// media/capture/mojom/image_capture.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_SHARED_H_
#define MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/image_capture.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class RangeDataView;

class PhotoStateDataView;

class Point2DDataView;

class PhotoSettingsDataView;

class BlobDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::RangeDataView> {
  using Data = ::media::mojom::internal::Range_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PhotoStateDataView> {
  using Data = ::media::mojom::internal::PhotoState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::Point2DDataView> {
  using Data = ::media::mojom::internal::Point2D_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::PhotoSettingsDataView> {
  using Data = ::media::mojom::internal::PhotoSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::BlobDataView> {
  using Data = ::media::mojom::internal::Blob_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


enum class BackgroundBlurMode : int32_t {
  
  OFF = 0,
  
  BLUR = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, BackgroundBlurMode value);
inline bool IsKnownEnumValue(BackgroundBlurMode value) {
  return internal::BackgroundBlurMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline BackgroundBlurMode ToKnownEnumValue(BackgroundBlurMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return BackgroundBlurMode::kDefaultValue;
}


enum class EyeGazeCorrectionMode : int32_t {
  
  OFF = 0,
  
  ON = 1,
  
  STARE = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, EyeGazeCorrectionMode value);
inline bool IsKnownEnumValue(EyeGazeCorrectionMode value) {
  return internal::EyeGazeCorrectionMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline EyeGazeCorrectionMode ToKnownEnumValue(EyeGazeCorrectionMode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return EyeGazeCorrectionMode::kDefaultValue;
}


enum class MeteringMode : int32_t {
  
  NONE = 0,
  
  MANUAL = 1,
  
  SINGLE_SHOT = 2,
  
  CONTINUOUS = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, MeteringMode value);
inline bool IsKnownEnumValue(MeteringMode value) {
  return internal::MeteringMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class RedEyeReduction : int32_t {
  
  NEVER = 0,
  
  ALWAYS = 1,
  
  CONTROLLABLE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, RedEyeReduction value);
inline bool IsKnownEnumValue(RedEyeReduction value) {
  return internal::RedEyeReduction_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class FillLightMode : int32_t {
  
  OFF = 0,
  
  AUTO = 1,
  
  FLASH = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, FillLightMode value);
inline bool IsKnownEnumValue(FillLightMode value) {
  return internal::FillLightMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ImageCaptureInterfaceBase {};

using ImageCapturePtrDataView =
    mojo::InterfacePtrDataView<ImageCaptureInterfaceBase>;
using ImageCaptureRequestDataView =
    mojo::InterfaceRequestDataView<ImageCaptureInterfaceBase>;
using ImageCaptureAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ImageCaptureInterfaceBase>;
using ImageCaptureAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ImageCaptureInterfaceBase>;


class RangeDataView {
 public:
  RangeDataView() = default;

  RangeDataView(
      internal::Range_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double max() const {
    return data_->max;
  }
  double min() const {
    return data_->min;
  }
  double current() const {
    return data_->current;
  }
  double step() const {
    return data_->step;
  }
 private:
  internal::Range_Data* data_ = nullptr;
};


class PhotoStateDataView {
 public:
  PhotoStateDataView() = default;

  PhotoStateDataView(
      internal::PhotoState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSupportedWhiteBalanceModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedWhiteBalanceModes(UserType* output) {
    
    auto* pointer = data_->supported_white_balance_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentWhiteBalanceMode(UserType* output) const {
    auto data_value = data_->current_white_balance_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_white_balance_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_white_balance_mode));
  }
  inline void GetSupportedExposureModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedExposureModes(UserType* output) {
    
    auto* pointer = data_->supported_exposure_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentExposureMode(UserType* output) const {
    auto data_value = data_->current_exposure_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_exposure_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_exposure_mode));
  }
  inline void GetSupportedFocusModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedFocusModes(UserType* output) {
    
    auto* pointer = data_->supported_focus_modes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentFocusMode(UserType* output) const {
    auto data_value = data_->current_focus_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_focus_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_focus_mode));
  }
  inline void GetPointsOfInterestDataView(
      mojo::ArrayDataView<Point2DDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointsOfInterest(UserType* output) {
    
    auto* pointer = data_->points_of_interest.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>>(
        pointer, output, message_);
  }
  inline void GetExposureCompensationDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExposureCompensation(UserType* output) {
    
    auto* pointer = data_->exposure_compensation.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetExposureTimeDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExposureTime(UserType* output) {
    
    auto* pointer = data_->exposure_time.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetColorTemperatureDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorTemperature(UserType* output) {
    
    auto* pointer = data_->color_temperature.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetIsoDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIso(UserType* output) {
    
    auto* pointer = data_->iso.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetBrightnessDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBrightness(UserType* output) {
    
    auto* pointer = data_->brightness.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetContrastDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContrast(UserType* output) {
    
    auto* pointer = data_->contrast.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetSaturationDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSaturation(UserType* output) {
    
    auto* pointer = data_->saturation.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetSharpnessDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharpness(UserType* output) {
    
    auto* pointer = data_->sharpness.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetFocusDistanceDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFocusDistance(UserType* output) {
    
    auto* pointer = data_->focus_distance.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetPanDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPan(UserType* output) {
    
    auto* pointer = data_->pan.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetTiltDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTilt(UserType* output) {
    
    auto* pointer = data_->tilt.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetZoomDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadZoom(UserType* output) {
    
    auto* pointer = data_->zoom.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  bool supports_torch() const {
    return data_->supports_torch;
  }
  bool torch() const {
    return data_->torch;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRedEyeReduction(UserType* output) const {
    auto data_value = data_->red_eye_reduction;
    return mojo::internal::Deserialize<::media::mojom::RedEyeReduction>(
        data_value, output);
  }
  RedEyeReduction red_eye_reduction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::RedEyeReduction>(data_->red_eye_reduction));
  }
  inline void GetHeightDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeight(UserType* output) {
    
    auto* pointer = data_->height.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetWidthDataView(
      RangeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWidth(UserType* output) {
    
    auto* pointer = data_->width.Get();
    return mojo::internal::Deserialize<::media::mojom::RangeDataView>(
        pointer, output, message_);
  }
  inline void GetFillLightModeDataView(
      mojo::ArrayDataView<FillLightMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFillLightMode(UserType* output) {
    
    auto* pointer = data_->fill_light_mode.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::FillLightMode>>(
        pointer, output, message_);
  }
  inline void GetSupportedBackgroundBlurModesDataView(
      mojo::ArrayDataView<BackgroundBlurMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedBackgroundBlurModes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media::mojom::BackgroundBlurMode>, UserType>(),
    "Attempting to read the optional `supported_background_blur_modes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupportedBackgroundBlurModes` instead "
    "of `ReadSupportedBackgroundBlurModes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->supported_background_blur_modes.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::BackgroundBlurMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundBlurMode(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->background_blur_mode : 0;
    return mojo::internal::Deserialize<::media::mojom::BackgroundBlurMode>(
        data_value, output);
  }
  BackgroundBlurMode background_blur_mode() const {
    if (data_->header_.version < 1)
      return BackgroundBlurMode{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::BackgroundBlurMode>(data_->background_blur_mode));
  }
  inline void GetSupportedFaceFramingModesDataView(
      mojo::ArrayDataView<MeteringMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedFaceFramingModes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media::mojom::MeteringMode>, UserType>(),
    "Attempting to read the optional `supported_face_framing_modes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupportedFaceFramingModes` instead "
    "of `ReadSupportedFaceFramingModes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->supported_face_framing_modes.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentFaceFramingMode(UserType* output) const {
    auto data_value = data_->header_.version >= 2
                      ? data_->current_face_framing_mode : 0;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode current_face_framing_mode() const {
    if (data_->header_.version < 2)
      return MeteringMode{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->current_face_framing_mode));
  }
  inline void GetSupportedEyeGazeCorrectionModesDataView(
      mojo::ArrayDataView<EyeGazeCorrectionMode>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedEyeGazeCorrectionModes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::media::mojom::EyeGazeCorrectionMode>, UserType>(),
    "Attempting to read the optional `supported_eye_gaze_correction_modes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupportedEyeGazeCorrectionModes` instead "
    "of `ReadSupportedEyeGazeCorrectionModes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->supported_eye_gaze_correction_modes.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::EyeGazeCorrectionMode>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCurrentEyeGazeCorrectionMode(UserType* output) const {
    auto data_value = data_->header_.version >= 3
                      ? data_->current_eye_gaze_correction_mode : 0;
    return mojo::internal::Deserialize<::media::mojom::EyeGazeCorrectionMode>(
        data_value, output);
  }
  EyeGazeCorrectionMode current_eye_gaze_correction_mode() const {
    if (data_->header_.version < 3)
      return EyeGazeCorrectionMode{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EyeGazeCorrectionMode>(data_->current_eye_gaze_correction_mode));
  }
  inline void GetSupportedBackgroundSegmentationMaskStatesDataView(
      mojo::ArrayDataView<bool>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSupportedBackgroundSegmentationMaskStates(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<bool>, UserType>(),
    "Attempting to read the optional `supported_background_segmentation_mask_states` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSupportedBackgroundSegmentationMaskStates` instead "
    "of `ReadSupportedBackgroundSegmentationMaskStates if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 4
                    ? data_->supported_background_segmentation_mask_states.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        pointer, output, message_);
  }
  bool current_background_segmentation_mask_state() const {
    if (data_->header_.version < 4)
      return bool{};
    return data_->current_background_segmentation_mask_state;
  }
 private:
  internal::PhotoState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class Point2DDataView {
 public:
  Point2DDataView() = default;

  Point2DDataView(
      internal::Point2D_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double x() const {
    return data_->x;
  }
  double y() const {
    return data_->y;
  }
 private:
  internal::Point2D_Data* data_ = nullptr;
};


class PhotoSettingsDataView {
 public:
  PhotoSettingsDataView() = default;

  PhotoSettingsDataView(
      internal::PhotoSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool has_white_balance_mode() const {
    return data_->has_white_balance_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadWhiteBalanceMode(UserType* output) const {
    auto data_value = data_->white_balance_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode white_balance_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->white_balance_mode));
  }
  bool has_exposure_mode() const {
    return data_->has_exposure_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadExposureMode(UserType* output) const {
    auto data_value = data_->exposure_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode exposure_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->exposure_mode));
  }
  bool has_focus_mode() const {
    return data_->has_focus_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFocusMode(UserType* output) const {
    auto data_value = data_->focus_mode;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode focus_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->focus_mode));
  }
  inline void GetPointsOfInterestDataView(
      mojo::ArrayDataView<Point2DDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPointsOfInterest(UserType* output) {
    
    auto* pointer = data_->points_of_interest.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>>(
        pointer, output, message_);
  }
  bool has_exposure_compensation() const {
    return data_->has_exposure_compensation;
  }
  double exposure_compensation() const {
    return data_->exposure_compensation;
  }
  bool has_exposure_time() const {
    return data_->has_exposure_time;
  }
  double exposure_time() const {
    return data_->exposure_time;
  }
  bool has_color_temperature() const {
    return data_->has_color_temperature;
  }
  double color_temperature() const {
    return data_->color_temperature;
  }
  bool has_iso() const {
    return data_->has_iso;
  }
  double iso() const {
    return data_->iso;
  }
  bool has_brightness() const {
    return data_->has_brightness;
  }
  double brightness() const {
    return data_->brightness;
  }
  bool has_contrast() const {
    return data_->has_contrast;
  }
  double contrast() const {
    return data_->contrast;
  }
  bool has_saturation() const {
    return data_->has_saturation;
  }
  double saturation() const {
    return data_->saturation;
  }
  bool has_sharpness() const {
    return data_->has_sharpness;
  }
  double sharpness() const {
    return data_->sharpness;
  }
  bool has_focus_distance() const {
    return data_->has_focus_distance;
  }
  double focus_distance() const {
    return data_->focus_distance;
  }
  bool has_pan() const {
    return data_->has_pan;
  }
  double pan() const {
    return data_->pan;
  }
  bool has_tilt() const {
    return data_->has_tilt;
  }
  double tilt() const {
    return data_->tilt;
  }
  bool has_zoom() const {
    return data_->has_zoom;
  }
  double zoom() const {
    return data_->zoom;
  }
  bool has_torch() const {
    return data_->has_torch;
  }
  bool torch() const {
    return data_->torch;
  }
  bool has_fill_light_mode() const {
    return data_->has_fill_light_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFillLightMode(UserType* output) const {
    auto data_value = data_->fill_light_mode;
    return mojo::internal::Deserialize<::media::mojom::FillLightMode>(
        data_value, output);
  }
  FillLightMode fill_light_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::FillLightMode>(data_->fill_light_mode));
  }
  bool has_width() const {
    return data_->has_width;
  }
  double width() const {
    return data_->width;
  }
  bool has_height() const {
    return data_->has_height;
  }
  double height() const {
    return data_->height;
  }
  bool has_red_eye_reduction() const {
    return data_->has_red_eye_reduction;
  }
  bool red_eye_reduction() const {
    return data_->red_eye_reduction;
  }
  bool has_background_blur_mode() const {
    if (data_->header_.version < 1)
      return bool{};
    return data_->has_background_blur_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundBlurMode(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->background_blur_mode : 0;
    return mojo::internal::Deserialize<::media::mojom::BackgroundBlurMode>(
        data_value, output);
  }
  BackgroundBlurMode background_blur_mode() const {
    if (data_->header_.version < 1)
      return BackgroundBlurMode{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::BackgroundBlurMode>(data_->background_blur_mode));
  }
  bool has_face_framing_mode() const {
    if (data_->header_.version < 2)
      return bool{};
    return data_->has_face_framing_mode;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFaceFramingMode(UserType* output) const {
    auto data_value = data_->header_.version >= 2
                      ? data_->face_framing_mode : 0;
    return mojo::internal::Deserialize<::media::mojom::MeteringMode>(
        data_value, output);
  }
  MeteringMode face_framing_mode() const {
    if (data_->header_.version < 2)
      return MeteringMode{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::MeteringMode>(data_->face_framing_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadEyeGazeCorrectionMode(UserType* output) const {
    if (data_->header_.version < 3) {
      *output = std::nullopt;
      return true;
    }
    if (!data_->eye_gaze_correction_mode_$flag) {
      *output = std::nullopt;
      return true;
    }

    return mojo::internal::Deserialize<::media::mojom::EyeGazeCorrectionMode>(
        data_->eye_gaze_correction_mode_$value, &output->emplace());
  }
  std::optional<EyeGazeCorrectionMode> eye_gaze_correction_mode() const {
    if (data_->header_.version < 3) {
      return std::nullopt;
    }
    if (!data_->eye_gaze_correction_mode_$flag) {
      return std::nullopt;
    }
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::EyeGazeCorrectionMode>(data_->eye_gaze_correction_mode_$value));
  }
  std::optional<bool> background_segmentation_mask_state() const {
    if (data_->header_.version < 4) {
      return std::nullopt;
    }

    return data_->background_segmentation_mask_state_$flag
        ? std::make_optional(!!data_->background_segmentation_mask_state_$value)
        : std::nullopt;
  }
 private:
  internal::PhotoSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlobDataView {
 public:
  BlobDataView() = default;

  BlobDataView(
      internal::Blob_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::Blob_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

template <>
struct hash<::media::mojom::BackgroundBlurMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::BackgroundBlurMode> {};

template <>
struct hash<::media::mojom::EyeGazeCorrectionMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::EyeGazeCorrectionMode> {};

template <>
struct hash<::media::mojom::MeteringMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::MeteringMode> {};

template <>
struct hash<::media::mojom::RedEyeReduction>
    : public mojo::internal::EnumHashImpl<::media::mojom::RedEyeReduction> {};

template <>
struct hash<::media::mojom::FillLightMode>
    : public mojo::internal::EnumHashImpl<::media::mojom::FillLightMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::BackgroundBlurMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::BackgroundBlurMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::BackgroundBlurMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::EyeGazeCorrectionMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::EyeGazeCorrectionMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::EyeGazeCorrectionMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::MeteringMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::MeteringMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::MeteringMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RedEyeReduction, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::RedEyeReduction, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::RedEyeReduction>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::FillLightMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media::mojom::FillLightMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media::mojom::FillLightMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::RangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::RangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Range_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->max = Traits::max(input);
    fragment->min = Traits::min(input);
    fragment->current = Traits::current(input);
    fragment->step = Traits::step(input);
  }

  static bool Deserialize(::media::mojom::internal::Range_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::RangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PhotoStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PhotoStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PhotoState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::supported_white_balance_modes(input)) in_supported_white_balance_modes = Traits::supported_white_balance_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_white_balance_modes)::BaseType>
        supported_white_balance_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_white_balance_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        in_supported_white_balance_modes, supported_white_balance_modes_fragment, &supported_white_balance_modes_validate_params);
    fragment->supported_white_balance_modes.Set(
        supported_white_balance_modes_fragment.is_null() ? nullptr : supported_white_balance_modes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->supported_white_balance_modes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_white_balance_modes in PhotoState struct");
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_white_balance_mode(input), &fragment->current_white_balance_mode);
    decltype(Traits::supported_exposure_modes(input)) in_supported_exposure_modes = Traits::supported_exposure_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_exposure_modes)::BaseType>
        supported_exposure_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_exposure_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        in_supported_exposure_modes, supported_exposure_modes_fragment, &supported_exposure_modes_validate_params);
    fragment->supported_exposure_modes.Set(
        supported_exposure_modes_fragment.is_null() ? nullptr : supported_exposure_modes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->supported_exposure_modes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_exposure_modes in PhotoState struct");
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_exposure_mode(input), &fragment->current_exposure_mode);
    decltype(Traits::supported_focus_modes(input)) in_supported_focus_modes = Traits::supported_focus_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_focus_modes)::BaseType>
        supported_focus_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_focus_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        in_supported_focus_modes, supported_focus_modes_fragment, &supported_focus_modes_validate_params);
    fragment->supported_focus_modes.Set(
        supported_focus_modes_fragment.is_null() ? nullptr : supported_focus_modes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->supported_focus_modes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null supported_focus_modes in PhotoState struct");
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_focus_mode(input), &fragment->current_focus_mode);
    decltype(Traits::points_of_interest(input)) in_points_of_interest = Traits::points_of_interest(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->points_of_interest)::BaseType>
        points_of_interest_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& points_of_interest_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>>(
        in_points_of_interest, points_of_interest_fragment, &points_of_interest_validate_params);
    fragment->points_of_interest.Set(
        points_of_interest_fragment.is_null() ? nullptr : points_of_interest_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->points_of_interest.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null points_of_interest in PhotoState struct");
    decltype(Traits::exposure_compensation(input)) in_exposure_compensation = Traits::exposure_compensation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exposure_compensation)::BaseType> exposure_compensation_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_exposure_compensation, exposure_compensation_fragment);
    fragment->exposure_compensation.Set(
        exposure_compensation_fragment.is_null() ? nullptr : exposure_compensation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->exposure_compensation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exposure_compensation in PhotoState struct");
    decltype(Traits::exposure_time(input)) in_exposure_time = Traits::exposure_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->exposure_time)::BaseType> exposure_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_exposure_time, exposure_time_fragment);
    fragment->exposure_time.Set(
        exposure_time_fragment.is_null() ? nullptr : exposure_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->exposure_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null exposure_time in PhotoState struct");
    decltype(Traits::color_temperature(input)) in_color_temperature = Traits::color_temperature(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_temperature)::BaseType> color_temperature_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_color_temperature, color_temperature_fragment);
    fragment->color_temperature.Set(
        color_temperature_fragment.is_null() ? nullptr : color_temperature_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_temperature.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_temperature in PhotoState struct");
    decltype(Traits::iso(input)) in_iso = Traits::iso(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->iso)::BaseType> iso_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_iso, iso_fragment);
    fragment->iso.Set(
        iso_fragment.is_null() ? nullptr : iso_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->iso.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null iso in PhotoState struct");
    decltype(Traits::brightness(input)) in_brightness = Traits::brightness(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->brightness)::BaseType> brightness_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_brightness, brightness_fragment);
    fragment->brightness.Set(
        brightness_fragment.is_null() ? nullptr : brightness_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->brightness.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null brightness in PhotoState struct");
    decltype(Traits::contrast(input)) in_contrast = Traits::contrast(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contrast)::BaseType> contrast_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_contrast, contrast_fragment);
    fragment->contrast.Set(
        contrast_fragment.is_null() ? nullptr : contrast_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->contrast.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contrast in PhotoState struct");
    decltype(Traits::saturation(input)) in_saturation = Traits::saturation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->saturation)::BaseType> saturation_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_saturation, saturation_fragment);
    fragment->saturation.Set(
        saturation_fragment.is_null() ? nullptr : saturation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->saturation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null saturation in PhotoState struct");
    decltype(Traits::sharpness(input)) in_sharpness = Traits::sharpness(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sharpness)::BaseType> sharpness_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_sharpness, sharpness_fragment);
    fragment->sharpness.Set(
        sharpness_fragment.is_null() ? nullptr : sharpness_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sharpness.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sharpness in PhotoState struct");
    decltype(Traits::focus_distance(input)) in_focus_distance = Traits::focus_distance(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->focus_distance)::BaseType> focus_distance_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_focus_distance, focus_distance_fragment);
    fragment->focus_distance.Set(
        focus_distance_fragment.is_null() ? nullptr : focus_distance_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->focus_distance.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null focus_distance in PhotoState struct");
    decltype(Traits::pan(input)) in_pan = Traits::pan(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->pan)::BaseType> pan_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_pan, pan_fragment);
    fragment->pan.Set(
        pan_fragment.is_null() ? nullptr : pan_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->pan.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pan in PhotoState struct");
    decltype(Traits::tilt(input)) in_tilt = Traits::tilt(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tilt)::BaseType> tilt_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_tilt, tilt_fragment);
    fragment->tilt.Set(
        tilt_fragment.is_null() ? nullptr : tilt_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->tilt.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null tilt in PhotoState struct");
    decltype(Traits::zoom(input)) in_zoom = Traits::zoom(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->zoom)::BaseType> zoom_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_zoom, zoom_fragment);
    fragment->zoom.Set(
        zoom_fragment.is_null() ? nullptr : zoom_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->zoom.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null zoom in PhotoState struct");
    fragment->supports_torch = Traits::supports_torch(input);
    fragment->torch = Traits::torch(input);
    mojo::internal::Serialize<::media::mojom::RedEyeReduction>(
        Traits::red_eye_reduction(input), &fragment->red_eye_reduction);
    decltype(Traits::height(input)) in_height = Traits::height(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->height)::BaseType> height_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_height, height_fragment);
    fragment->height.Set(
        height_fragment.is_null() ? nullptr : height_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->height.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null height in PhotoState struct");
    decltype(Traits::width(input)) in_width = Traits::width(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->width)::BaseType> width_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::RangeDataView>(
        in_width, width_fragment);
    fragment->width.Set(
        width_fragment.is_null() ? nullptr : width_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->width.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null width in PhotoState struct");
    decltype(Traits::fill_light_mode(input)) in_fill_light_mode = Traits::fill_light_mode(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fill_light_mode)::BaseType>
        fill_light_mode_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& fill_light_mode_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::FillLightMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::FillLightMode>>(
        in_fill_light_mode, fill_light_mode_fragment, &fill_light_mode_validate_params);
    fragment->fill_light_mode.Set(
        fill_light_mode_fragment.is_null() ? nullptr : fill_light_mode_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->fill_light_mode.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fill_light_mode in PhotoState struct");
    decltype(Traits::supported_background_blur_modes(input)) in_supported_background_blur_modes = Traits::supported_background_blur_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_background_blur_modes)::BaseType>
        supported_background_blur_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_background_blur_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::BackgroundBlurMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::BackgroundBlurMode>>(
        in_supported_background_blur_modes, supported_background_blur_modes_fragment, &supported_background_blur_modes_validate_params);
    fragment->supported_background_blur_modes.Set(
        supported_background_blur_modes_fragment.is_null() ? nullptr : supported_background_blur_modes_fragment.data());
    mojo::internal::Serialize<::media::mojom::BackgroundBlurMode>(
        Traits::background_blur_mode(input), &fragment->background_blur_mode);
    decltype(Traits::supported_face_framing_modes(input)) in_supported_face_framing_modes = Traits::supported_face_framing_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_face_framing_modes)::BaseType>
        supported_face_framing_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_face_framing_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::MeteringMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::MeteringMode>>(
        in_supported_face_framing_modes, supported_face_framing_modes_fragment, &supported_face_framing_modes_validate_params);
    fragment->supported_face_framing_modes.Set(
        supported_face_framing_modes_fragment.is_null() ? nullptr : supported_face_framing_modes_fragment.data());
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::current_face_framing_mode(input), &fragment->current_face_framing_mode);
    decltype(Traits::supported_eye_gaze_correction_modes(input)) in_supported_eye_gaze_correction_modes = Traits::supported_eye_gaze_correction_modes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_eye_gaze_correction_modes)::BaseType>
        supported_eye_gaze_correction_modes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_eye_gaze_correction_modes_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::media::mojom::internal::EyeGazeCorrectionMode_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::EyeGazeCorrectionMode>>(
        in_supported_eye_gaze_correction_modes, supported_eye_gaze_correction_modes_fragment, &supported_eye_gaze_correction_modes_validate_params);
    fragment->supported_eye_gaze_correction_modes.Set(
        supported_eye_gaze_correction_modes_fragment.is_null() ? nullptr : supported_eye_gaze_correction_modes_fragment.data());
    mojo::internal::Serialize<::media::mojom::EyeGazeCorrectionMode>(
        Traits::current_eye_gaze_correction_mode(input), &fragment->current_eye_gaze_correction_mode);
    decltype(Traits::supported_background_segmentation_mask_states(input)) in_supported_background_segmentation_mask_states = Traits::supported_background_segmentation_mask_states(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_background_segmentation_mask_states)::BaseType>
        supported_background_segmentation_mask_states_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_background_segmentation_mask_states_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<bool>>(
        in_supported_background_segmentation_mask_states, supported_background_segmentation_mask_states_fragment, &supported_background_segmentation_mask_states_validate_params);
    fragment->supported_background_segmentation_mask_states.Set(
        supported_background_segmentation_mask_states_fragment.is_null() ? nullptr : supported_background_segmentation_mask_states_fragment.data());
    fragment->current_background_segmentation_mask_state = Traits::current_background_segmentation_mask_state(input);
  }

  static bool Deserialize(::media::mojom::internal::PhotoState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PhotoStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::Point2DDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::Point2DDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Point2D_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->x = Traits::x(input);
    fragment->y = Traits::y(input);
  }

  static bool Deserialize(::media::mojom::internal::Point2D_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::Point2DDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::PhotoSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::PhotoSettingsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::PhotoSettings_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->has_white_balance_mode = Traits::has_white_balance_mode(input);
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::white_balance_mode(input), &fragment->white_balance_mode);
    fragment->has_exposure_mode = Traits::has_exposure_mode(input);
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::exposure_mode(input), &fragment->exposure_mode);
    fragment->has_focus_mode = Traits::has_focus_mode(input);
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::focus_mode(input), &fragment->focus_mode);
    decltype(Traits::points_of_interest(input)) in_points_of_interest = Traits::points_of_interest(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->points_of_interest)::BaseType>
        points_of_interest_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& points_of_interest_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::Point2DDataView>>(
        in_points_of_interest, points_of_interest_fragment, &points_of_interest_validate_params);
    fragment->points_of_interest.Set(
        points_of_interest_fragment.is_null() ? nullptr : points_of_interest_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->points_of_interest.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null points_of_interest in PhotoSettings struct");
    fragment->has_exposure_compensation = Traits::has_exposure_compensation(input);
    fragment->exposure_compensation = Traits::exposure_compensation(input);
    fragment->has_exposure_time = Traits::has_exposure_time(input);
    fragment->exposure_time = Traits::exposure_time(input);
    fragment->has_color_temperature = Traits::has_color_temperature(input);
    fragment->color_temperature = Traits::color_temperature(input);
    fragment->has_iso = Traits::has_iso(input);
    fragment->iso = Traits::iso(input);
    fragment->has_brightness = Traits::has_brightness(input);
    fragment->brightness = Traits::brightness(input);
    fragment->has_contrast = Traits::has_contrast(input);
    fragment->contrast = Traits::contrast(input);
    fragment->has_saturation = Traits::has_saturation(input);
    fragment->saturation = Traits::saturation(input);
    fragment->has_sharpness = Traits::has_sharpness(input);
    fragment->sharpness = Traits::sharpness(input);
    fragment->has_focus_distance = Traits::has_focus_distance(input);
    fragment->focus_distance = Traits::focus_distance(input);
    fragment->has_pan = Traits::has_pan(input);
    fragment->pan = Traits::pan(input);
    fragment->has_tilt = Traits::has_tilt(input);
    fragment->tilt = Traits::tilt(input);
    fragment->has_zoom = Traits::has_zoom(input);
    fragment->zoom = Traits::zoom(input);
    fragment->has_torch = Traits::has_torch(input);
    fragment->torch = Traits::torch(input);
    fragment->has_fill_light_mode = Traits::has_fill_light_mode(input);
    mojo::internal::Serialize<::media::mojom::FillLightMode>(
        Traits::fill_light_mode(input), &fragment->fill_light_mode);
    fragment->has_width = Traits::has_width(input);
    fragment->width = Traits::width(input);
    fragment->has_height = Traits::has_height(input);
    fragment->height = Traits::height(input);
    fragment->has_red_eye_reduction = Traits::has_red_eye_reduction(input);
    fragment->red_eye_reduction = Traits::red_eye_reduction(input);
    fragment->has_background_blur_mode = Traits::has_background_blur_mode(input);
    mojo::internal::Serialize<::media::mojom::BackgroundBlurMode>(
        Traits::background_blur_mode(input), &fragment->background_blur_mode);
    fragment->has_face_framing_mode = Traits::has_face_framing_mode(input);
    mojo::internal::Serialize<::media::mojom::MeteringMode>(
        Traits::face_framing_mode(input), &fragment->face_framing_mode);
    fragment->eye_gaze_correction_mode_$flag = Traits::eye_gaze_correction_mode(input).has_value();
    if (Traits::eye_gaze_correction_mode(input).has_value()) {
      mojo::internal::Serialize<::media::mojom::EyeGazeCorrectionMode>(
          Traits::eye_gaze_correction_mode(input).value(), &fragment->eye_gaze_correction_mode_$value);
    } else {
      fragment->eye_gaze_correction_mode_$value =
          static_cast<int32_t>(::media::mojom::EyeGazeCorrectionMode::kMinValue);
    }
    fragment->background_segmentation_mask_state_$flag = Traits::background_segmentation_mask_state(input).has_value();
    if (Traits::background_segmentation_mask_state(input).has_value()) {
      fragment->background_segmentation_mask_state_$value = Traits::background_segmentation_mask_state(input).value();
    }
  }

  static bool Deserialize(::media::mojom::internal::PhotoSettings_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::PhotoSettingsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::BlobDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::BlobDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::Blob_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, mime_type_fragment);
    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mime_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in Blob struct");
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_data, data_fragment, &data_validate_params);
    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in Blob struct");
  }

  static bool Deserialize(::media::mojom::internal::Blob_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::BlobDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {



inline void PhotoStateDataView::GetSupportedWhiteBalanceModesDataView(
    mojo::ArrayDataView<MeteringMode>* output) {
  auto pointer = data_->supported_white_balance_modes.Get();
  *output = mojo::ArrayDataView<MeteringMode>(pointer, message_);
}
inline void PhotoStateDataView::GetSupportedExposureModesDataView(
    mojo::ArrayDataView<MeteringMode>* output) {
  auto pointer = data_->supported_exposure_modes.Get();
  *output = mojo::ArrayDataView<MeteringMode>(pointer, message_);
}
inline void PhotoStateDataView::GetSupportedFocusModesDataView(
    mojo::ArrayDataView<MeteringMode>* output) {
  auto pointer = data_->supported_focus_modes.Get();
  *output = mojo::ArrayDataView<MeteringMode>(pointer, message_);
}
inline void PhotoStateDataView::GetPointsOfInterestDataView(
    mojo::ArrayDataView<Point2DDataView>* output) {
  auto pointer = data_->points_of_interest.Get();
  *output = mojo::ArrayDataView<Point2DDataView>(pointer, message_);
}
inline void PhotoStateDataView::GetExposureCompensationDataView(
    RangeDataView* output) {
  auto pointer = data_->exposure_compensation.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetExposureTimeDataView(
    RangeDataView* output) {
  auto pointer = data_->exposure_time.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetColorTemperatureDataView(
    RangeDataView* output) {
  auto pointer = data_->color_temperature.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetIsoDataView(
    RangeDataView* output) {
  auto pointer = data_->iso.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetBrightnessDataView(
    RangeDataView* output) {
  auto pointer = data_->brightness.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetContrastDataView(
    RangeDataView* output) {
  auto pointer = data_->contrast.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetSaturationDataView(
    RangeDataView* output) {
  auto pointer = data_->saturation.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetSharpnessDataView(
    RangeDataView* output) {
  auto pointer = data_->sharpness.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetFocusDistanceDataView(
    RangeDataView* output) {
  auto pointer = data_->focus_distance.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetPanDataView(
    RangeDataView* output) {
  auto pointer = data_->pan.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetTiltDataView(
    RangeDataView* output) {
  auto pointer = data_->tilt.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetZoomDataView(
    RangeDataView* output) {
  auto pointer = data_->zoom.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetHeightDataView(
    RangeDataView* output) {
  auto pointer = data_->height.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetWidthDataView(
    RangeDataView* output) {
  auto pointer = data_->width.Get();
  *output = RangeDataView(pointer, message_);
}
inline void PhotoStateDataView::GetFillLightModeDataView(
    mojo::ArrayDataView<FillLightMode>* output) {
  auto pointer = data_->fill_light_mode.Get();
  *output = mojo::ArrayDataView<FillLightMode>(pointer, message_);
}
inline void PhotoStateDataView::GetSupportedBackgroundBlurModesDataView(
    mojo::ArrayDataView<BackgroundBlurMode>* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->supported_background_blur_modes.Get() : nullptr;
  *output = mojo::ArrayDataView<BackgroundBlurMode>(pointer, message_);
}
inline void PhotoStateDataView::GetSupportedFaceFramingModesDataView(
    mojo::ArrayDataView<MeteringMode>* output) {
  auto pointer = data_->header_.version >= 2
                 ? data_->supported_face_framing_modes.Get() : nullptr;
  *output = mojo::ArrayDataView<MeteringMode>(pointer, message_);
}
inline void PhotoStateDataView::GetSupportedEyeGazeCorrectionModesDataView(
    mojo::ArrayDataView<EyeGazeCorrectionMode>* output) {
  auto pointer = data_->header_.version >= 3
                 ? data_->supported_eye_gaze_correction_modes.Get() : nullptr;
  *output = mojo::ArrayDataView<EyeGazeCorrectionMode>(pointer, message_);
}
inline void PhotoStateDataView::GetSupportedBackgroundSegmentationMaskStatesDataView(
    mojo::ArrayDataView<bool>* output) {
  auto pointer = data_->header_.version >= 4
                 ? data_->supported_background_segmentation_mask_states.Get() : nullptr;
  *output = mojo::ArrayDataView<bool>(pointer, message_);
}




inline void PhotoSettingsDataView::GetPointsOfInterestDataView(
    mojo::ArrayDataView<Point2DDataView>* output) {
  auto pointer = data_->points_of_interest.Get();
  *output = mojo::ArrayDataView<Point2DDataView>(pointer, message_);
}


inline void BlobDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void BlobDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::BackgroundBlurMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::BackgroundBlurMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::EyeGazeCorrectionMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::EyeGazeCorrectionMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::MeteringMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::MeteringMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::RedEyeReduction> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::RedEyeReduction value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media::mojom::FillLightMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media::mojom::FillLightMode value);
};

} // namespace perfetto

#endif  // MEDIA_CAPTURE_MOJOM_IMAGE_CAPTURE_MOJOM_SHARED_H_