// media/mojo/mojom/stable/stable_video_decoder_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-params-data.h"
#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-shared-message-ids.h"

#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-import-headers.h"
#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-test-utils.h"


namespace media::stable::mojom {
SubsampleEntry::SubsampleEntry()
    : clear_bytes(),
      cypher_bytes() {}

SubsampleEntry::SubsampleEntry(
    uint32_t clear_bytes_in,
    uint32_t cypher_bytes_in)
    : clear_bytes(std::move(clear_bytes_in)),
      cypher_bytes(std::move(cypher_bytes_in)) {}

SubsampleEntry::~SubsampleEntry() = default;

void SubsampleEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clear_bytes"), this->clear_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cypher_bytes"), this->cypher_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubsampleEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecryptConfig::DecryptConfig()
    : encryption_scheme(),
      key_id(),
      iv(),
      subsamples(),
      encryption_pattern() {}

DecryptConfig::DecryptConfig(
    ::media::EncryptionScheme encryption_scheme_in,
    const std::string& key_id_in,
    const std::string& iv_in,
    std::vector<::media::SubsampleEntry> subsamples_in,
    const std::optional<::media::EncryptionPattern>& encryption_pattern_in)
    : encryption_scheme(std::move(encryption_scheme_in)),
      key_id(std::move(key_id_in)),
      iv(std::move(iv_in)),
      subsamples(std::move(subsamples_in)),
      encryption_pattern(std::move(encryption_pattern_in)) {}

DecryptConfig::~DecryptConfig() = default;

void DecryptConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "key_id"), this->key_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iv"), this->iv,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "subsamples"), this->subsamples,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::media::SubsampleEntry>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_pattern"), this->encryption_pattern,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::EncryptionPattern>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecryptConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ColorVolumeMetadata::ColorVolumeMetadata()
    : primary_r(),
      primary_g(),
      primary_b(),
      white_point(),
      luminance_max(),
      luminance_min() {}

ColorVolumeMetadata::ColorVolumeMetadata(
    const ::gfx::PointF& primary_r_in,
    const ::gfx::PointF& primary_g_in,
    const ::gfx::PointF& primary_b_in,
    const ::gfx::PointF& white_point_in,
    float luminance_max_in,
    float luminance_min_in)
    : primary_r(std::move(primary_r_in)),
      primary_g(std::move(primary_g_in)),
      primary_b(std::move(primary_b_in)),
      white_point(std::move(white_point_in)),
      luminance_max(std::move(luminance_max_in)),
      luminance_min(std::move(luminance_min_in)) {}

ColorVolumeMetadata::~ColorVolumeMetadata() = default;

void ColorVolumeMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_r"), this->primary_r,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_g"), this->primary_g,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_b"), this->primary_b,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "white_point"), this->white_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::PointF&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "luminance_max"), this->luminance_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "luminance_min"), this->luminance_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorVolumeMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HDRMetadata::HDRMetadata()
    : color_volume_metadata(),
      max_content_light_level(),
      max_frame_average_light_level() {}

HDRMetadata::HDRMetadata(
    const ::gfx::HdrMetadataSmpteSt2086& color_volume_metadata_in,
    uint32_t max_content_light_level_in,
    uint32_t max_frame_average_light_level_in)
    : color_volume_metadata(std::move(color_volume_metadata_in)),
      max_content_light_level(std::move(max_content_light_level_in)),
      max_frame_average_light_level(std::move(max_frame_average_light_level_in)) {}

HDRMetadata::~HDRMetadata() = default;

void HDRMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_volume_metadata"), this->color_volume_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::HdrMetadataSmpteSt2086&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_content_light_level"), this->max_content_light_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_frame_average_light_level"), this->max_frame_average_light_level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HDRMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoDecoderConfig::VideoDecoderConfig()
    : codec(),
      profile(),
      level(),
      has_alpha(),
      coded_size(),
      visible_rect(),
      natural_size(),
      extra_data(),
      encryption_scheme(),
      color_space_info(),
      hdr_metadata() {}

VideoDecoderConfig::VideoDecoderConfig(
    ::media::VideoCodec codec_in,
    ::media::VideoCodecProfile profile_in,
    uint32_t level_in,
    bool has_alpha_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    std::vector<uint8_t> extra_data_in,
    ::media::EncryptionScheme encryption_scheme_in,
    const ::gfx::ColorSpace& color_space_info_in,
    const std::optional<::gfx::HDRMetadata>& hdr_metadata_in)
    : codec(std::move(codec_in)),
      profile(std::move(profile_in)),
      level(std::move(level_in)),
      has_alpha(std::move(has_alpha_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      extra_data(std::move(extra_data_in)),
      encryption_scheme(std::move(encryption_scheme_in)),
      color_space_info(std::move(color_space_info_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoDecoderConfig::~VideoDecoderConfig() = default;

void VideoDecoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "codec"), this->codec,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodec>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile"), this->profile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "level"), this->level,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_alpha"), this->has_alpha,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extra_data"), this->extra_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encryption_scheme"), this->encryption_scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::EncryptionScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space_info"), this->color_space_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::HDRMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SupportedVideoDecoderConfig::SupportedVideoDecoderConfig()
    : profile_min(),
      profile_max(),
      coded_size_min(),
      coded_size_max(),
      allow_encrypted(),
      require_encrypted() {}

SupportedVideoDecoderConfig::SupportedVideoDecoderConfig(
    ::media::VideoCodecProfile profile_min_in,
    ::media::VideoCodecProfile profile_max_in,
    const ::gfx::Size& coded_size_min_in,
    const ::gfx::Size& coded_size_max_in,
    bool allow_encrypted_in,
    bool require_encrypted_in)
    : profile_min(std::move(profile_min_in)),
      profile_max(std::move(profile_max_in)),
      coded_size_min(std::move(coded_size_min_in)),
      coded_size_max(std::move(coded_size_max_in)),
      allow_encrypted(std::move(allow_encrypted_in)),
      require_encrypted(std::move(require_encrypted_in)) {}

SupportedVideoDecoderConfig::~SupportedVideoDecoderConfig() = default;

void SupportedVideoDecoderConfig::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_min"), this->profile_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "profile_max"), this->profile_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoCodecProfile>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size_min"), this->coded_size_min,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size_max"), this->coded_size_max,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_encrypted"), this->allow_encrypted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "require_encrypted"), this->require_encrypted,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupportedVideoDecoderConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StatusData::StatusData()
    : group(),
      code(),
      message(),
      frames(),
      cause(),
      data() {}

StatusData::StatusData(
    const std::string& group_in,
    StatusCode code_in,
    const std::string& message_in,
    std::vector<::base::Value> frames_in,
    const std::optional<::media::internal::StatusData>& cause_in,
    ::base::Value data_in)
    : group(std::move(group_in)),
      code(std::move(code_in)),
      message(std::move(message_in)),
      frames(std::move(frames_in)),
      cause(std::move(cause_in)),
      data(std::move(data_in)) {}

StatusData::~StatusData() = default;

void StatusData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group"), this->group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type StatusCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frames"), this->frames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<::base::Value>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cause"), this->cause,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::internal::StatusData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StatusData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Status::Status()
    : internal() {}

Status::Status(
    const std::optional<::media::internal::StatusData>& internal_in)
    : internal(std::move(internal_in)) {}

Status::~Status() = default;

void Status::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "internal"), this->internal,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::media::internal::StatusData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Status::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecoderBufferSideData::DecoderBufferSideData()
    : spatial_layers(),
      alpha_data(),
      secure_handle() {}

DecoderBufferSideData::DecoderBufferSideData(
    std::vector<uint32_t> spatial_layers_in,
    std::vector<uint8_t> alpha_data_in,
    uint64_t secure_handle_in)
    : spatial_layers(std::move(spatial_layers_in)),
      alpha_data(std::move(alpha_data_in)),
      secure_handle(std::move(secure_handle_in)) {}

DecoderBufferSideData::~DecoderBufferSideData() = default;

void DecoderBufferSideData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "spatial_layers"), this->spatial_layers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alpha_data"), this->alpha_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "secure_handle"), this->secure_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecoderBufferSideData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DecoderBuffer::DecoderBuffer()
    : timestamp(),
      duration(),
      is_end_of_stream(),
      data_size(),
      is_key_frame(),
      raw_side_data(),
      decrypt_config(),
      front_discard(),
      back_discard(),
      side_data() {}

DecoderBuffer::DecoderBuffer(
    ::base::TimeDelta timestamp_in,
    ::base::TimeDelta duration_in,
    bool is_end_of_stream_in,
    uint32_t data_size_in,
    bool is_key_frame_in,
    std::vector<uint8_t> raw_side_data_in,
    ::std::unique_ptr<::media::DecryptConfig> decrypt_config_in,
    ::base::TimeDelta front_discard_in,
    ::base::TimeDelta back_discard_in)
    : timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)),
      is_end_of_stream(std::move(is_end_of_stream_in)),
      data_size(std::move(data_size_in)),
      is_key_frame(std::move(is_key_frame_in)),
      raw_side_data(std::move(raw_side_data_in)),
      decrypt_config(std::move(decrypt_config_in)),
      front_discard(std::move(front_discard_in)),
      back_discard(std::move(back_discard_in)),
      side_data() {}

DecoderBuffer::DecoderBuffer(
    ::base::TimeDelta timestamp_in,
    ::base::TimeDelta duration_in,
    bool is_end_of_stream_in,
    uint32_t data_size_in,
    bool is_key_frame_in,
    std::vector<uint8_t> raw_side_data_in,
    ::std::unique_ptr<::media::DecryptConfig> decrypt_config_in,
    ::base::TimeDelta front_discard_in,
    ::base::TimeDelta back_discard_in,
    DecoderBufferSideDataPtr side_data_in)
    : timestamp(std::move(timestamp_in)),
      duration(std::move(duration_in)),
      is_end_of_stream(std::move(is_end_of_stream_in)),
      data_size(std::move(data_size_in)),
      is_key_frame(std::move(is_key_frame_in)),
      raw_side_data(std::move(raw_side_data_in)),
      decrypt_config(std::move(decrypt_config_in)),
      front_discard(std::move(front_discard_in)),
      back_discard(std::move(back_discard_in)),
      side_data(std::move(side_data_in)) {}

DecoderBuffer::~DecoderBuffer() = default;

void DecoderBuffer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_end_of_stream"), this->is_end_of_stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data_size"), this->data_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_key_frame"), this->is_key_frame,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_side_data"), this->raw_side_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "decrypt_config"), this->decrypt_config,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::std::unique_ptr<::media::DecryptConfig>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "front_discard"), this->front_discard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "back_discard"), this->back_discard,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "side_data"), this->side_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DecoderBufferSideDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DecoderBuffer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ColorSpace::ColorSpace()
    : primaries(),
      transfer(),
      matrix(),
      range(),
      custom_primary_matrix(),
      transfer_params() {}

ColorSpace::ColorSpace(
    ::gfx::ColorSpace::PrimaryID primaries_in,
    ::gfx::ColorSpace::TransferID transfer_in,
    ::gfx::ColorSpace::MatrixID matrix_in,
    ::gfx::ColorSpace::RangeID range_in,
    std::vector<float> custom_primary_matrix_in,
    std::vector<float> transfer_params_in)
    : primaries(std::move(primaries_in)),
      transfer(std::move(transfer_in)),
      matrix(std::move(matrix_in)),
      range(std::move(range_in)),
      custom_primary_matrix(std::move(custom_primary_matrix_in)),
      transfer_params(std::move(transfer_params_in)) {}

ColorSpace::~ColorSpace() = default;

void ColorSpace::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primaries"), this->primaries,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::ColorSpace::PrimaryID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer"), this->transfer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::ColorSpace::TransferID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "matrix"), this->matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::ColorSpace::MatrixID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "range"), this->range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::ColorSpace::RangeID>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_primary_matrix"), this->custom_primary_matrix,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transfer_params"), this->transfer_params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<float>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ColorSpace::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NativeGpuMemoryBufferHandle::NativeGpuMemoryBufferHandle()
    : id(),
      platform_handle() {}

NativeGpuMemoryBufferHandle::NativeGpuMemoryBufferHandle(
    ::gfx::GpuMemoryBufferId id_in,
    ::gfx::NativePixmapHandle platform_handle_in)
    : id(std::move(id_in)),
      platform_handle(std::move(platform_handle_in)) {}

NativeGpuMemoryBufferHandle::~NativeGpuMemoryBufferHandle() = default;

void NativeGpuMemoryBufferHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "platform_handle"), this->platform_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::NativePixmapHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NativeGpuMemoryBufferHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrameMetadata::VideoFrameMetadata()
    : protected_video(),
      hw_protected(),
      needs_detiling() {}

VideoFrameMetadata::VideoFrameMetadata(
    bool protected_video_in,
    bool hw_protected_in)
    : protected_video(std::move(protected_video_in)),
      hw_protected(std::move(hw_protected_in)),
      needs_detiling() {}

VideoFrameMetadata::VideoFrameMetadata(
    bool protected_video_in,
    bool hw_protected_in,
    bool needs_detiling_in)
    : protected_video(std::move(protected_video_in)),
      hw_protected(std::move(hw_protected_in)),
      needs_detiling(std::move(needs_detiling_in)) {}

VideoFrameMetadata::~VideoFrameMetadata() = default;

void VideoFrameMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_video"), this->protected_video,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hw_protected"), this->hw_protected,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "needs_detiling"), this->needs_detiling,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrameMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VideoFrame::VideoFrame()
    : format(),
      coded_size(),
      visible_rect(),
      natural_size(),
      timestamp(),
      gpu_memory_buffer_handle(),
      metadata(),
      color_space(),
      hdr_metadata() {}

VideoFrame::VideoFrame(
    ::media::VideoPixelFormat format_in,
    const ::gfx::Size& coded_size_in,
    const ::gfx::Rect& visible_rect_in,
    const ::gfx::Size& natural_size_in,
    ::base::TimeDelta timestamp_in,
    ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle_in,
    const ::media::VideoFrameMetadata& metadata_in,
    const ::gfx::ColorSpace& color_space_in,
    const std::optional<::gfx::HDRMetadata>& hdr_metadata_in)
    : format(std::move(format_in)),
      coded_size(std::move(coded_size_in)),
      visible_rect(std::move(visible_rect_in)),
      natural_size(std::move(natural_size_in)),
      timestamp(std::move(timestamp_in)),
      gpu_memory_buffer_handle(std::move(gpu_memory_buffer_handle_in)),
      metadata(std::move(metadata_in)),
      color_space(std::move(color_space_in)),
      hdr_metadata(std::move(hdr_metadata_in)) {}

VideoFrame::~VideoFrame() = default;

void VideoFrame::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "format"), this->format,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::VideoPixelFormat>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "coded_size"), this->coded_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visible_rect"), this->visible_rect,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "natural_size"), this->natural_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Size&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gpu_memory_buffer_handle"), this->gpu_memory_buffer_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::gfx::GpuMemoryBufferHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "metadata"), this->metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::media::VideoFrameMetadata&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_space"), this->color_space,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::ColorSpace&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hdr_metadata"), this->hdr_metadata,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::HDRMetadata>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VideoFrame::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MediaLogRecord::MediaLogRecord()
    : id(),
      type(),
      params(),
      time() {}

MediaLogRecord::MediaLogRecord(
    int32_t id_in,
    ::media::MediaLogRecord::Type type_in,
    ::base::Value::Dict params_in,
    ::base::TimeTicks time_in)
    : id(std::move(id_in)),
      type(std::move(type_in)),
      params(std::move(params_in)),
      time(std::move(time_in)) {}

MediaLogRecord::~MediaLogRecord() = default;

void MediaLogRecord::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::MediaLogRecord::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "params"), this->params,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value::Dict>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "time"), this->time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MediaLogRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // media::stable::mojom


namespace mojo {


// static
bool StructTraits<::media::stable::mojom::SubsampleEntry::DataView, ::media::stable::mojom::SubsampleEntryPtr>::Read(
    ::media::stable::mojom::SubsampleEntry::DataView input,
    ::media::stable::mojom::SubsampleEntryPtr* output) {
  bool success = true;
  ::media::stable::mojom::SubsampleEntryPtr result(::media::stable::mojom::SubsampleEntry::New());
  
      if (success)
        result->clear_bytes = input.clear_bytes();
      if (success)
        result->cypher_bytes = input.cypher_bytes();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::DecryptConfig::DataView, ::media::stable::mojom::DecryptConfigPtr>::Read(
    ::media::stable::mojom::DecryptConfig::DataView input,
    ::media::stable::mojom::DecryptConfigPtr* output) {
  bool success = true;
  ::media::stable::mojom::DecryptConfigPtr result(::media::stable::mojom::DecryptConfig::New());
  
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadKeyId(&result->key_id))
        success = false;
      if (success && !input.ReadIv(&result->iv))
        success = false;
      if (success && !input.ReadSubsamples(&result->subsamples))
        success = false;
      if (success && !input.ReadEncryptionPattern(&result->encryption_pattern))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::ColorVolumeMetadata::DataView, ::media::stable::mojom::ColorVolumeMetadataPtr>::Read(
    ::media::stable::mojom::ColorVolumeMetadata::DataView input,
    ::media::stable::mojom::ColorVolumeMetadataPtr* output) {
  bool success = true;
  ::media::stable::mojom::ColorVolumeMetadataPtr result(::media::stable::mojom::ColorVolumeMetadata::New());
  
      if (success && !input.ReadPrimaryR(&result->primary_r))
        success = false;
      if (success && !input.ReadPrimaryG(&result->primary_g))
        success = false;
      if (success && !input.ReadPrimaryB(&result->primary_b))
        success = false;
      if (success && !input.ReadWhitePoint(&result->white_point))
        success = false;
      if (success)
        result->luminance_max = input.luminance_max();
      if (success)
        result->luminance_min = input.luminance_min();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::HDRMetadata::DataView, ::media::stable::mojom::HDRMetadataPtr>::Read(
    ::media::stable::mojom::HDRMetadata::DataView input,
    ::media::stable::mojom::HDRMetadataPtr* output) {
  bool success = true;
  ::media::stable::mojom::HDRMetadataPtr result(::media::stable::mojom::HDRMetadata::New());
  
      if (success && !input.ReadColorVolumeMetadata(&result->color_volume_metadata))
        success = false;
      if (success)
        result->max_content_light_level = input.max_content_light_level();
      if (success)
        result->max_frame_average_light_level = input.max_frame_average_light_level();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::VideoDecoderConfig::DataView, ::media::stable::mojom::VideoDecoderConfigPtr>::Read(
    ::media::stable::mojom::VideoDecoderConfig::DataView input,
    ::media::stable::mojom::VideoDecoderConfigPtr* output) {
  bool success = true;
  ::media::stable::mojom::VideoDecoderConfigPtr result(::media::stable::mojom::VideoDecoderConfig::New());
  
      if (success && !input.ReadCodec(&result->codec))
        success = false;
      if (success && !input.ReadProfile(&result->profile))
        success = false;
      if (success)
        result->level = input.level();
      if (success)
        result->has_alpha = input.has_alpha();
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadExtraData(&result->extra_data))
        success = false;
      if (success && !input.ReadEncryptionScheme(&result->encryption_scheme))
        success = false;
      if (success && !input.ReadColorSpaceInfo(&result->color_space_info))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::SupportedVideoDecoderConfig::DataView, ::media::stable::mojom::SupportedVideoDecoderConfigPtr>::Read(
    ::media::stable::mojom::SupportedVideoDecoderConfig::DataView input,
    ::media::stable::mojom::SupportedVideoDecoderConfigPtr* output) {
  bool success = true;
  ::media::stable::mojom::SupportedVideoDecoderConfigPtr result(::media::stable::mojom::SupportedVideoDecoderConfig::New());
  
      if (success && !input.ReadProfileMin(&result->profile_min))
        success = false;
      if (success && !input.ReadProfileMax(&result->profile_max))
        success = false;
      if (success && !input.ReadCodedSizeMin(&result->coded_size_min))
        success = false;
      if (success && !input.ReadCodedSizeMax(&result->coded_size_max))
        success = false;
      if (success)
        result->allow_encrypted = input.allow_encrypted();
      if (success)
        result->require_encrypted = input.require_encrypted();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::StatusData::DataView, ::media::stable::mojom::StatusDataPtr>::Read(
    ::media::stable::mojom::StatusData::DataView input,
    ::media::stable::mojom::StatusDataPtr* output) {
  bool success = true;
  ::media::stable::mojom::StatusDataPtr result(::media::stable::mojom::StatusData::New());
  
      if (success && !input.ReadGroup(&result->group))
        success = false;
      if (success && !input.ReadCode(&result->code))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
      if (success && !input.ReadFrames(&result->frames))
        success = false;
      if (success && !input.ReadCause(&result->cause))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::Status::DataView, ::media::stable::mojom::StatusPtr>::Read(
    ::media::stable::mojom::Status::DataView input,
    ::media::stable::mojom::StatusPtr* output) {
  bool success = true;
  ::media::stable::mojom::StatusPtr result(::media::stable::mojom::Status::New());
  
      if (success && !input.ReadInternal(&result->internal))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::DecoderBufferSideData::DataView, ::media::stable::mojom::DecoderBufferSideDataPtr>::Read(
    ::media::stable::mojom::DecoderBufferSideData::DataView input,
    ::media::stable::mojom::DecoderBufferSideDataPtr* output) {
  bool success = true;
  ::media::stable::mojom::DecoderBufferSideDataPtr result(::media::stable::mojom::DecoderBufferSideData::New());
  
      if (success && !input.ReadSpatialLayers(&result->spatial_layers))
        success = false;
      if (success && !input.ReadAlphaData(&result->alpha_data))
        success = false;
      if (success)
        result->secure_handle = input.secure_handle();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::DecoderBuffer::DataView, ::media::stable::mojom::DecoderBufferPtr>::Read(
    ::media::stable::mojom::DecoderBuffer::DataView input,
    ::media::stable::mojom::DecoderBufferPtr* output) {
  bool success = true;
  ::media::stable::mojom::DecoderBufferPtr result(::media::stable::mojom::DecoderBuffer::New());
  
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadDuration(&result->duration))
        success = false;
      if (success)
        result->is_end_of_stream = input.is_end_of_stream();
      if (success)
        result->data_size = input.data_size();
      if (success)
        result->is_key_frame = input.is_key_frame();
      if (success && !input.ReadRawSideData(&result->raw_side_data))
        success = false;
      if (success && !input.ReadDecryptConfig(&result->decrypt_config))
        success = false;
      if (success && !input.ReadFrontDiscard(&result->front_discard))
        success = false;
      if (success && !input.ReadBackDiscard(&result->back_discard))
        success = false;
      if (success && !input.ReadSideData(&result->side_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::ColorSpace::DataView, ::media::stable::mojom::ColorSpacePtr>::Read(
    ::media::stable::mojom::ColorSpace::DataView input,
    ::media::stable::mojom::ColorSpacePtr* output) {
  bool success = true;
  ::media::stable::mojom::ColorSpacePtr result(::media::stable::mojom::ColorSpace::New());
  
      if (success && !input.ReadPrimaries(&result->primaries))
        success = false;
      if (success && !input.ReadTransfer(&result->transfer))
        success = false;
      if (success && !input.ReadMatrix(&result->matrix))
        success = false;
      if (success && !input.ReadRange(&result->range))
        success = false;
      if (success && !input.ReadCustomPrimaryMatrix(&result->custom_primary_matrix))
        success = false;
      if (success && !input.ReadTransferParams(&result->transfer_params))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::NativeGpuMemoryBufferHandle::DataView, ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr>::Read(
    ::media::stable::mojom::NativeGpuMemoryBufferHandle::DataView input,
    ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr* output) {
  bool success = true;
  ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr result(::media::stable::mojom::NativeGpuMemoryBufferHandle::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadPlatformHandle(&result->platform_handle))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::VideoFrameMetadata::DataView, ::media::stable::mojom::VideoFrameMetadataPtr>::Read(
    ::media::stable::mojom::VideoFrameMetadata::DataView input,
    ::media::stable::mojom::VideoFrameMetadataPtr* output) {
  bool success = true;
  ::media::stable::mojom::VideoFrameMetadataPtr result(::media::stable::mojom::VideoFrameMetadata::New());
  
      if (success)
        result->protected_video = input.protected_video();
      if (success)
        result->hw_protected = input.hw_protected();
      if (success)
        result->needs_detiling = input.needs_detiling();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::VideoFrame::DataView, ::media::stable::mojom::VideoFramePtr>::Read(
    ::media::stable::mojom::VideoFrame::DataView input,
    ::media::stable::mojom::VideoFramePtr* output) {
  bool success = true;
  ::media::stable::mojom::VideoFramePtr result(::media::stable::mojom::VideoFrame::New());
  
      if (success && !input.ReadFormat(&result->format))
        success = false;
      if (success && !input.ReadCodedSize(&result->coded_size))
        success = false;
      if (success && !input.ReadVisibleRect(&result->visible_rect))
        success = false;
      if (success && !input.ReadNaturalSize(&result->natural_size))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success && !input.ReadGpuMemoryBufferHandle(&result->gpu_memory_buffer_handle))
        success = false;
      if (success && !input.ReadMetadata(&result->metadata))
        success = false;
      if (success && !input.ReadColorSpace(&result->color_space))
        success = false;
      if (success && !input.ReadHdrMetadata(&result->hdr_metadata))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::media::stable::mojom::MediaLogRecord::DataView, ::media::stable::mojom::MediaLogRecordPtr>::Read(
    ::media::stable::mojom::MediaLogRecord::DataView input,
    ::media::stable::mojom::MediaLogRecordPtr* output) {
  bool success = true;
  ::media::stable::mojom::MediaLogRecordPtr result(::media::stable::mojom::MediaLogRecord::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadParams(&result->params))
        success = false;
      if (success && !input.ReadTime(&result->time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media::stable::mojom {




}  // media::stable::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif