// services/device/public/mojom/device_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/device_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/device_service.mojom-params-data.h"
#include "services/device/public/mojom/device_service.mojom-shared-message-ids.h"

#include "services/device/public/mojom/device_service.mojom-import-headers.h"
#include "services/device/public/mojom/device_service.mojom-test-utils.h"


namespace device::mojom {
const char DeviceService::Name_[] = "device.mojom.DeviceService";

DeviceService::IPCStableHashFunction DeviceService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DeviceService>(message.name())) {
    case messages::DeviceService::kBindFingerprint: {
      return &DeviceService::BindFingerprint_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindGeolocationConfig: {
      return &DeviceService::BindGeolocationConfig_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindGeolocationContext: {
      return &DeviceService::BindGeolocationContext_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindGeolocationControl: {
      return &DeviceService::BindGeolocationControl_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindGeolocationInternals: {
      return &DeviceService::BindGeolocationInternals_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindInputDeviceManager: {
      return &DeviceService::BindInputDeviceManager_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindBatteryMonitor: {
      return &DeviceService::BindBatteryMonitor_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindPressureManager: {
      return &DeviceService::BindPressureManager_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindVibrationManager: {
      return &DeviceService::BindVibrationManager_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindHidManager: {
      return &DeviceService::BindHidManager_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindPowerMonitor: {
      return &DeviceService::BindPowerMonitor_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindPublicIpAddressGeolocationProvider: {
      return &DeviceService::BindPublicIpAddressGeolocationProvider_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindScreenOrientationListener: {
      return &DeviceService::BindScreenOrientationListener_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindSensorProvider: {
      return &DeviceService::BindSensorProvider_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindSerialPortManager: {
      return &DeviceService::BindSerialPortManager_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindTimeZoneMonitor: {
      return &DeviceService::BindTimeZoneMonitor_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindWakeLockProvider: {
      return &DeviceService::BindWakeLockProvider_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindUsbDeviceManager: {
      return &DeviceService::BindUsbDeviceManager_Sym::IPCStableHash;
    }
    case messages::DeviceService::kBindUsbDeviceManagerTest: {
      return &DeviceService::BindUsbDeviceManagerTest_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DeviceService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DeviceService>(message.name())) {
      case messages::DeviceService::kBindFingerprint:
            return "Receive device::mojom::DeviceService::BindFingerprint";
      case messages::DeviceService::kBindGeolocationConfig:
            return "Receive device::mojom::DeviceService::BindGeolocationConfig";
      case messages::DeviceService::kBindGeolocationContext:
            return "Receive device::mojom::DeviceService::BindGeolocationContext";
      case messages::DeviceService::kBindGeolocationControl:
            return "Receive device::mojom::DeviceService::BindGeolocationControl";
      case messages::DeviceService::kBindGeolocationInternals:
            return "Receive device::mojom::DeviceService::BindGeolocationInternals";
      case messages::DeviceService::kBindInputDeviceManager:
            return "Receive device::mojom::DeviceService::BindInputDeviceManager";
      case messages::DeviceService::kBindBatteryMonitor:
            return "Receive device::mojom::DeviceService::BindBatteryMonitor";
      case messages::DeviceService::kBindPressureManager:
            return "Receive device::mojom::DeviceService::BindPressureManager";
      case messages::DeviceService::kBindVibrationManager:
            return "Receive device::mojom::DeviceService::BindVibrationManager";
      case messages::DeviceService::kBindHidManager:
            return "Receive device::mojom::DeviceService::BindHidManager";
      case messages::DeviceService::kBindPowerMonitor:
            return "Receive device::mojom::DeviceService::BindPowerMonitor";
      case messages::DeviceService::kBindPublicIpAddressGeolocationProvider:
            return "Receive device::mojom::DeviceService::BindPublicIpAddressGeolocationProvider";
      case messages::DeviceService::kBindScreenOrientationListener:
            return "Receive device::mojom::DeviceService::BindScreenOrientationListener";
      case messages::DeviceService::kBindSensorProvider:
            return "Receive device::mojom::DeviceService::BindSensorProvider";
      case messages::DeviceService::kBindSerialPortManager:
            return "Receive device::mojom::DeviceService::BindSerialPortManager";
      case messages::DeviceService::kBindTimeZoneMonitor:
            return "Receive device::mojom::DeviceService::BindTimeZoneMonitor";
      case messages::DeviceService::kBindWakeLockProvider:
            return "Receive device::mojom::DeviceService::BindWakeLockProvider";
      case messages::DeviceService::kBindUsbDeviceManager:
            return "Receive device::mojom::DeviceService::BindUsbDeviceManager";
      case messages::DeviceService::kBindUsbDeviceManagerTest:
            return "Receive device::mojom::DeviceService::BindUsbDeviceManagerTest";
    }
  } else {
    switch (static_cast<messages::DeviceService>(message.name())) {
      case messages::DeviceService::kBindFingerprint:
            return "Receive reply device::mojom::DeviceService::BindFingerprint";
      case messages::DeviceService::kBindGeolocationConfig:
            return "Receive reply device::mojom::DeviceService::BindGeolocationConfig";
      case messages::DeviceService::kBindGeolocationContext:
            return "Receive reply device::mojom::DeviceService::BindGeolocationContext";
      case messages::DeviceService::kBindGeolocationControl:
            return "Receive reply device::mojom::DeviceService::BindGeolocationControl";
      case messages::DeviceService::kBindGeolocationInternals:
            return "Receive reply device::mojom::DeviceService::BindGeolocationInternals";
      case messages::DeviceService::kBindInputDeviceManager:
            return "Receive reply device::mojom::DeviceService::BindInputDeviceManager";
      case messages::DeviceService::kBindBatteryMonitor:
            return "Receive reply device::mojom::DeviceService::BindBatteryMonitor";
      case messages::DeviceService::kBindPressureManager:
            return "Receive reply device::mojom::DeviceService::BindPressureManager";
      case messages::DeviceService::kBindVibrationManager:
            return "Receive reply device::mojom::DeviceService::BindVibrationManager";
      case messages::DeviceService::kBindHidManager:
            return "Receive reply device::mojom::DeviceService::BindHidManager";
      case messages::DeviceService::kBindPowerMonitor:
            return "Receive reply device::mojom::DeviceService::BindPowerMonitor";
      case messages::DeviceService::kBindPublicIpAddressGeolocationProvider:
            return "Receive reply device::mojom::DeviceService::BindPublicIpAddressGeolocationProvider";
      case messages::DeviceService::kBindScreenOrientationListener:
            return "Receive reply device::mojom::DeviceService::BindScreenOrientationListener";
      case messages::DeviceService::kBindSensorProvider:
            return "Receive reply device::mojom::DeviceService::BindSensorProvider";
      case messages::DeviceService::kBindSerialPortManager:
            return "Receive reply device::mojom::DeviceService::BindSerialPortManager";
      case messages::DeviceService::kBindTimeZoneMonitor:
            return "Receive reply device::mojom::DeviceService::BindTimeZoneMonitor";
      case messages::DeviceService::kBindWakeLockProvider:
            return "Receive reply device::mojom::DeviceService::BindWakeLockProvider";
      case messages::DeviceService::kBindUsbDeviceManager:
            return "Receive reply device::mojom::DeviceService::BindUsbDeviceManager";
      case messages::DeviceService::kBindUsbDeviceManagerTest:
            return "Receive reply device::mojom::DeviceService::BindUsbDeviceManagerTest";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DeviceService::BindFingerprint_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindFingerprint");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindGeolocationConfig_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindGeolocationConfig");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindGeolocationContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindGeolocationContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindGeolocationControl_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindGeolocationControl");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindGeolocationInternals_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindGeolocationInternals");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindInputDeviceManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindInputDeviceManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindBatteryMonitor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindBatteryMonitor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindPressureManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindPressureManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindVibrationManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindVibrationManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindHidManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindHidManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindPowerMonitor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindPowerMonitor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindPublicIpAddressGeolocationProvider_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindPublicIpAddressGeolocationProvider");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindScreenOrientationListener_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindScreenOrientationListener");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindSensorProvider_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindSensorProvider");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindSerialPortManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindSerialPortManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindTimeZoneMonitor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindTimeZoneMonitor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindWakeLockProvider_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindWakeLockProvider");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindUsbDeviceManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindUsbDeviceManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t DeviceService::BindUsbDeviceManagerTest_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::DeviceService::BindUsbDeviceManagerTest");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

DeviceServiceProxy::DeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DeviceServiceProxy::BindFingerprint(
    ::mojo::PendingReceiver<::device::mojom::Fingerprint> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindFingerprint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::Fingerprint>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindFingerprint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindFingerprint_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::FingerprintInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindFingerprint request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindFingerprint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindGeolocationConfig(
    ::mojo::PendingReceiver<::device::mojom::GeolocationConfig> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindGeolocationConfig", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::GeolocationConfig>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindGeolocationConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindGeolocationConfig_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationConfigInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindGeolocationConfig request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindGeolocationConfig");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindGeolocationContext(
    ::mojo::PendingReceiver<::device::mojom::GeolocationContext> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindGeolocationContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::GeolocationContext>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindGeolocationContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindGeolocationContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationContextInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindGeolocationContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindGeolocationContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindGeolocationControl(
    ::mojo::PendingReceiver<::device::mojom::GeolocationControl> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindGeolocationControl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::GeolocationControl>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindGeolocationControl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindGeolocationControl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationControlInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindGeolocationControl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindGeolocationControl");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindGeolocationInternals(
    ::mojo::PendingReceiver<::device::mojom::GeolocationInternals> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindGeolocationInternals", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::GeolocationInternals>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindGeolocationInternals), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindGeolocationInternals_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationInternalsInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindGeolocationInternals request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindGeolocationInternals");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindInputDeviceManager(
    ::mojo::PendingReceiver<::device::mojom::InputDeviceManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindInputDeviceManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::InputDeviceManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindInputDeviceManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindInputDeviceManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::InputDeviceManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindInputDeviceManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindInputDeviceManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindBatteryMonitor(
    ::mojo::PendingReceiver<::device::mojom::BatteryMonitor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindBatteryMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::BatteryMonitor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindBatteryMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindBatteryMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::BatteryMonitorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindBatteryMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindBatteryMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindPressureManager(
    ::mojo::PendingReceiver<::device::mojom::PressureManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindPressureManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::PressureManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindPressureManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindPressureManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::PressureManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindPressureManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindPressureManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindVibrationManager(
    ::mojo::PendingReceiver<::device::mojom::VibrationManager> in_receiver, ::mojo::PendingRemote<::device::mojom::VibrationManagerListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindVibrationManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::VibrationManager>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::device::mojom::VibrationManagerListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindVibrationManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindVibrationManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::VibrationManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindVibrationManager request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::VibrationManagerListenerInterfaceBase>>(
      in_listener, &params->listener, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->listener),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid listener in DeviceService.BindVibrationManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindVibrationManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindHidManager(
    ::mojo::PendingReceiver<::device::mojom::HidManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindHidManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::HidManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindHidManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindHidManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::HidManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindHidManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindHidManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindPowerMonitor(
    ::mojo::PendingReceiver<::device::mojom::PowerMonitor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindPowerMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::PowerMonitor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindPowerMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindPowerMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::PowerMonitorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindPowerMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindPowerMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindPublicIpAddressGeolocationProvider(
    ::mojo::PendingReceiver<::device::mojom::PublicIpAddressGeolocationProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindPublicIpAddressGeolocationProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::PublicIpAddressGeolocationProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindPublicIpAddressGeolocationProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::PublicIpAddressGeolocationProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindPublicIpAddressGeolocationProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindPublicIpAddressGeolocationProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindScreenOrientationListener(
    ::mojo::PendingReceiver<::device::mojom::ScreenOrientationListener> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindScreenOrientationListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::ScreenOrientationListener>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindScreenOrientationListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindScreenOrientationListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::ScreenOrientationListenerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindScreenOrientationListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindScreenOrientationListener");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindSensorProvider(
    ::mojo::PendingReceiver<::device::mojom::SensorProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindSensorProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::SensorProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindSensorProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindSensorProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::SensorProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindSensorProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindSensorProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindSerialPortManager(
    ::mojo::PendingReceiver<::device::mojom::SerialPortManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindSerialPortManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::SerialPortManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindSerialPortManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindSerialPortManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::SerialPortManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindSerialPortManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindSerialPortManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindTimeZoneMonitor(
    ::mojo::PendingReceiver<::device::mojom::TimeZoneMonitor> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindTimeZoneMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::TimeZoneMonitor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindTimeZoneMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindTimeZoneMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::TimeZoneMonitorInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindTimeZoneMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindTimeZoneMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindWakeLockProvider(
    ::mojo::PendingReceiver<::device::mojom::WakeLockProvider> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindWakeLockProvider", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::WakeLockProvider>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindWakeLockProvider), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindWakeLockProvider_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockProviderInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindWakeLockProvider request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindWakeLockProvider");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindUsbDeviceManager(
    ::mojo::PendingReceiver<::device::mojom::UsbDeviceManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindUsbDeviceManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::UsbDeviceManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindUsbDeviceManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindUsbDeviceManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindUsbDeviceManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindUsbDeviceManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void DeviceServiceProxy::BindUsbDeviceManagerTest(
    ::mojo::PendingReceiver<::device::mojom::UsbDeviceManagerTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::DeviceService::BindUsbDeviceManagerTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::UsbDeviceManagerTest>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DeviceService::kBindUsbDeviceManagerTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::DeviceService_BindUsbDeviceManagerTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::UsbDeviceManagerTestInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in DeviceService.BindUsbDeviceManagerTest request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DeviceService::Name_);
  message.set_method_name("BindUsbDeviceManagerTest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool DeviceServiceStubDispatch::Accept(
    DeviceService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DeviceService>(message->header()->name)) {
    case messages::DeviceService::kBindFingerprint: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindFingerprint_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindFingerprint_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.0
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::Fingerprint> p_receiver{};
      DeviceService_BindFingerprint_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindFingerprint(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindGeolocationConfig: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindGeolocationConfig_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindGeolocationConfig_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.1
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::GeolocationConfig> p_receiver{};
      DeviceService_BindGeolocationConfig_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocationConfig(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindGeolocationContext: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindGeolocationContext_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindGeolocationContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.2
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::GeolocationContext> p_receiver{};
      DeviceService_BindGeolocationContext_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocationContext(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindGeolocationControl: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindGeolocationControl_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindGeolocationControl_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.3
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::GeolocationControl> p_receiver{};
      DeviceService_BindGeolocationControl_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocationControl(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindGeolocationInternals: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindGeolocationInternals_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindGeolocationInternals_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.4
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::GeolocationInternals> p_receiver{};
      DeviceService_BindGeolocationInternals_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocationInternals(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindInputDeviceManager: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindInputDeviceManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindInputDeviceManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.5
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::InputDeviceManager> p_receiver{};
      DeviceService_BindInputDeviceManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindInputDeviceManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindBatteryMonitor: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindBatteryMonitor_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindBatteryMonitor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.6
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::BatteryMonitor> p_receiver{};
      DeviceService_BindBatteryMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindBatteryMonitor(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindPressureManager: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindPressureManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindPressureManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.7
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::PressureManager> p_receiver{};
      DeviceService_BindPressureManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPressureManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindVibrationManager: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindVibrationManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindVibrationManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.8
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::VibrationManager> p_receiver{};
      ::mojo::PendingRemote<::device::mojom::VibrationManagerListener> p_listener{};
      DeviceService_BindVibrationManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindVibrationManager(        
        std::move(p_receiver), 
        std::move(p_listener));
      return true;
    }
    case messages::DeviceService::kBindHidManager: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindHidManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindHidManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.9
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::HidManager> p_receiver{};
      DeviceService_BindHidManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindHidManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindPowerMonitor: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindPowerMonitor_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindPowerMonitor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.10
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::PowerMonitor> p_receiver{};
      DeviceService_BindPowerMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPowerMonitor(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindPublicIpAddressGeolocationProvider: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.11
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::PublicIpAddressGeolocationProvider> p_receiver{};
      DeviceService_BindPublicIpAddressGeolocationProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindPublicIpAddressGeolocationProvider(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindScreenOrientationListener: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindScreenOrientationListener_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindScreenOrientationListener_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.12
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::ScreenOrientationListener> p_receiver{};
      DeviceService_BindScreenOrientationListener_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindScreenOrientationListener(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindSensorProvider: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindSensorProvider_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindSensorProvider_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.13
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::SensorProvider> p_receiver{};
      DeviceService_BindSensorProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSensorProvider(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindSerialPortManager: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindSerialPortManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindSerialPortManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.14
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::SerialPortManager> p_receiver{};
      DeviceService_BindSerialPortManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindSerialPortManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindTimeZoneMonitor: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindTimeZoneMonitor_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindTimeZoneMonitor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.15
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::TimeZoneMonitor> p_receiver{};
      DeviceService_BindTimeZoneMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTimeZoneMonitor(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindWakeLockProvider: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindWakeLockProvider_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindWakeLockProvider_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.16
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::WakeLockProvider> p_receiver{};
      DeviceService_BindWakeLockProvider_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWakeLockProvider(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindUsbDeviceManager: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindUsbDeviceManager_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindUsbDeviceManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.17
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::UsbDeviceManager> p_receiver{};
      DeviceService_BindUsbDeviceManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindUsbDeviceManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::DeviceService::kBindUsbDeviceManagerTest: {
      DCHECK(message->is_serialized());
      internal::DeviceService_BindUsbDeviceManagerTest_Params_Data* params =
          reinterpret_cast<internal::DeviceService_BindUsbDeviceManagerTest_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for DeviceService.18
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::UsbDeviceManagerTest> p_receiver{};
      DeviceService_BindUsbDeviceManagerTest_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DeviceService::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindUsbDeviceManagerTest(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool DeviceServiceStubDispatch::AcceptWithResponder(
    DeviceService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DeviceService>(message->header()->name)) {
    case messages::DeviceService::kBindFingerprint: {
      break;
    }
    case messages::DeviceService::kBindGeolocationConfig: {
      break;
    }
    case messages::DeviceService::kBindGeolocationContext: {
      break;
    }
    case messages::DeviceService::kBindGeolocationControl: {
      break;
    }
    case messages::DeviceService::kBindGeolocationInternals: {
      break;
    }
    case messages::DeviceService::kBindInputDeviceManager: {
      break;
    }
    case messages::DeviceService::kBindBatteryMonitor: {
      break;
    }
    case messages::DeviceService::kBindPressureManager: {
      break;
    }
    case messages::DeviceService::kBindVibrationManager: {
      break;
    }
    case messages::DeviceService::kBindHidManager: {
      break;
    }
    case messages::DeviceService::kBindPowerMonitor: {
      break;
    }
    case messages::DeviceService::kBindPublicIpAddressGeolocationProvider: {
      break;
    }
    case messages::DeviceService::kBindScreenOrientationListener: {
      break;
    }
    case messages::DeviceService::kBindSensorProvider: {
      break;
    }
    case messages::DeviceService::kBindSerialPortManager: {
      break;
    }
    case messages::DeviceService::kBindTimeZoneMonitor: {
      break;
    }
    case messages::DeviceService::kBindWakeLockProvider: {
      break;
    }
    case messages::DeviceService::kBindUsbDeviceManager: {
      break;
    }
    case messages::DeviceService::kBindUsbDeviceManagerTest: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDeviceServiceValidationInfo[] = {
    {base::to_underlying(messages::DeviceService::kBindFingerprint),
     { &internal::DeviceService_BindFingerprint_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindGeolocationConfig),
     { &internal::DeviceService_BindGeolocationConfig_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindGeolocationContext),
     { &internal::DeviceService_BindGeolocationContext_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindGeolocationControl),
     { &internal::DeviceService_BindGeolocationControl_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindGeolocationInternals),
     { &internal::DeviceService_BindGeolocationInternals_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindInputDeviceManager),
     { &internal::DeviceService_BindInputDeviceManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindBatteryMonitor),
     { &internal::DeviceService_BindBatteryMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindPressureManager),
     { &internal::DeviceService_BindPressureManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindVibrationManager),
     { &internal::DeviceService_BindVibrationManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindHidManager),
     { &internal::DeviceService_BindHidManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindPowerMonitor),
     { &internal::DeviceService_BindPowerMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindPublicIpAddressGeolocationProvider),
     { &internal::DeviceService_BindPublicIpAddressGeolocationProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindScreenOrientationListener),
     { &internal::DeviceService_BindScreenOrientationListener_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindSensorProvider),
     { &internal::DeviceService_BindSensorProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindSerialPortManager),
     { &internal::DeviceService_BindSerialPortManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindTimeZoneMonitor),
     { &internal::DeviceService_BindTimeZoneMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindWakeLockProvider),
     { &internal::DeviceService_BindWakeLockProvider_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindUsbDeviceManager),
     { &internal::DeviceService_BindUsbDeviceManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::DeviceService::kBindUsbDeviceManagerTest),
     { &internal::DeviceService_BindUsbDeviceManagerTest_Params_Data::Validate,
      nullptr /* no response */}},
};

bool DeviceServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::DeviceService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDeviceServiceValidationInfo);
}



}  // device::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void DeviceServiceInterceptorForTesting::BindFingerprint(::mojo::PendingReceiver<::device::mojom::Fingerprint> receiver) {
  GetForwardingInterface()->BindFingerprint(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindGeolocationConfig(::mojo::PendingReceiver<::device::mojom::GeolocationConfig> receiver) {
  GetForwardingInterface()->BindGeolocationConfig(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindGeolocationContext(::mojo::PendingReceiver<::device::mojom::GeolocationContext> receiver) {
  GetForwardingInterface()->BindGeolocationContext(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindGeolocationControl(::mojo::PendingReceiver<::device::mojom::GeolocationControl> receiver) {
  GetForwardingInterface()->BindGeolocationControl(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindGeolocationInternals(::mojo::PendingReceiver<::device::mojom::GeolocationInternals> receiver) {
  GetForwardingInterface()->BindGeolocationInternals(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindInputDeviceManager(::mojo::PendingReceiver<::device::mojom::InputDeviceManager> receiver) {
  GetForwardingInterface()->BindInputDeviceManager(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindBatteryMonitor(::mojo::PendingReceiver<::device::mojom::BatteryMonitor> receiver) {
  GetForwardingInterface()->BindBatteryMonitor(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindPressureManager(::mojo::PendingReceiver<::device::mojom::PressureManager> receiver) {
  GetForwardingInterface()->BindPressureManager(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindVibrationManager(::mojo::PendingReceiver<::device::mojom::VibrationManager> receiver, ::mojo::PendingRemote<::device::mojom::VibrationManagerListener> listener) {
  GetForwardingInterface()->BindVibrationManager(
    std::move(receiver)
    , 
    std::move(listener)
    );
}
void DeviceServiceInterceptorForTesting::BindHidManager(::mojo::PendingReceiver<::device::mojom::HidManager> receiver) {
  GetForwardingInterface()->BindHidManager(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindPowerMonitor(::mojo::PendingReceiver<::device::mojom::PowerMonitor> receiver) {
  GetForwardingInterface()->BindPowerMonitor(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindPublicIpAddressGeolocationProvider(::mojo::PendingReceiver<::device::mojom::PublicIpAddressGeolocationProvider> receiver) {
  GetForwardingInterface()->BindPublicIpAddressGeolocationProvider(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindScreenOrientationListener(::mojo::PendingReceiver<::device::mojom::ScreenOrientationListener> receiver) {
  GetForwardingInterface()->BindScreenOrientationListener(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindSensorProvider(::mojo::PendingReceiver<::device::mojom::SensorProvider> receiver) {
  GetForwardingInterface()->BindSensorProvider(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindSerialPortManager(::mojo::PendingReceiver<::device::mojom::SerialPortManager> receiver) {
  GetForwardingInterface()->BindSerialPortManager(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindTimeZoneMonitor(::mojo::PendingReceiver<::device::mojom::TimeZoneMonitor> receiver) {
  GetForwardingInterface()->BindTimeZoneMonitor(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindWakeLockProvider(::mojo::PendingReceiver<::device::mojom::WakeLockProvider> receiver) {
  GetForwardingInterface()->BindWakeLockProvider(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindUsbDeviceManager(::mojo::PendingReceiver<::device::mojom::UsbDeviceManager> receiver) {
  GetForwardingInterface()->BindUsbDeviceManager(
    std::move(receiver)
    );
}
void DeviceServiceInterceptorForTesting::BindUsbDeviceManagerTest(::mojo::PendingReceiver<::device::mojom::UsbDeviceManagerTest> receiver) {
  GetForwardingInterface()->BindUsbDeviceManagerTest(
    std::move(receiver)
    );
}
DeviceServiceAsyncWaiter::DeviceServiceAsyncWaiter(
    DeviceService* proxy) : proxy_(proxy) {}

DeviceServiceAsyncWaiter::~DeviceServiceAsyncWaiter() = default;






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif