// services/device/public/mojom/pressure_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/pressure_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/pressure_manager.mojom-params-data.h"
#include "services/device/public/mojom/pressure_manager.mojom-shared-message-ids.h"

#include "services/device/public/mojom/pressure_manager.mojom-blink-import-headers.h"
#include "services/device/public/mojom/pressure_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
VirtualPressureSourceMetadata::VirtualPressureSourceMetadata()
    : available(true) {}

VirtualPressureSourceMetadata::VirtualPressureSourceMetadata(
    bool available_in)
    : available(std::move(available_in)) {}

VirtualPressureSourceMetadata::~VirtualPressureSourceMetadata() = default;
size_t VirtualPressureSourceMetadata::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->available);
  return seed;
}

void VirtualPressureSourceMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "available"), this->available,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VirtualPressureSourceMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PressureManagerAddClientResult::PressureManagerAddClientResult() : tag_(Tag::kError) {
  data_.error = PressureManagerAddClientError();
}

PressureManagerAddClientResult::~PressureManagerAddClientResult() {
  DestroyActive();
}


void PressureManagerAddClientResult::set_error(
    PressureManagerAddClientError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}
void PressureManagerAddClientResult::set_pressure_client(
    ::mojo::PendingReceiver<PressureClient> pressure_client) {
  if (tag_ == Tag::kPressureClient) {
    *(data_.pressure_client) = std::move(pressure_client);
  } else {
    DestroyActive();
    tag_ = Tag::kPressureClient;
    data_.pressure_client = new ::mojo::PendingReceiver<PressureClient>(
        std::move(pressure_client));
  }
}

void PressureManagerAddClientResult::DestroyActive() {
  switch (tag_) {

    case Tag::kError:

      break;
    case Tag::kPressureClient:

      delete data_.pressure_client;
      break;
  }
}

bool PressureManagerAddClientResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char PressureManager::Name_[] = "device.mojom.PressureManager";

PressureManager::IPCStableHashFunction PressureManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PressureManager>(message.name())) {
    case messages::PressureManager::kAddVirtualPressureSource: {
      return &PressureManager::AddVirtualPressureSource_Sym::IPCStableHash;
    }
    case messages::PressureManager::kRemoveVirtualPressureSource: {
      return &PressureManager::RemoveVirtualPressureSource_Sym::IPCStableHash;
    }
    case messages::PressureManager::kUpdateVirtualPressureSourceState: {
      return &PressureManager::UpdateVirtualPressureSourceState_Sym::IPCStableHash;
    }
    case messages::PressureManager::kAddClient: {
      return &PressureManager::AddClient_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PressureManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PressureManager>(message.name())) {
      case messages::PressureManager::kAddVirtualPressureSource:
            return "Receive device::mojom::PressureManager::AddVirtualPressureSource";
      case messages::PressureManager::kRemoveVirtualPressureSource:
            return "Receive device::mojom::PressureManager::RemoveVirtualPressureSource";
      case messages::PressureManager::kUpdateVirtualPressureSourceState:
            return "Receive device::mojom::PressureManager::UpdateVirtualPressureSourceState";
      case messages::PressureManager::kAddClient:
            return "Receive device::mojom::PressureManager::AddClient";
    }
  } else {
    switch (static_cast<messages::PressureManager>(message.name())) {
      case messages::PressureManager::kAddVirtualPressureSource:
            return "Receive reply device::mojom::PressureManager::AddVirtualPressureSource";
      case messages::PressureManager::kRemoveVirtualPressureSource:
            return "Receive reply device::mojom::PressureManager::RemoveVirtualPressureSource";
      case messages::PressureManager::kUpdateVirtualPressureSourceState:
            return "Receive reply device::mojom::PressureManager::UpdateVirtualPressureSourceState";
      case messages::PressureManager::kAddClient:
            return "Receive reply device::mojom::PressureManager::AddClient";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PressureManager::AddVirtualPressureSource_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::PressureManager::AddVirtualPressureSource");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PressureManager::RemoveVirtualPressureSource_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::PressureManager::RemoveVirtualPressureSource");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PressureManager::UpdateVirtualPressureSourceState_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::PressureManager::UpdateVirtualPressureSourceState");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PressureManager::AddClient_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::PressureManager::AddClient");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PressureManager_AddVirtualPressureSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_AddVirtualPressureSource_ForwardToCallback(
      PressureManager::AddVirtualPressureSourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_AddVirtualPressureSource_ForwardToCallback(const PressureManager_AddVirtualPressureSource_ForwardToCallback&) = delete;
  PressureManager_AddVirtualPressureSource_ForwardToCallback& operator=(const PressureManager_AddVirtualPressureSource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::AddVirtualPressureSourceCallback callback_;
};

class PressureManager_RemoveVirtualPressureSource_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_RemoveVirtualPressureSource_ForwardToCallback(
      PressureManager::RemoveVirtualPressureSourceCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_RemoveVirtualPressureSource_ForwardToCallback(const PressureManager_RemoveVirtualPressureSource_ForwardToCallback&) = delete;
  PressureManager_RemoveVirtualPressureSource_ForwardToCallback& operator=(const PressureManager_RemoveVirtualPressureSource_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::RemoveVirtualPressureSourceCallback callback_;
};

class PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback(
      PressureManager::UpdateVirtualPressureSourceStateCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback(const PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback&) = delete;
  PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback& operator=(const PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::UpdateVirtualPressureSourceStateCallback callback_;
};

class PressureManager_AddClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PressureManager_AddClient_ForwardToCallback(
      PressureManager::AddClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  PressureManager_AddClient_ForwardToCallback(const PressureManager_AddClient_ForwardToCallback&) = delete;
  PressureManager_AddClient_ForwardToCallback& operator=(const PressureManager_AddClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PressureManager::AddClientCallback callback_;
};

PressureManagerProxy::PressureManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PressureManagerProxy::AddVirtualPressureSource(
    const ::base::UnguessableToken& in_token, ::device::mojom::blink::PressureSource in_source, VirtualPressureSourceMetadataPtr in_metadata, AddVirtualPressureSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::AddVirtualPressureSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::blink::PressureSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("metadata"), in_metadata,
                        "<value of type VirtualPressureSourceMetadataPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddVirtualPressureSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in PressureManager.AddVirtualPressureSource request");
  mojo::internal::Serialize<::device::mojom::PressureSource>(
      in_source, &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->metadata)::BaseType> metadata_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::VirtualPressureSourceMetadataDataView>(
      in_metadata, metadata_fragment);
  params->metadata.Set(
      metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->metadata.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metadata in PressureManager.AddVirtualPressureSource request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddVirtualPressureSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_AddVirtualPressureSource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PressureManagerProxy::RemoveVirtualPressureSource(
    const ::base::UnguessableToken& in_token, ::device::mojom::blink::PressureSource in_source, RemoveVirtualPressureSourceCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::RemoveVirtualPressureSource", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::blink::PressureSource>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kRemoveVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_RemoveVirtualPressureSource_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in PressureManager.RemoveVirtualPressureSource request");
  mojo::internal::Serialize<::device::mojom::PressureSource>(
      in_source, &params->source);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("RemoveVirtualPressureSource");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_RemoveVirtualPressureSource_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PressureManagerProxy::UpdateVirtualPressureSourceState(
    const ::base::UnguessableToken& in_token, ::device::mojom::blink::PressureSource in_source, ::device::mojom::blink::PressureState in_state, UpdateVirtualPressureSourceStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::UpdateVirtualPressureSourceState", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::blink::PressureSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("state"), in_state,
                        "<value of type ::device::mojom::blink::PressureState>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kUpdateVirtualPressureSourceState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_UpdateVirtualPressureSourceState_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in PressureManager.UpdateVirtualPressureSourceState request");
  mojo::internal::Serialize<::device::mojom::PressureSource>(
      in_source, &params->source);
  mojo::internal::Serialize<::device::mojom::PressureState>(
      in_state, &params->state);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("UpdateVirtualPressureSourceState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PressureManagerProxy::AddClient(
    ::device::mojom::blink::PressureSource in_source, const std::optional<::base::UnguessableToken>& in_token, AddClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureManager::AddClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source"), in_source,
                        "<value of type ::device::mojom::blink::PressureSource>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddClient_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::PressureSource>(
      in_source, &params->source);
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PressureManager_AddClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PressureManager_AddVirtualPressureSource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::AddVirtualPressureSourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_AddVirtualPressureSource_ProxyToResponder> proxy(
        new PressureManager_AddVirtualPressureSource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_AddVirtualPressureSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_AddVirtualPressureSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_AddVirtualPressureSource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PressureManager::AddVirtualPressureSourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PressureManager_AddVirtualPressureSource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PressureManager.0
  bool success = true;
  PressureManager_AddVirtualPressureSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PressureManager_AddVirtualPressureSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::PressureManager::AddVirtualPressureSource");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddVirtualPressureSource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PressureManager_RemoveVirtualPressureSource_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::RemoveVirtualPressureSourceCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_RemoveVirtualPressureSource_ProxyToResponder> proxy(
        new PressureManager_RemoveVirtualPressureSource_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_RemoveVirtualPressureSource_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_RemoveVirtualPressureSource_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_RemoveVirtualPressureSource_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PressureManager::RemoveVirtualPressureSourceCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PressureManager_RemoveVirtualPressureSource_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PressureManager.1
  bool success = true;
  PressureManager_RemoveVirtualPressureSource_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PressureManager_RemoveVirtualPressureSource_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::PressureManager::RemoveVirtualPressureSource");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kRemoveVirtualPressureSource), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("RemoveVirtualPressureSource");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::UpdateVirtualPressureSourceStateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder> proxy(
        new PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PressureManager::UpdateVirtualPressureSourceStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool PressureManager_UpdateVirtualPressureSourceState_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_UpdateVirtualPressureSourceState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_UpdateVirtualPressureSourceState_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PressureManager.2
  bool success = true;
  PressureManager_UpdateVirtualPressureSourceState_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::PressureManager::UpdateVirtualPressureSourceState");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kUpdateVirtualPressureSourceState), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_UpdateVirtualPressureSourceState_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("UpdateVirtualPressureSourceState");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PressureManager_AddClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PressureManager::AddClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PressureManager_AddClient_ProxyToResponder> proxy(
        new PressureManager_AddClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PressureManager_AddClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PressureManager_AddClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PressureManager_AddClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "PressureManager::AddClientCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PressureManagerAddClientResultPtr in_result);
};

bool PressureManager_AddClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PressureManager_AddClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PressureManager_AddClient_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for PressureManager.3
  bool success = true;
  PressureManagerAddClientResultPtr p_result{};
  PressureManager_AddClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PressureManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void PressureManager_AddClient_ProxyToResponder::Run(
    PressureManagerAddClientResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::PressureManager::AddClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PressureManagerAddClientResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureManager::kAddClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureManager_AddClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::device::mojom::PressureManagerAddClientResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureManager::Name_);
  message.set_method_name("AddClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PressureManagerStubDispatch::Accept(
    PressureManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PressureManager>(message->header()->name)) {
    case messages::PressureManager::kAddVirtualPressureSource: {
      break;
    }
    case messages::PressureManager::kRemoveVirtualPressureSource: {
      break;
    }
    case messages::PressureManager::kUpdateVirtualPressureSourceState: {
      break;
    }
    case messages::PressureManager::kAddClient: {
      break;
    }
  }
  return false;
}

// static
bool PressureManagerStubDispatch::AcceptWithResponder(
    PressureManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PressureManager>(message->header()->name)) {
    case messages::PressureManager::kAddVirtualPressureSource: {
      internal::PressureManager_AddVirtualPressureSource_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_AddVirtualPressureSource_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PressureManager.0
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::blink::PressureSource p_source{};
      VirtualPressureSourceMetadataPtr p_metadata{};
      PressureManager_AddVirtualPressureSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadMetadata(&p_metadata))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 0, false);
        return false;
      }
      PressureManager::AddVirtualPressureSourceCallback callback =
          PressureManager_AddVirtualPressureSource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddVirtualPressureSource(        
        std::move(p_token), 
        std::move(p_source), 
        std::move(p_metadata), std::move(callback));
      return true;
    }
    case messages::PressureManager::kRemoveVirtualPressureSource: {
      internal::PressureManager_RemoveVirtualPressureSource_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_RemoveVirtualPressureSource_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PressureManager.1
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::blink::PressureSource p_source{};
      PressureManager_RemoveVirtualPressureSource_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 1, false);
        return false;
      }
      PressureManager::RemoveVirtualPressureSourceCallback callback =
          PressureManager_RemoveVirtualPressureSource_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveVirtualPressureSource(        
        std::move(p_token), 
        std::move(p_source), std::move(callback));
      return true;
    }
    case messages::PressureManager::kUpdateVirtualPressureSourceState: {
      internal::PressureManager_UpdateVirtualPressureSourceState_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_UpdateVirtualPressureSourceState_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PressureManager.2
      bool success = true;
      ::base::UnguessableToken p_token{};
      ::device::mojom::blink::PressureSource p_source{};
      ::device::mojom::blink::PressureState p_state{};
      PressureManager_UpdateVirtualPressureSourceState_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 2, false);
        return false;
      }
      PressureManager::UpdateVirtualPressureSourceStateCallback callback =
          PressureManager_UpdateVirtualPressureSourceState_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVirtualPressureSourceState(        
        std::move(p_token), 
        std::move(p_source), 
        std::move(p_state), std::move(callback));
      return true;
    }
    case messages::PressureManager::kAddClient: {
      internal::PressureManager_AddClient_Params_Data* params =
          reinterpret_cast<
              internal::PressureManager_AddClient_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for PressureManager.3
      bool success = true;
      ::device::mojom::blink::PressureSource p_source{};
      std::optional<::base::UnguessableToken> p_token{};
      PressureManager_AddClient_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSource(&p_source))
        success = false;
      if (success && !input_data_view.ReadToken(&p_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureManager::Name_, 3, false);
        return false;
      }
      PressureManager::AddClientCallback callback =
          PressureManager_AddClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddClient(        
        std::move(p_source), 
        std::move(p_token), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPressureManagerValidationInfo[] = {
    {base::to_underlying(messages::PressureManager::kAddVirtualPressureSource),
     { &internal::PressureManager_AddVirtualPressureSource_Params_Data::Validate,
      &internal::PressureManager_AddVirtualPressureSource_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PressureManager::kRemoveVirtualPressureSource),
     { &internal::PressureManager_RemoveVirtualPressureSource_Params_Data::Validate,
      &internal::PressureManager_RemoveVirtualPressureSource_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PressureManager::kUpdateVirtualPressureSourceState),
     { &internal::PressureManager_UpdateVirtualPressureSourceState_Params_Data::Validate,
      &internal::PressureManager_UpdateVirtualPressureSourceState_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::PressureManager::kAddClient),
     { &internal::PressureManager_AddClient_Params_Data::Validate,
      &internal::PressureManager_AddClient_ResponseParams_Data::Validate}},
};

bool PressureManagerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::PressureManager::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPressureManagerValidationInfo);
}

bool PressureManagerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::PressureManager::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kPressureManagerValidationInfo);

}
const char PressureClient::Name_[] = "device.mojom.PressureClient";

PressureClient::IPCStableHashFunction PressureClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PressureClient>(message.name())) {
    case messages::PressureClient::kOnPressureUpdated: {
      return &PressureClient::OnPressureUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PressureClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PressureClient>(message.name())) {
      case messages::PressureClient::kOnPressureUpdated:
            return "Receive device::mojom::PressureClient::OnPressureUpdated";
    }
  } else {
    switch (static_cast<messages::PressureClient>(message.name())) {
      case messages::PressureClient::kOnPressureUpdated:
            return "Receive reply device::mojom::PressureClient::OnPressureUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PressureClient::OnPressureUpdated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::PressureClient::OnPressureUpdated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PressureClientProxy::PressureClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PressureClientProxy::OnPressureUpdated(
    ::device::mojom::blink::PressureUpdatePtr in_update) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::PressureClient::OnPressureUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update"), in_update,
                        "<value of type ::device::mojom::blink::PressureUpdatePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PressureClient::kOnPressureUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::PressureClient_OnPressureUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->update)::BaseType> update_fragment(
          params.message());
  mojo::internal::Serialize<::device::mojom::PressureUpdateDataView>(
      in_update, update_fragment);
  params->update.Set(
      update_fragment.is_null() ? nullptr : update_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->update.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null update in PressureClient.OnPressureUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PressureClient::Name_);
  message.set_method_name("OnPressureUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PressureClientStubDispatch::Accept(
    PressureClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PressureClient>(message->header()->name)) {
    case messages::PressureClient::kOnPressureUpdated: {
      DCHECK(message->is_serialized());
      internal::PressureClient_OnPressureUpdated_Params_Data* params =
          reinterpret_cast<internal::PressureClient_OnPressureUpdated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for PressureClient.0
      bool success = true;
      ::device::mojom::blink::PressureUpdatePtr p_update{};
      PressureClient_OnPressureUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdate(&p_update))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PressureClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPressureUpdated(        
        std::move(p_update));
      return true;
    }
  }
  return false;
}

// static
bool PressureClientStubDispatch::AcceptWithResponder(
    PressureClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PressureClient>(message->header()->name)) {
    case messages::PressureClient::kOnPressureUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kPressureClientValidationInfo[] = {
    {base::to_underlying(messages::PressureClient::kOnPressureUpdated),
     { &internal::PressureClient_OnPressureUpdated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool PressureClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::blink::PressureClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kPressureClientValidationInfo);
}



}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::VirtualPressureSourceMetadata::DataView, ::device::mojom::blink::VirtualPressureSourceMetadataPtr>::Read(
    ::device::mojom::blink::VirtualPressureSourceMetadata::DataView input,
    ::device::mojom::blink::VirtualPressureSourceMetadataPtr* output) {
  bool success = true;
  ::device::mojom::blink::VirtualPressureSourceMetadataPtr result(::device::mojom::blink::VirtualPressureSourceMetadata::New());
  
      if (success)
        result->available = input.available();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::device::mojom::blink::PressureManagerAddClientResult::DataView, ::device::mojom::blink::PressureManagerAddClientResultPtr>::Read(
    ::device::mojom::blink::PressureManagerAddClientResult::DataView input,
    ::device::mojom::blink::PressureManagerAddClientResultPtr* output) {
  using UnionType = ::device::mojom::blink::PressureManagerAddClientResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kError: {
      ::device::mojom::blink::PressureManagerAddClientError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    case Tag::kPressureClient: {
      *output = UnionType::NewPressureClient(
          input.TakePressureClient<::mojo::PendingReceiver<::device::mojom::blink::PressureClient>>());
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void PressureManagerInterceptorForTesting::AddVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, VirtualPressureSourceMetadataPtr metadata, AddVirtualPressureSourceCallback callback) {
  GetForwardingInterface()->AddVirtualPressureSource(
    std::move(token)
    , 
    std::move(source)
    , 
    std::move(metadata)
    , std::move(callback));
}
void PressureManagerInterceptorForTesting::RemoveVirtualPressureSource(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, RemoveVirtualPressureSourceCallback callback) {
  GetForwardingInterface()->RemoveVirtualPressureSource(
    std::move(token)
    , 
    std::move(source)
    , std::move(callback));
}
void PressureManagerInterceptorForTesting::UpdateVirtualPressureSourceState(const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, ::device::mojom::blink::PressureState state, UpdateVirtualPressureSourceStateCallback callback) {
  GetForwardingInterface()->UpdateVirtualPressureSourceState(
    std::move(token)
    , 
    std::move(source)
    , 
    std::move(state)
    , std::move(callback));
}
void PressureManagerInterceptorForTesting::AddClient(::device::mojom::blink::PressureSource source, const std::optional<::base::UnguessableToken>& token, AddClientCallback callback) {
  GetForwardingInterface()->AddClient(
    std::move(source)
    , 
    std::move(token)
    , std::move(callback));
}
PressureManagerAsyncWaiter::PressureManagerAsyncWaiter(
    PressureManager* proxy) : proxy_(proxy) {}

PressureManagerAsyncWaiter::~PressureManagerAsyncWaiter() = default;

void PressureManagerAsyncWaiter::AddVirtualPressureSource(
    const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, VirtualPressureSourceMetadataPtr metadata) {
  base::RunLoop loop;
  proxy_->AddVirtualPressureSource(
      std::move(token),
      std::move(source),
      std::move(metadata),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PressureManagerAsyncWaiter::RemoveVirtualPressureSource(
    const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source) {
  base::RunLoop loop;
  proxy_->RemoveVirtualPressureSource(
      std::move(token),
      std::move(source),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PressureManagerAsyncWaiter::UpdateVirtualPressureSourceState(
    const ::base::UnguessableToken& token, ::device::mojom::blink::PressureSource source, ::device::mojom::blink::PressureState state) {
  base::RunLoop loop;
  proxy_->UpdateVirtualPressureSourceState(
      std::move(token),
      std::move(source),
      std::move(state),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void PressureManagerAsyncWaiter::AddClient(
    ::device::mojom::blink::PressureSource source, const std::optional<::base::UnguessableToken>& token, PressureManagerAddClientResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->AddClient(
      std::move(source),
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             PressureManagerAddClientResultPtr* out_result
,
             PressureManagerAddClientResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

PressureManagerAddClientResultPtr PressureManagerAsyncWaiter::AddClient(
    ::device::mojom::blink::PressureSource source, const std::optional<::base::UnguessableToken>& token) {
  PressureManagerAddClientResultPtr async_wait_result;
  AddClient(std::move(source),std::move(token),&async_wait_result);
  return async_wait_result;
}




void PressureClientInterceptorForTesting::OnPressureUpdated(::device::mojom::blink::PressureUpdatePtr update) {
  GetForwardingInterface()->OnPressureUpdated(
    std::move(update)
    );
}
PressureClientAsyncWaiter::PressureClientAsyncWaiter(
    PressureClient* proxy) : proxy_(proxy) {}

PressureClientAsyncWaiter::~PressureClientAsyncWaiter() = default;






}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif