// services/device/public/mojom/screen_orientation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/screen_orientation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/screen_orientation.mojom-params-data.h"
#include "services/device/public/mojom/screen_orientation.mojom-shared-message-ids.h"

#include "services/device/public/mojom/screen_orientation.mojom-import-headers.h"
#include "services/device/public/mojom/screen_orientation.mojom-test-utils.h"


namespace device::mojom {
const char ScreenOrientation::Name_[] = "device.mojom.ScreenOrientation";

ScreenOrientation::IPCStableHashFunction ScreenOrientation::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ScreenOrientation>(message.name())) {
    case messages::ScreenOrientation::kLockOrientation: {
      return &ScreenOrientation::LockOrientation_Sym::IPCStableHash;
    }
    case messages::ScreenOrientation::kUnlockOrientation: {
      return &ScreenOrientation::UnlockOrientation_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ScreenOrientation::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ScreenOrientation>(message.name())) {
      case messages::ScreenOrientation::kLockOrientation:
            return "Receive device::mojom::ScreenOrientation::LockOrientation";
      case messages::ScreenOrientation::kUnlockOrientation:
            return "Receive device::mojom::ScreenOrientation::UnlockOrientation";
    }
  } else {
    switch (static_cast<messages::ScreenOrientation>(message.name())) {
      case messages::ScreenOrientation::kLockOrientation:
            return "Receive reply device::mojom::ScreenOrientation::LockOrientation";
      case messages::ScreenOrientation::kUnlockOrientation:
            return "Receive reply device::mojom::ScreenOrientation::UnlockOrientation";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ScreenOrientation::LockOrientation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::ScreenOrientation::LockOrientation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ScreenOrientation::UnlockOrientation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::ScreenOrientation::UnlockOrientation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ScreenOrientation_LockOrientation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenOrientation_LockOrientation_ForwardToCallback(
      ScreenOrientation::LockOrientationCallback callback
      ) : callback_(std::move(callback)) {
  }

  ScreenOrientation_LockOrientation_ForwardToCallback(const ScreenOrientation_LockOrientation_ForwardToCallback&) = delete;
  ScreenOrientation_LockOrientation_ForwardToCallback& operator=(const ScreenOrientation_LockOrientation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ScreenOrientation::LockOrientationCallback callback_;
};

ScreenOrientationProxy::ScreenOrientationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenOrientationProxy::LockOrientation(
    ::device::mojom::ScreenOrientationLockType in_orientation, LockOrientationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::ScreenOrientation::LockOrientation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("orientation"), in_orientation,
                        "<value of type ::device::mojom::ScreenOrientationLockType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenOrientation::kLockOrientation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientation_LockOrientation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::ScreenOrientationLockType>(
      in_orientation, &params->orientation);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientation::Name_);
  message.set_method_name("LockOrientation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenOrientation_LockOrientation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ScreenOrientationProxy::UnlockOrientation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::ScreenOrientation::UnlockOrientation");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenOrientation::kUnlockOrientation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientation_UnlockOrientation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientation::Name_);
  message.set_method_name("UnlockOrientation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ScreenOrientation_LockOrientation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ScreenOrientation::LockOrientationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ScreenOrientation_LockOrientation_ProxyToResponder> proxy(
        new ScreenOrientation_LockOrientation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ScreenOrientation_LockOrientation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenOrientation_LockOrientation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ScreenOrientation_LockOrientation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ScreenOrientation::LockOrientationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::ScreenOrientationLockResult in_result);
};

bool ScreenOrientation_LockOrientation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ScreenOrientation_LockOrientation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenOrientation_LockOrientation_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ScreenOrientation.0
  bool success = true;
  ::device::mojom::ScreenOrientationLockResult p_result{};
  ScreenOrientation_LockOrientation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenOrientation::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ScreenOrientation_LockOrientation_ProxyToResponder::Run(
    ::device::mojom::ScreenOrientationLockResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::ScreenOrientation::LockOrientation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::device::mojom::ScreenOrientationLockResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenOrientation::kLockOrientation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientation_LockOrientation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::device::mojom::ScreenOrientationLockResult>(
      in_result, &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientation::Name_);
  message.set_method_name("LockOrientation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ScreenOrientationStubDispatch::Accept(
    ScreenOrientation* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ScreenOrientation>(message->header()->name)) {
    case messages::ScreenOrientation::kLockOrientation: {
      break;
    }
    case messages::ScreenOrientation::kUnlockOrientation: {
      DCHECK(message->is_serialized());
      internal::ScreenOrientation_UnlockOrientation_Params_Data* params =
          reinterpret_cast<internal::ScreenOrientation_UnlockOrientation_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ScreenOrientation.1
      bool success = true;
      ScreenOrientation_UnlockOrientation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenOrientation::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UnlockOrientation(        );
      return true;
    }
  }
  return false;
}

// static
bool ScreenOrientationStubDispatch::AcceptWithResponder(
    ScreenOrientation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ScreenOrientation>(message->header()->name)) {
    case messages::ScreenOrientation::kLockOrientation: {
      internal::ScreenOrientation_LockOrientation_Params_Data* params =
          reinterpret_cast<
              internal::ScreenOrientation_LockOrientation_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ScreenOrientation.0
      bool success = true;
      ::device::mojom::ScreenOrientationLockType p_orientation{};
      ScreenOrientation_LockOrientation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrientation(&p_orientation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenOrientation::Name_, 0, false);
        return false;
      }
      ScreenOrientation::LockOrientationCallback callback =
          ScreenOrientation_LockOrientation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LockOrientation(        
        std::move(p_orientation), std::move(callback));
      return true;
    }
    case messages::ScreenOrientation::kUnlockOrientation: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kScreenOrientationValidationInfo[] = {
    {base::to_underlying(messages::ScreenOrientation::kLockOrientation),
     { &internal::ScreenOrientation_LockOrientation_Params_Data::Validate,
      &internal::ScreenOrientation_LockOrientation_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::ScreenOrientation::kUnlockOrientation),
     { &internal::ScreenOrientation_UnlockOrientation_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ScreenOrientationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::ScreenOrientation::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kScreenOrientationValidationInfo);
}

bool ScreenOrientationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::ScreenOrientation::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kScreenOrientationValidationInfo);

}
const char ScreenOrientationListener::Name_[] = "device.mojom.ScreenOrientationListener";

ScreenOrientationListener::IPCStableHashFunction ScreenOrientationListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ScreenOrientationListener>(message.name())) {
    case messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser: {
      return &ScreenOrientationListener::IsAutoRotateEnabledByUser_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ScreenOrientationListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ScreenOrientationListener>(message.name())) {
      case messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser:
            return "Receive device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser";
    }
  } else {
    switch (static_cast<messages::ScreenOrientationListener>(message.name())) {
      case messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser:
            return "Receive reply device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ScreenOrientationListener::IsAutoRotateEnabledByUser_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback(
      ScreenOrientationListener::IsAutoRotateEnabledByUserCallback callback
      ) : callback_(std::move(callback)) {
  }

  ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback(const ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback&) = delete;
  ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback& operator=(const ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ScreenOrientationListener::IsAutoRotateEnabledByUserCallback callback_;
};

ScreenOrientationListenerProxy::ScreenOrientationListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenOrientationListenerProxy::IsAutoRotateEnabledByUser(
    IsAutoRotateEnabledByUserCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientationListener::Name_);
  message.set_method_name("IsAutoRotateEnabledByUser");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ScreenOrientationListener::IsAutoRotateEnabledByUserCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder> proxy(
        new ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ScreenOrientationListener::IsAutoRotateEnabledByUserCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_enabled);
};

bool ScreenOrientationListener_IsAutoRotateEnabledByUser_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for ScreenOrientationListener.0
  bool success = true;
  bool p_enabled{};
  ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_enabled = input_data_view.enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenOrientationListener::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_enabled));
  return true;
}

void ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder::Run(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::ScreenOrientationListener::IsAutoRotateEnabledByUser", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenOrientationListener::Name_);
  message.set_method_name("IsAutoRotateEnabledByUser");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ScreenOrientationListenerStubDispatch::Accept(
    ScreenOrientationListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ScreenOrientationListener>(message->header()->name)) {
    case messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser: {
      break;
    }
  }
  return false;
}

// static
bool ScreenOrientationListenerStubDispatch::AcceptWithResponder(
    ScreenOrientationListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ScreenOrientationListener>(message->header()->name)) {
    case messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser: {
      internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data* params =
          reinterpret_cast<
              internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for ScreenOrientationListener.0
      bool success = true;
      ScreenOrientationListener_IsAutoRotateEnabledByUser_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenOrientationListener::Name_, 0, false);
        return false;
      }
      ScreenOrientationListener::IsAutoRotateEnabledByUserCallback callback =
          ScreenOrientationListener_IsAutoRotateEnabledByUser_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsAutoRotateEnabledByUser(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kScreenOrientationListenerValidationInfo[] = {
    {base::to_underlying(messages::ScreenOrientationListener::kIsAutoRotateEnabledByUser),
     { &internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_Params_Data::Validate,
      &internal::ScreenOrientationListener_IsAutoRotateEnabledByUser_ResponseParams_Data::Validate}},
};

bool ScreenOrientationListenerRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::ScreenOrientationListener::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kScreenOrientationListenerValidationInfo);
}

bool ScreenOrientationListenerResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::device::mojom::ScreenOrientationListener::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kScreenOrientationListenerValidationInfo);

}


}  // device::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void ScreenOrientationInterceptorForTesting::LockOrientation(::device::mojom::ScreenOrientationLockType orientation, LockOrientationCallback callback) {
  GetForwardingInterface()->LockOrientation(
    std::move(orientation)
    , std::move(callback));
}
void ScreenOrientationInterceptorForTesting::UnlockOrientation() {
  GetForwardingInterface()->UnlockOrientation();
}
ScreenOrientationAsyncWaiter::ScreenOrientationAsyncWaiter(
    ScreenOrientation* proxy) : proxy_(proxy) {}

ScreenOrientationAsyncWaiter::~ScreenOrientationAsyncWaiter() = default;

void ScreenOrientationAsyncWaiter::LockOrientation(
    ::device::mojom::ScreenOrientationLockType orientation, ::device::mojom::ScreenOrientationLockResult* out_result) {
  base::RunLoop loop;
  proxy_->LockOrientation(
      std::move(orientation),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::ScreenOrientationLockResult* out_result
,
             ::device::mojom::ScreenOrientationLockResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::device::mojom::ScreenOrientationLockResult ScreenOrientationAsyncWaiter::LockOrientation(
    ::device::mojom::ScreenOrientationLockType orientation) {
  ::device::mojom::ScreenOrientationLockResult async_wait_result;
  LockOrientation(std::move(orientation),&async_wait_result);
  return async_wait_result;
}




void ScreenOrientationListenerInterceptorForTesting::IsAutoRotateEnabledByUser(IsAutoRotateEnabledByUserCallback callback) {
  GetForwardingInterface()->IsAutoRotateEnabledByUser(std::move(callback));
}
ScreenOrientationListenerAsyncWaiter::ScreenOrientationListenerAsyncWaiter(
    ScreenOrientationListener* proxy) : proxy_(proxy) {}

ScreenOrientationListenerAsyncWaiter::~ScreenOrientationListenerAsyncWaiter() = default;

void ScreenOrientationListenerAsyncWaiter::IsAutoRotateEnabledByUser(
    bool* out_enabled) {
  base::RunLoop loop;
  proxy_->IsAutoRotateEnabledByUser(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_enabled
,
             bool enabled) {*out_enabled = std::move(enabled);
            loop->Quit();
          },
          &loop,
          out_enabled));
  loop.Run();
}

bool ScreenOrientationListenerAsyncWaiter::IsAutoRotateEnabledByUser(
    ) {
  bool async_wait_result;
  IsAutoRotateEnabledByUser(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif