// services/network/public/mojom/host_resolver.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/host_resolver.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/host_resolver_endpoint_result.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/request_priority.mojom-shared.h"
#include "url/mojom/scheme_host_port.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class DnsOverHttpsServerConfigDataView;

class DnsOverHttpsConfigDataView;

class DnsConfigOverridesDataView;

class ResolveHostParametersDataView;

class HostResolverHostDataView;


}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::DnsOverHttpsServerConfigDataView> {
  using Data = ::network::mojom::internal::DnsOverHttpsServerConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DnsOverHttpsConfigDataView> {
  using Data = ::network::mojom::internal::DnsOverHttpsConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DnsConfigOverridesDataView> {
  using Data = ::network::mojom::internal::DnsConfigOverrides_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::ResolveHostParametersDataView> {
  using Data = ::network::mojom::internal::ResolveHostParameters_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HostResolverHostDataView> {
  using Data = ::network::mojom::internal::HostResolverHost_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class OptionalSecureDnsMode : int32_t {
  
  NO_OVERRIDE = 0,
  
  OFF = 1,
  
  AUTOMATIC = 2,
  
  SECURE = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, OptionalSecureDnsMode value);
inline bool IsKnownEnumValue(OptionalSecureDnsMode value) {
  return internal::OptionalSecureDnsMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SecureDnsMode : int32_t {
  
  OFF = 0,
  
  AUTOMATIC = 1,
  
  SECURE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SecureDnsMode value);
inline bool IsKnownEnumValue(SecureDnsMode value) {
  return internal::SecureDnsMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SecureDnsPolicy : int32_t {
  
  ALLOW = 0,
  
  DISABLE = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SecureDnsPolicy value);
inline bool IsKnownEnumValue(SecureDnsPolicy value) {
  return internal::SecureDnsPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DnsQueryType : int32_t {
  
  UNSPECIFIED = 0,
  
  A = 1,
  
  AAAA = 2,
  
  TXT = 3,
  
  PTR = 4,
  
  SRV = 5,
  
  HTTPS = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, DnsQueryType value);
inline bool IsKnownEnumValue(DnsQueryType value) {
  return internal::DnsQueryType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DnsConfigOverrides_Tristate : int32_t {
  
  NO_OVERRIDE = 0,
  
  TRISTATE_TRUE = 1,
  
  TRISTATE_FALSE = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DnsConfigOverrides_Tristate value);
inline bool IsKnownEnumValue(DnsConfigOverrides_Tristate value) {
  return internal::DnsConfigOverrides_Tristate_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolveHostParameters_Source : int32_t {
  
  ANY = 0,
  
  SYSTEM = 1,
  
  DNS = 2,
  
  MULTICAST_DNS = 3,
  
  LOCAL_ONLY = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ResolveHostParameters_Source value);
inline bool IsKnownEnumValue(ResolveHostParameters_Source value) {
  return internal::ResolveHostParameters_Source_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolveHostParameters_CacheUsage : int32_t {
  
  ALLOWED = 0,
  
  STALE_ALLOWED = 1,
  
  DISALLOWED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, ResolveHostParameters_CacheUsage value);
inline bool IsKnownEnumValue(ResolveHostParameters_CacheUsage value) {
  return internal::ResolveHostParameters_CacheUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class ResolveHostParameters_Purpose : int32_t {
  
  kUnspecified = 0,
  
  kPreconnect = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ResolveHostParameters_Purpose value);
inline bool IsKnownEnumValue(ResolveHostParameters_Purpose value) {
  return internal::ResolveHostParameters_Purpose_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class MdnsListenClient_UpdateType : int32_t {
  
  ADDED = 0,
  
  CHANGED = 1,
  
  REMOVED = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MdnsListenClient_UpdateType value);
inline bool IsKnownEnumValue(MdnsListenClient_UpdateType value) {
  return internal::MdnsListenClient_UpdateType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ResolveHostHandleInterfaceBase {};

using ResolveHostHandlePtrDataView =
    mojo::InterfacePtrDataView<ResolveHostHandleInterfaceBase>;
using ResolveHostHandleRequestDataView =
    mojo::InterfaceRequestDataView<ResolveHostHandleInterfaceBase>;
using ResolveHostHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResolveHostHandleInterfaceBase>;
using ResolveHostHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResolveHostHandleInterfaceBase>;
class ResolveHostClientInterfaceBase {};

using ResolveHostClientPtrDataView =
    mojo::InterfacePtrDataView<ResolveHostClientInterfaceBase>;
using ResolveHostClientRequestDataView =
    mojo::InterfaceRequestDataView<ResolveHostClientInterfaceBase>;
using ResolveHostClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ResolveHostClientInterfaceBase>;
using ResolveHostClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ResolveHostClientInterfaceBase>;
class MdnsListenClientInterfaceBase {};

using MdnsListenClientPtrDataView =
    mojo::InterfacePtrDataView<MdnsListenClientInterfaceBase>;
using MdnsListenClientRequestDataView =
    mojo::InterfaceRequestDataView<MdnsListenClientInterfaceBase>;
using MdnsListenClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MdnsListenClientInterfaceBase>;
using MdnsListenClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MdnsListenClientInterfaceBase>;
class HostResolverInterfaceBase {};

using HostResolverPtrDataView =
    mojo::InterfacePtrDataView<HostResolverInterfaceBase>;
using HostResolverRequestDataView =
    mojo::InterfaceRequestDataView<HostResolverInterfaceBase>;
using HostResolverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HostResolverInterfaceBase>;
using HostResolverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HostResolverInterfaceBase>;
class DnsConfigChangeManagerClientInterfaceBase {};

using DnsConfigChangeManagerClientPtrDataView =
    mojo::InterfacePtrDataView<DnsConfigChangeManagerClientInterfaceBase>;
using DnsConfigChangeManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<DnsConfigChangeManagerClientInterfaceBase>;
using DnsConfigChangeManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DnsConfigChangeManagerClientInterfaceBase>;
using DnsConfigChangeManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DnsConfigChangeManagerClientInterfaceBase>;
class DnsConfigChangeManagerInterfaceBase {};

using DnsConfigChangeManagerPtrDataView =
    mojo::InterfacePtrDataView<DnsConfigChangeManagerInterfaceBase>;
using DnsConfigChangeManagerRequestDataView =
    mojo::InterfaceRequestDataView<DnsConfigChangeManagerInterfaceBase>;
using DnsConfigChangeManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DnsConfigChangeManagerInterfaceBase>;
using DnsConfigChangeManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DnsConfigChangeManagerInterfaceBase>;


class DnsOverHttpsServerConfigDataView {
 public:
  DnsOverHttpsServerConfigDataView() = default;

  DnsOverHttpsServerConfigDataView(
      internal::DnsOverHttpsServerConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServerTemplateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerTemplate(UserType* output) {
    
    auto* pointer = data_->server_template.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEndpointsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEndpoints(UserType* output) {
    
    auto* pointer = data_->endpoints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>>(
        pointer, output, message_);
  }
 private:
  internal::DnsOverHttpsServerConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DnsOverHttpsConfigDataView {
 public:
  DnsOverHttpsConfigDataView() = default;

  DnsOverHttpsConfigDataView(
      internal::DnsOverHttpsConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetServersDataView(
      mojo::ArrayDataView<DnsOverHttpsServerConfigDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServers(UserType* output) {
    
    auto* pointer = data_->servers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::DnsOverHttpsServerConfigDataView>>(
        pointer, output, message_);
  }
 private:
  internal::DnsOverHttpsConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DnsConfigOverridesDataView {
 public:
  DnsConfigOverridesDataView() = default;

  DnsConfigOverridesDataView(
      internal::DnsConfigOverrides_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameserversDataView(
      mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNameservers(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::network::mojom::IPEndPointDataView>, UserType>(),
    "Attempting to read the optional `nameservers` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNameservers` instead "
    "of `ReadNameservers if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nameservers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
        pointer, output, message_);
  }
  inline void GetSearchDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSearch(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `search` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSearch` instead "
    "of `ReadSearch if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->search.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAppendToMultiLabelName(UserType* output) const {
    auto data_value = data_->append_to_multi_label_name;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate append_to_multi_label_name() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->append_to_multi_label_name));
  }
  int8_t ndots() const {
    return data_->ndots;
  }
  inline void GetFallbackPeriodDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFallbackPeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `fallback_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFallbackPeriod` instead "
    "of `ReadFallbackPeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->fallback_period.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  int32_t attempts() const {
    return data_->attempts;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadRotate(UserType* output) const {
    auto data_value = data_->rotate;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate rotate() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->rotate));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadUseLocalIpv6(UserType* output) const {
    auto data_value = data_->use_local_ipv6;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate use_local_ipv6() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->use_local_ipv6));
  }
  inline void GetDnsOverHttpsConfigDataView(
      DnsOverHttpsConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDnsOverHttpsConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::DnsOverHttpsConfigDataView, UserType>(),
    "Attempting to read the optional `dns_over_https_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDnsOverHttpsConfig` instead "
    "of `ReadDnsOverHttpsConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->dns_over_https_config.Get();
    return mojo::internal::Deserialize<::network::mojom::DnsOverHttpsConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSecureDnsMode(UserType* output) const {
    auto data_value = data_->secure_dns_mode;
    return mojo::internal::Deserialize<::network::mojom::OptionalSecureDnsMode>(
        data_value, output);
  }
  OptionalSecureDnsMode secure_dns_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::OptionalSecureDnsMode>(data_->secure_dns_mode));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAllowDnsOverHttpsUpgrade(UserType* output) const {
    auto data_value = data_->allow_dns_over_https_upgrade;
    return mojo::internal::Deserialize<::network::mojom::DnsConfigOverrides_Tristate>(
        data_value, output);
  }
  DnsConfigOverrides_Tristate allow_dns_over_https_upgrade() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsConfigOverrides_Tristate>(data_->allow_dns_over_https_upgrade));
  }
  bool clear_hosts() const {
    return data_->clear_hosts;
  }
 private:
  internal::DnsConfigOverrides_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ResolveHostParametersDataView {
 public:
  ResolveHostParametersDataView() = default;

  ResolveHostParametersDataView(
      internal::ResolveHostParameters_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDnsQueryType(UserType* output) const {
    auto data_value = data_->dns_query_type;
    return mojo::internal::Deserialize<::network::mojom::DnsQueryType>(
        data_value, output);
  }
  DnsQueryType dns_query_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DnsQueryType>(data_->dns_query_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialPriority(UserType* output) const {
    auto data_value = data_->initial_priority;
    return mojo::internal::Deserialize<::network::mojom::RequestPriority>(
        data_value, output);
  }
  ::network::mojom::RequestPriority initial_priority() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::RequestPriority>(data_->initial_priority));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::network::mojom::ResolveHostParameters_Source>(
        data_value, output);
  }
  ResolveHostParameters_Source source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ResolveHostParameters_Source>(data_->source));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadCacheUsage(UserType* output) const {
    auto data_value = data_->cache_usage;
    return mojo::internal::Deserialize<::network::mojom::ResolveHostParameters_CacheUsage>(
        data_value, output);
  }
  ResolveHostParameters_CacheUsage cache_usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ResolveHostParameters_CacheUsage>(data_->cache_usage));
  }
  template <typename UserType>
  UserType TakeControlHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::ResolveHostHandleInterfaceBase>>(
            &data_->control_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool include_canonical_name() const {
    return data_->include_canonical_name;
  }
  bool loopback_only() const {
    return data_->loopback_only;
  }
  bool is_speculative() const {
    return data_->is_speculative;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSecureDnsPolicy(UserType* output) const {
    auto data_value = data_->secure_dns_policy;
    return mojo::internal::Deserialize<::network::mojom::SecureDnsPolicy>(
        data_value, output);
  }
  SecureDnsPolicy secure_dns_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SecureDnsPolicy>(data_->secure_dns_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPurpose(UserType* output) const {
    auto data_value = data_->purpose;
    return mojo::internal::Deserialize<::network::mojom::ResolveHostParameters_Purpose>(
        data_value, output);
  }
  ResolveHostParameters_Purpose purpose() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ResolveHostParameters_Purpose>(data_->purpose));
  }
 private:
  internal::ResolveHostParameters_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HostResolverHostDataView {
 public:
  using Tag = internal::HostResolverHost_Data::HostResolverHost_Tag;

  HostResolverHostDataView() = default;

  HostResolverHostDataView(
      internal::HostResolverHost_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_scheme_host_port() const { return data_->tag == Tag::kSchemeHostPort; }
  inline void GetSchemeHostPortDataView(
      ::url::mojom::SchemeHostPortDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSchemeHostPort(UserType* output) const {
    
    CHECK(is_scheme_host_port());
    return mojo::internal::Deserialize<::url::mojom::SchemeHostPortDataView>(
        data_->data.f_scheme_host_port.Get(), output, message_);
  }
  bool is_host_port_pair() const { return data_->tag == Tag::kHostPortPair; }
  inline void GetHostPortPairDataView(
      ::network::mojom::HostPortPairDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadHostPortPair(UserType* output) const {
    
    CHECK(is_host_port_pair());
    return mojo::internal::Deserialize<::network::mojom::HostPortPairDataView>(
        data_->data.f_host_port_pair.Get(), output, message_);
  }

 private:
  internal::HostResolverHost_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::OptionalSecureDnsMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::OptionalSecureDnsMode> {};

template <>
struct hash<::network::mojom::SecureDnsMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::SecureDnsMode> {};

template <>
struct hash<::network::mojom::SecureDnsPolicy>
    : public mojo::internal::EnumHashImpl<::network::mojom::SecureDnsPolicy> {};

template <>
struct hash<::network::mojom::DnsQueryType>
    : public mojo::internal::EnumHashImpl<::network::mojom::DnsQueryType> {};

template <>
struct hash<::network::mojom::DnsConfigOverrides_Tristate>
    : public mojo::internal::EnumHashImpl<::network::mojom::DnsConfigOverrides_Tristate> {};

template <>
struct hash<::network::mojom::ResolveHostParameters_Source>
    : public mojo::internal::EnumHashImpl<::network::mojom::ResolveHostParameters_Source> {};

template <>
struct hash<::network::mojom::ResolveHostParameters_CacheUsage>
    : public mojo::internal::EnumHashImpl<::network::mojom::ResolveHostParameters_CacheUsage> {};

template <>
struct hash<::network::mojom::ResolveHostParameters_Purpose>
    : public mojo::internal::EnumHashImpl<::network::mojom::ResolveHostParameters_Purpose> {};

template <>
struct hash<::network::mojom::MdnsListenClient_UpdateType>
    : public mojo::internal::EnumHashImpl<::network::mojom::MdnsListenClient_UpdateType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::OptionalSecureDnsMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::OptionalSecureDnsMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::OptionalSecureDnsMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SecureDnsMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SecureDnsMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SecureDnsMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SecureDnsPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SecureDnsPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SecureDnsPolicy>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsQueryType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DnsQueryType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DnsQueryType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsConfigOverrides_Tristate, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DnsConfigOverrides_Tristate, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DnsConfigOverrides_Tristate>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParameters_Source, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ResolveHostParameters_Source, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ResolveHostParameters_Source>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParameters_CacheUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ResolveHostParameters_CacheUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ResolveHostParameters_CacheUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParameters_Purpose, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ResolveHostParameters_Purpose, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ResolveHostParameters_Purpose>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::MdnsListenClient_UpdateType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::MdnsListenClient_UpdateType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::MdnsListenClient_UpdateType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsOverHttpsServerConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsOverHttpsServerConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsOverHttpsServerConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::server_template(input)) in_server_template = Traits::server_template(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_template)::BaseType> server_template_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_server_template, server_template_fragment);
    fragment->server_template.Set(
        server_template_fragment.is_null() ? nullptr : server_template_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->server_template.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_template in DnsOverHttpsServerConfig struct");
    decltype(Traits::endpoints(input)) in_endpoints = Traits::endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->endpoints)::BaseType>
        endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>>(
        in_endpoints, endpoints_fragment, &endpoints_validate_params);
    fragment->endpoints.Set(
        endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->endpoints.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null endpoints in DnsOverHttpsServerConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::DnsOverHttpsServerConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DnsOverHttpsServerConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsOverHttpsConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsOverHttpsConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsOverHttpsConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::servers(input)) in_servers = Traits::servers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->servers)::BaseType>
        servers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& servers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::DnsOverHttpsServerConfigDataView>>(
        in_servers, servers_fragment, &servers_validate_params);
    fragment->servers.Set(
        servers_fragment.is_null() ? nullptr : servers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->servers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null servers in DnsOverHttpsConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::DnsOverHttpsConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DnsOverHttpsConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DnsConfigOverridesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DnsConfigOverridesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DnsConfigOverrides_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::nameservers(input)) in_nameservers = Traits::nameservers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nameservers)::BaseType>
        nameservers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& nameservers_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>>(
        in_nameservers, nameservers_fragment, &nameservers_validate_params);
    fragment->nameservers.Set(
        nameservers_fragment.is_null() ? nullptr : nameservers_fragment.data());
    decltype(Traits::search(input)) in_search = Traits::search(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->search)::BaseType>
        search_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& search_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_search, search_fragment, &search_validate_params);
    fragment->search.Set(
        search_fragment.is_null() ? nullptr : search_fragment.data());
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::append_to_multi_label_name(input), &fragment->append_to_multi_label_name);
    fragment->ndots = Traits::ndots(input);
    decltype(Traits::fallback_period(input)) in_fallback_period = Traits::fallback_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fallback_period)::BaseType> fallback_period_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_fallback_period, fallback_period_fragment);
    fragment->fallback_period.Set(
        fallback_period_fragment.is_null() ? nullptr : fallback_period_fragment.data());
    fragment->attempts = Traits::attempts(input);
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::rotate(input), &fragment->rotate);
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::use_local_ipv6(input), &fragment->use_local_ipv6);
    decltype(Traits::dns_over_https_config(input)) in_dns_over_https_config = Traits::dns_over_https_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dns_over_https_config)::BaseType> dns_over_https_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::DnsOverHttpsConfigDataView>(
        in_dns_over_https_config, dns_over_https_config_fragment);
    fragment->dns_over_https_config.Set(
        dns_over_https_config_fragment.is_null() ? nullptr : dns_over_https_config_fragment.data());
    mojo::internal::Serialize<::network::mojom::OptionalSecureDnsMode>(
        Traits::secure_dns_mode(input), &fragment->secure_dns_mode);
    mojo::internal::Serialize<::network::mojom::DnsConfigOverrides_Tristate>(
        Traits::allow_dns_over_https_upgrade(input), &fragment->allow_dns_over_https_upgrade);
    fragment->clear_hosts = Traits::clear_hosts(input);
  }

  static bool Deserialize(::network::mojom::internal::DnsConfigOverrides_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DnsConfigOverridesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ResolveHostParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ResolveHostParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ResolveHostParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::DnsQueryType>(
        Traits::dns_query_type(input), &fragment->dns_query_type);
    mojo::internal::Serialize<::network::mojom::RequestPriority>(
        Traits::initial_priority(input), &fragment->initial_priority);
    mojo::internal::Serialize<::network::mojom::ResolveHostParameters_Source>(
        Traits::source(input), &fragment->source);
    mojo::internal::Serialize<::network::mojom::ResolveHostParameters_CacheUsage>(
        Traits::cache_usage(input), &fragment->cache_usage);
    decltype(Traits::control_handle(input)) in_control_handle = Traits::control_handle(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ResolveHostHandleInterfaceBase>>(
        in_control_handle, &fragment->control_handle, &fragment.message());
    fragment->include_canonical_name = Traits::include_canonical_name(input);
    fragment->loopback_only = Traits::loopback_only(input);
    fragment->is_speculative = Traits::is_speculative(input);
    mojo::internal::Serialize<::network::mojom::SecureDnsPolicy>(
        Traits::secure_dns_policy(input), &fragment->secure_dns_policy);
    mojo::internal::Serialize<::network::mojom::ResolveHostParameters_Purpose>(
        Traits::purpose(input), &fragment->purpose);
  }

  static bool Deserialize(::network::mojom::internal::ResolveHostParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ResolveHostParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HostResolverHostDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::HostResolverHostDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::HostResolverHost_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::network::mojom::HostResolverHostDataView::Tag::kSchemeHostPort: {
        decltype(Traits::scheme_host_port(input))
            in_scheme_host_port = Traits::scheme_host_port(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_scheme_host_port)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::url::mojom::SchemeHostPortDataView>(
            in_scheme_host_port, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null scheme_host_port in HostResolverHost union");
        fragment->data.f_scheme_host_port.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::network::mojom::HostResolverHostDataView::Tag::kHostPortPair: {
        decltype(Traits::host_port_pair(input))
            in_host_port_pair = Traits::host_port_pair(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_host_port_pair)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
            in_host_port_pair, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null host_port_pair in HostResolverHost union");
        fragment->data.f_host_port_pair.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::network::mojom::internal::HostResolverHost_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HostResolverHostDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void DnsOverHttpsServerConfigDataView::GetServerTemplateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->server_template.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DnsOverHttpsServerConfigDataView::GetEndpointsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>* output) {
  auto pointer = data_->endpoints.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<::network::mojom::IPAddressDataView>>(pointer, message_);
}


inline void DnsOverHttpsConfigDataView::GetServersDataView(
    mojo::ArrayDataView<DnsOverHttpsServerConfigDataView>* output) {
  auto pointer = data_->servers.Get();
  *output = mojo::ArrayDataView<DnsOverHttpsServerConfigDataView>(pointer, message_);
}


inline void DnsConfigOverridesDataView::GetNameserversDataView(
    mojo::ArrayDataView<::network::mojom::IPEndPointDataView>* output) {
  auto pointer = data_->nameservers.Get();
  *output = mojo::ArrayDataView<::network::mojom::IPEndPointDataView>(pointer, message_);
}
inline void DnsConfigOverridesDataView::GetSearchDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->search.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void DnsConfigOverridesDataView::GetFallbackPeriodDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->fallback_period.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void DnsConfigOverridesDataView::GetDnsOverHttpsConfigDataView(
    DnsOverHttpsConfigDataView* output) {
  auto pointer = data_->dns_over_https_config.Get();
  *output = DnsOverHttpsConfigDataView(pointer, message_);
}




inline void HostResolverHostDataView::GetSchemeHostPortDataView(
    ::url::mojom::SchemeHostPortDataView* output) const {
  CHECK(is_scheme_host_port());
  *output = ::url::mojom::SchemeHostPortDataView(data_->data.f_scheme_host_port.Get(), message_);
}
inline void HostResolverHostDataView::GetHostPortPairDataView(
    ::network::mojom::HostPortPairDataView* output) const {
  CHECK(is_host_port_pair());
  *output = ::network::mojom::HostPortPairDataView(data_->data.f_host_port_pair.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::OptionalSecureDnsMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::OptionalSecureDnsMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SecureDnsMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SecureDnsMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SecureDnsPolicy> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SecureDnsPolicy value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DnsQueryType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DnsQueryType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DnsConfigOverrides_Tristate> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DnsConfigOverrides_Tristate value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ResolveHostParameters_Source> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_Source value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ResolveHostParameters_CacheUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_CacheUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ResolveHostParameters_Purpose> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ResolveHostParameters_Purpose value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::MdnsListenClient_UpdateType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::MdnsListenClient_UpdateType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HOST_RESOLVER_MOJOM_SHARED_H_