// services/network/public/mojom/network_context.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_context.mojom-shared-internal.h"
#include "components/ip_protection/mojom/core.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/cookie_access_observer.mojom-shared.h"
#include "services/network/public/mojom/cookie_encryption_provider.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_setting_overrides.mojom-shared.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/default_credentials.mojom-shared.h"
#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"
#include "services/network/public/mojom/devtools_observer.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets_access_delegate.mojom-shared.h"
#include "services/network/public/mojom/hash_value.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared.h"
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/isolation_info.mojom-shared.h"
#include "services/network/public/mojom/mdns_responder.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/net_log.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"
#include "services/network/public/mojom/network_context_client.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_key.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/oblivious_http_request.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/proxy_config.mojom-shared.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared.h"
#include "services/network/public/mojom/proxy_lookup_client.mojom-shared.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom-shared.h"
#include "services/network/public/mojom/reporting_service.mojom-shared.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/restricted_udp_socket.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h"
#include "services/network/public/mojom/shared_dictionary_usage_info.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/socket_broker.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/tcp_socket.mojom-shared.h"
#include "services/network/public/mojom/transferable_directory.mojom-shared.h"
#include "services/network/public/mojom/trust_token_access_observer.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/udp_socket.mojom-shared.h"
#include "services/network/public/mojom/url_loader.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "services/network/public/mojom/web_transport.mojom-shared.h"
#include "services/network/public/mojom/websocket.mojom-shared.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/p2p.mojom-shared.h"
#include "services/network/public/mojom/p2p_trusted.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class CustomProxyConfigDataView;

class CertVerifierServiceRemoteParamsDataView;

class HttpAuthStaticNetworkContextParamsDataView;

class CTPolicyDataView;

class NetworkContextFilePathsDataView;

class NetworkContextParamsDataView;

class NetworkConditionsDataView;

class SharedDictionaryInfoDataView;

class SignedExchangeReportDataView;

class URLLoaderFactoryOverrideDataView;

class URLLoaderFactoryParamsDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CustomProxyConfigDataView> {
  using Data = ::network::mojom::internal::CustomProxyConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CertVerifierServiceRemoteParamsDataView> {
  using Data = ::network::mojom::internal::CertVerifierServiceRemoteParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HttpAuthStaticNetworkContextParamsDataView> {
  using Data = ::network::mojom::internal::HttpAuthStaticNetworkContextParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::CTPolicyDataView> {
  using Data = ::network::mojom::internal::CTPolicy_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkContextFilePathsDataView> {
  using Data = ::network::mojom::internal::NetworkContextFilePaths_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkContextParamsDataView> {
  using Data = ::network::mojom::internal::NetworkContextParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkConditionsDataView> {
  using Data = ::network::mojom::internal::NetworkConditions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SharedDictionaryInfoDataView> {
  using Data = ::network::mojom::internal::SharedDictionaryInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SignedExchangeReportDataView> {
  using Data = ::network::mojom::internal::SignedExchangeReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLLoaderFactoryOverrideDataView> {
  using Data = ::network::mojom::internal::URLLoaderFactoryOverride_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::URLLoaderFactoryParamsDataView> {
  using Data = ::network::mojom::internal::URLLoaderFactoryParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class TrustTokenOperationPolicyVerdict : int32_t {
  
  kForbid = 0,
  
  kPotentiallyPermit = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenOperationPolicyVerdict value);
inline bool IsKnownEnumValue(TrustTokenOperationPolicyVerdict value) {
  return internal::TrustTokenOperationPolicyVerdict_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SCTAuditingMode : int32_t {
  
  kDisabled = 0,
  
  kEnhancedSafeBrowsingReporting = 1,
  
  kHashdance = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SCTAuditingMode value);
inline bool IsKnownEnumValue(SCTAuditingMode value) {
  return internal::SCTAuditingMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NetworkContext_DomainReliabilityClearMode : int32_t {
  
  CLEAR_CONTEXTS = 0,
  
  CLEAR_BEACONS = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, NetworkContext_DomainReliabilityClearMode value);
inline bool IsKnownEnumValue(NetworkContext_DomainReliabilityClearMode value) {
  return internal::NetworkContext_DomainReliabilityClearMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CustomProxyConnectionObserverInterfaceBase {};

using CustomProxyConnectionObserverPtrDataView =
    mojo::InterfacePtrDataView<CustomProxyConnectionObserverInterfaceBase>;
using CustomProxyConnectionObserverRequestDataView =
    mojo::InterfaceRequestDataView<CustomProxyConnectionObserverInterfaceBase>;
using CustomProxyConnectionObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomProxyConnectionObserverInterfaceBase>;
using CustomProxyConnectionObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomProxyConnectionObserverInterfaceBase>;
class CustomProxyConfigClientInterfaceBase {};

using CustomProxyConfigClientPtrDataView =
    mojo::InterfacePtrDataView<CustomProxyConfigClientInterfaceBase>;
using CustomProxyConfigClientRequestDataView =
    mojo::InterfaceRequestDataView<CustomProxyConfigClientInterfaceBase>;
using CustomProxyConfigClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CustomProxyConfigClientInterfaceBase>;
using CustomProxyConfigClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CustomProxyConfigClientInterfaceBase>;
class TrustedHeaderClientInterfaceBase {};

using TrustedHeaderClientPtrDataView =
    mojo::InterfacePtrDataView<TrustedHeaderClientInterfaceBase>;
using TrustedHeaderClientRequestDataView =
    mojo::InterfaceRequestDataView<TrustedHeaderClientInterfaceBase>;
using TrustedHeaderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TrustedHeaderClientInterfaceBase>;
using TrustedHeaderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TrustedHeaderClientInterfaceBase>;
class TrustedURLLoaderHeaderClientInterfaceBase {};

using TrustedURLLoaderHeaderClientPtrDataView =
    mojo::InterfacePtrDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
using TrustedURLLoaderHeaderClientRequestDataView =
    mojo::InterfaceRequestDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
using TrustedURLLoaderHeaderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
using TrustedURLLoaderHeaderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TrustedURLLoaderHeaderClientInterfaceBase>;
class PreloadedSharedDictionaryInfoHandleInterfaceBase {};

using PreloadedSharedDictionaryInfoHandlePtrDataView =
    mojo::InterfacePtrDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
using PreloadedSharedDictionaryInfoHandleRequestDataView =
    mojo::InterfaceRequestDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
using PreloadedSharedDictionaryInfoHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
using PreloadedSharedDictionaryInfoHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PreloadedSharedDictionaryInfoHandleInterfaceBase>;
class NetworkContextInterfaceBase {};

using NetworkContextPtrDataView =
    mojo::InterfacePtrDataView<NetworkContextInterfaceBase>;
using NetworkContextRequestDataView =
    mojo::InterfaceRequestDataView<NetworkContextInterfaceBase>;
using NetworkContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NetworkContextInterfaceBase>;
using NetworkContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NetworkContextInterfaceBase>;


class CustomProxyConfigDataView {
 public:
  CustomProxyConfigDataView() = default;

  CustomProxyConfigDataView(
      internal::CustomProxyConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRulesDataView(
      ::network::mojom::ProxyRulesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRules(UserType* output) {
    
    auto* pointer = data_->rules.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyRulesDataView>(
        pointer, output, message_);
  }
  bool should_override_existing_config() const {
    return data_->should_override_existing_config;
  }
  bool allow_non_idempotent_methods() const {
    return data_->allow_non_idempotent_methods;
  }
  inline void GetConnectTunnelHeadersDataView(
      ::network::mojom::HttpRequestHeadersDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectTunnelHeaders(UserType* output) {
    
    auto* pointer = data_->connect_tunnel_headers.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpRequestHeadersDataView>(
        pointer, output, message_);
  }
 private:
  internal::CustomProxyConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CertVerifierServiceRemoteParamsDataView {
 public:
  CertVerifierServiceRemoteParamsDataView() = default;

  CertVerifierServiceRemoteParamsDataView(
      internal::CertVerifierServiceRemoteParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeCertVerifierService() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::CertVerifierServiceInterfaceBase>>(
            &data_->cert_verifier_service, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCertVerifierServiceClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::cert_verifier::mojom::CertVerifierServiceClientInterfaceBase>>(
            &data_->cert_verifier_service_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CertVerifierServiceRemoteParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpAuthStaticNetworkContextParamsDataView {
 public:
  HttpAuthStaticNetworkContextParamsDataView() = default;

  HttpAuthStaticNetworkContextParamsDataView(
      internal::HttpAuthStaticNetworkContextParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAllowDefaultCredentials(UserType* output) const {
    auto data_value = data_->allow_default_credentials;
    return mojo::internal::Deserialize<::network::mojom::DefaultCredentials>(
        data_value, output);
  }
  ::network::mojom::DefaultCredentials allow_default_credentials() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DefaultCredentials>(data_->allow_default_credentials));
  }
 private:
  internal::HttpAuthStaticNetworkContextParams_Data* data_ = nullptr;
};


class CTPolicyDataView {
 public:
  CTPolicyDataView() = default;

  CTPolicyDataView(
      internal::CTPolicy_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetExcludedHostsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludedHosts(UserType* output) {
    
    auto* pointer = data_->excluded_hosts.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetExcludedSpkisDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludedSpkis(UserType* output) {
    
    auto* pointer = data_->excluded_spkis.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CTPolicy_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkContextFilePathsDataView {
 public:
  NetworkContextFilePathsDataView() = default;

  NetworkContextFilePathsDataView(
      internal::NetworkContextFilePaths_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSharedDictionaryDirectoryDataView(
      ::network::mojom::TransferableDirectoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedDictionaryDirectory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TransferableDirectoryDataView, UserType>(),
    "Attempting to read the optional `shared_dictionary_directory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedDictionaryDirectory` instead "
    "of `ReadSharedDictionaryDirectory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->shared_dictionary_directory.is_null() ? &data_->shared_dictionary_directory : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TransferableDirectoryDataView>(
        pointer, output, message_);
  }
  inline void GetHttpCacheDirectoryDataView(
      ::network::mojom::TransferableDirectoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpCacheDirectory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::TransferableDirectoryDataView, UserType>(),
    "Attempting to read the optional `http_cache_directory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpCacheDirectory` instead "
    "of `ReadHttpCacheDirectory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->http_cache_directory.is_null() ? &data_->http_cache_directory : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TransferableDirectoryDataView>(
        pointer, output, message_);
  }
  inline void GetDataDirectoryDataView(
      ::network::mojom::TransferableDirectoryDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDataDirectory(UserType* output) {
    
    auto* pointer = !data_->data_directory.is_null() ? &data_->data_directory : nullptr;
    return mojo::internal::Deserialize<::network::mojom::TransferableDirectoryDataView>(
        pointer, output, message_);
  }
  inline void GetUnsandboxedDataPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUnsandboxedDataPath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `unsandboxed_data_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUnsandboxedDataPath` instead "
    "of `ReadUnsandboxedDataPath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->unsandboxed_data_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetCookieDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `cookie_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieDatabaseName` instead "
    "of `ReadCookieDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetDeviceBoundSessionsDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDeviceBoundSessionsDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `device_bound_sessions_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDeviceBoundSessionsDatabaseName` instead "
    "of `ReadDeviceBoundSessionsDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->device_bound_sessions_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetTrustTokenDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `trust_token_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTrustTokenDatabaseName` instead "
    "of `ReadTrustTokenDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->trust_token_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetHttpServerPropertiesFileNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpServerPropertiesFileName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `http_server_properties_file_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpServerPropertiesFileName` instead "
    "of `ReadHttpServerPropertiesFileName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->http_server_properties_file_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetTransportSecurityPersisterFileNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransportSecurityPersisterFileName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `transport_security_persister_file_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTransportSecurityPersisterFileName` instead "
    "of `ReadTransportSecurityPersisterFileName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->transport_security_persister_file_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetReportingAndNelStoreDatabaseNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingAndNelStoreDatabaseName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `reporting_and_nel_store_database_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingAndNelStoreDatabaseName` instead "
    "of `ReadReportingAndNelStoreDatabaseName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_and_nel_store_database_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetSctAuditingPendingReportsFileNameDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSctAuditingPendingReportsFileName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `sct_auditing_pending_reports_file_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSctAuditingPendingReportsFileName` instead "
    "of `ReadSctAuditingPendingReportsFileName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->sct_auditing_pending_reports_file_name.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  bool trigger_migration() const {
    return data_->trigger_migration;
  }
 private:
  internal::NetworkContextFilePaths_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkContextParamsDataView {
 public:
  NetworkContextParamsDataView() = default;

  NetworkContextParamsDataView(
      internal::NetworkContextParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserAgentDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAgent(UserType* output) {
    
    auto* pointer = data_->user_agent.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAcceptLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAcceptLanguage(UserType* output) {
    
    auto* pointer = data_->accept_language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool enable_brotli() const {
    return data_->enable_brotli;
  }
  bool enable_zstd() const {
    return data_->enable_zstd;
  }
  bool enable_referrers() const {
    return data_->enable_referrers;
  }
  bool validate_referrer_policy_on_initial_request() const {
    return data_->validate_referrer_policy_on_initial_request;
  }
  template <typename UserType>
  UserType TakeProxyResolverFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverFactoryInterfaceBase>>(
            &data_->proxy_resolver_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool enable_encrypted_cookies() const {
    return data_->enable_encrypted_cookies;
  }
  bool restore_old_session_cookies() const {
    return data_->restore_old_session_cookies;
  }
  bool persist_session_cookies() const {
    return data_->persist_session_cookies;
  }
  bool http_cache_enabled() const {
    return data_->http_cache_enabled;
  }
  int32_t http_cache_max_size() const {
    return data_->http_cache_max_size;
  }
  template <typename UserType>
  UserType TakeHttpCacheFileOperationsFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::HttpCacheBackendFileOperationsFactoryInterfaceBase>>(
            &data_->http_cache_file_operations_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool disable_idle_sockets_close_on_memory_pressure() const {
    return data_->disable_idle_sockets_close_on_memory_pressure;
  }
  inline void GetInitialSslConfigDataView(
      ::network::mojom::SSLConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialSslConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::SSLConfigDataView, UserType>(),
    "Attempting to read the optional `initial_ssl_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialSslConfig` instead "
    "of `ReadInitialSslConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_ssl_config.Get();
    return mojo::internal::Deserialize<::network::mojom::SSLConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeSslConfigClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::SSLConfigClientInterfaceBase>>(
            &data_->ssl_config_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetInitialProxyConfigDataView(
      ::network::mojom::ProxyConfigWithAnnotationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialProxyConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ProxyConfigWithAnnotationDataView, UserType>(),
    "Attempting to read the optional `initial_proxy_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialProxyConfig` instead "
    "of `ReadInitialProxyConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_proxy_config.Get();
    return mojo::internal::Deserialize<::network::mojom::ProxyConfigWithAnnotationDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeProxyConfigClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyConfigClientInterfaceBase>>(
            &data_->proxy_config_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetInitialCustomProxyConfigDataView(
      CustomProxyConfigDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialCustomProxyConfig(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CustomProxyConfigDataView, UserType>(),
    "Attempting to read the optional `initial_custom_proxy_config` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialCustomProxyConfig` instead "
    "of `ReadInitialCustomProxyConfig if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_custom_proxy_config.Get();
    return mojo::internal::Deserialize<::network::mojom::CustomProxyConfigDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCustomProxyConfigClientReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::CustomProxyConfigClientInterfaceBase>>(
            &data_->custom_proxy_config_client_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCustomProxyConnectionObserverRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CustomProxyConnectionObserverInterfaceBase>>(
            &data_->custom_proxy_connection_observer_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeProxyConfigPollerClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ProxyConfigPollerClientInterfaceBase>>(
            &data_->proxy_config_poller_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeProxyErrorClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::ProxyErrorClientInterfaceBase>>(
            &data_->proxy_error_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeIpProtectionCoreHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::ip_protection::mojom::CoreHostInterfaceBase>>(
            &data_->ip_protection_core_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeIpProtectionControl() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::ip_protection::mojom::CoreControlInterfaceBase>>(
            &data_->ip_protection_control, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool enable_ip_protection() const {
    return data_->enable_ip_protection;
  }
  bool pac_quick_check_enabled() const {
    return data_->pac_quick_check_enabled;
  }
  bool enable_certificate_reporting() const {
    return data_->enable_certificate_reporting;
  }
  bool enforce_chrome_ct_policy() const {
    return data_->enforce_chrome_ct_policy;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSctAuditingMode(UserType* output) const {
    auto data_value = data_->sct_auditing_mode;
    return mojo::internal::Deserialize<::network::mojom::SCTAuditingMode>(
        data_value, output);
  }
  SCTAuditingMode sct_auditing_mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SCTAuditingMode>(data_->sct_auditing_mode));
  }
  inline void GetCtPolicyDataView(
      CTPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCtPolicy(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CTPolicyDataView, UserType>(),
    "Attempting to read the optional `ct_policy` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCtPolicy` instead "
    "of `ReadCtPolicy if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->ct_policy.Get();
    return mojo::internal::Deserialize<::network::mojom::CTPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetCertVerifierParamsDataView(
      CertVerifierServiceRemoteParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertVerifierParams(UserType* output) {
    
    auto* pointer = data_->cert_verifier_params.Get();
    return mojo::internal::Deserialize<::network::mojom::CertVerifierServiceRemoteParamsDataView>(
        pointer, output, message_);
  }
  inline void GetCookieManagerParamsDataView(
      ::network::mojom::CookieManagerParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieManagerParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::CookieManagerParamsDataView, UserType>(),
    "Attempting to read the optional `cookie_manager_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieManagerParams` instead "
    "of `ReadCookieManagerParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_manager_params.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieManagerParamsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCookieManager() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
            &data_->cookie_manager, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool enable_domain_reliability() const {
    return data_->enable_domain_reliability;
  }
  inline void GetDomainReliabilityUploadReporterDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainReliabilityUploadReporter(UserType* output) {
    
    auto* pointer = data_->domain_reliability_upload_reporter.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool discard_domain_reliablity_uploads() const {
    return data_->discard_domain_reliablity_uploads;
  }
  inline void GetReportingDeliveryIntervalDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportingDeliveryInterval(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::TimeDeltaDataView, UserType>(),
    "Attempting to read the optional `reporting_delivery_interval` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReportingDeliveryInterval` instead "
    "of `ReadReportingDeliveryInterval if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->reporting_delivery_interval.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  bool skip_reporting_send_permission_check() const {
    return data_->skip_reporting_send_permission_check;
  }
  inline void GetCorsOriginAccessListDataView(
      mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsOriginAccessList(UserType* output) {
    
    auto* pointer = data_->cors_origin_access_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>>(
        pointer, output, message_);
  }
  inline void GetCorsExemptHeaderListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCorsExemptHeaderList(UserType* output) {
    
    auto* pointer = data_->cors_exempt_header_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool allow_any_cors_exempt_header_for_browser() const {
    return data_->allow_any_cors_exempt_header_for_browser;
  }
  inline void GetHstsPolicyBypassListDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHstsPolicyBypassList(UserType* output) {
    
    auto* pointer = data_->hsts_policy_bypass_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetHttpAuthStaticNetworkContextParamsDataView(
      HttpAuthStaticNetworkContextParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpAuthStaticNetworkContextParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::HttpAuthStaticNetworkContextParamsDataView, UserType>(),
    "Attempting to read the optional `http_auth_static_network_context_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpAuthStaticNetworkContextParams` instead "
    "of `ReadHttpAuthStaticNetworkContextParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->http_auth_static_network_context_params.Get();
    return mojo::internal::Deserialize<::network::mojom::HttpAuthStaticNetworkContextParamsDataView>(
        pointer, output, message_);
  }
  bool reset_http_cache_backend() const {
    return data_->reset_http_cache_backend;
  }
  bool split_auth_cache_by_network_anonymization_key() const {
    return data_->split_auth_cache_by_network_anonymization_key;
  }
  bool require_network_anonymization_key() const {
    return data_->require_network_anonymization_key;
  }
  inline void GetFilePathsDataView(
      NetworkContextFilePathsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilePaths(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::NetworkContextFilePathsDataView, UserType>(),
    "Attempting to read the optional `file_paths` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFilePaths` instead "
    "of `ReadFilePaths if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_paths.Get();
    return mojo::internal::Deserialize<::network::mojom::NetworkContextFilePathsDataView>(
        pointer, output, message_);
  }
  bool block_trust_tokens() const {
    return data_->block_trust_tokens;
  }
  bool shared_dictionary_enabled() const {
    return data_->shared_dictionary_enabled;
  }
  uint64_t shared_dictionary_cache_max_size() const {
    return data_->shared_dictionary_cache_max_size;
  }
  inline void GetFirstPartySetsAccessDelegateParamsDataView(
      ::network::mojom::FirstPartySetsAccessDelegateParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstPartySetsAccessDelegateParams(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::FirstPartySetsAccessDelegateParamsDataView, UserType>(),
    "Attempting to read the optional `first_party_sets_access_delegate_params` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFirstPartySetsAccessDelegateParams` instead "
    "of `ReadFirstPartySetsAccessDelegateParams if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->first_party_sets_access_delegate_params.Get();
    return mojo::internal::Deserialize<::network::mojom::FirstPartySetsAccessDelegateParamsDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeFirstPartySetsAccessDelegateReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::FirstPartySetsAccessDelegateInterfaceBase>>(
            &data_->first_party_sets_access_delegate_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool acam_preflight_spec_conformant() const {
    return data_->acam_preflight_spec_conformant;
  }
  inline void GetCookieDeprecationLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieDeprecationLabel(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `cookie_deprecation_label` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCookieDeprecationLabel` instead "
    "of `ReadCookieDeprecationLabel if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->cookie_deprecation_label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCookieEncryptionProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieEncryptionProviderInterfaceBase>>(
            &data_->cookie_encryption_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool device_bound_sessions_enabled() const {
    return data_->device_bound_sessions_enabled;
  }
  int64_t bound_network() const {
    return data_->bound_network;
  }
  inline void GetEnterpriseReportingEndpointsDataView(
      mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnterpriseReportingEndpoints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>, UserType>(),
    "Attempting to read the optional `enterprise_reporting_endpoints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEnterpriseReportingEndpoints` instead "
    "of `ReadEnterpriseReportingEndpoints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->enterprise_reporting_endpoints.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::NetworkContextParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkConditionsDataView {
 public:
  NetworkConditionsDataView() = default;

  NetworkConditionsDataView(
      internal::NetworkConditions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool offline() const {
    return data_->offline;
  }
  inline void GetLatencyDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLatency(UserType* output) {
    
    auto* pointer = data_->latency.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  double download_throughput() const {
    return data_->download_throughput;
  }
  double upload_throughput() const {
    return data_->upload_throughput;
  }
  double packet_loss() const {
    return data_->packet_loss;
  }
  int32_t packet_queue_length() const {
    return data_->packet_queue_length;
  }
  bool packet_reordering() const {
    return data_->packet_reordering;
  }
 private:
  internal::NetworkConditions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedDictionaryInfoDataView {
 public:
  SharedDictionaryInfoDataView() = default;

  SharedDictionaryInfoDataView(
      internal::SharedDictionaryInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMatchDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatch(UserType* output) {
    
    auto* pointer = data_->match.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMatchDestDataView(
      mojo::ArrayDataView<::network::mojom::RequestDestination>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMatchDest(UserType* output) {
    
    auto* pointer = data_->match_dest.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::RequestDestination>>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDictionaryUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDictionaryUrl(UserType* output) {
    
    auto* pointer = data_->dictionary_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLastFetchTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastFetchTime(UserType* output) {
    
    auto* pointer = data_->last_fetch_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetResponseTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseTime(UserType* output) {
    
    auto* pointer = data_->response_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLastUsedTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLastUsedTime(UserType* output) {
    
    auto* pointer = data_->last_used_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  uint64_t size() const {
    return data_->size;
  }
  inline void GetHashDataView(
      ::network::mojom::SHA256HashValueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHash(UserType* output) {
    
    auto* pointer = data_->hash.Get();
    return mojo::internal::Deserialize<::network::mojom::SHA256HashValueDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedDictionaryInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SignedExchangeReportDataView {
 public:
  SignedExchangeReportDataView() = default;

  SignedExchangeReportDataView(
      internal::SignedExchangeReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOuterUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOuterUrl(UserType* output) {
    
    auto* pointer = data_->outer_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInnerUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInnerUrl(UserType* output) {
    
    auto* pointer = data_->inner_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCertUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertUrl(UserType* output) {
    
    auto* pointer = data_->cert_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetServerIpAddressDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerIpAddress(UserType* output) {
    
    auto* pointer = data_->server_ip_address.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
  inline void GetProtocolDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) {
    
    auto* pointer = data_->protocol.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMethodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMethod(UserType* output) {
    
    auto* pointer = data_->method.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t status_code() const {
    return data_->status_code;
  }
  inline void GetElapsedTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElapsedTime(UserType* output) {
    
    auto* pointer = data_->elapsed_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::SignedExchangeReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderFactoryOverrideDataView {
 public:
  URLLoaderFactoryOverrideDataView() = default;

  URLLoaderFactoryOverrideDataView(
      internal::URLLoaderFactoryOverride_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeOverridingFactory() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->overriding_factory, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeOverriddenFactoryReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
            &data_->overridden_factory_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool skip_cors_enabled_scheme_check() const {
    return data_->skip_cors_enabled_scheme_check;
  }
 private:
  internal::URLLoaderFactoryOverride_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLLoaderFactoryParamsDataView {
 public:
  URLLoaderFactoryParamsDataView() = default;

  URLLoaderFactoryParamsDataView(
      internal::URLLoaderFactoryParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t process_id() const {
    return data_->process_id;
  }
  inline void GetRequestInitiatorOriginLockDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestInitiatorOriginLock(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `request_initiator_origin_lock` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestInitiatorOriginLock` instead "
    "of `ReadRequestInitiatorOriginLock if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_initiator_origin_lock.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  bool is_orb_enabled() const {
    return data_->is_orb_enabled;
  }
  bool ignore_isolated_world_origin() const {
    return data_->ignore_isolated_world_origin;
  }
  bool unsafe_non_webby_initiator() const {
    return data_->unsafe_non_webby_initiator;
  }
  bool disable_web_security() const {
    return data_->disable_web_security;
  }
  template <typename UserType>
  UserType TakeHeaderClient() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::TrustedURLLoaderHeaderClientInterfaceBase>>(
            &data_->header_client, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetIsolationInfoDataView(
      ::network::mojom::IsolationInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsolationInfo(UserType* output) {
    
    auto* pointer = data_->isolation_info.Get();
    return mojo::internal::Deserialize<::network::mojom::IsolationInfoDataView>(
        pointer, output, message_);
  }
  bool disable_secure_dns() const {
    return data_->disable_secure_dns;
  }
  bool is_trusted() const {
    return data_->is_trusted;
  }
  bool automatically_assign_isolation_info() const {
    return data_->automatically_assign_isolation_info;
  }
  inline void GetTopFrameIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `top_frame_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTopFrameId` instead "
    "of `ReadTopFrameId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->top_frame_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFactoryOverrideDataView(
      URLLoaderFactoryOverrideDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFactoryOverride(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLLoaderFactoryOverrideDataView, UserType>(),
    "Attempting to read the optional `factory_override` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFactoryOverride` instead "
    "of `ReadFactoryOverride if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->factory_override.Get();
    return mojo::internal::Deserialize<::network::mojom::URLLoaderFactoryOverrideDataView>(
        pointer, output, message_);
  }
  inline void GetClientSecurityStateDataView(
      ::network::mojom::ClientSecurityStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadClientSecurityState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::ClientSecurityStateDataView, UserType>(),
    "Attempting to read the optional `client_security_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadClientSecurityState` instead "
    "of `ReadClientSecurityState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->client_security_state.Get();
    return mojo::internal::Deserialize<::network::mojom::ClientSecurityStateDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeCoepReporter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
            &data_->coep_reporter, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDipReporter() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DocumentIsolationPolicyReporterInterfaceBase>>(
            &data_->dip_reporter, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeCookieObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
            &data_->cookie_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeTrustTokenObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
            &data_->trust_token_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeSharedDictionaryObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
            &data_->shared_dictionary_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeUrlLoaderNetworkObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
            &data_->url_loader_network_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDevtoolsObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
            &data_->devtools_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeDeviceBoundSessionObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
            &data_->device_bound_session_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenIssuancePolicy(UserType* output) const {
    auto data_value = data_->trust_token_issuance_policy;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        data_value, output);
  }
  TrustTokenOperationPolicyVerdict trust_token_issuance_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationPolicyVerdict>(data_->trust_token_issuance_policy));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustTokenRedemptionPolicy(UserType* output) const {
    auto data_value = data_->trust_token_redemption_policy;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        data_value, output);
  }
  TrustTokenOperationPolicyVerdict trust_token_redemption_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::TrustTokenOperationPolicyVerdict>(data_->trust_token_redemption_policy));
  }
  inline void GetDebugTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugTag(UserType* output) {
    
    auto* pointer = data_->debug_tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCookieSettingOverridesDataView(
      ::network::mojom::CookieSettingOverridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieSettingOverrides(UserType* output) {
    
    auto* pointer = data_->cookie_setting_overrides.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSettingOverridesDataView>(
        pointer, output, message_);
  }
  inline void GetDevtoolsCookieSettingOverridesDataView(
      ::network::mojom::CookieSettingOverridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsCookieSettingOverrides(UserType* output) {
    
    auto* pointer = data_->devtools_cookie_setting_overrides.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSettingOverridesDataView>(
        pointer, output, message_);
  }
  bool require_cross_site_request_for_cookies() const {
    return data_->require_cross_site_request_for_cookies;
  }
 private:
  internal::URLLoaderFactoryParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::TrustTokenOperationPolicyVerdict>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenOperationPolicyVerdict> {};

template <>
struct hash<::network::mojom::SCTAuditingMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::SCTAuditingMode> {};

template <>
struct hash<::network::mojom::NetworkContext_DomainReliabilityClearMode>
    : public mojo::internal::EnumHashImpl<::network::mojom::NetworkContext_DomainReliabilityClearMode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenOperationPolicyVerdict, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenOperationPolicyVerdict, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::TrustTokenOperationPolicyVerdict>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SCTAuditingMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SCTAuditingMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SCTAuditingMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkContext_DomainReliabilityClearMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::NetworkContext_DomainReliabilityClearMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::NetworkContext_DomainReliabilityClearMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CustomProxyConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CustomProxyConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CustomProxyConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::rules(input)) in_rules = Traits::rules(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rules)::BaseType> rules_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyRulesDataView>(
        in_rules, rules_fragment);
    fragment->rules.Set(
        rules_fragment.is_null() ? nullptr : rules_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->rules.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rules in CustomProxyConfig struct");
    fragment->should_override_existing_config = Traits::should_override_existing_config(input);
    fragment->allow_non_idempotent_methods = Traits::allow_non_idempotent_methods(input);
    decltype(Traits::connect_tunnel_headers(input)) in_connect_tunnel_headers = Traits::connect_tunnel_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->connect_tunnel_headers)::BaseType> connect_tunnel_headers_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
        in_connect_tunnel_headers, connect_tunnel_headers_fragment);
    fragment->connect_tunnel_headers.Set(
        connect_tunnel_headers_fragment.is_null() ? nullptr : connect_tunnel_headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->connect_tunnel_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connect_tunnel_headers in CustomProxyConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::CustomProxyConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CustomProxyConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CertVerifierServiceRemoteParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CertVerifierServiceRemoteParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CertVerifierServiceRemoteParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::cert_verifier_service(input)) in_cert_verifier_service = Traits::cert_verifier_service(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::cert_verifier::mojom::CertVerifierServiceInterfaceBase>>(
        in_cert_verifier_service, &fragment->cert_verifier_service, &fragment.message());
    decltype(Traits::cert_verifier_service_client_receiver(input)) in_cert_verifier_service_client_receiver = Traits::cert_verifier_service_client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::cert_verifier::mojom::CertVerifierServiceClientInterfaceBase>>(
        in_cert_verifier_service_client_receiver, &fragment->cert_verifier_service_client_receiver, &fragment.message());
  }

  static bool Deserialize(::network::mojom::internal::CertVerifierServiceRemoteParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CertVerifierServiceRemoteParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpAuthStaticNetworkContextParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpAuthStaticNetworkContextParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpAuthStaticNetworkContextParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::DefaultCredentials>(
        Traits::allow_default_credentials(input), &fragment->allow_default_credentials);
  }

  static bool Deserialize(::network::mojom::internal::HttpAuthStaticNetworkContextParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HttpAuthStaticNetworkContextParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CTPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CTPolicyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CTPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::excluded_hosts(input)) in_excluded_hosts = Traits::excluded_hosts(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->excluded_hosts)::BaseType>
        excluded_hosts_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& excluded_hosts_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_excluded_hosts, excluded_hosts_fragment, &excluded_hosts_validate_params);
    fragment->excluded_hosts.Set(
        excluded_hosts_fragment.is_null() ? nullptr : excluded_hosts_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->excluded_hosts.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null excluded_hosts in CTPolicy struct");
    decltype(Traits::excluded_spkis(input)) in_excluded_spkis = Traits::excluded_spkis(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->excluded_spkis)::BaseType>
        excluded_spkis_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& excluded_spkis_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_excluded_spkis, excluded_spkis_fragment, &excluded_spkis_validate_params);
    fragment->excluded_spkis.Set(
        excluded_spkis_fragment.is_null() ? nullptr : excluded_spkis_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->excluded_spkis.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null excluded_spkis in CTPolicy struct");
  }

  static bool Deserialize(::network::mojom::internal::CTPolicy_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CTPolicyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkContextFilePathsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkContextFilePathsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkContextFilePaths_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::shared_dictionary_directory(input)) in_shared_dictionary_directory = Traits::shared_dictionary_directory(input);
    mojo::internal::MessageFragment<decltype(fragment->shared_dictionary_directory)>
        shared_dictionary_directory_fragment(fragment.message());
    shared_dictionary_directory_fragment.Claim(&fragment->shared_dictionary_directory);
    mojo::internal::Serialize<::network::mojom::TransferableDirectoryDataView>(
        in_shared_dictionary_directory, shared_dictionary_directory_fragment, true);
    decltype(Traits::http_cache_directory(input)) in_http_cache_directory = Traits::http_cache_directory(input);
    mojo::internal::MessageFragment<decltype(fragment->http_cache_directory)>
        http_cache_directory_fragment(fragment.message());
    http_cache_directory_fragment.Claim(&fragment->http_cache_directory);
    mojo::internal::Serialize<::network::mojom::TransferableDirectoryDataView>(
        in_http_cache_directory, http_cache_directory_fragment, true);
    decltype(Traits::data_directory(input)) in_data_directory = Traits::data_directory(input);
    mojo::internal::MessageFragment<decltype(fragment->data_directory)>
        data_directory_fragment(fragment.message());
    data_directory_fragment.Claim(&fragment->data_directory);
    mojo::internal::Serialize<::network::mojom::TransferableDirectoryDataView>(
        in_data_directory, data_directory_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data_directory.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data_directory in NetworkContextFilePaths struct");
    decltype(Traits::unsandboxed_data_path(input)) in_unsandboxed_data_path = Traits::unsandboxed_data_path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->unsandboxed_data_path)::BaseType> unsandboxed_data_path_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_unsandboxed_data_path, unsandboxed_data_path_fragment);
    fragment->unsandboxed_data_path.Set(
        unsandboxed_data_path_fragment.is_null() ? nullptr : unsandboxed_data_path_fragment.data());
    decltype(Traits::cookie_database_name(input)) in_cookie_database_name = Traits::cookie_database_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_database_name)::BaseType> cookie_database_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_cookie_database_name, cookie_database_name_fragment);
    fragment->cookie_database_name.Set(
        cookie_database_name_fragment.is_null() ? nullptr : cookie_database_name_fragment.data());
    decltype(Traits::device_bound_sessions_database_name(input)) in_device_bound_sessions_database_name = Traits::device_bound_sessions_database_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->device_bound_sessions_database_name)::BaseType> device_bound_sessions_database_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_device_bound_sessions_database_name, device_bound_sessions_database_name_fragment);
    fragment->device_bound_sessions_database_name.Set(
        device_bound_sessions_database_name_fragment.is_null() ? nullptr : device_bound_sessions_database_name_fragment.data());
    decltype(Traits::trust_token_database_name(input)) in_trust_token_database_name = Traits::trust_token_database_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_token_database_name)::BaseType> trust_token_database_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_trust_token_database_name, trust_token_database_name_fragment);
    fragment->trust_token_database_name.Set(
        trust_token_database_name_fragment.is_null() ? nullptr : trust_token_database_name_fragment.data());
    decltype(Traits::http_server_properties_file_name(input)) in_http_server_properties_file_name = Traits::http_server_properties_file_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->http_server_properties_file_name)::BaseType> http_server_properties_file_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_http_server_properties_file_name, http_server_properties_file_name_fragment);
    fragment->http_server_properties_file_name.Set(
        http_server_properties_file_name_fragment.is_null() ? nullptr : http_server_properties_file_name_fragment.data());
    decltype(Traits::transport_security_persister_file_name(input)) in_transport_security_persister_file_name = Traits::transport_security_persister_file_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transport_security_persister_file_name)::BaseType> transport_security_persister_file_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_transport_security_persister_file_name, transport_security_persister_file_name_fragment);
    fragment->transport_security_persister_file_name.Set(
        transport_security_persister_file_name_fragment.is_null() ? nullptr : transport_security_persister_file_name_fragment.data());
    decltype(Traits::reporting_and_nel_store_database_name(input)) in_reporting_and_nel_store_database_name = Traits::reporting_and_nel_store_database_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_and_nel_store_database_name)::BaseType> reporting_and_nel_store_database_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_reporting_and_nel_store_database_name, reporting_and_nel_store_database_name_fragment);
    fragment->reporting_and_nel_store_database_name.Set(
        reporting_and_nel_store_database_name_fragment.is_null() ? nullptr : reporting_and_nel_store_database_name_fragment.data());
    decltype(Traits::sct_auditing_pending_reports_file_name(input)) in_sct_auditing_pending_reports_file_name = Traits::sct_auditing_pending_reports_file_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sct_auditing_pending_reports_file_name)::BaseType> sct_auditing_pending_reports_file_name_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_sct_auditing_pending_reports_file_name, sct_auditing_pending_reports_file_name_fragment);
    fragment->sct_auditing_pending_reports_file_name.Set(
        sct_auditing_pending_reports_file_name_fragment.is_null() ? nullptr : sct_auditing_pending_reports_file_name_fragment.data());
    fragment->trigger_migration = Traits::trigger_migration(input);
  }

  static bool Deserialize(::network::mojom::internal::NetworkContextFilePaths_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkContextFilePathsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkContextParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkContextParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkContextParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::user_agent(input)) in_user_agent = Traits::user_agent(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_agent)::BaseType> user_agent_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_user_agent, user_agent_fragment);
    fragment->user_agent.Set(
        user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->user_agent.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_agent in NetworkContextParams struct");
    decltype(Traits::accept_language(input)) in_accept_language = Traits::accept_language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->accept_language)::BaseType> accept_language_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_accept_language, accept_language_fragment);
    fragment->accept_language.Set(
        accept_language_fragment.is_null() ? nullptr : accept_language_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->accept_language.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null accept_language in NetworkContextParams struct");
    fragment->enable_brotli = Traits::enable_brotli(input);
    fragment->enable_zstd = Traits::enable_zstd(input);
    fragment->enable_referrers = Traits::enable_referrers(input);
    fragment->validate_referrer_policy_on_initial_request = Traits::validate_referrer_policy_on_initial_request(input);
    decltype(Traits::proxy_resolver_factory(input)) in_proxy_resolver_factory = Traits::proxy_resolver_factory(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::proxy_resolver::mojom::ProxyResolverFactoryInterfaceBase>>(
        in_proxy_resolver_factory, &fragment->proxy_resolver_factory, &fragment.message());
    fragment->enable_encrypted_cookies = Traits::enable_encrypted_cookies(input);
    fragment->restore_old_session_cookies = Traits::restore_old_session_cookies(input);
    fragment->persist_session_cookies = Traits::persist_session_cookies(input);
    fragment->http_cache_enabled = Traits::http_cache_enabled(input);
    fragment->http_cache_max_size = Traits::http_cache_max_size(input);
    decltype(Traits::http_cache_file_operations_factory(input)) in_http_cache_file_operations_factory = Traits::http_cache_file_operations_factory(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::HttpCacheBackendFileOperationsFactoryInterfaceBase>>(
        in_http_cache_file_operations_factory, &fragment->http_cache_file_operations_factory, &fragment.message());
    fragment->disable_idle_sockets_close_on_memory_pressure = Traits::disable_idle_sockets_close_on_memory_pressure(input);
    decltype(Traits::initial_ssl_config(input)) in_initial_ssl_config = Traits::initial_ssl_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_ssl_config)::BaseType> initial_ssl_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SSLConfigDataView>(
        in_initial_ssl_config, initial_ssl_config_fragment);
    fragment->initial_ssl_config.Set(
        initial_ssl_config_fragment.is_null() ? nullptr : initial_ssl_config_fragment.data());
    decltype(Traits::ssl_config_client_receiver(input)) in_ssl_config_client_receiver = Traits::ssl_config_client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::SSLConfigClientInterfaceBase>>(
        in_ssl_config_client_receiver, &fragment->ssl_config_client_receiver, &fragment.message());
    decltype(Traits::initial_proxy_config(input)) in_initial_proxy_config = Traits::initial_proxy_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_proxy_config)::BaseType> initial_proxy_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ProxyConfigWithAnnotationDataView>(
        in_initial_proxy_config, initial_proxy_config_fragment);
    fragment->initial_proxy_config.Set(
        initial_proxy_config_fragment.is_null() ? nullptr : initial_proxy_config_fragment.data());
    decltype(Traits::proxy_config_client_receiver(input)) in_proxy_config_client_receiver = Traits::proxy_config_client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyConfigClientInterfaceBase>>(
        in_proxy_config_client_receiver, &fragment->proxy_config_client_receiver, &fragment.message());
    decltype(Traits::initial_custom_proxy_config(input)) in_initial_custom_proxy_config = Traits::initial_custom_proxy_config(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_custom_proxy_config)::BaseType> initial_custom_proxy_config_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CustomProxyConfigDataView>(
        in_initial_custom_proxy_config, initial_custom_proxy_config_fragment);
    fragment->initial_custom_proxy_config.Set(
        initial_custom_proxy_config_fragment.is_null() ? nullptr : initial_custom_proxy_config_fragment.data());
    decltype(Traits::custom_proxy_config_client_receiver(input)) in_custom_proxy_config_client_receiver = Traits::custom_proxy_config_client_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CustomProxyConfigClientInterfaceBase>>(
        in_custom_proxy_config_client_receiver, &fragment->custom_proxy_config_client_receiver, &fragment.message());
    decltype(Traits::custom_proxy_connection_observer_remote(input)) in_custom_proxy_connection_observer_remote = Traits::custom_proxy_connection_observer_remote(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CustomProxyConnectionObserverInterfaceBase>>(
        in_custom_proxy_connection_observer_remote, &fragment->custom_proxy_connection_observer_remote, &fragment.message());
    decltype(Traits::proxy_config_poller_client(input)) in_proxy_config_poller_client = Traits::proxy_config_poller_client(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ProxyConfigPollerClientInterfaceBase>>(
        in_proxy_config_poller_client, &fragment->proxy_config_poller_client, &fragment.message());
    decltype(Traits::proxy_error_client(input)) in_proxy_error_client = Traits::proxy_error_client(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ProxyErrorClientInterfaceBase>>(
        in_proxy_error_client, &fragment->proxy_error_client, &fragment.message());
    decltype(Traits::ip_protection_core_host(input)) in_ip_protection_core_host = Traits::ip_protection_core_host(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::ip_protection::mojom::CoreHostInterfaceBase>>(
        in_ip_protection_core_host, &fragment->ip_protection_core_host, &fragment.message());
    decltype(Traits::ip_protection_control(input)) in_ip_protection_control = Traits::ip_protection_control(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::ip_protection::mojom::CoreControlInterfaceBase>>(
        in_ip_protection_control, &fragment->ip_protection_control, &fragment.message());
    fragment->enable_ip_protection = Traits::enable_ip_protection(input);
    fragment->pac_quick_check_enabled = Traits::pac_quick_check_enabled(input);
    fragment->enable_certificate_reporting = Traits::enable_certificate_reporting(input);
    fragment->enforce_chrome_ct_policy = Traits::enforce_chrome_ct_policy(input);
    mojo::internal::Serialize<::network::mojom::SCTAuditingMode>(
        Traits::sct_auditing_mode(input), &fragment->sct_auditing_mode);
    decltype(Traits::ct_policy(input)) in_ct_policy = Traits::ct_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ct_policy)::BaseType> ct_policy_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CTPolicyDataView>(
        in_ct_policy, ct_policy_fragment);
    fragment->ct_policy.Set(
        ct_policy_fragment.is_null() ? nullptr : ct_policy_fragment.data());
    decltype(Traits::cert_verifier_params(input)) in_cert_verifier_params = Traits::cert_verifier_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cert_verifier_params)::BaseType> cert_verifier_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CertVerifierServiceRemoteParamsDataView>(
        in_cert_verifier_params, cert_verifier_params_fragment);
    fragment->cert_verifier_params.Set(
        cert_verifier_params_fragment.is_null() ? nullptr : cert_verifier_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cert_verifier_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert_verifier_params in NetworkContextParams struct");
    decltype(Traits::cookie_manager_params(input)) in_cookie_manager_params = Traits::cookie_manager_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_manager_params)::BaseType> cookie_manager_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CookieManagerParamsDataView>(
        in_cookie_manager_params, cookie_manager_params_fragment);
    fragment->cookie_manager_params.Set(
        cookie_manager_params_fragment.is_null() ? nullptr : cookie_manager_params_fragment.data());
    decltype(Traits::cookie_manager(input)) in_cookie_manager = Traits::cookie_manager(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
        in_cookie_manager, &fragment->cookie_manager, &fragment.message());
    fragment->enable_domain_reliability = Traits::enable_domain_reliability(input);
    decltype(Traits::domain_reliability_upload_reporter(input)) in_domain_reliability_upload_reporter = Traits::domain_reliability_upload_reporter(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain_reliability_upload_reporter)::BaseType> domain_reliability_upload_reporter_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_domain_reliability_upload_reporter, domain_reliability_upload_reporter_fragment);
    fragment->domain_reliability_upload_reporter.Set(
        domain_reliability_upload_reporter_fragment.is_null() ? nullptr : domain_reliability_upload_reporter_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->domain_reliability_upload_reporter.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain_reliability_upload_reporter in NetworkContextParams struct");
    fragment->discard_domain_reliablity_uploads = Traits::discard_domain_reliablity_uploads(input);
    decltype(Traits::reporting_delivery_interval(input)) in_reporting_delivery_interval = Traits::reporting_delivery_interval(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_delivery_interval)::BaseType> reporting_delivery_interval_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_reporting_delivery_interval, reporting_delivery_interval_fragment);
    fragment->reporting_delivery_interval.Set(
        reporting_delivery_interval_fragment.is_null() ? nullptr : reporting_delivery_interval_fragment.data());
    fragment->skip_reporting_send_permission_check = Traits::skip_reporting_send_permission_check(input);
    decltype(Traits::cors_origin_access_list(input)) in_cors_origin_access_list = Traits::cors_origin_access_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cors_origin_access_list)::BaseType>
        cors_origin_access_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cors_origin_access_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>>(
        in_cors_origin_access_list, cors_origin_access_list_fragment, &cors_origin_access_list_validate_params);
    fragment->cors_origin_access_list.Set(
        cors_origin_access_list_fragment.is_null() ? nullptr : cors_origin_access_list_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cors_origin_access_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cors_origin_access_list in NetworkContextParams struct");
    decltype(Traits::cors_exempt_header_list(input)) in_cors_exempt_header_list = Traits::cors_exempt_header_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cors_exempt_header_list)::BaseType>
        cors_exempt_header_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cors_exempt_header_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_cors_exempt_header_list, cors_exempt_header_list_fragment, &cors_exempt_header_list_validate_params);
    fragment->cors_exempt_header_list.Set(
        cors_exempt_header_list_fragment.is_null() ? nullptr : cors_exempt_header_list_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cors_exempt_header_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cors_exempt_header_list in NetworkContextParams struct");
    fragment->allow_any_cors_exempt_header_for_browser = Traits::allow_any_cors_exempt_header_for_browser(input);
    decltype(Traits::hsts_policy_bypass_list(input)) in_hsts_policy_bypass_list = Traits::hsts_policy_bypass_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hsts_policy_bypass_list)::BaseType>
        hsts_policy_bypass_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hsts_policy_bypass_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_hsts_policy_bypass_list, hsts_policy_bypass_list_fragment, &hsts_policy_bypass_list_validate_params);
    fragment->hsts_policy_bypass_list.Set(
        hsts_policy_bypass_list_fragment.is_null() ? nullptr : hsts_policy_bypass_list_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hsts_policy_bypass_list.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hsts_policy_bypass_list in NetworkContextParams struct");
    decltype(Traits::http_auth_static_network_context_params(input)) in_http_auth_static_network_context_params = Traits::http_auth_static_network_context_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->http_auth_static_network_context_params)::BaseType> http_auth_static_network_context_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::HttpAuthStaticNetworkContextParamsDataView>(
        in_http_auth_static_network_context_params, http_auth_static_network_context_params_fragment);
    fragment->http_auth_static_network_context_params.Set(
        http_auth_static_network_context_params_fragment.is_null() ? nullptr : http_auth_static_network_context_params_fragment.data());
    fragment->reset_http_cache_backend = Traits::reset_http_cache_backend(input);
    fragment->split_auth_cache_by_network_anonymization_key = Traits::split_auth_cache_by_network_anonymization_key(input);
    fragment->require_network_anonymization_key = Traits::require_network_anonymization_key(input);
    decltype(Traits::file_paths(input)) in_file_paths = Traits::file_paths(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_paths)::BaseType> file_paths_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::NetworkContextFilePathsDataView>(
        in_file_paths, file_paths_fragment);
    fragment->file_paths.Set(
        file_paths_fragment.is_null() ? nullptr : file_paths_fragment.data());
    fragment->block_trust_tokens = Traits::block_trust_tokens(input);
    fragment->shared_dictionary_enabled = Traits::shared_dictionary_enabled(input);
    fragment->shared_dictionary_cache_max_size = Traits::shared_dictionary_cache_max_size(input);
    decltype(Traits::first_party_sets_access_delegate_params(input)) in_first_party_sets_access_delegate_params = Traits::first_party_sets_access_delegate_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->first_party_sets_access_delegate_params)::BaseType> first_party_sets_access_delegate_params_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::FirstPartySetsAccessDelegateParamsDataView>(
        in_first_party_sets_access_delegate_params, first_party_sets_access_delegate_params_fragment);
    fragment->first_party_sets_access_delegate_params.Set(
        first_party_sets_access_delegate_params_fragment.is_null() ? nullptr : first_party_sets_access_delegate_params_fragment.data());
    decltype(Traits::first_party_sets_access_delegate_receiver(input)) in_first_party_sets_access_delegate_receiver = Traits::first_party_sets_access_delegate_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::FirstPartySetsAccessDelegateInterfaceBase>>(
        in_first_party_sets_access_delegate_receiver, &fragment->first_party_sets_access_delegate_receiver, &fragment.message());
    fragment->acam_preflight_spec_conformant = Traits::acam_preflight_spec_conformant(input);
    decltype(Traits::cookie_deprecation_label(input)) in_cookie_deprecation_label = Traits::cookie_deprecation_label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_deprecation_label)::BaseType> cookie_deprecation_label_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_cookie_deprecation_label, cookie_deprecation_label_fragment);
    fragment->cookie_deprecation_label.Set(
        cookie_deprecation_label_fragment.is_null() ? nullptr : cookie_deprecation_label_fragment.data());
    decltype(Traits::cookie_encryption_provider(input)) in_cookie_encryption_provider = Traits::cookie_encryption_provider(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieEncryptionProviderInterfaceBase>>(
        in_cookie_encryption_provider, &fragment->cookie_encryption_provider, &fragment.message());
    fragment->device_bound_sessions_enabled = Traits::device_bound_sessions_enabled(input);
    fragment->bound_network = Traits::bound_network(input);
    decltype(Traits::enterprise_reporting_endpoints(input)) in_enterprise_reporting_endpoints = Traits::enterprise_reporting_endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enterprise_reporting_endpoints)::BaseType>
        enterprise_reporting_endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& enterprise_reporting_endpoints_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>>(
        in_enterprise_reporting_endpoints, enterprise_reporting_endpoints_fragment, &enterprise_reporting_endpoints_validate_params);
    fragment->enterprise_reporting_endpoints.Set(
        enterprise_reporting_endpoints_fragment.is_null() ? nullptr : enterprise_reporting_endpoints_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::NetworkContextParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkContextParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkConditionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkConditionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkConditions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->offline = Traits::offline(input);
    decltype(Traits::latency(input)) in_latency = Traits::latency(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->latency)::BaseType> latency_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_latency, latency_fragment);
    fragment->latency.Set(
        latency_fragment.is_null() ? nullptr : latency_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->latency.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null latency in NetworkConditions struct");
    fragment->download_throughput = Traits::download_throughput(input);
    fragment->upload_throughput = Traits::upload_throughput(input);
    fragment->packet_loss = Traits::packet_loss(input);
    fragment->packet_queue_length = Traits::packet_queue_length(input);
    fragment->packet_reordering = Traits::packet_reordering(input);
  }

  static bool Deserialize(::network::mojom::internal::NetworkConditions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkConditionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedDictionaryInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedDictionaryInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedDictionaryInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::match(input)) in_match = Traits::match(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->match)::BaseType> match_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_match, match_fragment);
    fragment->match.Set(
        match_fragment.is_null() ? nullptr : match_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->match.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null match in SharedDictionaryInfo struct");
    decltype(Traits::match_dest(input)) in_match_dest = Traits::match_dest(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->match_dest)::BaseType>
        match_dest_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& match_dest_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::RequestDestination_Data::Validate>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::RequestDestination>>(
        in_match_dest, match_dest_fragment, &match_dest_validate_params);
    fragment->match_dest.Set(
        match_dest_fragment.is_null() ? nullptr : match_dest_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->match_dest.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null match_dest in SharedDictionaryInfo struct");
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in SharedDictionaryInfo struct");
    decltype(Traits::dictionary_url(input)) in_dictionary_url = Traits::dictionary_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->dictionary_url)::BaseType> dictionary_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_dictionary_url, dictionary_url_fragment);
    fragment->dictionary_url.Set(
        dictionary_url_fragment.is_null() ? nullptr : dictionary_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->dictionary_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dictionary_url in SharedDictionaryInfo struct");
    decltype(Traits::last_fetch_time(input)) in_last_fetch_time = Traits::last_fetch_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_fetch_time)::BaseType> last_fetch_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_fetch_time, last_fetch_time_fragment);
    fragment->last_fetch_time.Set(
        last_fetch_time_fragment.is_null() ? nullptr : last_fetch_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->last_fetch_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_fetch_time in SharedDictionaryInfo struct");
    decltype(Traits::response_time(input)) in_response_time = Traits::response_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_time)::BaseType> response_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_response_time, response_time_fragment);
    fragment->response_time.Set(
        response_time_fragment.is_null() ? nullptr : response_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->response_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_time in SharedDictionaryInfo struct");
    decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->expiration)::BaseType> expiration_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_expiration, expiration_fragment);
    fragment->expiration.Set(
        expiration_fragment.is_null() ? nullptr : expiration_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->expiration.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration in SharedDictionaryInfo struct");
    decltype(Traits::last_used_time(input)) in_last_used_time = Traits::last_used_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_used_time)::BaseType> last_used_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_last_used_time, last_used_time_fragment);
    fragment->last_used_time.Set(
        last_used_time_fragment.is_null() ? nullptr : last_used_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->last_used_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_used_time in SharedDictionaryInfo struct");
    fragment->size = Traits::size(input);
    decltype(Traits::hash(input)) in_hash = Traits::hash(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hash)::BaseType> hash_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SHA256HashValueDataView>(
        in_hash, hash_fragment);
    fragment->hash.Set(
        hash_fragment.is_null() ? nullptr : hash_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hash.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hash in SharedDictionaryInfo struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedDictionaryInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedDictionaryInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SignedExchangeReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SignedExchangeReportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SignedExchangeReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->success = Traits::success(input);
    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_type, type_fragment);
    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in SignedExchangeReport struct");
    decltype(Traits::outer_url(input)) in_outer_url = Traits::outer_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->outer_url)::BaseType> outer_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_outer_url, outer_url_fragment);
    fragment->outer_url.Set(
        outer_url_fragment.is_null() ? nullptr : outer_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->outer_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null outer_url in SignedExchangeReport struct");
    decltype(Traits::inner_url(input)) in_inner_url = Traits::inner_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inner_url)::BaseType> inner_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_inner_url, inner_url_fragment);
    fragment->inner_url.Set(
        inner_url_fragment.is_null() ? nullptr : inner_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->inner_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null inner_url in SignedExchangeReport struct");
    decltype(Traits::cert_url(input)) in_cert_url = Traits::cert_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cert_url)::BaseType> cert_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_cert_url, cert_url_fragment);
    fragment->cert_url.Set(
        cert_url_fragment.is_null() ? nullptr : cert_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cert_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert_url in SignedExchangeReport struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_referrer, referrer_fragment);
    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in SignedExchangeReport struct");
    decltype(Traits::server_ip_address(input)) in_server_ip_address = Traits::server_ip_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_ip_address)::BaseType> server_ip_address_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
        in_server_ip_address, server_ip_address_fragment);
    fragment->server_ip_address.Set(
        server_ip_address_fragment.is_null() ? nullptr : server_ip_address_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->server_ip_address.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_ip_address in SignedExchangeReport struct");
    decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->protocol)::BaseType> protocol_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_protocol, protocol_fragment);
    fragment->protocol.Set(
        protocol_fragment.is_null() ? nullptr : protocol_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->protocol.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol in SignedExchangeReport struct");
    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->method)::BaseType> method_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_method, method_fragment);
    fragment->method.Set(
        method_fragment.is_null() ? nullptr : method_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->method.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null method in SignedExchangeReport struct");
    fragment->status_code = Traits::status_code(input);
    decltype(Traits::elapsed_time(input)) in_elapsed_time = Traits::elapsed_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->elapsed_time)::BaseType> elapsed_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_elapsed_time, elapsed_time_fragment);
    fragment->elapsed_time.Set(
        elapsed_time_fragment.is_null() ? nullptr : elapsed_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->elapsed_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elapsed_time in SignedExchangeReport struct");
  }

  static bool Deserialize(::network::mojom::internal::SignedExchangeReport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SignedExchangeReportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLLoaderFactoryOverrideDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLLoaderFactoryOverrideDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLLoaderFactoryOverride_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::overriding_factory(input)) in_overriding_factory = Traits::overriding_factory(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
        in_overriding_factory, &fragment->overriding_factory, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->overriding_factory),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid overriding_factory in URLLoaderFactoryOverride struct");
    decltype(Traits::overridden_factory_receiver(input)) in_overridden_factory_receiver = Traits::overridden_factory_receiver(input);
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
        in_overridden_factory_receiver, &fragment->overridden_factory_receiver, &fragment.message());
    fragment->skip_cors_enabled_scheme_check = Traits::skip_cors_enabled_scheme_check(input);
  }

  static bool Deserialize(::network::mojom::internal::URLLoaderFactoryOverride_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLLoaderFactoryOverrideDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::URLLoaderFactoryParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::URLLoaderFactoryParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::URLLoaderFactoryParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->process_id = Traits::process_id(input);
    decltype(Traits::request_initiator_origin_lock(input)) in_request_initiator_origin_lock = Traits::request_initiator_origin_lock(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_initiator_origin_lock)::BaseType> request_initiator_origin_lock_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_request_initiator_origin_lock, request_initiator_origin_lock_fragment);
    fragment->request_initiator_origin_lock.Set(
        request_initiator_origin_lock_fragment.is_null() ? nullptr : request_initiator_origin_lock_fragment.data());
    fragment->is_orb_enabled = Traits::is_orb_enabled(input);
    fragment->ignore_isolated_world_origin = Traits::ignore_isolated_world_origin(input);
    fragment->unsafe_non_webby_initiator = Traits::unsafe_non_webby_initiator(input);
    fragment->disable_web_security = Traits::disable_web_security(input);
    decltype(Traits::header_client(input)) in_header_client = Traits::header_client(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustedURLLoaderHeaderClientInterfaceBase>>(
        in_header_client, &fragment->header_client, &fragment.message());
    decltype(Traits::isolation_info(input)) in_isolation_info = Traits::isolation_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->isolation_info)::BaseType> isolation_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
        in_isolation_info, isolation_info_fragment);
    fragment->isolation_info.Set(
        isolation_info_fragment.is_null() ? nullptr : isolation_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->isolation_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null isolation_info in URLLoaderFactoryParams struct");
    fragment->disable_secure_dns = Traits::disable_secure_dns(input);
    fragment->is_trusted = Traits::is_trusted(input);
    fragment->automatically_assign_isolation_info = Traits::automatically_assign_isolation_info(input);
    decltype(Traits::top_frame_id(input)) in_top_frame_id = Traits::top_frame_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_id)::BaseType> top_frame_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_top_frame_id, top_frame_id_fragment);
    fragment->top_frame_id.Set(
        top_frame_id_fragment.is_null() ? nullptr : top_frame_id_fragment.data());
    decltype(Traits::factory_override(input)) in_factory_override = Traits::factory_override(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->factory_override)::BaseType> factory_override_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::URLLoaderFactoryOverrideDataView>(
        in_factory_override, factory_override_fragment);
    fragment->factory_override.Set(
        factory_override_fragment.is_null() ? nullptr : factory_override_fragment.data());
    decltype(Traits::client_security_state(input)) in_client_security_state = Traits::client_security_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_security_state)::BaseType> client_security_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::ClientSecurityStateDataView>(
        in_client_security_state, client_security_state_fragment);
    fragment->client_security_state.Set(
        client_security_state_fragment.is_null() ? nullptr : client_security_state_fragment.data());
    decltype(Traits::coep_reporter(input)) in_coep_reporter = Traits::coep_reporter(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CrossOriginEmbedderPolicyReporterInterfaceBase>>(
        in_coep_reporter, &fragment->coep_reporter, &fragment.message());
    decltype(Traits::dip_reporter(input)) in_dip_reporter = Traits::dip_reporter(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DocumentIsolationPolicyReporterInterfaceBase>>(
        in_dip_reporter, &fragment->dip_reporter, &fragment.message());
    decltype(Traits::cookie_observer(input)) in_cookie_observer = Traits::cookie_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
        in_cookie_observer, &fragment->cookie_observer, &fragment.message());
    decltype(Traits::trust_token_observer(input)) in_trust_token_observer = Traits::trust_token_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustTokenAccessObserverInterfaceBase>>(
        in_trust_token_observer, &fragment->trust_token_observer, &fragment.message());
    decltype(Traits::shared_dictionary_observer(input)) in_shared_dictionary_observer = Traits::shared_dictionary_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
        in_shared_dictionary_observer, &fragment->shared_dictionary_observer, &fragment.message());
    decltype(Traits::url_loader_network_observer(input)) in_url_loader_network_observer = Traits::url_loader_network_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
        in_url_loader_network_observer, &fragment->url_loader_network_observer, &fragment.message());
    decltype(Traits::devtools_observer(input)) in_devtools_observer = Traits::devtools_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DevToolsObserverInterfaceBase>>(
        in_devtools_observer, &fragment->devtools_observer, &fragment.message());
    decltype(Traits::device_bound_session_observer(input)) in_device_bound_session_observer = Traits::device_bound_session_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::DeviceBoundSessionAccessObserverInterfaceBase>>(
        in_device_bound_session_observer, &fragment->device_bound_session_observer, &fragment.message());
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        Traits::trust_token_issuance_policy(input), &fragment->trust_token_issuance_policy);
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationPolicyVerdict>(
        Traits::trust_token_redemption_policy(input), &fragment->trust_token_redemption_policy);
    decltype(Traits::debug_tag(input)) in_debug_tag = Traits::debug_tag(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_tag)::BaseType> debug_tag_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_debug_tag, debug_tag_fragment);
    fragment->debug_tag.Set(
        debug_tag_fragment.is_null() ? nullptr : debug_tag_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->debug_tag.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null debug_tag in URLLoaderFactoryParams struct");
    decltype(Traits::cookie_setting_overrides(input)) in_cookie_setting_overrides = Traits::cookie_setting_overrides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cookie_setting_overrides)::BaseType> cookie_setting_overrides_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView>(
        in_cookie_setting_overrides, cookie_setting_overrides_fragment);
    fragment->cookie_setting_overrides.Set(
        cookie_setting_overrides_fragment.is_null() ? nullptr : cookie_setting_overrides_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cookie_setting_overrides.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_setting_overrides in URLLoaderFactoryParams struct");
    decltype(Traits::devtools_cookie_setting_overrides(input)) in_devtools_cookie_setting_overrides = Traits::devtools_cookie_setting_overrides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_cookie_setting_overrides)::BaseType> devtools_cookie_setting_overrides_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView>(
        in_devtools_cookie_setting_overrides, devtools_cookie_setting_overrides_fragment);
    fragment->devtools_cookie_setting_overrides.Set(
        devtools_cookie_setting_overrides_fragment.is_null() ? nullptr : devtools_cookie_setting_overrides_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->devtools_cookie_setting_overrides.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_cookie_setting_overrides in URLLoaderFactoryParams struct");
    fragment->require_cross_site_request_for_cookies = Traits::require_cross_site_request_for_cookies(input);
  }

  static bool Deserialize(::network::mojom::internal::URLLoaderFactoryParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::URLLoaderFactoryParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void CustomProxyConfigDataView::GetRulesDataView(
    ::network::mojom::ProxyRulesDataView* output) {
  auto pointer = data_->rules.Get();
  *output = ::network::mojom::ProxyRulesDataView(pointer, message_);
}
inline void CustomProxyConfigDataView::GetConnectTunnelHeadersDataView(
    ::network::mojom::HttpRequestHeadersDataView* output) {
  auto pointer = data_->connect_tunnel_headers.Get();
  *output = ::network::mojom::HttpRequestHeadersDataView(pointer, message_);
}






inline void CTPolicyDataView::GetExcludedHostsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excluded_hosts.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CTPolicyDataView::GetExcludedSpkisDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->excluded_spkis.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void NetworkContextFilePathsDataView::GetSharedDictionaryDirectoryDataView(
    ::network::mojom::TransferableDirectoryDataView* output) {
  auto pointer = &data_->shared_dictionary_directory;
  *output = ::network::mojom::TransferableDirectoryDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetHttpCacheDirectoryDataView(
    ::network::mojom::TransferableDirectoryDataView* output) {
  auto pointer = &data_->http_cache_directory;
  *output = ::network::mojom::TransferableDirectoryDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetDataDirectoryDataView(
    ::network::mojom::TransferableDirectoryDataView* output) {
  auto pointer = &data_->data_directory;
  *output = ::network::mojom::TransferableDirectoryDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetUnsandboxedDataPathDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->unsandboxed_data_path.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetCookieDatabaseNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->cookie_database_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetDeviceBoundSessionsDatabaseNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->device_bound_sessions_database_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetTrustTokenDatabaseNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->trust_token_database_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetHttpServerPropertiesFileNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->http_server_properties_file_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetTransportSecurityPersisterFileNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->transport_security_persister_file_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetReportingAndNelStoreDatabaseNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->reporting_and_nel_store_database_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void NetworkContextFilePathsDataView::GetSctAuditingPendingReportsFileNameDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->sct_auditing_pending_reports_file_name.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}


inline void NetworkContextParamsDataView::GetUserAgentDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->user_agent.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetAcceptLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->accept_language.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetInitialSslConfigDataView(
    ::network::mojom::SSLConfigDataView* output) {
  auto pointer = data_->initial_ssl_config.Get();
  *output = ::network::mojom::SSLConfigDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetInitialProxyConfigDataView(
    ::network::mojom::ProxyConfigWithAnnotationDataView* output) {
  auto pointer = data_->initial_proxy_config.Get();
  *output = ::network::mojom::ProxyConfigWithAnnotationDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetInitialCustomProxyConfigDataView(
    CustomProxyConfigDataView* output) {
  auto pointer = data_->initial_custom_proxy_config.Get();
  *output = CustomProxyConfigDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetCtPolicyDataView(
    CTPolicyDataView* output) {
  auto pointer = data_->ct_policy.Get();
  *output = CTPolicyDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetCertVerifierParamsDataView(
    CertVerifierServiceRemoteParamsDataView* output) {
  auto pointer = data_->cert_verifier_params.Get();
  *output = CertVerifierServiceRemoteParamsDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetCookieManagerParamsDataView(
    ::network::mojom::CookieManagerParamsDataView* output) {
  auto pointer = data_->cookie_manager_params.Get();
  *output = ::network::mojom::CookieManagerParamsDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetDomainReliabilityUploadReporterDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->domain_reliability_upload_reporter.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetReportingDeliveryIntervalDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->reporting_delivery_interval.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetCorsOriginAccessListDataView(
    mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>* output) {
  auto pointer = data_->cors_origin_access_list.Get();
  *output = mojo::ArrayDataView<::network::mojom::CorsOriginAccessPatternsDataView>(pointer, message_);
}
inline void NetworkContextParamsDataView::GetCorsExemptHeaderListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->cors_exempt_header_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void NetworkContextParamsDataView::GetHstsPolicyBypassListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->hsts_policy_bypass_list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void NetworkContextParamsDataView::GetHttpAuthStaticNetworkContextParamsDataView(
    HttpAuthStaticNetworkContextParamsDataView* output) {
  auto pointer = data_->http_auth_static_network_context_params.Get();
  *output = HttpAuthStaticNetworkContextParamsDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetFilePathsDataView(
    NetworkContextFilePathsDataView* output) {
  auto pointer = data_->file_paths.Get();
  *output = NetworkContextFilePathsDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetFirstPartySetsAccessDelegateParamsDataView(
    ::network::mojom::FirstPartySetsAccessDelegateParamsDataView* output) {
  auto pointer = data_->first_party_sets_access_delegate_params.Get();
  *output = ::network::mojom::FirstPartySetsAccessDelegateParamsDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetCookieDeprecationLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->cookie_deprecation_label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void NetworkContextParamsDataView::GetEnterpriseReportingEndpointsDataView(
    mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>* output) {
  auto pointer = data_->enterprise_reporting_endpoints.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::url::mojom::UrlDataView>(pointer, message_);
}


inline void NetworkConditionsDataView::GetLatencyDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->latency.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void SharedDictionaryInfoDataView::GetMatchDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->match.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetMatchDestDataView(
    mojo::ArrayDataView<::network::mojom::RequestDestination>* output) {
  auto pointer = data_->match_dest.Get();
  *output = mojo::ArrayDataView<::network::mojom::RequestDestination>(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetDictionaryUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->dictionary_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetLastFetchTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_fetch_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetResponseTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->response_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetExpirationDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->expiration.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetLastUsedTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->last_used_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void SharedDictionaryInfoDataView::GetHashDataView(
    ::network::mojom::SHA256HashValueDataView* output) {
  auto pointer = data_->hash.Get();
  *output = ::network::mojom::SHA256HashValueDataView(pointer, message_);
}


inline void SignedExchangeReportDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetOuterUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->outer_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetInnerUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->inner_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetCertUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->cert_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetReferrerDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetServerIpAddressDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->server_ip_address.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetProtocolDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->protocol.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetMethodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->method.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SignedExchangeReportDataView::GetElapsedTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->elapsed_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}




inline void URLLoaderFactoryParamsDataView::GetRequestInitiatorOriginLockDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->request_initiator_origin_lock.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void URLLoaderFactoryParamsDataView::GetIsolationInfoDataView(
    ::network::mojom::IsolationInfoDataView* output) {
  auto pointer = data_->isolation_info.Get();
  *output = ::network::mojom::IsolationInfoDataView(pointer, message_);
}
inline void URLLoaderFactoryParamsDataView::GetTopFrameIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->top_frame_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void URLLoaderFactoryParamsDataView::GetFactoryOverrideDataView(
    URLLoaderFactoryOverrideDataView* output) {
  auto pointer = data_->factory_override.Get();
  *output = URLLoaderFactoryOverrideDataView(pointer, message_);
}
inline void URLLoaderFactoryParamsDataView::GetClientSecurityStateDataView(
    ::network::mojom::ClientSecurityStateDataView* output) {
  auto pointer = data_->client_security_state.Get();
  *output = ::network::mojom::ClientSecurityStateDataView(pointer, message_);
}
inline void URLLoaderFactoryParamsDataView::GetDebugTagDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_tag.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLLoaderFactoryParamsDataView::GetCookieSettingOverridesDataView(
    ::network::mojom::CookieSettingOverridesDataView* output) {
  auto pointer = data_->cookie_setting_overrides.Get();
  *output = ::network::mojom::CookieSettingOverridesDataView(pointer, message_);
}
inline void URLLoaderFactoryParamsDataView::GetDevtoolsCookieSettingOverridesDataView(
    ::network::mojom::CookieSettingOverridesDataView* output) {
  auto pointer = data_->devtools_cookie_setting_overrides.Get();
  *output = ::network::mojom::CookieSettingOverridesDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::TrustTokenOperationPolicyVerdict> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::TrustTokenOperationPolicyVerdict value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SCTAuditingMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SCTAuditingMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::NetworkContext_DomainReliabilityClearMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::NetworkContext_DomainReliabilityClearMode value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_SHARED_H_