// services/network/public/mojom/network_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_service.mojom-shared-internal.h"
#include "components/content_settings/core/common/content_settings.mojom-shared.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "services/network/public/mojom/client_security_state.mojom-shared.h"
#include "services/network/public/mojom/first_party_sets.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/http_raw_headers.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"
#include "services/network/public/mojom/key_pinning.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/net_log.mojom-shared.h"
#include "services/network/public/mojom/network_annotation_monitor.mojom-shared.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared.h"
#include "services/network/public/mojom/network_context.mojom-shared.h"
#include "services/network/public/mojom/network_interface.mojom-shared.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_quality_estimator_manager.mojom-shared.h"
#include "services/network/public/mojom/network_service_test.mojom-shared.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared.h"
#include "services/network/public/mojom/proxy_config.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "services/network/public/mojom/system_dns_resolution.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/url_loader_network_service_observer.mojom-shared.h"
#include "services/network/public/mojom/url_response_head.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class HttpAuthStaticParamsDataView;

class HttpAuthDynamicParamsDataView;

class EnvironmentVariableDataView;

class NetworkServiceParamsDataView;

class SCTAuditingConfigurationDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::HttpAuthStaticParamsDataView> {
  using Data = ::network::mojom::internal::HttpAuthStaticParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HttpAuthDynamicParamsDataView> {
  using Data = ::network::mojom::internal::HttpAuthDynamicParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::EnvironmentVariableDataView> {
  using Data = ::network::mojom::internal::EnvironmentVariable_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::NetworkServiceParamsDataView> {
  using Data = ::network::mojom::internal::NetworkServiceParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SCTAuditingConfigurationDataView> {
  using Data = ::network::mojom::internal::SCTAuditingConfiguration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {
// Interface base classes. They are used for type safety check.
class GssapiLibraryLoadObserverInterfaceBase {};

using GssapiLibraryLoadObserverPtrDataView =
    mojo::InterfacePtrDataView<GssapiLibraryLoadObserverInterfaceBase>;
using GssapiLibraryLoadObserverRequestDataView =
    mojo::InterfaceRequestDataView<GssapiLibraryLoadObserverInterfaceBase>;
using GssapiLibraryLoadObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<GssapiLibraryLoadObserverInterfaceBase>;
using GssapiLibraryLoadObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<GssapiLibraryLoadObserverInterfaceBase>;
class NetworkServiceInterfaceBase {};

using NetworkServicePtrDataView =
    mojo::InterfacePtrDataView<NetworkServiceInterfaceBase>;
using NetworkServiceRequestDataView =
    mojo::InterfaceRequestDataView<NetworkServiceInterfaceBase>;
using NetworkServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NetworkServiceInterfaceBase>;
using NetworkServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NetworkServiceInterfaceBase>;


class HttpAuthStaticParamsDataView {
 public:
  HttpAuthStaticParamsDataView() = default;

  HttpAuthStaticParamsDataView(
      internal::HttpAuthStaticParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetGssapiLibraryNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGssapiLibraryName(UserType* output) {
    
    auto* pointer = data_->gssapi_library_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::HttpAuthStaticParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpAuthDynamicParamsDataView {
 public:
  HttpAuthDynamicParamsDataView() = default;

  HttpAuthDynamicParamsDataView(
      internal::HttpAuthDynamicParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllowedSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllowedSchemes(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `allowed_schemes` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAllowedSchemes` instead "
    "of `ReadAllowedSchemes if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->allowed_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetPatternsAllowedToUseAllSchemesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPatternsAllowedToUseAllSchemes(UserType* output) {
    
    auto* pointer = data_->patterns_allowed_to_use_all_schemes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetServerAllowlistDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServerAllowlist(UserType* output) {
    
    auto* pointer = data_->server_allowlist.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDelegateAllowlistDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDelegateAllowlist(UserType* output) {
    
    auto* pointer = data_->delegate_allowlist.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool delegate_by_kdc_policy() const {
    return data_->delegate_by_kdc_policy;
  }
  bool negotiate_disable_cname_lookup() const {
    return data_->negotiate_disable_cname_lookup;
  }
  bool enable_negotiate_port() const {
    return data_->enable_negotiate_port;
  }
  bool ntlm_v2_enabled() const {
    return data_->ntlm_v2_enabled;
  }
  inline void GetAndroidNegotiateAccountTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAndroidNegotiateAccountType(UserType* output) {
    
    auto* pointer = data_->android_negotiate_account_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool allow_gssapi_library_load() const {
    return data_->allow_gssapi_library_load;
  }
  bool basic_over_http_enabled() const {
    return data_->basic_over_http_enabled;
  }
 private:
  internal::HttpAuthDynamicParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class EnvironmentVariableDataView {
 public:
  EnvironmentVariableDataView() = default;

  EnvironmentVariableDataView(
      internal::EnvironmentVariable_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::EnvironmentVariable_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NetworkServiceParamsDataView {
 public:
  NetworkServiceParamsDataView() = default;

  NetworkServiceParamsDataView(
      internal::NetworkServiceParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialConnectionType(UserType* output) const {
    auto data_value = data_->initial_connection_type;
    return mojo::internal::Deserialize<::network::mojom::ConnectionType>(
        data_value, output);
  }
  ::network::mojom::ConnectionType initial_connection_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ConnectionType>(data_->initial_connection_type));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitialConnectionSubtype(UserType* output) const {
    auto data_value = data_->initial_connection_subtype;
    return mojo::internal::Deserialize<::network::mojom::ConnectionSubtype>(
        data_value, output);
  }
  ::network::mojom::ConnectionSubtype initial_connection_subtype() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ConnectionSubtype>(data_->initial_connection_subtype));
  }
  inline void GetInitialAddressMapDataView(
      ::network::mojom::InitialAddressMapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialAddressMap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::InitialAddressMapDataView, UserType>(),
    "Attempting to read the optional `initial_address_map` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialAddressMap` instead "
    "of `ReadInitialAddressMap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_address_map.Get();
    return mojo::internal::Deserialize<::network::mojom::InitialAddressMapDataView>(
        pointer, output, message_);
  }
  inline void GetEnvironmentDataView(
      mojo::ArrayDataView<EnvironmentVariableDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEnvironment(UserType* output) {
    
    auto* pointer = data_->environment.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::EnvironmentVariableDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeDefaultObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
            &data_->default_observer, &result, message_);
    DCHECK(ret);
    return result;
  }
  bool first_party_sets_enabled() const {
    return data_->first_party_sets_enabled;
  }
  template <typename UserType>
  UserType TakeSystemDnsResolver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SystemDnsResolverInterfaceBase>>(
            &data_->system_dns_resolver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIpProtectionProxyBypassPolicy(UserType* output) const {
    auto data_value = data_->ip_protection_proxy_bypass_policy;
    return mojo::internal::Deserialize<::network::mojom::IpProtectionProxyBypassPolicy>(
        data_value, output);
  }
  ::network::mojom::IpProtectionProxyBypassPolicy ip_protection_proxy_bypass_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::IpProtectionProxyBypassPolicy>(data_->ip_protection_proxy_bypass_policy));
  }
 private:
  internal::NetworkServiceParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SCTAuditingConfigurationDataView {
 public:
  SCTAuditingConfigurationDataView() = default;

  SCTAuditingConfigurationDataView(
      internal::SCTAuditingConfiguration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  double sampling_rate() const {
    return data_->sampling_rate;
  }
  inline void GetLogExpectedIngestionDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogExpectedIngestionDelay(UserType* output) {
    
    auto* pointer = data_->log_expected_ingestion_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetLogMaxIngestionRandomDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogMaxIngestionRandomDelay(UserType* output) {
    
    auto* pointer = data_->log_max_ingestion_random_delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetReportUriDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportUri(UserType* output) {
    
    auto* pointer = data_->report_uri.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetHashdanceLookupUriDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHashdanceLookupUri(UserType* output) {
    
    auto* pointer = data_->hashdance_lookup_uri.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
  inline void GetHashdanceTrafficAnnotationDataView(
      ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHashdanceTrafficAnnotation(UserType* output) {
    
    auto* pointer = data_->hashdance_traffic_annotation.Get();
    return mojo::internal::Deserialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        pointer, output, message_);
  }
 private:
  internal::SCTAuditingConfiguration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpAuthStaticParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpAuthStaticParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpAuthStaticParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::gssapi_library_name(input)) in_gssapi_library_name = Traits::gssapi_library_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gssapi_library_name)::BaseType> gssapi_library_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_gssapi_library_name, gssapi_library_name_fragment);
    fragment->gssapi_library_name.Set(
        gssapi_library_name_fragment.is_null() ? nullptr : gssapi_library_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->gssapi_library_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null gssapi_library_name in HttpAuthStaticParams struct");
  }

  static bool Deserialize(::network::mojom::internal::HttpAuthStaticParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HttpAuthStaticParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HttpAuthDynamicParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HttpAuthDynamicParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::HttpAuthDynamicParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::allowed_schemes(input)) in_allowed_schemes = Traits::allowed_schemes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowed_schemes)::BaseType>
        allowed_schemes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowed_schemes_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_allowed_schemes, allowed_schemes_fragment, &allowed_schemes_validate_params);
    fragment->allowed_schemes.Set(
        allowed_schemes_fragment.is_null() ? nullptr : allowed_schemes_fragment.data());
    decltype(Traits::patterns_allowed_to_use_all_schemes(input)) in_patterns_allowed_to_use_all_schemes = Traits::patterns_allowed_to_use_all_schemes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->patterns_allowed_to_use_all_schemes)::BaseType>
        patterns_allowed_to_use_all_schemes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& patterns_allowed_to_use_all_schemes_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_patterns_allowed_to_use_all_schemes, patterns_allowed_to_use_all_schemes_fragment, &patterns_allowed_to_use_all_schemes_validate_params);
    fragment->patterns_allowed_to_use_all_schemes.Set(
        patterns_allowed_to_use_all_schemes_fragment.is_null() ? nullptr : patterns_allowed_to_use_all_schemes_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->patterns_allowed_to_use_all_schemes.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null patterns_allowed_to_use_all_schemes in HttpAuthDynamicParams struct");
    decltype(Traits::server_allowlist(input)) in_server_allowlist = Traits::server_allowlist(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->server_allowlist)::BaseType> server_allowlist_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_server_allowlist, server_allowlist_fragment);
    fragment->server_allowlist.Set(
        server_allowlist_fragment.is_null() ? nullptr : server_allowlist_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->server_allowlist.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_allowlist in HttpAuthDynamicParams struct");
    decltype(Traits::delegate_allowlist(input)) in_delegate_allowlist = Traits::delegate_allowlist(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->delegate_allowlist)::BaseType> delegate_allowlist_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_delegate_allowlist, delegate_allowlist_fragment);
    fragment->delegate_allowlist.Set(
        delegate_allowlist_fragment.is_null() ? nullptr : delegate_allowlist_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->delegate_allowlist.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null delegate_allowlist in HttpAuthDynamicParams struct");
    fragment->delegate_by_kdc_policy = Traits::delegate_by_kdc_policy(input);
    fragment->negotiate_disable_cname_lookup = Traits::negotiate_disable_cname_lookup(input);
    fragment->enable_negotiate_port = Traits::enable_negotiate_port(input);
    fragment->ntlm_v2_enabled = Traits::ntlm_v2_enabled(input);
    decltype(Traits::android_negotiate_account_type(input)) in_android_negotiate_account_type = Traits::android_negotiate_account_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->android_negotiate_account_type)::BaseType> android_negotiate_account_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_android_negotiate_account_type, android_negotiate_account_type_fragment);
    fragment->android_negotiate_account_type.Set(
        android_negotiate_account_type_fragment.is_null() ? nullptr : android_negotiate_account_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->android_negotiate_account_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null android_negotiate_account_type in HttpAuthDynamicParams struct");
    fragment->allow_gssapi_library_load = Traits::allow_gssapi_library_load(input);
    fragment->basic_over_http_enabled = Traits::basic_over_http_enabled(input);
  }

  static bool Deserialize(::network::mojom::internal::HttpAuthDynamicParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HttpAuthDynamicParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::EnvironmentVariableDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::EnvironmentVariableDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::EnvironmentVariable_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, name_fragment);
    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in EnvironmentVariable struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in EnvironmentVariable struct");
  }

  static bool Deserialize(::network::mojom::internal::EnvironmentVariable_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::EnvironmentVariableDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkServiceParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NetworkServiceParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NetworkServiceParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::ConnectionType>(
        Traits::initial_connection_type(input), &fragment->initial_connection_type);
    mojo::internal::Serialize<::network::mojom::ConnectionSubtype>(
        Traits::initial_connection_subtype(input), &fragment->initial_connection_subtype);
    decltype(Traits::initial_address_map(input)) in_initial_address_map = Traits::initial_address_map(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_address_map)::BaseType> initial_address_map_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::InitialAddressMapDataView>(
        in_initial_address_map, initial_address_map_fragment);
    fragment->initial_address_map.Set(
        initial_address_map_fragment.is_null() ? nullptr : initial_address_map_fragment.data());
    decltype(Traits::environment(input)) in_environment = Traits::environment(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->environment)::BaseType>
        environment_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& environment_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::EnvironmentVariableDataView>>(
        in_environment, environment_fragment, &environment_validate_params);
    fragment->environment.Set(
        environment_fragment.is_null() ? nullptr : environment_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->environment.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null environment in NetworkServiceParams struct");
    decltype(Traits::default_observer(input)) in_default_observer = Traits::default_observer(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::URLLoaderNetworkServiceObserverInterfaceBase>>(
        in_default_observer, &fragment->default_observer, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->default_observer),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid default_observer in NetworkServiceParams struct");
    fragment->first_party_sets_enabled = Traits::first_party_sets_enabled(input);
    decltype(Traits::system_dns_resolver(input)) in_system_dns_resolver = Traits::system_dns_resolver(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SystemDnsResolverInterfaceBase>>(
        in_system_dns_resolver, &fragment->system_dns_resolver, &fragment.message());
    mojo::internal::Serialize<::network::mojom::IpProtectionProxyBypassPolicy>(
        Traits::ip_protection_proxy_bypass_policy(input), &fragment->ip_protection_proxy_bypass_policy);
  }

  static bool Deserialize(::network::mojom::internal::NetworkServiceParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::NetworkServiceParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SCTAuditingConfigurationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SCTAuditingConfigurationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SCTAuditingConfiguration_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->sampling_rate = Traits::sampling_rate(input);
    decltype(Traits::log_expected_ingestion_delay(input)) in_log_expected_ingestion_delay = Traits::log_expected_ingestion_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->log_expected_ingestion_delay)::BaseType> log_expected_ingestion_delay_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_log_expected_ingestion_delay, log_expected_ingestion_delay_fragment);
    fragment->log_expected_ingestion_delay.Set(
        log_expected_ingestion_delay_fragment.is_null() ? nullptr : log_expected_ingestion_delay_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->log_expected_ingestion_delay.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null log_expected_ingestion_delay in SCTAuditingConfiguration struct");
    decltype(Traits::log_max_ingestion_random_delay(input)) in_log_max_ingestion_random_delay = Traits::log_max_ingestion_random_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->log_max_ingestion_random_delay)::BaseType> log_max_ingestion_random_delay_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_log_max_ingestion_random_delay, log_max_ingestion_random_delay_fragment);
    fragment->log_max_ingestion_random_delay.Set(
        log_max_ingestion_random_delay_fragment.is_null() ? nullptr : log_max_ingestion_random_delay_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->log_max_ingestion_random_delay.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null log_max_ingestion_random_delay in SCTAuditingConfiguration struct");
    decltype(Traits::report_uri(input)) in_report_uri = Traits::report_uri(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_uri)::BaseType> report_uri_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_report_uri, report_uri_fragment);
    fragment->report_uri.Set(
        report_uri_fragment.is_null() ? nullptr : report_uri_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->report_uri.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_uri in SCTAuditingConfiguration struct");
    decltype(Traits::hashdance_lookup_uri(input)) in_hashdance_lookup_uri = Traits::hashdance_lookup_uri(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hashdance_lookup_uri)::BaseType> hashdance_lookup_uri_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_hashdance_lookup_uri, hashdance_lookup_uri_fragment);
    fragment->hashdance_lookup_uri.Set(
        hashdance_lookup_uri_fragment.is_null() ? nullptr : hashdance_lookup_uri_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hashdance_lookup_uri.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hashdance_lookup_uri in SCTAuditingConfiguration struct");
    decltype(Traits::traffic_annotation(input)) in_traffic_annotation = Traits::traffic_annotation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->traffic_annotation)::BaseType> traffic_annotation_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        in_traffic_annotation, traffic_annotation_fragment);
    fragment->traffic_annotation.Set(
        traffic_annotation_fragment.is_null() ? nullptr : traffic_annotation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->traffic_annotation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null traffic_annotation in SCTAuditingConfiguration struct");
    decltype(Traits::hashdance_traffic_annotation(input)) in_hashdance_traffic_annotation = Traits::hashdance_traffic_annotation(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hashdance_traffic_annotation)::BaseType> hashdance_traffic_annotation_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
        in_hashdance_traffic_annotation, hashdance_traffic_annotation_fragment);
    fragment->hashdance_traffic_annotation.Set(
        hashdance_traffic_annotation_fragment.is_null() ? nullptr : hashdance_traffic_annotation_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hashdance_traffic_annotation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hashdance_traffic_annotation in SCTAuditingConfiguration struct");
  }

  static bool Deserialize(::network::mojom::internal::SCTAuditingConfiguration_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SCTAuditingConfigurationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void HttpAuthStaticParamsDataView::GetGssapiLibraryNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gssapi_library_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void HttpAuthDynamicParamsDataView::GetAllowedSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->allowed_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void HttpAuthDynamicParamsDataView::GetPatternsAllowedToUseAllSchemesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->patterns_allowed_to_use_all_schemes.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void HttpAuthDynamicParamsDataView::GetServerAllowlistDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->server_allowlist.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HttpAuthDynamicParamsDataView::GetDelegateAllowlistDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->delegate_allowlist.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void HttpAuthDynamicParamsDataView::GetAndroidNegotiateAccountTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->android_negotiate_account_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void EnvironmentVariableDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void EnvironmentVariableDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void NetworkServiceParamsDataView::GetInitialAddressMapDataView(
    ::network::mojom::InitialAddressMapDataView* output) {
  auto pointer = data_->initial_address_map.Get();
  *output = ::network::mojom::InitialAddressMapDataView(pointer, message_);
}
inline void NetworkServiceParamsDataView::GetEnvironmentDataView(
    mojo::ArrayDataView<EnvironmentVariableDataView>* output) {
  auto pointer = data_->environment.Get();
  *output = mojo::ArrayDataView<EnvironmentVariableDataView>(pointer, message_);
}


inline void SCTAuditingConfigurationDataView::GetLogExpectedIngestionDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->log_expected_ingestion_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void SCTAuditingConfigurationDataView::GetLogMaxIngestionRandomDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->log_max_ingestion_random_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void SCTAuditingConfigurationDataView::GetReportUriDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->report_uri.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SCTAuditingConfigurationDataView::GetHashdanceLookupUriDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->hashdance_lookup_uri.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SCTAuditingConfigurationDataView::GetTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}
inline void SCTAuditingConfigurationDataView::GetHashdanceTrafficAnnotationDataView(
    ::network::mojom::MutableNetworkTrafficAnnotationTagDataView* output) {
  auto pointer = data_->hashdance_traffic_annotation.Get();
  *output = ::network::mojom::MutableNetworkTrafficAnnotationTagDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_SHARED_H_