// services/network/public/mojom/network_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_service.mojom-params-data.h"
#include "services/network/public/mojom/network_service.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_service.mojom-import-headers.h"
#include "services/network/public/mojom/network_service.mojom-test-utils.h"
#include "components/content_settings/core/common/content_settings_param_traits.h"
#include "net/cert/cert_verify_result.h"


namespace network::mojom {
HttpAuthStaticParams::HttpAuthStaticParams()
    : gssapi_library_name() {}

HttpAuthStaticParams::HttpAuthStaticParams(
    const std::string& gssapi_library_name_in)
    : gssapi_library_name(std::move(gssapi_library_name_in)) {}

HttpAuthStaticParams::~HttpAuthStaticParams() = default;
size_t HttpAuthStaticParams::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->gssapi_library_name);
  return seed;
}

void HttpAuthStaticParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "gssapi_library_name"), this->gssapi_library_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpAuthStaticParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpAuthDynamicParams::HttpAuthDynamicParams()
    : allowed_schemes(),
      patterns_allowed_to_use_all_schemes(),
      server_allowlist(),
      delegate_allowlist(),
      delegate_by_kdc_policy(false),
      negotiate_disable_cname_lookup(false),
      enable_negotiate_port(false),
      ntlm_v2_enabled(true),
      android_negotiate_account_type(),
      allow_gssapi_library_load(true),
      basic_over_http_enabled(true) {}

HttpAuthDynamicParams::HttpAuthDynamicParams(
    std::optional<std::vector<std::string>> allowed_schemes_in,
    std::vector<std::string> patterns_allowed_to_use_all_schemes_in,
    const std::string& server_allowlist_in,
    const std::string& delegate_allowlist_in,
    bool delegate_by_kdc_policy_in,
    bool negotiate_disable_cname_lookup_in,
    bool enable_negotiate_port_in,
    bool ntlm_v2_enabled_in,
    const std::string& android_negotiate_account_type_in,
    bool allow_gssapi_library_load_in,
    bool basic_over_http_enabled_in)
    : allowed_schemes(std::move(allowed_schemes_in)),
      patterns_allowed_to_use_all_schemes(std::move(patterns_allowed_to_use_all_schemes_in)),
      server_allowlist(std::move(server_allowlist_in)),
      delegate_allowlist(std::move(delegate_allowlist_in)),
      delegate_by_kdc_policy(std::move(delegate_by_kdc_policy_in)),
      negotiate_disable_cname_lookup(std::move(negotiate_disable_cname_lookup_in)),
      enable_negotiate_port(std::move(enable_negotiate_port_in)),
      ntlm_v2_enabled(std::move(ntlm_v2_enabled_in)),
      android_negotiate_account_type(std::move(android_negotiate_account_type_in)),
      allow_gssapi_library_load(std::move(allow_gssapi_library_load_in)),
      basic_over_http_enabled(std::move(basic_over_http_enabled_in)) {}

HttpAuthDynamicParams::~HttpAuthDynamicParams() = default;

void HttpAuthDynamicParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowed_schemes"), this->allowed_schemes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::vector<std::string>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "patterns_allowed_to_use_all_schemes"), this->patterns_allowed_to_use_all_schemes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_allowlist"), this->server_allowlist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegate_allowlist"), this->delegate_allowlist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delegate_by_kdc_policy"), this->delegate_by_kdc_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "negotiate_disable_cname_lookup"), this->negotiate_disable_cname_lookup,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enable_negotiate_port"), this->enable_negotiate_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ntlm_v2_enabled"), this->ntlm_v2_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "android_negotiate_account_type"), this->android_negotiate_account_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_gssapi_library_load"), this->allow_gssapi_library_load,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "basic_over_http_enabled"), this->basic_over_http_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpAuthDynamicParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EnvironmentVariable::EnvironmentVariable()
    : name(),
      value() {}

EnvironmentVariable::EnvironmentVariable(
    const std::string& name_in,
    const std::string& value_in)
    : name(std::move(name_in)),
      value(std::move(value_in)) {}

EnvironmentVariable::~EnvironmentVariable() = default;
size_t EnvironmentVariable::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->value);
  return seed;
}

void EnvironmentVariable::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool EnvironmentVariable::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkServiceParams::NetworkServiceParams()
    : initial_connection_type(::network::mojom::ConnectionType::CONNECTION_UNKNOWN),
      initial_connection_subtype(::network::mojom::ConnectionSubtype::SUBTYPE_UNKNOWN),
      initial_address_map(),
      environment(),
      default_observer(),
      first_party_sets_enabled(),
      system_dns_resolver(),
      ip_protection_proxy_bypass_policy() {}

NetworkServiceParams::NetworkServiceParams(
    ::network::mojom::ConnectionType initial_connection_type_in,
    ::network::mojom::ConnectionSubtype initial_connection_subtype_in,
    ::network::mojom::InitialAddressMapPtr initial_address_map_in,
    std::vector<EnvironmentVariablePtr> environment_in,
    ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver> default_observer_in,
    bool first_party_sets_enabled_in,
    ::mojo::PendingRemote<::network::mojom::SystemDnsResolver> system_dns_resolver_in,
    ::network::mojom::IpProtectionProxyBypassPolicy ip_protection_proxy_bypass_policy_in)
    : initial_connection_type(std::move(initial_connection_type_in)),
      initial_connection_subtype(std::move(initial_connection_subtype_in)),
      initial_address_map(std::move(initial_address_map_in)),
      environment(std::move(environment_in)),
      default_observer(std::move(default_observer_in)),
      first_party_sets_enabled(std::move(first_party_sets_enabled_in)),
      system_dns_resolver(std::move(system_dns_resolver_in)),
      ip_protection_proxy_bypass_policy(std::move(ip_protection_proxy_bypass_policy_in)) {}

NetworkServiceParams::~NetworkServiceParams() = default;

void NetworkServiceParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_connection_type"), this->initial_connection_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ConnectionType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_connection_subtype"), this->initial_connection_subtype,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::ConnectionSubtype>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_address_map"), this->initial_address_map,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::InitialAddressMapPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "environment"), this->environment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<EnvironmentVariablePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "default_observer"), this->default_observer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::URLLoaderNetworkServiceObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first_party_sets_enabled"), this->first_party_sets_enabled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "system_dns_resolver"), this->system_dns_resolver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::network::mojom::SystemDnsResolver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_protection_proxy_bypass_policy"), this->ip_protection_proxy_bypass_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::IpProtectionProxyBypassPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetworkServiceParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SCTAuditingConfiguration::SCTAuditingConfiguration()
    : sampling_rate(),
      log_expected_ingestion_delay(),
      log_max_ingestion_random_delay(),
      report_uri(),
      hashdance_lookup_uri(),
      traffic_annotation(),
      hashdance_traffic_annotation() {}

SCTAuditingConfiguration::SCTAuditingConfiguration(
    double sampling_rate_in,
    ::base::TimeDelta log_expected_ingestion_delay_in,
    ::base::TimeDelta log_max_ingestion_random_delay_in,
    const ::GURL& report_uri_in,
    const ::GURL& hashdance_lookup_uri_in,
    const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation_in,
    const ::net::MutableNetworkTrafficAnnotationTag& hashdance_traffic_annotation_in)
    : sampling_rate(std::move(sampling_rate_in)),
      log_expected_ingestion_delay(std::move(log_expected_ingestion_delay_in)),
      log_max_ingestion_random_delay(std::move(log_max_ingestion_random_delay_in)),
      report_uri(std::move(report_uri_in)),
      hashdance_lookup_uri(std::move(hashdance_lookup_uri_in)),
      traffic_annotation(std::move(traffic_annotation_in)),
      hashdance_traffic_annotation(std::move(hashdance_traffic_annotation_in)) {}

SCTAuditingConfiguration::~SCTAuditingConfiguration() = default;

void SCTAuditingConfiguration::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sampling_rate"), this->sampling_rate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "log_expected_ingestion_delay"), this->log_expected_ingestion_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "log_max_ingestion_random_delay"), this->log_max_ingestion_random_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeDelta>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_uri"), this->report_uri,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hashdance_lookup_uri"), this->hashdance_lookup_uri,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "traffic_annotation"), this->traffic_annotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hashdance_traffic_annotation"), this->hashdance_traffic_annotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SCTAuditingConfiguration::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char GssapiLibraryLoadObserver::Name_[] = "network.mojom.GssapiLibraryLoadObserver";

GssapiLibraryLoadObserver::IPCStableHashFunction GssapiLibraryLoadObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GssapiLibraryLoadObserver>(message.name())) {
    case messages::GssapiLibraryLoadObserver::kOnBeforeGssapiLibraryLoad: {
      return &GssapiLibraryLoadObserver::OnBeforeGssapiLibraryLoad_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GssapiLibraryLoadObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GssapiLibraryLoadObserver>(message.name())) {
      case messages::GssapiLibraryLoadObserver::kOnBeforeGssapiLibraryLoad:
            return "Receive network::mojom::GssapiLibraryLoadObserver::OnBeforeGssapiLibraryLoad";
    }
  } else {
    switch (static_cast<messages::GssapiLibraryLoadObserver>(message.name())) {
      case messages::GssapiLibraryLoadObserver::kOnBeforeGssapiLibraryLoad:
            return "Receive reply network::mojom::GssapiLibraryLoadObserver::OnBeforeGssapiLibraryLoad";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GssapiLibraryLoadObserver::OnBeforeGssapiLibraryLoad_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::GssapiLibraryLoadObserver::OnBeforeGssapiLibraryLoad");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GssapiLibraryLoadObserverProxy::GssapiLibraryLoadObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GssapiLibraryLoadObserverProxy::OnBeforeGssapiLibraryLoad(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::GssapiLibraryLoadObserver::OnBeforeGssapiLibraryLoad");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GssapiLibraryLoadObserver::kOnBeforeGssapiLibraryLoad), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GssapiLibraryLoadObserver::Name_);
  message.set_method_name("OnBeforeGssapiLibraryLoad");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GssapiLibraryLoadObserverStubDispatch::Accept(
    GssapiLibraryLoadObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GssapiLibraryLoadObserver>(message->header()->name)) {
    case messages::GssapiLibraryLoadObserver::kOnBeforeGssapiLibraryLoad: {
      DCHECK(message->is_serialized());
      internal::GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data* params =
          reinterpret_cast<internal::GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for GssapiLibraryLoadObserver.0
      bool success = true;
      GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GssapiLibraryLoadObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeforeGssapiLibraryLoad(        );
      return true;
    }
  }
  return false;
}

// static
bool GssapiLibraryLoadObserverStubDispatch::AcceptWithResponder(
    GssapiLibraryLoadObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GssapiLibraryLoadObserver>(message->header()->name)) {
    case messages::GssapiLibraryLoadObserver::kOnBeforeGssapiLibraryLoad: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kGssapiLibraryLoadObserverValidationInfo[] = {
    {base::to_underlying(messages::GssapiLibraryLoadObserver::kOnBeforeGssapiLibraryLoad),
     { &internal::GssapiLibraryLoadObserver_OnBeforeGssapiLibraryLoad_Params_Data::Validate,
      nullptr /* no response */}},
};

bool GssapiLibraryLoadObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::GssapiLibraryLoadObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kGssapiLibraryLoadObserverValidationInfo);
}

const char NetworkService::Name_[] = "network.mojom.NetworkService";

NetworkService::IPCStableHashFunction NetworkService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetworkService>(message.name())) {
    case messages::NetworkService::kSetParams: {
      return &NetworkService::SetParams_Sym::IPCStableHash;
    }
    case messages::NetworkService::kStartNetLog: {
      return &NetworkService::StartNetLog_Sym::IPCStableHash;
    }
    case messages::NetworkService::kAttachNetLogProxy: {
      return &NetworkService::AttachNetLogProxy_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetSSLKeyLogFile: {
      return &NetworkService::SetSSLKeyLogFile_Sym::IPCStableHash;
    }
    case messages::NetworkService::kCreateNetworkContext: {
      return &NetworkService::CreateNetworkContext_Sym::IPCStableHash;
    }
    case messages::NetworkService::kConfigureStubHostResolver: {
      return &NetworkService::ConfigureStubHostResolver_Sym::IPCStableHash;
    }
    case messages::NetworkService::kDisableQuic: {
      return &NetworkService::DisableQuic_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetUpHttpAuth: {
      return &NetworkService::SetUpHttpAuth_Sym::IPCStableHash;
    }
    case messages::NetworkService::kConfigureHttpAuthPrefs: {
      return &NetworkService::ConfigureHttpAuthPrefs_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetRawHeadersAccess: {
      return &NetworkService::SetRawHeadersAccess_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetMaxConnectionsPerProxyChain: {
      return &NetworkService::SetMaxConnectionsPerProxyChain_Sym::IPCStableHash;
    }
    case messages::NetworkService::kGetNetworkChangeManager: {
      return &NetworkService::GetNetworkChangeManager_Sym::IPCStableHash;
    }
    case messages::NetworkService::kGetNetworkQualityEstimatorManager: {
      return &NetworkService::GetNetworkQualityEstimatorManager_Sym::IPCStableHash;
    }
    case messages::NetworkService::kGetDnsConfigChangeManager: {
      return &NetworkService::GetDnsConfigChangeManager_Sym::IPCStableHash;
    }
    case messages::NetworkService::kGetNetworkList: {
      return &NetworkService::GetNetworkList_Sym::IPCStableHash;
    }
    case messages::NetworkService::kOnTrustStoreChanged: {
      return &NetworkService::OnTrustStoreChanged_Sym::IPCStableHash;
    }
    case messages::NetworkService::kOnClientCertStoreChanged: {
      return &NetworkService::OnClientCertStoreChanged_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetEncryptionKey: {
      return &NetworkService::SetEncryptionKey_Sym::IPCStableHash;
    }
    case messages::NetworkService::kOnMemoryPressure: {
      return &NetworkService::OnMemoryPressure_Sym::IPCStableHash;
    }
    case messages::NetworkService::kOnPeerToPeerConnectionsCountChange: {
      return &NetworkService::OnPeerToPeerConnectionsCountChange_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetTrustTokenKeyCommitments: {
      return &NetworkService::SetTrustTokenKeyCommitments_Sym::IPCStableHash;
    }
    case messages::NetworkService::kClearSCTAuditingCache: {
      return &NetworkService::ClearSCTAuditingCache_Sym::IPCStableHash;
    }
    case messages::NetworkService::kConfigureSCTAuditing: {
      return &NetworkService::ConfigureSCTAuditing_Sym::IPCStableHash;
    }
    case messages::NetworkService::kUpdateCtLogList: {
      return &NetworkService::UpdateCtLogList_Sym::IPCStableHash;
    }
    case messages::NetworkService::kUpdateCtKnownPopularSCTs: {
      return &NetworkService::UpdateCtKnownPopularSCTs_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetCtEnforcementEnabled: {
      return &NetworkService::SetCtEnforcementEnabled_Sym::IPCStableHash;
    }
    case messages::NetworkService::kUpdateKeyPinsList: {
      return &NetworkService::UpdateKeyPinsList_Sym::IPCStableHash;
    }
    case messages::NetworkService::kBindTestInterfaceForTesting: {
      return &NetworkService::BindTestInterfaceForTesting_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetFirstPartySets: {
      return &NetworkService::SetFirstPartySets_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetExplicitlyAllowedPorts: {
      return &NetworkService::SetExplicitlyAllowedPorts_Sym::IPCStableHash;
    }
    case messages::NetworkService::kUpdateMaskedDomainList: {
      return &NetworkService::UpdateMaskedDomainList_Sym::IPCStableHash;
    }
    case messages::NetworkService::kParseHeaders: {
      return &NetworkService::ParseHeaders_Sym::IPCStableHash;
    }
    case messages::NetworkService::kEnableDataUseUpdates: {
      return &NetworkService::EnableDataUseUpdates_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetIPv6ReachabilityOverride: {
      return &NetworkService::SetIPv6ReachabilityOverride_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetGssapiLibraryLoadObserver: {
      return &NetworkService::SetGssapiLibraryLoadObserver_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetNetworkAnnotationMonitor: {
      return &NetworkService::SetNetworkAnnotationMonitor_Sym::IPCStableHash;
    }
    case messages::NetworkService::kSetTpcdMetadataGrants: {
      return &NetworkService::SetTpcdMetadataGrants_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetworkService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetworkService>(message.name())) {
      case messages::NetworkService::kSetParams:
            return "Receive network::mojom::NetworkService::SetParams";
      case messages::NetworkService::kStartNetLog:
            return "Receive network::mojom::NetworkService::StartNetLog";
      case messages::NetworkService::kAttachNetLogProxy:
            return "Receive network::mojom::NetworkService::AttachNetLogProxy";
      case messages::NetworkService::kSetSSLKeyLogFile:
            return "Receive network::mojom::NetworkService::SetSSLKeyLogFile";
      case messages::NetworkService::kCreateNetworkContext:
            return "Receive network::mojom::NetworkService::CreateNetworkContext";
      case messages::NetworkService::kConfigureStubHostResolver:
            return "Receive network::mojom::NetworkService::ConfigureStubHostResolver";
      case messages::NetworkService::kDisableQuic:
            return "Receive network::mojom::NetworkService::DisableQuic";
      case messages::NetworkService::kSetUpHttpAuth:
            return "Receive network::mojom::NetworkService::SetUpHttpAuth";
      case messages::NetworkService::kConfigureHttpAuthPrefs:
            return "Receive network::mojom::NetworkService::ConfigureHttpAuthPrefs";
      case messages::NetworkService::kSetRawHeadersAccess:
            return "Receive network::mojom::NetworkService::SetRawHeadersAccess";
      case messages::NetworkService::kSetMaxConnectionsPerProxyChain:
            return "Receive network::mojom::NetworkService::SetMaxConnectionsPerProxyChain";
      case messages::NetworkService::kGetNetworkChangeManager:
            return "Receive network::mojom::NetworkService::GetNetworkChangeManager";
      case messages::NetworkService::kGetNetworkQualityEstimatorManager:
            return "Receive network::mojom::NetworkService::GetNetworkQualityEstimatorManager";
      case messages::NetworkService::kGetDnsConfigChangeManager:
            return "Receive network::mojom::NetworkService::GetDnsConfigChangeManager";
      case messages::NetworkService::kGetNetworkList:
            return "Receive network::mojom::NetworkService::GetNetworkList";
      case messages::NetworkService::kOnTrustStoreChanged:
            return "Receive network::mojom::NetworkService::OnTrustStoreChanged";
      case messages::NetworkService::kOnClientCertStoreChanged:
            return "Receive network::mojom::NetworkService::OnClientCertStoreChanged";
      case messages::NetworkService::kSetEncryptionKey:
            return "Receive network::mojom::NetworkService::SetEncryptionKey";
      case messages::NetworkService::kOnMemoryPressure:
            return "Receive network::mojom::NetworkService::OnMemoryPressure";
      case messages::NetworkService::kOnPeerToPeerConnectionsCountChange:
            return "Receive network::mojom::NetworkService::OnPeerToPeerConnectionsCountChange";
      case messages::NetworkService::kSetTrustTokenKeyCommitments:
            return "Receive network::mojom::NetworkService::SetTrustTokenKeyCommitments";
      case messages::NetworkService::kClearSCTAuditingCache:
            return "Receive network::mojom::NetworkService::ClearSCTAuditingCache";
      case messages::NetworkService::kConfigureSCTAuditing:
            return "Receive network::mojom::NetworkService::ConfigureSCTAuditing";
      case messages::NetworkService::kUpdateCtLogList:
            return "Receive network::mojom::NetworkService::UpdateCtLogList";
      case messages::NetworkService::kUpdateCtKnownPopularSCTs:
            return "Receive network::mojom::NetworkService::UpdateCtKnownPopularSCTs";
      case messages::NetworkService::kSetCtEnforcementEnabled:
            return "Receive network::mojom::NetworkService::SetCtEnforcementEnabled";
      case messages::NetworkService::kUpdateKeyPinsList:
            return "Receive network::mojom::NetworkService::UpdateKeyPinsList";
      case messages::NetworkService::kBindTestInterfaceForTesting:
            return "Receive network::mojom::NetworkService::BindTestInterfaceForTesting";
      case messages::NetworkService::kSetFirstPartySets:
            return "Receive network::mojom::NetworkService::SetFirstPartySets";
      case messages::NetworkService::kSetExplicitlyAllowedPorts:
            return "Receive network::mojom::NetworkService::SetExplicitlyAllowedPorts";
      case messages::NetworkService::kUpdateMaskedDomainList:
            return "Receive network::mojom::NetworkService::UpdateMaskedDomainList";
      case messages::NetworkService::kParseHeaders:
            return "Receive network::mojom::NetworkService::ParseHeaders";
      case messages::NetworkService::kEnableDataUseUpdates:
            return "Receive network::mojom::NetworkService::EnableDataUseUpdates";
      case messages::NetworkService::kSetIPv6ReachabilityOverride:
            return "Receive network::mojom::NetworkService::SetIPv6ReachabilityOverride";
      case messages::NetworkService::kSetGssapiLibraryLoadObserver:
            return "Receive network::mojom::NetworkService::SetGssapiLibraryLoadObserver";
      case messages::NetworkService::kSetNetworkAnnotationMonitor:
            return "Receive network::mojom::NetworkService::SetNetworkAnnotationMonitor";
      case messages::NetworkService::kSetTpcdMetadataGrants:
            return "Receive network::mojom::NetworkService::SetTpcdMetadataGrants";
    }
  } else {
    switch (static_cast<messages::NetworkService>(message.name())) {
      case messages::NetworkService::kSetParams:
            return "Receive reply network::mojom::NetworkService::SetParams";
      case messages::NetworkService::kStartNetLog:
            return "Receive reply network::mojom::NetworkService::StartNetLog";
      case messages::NetworkService::kAttachNetLogProxy:
            return "Receive reply network::mojom::NetworkService::AttachNetLogProxy";
      case messages::NetworkService::kSetSSLKeyLogFile:
            return "Receive reply network::mojom::NetworkService::SetSSLKeyLogFile";
      case messages::NetworkService::kCreateNetworkContext:
            return "Receive reply network::mojom::NetworkService::CreateNetworkContext";
      case messages::NetworkService::kConfigureStubHostResolver:
            return "Receive reply network::mojom::NetworkService::ConfigureStubHostResolver";
      case messages::NetworkService::kDisableQuic:
            return "Receive reply network::mojom::NetworkService::DisableQuic";
      case messages::NetworkService::kSetUpHttpAuth:
            return "Receive reply network::mojom::NetworkService::SetUpHttpAuth";
      case messages::NetworkService::kConfigureHttpAuthPrefs:
            return "Receive reply network::mojom::NetworkService::ConfigureHttpAuthPrefs";
      case messages::NetworkService::kSetRawHeadersAccess:
            return "Receive reply network::mojom::NetworkService::SetRawHeadersAccess";
      case messages::NetworkService::kSetMaxConnectionsPerProxyChain:
            return "Receive reply network::mojom::NetworkService::SetMaxConnectionsPerProxyChain";
      case messages::NetworkService::kGetNetworkChangeManager:
            return "Receive reply network::mojom::NetworkService::GetNetworkChangeManager";
      case messages::NetworkService::kGetNetworkQualityEstimatorManager:
            return "Receive reply network::mojom::NetworkService::GetNetworkQualityEstimatorManager";
      case messages::NetworkService::kGetDnsConfigChangeManager:
            return "Receive reply network::mojom::NetworkService::GetDnsConfigChangeManager";
      case messages::NetworkService::kGetNetworkList:
            return "Receive reply network::mojom::NetworkService::GetNetworkList";
      case messages::NetworkService::kOnTrustStoreChanged:
            return "Receive reply network::mojom::NetworkService::OnTrustStoreChanged";
      case messages::NetworkService::kOnClientCertStoreChanged:
            return "Receive reply network::mojom::NetworkService::OnClientCertStoreChanged";
      case messages::NetworkService::kSetEncryptionKey:
            return "Receive reply network::mojom::NetworkService::SetEncryptionKey";
      case messages::NetworkService::kOnMemoryPressure:
            return "Receive reply network::mojom::NetworkService::OnMemoryPressure";
      case messages::NetworkService::kOnPeerToPeerConnectionsCountChange:
            return "Receive reply network::mojom::NetworkService::OnPeerToPeerConnectionsCountChange";
      case messages::NetworkService::kSetTrustTokenKeyCommitments:
            return "Receive reply network::mojom::NetworkService::SetTrustTokenKeyCommitments";
      case messages::NetworkService::kClearSCTAuditingCache:
            return "Receive reply network::mojom::NetworkService::ClearSCTAuditingCache";
      case messages::NetworkService::kConfigureSCTAuditing:
            return "Receive reply network::mojom::NetworkService::ConfigureSCTAuditing";
      case messages::NetworkService::kUpdateCtLogList:
            return "Receive reply network::mojom::NetworkService::UpdateCtLogList";
      case messages::NetworkService::kUpdateCtKnownPopularSCTs:
            return "Receive reply network::mojom::NetworkService::UpdateCtKnownPopularSCTs";
      case messages::NetworkService::kSetCtEnforcementEnabled:
            return "Receive reply network::mojom::NetworkService::SetCtEnforcementEnabled";
      case messages::NetworkService::kUpdateKeyPinsList:
            return "Receive reply network::mojom::NetworkService::UpdateKeyPinsList";
      case messages::NetworkService::kBindTestInterfaceForTesting:
            return "Receive reply network::mojom::NetworkService::BindTestInterfaceForTesting";
      case messages::NetworkService::kSetFirstPartySets:
            return "Receive reply network::mojom::NetworkService::SetFirstPartySets";
      case messages::NetworkService::kSetExplicitlyAllowedPorts:
            return "Receive reply network::mojom::NetworkService::SetExplicitlyAllowedPorts";
      case messages::NetworkService::kUpdateMaskedDomainList:
            return "Receive reply network::mojom::NetworkService::UpdateMaskedDomainList";
      case messages::NetworkService::kParseHeaders:
            return "Receive reply network::mojom::NetworkService::ParseHeaders";
      case messages::NetworkService::kEnableDataUseUpdates:
            return "Receive reply network::mojom::NetworkService::EnableDataUseUpdates";
      case messages::NetworkService::kSetIPv6ReachabilityOverride:
            return "Receive reply network::mojom::NetworkService::SetIPv6ReachabilityOverride";
      case messages::NetworkService::kSetGssapiLibraryLoadObserver:
            return "Receive reply network::mojom::NetworkService::SetGssapiLibraryLoadObserver";
      case messages::NetworkService::kSetNetworkAnnotationMonitor:
            return "Receive reply network::mojom::NetworkService::SetNetworkAnnotationMonitor";
      case messages::NetworkService::kSetTpcdMetadataGrants:
            return "Receive reply network::mojom::NetworkService::SetTpcdMetadataGrants";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetworkService::SetParams_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetParams");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::StartNetLog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::StartNetLog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::AttachNetLogProxy_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::AttachNetLogProxy");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetSSLKeyLogFile_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetSSLKeyLogFile");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::CreateNetworkContext_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::CreateNetworkContext");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::ConfigureStubHostResolver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::ConfigureStubHostResolver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::DisableQuic_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::DisableQuic");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetUpHttpAuth_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetUpHttpAuth");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::ConfigureHttpAuthPrefs_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::ConfigureHttpAuthPrefs");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetRawHeadersAccess_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetRawHeadersAccess");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetMaxConnectionsPerProxyChain_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetMaxConnectionsPerProxyChain");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::GetNetworkChangeManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::GetNetworkChangeManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::GetNetworkQualityEstimatorManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::GetNetworkQualityEstimatorManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::GetDnsConfigChangeManager_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::GetDnsConfigChangeManager");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::GetNetworkList_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::GetNetworkList");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::OnTrustStoreChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::OnTrustStoreChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::OnClientCertStoreChanged_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::OnClientCertStoreChanged");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetEncryptionKey_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetEncryptionKey");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::OnMemoryPressure_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::OnMemoryPressure");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::OnPeerToPeerConnectionsCountChange_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::OnPeerToPeerConnectionsCountChange");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetTrustTokenKeyCommitments_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetTrustTokenKeyCommitments");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::ClearSCTAuditingCache_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::ClearSCTAuditingCache");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::ConfigureSCTAuditing_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::ConfigureSCTAuditing");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::UpdateCtLogList_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::UpdateCtLogList");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::UpdateCtKnownPopularSCTs_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::UpdateCtKnownPopularSCTs");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetCtEnforcementEnabled_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetCtEnforcementEnabled");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::UpdateKeyPinsList_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::UpdateKeyPinsList");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::BindTestInterfaceForTesting_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::BindTestInterfaceForTesting");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetFirstPartySets_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetFirstPartySets");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetExplicitlyAllowedPorts_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetExplicitlyAllowedPorts");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::UpdateMaskedDomainList_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::UpdateMaskedDomainList");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::ParseHeaders_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::ParseHeaders");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::EnableDataUseUpdates_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::EnableDataUseUpdates");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetIPv6ReachabilityOverride_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetIPv6ReachabilityOverride");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetGssapiLibraryLoadObserver_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetGssapiLibraryLoadObserver");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetNetworkAnnotationMonitor_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetNetworkAnnotationMonitor");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetworkService::SetTpcdMetadataGrants_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::NetworkService::SetTpcdMetadataGrants");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NetworkService_GetNetworkList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_GetNetworkList_ForwardToCallback(
      NetworkService::GetNetworkListCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkService_GetNetworkList_ForwardToCallback(const NetworkService_GetNetworkList_ForwardToCallback&) = delete;
  NetworkService_GetNetworkList_ForwardToCallback& operator=(const NetworkService_GetNetworkList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::GetNetworkListCallback callback_;
};

class NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback(
      NetworkService::SetTrustTokenKeyCommitmentsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback(const NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback&) = delete;
  NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback& operator=(const NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::SetTrustTokenKeyCommitmentsCallback callback_;
};

class NetworkService_UpdateCtLogList_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_UpdateCtLogList_ForwardToCallback(
      NetworkService::UpdateCtLogListCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkService_UpdateCtLogList_ForwardToCallback(const NetworkService_UpdateCtLogList_ForwardToCallback&) = delete;
  NetworkService_UpdateCtLogList_ForwardToCallback& operator=(const NetworkService_UpdateCtLogList_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::UpdateCtLogListCallback callback_;
};

class NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback(
      NetworkService::UpdateCtKnownPopularSCTsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback(const NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback&) = delete;
  NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback& operator=(const NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::UpdateCtKnownPopularSCTsCallback callback_;
};

class NetworkService_SetCtEnforcementEnabled_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_SetCtEnforcementEnabled_ForwardToCallback(
      NetworkService::SetCtEnforcementEnabledCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkService_SetCtEnforcementEnabled_ForwardToCallback(const NetworkService_SetCtEnforcementEnabled_ForwardToCallback&) = delete;
  NetworkService_SetCtEnforcementEnabled_ForwardToCallback& operator=(const NetworkService_SetCtEnforcementEnabled_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::SetCtEnforcementEnabledCallback callback_;
};

class NetworkService_ParseHeaders_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkService_ParseHeaders_ForwardToCallback(
      NetworkService::ParseHeadersCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetworkService_ParseHeaders_ForwardToCallback(const NetworkService_ParseHeaders_ForwardToCallback&) = delete;
  NetworkService_ParseHeaders_ForwardToCallback& operator=(const NetworkService_ParseHeaders_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetworkService::ParseHeadersCallback callback_;
};

NetworkServiceProxy::NetworkServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkServiceProxy::SetParams(
    NetworkServiceParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetParams", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type NetworkServiceParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetParams), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetParams_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkServiceParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NetworkService.SetParams request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetParams");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::StartNetLog(
    ::base::File in_file, uint64_t in_max_total_size, ::net::NetLogCaptureMode in_capture_mode, ::base::Value::Dict in_constants) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::StartNetLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_total_size"), in_max_total_size,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_mode"), in_capture_mode,
                        "<value of type ::net::NetLogCaptureMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("constants"), in_constants,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kStartNetLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_StartNetLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in NetworkService.StartNetLog request");
  params->max_total_size = in_max_total_size;
  mojo::internal::Serialize<::network::mojom::NetLogCaptureMode>(
      in_capture_mode, &params->capture_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->constants)::BaseType> constants_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_constants, constants_fragment);
  params->constants.Set(
      constants_fragment.is_null() ? nullptr : constants_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->constants.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null constants in NetworkService.StartNetLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("StartNetLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::AttachNetLogProxy(
    ::mojo::PendingRemote<::network::mojom::NetLogProxySource> in_proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> in_proxy_sink) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::AttachNetLogProxy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_source"), in_proxy_source,
                        "<value of type ::mojo::PendingRemote<::network::mojom::NetLogProxySource>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_sink"), in_proxy_sink,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::NetLogProxySink>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kAttachNetLogProxy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_AttachNetLogProxy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetLogProxySourceInterfaceBase>>(
      in_proxy_source, &params->proxy_source, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->proxy_source),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid proxy_source in NetworkService.AttachNetLogProxy request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetLogProxySinkInterfaceBase>>(
      in_proxy_sink, &params->proxy_sink, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->proxy_sink),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid proxy_sink in NetworkService.AttachNetLogProxy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("AttachNetLogProxy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetSSLKeyLogFile(
    ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetSSLKeyLogFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetSSLKeyLogFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetSSLKeyLogFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file in NetworkService.SetSSLKeyLogFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetSSLKeyLogFile");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::CreateNetworkContext(
    ::mojo::PendingReceiver<::network::mojom::NetworkContext> in_context, ::network::mojom::NetworkContextParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::CreateNetworkContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::NetworkContext>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::network::mojom::NetworkContextParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kCreateNetworkContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_CreateNetworkContext_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkContextInterfaceBase>>(
      in_context, &params->context, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->context),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid context in NetworkService.CreateNetworkContext request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::NetworkContextParamsDataView>(
      in_params, params_fragment);
  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NetworkService.CreateNetworkContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("CreateNetworkContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::ConfigureStubHostResolver(
    bool in_insecure_dns_client_enabled, ::net::SecureDnsMode in_secure_dns_mode, const ::net::DnsOverHttpsConfig& in_dns_over_https_config, bool in_additional_dns_types_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::ConfigureStubHostResolver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("insecure_dns_client_enabled"), in_insecure_dns_client_enabled,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("secure_dns_mode"), in_secure_dns_mode,
                        "<value of type ::net::SecureDnsMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dns_over_https_config"), in_dns_over_https_config,
                        "<value of type const ::net::DnsOverHttpsConfig&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("additional_dns_types_enabled"), in_additional_dns_types_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kConfigureStubHostResolver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ConfigureStubHostResolver_Params_Data> params(
          message);
  params.Allocate();
  params->insecure_dns_client_enabled = in_insecure_dns_client_enabled;
  mojo::internal::Serialize<::network::mojom::SecureDnsMode>(
      in_secure_dns_mode, &params->secure_dns_mode);
  mojo::internal::MessageFragment<
      typename decltype(params->dns_over_https_config)::BaseType> dns_over_https_config_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::DnsOverHttpsConfigDataView>(
      in_dns_over_https_config, dns_over_https_config_fragment);
  params->dns_over_https_config.Set(
      dns_over_https_config_fragment.is_null() ? nullptr : dns_over_https_config_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->dns_over_https_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null dns_over_https_config in NetworkService.ConfigureStubHostResolver request");
  params->additional_dns_types_enabled = in_additional_dns_types_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ConfigureStubHostResolver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::DisableQuic(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkService::DisableQuic");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kDisableQuic), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_DisableQuic_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("DisableQuic");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetUpHttpAuth(
    HttpAuthStaticParamsPtr in_http_auth_static_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetUpHttpAuth", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_auth_static_params"), in_http_auth_static_params,
                        "<value of type HttpAuthStaticParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetUpHttpAuth), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetUpHttpAuth_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->http_auth_static_params)::BaseType> http_auth_static_params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpAuthStaticParamsDataView>(
      in_http_auth_static_params, http_auth_static_params_fragment);
  params->http_auth_static_params.Set(
      http_auth_static_params_fragment.is_null() ? nullptr : http_auth_static_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_auth_static_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_auth_static_params in NetworkService.SetUpHttpAuth request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetUpHttpAuth");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::ConfigureHttpAuthPrefs(
    HttpAuthDynamicParamsPtr in_http_auth_dynamic_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::ConfigureHttpAuthPrefs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("http_auth_dynamic_params"), in_http_auth_dynamic_params,
                        "<value of type HttpAuthDynamicParamsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kConfigureHttpAuthPrefs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->http_auth_dynamic_params)::BaseType> http_auth_dynamic_params_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpAuthDynamicParamsDataView>(
      in_http_auth_dynamic_params, http_auth_dynamic_params_fragment);
  params->http_auth_dynamic_params.Set(
      http_auth_dynamic_params_fragment.is_null() ? nullptr : http_auth_dynamic_params_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_auth_dynamic_params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_auth_dynamic_params in NetworkService.ConfigureHttpAuthPrefs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ConfigureHttpAuthPrefs");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetRawHeadersAccess(
    int32_t in_process_id, const std::vector<::url::Origin>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetRawHeadersAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("process_id"), in_process_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origins"), in_origins,
                        "<value of type const std::vector<::url::Origin>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetRawHeadersAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetRawHeadersAccess_Params_Data> params(
          message);
  params.Allocate();
  params->process_id = in_process_id;
  mojo::internal::MessageFragment<
      typename decltype(params->origins)::BaseType>
      origins_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins, origins_fragment, &origins_validate_params);
  params->origins.Set(
      origins_fragment.is_null() ? nullptr : origins_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in NetworkService.SetRawHeadersAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetRawHeadersAccess");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetMaxConnectionsPerProxyChain(
    int32_t in_max_connections) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetMaxConnectionsPerProxyChain", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_connections"), in_max_connections,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetMaxConnectionsPerProxyChain), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetMaxConnectionsPerProxyChain_Params_Data> params(
          message);
  params.Allocate();
  params->max_connections = in_max_connections;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetMaxConnectionsPerProxyChain");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::GetNetworkChangeManager(
    ::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> in_network_change_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::GetNetworkChangeManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("network_change_manager"), in_network_change_manager,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::NetworkChangeManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kGetNetworkChangeManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkChangeManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkChangeManagerInterfaceBase>>(
      in_network_change_manager, &params->network_change_manager, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->network_change_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid network_change_manager in NetworkService.GetNetworkChangeManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkChangeManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::GetNetworkQualityEstimatorManager(
    ::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::GetNetworkQualityEstimatorManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kGetNetworkQualityEstimatorManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkQualityEstimatorManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkService.GetNetworkQualityEstimatorManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkQualityEstimatorManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::GetDnsConfigChangeManager(
    ::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::GetDnsConfigChangeManager", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kGetDnsConfigChangeManager), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetDnsConfigChangeManager_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::DnsConfigChangeManagerInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkService.GetDnsConfigChangeManager request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetDnsConfigChangeManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::GetNetworkList(
    uint32_t in_policy, GetNetworkListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::GetNetworkList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("policy"), in_policy,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kGetNetworkList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkList_Params_Data> params(
          message);
  params.Allocate();
  params->policy = in_policy;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_GetNetworkList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceProxy::OnTrustStoreChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkService::OnTrustStoreChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kOnTrustStoreChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_OnTrustStoreChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("OnTrustStoreChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::OnClientCertStoreChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkService::OnClientCertStoreChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kOnClientCertStoreChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_OnClientCertStoreChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("OnClientCertStoreChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetEncryptionKey(
    const std::string& in_encryption_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetEncryptionKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("encryption_key"), in_encryption_key,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetEncryptionKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetEncryptionKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->encryption_key)::BaseType> encryption_key_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_encryption_key, encryption_key_fragment);
  params->encryption_key.Set(
      encryption_key_fragment.is_null() ? nullptr : encryption_key_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->encryption_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null encryption_key in NetworkService.SetEncryptionKey request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetEncryptionKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::OnMemoryPressure(
    ::base::MemoryPressureListener::MemoryPressureLevel in_memory_pressure_level) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::OnMemoryPressure", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("memory_pressure_level"), in_memory_pressure_level,
                        "<value of type ::base::MemoryPressureListener::MemoryPressureLevel>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kOnMemoryPressure), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_OnMemoryPressure_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::MemoryPressureLevel>(
      in_memory_pressure_level, &params->memory_pressure_level);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("OnMemoryPressure");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::OnPeerToPeerConnectionsCountChange(
    uint32_t in_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::OnPeerToPeerConnectionsCountChange", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kOnPeerToPeerConnectionsCountChange), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data> params(
          message);
  params.Allocate();
  params->count = in_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("OnPeerToPeerConnectionsCountChange");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetTrustTokenKeyCommitments(
    const std::string& in_raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetTrustTokenKeyCommitments", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("raw_commitments"), in_raw_commitments,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetTrustTokenKeyCommitments), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->raw_commitments)::BaseType> raw_commitments_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_raw_commitments, raw_commitments_fragment);
  params->raw_commitments.Set(
      raw_commitments_fragment.is_null() ? nullptr : raw_commitments_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->raw_commitments.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_commitments in NetworkService.SetTrustTokenKeyCommitments request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetTrustTokenKeyCommitments");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceProxy::ClearSCTAuditingCache(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::NetworkService::ClearSCTAuditingCache");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kClearSCTAuditingCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ClearSCTAuditingCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ClearSCTAuditingCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::ConfigureSCTAuditing(
    SCTAuditingConfigurationPtr in_configuration) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::ConfigureSCTAuditing", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("configuration"), in_configuration,
                        "<value of type SCTAuditingConfigurationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kConfigureSCTAuditing), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ConfigureSCTAuditing_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->configuration)::BaseType> configuration_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SCTAuditingConfigurationDataView>(
      in_configuration, configuration_fragment);
  params->configuration.Set(
      configuration_fragment.is_null() ? nullptr : configuration_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->configuration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null configuration in NetworkService.ConfigureSCTAuditing request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ConfigureSCTAuditing");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::UpdateCtLogList(
    std::vector<::network::mojom::CTLogInfoPtr> in_log_list, UpdateCtLogListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::UpdateCtLogList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("log_list"), in_log_list,
                        "<value of type std::vector<::network::mojom::CTLogInfoPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kUpdateCtLogList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateCtLogList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->log_list)::BaseType>
      log_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& log_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CTLogInfoDataView>>(
      in_log_list, log_list_fragment, &log_list_validate_params);
  params->log_list.Set(
      log_list_fragment.is_null() ? nullptr : log_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->log_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null log_list in NetworkService.UpdateCtLogList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateCtLogList");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_UpdateCtLogList_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceProxy::UpdateCtKnownPopularSCTs(
    const std::vector<std::vector<uint8_t>>& in_sct_hashes, UpdateCtKnownPopularSCTsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::UpdateCtKnownPopularSCTs", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sct_hashes"), in_sct_hashes,
                        "<value of type const std::vector<std::vector<uint8_t>>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kUpdateCtKnownPopularSCTs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateCtKnownPopularSCTs_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sct_hashes)::BaseType>
      sct_hashes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sct_hashes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_sct_hashes, sct_hashes_fragment, &sct_hashes_validate_params);
  params->sct_hashes.Set(
      sct_hashes_fragment.is_null() ? nullptr : sct_hashes_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sct_hashes.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sct_hashes in NetworkService.UpdateCtKnownPopularSCTs request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateCtKnownPopularSCTs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceProxy::SetCtEnforcementEnabled(
    bool in_enabled, SetCtEnforcementEnabledCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetCtEnforcementEnabled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enabled"), in_enabled,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetCtEnforcementEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetCtEnforcementEnabled_Params_Data> params(
          message);
  params.Allocate();
  params->enabled = in_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetCtEnforcementEnabled");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_SetCtEnforcementEnabled_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceProxy::UpdateKeyPinsList(
    ::network::mojom::PinListPtr in_pin_list, ::base::Time in_update_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::UpdateKeyPinsList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pin_list"), in_pin_list,
                        "<value of type ::network::mojom::PinListPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_time"), in_update_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kUpdateKeyPinsList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateKeyPinsList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pin_list)::BaseType> pin_list_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::PinListDataView>(
      in_pin_list, pin_list_fragment);
  params->pin_list.Set(
      pin_list_fragment.is_null() ? nullptr : pin_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->pin_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null pin_list in NetworkService.UpdateKeyPinsList request");
  mojo::internal::MessageFragment<
      typename decltype(params->update_time)::BaseType> update_time_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_update_time, update_time_fragment);
  params->update_time.Set(
      update_time_fragment.is_null() ? nullptr : update_time_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->update_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null update_time in NetworkService.UpdateKeyPinsList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateKeyPinsList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::BindTestInterfaceForTesting(
    ::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::BindTestInterfaceForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::NetworkServiceTest>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kBindTestInterfaceForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_BindTestInterfaceForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetworkServiceTestInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkService.BindTestInterfaceForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("BindTestInterfaceForTesting");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetFirstPartySets(
    ::net::GlobalFirstPartySets in_sets) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetFirstPartySets", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sets"), in_sets,
                        "<value of type ::net::GlobalFirstPartySets>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetFirstPartySets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetFirstPartySets_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sets)::BaseType> sets_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::GlobalFirstPartySetsDataView>(
      in_sets, sets_fragment);
  params->sets.Set(
      sets_fragment.is_null() ? nullptr : sets_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sets.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sets in NetworkService.SetFirstPartySets request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetFirstPartySets");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetExplicitlyAllowedPorts(
    const std::vector<uint16_t>& in_ports) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetExplicitlyAllowedPorts", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ports"), in_ports,
                        "<value of type const std::vector<uint16_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetExplicitlyAllowedPorts), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetExplicitlyAllowedPorts_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ports)::BaseType>
      ports_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& ports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
      in_ports, ports_fragment, &ports_validate_params);
  params->ports.Set(
      ports_fragment.is_null() ? nullptr : ports_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ports.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ports in NetworkService.SetExplicitlyAllowedPorts request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetExplicitlyAllowedPorts");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::UpdateMaskedDomainList(
    ::mojo_base::ProtoWrapper in_masked_domain_list, const std::vector<std::string>& in_exclusion_list) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::UpdateMaskedDomainList", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("masked_domain_list"), in_masked_domain_list,
                        "<value of type ::mojo_base::ProtoWrapper>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exclusion_list"), in_exclusion_list,
                        "<value of type const std::vector<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kUpdateMaskedDomainList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateMaskedDomainList_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->masked_domain_list)::BaseType> masked_domain_list_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ProtoWrapperDataView>(
      in_masked_domain_list, masked_domain_list_fragment);
  params->masked_domain_list.Set(
      masked_domain_list_fragment.is_null() ? nullptr : masked_domain_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->masked_domain_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null masked_domain_list in NetworkService.UpdateMaskedDomainList request");
  mojo::internal::MessageFragment<
      typename decltype(params->exclusion_list)::BaseType>
      exclusion_list_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& exclusion_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_exclusion_list, exclusion_list_fragment, &exclusion_list_validate_params);
  params->exclusion_list.Set(
      exclusion_list_fragment.is_null() ? nullptr : exclusion_list_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->exclusion_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null exclusion_list in NetworkService.UpdateMaskedDomainList request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateMaskedDomainList");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::ParseHeaders(
    const ::GURL& in_url, const ::scoped_refptr<::net::HttpResponseHeaders>& in_headers, ParseHeadersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::ParseHeaders", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("headers"), in_headers,
                        "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kParseHeaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ParseHeaders_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkService.ParseHeaders request");
  mojo::internal::MessageFragment<
      typename decltype(params->headers)::BaseType> headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_headers, headers_fragment);
  params->headers.Set(
      headers_fragment.is_null() ? nullptr : headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in NetworkService.ParseHeaders request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ParseHeaders");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkService_ParseHeaders_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetworkServiceProxy::EnableDataUseUpdates(
    bool in_enable) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::EnableDataUseUpdates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("enable"), in_enable,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kEnableDataUseUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_EnableDataUseUpdates_Params_Data> params(
          message);
  params.Allocate();
  params->enable = in_enable;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("EnableDataUseUpdates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetIPv6ReachabilityOverride(
    bool in_reachability_override) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetIPv6ReachabilityOverride", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reachability_override"), in_reachability_override,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetIPv6ReachabilityOverride), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetIPv6ReachabilityOverride_Params_Data> params(
          message);
  params.Allocate();
  params->reachability_override = in_reachability_override;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetIPv6ReachabilityOverride");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetGssapiLibraryLoadObserver(
    ::mojo::PendingRemote<GssapiLibraryLoadObserver> in_gssapi_library_load_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetGssapiLibraryLoadObserver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("gssapi_library_load_observer"), in_gssapi_library_load_observer,
                        "<value of type ::mojo::PendingRemote<GssapiLibraryLoadObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetGssapiLibraryLoadObserver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetGssapiLibraryLoadObserver_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::GssapiLibraryLoadObserverInterfaceBase>>(
      in_gssapi_library_load_observer, &params->gssapi_library_load_observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->gssapi_library_load_observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid gssapi_library_load_observer in NetworkService.SetGssapiLibraryLoadObserver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetGssapiLibraryLoadObserver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetNetworkAnnotationMonitor(
    ::mojo::PendingRemote<::network::mojom::NetworkAnnotationMonitor> in_remote) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetNetworkAnnotationMonitor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("remote"), in_remote,
                        "<value of type ::mojo::PendingRemote<::network::mojom::NetworkAnnotationMonitor>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetNetworkAnnotationMonitor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetNetworkAnnotationMonitor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkAnnotationMonitorInterfaceBase>>(
      in_remote, &params->remote, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->remote),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid remote in NetworkService.SetNetworkAnnotationMonitor request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetNetworkAnnotationMonitor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NetworkServiceProxy::SetTpcdMetadataGrants(
    const std::vector<::ContentSettingPatternSource>& in_settings) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetworkService::SetTpcdMetadataGrants", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("settings"), in_settings,
                        "<value of type const std::vector<::ContentSettingPatternSource>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetTpcdMetadataGrants), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetTpcdMetadataGrants_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->settings)::BaseType>
      settings_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
      in_settings, settings_fragment, &settings_validate_params);
  params->settings.Set(
      settings_fragment.is_null() ? nullptr : settings_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->settings.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null settings in NetworkService.SetTpcdMetadataGrants request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetTpcdMetadataGrants");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class NetworkService_GetNetworkList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkService::GetNetworkListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkService_GetNetworkList_ProxyToResponder> proxy(
        new NetworkService_GetNetworkList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkService_GetNetworkList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_GetNetworkList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkService_GetNetworkList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::GetNetworkListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<std::vector<::net::NetworkInterface>>& in_networks);
};

bool NetworkService_GetNetworkList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkService_GetNetworkList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_GetNetworkList_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for NetworkService.14
  bool success = true;
  std::optional<std::vector<::net::NetworkInterface>> p_networks{};
  NetworkService_GetNetworkList_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadNetworks(&p_networks))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_networks));
  return true;
}

void NetworkService_GetNetworkList_ProxyToResponder::Run(
    const std::optional<std::vector<::net::NetworkInterface>>& in_networks) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkService::GetNetworkList", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("networks"), in_networks,
                        "<value of type const std::optional<std::vector<::net::NetworkInterface>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kGetNetworkList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_GetNetworkList_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->networks)::BaseType>
      networks_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& networks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::NetworkInterfaceDataView>>(
      in_networks, networks_fragment, &networks_validate_params);
  params->networks.Set(
      networks_fragment.is_null() ? nullptr : networks_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("GetNetworkList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkService::SetTrustTokenKeyCommitmentsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder> proxy(
        new NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::SetTrustTokenKeyCommitmentsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkService_SetTrustTokenKeyCommitments_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for NetworkService.20
  bool success = true;
  NetworkService_SetTrustTokenKeyCommitments_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkService::SetTrustTokenKeyCommitments");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetTrustTokenKeyCommitments), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetTrustTokenKeyCommitments");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_UpdateCtLogList_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkService::UpdateCtLogListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkService_UpdateCtLogList_ProxyToResponder> proxy(
        new NetworkService_UpdateCtLogList_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkService_UpdateCtLogList_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_UpdateCtLogList_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkService_UpdateCtLogList_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::UpdateCtLogListCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkService_UpdateCtLogList_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkService_UpdateCtLogList_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_UpdateCtLogList_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for NetworkService.23
  bool success = true;
  NetworkService_UpdateCtLogList_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 23, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkService_UpdateCtLogList_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkService::UpdateCtLogList");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kUpdateCtLogList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateCtLogList_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateCtLogList");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkService::UpdateCtKnownPopularSCTsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder> proxy(
        new NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::UpdateCtKnownPopularSCTsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkService_UpdateCtKnownPopularSCTs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for NetworkService.24
  bool success = true;
  NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 24, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkService::UpdateCtKnownPopularSCTs");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kUpdateCtKnownPopularSCTs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("UpdateCtKnownPopularSCTs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_SetCtEnforcementEnabled_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkService::SetCtEnforcementEnabledCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkService_SetCtEnforcementEnabled_ProxyToResponder> proxy(
        new NetworkService_SetCtEnforcementEnabled_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkService_SetCtEnforcementEnabled_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_SetCtEnforcementEnabled_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkService_SetCtEnforcementEnabled_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::SetCtEnforcementEnabledCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetworkService_SetCtEnforcementEnabled_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkService_SetCtEnforcementEnabled_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_SetCtEnforcementEnabled_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for NetworkService.25
  bool success = true;
  NetworkService_SetCtEnforcementEnabled_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 25, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkService_SetCtEnforcementEnabled_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::NetworkService::SetCtEnforcementEnabled");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kSetCtEnforcementEnabled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_SetCtEnforcementEnabled_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("SetCtEnforcementEnabled");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkService_ParseHeaders_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetworkService::ParseHeadersCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetworkService_ParseHeaders_ProxyToResponder> proxy(
        new NetworkService_ParseHeaders_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetworkService_ParseHeaders_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkService_ParseHeaders_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetworkService_ParseHeaders_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkService::ParseHeadersCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::ParsedHeadersPtr in_parsed_headers);
};

bool NetworkService_ParseHeaders_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetworkService_ParseHeaders_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkService_ParseHeaders_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for NetworkService.31
  bool success = true;
  ::network::mojom::ParsedHeadersPtr p_parsed_headers{};
  NetworkService_ParseHeaders_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadParsedHeaders(&p_parsed_headers))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkService::Name_, 31, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_parsed_headers));
  return true;
}

void NetworkService_ParseHeaders_ProxyToResponder::Run(
    ::network::mojom::ParsedHeadersPtr in_parsed_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetworkService::ParseHeaders", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("parsed_headers"), in_parsed_headers,
                        "<value of type ::network::mojom::ParsedHeadersPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetworkService::kParseHeaders), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetworkService_ParseHeaders_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->parsed_headers)::BaseType> parsed_headers_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ParsedHeadersDataView>(
      in_parsed_headers, parsed_headers_fragment);
  params->parsed_headers.Set(
      parsed_headers_fragment.is_null() ? nullptr : parsed_headers_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parsed_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parsed_headers in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkService::Name_);
  message.set_method_name("ParseHeaders");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkServiceStubDispatch::Accept(
    NetworkService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetworkService>(message->header()->name)) {
    case messages::NetworkService::kSetParams: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetParams_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetParams_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.0
      bool success = true;
      NetworkServiceParamsPtr p_params{};
      NetworkService_SetParams_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetParams(        
        std::move(p_params));
      return true;
    }
    case messages::NetworkService::kStartNetLog: {
      DCHECK(message->is_serialized());
      internal::NetworkService_StartNetLog_Params_Data* params =
          reinterpret_cast<internal::NetworkService_StartNetLog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.1
      bool success = true;
      ::base::File p_file{};
      uint64_t p_max_total_size{};
      ::net::NetLogCaptureMode p_capture_mode{};
      ::base::Value::Dict p_constants{};
      NetworkService_StartNetLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (success)
        p_max_total_size = input_data_view.max_total_size();
      if (success && !input_data_view.ReadCaptureMode(&p_capture_mode))
        success = false;
      if (success && !input_data_view.ReadConstants(&p_constants))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartNetLog(        
        std::move(p_file), 
        std::move(p_max_total_size), 
        std::move(p_capture_mode), 
        std::move(p_constants));
      return true;
    }
    case messages::NetworkService::kAttachNetLogProxy: {
      DCHECK(message->is_serialized());
      internal::NetworkService_AttachNetLogProxy_Params_Data* params =
          reinterpret_cast<internal::NetworkService_AttachNetLogProxy_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.2
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::NetLogProxySource> p_proxy_source{};
      ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> p_proxy_sink{};
      NetworkService_AttachNetLogProxy_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_proxy_source =
            input_data_view.TakeProxySource<decltype(p_proxy_source)>();
      }
      if (success) {
        p_proxy_sink =
            input_data_view.TakeProxySink<decltype(p_proxy_sink)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachNetLogProxy(        
        std::move(p_proxy_source), 
        std::move(p_proxy_sink));
      return true;
    }
    case messages::NetworkService::kSetSSLKeyLogFile: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetSSLKeyLogFile_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetSSLKeyLogFile_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.3
      bool success = true;
      ::base::File p_file{};
      NetworkService_SetSSLKeyLogFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFile(&p_file))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSSLKeyLogFile(        
        std::move(p_file));
      return true;
    }
    case messages::NetworkService::kCreateNetworkContext: {
      DCHECK(message->is_serialized());
      internal::NetworkService_CreateNetworkContext_Params_Data* params =
          reinterpret_cast<internal::NetworkService_CreateNetworkContext_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.4
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::NetworkContext> p_context{};
      ::network::mojom::NetworkContextParamsPtr p_params{};
      NetworkService_CreateNetworkContext_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNetworkContext(        
        std::move(p_context), 
        std::move(p_params));
      return true;
    }
    case messages::NetworkService::kConfigureStubHostResolver: {
      DCHECK(message->is_serialized());
      internal::NetworkService_ConfigureStubHostResolver_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ConfigureStubHostResolver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.5
      bool success = true;
      bool p_insecure_dns_client_enabled{};
      ::net::SecureDnsMode p_secure_dns_mode{};
      ::net::DnsOverHttpsConfig p_dns_over_https_config{};
      bool p_additional_dns_types_enabled{};
      NetworkService_ConfigureStubHostResolver_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_insecure_dns_client_enabled = input_data_view.insecure_dns_client_enabled();
      if (success && !input_data_view.ReadSecureDnsMode(&p_secure_dns_mode))
        success = false;
      if (success && !input_data_view.ReadDnsOverHttpsConfig(&p_dns_over_https_config))
        success = false;
      if (success)
        p_additional_dns_types_enabled = input_data_view.additional_dns_types_enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureStubHostResolver(        
        std::move(p_insecure_dns_client_enabled), 
        std::move(p_secure_dns_mode), 
        std::move(p_dns_over_https_config), 
        std::move(p_additional_dns_types_enabled));
      return true;
    }
    case messages::NetworkService::kDisableQuic: {
      DCHECK(message->is_serialized());
      internal::NetworkService_DisableQuic_Params_Data* params =
          reinterpret_cast<internal::NetworkService_DisableQuic_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.6
      bool success = true;
      NetworkService_DisableQuic_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableQuic(        );
      return true;
    }
    case messages::NetworkService::kSetUpHttpAuth: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetUpHttpAuth_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetUpHttpAuth_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.7
      bool success = true;
      HttpAuthStaticParamsPtr p_http_auth_static_params{};
      NetworkService_SetUpHttpAuth_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHttpAuthStaticParams(&p_http_auth_static_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUpHttpAuth(        
        std::move(p_http_auth_static_params));
      return true;
    }
    case messages::NetworkService::kConfigureHttpAuthPrefs: {
      DCHECK(message->is_serialized());
      internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.8
      bool success = true;
      HttpAuthDynamicParamsPtr p_http_auth_dynamic_params{};
      NetworkService_ConfigureHttpAuthPrefs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadHttpAuthDynamicParams(&p_http_auth_dynamic_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureHttpAuthPrefs(        
        std::move(p_http_auth_dynamic_params));
      return true;
    }
    case messages::NetworkService::kSetRawHeadersAccess: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetRawHeadersAccess_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetRawHeadersAccess_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.9
      bool success = true;
      int32_t p_process_id{};
      std::vector<::url::Origin> p_origins{};
      NetworkService_SetRawHeadersAccess_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success && !input_data_view.ReadOrigins(&p_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetRawHeadersAccess(        
        std::move(p_process_id), 
        std::move(p_origins));
      return true;
    }
    case messages::NetworkService::kSetMaxConnectionsPerProxyChain: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetMaxConnectionsPerProxyChain_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetMaxConnectionsPerProxyChain_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.10
      bool success = true;
      int32_t p_max_connections{};
      NetworkService_SetMaxConnectionsPerProxyChain_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_max_connections = input_data_view.max_connections();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMaxConnectionsPerProxyChain(        
        std::move(p_max_connections));
      return true;
    }
    case messages::NetworkService::kGetNetworkChangeManager: {
      DCHECK(message->is_serialized());
      internal::NetworkService_GetNetworkChangeManager_Params_Data* params =
          reinterpret_cast<internal::NetworkService_GetNetworkChangeManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.11
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> p_network_change_manager{};
      NetworkService_GetNetworkChangeManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_network_change_manager =
            input_data_view.TakeNetworkChangeManager<decltype(p_network_change_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNetworkChangeManager(        
        std::move(p_network_change_manager));
      return true;
    }
    case messages::NetworkService::kGetNetworkQualityEstimatorManager: {
      DCHECK(message->is_serialized());
      internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data* params =
          reinterpret_cast<internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.12
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> p_receiver{};
      NetworkService_GetNetworkQualityEstimatorManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNetworkQualityEstimatorManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::NetworkService::kGetDnsConfigChangeManager: {
      DCHECK(message->is_serialized());
      internal::NetworkService_GetDnsConfigChangeManager_Params_Data* params =
          reinterpret_cast<internal::NetworkService_GetDnsConfigChangeManager_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.13
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> p_receiver{};
      NetworkService_GetDnsConfigChangeManager_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDnsConfigChangeManager(        
        std::move(p_receiver));
      return true;
    }
    case messages::NetworkService::kGetNetworkList: {
      break;
    }
    case messages::NetworkService::kOnTrustStoreChanged: {
      DCHECK(message->is_serialized());
      internal::NetworkService_OnTrustStoreChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkService_OnTrustStoreChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.15
      bool success = true;
      NetworkService_OnTrustStoreChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTrustStoreChanged(        );
      return true;
    }
    case messages::NetworkService::kOnClientCertStoreChanged: {
      DCHECK(message->is_serialized());
      internal::NetworkService_OnClientCertStoreChanged_Params_Data* params =
          reinterpret_cast<internal::NetworkService_OnClientCertStoreChanged_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.16
      bool success = true;
      NetworkService_OnClientCertStoreChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClientCertStoreChanged(        );
      return true;
    }
    case messages::NetworkService::kSetEncryptionKey: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetEncryptionKey_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetEncryptionKey_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.17
      bool success = true;
      std::string p_encryption_key{};
      NetworkService_SetEncryptionKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEncryptionKey(&p_encryption_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEncryptionKey(        
        std::move(p_encryption_key));
      return true;
    }
    case messages::NetworkService::kOnMemoryPressure: {
      DCHECK(message->is_serialized());
      internal::NetworkService_OnMemoryPressure_Params_Data* params =
          reinterpret_cast<internal::NetworkService_OnMemoryPressure_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.18
      bool success = true;
      ::base::MemoryPressureListener::MemoryPressureLevel p_memory_pressure_level{};
      NetworkService_OnMemoryPressure_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMemoryPressureLevel(&p_memory_pressure_level))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnMemoryPressure(        
        std::move(p_memory_pressure_level));
      return true;
    }
    case messages::NetworkService::kOnPeerToPeerConnectionsCountChange: {
      DCHECK(message->is_serialized());
      internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data* params =
          reinterpret_cast<internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.19
      bool success = true;
      uint32_t p_count{};
      NetworkService_OnPeerToPeerConnectionsCountChange_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_count = input_data_view.count();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPeerToPeerConnectionsCountChange(        
        std::move(p_count));
      return true;
    }
    case messages::NetworkService::kSetTrustTokenKeyCommitments: {
      break;
    }
    case messages::NetworkService::kClearSCTAuditingCache: {
      DCHECK(message->is_serialized());
      internal::NetworkService_ClearSCTAuditingCache_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ClearSCTAuditingCache_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.21
      bool success = true;
      NetworkService_ClearSCTAuditingCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearSCTAuditingCache(        );
      return true;
    }
    case messages::NetworkService::kConfigureSCTAuditing: {
      DCHECK(message->is_serialized());
      internal::NetworkService_ConfigureSCTAuditing_Params_Data* params =
          reinterpret_cast<internal::NetworkService_ConfigureSCTAuditing_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.22
      bool success = true;
      SCTAuditingConfigurationPtr p_configuration{};
      NetworkService_ConfigureSCTAuditing_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadConfiguration(&p_configuration))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureSCTAuditing(        
        std::move(p_configuration));
      return true;
    }
    case messages::NetworkService::kUpdateCtLogList: {
      break;
    }
    case messages::NetworkService::kUpdateCtKnownPopularSCTs: {
      break;
    }
    case messages::NetworkService::kSetCtEnforcementEnabled: {
      break;
    }
    case messages::NetworkService::kUpdateKeyPinsList: {
      DCHECK(message->is_serialized());
      internal::NetworkService_UpdateKeyPinsList_Params_Data* params =
          reinterpret_cast<internal::NetworkService_UpdateKeyPinsList_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.26
      bool success = true;
      ::network::mojom::PinListPtr p_pin_list{};
      ::base::Time p_update_time{};
      NetworkService_UpdateKeyPinsList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPinList(&p_pin_list))
        success = false;
      if (success && !input_data_view.ReadUpdateTime(&p_update_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateKeyPinsList(        
        std::move(p_pin_list), 
        std::move(p_update_time));
      return true;
    }
    case messages::NetworkService::kBindTestInterfaceForTesting: {
      DCHECK(message->is_serialized());
      internal::NetworkService_BindTestInterfaceForTesting_Params_Data* params =
          reinterpret_cast<internal::NetworkService_BindTestInterfaceForTesting_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.27
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> p_receiver{};
      NetworkService_BindTestInterfaceForTesting_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 27, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindTestInterfaceForTesting(        
        std::move(p_receiver));
      return true;
    }
    case messages::NetworkService::kSetFirstPartySets: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetFirstPartySets_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetFirstPartySets_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.28
      bool success = true;
      ::net::GlobalFirstPartySets p_sets{};
      NetworkService_SetFirstPartySets_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSets(&p_sets))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 28, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetFirstPartySets(        
        std::move(p_sets));
      return true;
    }
    case messages::NetworkService::kSetExplicitlyAllowedPorts: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetExplicitlyAllowedPorts_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetExplicitlyAllowedPorts_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.29
      bool success = true;
      std::vector<uint16_t> p_ports{};
      NetworkService_SetExplicitlyAllowedPorts_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPorts(&p_ports))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 29, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetExplicitlyAllowedPorts(        
        std::move(p_ports));
      return true;
    }
    case messages::NetworkService::kUpdateMaskedDomainList: {
      DCHECK(message->is_serialized());
      internal::NetworkService_UpdateMaskedDomainList_Params_Data* params =
          reinterpret_cast<internal::NetworkService_UpdateMaskedDomainList_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.30
      bool success = true;
      ::mojo_base::ProtoWrapper p_masked_domain_list{mojo::internal::DefaultConstructTag()};
      std::vector<std::string> p_exclusion_list{};
      NetworkService_UpdateMaskedDomainList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMaskedDomainList(&p_masked_domain_list))
        success = false;
      if (success && !input_data_view.ReadExclusionList(&p_exclusion_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateMaskedDomainList(        
        std::move(p_masked_domain_list), 
        std::move(p_exclusion_list));
      return true;
    }
    case messages::NetworkService::kParseHeaders: {
      break;
    }
    case messages::NetworkService::kEnableDataUseUpdates: {
      DCHECK(message->is_serialized());
      internal::NetworkService_EnableDataUseUpdates_Params_Data* params =
          reinterpret_cast<internal::NetworkService_EnableDataUseUpdates_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.32
      bool success = true;
      bool p_enable{};
      NetworkService_EnableDataUseUpdates_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enable = input_data_view.enable();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 32, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableDataUseUpdates(        
        std::move(p_enable));
      return true;
    }
    case messages::NetworkService::kSetIPv6ReachabilityOverride: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetIPv6ReachabilityOverride_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetIPv6ReachabilityOverride_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.33
      bool success = true;
      bool p_reachability_override{};
      NetworkService_SetIPv6ReachabilityOverride_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reachability_override = input_data_view.reachability_override();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 33, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIPv6ReachabilityOverride(        
        std::move(p_reachability_override));
      return true;
    }
    case messages::NetworkService::kSetGssapiLibraryLoadObserver: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetGssapiLibraryLoadObserver_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetGssapiLibraryLoadObserver_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.34
      bool success = true;
      ::mojo::PendingRemote<GssapiLibraryLoadObserver> p_gssapi_library_load_observer{};
      NetworkService_SetGssapiLibraryLoadObserver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_gssapi_library_load_observer =
            input_data_view.TakeGssapiLibraryLoadObserver<decltype(p_gssapi_library_load_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetGssapiLibraryLoadObserver(        
        std::move(p_gssapi_library_load_observer));
      return true;
    }
    case messages::NetworkService::kSetNetworkAnnotationMonitor: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetNetworkAnnotationMonitor_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetNetworkAnnotationMonitor_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.35
      bool success = true;
      ::mojo::PendingRemote<::network::mojom::NetworkAnnotationMonitor> p_remote{};
      NetworkService_SetNetworkAnnotationMonitor_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_remote =
            input_data_view.TakeRemote<decltype(p_remote)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNetworkAnnotationMonitor(        
        std::move(p_remote));
      return true;
    }
    case messages::NetworkService::kSetTpcdMetadataGrants: {
      DCHECK(message->is_serialized());
      internal::NetworkService_SetTpcdMetadataGrants_Params_Data* params =
          reinterpret_cast<internal::NetworkService_SetTpcdMetadataGrants_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for NetworkService.36
      bool success = true;
      std::vector<::ContentSettingPatternSource> p_settings{};
      NetworkService_SetTpcdMetadataGrants_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSettings(&p_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 36, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTpcdMetadataGrants(        
        std::move(p_settings));
      return true;
    }
  }
  return false;
}

// static
bool NetworkServiceStubDispatch::AcceptWithResponder(
    NetworkService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetworkService>(message->header()->name)) {
    case messages::NetworkService::kSetParams: {
      break;
    }
    case messages::NetworkService::kStartNetLog: {
      break;
    }
    case messages::NetworkService::kAttachNetLogProxy: {
      break;
    }
    case messages::NetworkService::kSetSSLKeyLogFile: {
      break;
    }
    case messages::NetworkService::kCreateNetworkContext: {
      break;
    }
    case messages::NetworkService::kConfigureStubHostResolver: {
      break;
    }
    case messages::NetworkService::kDisableQuic: {
      break;
    }
    case messages::NetworkService::kSetUpHttpAuth: {
      break;
    }
    case messages::NetworkService::kConfigureHttpAuthPrefs: {
      break;
    }
    case messages::NetworkService::kSetRawHeadersAccess: {
      break;
    }
    case messages::NetworkService::kSetMaxConnectionsPerProxyChain: {
      break;
    }
    case messages::NetworkService::kGetNetworkChangeManager: {
      break;
    }
    case messages::NetworkService::kGetNetworkQualityEstimatorManager: {
      break;
    }
    case messages::NetworkService::kGetDnsConfigChangeManager: {
      break;
    }
    case messages::NetworkService::kGetNetworkList: {
      internal::NetworkService_GetNetworkList_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_GetNetworkList_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for NetworkService.14
      bool success = true;
      uint32_t p_policy{};
      NetworkService_GetNetworkList_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_policy = input_data_view.policy();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 14, false);
        return false;
      }
      NetworkService::GetNetworkListCallback callback =
          NetworkService_GetNetworkList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNetworkList(        
        std::move(p_policy), std::move(callback));
      return true;
    }
    case messages::NetworkService::kOnTrustStoreChanged: {
      break;
    }
    case messages::NetworkService::kOnClientCertStoreChanged: {
      break;
    }
    case messages::NetworkService::kSetEncryptionKey: {
      break;
    }
    case messages::NetworkService::kOnMemoryPressure: {
      break;
    }
    case messages::NetworkService::kOnPeerToPeerConnectionsCountChange: {
      break;
    }
    case messages::NetworkService::kSetTrustTokenKeyCommitments: {
      internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for NetworkService.20
      bool success = true;
      std::string p_raw_commitments{};
      NetworkService_SetTrustTokenKeyCommitments_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadRawCommitments(&p_raw_commitments))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 20, false);
        return false;
      }
      NetworkService::SetTrustTokenKeyCommitmentsCallback callback =
          NetworkService_SetTrustTokenKeyCommitments_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTrustTokenKeyCommitments(        
        std::move(p_raw_commitments), std::move(callback));
      return true;
    }
    case messages::NetworkService::kClearSCTAuditingCache: {
      break;
    }
    case messages::NetworkService::kConfigureSCTAuditing: {
      break;
    }
    case messages::NetworkService::kUpdateCtLogList: {
      internal::NetworkService_UpdateCtLogList_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_UpdateCtLogList_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for NetworkService.23
      bool success = true;
      std::vector<::network::mojom::CTLogInfoPtr> p_log_list{};
      NetworkService_UpdateCtLogList_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLogList(&p_log_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 23, false);
        return false;
      }
      NetworkService::UpdateCtLogListCallback callback =
          NetworkService_UpdateCtLogList_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCtLogList(        
        std::move(p_log_list), std::move(callback));
      return true;
    }
    case messages::NetworkService::kUpdateCtKnownPopularSCTs: {
      internal::NetworkService_UpdateCtKnownPopularSCTs_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_UpdateCtKnownPopularSCTs_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for NetworkService.24
      bool success = true;
      std::vector<std::vector<uint8_t>> p_sct_hashes{};
      NetworkService_UpdateCtKnownPopularSCTs_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSctHashes(&p_sct_hashes))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 24, false);
        return false;
      }
      NetworkService::UpdateCtKnownPopularSCTsCallback callback =
          NetworkService_UpdateCtKnownPopularSCTs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCtKnownPopularSCTs(        
        std::move(p_sct_hashes), std::move(callback));
      return true;
    }
    case messages::NetworkService::kSetCtEnforcementEnabled: {
      internal::NetworkService_SetCtEnforcementEnabled_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_SetCtEnforcementEnabled_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for NetworkService.25
      bool success = true;
      bool p_enabled{};
      NetworkService_SetCtEnforcementEnabled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 25, false);
        return false;
      }
      NetworkService::SetCtEnforcementEnabledCallback callback =
          NetworkService_SetCtEnforcementEnabled_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCtEnforcementEnabled(        
        std::move(p_enabled), std::move(callback));
      return true;
    }
    case messages::NetworkService::kUpdateKeyPinsList: {
      break;
    }
    case messages::NetworkService::kBindTestInterfaceForTesting: {
      break;
    }
    case messages::NetworkService::kSetFirstPartySets: {
      break;
    }
    case messages::NetworkService::kSetExplicitlyAllowedPorts: {
      break;
    }
    case messages::NetworkService::kUpdateMaskedDomainList: {
      break;
    }
    case messages::NetworkService::kParseHeaders: {
      internal::NetworkService_ParseHeaders_Params_Data* params =
          reinterpret_cast<
              internal::NetworkService_ParseHeaders_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for NetworkService.31
      bool success = true;
      ::GURL p_url{};
      ::scoped_refptr<::net::HttpResponseHeaders> p_headers{};
      NetworkService_ParseHeaders_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkService::Name_, 31, false);
        return false;
      }
      NetworkService::ParseHeadersCallback callback =
          NetworkService_ParseHeaders_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseHeaders(        
        std::move(p_url), 
        std::move(p_headers), std::move(callback));
      return true;
    }
    case messages::NetworkService::kEnableDataUseUpdates: {
      break;
    }
    case messages::NetworkService::kSetIPv6ReachabilityOverride: {
      break;
    }
    case messages::NetworkService::kSetGssapiLibraryLoadObserver: {
      break;
    }
    case messages::NetworkService::kSetNetworkAnnotationMonitor: {
      break;
    }
    case messages::NetworkService::kSetTpcdMetadataGrants: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkServiceValidationInfo[] = {
    {base::to_underlying(messages::NetworkService::kSetParams),
     { &internal::NetworkService_SetParams_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kStartNetLog),
     { &internal::NetworkService_StartNetLog_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kAttachNetLogProxy),
     { &internal::NetworkService_AttachNetLogProxy_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetSSLKeyLogFile),
     { &internal::NetworkService_SetSSLKeyLogFile_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kCreateNetworkContext),
     { &internal::NetworkService_CreateNetworkContext_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kConfigureStubHostResolver),
     { &internal::NetworkService_ConfigureStubHostResolver_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kDisableQuic),
     { &internal::NetworkService_DisableQuic_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetUpHttpAuth),
     { &internal::NetworkService_SetUpHttpAuth_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kConfigureHttpAuthPrefs),
     { &internal::NetworkService_ConfigureHttpAuthPrefs_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetRawHeadersAccess),
     { &internal::NetworkService_SetRawHeadersAccess_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetMaxConnectionsPerProxyChain),
     { &internal::NetworkService_SetMaxConnectionsPerProxyChain_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kGetNetworkChangeManager),
     { &internal::NetworkService_GetNetworkChangeManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kGetNetworkQualityEstimatorManager),
     { &internal::NetworkService_GetNetworkQualityEstimatorManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kGetDnsConfigChangeManager),
     { &internal::NetworkService_GetDnsConfigChangeManager_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kGetNetworkList),
     { &internal::NetworkService_GetNetworkList_Params_Data::Validate,
      &internal::NetworkService_GetNetworkList_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkService::kOnTrustStoreChanged),
     { &internal::NetworkService_OnTrustStoreChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kOnClientCertStoreChanged),
     { &internal::NetworkService_OnClientCertStoreChanged_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetEncryptionKey),
     { &internal::NetworkService_SetEncryptionKey_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kOnMemoryPressure),
     { &internal::NetworkService_OnMemoryPressure_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kOnPeerToPeerConnectionsCountChange),
     { &internal::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetTrustTokenKeyCommitments),
     { &internal::NetworkService_SetTrustTokenKeyCommitments_Params_Data::Validate,
      &internal::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkService::kClearSCTAuditingCache),
     { &internal::NetworkService_ClearSCTAuditingCache_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kConfigureSCTAuditing),
     { &internal::NetworkService_ConfigureSCTAuditing_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kUpdateCtLogList),
     { &internal::NetworkService_UpdateCtLogList_Params_Data::Validate,
      &internal::NetworkService_UpdateCtLogList_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkService::kUpdateCtKnownPopularSCTs),
     { &internal::NetworkService_UpdateCtKnownPopularSCTs_Params_Data::Validate,
      &internal::NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkService::kSetCtEnforcementEnabled),
     { &internal::NetworkService_SetCtEnforcementEnabled_Params_Data::Validate,
      &internal::NetworkService_SetCtEnforcementEnabled_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkService::kUpdateKeyPinsList),
     { &internal::NetworkService_UpdateKeyPinsList_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kBindTestInterfaceForTesting),
     { &internal::NetworkService_BindTestInterfaceForTesting_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetFirstPartySets),
     { &internal::NetworkService_SetFirstPartySets_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetExplicitlyAllowedPorts),
     { &internal::NetworkService_SetExplicitlyAllowedPorts_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kUpdateMaskedDomainList),
     { &internal::NetworkService_UpdateMaskedDomainList_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kParseHeaders),
     { &internal::NetworkService_ParseHeaders_Params_Data::Validate,
      &internal::NetworkService_ParseHeaders_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::NetworkService::kEnableDataUseUpdates),
     { &internal::NetworkService_EnableDataUseUpdates_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetIPv6ReachabilityOverride),
     { &internal::NetworkService_SetIPv6ReachabilityOverride_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetGssapiLibraryLoadObserver),
     { &internal::NetworkService_SetGssapiLibraryLoadObserver_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetNetworkAnnotationMonitor),
     { &internal::NetworkService_SetNetworkAnnotationMonitor_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::NetworkService::kSetTpcdMetadataGrants),
     { &internal::NetworkService_SetTpcdMetadataGrants_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkServiceValidationInfo);
}

bool NetworkServiceResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkService::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNetworkServiceValidationInfo);

}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::HttpAuthStaticParams::DataView, ::network::mojom::HttpAuthStaticParamsPtr>::Read(
    ::network::mojom::HttpAuthStaticParams::DataView input,
    ::network::mojom::HttpAuthStaticParamsPtr* output) {
  bool success = true;
  ::network::mojom::HttpAuthStaticParamsPtr result(::network::mojom::HttpAuthStaticParams::New());
  
      if (success && !input.ReadGssapiLibraryName(&result->gssapi_library_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HttpAuthDynamicParams::DataView, ::network::mojom::HttpAuthDynamicParamsPtr>::Read(
    ::network::mojom::HttpAuthDynamicParams::DataView input,
    ::network::mojom::HttpAuthDynamicParamsPtr* output) {
  bool success = true;
  ::network::mojom::HttpAuthDynamicParamsPtr result(::network::mojom::HttpAuthDynamicParams::New());
  
      if (success && !input.ReadAllowedSchemes(&result->allowed_schemes))
        success = false;
      if (success && !input.ReadPatternsAllowedToUseAllSchemes(&result->patterns_allowed_to_use_all_schemes))
        success = false;
      if (success && !input.ReadServerAllowlist(&result->server_allowlist))
        success = false;
      if (success && !input.ReadDelegateAllowlist(&result->delegate_allowlist))
        success = false;
      if (success)
        result->delegate_by_kdc_policy = input.delegate_by_kdc_policy();
      if (success)
        result->negotiate_disable_cname_lookup = input.negotiate_disable_cname_lookup();
      if (success)
        result->enable_negotiate_port = input.enable_negotiate_port();
      if (success)
        result->ntlm_v2_enabled = input.ntlm_v2_enabled();
      if (success && !input.ReadAndroidNegotiateAccountType(&result->android_negotiate_account_type))
        success = false;
      if (success)
        result->allow_gssapi_library_load = input.allow_gssapi_library_load();
      if (success)
        result->basic_over_http_enabled = input.basic_over_http_enabled();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::EnvironmentVariable::DataView, ::network::mojom::EnvironmentVariablePtr>::Read(
    ::network::mojom::EnvironmentVariable::DataView input,
    ::network::mojom::EnvironmentVariablePtr* output) {
  bool success = true;
  ::network::mojom::EnvironmentVariablePtr result(::network::mojom::EnvironmentVariable::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadValue(&result->value))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetworkServiceParams::DataView, ::network::mojom::NetworkServiceParamsPtr>::Read(
    ::network::mojom::NetworkServiceParams::DataView input,
    ::network::mojom::NetworkServiceParamsPtr* output) {
  bool success = true;
  ::network::mojom::NetworkServiceParamsPtr result(::network::mojom::NetworkServiceParams::New());
  
      if (success && !input.ReadInitialConnectionType(&result->initial_connection_type))
        success = false;
      if (success && !input.ReadInitialConnectionSubtype(&result->initial_connection_subtype))
        success = false;
      if (success && !input.ReadInitialAddressMap(&result->initial_address_map))
        success = false;
      if (success && !input.ReadEnvironment(&result->environment))
        success = false;
      if (success) {
        result->default_observer =
            input.TakeDefaultObserver<decltype(result->default_observer)>();
      }
      if (success)
        result->first_party_sets_enabled = input.first_party_sets_enabled();
      if (success) {
        result->system_dns_resolver =
            input.TakeSystemDnsResolver<decltype(result->system_dns_resolver)>();
      }
      if (success && !input.ReadIpProtectionProxyBypassPolicy(&result->ip_protection_proxy_bypass_policy))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SCTAuditingConfiguration::DataView, ::network::mojom::SCTAuditingConfigurationPtr>::Read(
    ::network::mojom::SCTAuditingConfiguration::DataView input,
    ::network::mojom::SCTAuditingConfigurationPtr* output) {
  bool success = true;
  ::network::mojom::SCTAuditingConfigurationPtr result(::network::mojom::SCTAuditingConfiguration::New());
  
      if (success)
        result->sampling_rate = input.sampling_rate();
      if (success && !input.ReadLogExpectedIngestionDelay(&result->log_expected_ingestion_delay))
        success = false;
      if (success && !input.ReadLogMaxIngestionRandomDelay(&result->log_max_ingestion_random_delay))
        success = false;
      if (success && !input.ReadReportUri(&result->report_uri))
        success = false;
      if (success && !input.ReadHashdanceLookupUri(&result->hashdance_lookup_uri))
        success = false;
      if (success && !input.ReadTrafficAnnotation(&result->traffic_annotation))
        success = false;
      if (success && !input.ReadHashdanceTrafficAnnotation(&result->hashdance_traffic_annotation))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void GssapiLibraryLoadObserverInterceptorForTesting::OnBeforeGssapiLibraryLoad() {
  GetForwardingInterface()->OnBeforeGssapiLibraryLoad();
}
GssapiLibraryLoadObserverAsyncWaiter::GssapiLibraryLoadObserverAsyncWaiter(
    GssapiLibraryLoadObserver* proxy) : proxy_(proxy) {}

GssapiLibraryLoadObserverAsyncWaiter::~GssapiLibraryLoadObserverAsyncWaiter() = default;




void NetworkServiceInterceptorForTesting::SetParams(NetworkServiceParamsPtr params) {
  GetForwardingInterface()->SetParams(
    std::move(params)
    );
}
void NetworkServiceInterceptorForTesting::StartNetLog(::base::File file, uint64_t max_total_size, ::net::NetLogCaptureMode capture_mode, ::base::Value::Dict constants) {
  GetForwardingInterface()->StartNetLog(
    std::move(file)
    , 
    std::move(max_total_size)
    , 
    std::move(capture_mode)
    , 
    std::move(constants)
    );
}
void NetworkServiceInterceptorForTesting::AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) {
  GetForwardingInterface()->AttachNetLogProxy(
    std::move(proxy_source)
    , 
    std::move(proxy_sink)
    );
}
void NetworkServiceInterceptorForTesting::SetSSLKeyLogFile(::base::File file) {
  GetForwardingInterface()->SetSSLKeyLogFile(
    std::move(file)
    );
}
void NetworkServiceInterceptorForTesting::CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) {
  GetForwardingInterface()->CreateNetworkContext(
    std::move(context)
    , 
    std::move(params)
    );
}
void NetworkServiceInterceptorForTesting::ConfigureStubHostResolver(bool insecure_dns_client_enabled, ::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& dns_over_https_config, bool additional_dns_types_enabled) {
  GetForwardingInterface()->ConfigureStubHostResolver(
    std::move(insecure_dns_client_enabled)
    , 
    std::move(secure_dns_mode)
    , 
    std::move(dns_over_https_config)
    , 
    std::move(additional_dns_types_enabled)
    );
}
void NetworkServiceInterceptorForTesting::DisableQuic() {
  GetForwardingInterface()->DisableQuic();
}
void NetworkServiceInterceptorForTesting::SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) {
  GetForwardingInterface()->SetUpHttpAuth(
    std::move(http_auth_static_params)
    );
}
void NetworkServiceInterceptorForTesting::ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) {
  GetForwardingInterface()->ConfigureHttpAuthPrefs(
    std::move(http_auth_dynamic_params)
    );
}
void NetworkServiceInterceptorForTesting::SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) {
  GetForwardingInterface()->SetRawHeadersAccess(
    std::move(process_id)
    , 
    std::move(origins)
    );
}
void NetworkServiceInterceptorForTesting::SetMaxConnectionsPerProxyChain(int32_t max_connections) {
  GetForwardingInterface()->SetMaxConnectionsPerProxyChain(
    std::move(max_connections)
    );
}
void NetworkServiceInterceptorForTesting::GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) {
  GetForwardingInterface()->GetNetworkChangeManager(
    std::move(network_change_manager)
    );
}
void NetworkServiceInterceptorForTesting::GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) {
  GetForwardingInterface()->GetNetworkQualityEstimatorManager(
    std::move(receiver)
    );
}
void NetworkServiceInterceptorForTesting::GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) {
  GetForwardingInterface()->GetDnsConfigChangeManager(
    std::move(receiver)
    );
}
void NetworkServiceInterceptorForTesting::GetNetworkList(uint32_t policy, GetNetworkListCallback callback) {
  GetForwardingInterface()->GetNetworkList(
    std::move(policy)
    , std::move(callback));
}
void NetworkServiceInterceptorForTesting::OnTrustStoreChanged() {
  GetForwardingInterface()->OnTrustStoreChanged();
}
void NetworkServiceInterceptorForTesting::OnClientCertStoreChanged() {
  GetForwardingInterface()->OnClientCertStoreChanged();
}
void NetworkServiceInterceptorForTesting::SetEncryptionKey(const std::string& encryption_key) {
  GetForwardingInterface()->SetEncryptionKey(
    std::move(encryption_key)
    );
}
void NetworkServiceInterceptorForTesting::OnMemoryPressure(::base::MemoryPressureListener::MemoryPressureLevel memory_pressure_level) {
  GetForwardingInterface()->OnMemoryPressure(
    std::move(memory_pressure_level)
    );
}
void NetworkServiceInterceptorForTesting::OnPeerToPeerConnectionsCountChange(uint32_t count) {
  GetForwardingInterface()->OnPeerToPeerConnectionsCountChange(
    std::move(count)
    );
}
void NetworkServiceInterceptorForTesting::SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) {
  GetForwardingInterface()->SetTrustTokenKeyCommitments(
    std::move(raw_commitments)
    , std::move(callback));
}
void NetworkServiceInterceptorForTesting::ClearSCTAuditingCache() {
  GetForwardingInterface()->ClearSCTAuditingCache();
}
void NetworkServiceInterceptorForTesting::ConfigureSCTAuditing(SCTAuditingConfigurationPtr configuration) {
  GetForwardingInterface()->ConfigureSCTAuditing(
    std::move(configuration)
    );
}
void NetworkServiceInterceptorForTesting::UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, UpdateCtLogListCallback callback) {
  GetForwardingInterface()->UpdateCtLogList(
    std::move(log_list)
    , std::move(callback));
}
void NetworkServiceInterceptorForTesting::UpdateCtKnownPopularSCTs(const std::vector<std::vector<uint8_t>>& sct_hashes, UpdateCtKnownPopularSCTsCallback callback) {
  GetForwardingInterface()->UpdateCtKnownPopularSCTs(
    std::move(sct_hashes)
    , std::move(callback));
}
void NetworkServiceInterceptorForTesting::SetCtEnforcementEnabled(bool enabled, SetCtEnforcementEnabledCallback callback) {
  GetForwardingInterface()->SetCtEnforcementEnabled(
    std::move(enabled)
    , std::move(callback));
}
void NetworkServiceInterceptorForTesting::UpdateKeyPinsList(::network::mojom::PinListPtr pin_list, ::base::Time update_time) {
  GetForwardingInterface()->UpdateKeyPinsList(
    std::move(pin_list)
    , 
    std::move(update_time)
    );
}
void NetworkServiceInterceptorForTesting::BindTestInterfaceForTesting(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) {
  GetForwardingInterface()->BindTestInterfaceForTesting(
    std::move(receiver)
    );
}
void NetworkServiceInterceptorForTesting::SetFirstPartySets(::net::GlobalFirstPartySets sets) {
  GetForwardingInterface()->SetFirstPartySets(
    std::move(sets)
    );
}
void NetworkServiceInterceptorForTesting::SetExplicitlyAllowedPorts(const std::vector<uint16_t>& ports) {
  GetForwardingInterface()->SetExplicitlyAllowedPorts(
    std::move(ports)
    );
}
void NetworkServiceInterceptorForTesting::UpdateMaskedDomainList(::mojo_base::ProtoWrapper masked_domain_list, const std::vector<std::string>& exclusion_list) {
  GetForwardingInterface()->UpdateMaskedDomainList(
    std::move(masked_domain_list)
    , 
    std::move(exclusion_list)
    );
}
void NetworkServiceInterceptorForTesting::ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ParseHeadersCallback callback) {
  GetForwardingInterface()->ParseHeaders(
    std::move(url)
    , 
    std::move(headers)
    , std::move(callback));
}
void NetworkServiceInterceptorForTesting::EnableDataUseUpdates(bool enable) {
  GetForwardingInterface()->EnableDataUseUpdates(
    std::move(enable)
    );
}
void NetworkServiceInterceptorForTesting::SetIPv6ReachabilityOverride(bool reachability_override) {
  GetForwardingInterface()->SetIPv6ReachabilityOverride(
    std::move(reachability_override)
    );
}
void NetworkServiceInterceptorForTesting::SetGssapiLibraryLoadObserver(::mojo::PendingRemote<GssapiLibraryLoadObserver> gssapi_library_load_observer) {
  GetForwardingInterface()->SetGssapiLibraryLoadObserver(
    std::move(gssapi_library_load_observer)
    );
}
void NetworkServiceInterceptorForTesting::SetNetworkAnnotationMonitor(::mojo::PendingRemote<::network::mojom::NetworkAnnotationMonitor> remote) {
  GetForwardingInterface()->SetNetworkAnnotationMonitor(
    std::move(remote)
    );
}
void NetworkServiceInterceptorForTesting::SetTpcdMetadataGrants(const std::vector<::ContentSettingPatternSource>& settings) {
  GetForwardingInterface()->SetTpcdMetadataGrants(
    std::move(settings)
    );
}
NetworkServiceAsyncWaiter::NetworkServiceAsyncWaiter(
    NetworkService* proxy) : proxy_(proxy) {}

NetworkServiceAsyncWaiter::~NetworkServiceAsyncWaiter() = default;

void NetworkServiceAsyncWaiter::GetNetworkList(
    uint32_t policy, std::optional<std::vector<::net::NetworkInterface>>* out_networks) {
  base::RunLoop loop;
  proxy_->GetNetworkList(
      std::move(policy),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<std::vector<::net::NetworkInterface>>* out_networks
,
             const std::optional<std::vector<::net::NetworkInterface>>& networks) {*out_networks = std::move(networks);
            loop->Quit();
          },
          &loop,
          out_networks));
  loop.Run();
}

std::optional<std::vector<::net::NetworkInterface>> NetworkServiceAsyncWaiter::GetNetworkList(
    uint32_t policy) {
  std::optional<std::vector<::net::NetworkInterface>> async_wait_result;
  GetNetworkList(std::move(policy),&async_wait_result);
  return async_wait_result;
}

void NetworkServiceAsyncWaiter::SetTrustTokenKeyCommitments(
    const std::string& raw_commitments) {
  base::RunLoop loop;
  proxy_->SetTrustTokenKeyCommitments(
      std::move(raw_commitments),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceAsyncWaiter::UpdateCtLogList(
    std::vector<::network::mojom::CTLogInfoPtr> log_list) {
  base::RunLoop loop;
  proxy_->UpdateCtLogList(
      std::move(log_list),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceAsyncWaiter::UpdateCtKnownPopularSCTs(
    const std::vector<std::vector<uint8_t>>& sct_hashes) {
  base::RunLoop loop;
  proxy_->UpdateCtKnownPopularSCTs(
      std::move(sct_hashes),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceAsyncWaiter::SetCtEnforcementEnabled(
    bool enabled) {
  base::RunLoop loop;
  proxy_->SetCtEnforcementEnabled(
      std::move(enabled),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetworkServiceAsyncWaiter::ParseHeaders(
    const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ::network::mojom::ParsedHeadersPtr* out_parsed_headers) {
  base::RunLoop loop;
  proxy_->ParseHeaders(
      std::move(url),
      std::move(headers),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::network::mojom::ParsedHeadersPtr* out_parsed_headers
,
             ::network::mojom::ParsedHeadersPtr parsed_headers) {*out_parsed_headers = std::move(parsed_headers);
            loop->Quit();
          },
          &loop,
          out_parsed_headers));
  loop.Run();
}

::network::mojom::ParsedHeadersPtr NetworkServiceAsyncWaiter::ParseHeaders(
    const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers) {
  ::network::mojom::ParsedHeadersPtr async_wait_result;
  ParseHeaders(std::move(url),std::move(headers),&async_wait_result);
  return async_wait_result;
}






}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif