// services/network/public/mojom/parsed_request_cookie.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_REQUEST_COOKIE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_REQUEST_COOKIE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/parsed_request_cookie.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/parsed_request_cookie.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/parsed_request_cookie.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/network/public/cpp/parsed_request_cookie_mojom_traits.h"




namespace network::mojom {





class  ParsedRequestCookie {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ParsedRequestCookie, T>::value>;
  using DataView = ParsedRequestCookieDataView;
  using Data_ = internal::ParsedRequestCookie_Data;

  template <typename... Args>
  static ParsedRequestCookiePtr New(Args&&... args) {
    return ParsedRequestCookiePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ParsedRequestCookiePtr From(const U& u) {
    return mojo::TypeConverter<ParsedRequestCookiePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ParsedRequestCookie>::Convert(*this);
  }


  ParsedRequestCookie();

  ParsedRequestCookie(
      const std::string& name,
      const std::string& value);


  ~ParsedRequestCookie();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ParsedRequestCookiePtr>
  ParsedRequestCookiePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ParsedRequestCookie::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ParsedRequestCookie::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ParsedRequestCookie::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ParsedRequestCookie::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ParsedRequestCookie::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ParsedRequestCookie_UnserializedMessageContext<
            UserType, ParsedRequestCookie::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ParsedRequestCookie::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ParsedRequestCookie::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ParsedRequestCookie_UnserializedMessageContext<
            UserType, ParsedRequestCookie::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ParsedRequestCookie::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ParsedRequestCookie::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ParsedRequestCookie::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ParsedRequestCookie::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ParsedRequestCookie::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ParsedRequestCookiePtr ParsedRequestCookie::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, ParsedRequestCookie::EnableIfSame<T>*>
bool ParsedRequestCookie::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, ParsedRequestCookie::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ParsedRequestCookie::DataView,
                                         ::network::mojom::ParsedRequestCookiePtr> {
  static bool IsNull(const ::network::mojom::ParsedRequestCookiePtr& input) { return !input; }
  static void SetToNull(::network::mojom::ParsedRequestCookiePtr* output) { output->reset(); }

  static const decltype(::network::mojom::ParsedRequestCookie::name)& name(
      const ::network::mojom::ParsedRequestCookiePtr& input) {
    return input->name;
  }

  static const decltype(::network::mojom::ParsedRequestCookie::value)& value(
      const ::network::mojom::ParsedRequestCookiePtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::ParsedRequestCookie::DataView input, ::network::mojom::ParsedRequestCookiePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PARSED_REQUEST_COOKIE_MOJOM_H_