// services/network/public/mojom/shared_dictionary_access_observer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-params-data.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared-message-ids.h"

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-blink-import-headers.h"
#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
SharedDictionaryAccessDetails::SharedDictionaryAccessDetails()
    : type(),
      url(),
      isolation_key(),
      is_blocked(false) {}

SharedDictionaryAccessDetails::SharedDictionaryAccessDetails(
    SharedDictionaryAccessDetails::Type type_in,
    const ::blink::KURL& url_in,
    ::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key_in,
    bool is_blocked_in)
    : type(std::move(type_in)),
      url(std::move(url_in)),
      isolation_key(std::move(isolation_key_in)),
      is_blocked(std::move(is_blocked_in)) {}

SharedDictionaryAccessDetails::~SharedDictionaryAccessDetails() = default;

void SharedDictionaryAccessDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SharedDictionaryAccessDetails::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "isolation_key"), this->isolation_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::SharedDictionaryIsolationKeyPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_blocked"), this->is_blocked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SharedDictionaryAccessDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char SharedDictionaryAccessObserver::Name_[] = "network.mojom.SharedDictionaryAccessObserver";

SharedDictionaryAccessObserver::IPCStableHashFunction SharedDictionaryAccessObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SharedDictionaryAccessObserver>(message.name())) {
    case messages::SharedDictionaryAccessObserver::kOnSharedDictionaryAccessed: {
      return &SharedDictionaryAccessObserver::OnSharedDictionaryAccessed_Sym::IPCStableHash;
    }
    case messages::SharedDictionaryAccessObserver::kClone: {
      return &SharedDictionaryAccessObserver::Clone_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SharedDictionaryAccessObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SharedDictionaryAccessObserver>(message.name())) {
      case messages::SharedDictionaryAccessObserver::kOnSharedDictionaryAccessed:
            return "Receive network::mojom::SharedDictionaryAccessObserver::OnSharedDictionaryAccessed";
      case messages::SharedDictionaryAccessObserver::kClone:
            return "Receive network::mojom::SharedDictionaryAccessObserver::Clone";
    }
  } else {
    switch (static_cast<messages::SharedDictionaryAccessObserver>(message.name())) {
      case messages::SharedDictionaryAccessObserver::kOnSharedDictionaryAccessed:
            return "Receive reply network::mojom::SharedDictionaryAccessObserver::OnSharedDictionaryAccessed";
      case messages::SharedDictionaryAccessObserver::kClone:
            return "Receive reply network::mojom::SharedDictionaryAccessObserver::Clone";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SharedDictionaryAccessObserver::OnSharedDictionaryAccessed_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::SharedDictionaryAccessObserver::OnSharedDictionaryAccessed");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SharedDictionaryAccessObserver::Clone_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::SharedDictionaryAccessObserver::Clone");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SharedDictionaryAccessObserverProxy::SharedDictionaryAccessObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SharedDictionaryAccessObserverProxy::OnSharedDictionaryAccessed(
    SharedDictionaryAccessDetailsPtr in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SharedDictionaryAccessObserver::OnSharedDictionaryAccessed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type SharedDictionaryAccessDetailsPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedDictionaryAccessObserver::kOnSharedDictionaryAccessed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SharedDictionaryAccessDetailsDataView>(
      in_details, details_fragment);
  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->details.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in SharedDictionaryAccessObserver.OnSharedDictionaryAccessed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedDictionaryAccessObserver::Name_);
  message.set_method_name("OnSharedDictionaryAccessed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SharedDictionaryAccessObserverProxy::Clone(
    ::mojo::PendingReceiver<SharedDictionaryAccessObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::SharedDictionaryAccessObserver::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingReceiver<SharedDictionaryAccessObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SharedDictionaryAccessObserver::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::SharedDictionaryAccessObserver_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::SharedDictionaryAccessObserverInterfaceBase>>(
      in_observer, &params->observer, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->observer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid observer in SharedDictionaryAccessObserver.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SharedDictionaryAccessObserver::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SharedDictionaryAccessObserverStubDispatch::Accept(
    SharedDictionaryAccessObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SharedDictionaryAccessObserver>(message->header()->name)) {
    case messages::SharedDictionaryAccessObserver::kOnSharedDictionaryAccessed: {
      DCHECK(message->is_serialized());
      internal::SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params_Data* params =
          reinterpret_cast<internal::SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SharedDictionaryAccessObserver.0
      bool success = true;
      SharedDictionaryAccessDetailsPtr p_details{};
      SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedDictionaryAccessObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSharedDictionaryAccessed(        
        std::move(p_details));
      return true;
    }
    case messages::SharedDictionaryAccessObserver::kClone: {
      DCHECK(message->is_serialized());
      internal::SharedDictionaryAccessObserver_Clone_Params_Data* params =
          reinterpret_cast<internal::SharedDictionaryAccessObserver_Clone_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for SharedDictionaryAccessObserver.1
      bool success = true;
      ::mojo::PendingReceiver<SharedDictionaryAccessObserver> p_observer{};
      SharedDictionaryAccessObserver_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SharedDictionaryAccessObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_observer));
      return true;
    }
  }
  return false;
}

// static
bool SharedDictionaryAccessObserverStubDispatch::AcceptWithResponder(
    SharedDictionaryAccessObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SharedDictionaryAccessObserver>(message->header()->name)) {
    case messages::SharedDictionaryAccessObserver::kOnSharedDictionaryAccessed: {
      break;
    }
    case messages::SharedDictionaryAccessObserver::kClone: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSharedDictionaryAccessObserverValidationInfo[] = {
    {base::to_underlying(messages::SharedDictionaryAccessObserver::kOnSharedDictionaryAccessed),
     { &internal::SharedDictionaryAccessObserver_OnSharedDictionaryAccessed_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::SharedDictionaryAccessObserver::kClone),
     { &internal::SharedDictionaryAccessObserver_Clone_Params_Data::Validate,
      nullptr /* no response */}},
};

bool SharedDictionaryAccessObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::blink::SharedDictionaryAccessObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSharedDictionaryAccessObserverValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::SharedDictionaryAccessDetails::DataView, ::network::mojom::blink::SharedDictionaryAccessDetailsPtr>::Read(
    ::network::mojom::blink::SharedDictionaryAccessDetails::DataView input,
    ::network::mojom::blink::SharedDictionaryAccessDetailsPtr* output) {
  bool success = true;
  ::network::mojom::blink::SharedDictionaryAccessDetailsPtr result(::network::mojom::blink::SharedDictionaryAccessDetails::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadIsolationKey(&result->isolation_key))
        success = false;
      if (success)
        result->is_blocked = input.is_blocked();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void SharedDictionaryAccessObserverInterceptorForTesting::OnSharedDictionaryAccessed(SharedDictionaryAccessDetailsPtr details) {
  GetForwardingInterface()->OnSharedDictionaryAccessed(
    std::move(details)
    );
}
void SharedDictionaryAccessObserverInterceptorForTesting::Clone(::mojo::PendingReceiver<SharedDictionaryAccessObserver> observer) {
  GetForwardingInterface()->Clone(
    std::move(observer)
    );
}
SharedDictionaryAccessObserverAsyncWaiter::SharedDictionaryAccessObserverAsyncWaiter(
    SharedDictionaryAccessObserver* proxy) : proxy_(proxy) {}

SharedDictionaryAccessObserverAsyncWaiter::~SharedDictionaryAccessObserverAsyncWaiter() = default;






}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif