// services/network/public/mojom/trust_tokens.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/trust_tokens.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/trust_tokens.mojom-params-data.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared-message-ids.h"

#include "services/network/public/mojom/trust_tokens.mojom-import-headers.h"
#include "services/network/public/mojom/trust_tokens.mojom-test-utils.h"


namespace network::mojom {
TrustTokenParams::TrustTokenParams()
    : operation(),
      refresh_policy(TrustTokenRefreshPolicy::kUseCached),
      custom_key_commitment(),
      custom_issuer(),
      sign_request_data(TrustTokenSignRequestData::kOmit),
      include_timestamp_header(false),
      issuers(),
      additional_signed_headers(),
      possibly_unsafe_additional_signing_data() {}

TrustTokenParams::TrustTokenParams(
    TrustTokenOperationType operation_in,
    TrustTokenRefreshPolicy refresh_policy_in,
    const std::optional<std::string>& custom_key_commitment_in,
    const std::optional<::url::Origin>& custom_issuer_in,
    TrustTokenSignRequestData sign_request_data_in,
    bool include_timestamp_header_in,
    std::vector<::url::Origin> issuers_in,
    std::vector<std::string> additional_signed_headers_in,
    const std::optional<std::string>& possibly_unsafe_additional_signing_data_in)
    : operation(std::move(operation_in)),
      refresh_policy(std::move(refresh_policy_in)),
      custom_key_commitment(std::move(custom_key_commitment_in)),
      custom_issuer(std::move(custom_issuer_in)),
      sign_request_data(std::move(sign_request_data_in)),
      include_timestamp_header(std::move(include_timestamp_header_in)),
      issuers(std::move(issuers_in)),
      additional_signed_headers(std::move(additional_signed_headers_in)),
      possibly_unsafe_additional_signing_data(std::move(possibly_unsafe_additional_signing_data_in)) {}

TrustTokenParams::~TrustTokenParams() = default;

void TrustTokenParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation"), this->operation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "refresh_policy"), this->refresh_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenRefreshPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_key_commitment"), this->custom_key_commitment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "custom_issuer"), this->custom_issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sign_request_data"), this->sign_request_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenSignRequestData>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_timestamp_header"), this->include_timestamp_header,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuers"), this->issuers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "additional_signed_headers"), this->additional_signed_headers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "possibly_unsafe_additional_signing_data"), this->possibly_unsafe_additional_signing_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HasTrustTokensResult::HasTrustTokensResult()
    : status(),
      has_trust_tokens() {}

HasTrustTokensResult::HasTrustTokensResult(
    TrustTokenOperationStatus status_in,
    bool has_trust_tokens_in)
    : status(std::move(status_in)),
      has_trust_tokens(std::move(has_trust_tokens_in)) {}

HasTrustTokensResult::~HasTrustTokensResult() = default;
size_t HasTrustTokensResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  seed = mojo::internal::Hash(seed, this->has_trust_tokens);
  return seed;
}

void HasTrustTokensResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_trust_tokens"), this->has_trust_tokens,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HasTrustTokensResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HasRedemptionRecordResult::HasRedemptionRecordResult()
    : status(),
      has_redemption_record() {}

HasRedemptionRecordResult::HasRedemptionRecordResult(
    TrustTokenOperationStatus status_in,
    bool has_redemption_record_in)
    : status(std::move(status_in)),
      has_redemption_record(std::move(has_redemption_record_in)) {}

HasRedemptionRecordResult::~HasRedemptionRecordResult() = default;
size_t HasRedemptionRecordResult::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  seed = mojo::internal::Hash(seed, this->has_redemption_record);
  return seed;
}

void HasRedemptionRecordResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_redemption_record"), this->has_redemption_record,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HasRedemptionRecordResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenVerificationKey::TrustTokenVerificationKey()
    : body(),
      expiry() {}

TrustTokenVerificationKey::TrustTokenVerificationKey(
    const std::string& body_in,
    ::base::Time expiry_in)
    : body(std::move(body_in)),
      expiry(std::move(expiry_in)) {}

TrustTokenVerificationKey::~TrustTokenVerificationKey() = default;

void TrustTokenVerificationKey::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiry"), this->expiry,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenVerificationKey::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenKeyCommitmentResult::TrustTokenKeyCommitmentResult()
    : protocol_version(),
      id(),
      batch_size(),
      keys(),
      request_issuance_locally_on(),
      unavailable_local_operation_fallback() {}

TrustTokenKeyCommitmentResult::TrustTokenKeyCommitmentResult(
    TrustTokenProtocolVersion protocol_version_in,
    int32_t id_in,
    int32_t batch_size_in,
    std::vector<TrustTokenVerificationKeyPtr> keys_in,
    std::vector<TrustTokenKeyCommitmentResult::Os> request_issuance_locally_on_in,
    TrustTokenKeyCommitmentResult::UnavailableLocalOperationFallback unavailable_local_operation_fallback_in)
    : protocol_version(std::move(protocol_version_in)),
      id(std::move(id_in)),
      batch_size(std::move(batch_size_in)),
      keys(std::move(keys_in)),
      request_issuance_locally_on(std::move(request_issuance_locally_on_in)),
      unavailable_local_operation_fallback(std::move(unavailable_local_operation_fallback_in)) {}

TrustTokenKeyCommitmentResult::~TrustTokenKeyCommitmentResult() = default;

void TrustTokenKeyCommitmentResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol_version"), this->protocol_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenProtocolVersion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "batch_size"), this->batch_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keys"), this->keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<TrustTokenVerificationKeyPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request_issuance_locally_on"), this->request_issuance_locally_on,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<TrustTokenKeyCommitmentResult::Os>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unavailable_local_operation_fallback"), this->unavailable_local_operation_fallback,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenKeyCommitmentResult::UnavailableLocalOperationFallback>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenKeyCommitmentResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FulfillTrustTokenIssuanceRequest::FulfillTrustTokenIssuanceRequest()
    : issuer(),
      request() {}

FulfillTrustTokenIssuanceRequest::FulfillTrustTokenIssuanceRequest(
    const ::url::Origin& issuer_in,
    const std::string& request_in)
    : issuer(std::move(issuer_in)),
      request(std::move(request_in)) {}

FulfillTrustTokenIssuanceRequest::~FulfillTrustTokenIssuanceRequest() = default;

void FulfillTrustTokenIssuanceRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "request"), this->request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FulfillTrustTokenIssuanceRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
FulfillTrustTokenIssuanceAnswer::FulfillTrustTokenIssuanceAnswer()
    : status(),
      response() {}

FulfillTrustTokenIssuanceAnswer::FulfillTrustTokenIssuanceAnswer(
    FulfillTrustTokenIssuanceAnswer::Status status_in,
    const std::string& response_in)
    : status(std::move(status_in)),
      response(std::move(response_in)) {}

FulfillTrustTokenIssuanceAnswer::~FulfillTrustTokenIssuanceAnswer() = default;
size_t FulfillTrustTokenIssuanceAnswer::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->status);
  seed = mojo::internal::Hash(seed, this->response);
  return seed;
}

void FulfillTrustTokenIssuanceAnswer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type FulfillTrustTokenIssuanceAnswer::Status>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "response"), this->response,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FulfillTrustTokenIssuanceAnswer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TrustTokenOperationResult::TrustTokenOperationResult()
    : operation(),
      status(),
      issuer(),
      top_level_origin(),
      issued_token_count(0) {}

TrustTokenOperationResult::TrustTokenOperationResult(
    TrustTokenOperationType operation_in,
    TrustTokenOperationStatus status_in,
    const std::optional<::url::Origin>& issuer_in,
    const std::optional<::url::Origin>& top_level_origin_in,
    int32_t issued_token_count_in)
    : operation(std::move(operation_in)),
      status(std::move(status_in)),
      issuer(std::move(issuer_in)),
      top_level_origin(std::move(top_level_origin_in)),
      issued_token_count(std::move(issued_token_count_in)) {}

TrustTokenOperationResult::~TrustTokenOperationResult() = default;

void TrustTokenOperationResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "operation"), this->operation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TrustTokenOperationStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_level_origin"), this->top_level_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::url::Origin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issued_token_count"), this->issued_token_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TrustTokenOperationResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
StoredTrustTokensForIssuer::StoredTrustTokensForIssuer()
    : issuer(),
      count() {}

StoredTrustTokensForIssuer::StoredTrustTokensForIssuer(
    const ::url::Origin& issuer_in,
    int32_t count_in)
    : issuer(std::move(issuer_in)),
      count(std::move(count_in)) {}

StoredTrustTokensForIssuer::~StoredTrustTokensForIssuer() = default;

void StoredTrustTokensForIssuer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issuer"), this->issuer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "count"), this->count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StoredTrustTokensForIssuer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ToplevelRedemptionRecord::ToplevelRedemptionRecord()
    : toplevel_origin(),
      last_redemption() {}

ToplevelRedemptionRecord::ToplevelRedemptionRecord(
    const ::url::Origin& toplevel_origin_in,
    ::base::Time last_redemption_in)
    : toplevel_origin(std::move(toplevel_origin_in)),
      last_redemption(std::move(last_redemption_in)) {}

ToplevelRedemptionRecord::~ToplevelRedemptionRecord() = default;

void ToplevelRedemptionRecord::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "toplevel_origin"), this->toplevel_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_redemption"), this->last_redemption,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ToplevelRedemptionRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char TrustTokenQueryAnswerer::Name_[] = "network.mojom.TrustTokenQueryAnswerer";

TrustTokenQueryAnswerer::IPCStableHashFunction TrustTokenQueryAnswerer::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TrustTokenQueryAnswerer>(message.name())) {
    case messages::TrustTokenQueryAnswerer::kHasTrustTokens: {
      return &TrustTokenQueryAnswerer::HasTrustTokens_Sym::IPCStableHash;
    }
    case messages::TrustTokenQueryAnswerer::kHasRedemptionRecord: {
      return &TrustTokenQueryAnswerer::HasRedemptionRecord_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TrustTokenQueryAnswerer::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TrustTokenQueryAnswerer>(message.name())) {
      case messages::TrustTokenQueryAnswerer::kHasTrustTokens:
            return "Receive network::mojom::TrustTokenQueryAnswerer::HasTrustTokens";
      case messages::TrustTokenQueryAnswerer::kHasRedemptionRecord:
            return "Receive network::mojom::TrustTokenQueryAnswerer::HasRedemptionRecord";
    }
  } else {
    switch (static_cast<messages::TrustTokenQueryAnswerer>(message.name())) {
      case messages::TrustTokenQueryAnswerer::kHasTrustTokens:
            return "Receive reply network::mojom::TrustTokenQueryAnswerer::HasTrustTokens";
      case messages::TrustTokenQueryAnswerer::kHasRedemptionRecord:
            return "Receive reply network::mojom::TrustTokenQueryAnswerer::HasRedemptionRecord";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TrustTokenQueryAnswerer::HasTrustTokens_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TrustTokenQueryAnswerer::HasTrustTokens");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TrustTokenQueryAnswerer::HasRedemptionRecord_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::TrustTokenQueryAnswerer::HasRedemptionRecord");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback(
      TrustTokenQueryAnswerer::HasTrustTokensCallback callback
      ) : callback_(std::move(callback)) {
  }

  TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback(const TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback&) = delete;
  TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback& operator=(const TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TrustTokenQueryAnswerer::HasTrustTokensCallback callback_;
};

class TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback(
      TrustTokenQueryAnswerer::HasRedemptionRecordCallback callback
      ) : callback_(std::move(callback)) {
  }

  TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback(const TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback&) = delete;
  TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback& operator=(const TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TrustTokenQueryAnswerer::HasRedemptionRecordCallback callback_;
};

TrustTokenQueryAnswererProxy::TrustTokenQueryAnswererProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustTokenQueryAnswererProxy::HasTrustTokens(
    const ::url::Origin& in_issuer, HasTrustTokensCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustTokenQueryAnswerer::HasTrustTokens", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issuer"), in_issuer,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustTokenQueryAnswerer::kHasTrustTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustTokenQueryAnswerer_HasTrustTokens_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->issuer)::BaseType> issuer_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer, issuer_fragment);
  params->issuer.Set(
      issuer_fragment.is_null() ? nullptr : issuer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->issuer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer in TrustTokenQueryAnswerer.HasTrustTokens request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustTokenQueryAnswerer::Name_);
  message.set_method_name("HasTrustTokens");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void TrustTokenQueryAnswererProxy::HasRedemptionRecord(
    const ::url::Origin& in_issuer, HasRedemptionRecordCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::TrustTokenQueryAnswerer::HasRedemptionRecord", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("issuer"), in_issuer,
                        "<value of type const ::url::Origin&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustTokenQueryAnswerer::kHasRedemptionRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustTokenQueryAnswerer_HasRedemptionRecord_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->issuer)::BaseType> issuer_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_issuer, issuer_fragment);
  params->issuer.Set(
      issuer_fragment.is_null() ? nullptr : issuer_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->issuer.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issuer in TrustTokenQueryAnswerer.HasRedemptionRecord request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustTokenQueryAnswerer::Name_);
  message.set_method_name("HasRedemptionRecord");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TrustTokenQueryAnswerer::HasTrustTokensCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder> proxy(
        new TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TrustTokenQueryAnswerer::HasTrustTokensCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      HasTrustTokensResultPtr in_result);
};

bool TrustTokenQueryAnswerer_HasTrustTokens_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TrustTokenQueryAnswerer.0
  bool success = true;
  HasTrustTokensResultPtr p_result{};
  TrustTokenQueryAnswerer_HasTrustTokens_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustTokenQueryAnswerer::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder::Run(
    HasTrustTokensResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TrustTokenQueryAnswerer::HasTrustTokens", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type HasTrustTokensResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustTokenQueryAnswerer::kHasTrustTokens), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HasTrustTokensResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustTokenQueryAnswerer::Name_);
  message.set_method_name("HasTrustTokens");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TrustTokenQueryAnswerer::HasRedemptionRecordCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder> proxy(
        new TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TrustTokenQueryAnswerer::HasRedemptionRecordCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      HasRedemptionRecordResultPtr in_result);
};

bool TrustTokenQueryAnswerer_HasRedemptionRecord_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for TrustTokenQueryAnswerer.1
  bool success = true;
  HasRedemptionRecordResultPtr p_result{};
  TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustTokenQueryAnswerer::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder::Run(
    HasRedemptionRecordResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::TrustTokenQueryAnswerer::HasRedemptionRecord", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type HasRedemptionRecordResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TrustTokenQueryAnswerer::kHasRedemptionRecord), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::HasRedemptionRecordResultDataView>(
      in_result, result_fragment);
  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustTokenQueryAnswerer::Name_);
  message.set_method_name("HasRedemptionRecord");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TrustTokenQueryAnswererStubDispatch::Accept(
    TrustTokenQueryAnswerer* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TrustTokenQueryAnswerer>(message->header()->name)) {
    case messages::TrustTokenQueryAnswerer::kHasTrustTokens: {
      break;
    }
    case messages::TrustTokenQueryAnswerer::kHasRedemptionRecord: {
      break;
    }
  }
  return false;
}

// static
bool TrustTokenQueryAnswererStubDispatch::AcceptWithResponder(
    TrustTokenQueryAnswerer* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TrustTokenQueryAnswerer>(message->header()->name)) {
    case messages::TrustTokenQueryAnswerer::kHasTrustTokens: {
      internal::TrustTokenQueryAnswerer_HasTrustTokens_Params_Data* params =
          reinterpret_cast<
              internal::TrustTokenQueryAnswerer_HasTrustTokens_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TrustTokenQueryAnswerer.0
      bool success = true;
      ::url::Origin p_issuer{};
      TrustTokenQueryAnswerer_HasTrustTokens_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIssuer(&p_issuer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustTokenQueryAnswerer::Name_, 0, false);
        return false;
      }
      TrustTokenQueryAnswerer::HasTrustTokensCallback callback =
          TrustTokenQueryAnswerer_HasTrustTokens_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasTrustTokens(        
        std::move(p_issuer), std::move(callback));
      return true;
    }
    case messages::TrustTokenQueryAnswerer::kHasRedemptionRecord: {
      internal::TrustTokenQueryAnswerer_HasRedemptionRecord_Params_Data* params =
          reinterpret_cast<
              internal::TrustTokenQueryAnswerer_HasRedemptionRecord_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for TrustTokenQueryAnswerer.1
      bool success = true;
      ::url::Origin p_issuer{};
      TrustTokenQueryAnswerer_HasRedemptionRecord_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadIssuer(&p_issuer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustTokenQueryAnswerer::Name_, 1, false);
        return false;
      }
      TrustTokenQueryAnswerer::HasRedemptionRecordCallback callback =
          TrustTokenQueryAnswerer_HasRedemptionRecord_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasRedemptionRecord(        
        std::move(p_issuer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTrustTokenQueryAnswererValidationInfo[] = {
    {base::to_underlying(messages::TrustTokenQueryAnswerer::kHasTrustTokens),
     { &internal::TrustTokenQueryAnswerer_HasTrustTokens_Params_Data::Validate,
      &internal::TrustTokenQueryAnswerer_HasTrustTokens_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::TrustTokenQueryAnswerer::kHasRedemptionRecord),
     { &internal::TrustTokenQueryAnswerer_HasRedemptionRecord_Params_Data::Validate,
      &internal::TrustTokenQueryAnswerer_HasRedemptionRecord_ResponseParams_Data::Validate}},
};

bool TrustTokenQueryAnswererRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TrustTokenQueryAnswerer::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTrustTokenQueryAnswererValidationInfo);
}

bool TrustTokenQueryAnswererResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TrustTokenQueryAnswerer::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTrustTokenQueryAnswererValidationInfo);

}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::TrustTokenParams::DataView, ::network::mojom::TrustTokenParamsPtr>::Read(
    ::network::mojom::TrustTokenParams::DataView input,
    ::network::mojom::TrustTokenParamsPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenParamsPtr result(::network::mojom::TrustTokenParams::New());
  
      if (success && !input.ReadOperation(&result->operation))
        success = false;
      if (success && !input.ReadRefreshPolicy(&result->refresh_policy))
        success = false;
      if (success && !input.ReadCustomKeyCommitment(&result->custom_key_commitment))
        success = false;
      if (success && !input.ReadCustomIssuer(&result->custom_issuer))
        success = false;
      if (success && !input.ReadSignRequestData(&result->sign_request_data))
        success = false;
      if (success)
        result->include_timestamp_header = input.include_timestamp_header();
      if (success && !input.ReadIssuers(&result->issuers))
        success = false;
      if (success && !input.ReadAdditionalSignedHeaders(&result->additional_signed_headers))
        success = false;
      if (success && !input.ReadPossiblyUnsafeAdditionalSigningData(&result->possibly_unsafe_additional_signing_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HasTrustTokensResult::DataView, ::network::mojom::HasTrustTokensResultPtr>::Read(
    ::network::mojom::HasTrustTokensResult::DataView input,
    ::network::mojom::HasTrustTokensResultPtr* output) {
  bool success = true;
  ::network::mojom::HasTrustTokensResultPtr result(::network::mojom::HasTrustTokensResult::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->has_trust_tokens = input.has_trust_tokens();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HasRedemptionRecordResult::DataView, ::network::mojom::HasRedemptionRecordResultPtr>::Read(
    ::network::mojom::HasRedemptionRecordResult::DataView input,
    ::network::mojom::HasRedemptionRecordResultPtr* output) {
  bool success = true;
  ::network::mojom::HasRedemptionRecordResultPtr result(::network::mojom::HasRedemptionRecordResult::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success)
        result->has_redemption_record = input.has_redemption_record();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenVerificationKey::DataView, ::network::mojom::TrustTokenVerificationKeyPtr>::Read(
    ::network::mojom::TrustTokenVerificationKey::DataView input,
    ::network::mojom::TrustTokenVerificationKeyPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenVerificationKeyPtr result(::network::mojom::TrustTokenVerificationKey::New());
  
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadExpiry(&result->expiry))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenKeyCommitmentResult::DataView, ::network::mojom::TrustTokenKeyCommitmentResultPtr>::Read(
    ::network::mojom::TrustTokenKeyCommitmentResult::DataView input,
    ::network::mojom::TrustTokenKeyCommitmentResultPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenKeyCommitmentResultPtr result(::network::mojom::TrustTokenKeyCommitmentResult::New());
  
      if (success && !input.ReadProtocolVersion(&result->protocol_version))
        success = false;
      if (success)
        result->id = input.id();
      if (success)
        result->batch_size = input.batch_size();
      if (success && !input.ReadKeys(&result->keys))
        success = false;
      if (success && !input.ReadRequestIssuanceLocallyOn(&result->request_issuance_locally_on))
        success = false;
      if (success && !input.ReadUnavailableLocalOperationFallback(&result->unavailable_local_operation_fallback))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FulfillTrustTokenIssuanceRequest::DataView, ::network::mojom::FulfillTrustTokenIssuanceRequestPtr>::Read(
    ::network::mojom::FulfillTrustTokenIssuanceRequest::DataView input,
    ::network::mojom::FulfillTrustTokenIssuanceRequestPtr* output) {
  bool success = true;
  ::network::mojom::FulfillTrustTokenIssuanceRequestPtr result(::network::mojom::FulfillTrustTokenIssuanceRequest::New());
  
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::FulfillTrustTokenIssuanceAnswer::DataView, ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr>::Read(
    ::network::mojom::FulfillTrustTokenIssuanceAnswer::DataView input,
    ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr* output) {
  bool success = true;
  ::network::mojom::FulfillTrustTokenIssuanceAnswerPtr result(::network::mojom::FulfillTrustTokenIssuanceAnswer::New());
  
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadResponse(&result->response))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::TrustTokenOperationResult::DataView, ::network::mojom::TrustTokenOperationResultPtr>::Read(
    ::network::mojom::TrustTokenOperationResult::DataView input,
    ::network::mojom::TrustTokenOperationResultPtr* output) {
  bool success = true;
  ::network::mojom::TrustTokenOperationResultPtr result(::network::mojom::TrustTokenOperationResult::New());
  
      if (success && !input.ReadOperation(&result->operation))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success && !input.ReadTopLevelOrigin(&result->top_level_origin))
        success = false;
      if (success)
        result->issued_token_count = input.issued_token_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::StoredTrustTokensForIssuer::DataView, ::network::mojom::StoredTrustTokensForIssuerPtr>::Read(
    ::network::mojom::StoredTrustTokensForIssuer::DataView input,
    ::network::mojom::StoredTrustTokensForIssuerPtr* output) {
  bool success = true;
  ::network::mojom::StoredTrustTokensForIssuerPtr result(::network::mojom::StoredTrustTokensForIssuer::New());
  
      if (success && !input.ReadIssuer(&result->issuer))
        success = false;
      if (success)
        result->count = input.count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ToplevelRedemptionRecord::DataView, ::network::mojom::ToplevelRedemptionRecordPtr>::Read(
    ::network::mojom::ToplevelRedemptionRecord::DataView input,
    ::network::mojom::ToplevelRedemptionRecordPtr* output) {
  bool success = true;
  ::network::mojom::ToplevelRedemptionRecordPtr result(::network::mojom::ToplevelRedemptionRecord::New());
  
      if (success && !input.ReadToplevelOrigin(&result->toplevel_origin))
        success = false;
      if (success && !input.ReadLastRedemption(&result->last_redemption))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void TrustTokenQueryAnswererInterceptorForTesting::HasTrustTokens(const ::url::Origin& issuer, HasTrustTokensCallback callback) {
  GetForwardingInterface()->HasTrustTokens(
    std::move(issuer)
    , std::move(callback));
}
void TrustTokenQueryAnswererInterceptorForTesting::HasRedemptionRecord(const ::url::Origin& issuer, HasRedemptionRecordCallback callback) {
  GetForwardingInterface()->HasRedemptionRecord(
    std::move(issuer)
    , std::move(callback));
}
TrustTokenQueryAnswererAsyncWaiter::TrustTokenQueryAnswererAsyncWaiter(
    TrustTokenQueryAnswerer* proxy) : proxy_(proxy) {}

TrustTokenQueryAnswererAsyncWaiter::~TrustTokenQueryAnswererAsyncWaiter() = default;

void TrustTokenQueryAnswererAsyncWaiter::HasTrustTokens(
    const ::url::Origin& issuer, HasTrustTokensResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->HasTrustTokens(
      std::move(issuer),
      base::BindOnce(
          [](base::RunLoop* loop,
             HasTrustTokensResultPtr* out_result
,
             HasTrustTokensResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

HasTrustTokensResultPtr TrustTokenQueryAnswererAsyncWaiter::HasTrustTokens(
    const ::url::Origin& issuer) {
  HasTrustTokensResultPtr async_wait_result;
  HasTrustTokens(std::move(issuer),&async_wait_result);
  return async_wait_result;
}

void TrustTokenQueryAnswererAsyncWaiter::HasRedemptionRecord(
    const ::url::Origin& issuer, HasRedemptionRecordResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->HasRedemptionRecord(
      std::move(issuer),
      base::BindOnce(
          [](base::RunLoop* loop,
             HasRedemptionRecordResultPtr* out_result
,
             HasRedemptionRecordResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

HasRedemptionRecordResultPtr TrustTokenQueryAnswererAsyncWaiter::HasRedemptionRecord(
    const ::url::Origin& issuer) {
  HasRedemptionRecordResultPtr async_wait_result;
  HasRedemptionRecord(std::move(issuer),&async_wait_result);
  return async_wait_result;
}






}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif