// third_party/blink/public/mojom/blob/blob_url_store.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/blob/blob_url_store.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-params-data.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-import-headers.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-test-utils.h"


namespace blink::mojom {
const char BlobURLStore::Name_[] = "blink.mojom.BlobURLStore";

BlobURLStore::IPCStableHashFunction BlobURLStore::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BlobURLStore>(message.name())) {
    case messages::BlobURLStore::kRegister: {
      return &BlobURLStore::Register_Sym::IPCStableHash;
    }
    case messages::BlobURLStore::kRevoke: {
      return &BlobURLStore::Revoke_Sym::IPCStableHash;
    }
    case messages::BlobURLStore::kResolveAsURLLoaderFactory: {
      return &BlobURLStore::ResolveAsURLLoaderFactory_Sym::IPCStableHash;
    }
    case messages::BlobURLStore::kResolveForNavigation: {
      return &BlobURLStore::ResolveForNavigation_Sym::IPCStableHash;
    }
    case messages::BlobURLStore::kResolveForWorkerScriptFetch: {
      return &BlobURLStore::ResolveForWorkerScriptFetch_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BlobURLStore::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BlobURLStore>(message.name())) {
      case messages::BlobURLStore::kRegister:
            return "Receive blink::mojom::BlobURLStore::Register";
      case messages::BlobURLStore::kRevoke:
            return "Receive blink::mojom::BlobURLStore::Revoke";
      case messages::BlobURLStore::kResolveAsURLLoaderFactory:
            return "Receive blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory";
      case messages::BlobURLStore::kResolveForNavigation:
            return "Receive blink::mojom::BlobURLStore::ResolveForNavigation";
      case messages::BlobURLStore::kResolveForWorkerScriptFetch:
            return "Receive blink::mojom::BlobURLStore::ResolveForWorkerScriptFetch";
    }
  } else {
    switch (static_cast<messages::BlobURLStore>(message.name())) {
      case messages::BlobURLStore::kRegister:
            return "Receive reply blink::mojom::BlobURLStore::Register";
      case messages::BlobURLStore::kRevoke:
            return "Receive reply blink::mojom::BlobURLStore::Revoke";
      case messages::BlobURLStore::kResolveAsURLLoaderFactory:
            return "Receive reply blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory";
      case messages::BlobURLStore::kResolveForNavigation:
            return "Receive reply blink::mojom::BlobURLStore::ResolveForNavigation";
      case messages::BlobURLStore::kResolveForWorkerScriptFetch:
            return "Receive reply blink::mojom::BlobURLStore::ResolveForWorkerScriptFetch";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BlobURLStore::Register_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobURLStore::Register");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobURLStore::Revoke_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobURLStore::Revoke");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobURLStore::ResolveAsURLLoaderFactory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobURLStore::ResolveForNavigation_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobURLStore::ResolveForNavigation");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobURLStore::ResolveForWorkerScriptFetch_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobURLStore::ResolveForWorkerScriptFetch");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool BlobURLStore::Register(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::GURL& url, const ::base::UnguessableToken& unsafe_agent_cluster_id, const std::optional<::net::SchemefulSite>& unsafe_top_level_site) {
  NOTREACHED();
}
class BlobURLStore_Register_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_Register_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  BlobURLStore_Register_HandleSyncResponse(const BlobURLStore_Register_HandleSyncResponse&) = delete;
  BlobURLStore_Register_HandleSyncResponse& operator=(const BlobURLStore_Register_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class BlobURLStore_Register_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_Register_ForwardToCallback(
      BlobURLStore::RegisterCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobURLStore_Register_ForwardToCallback(const BlobURLStore_Register_ForwardToCallback&) = delete;
  BlobURLStore_Register_ForwardToCallback& operator=(const BlobURLStore_Register_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobURLStore::RegisterCallback callback_;
};

class BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback(
      BlobURLStore::ResolveAsURLLoaderFactoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback(const BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback&) = delete;
  BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback& operator=(const BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobURLStore::ResolveAsURLLoaderFactoryCallback callback_;
};

class BlobURLStore_ResolveForNavigation_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_ResolveForNavigation_ForwardToCallback(
      BlobURLStore::ResolveForNavigationCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobURLStore_ResolveForNavigation_ForwardToCallback(const BlobURLStore_ResolveForNavigation_ForwardToCallback&) = delete;
  BlobURLStore_ResolveForNavigation_ForwardToCallback& operator=(const BlobURLStore_ResolveForNavigation_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobURLStore::ResolveForNavigationCallback callback_;
};

class BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback(
      BlobURLStore::ResolveForWorkerScriptFetchCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback(const BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback&) = delete;
  BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback& operator=(const BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobURLStore::ResolveForWorkerScriptFetchCallback callback_;
};

BlobURLStoreProxy::BlobURLStoreProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool BlobURLStoreProxy::Register(
    ::mojo::PendingRemote<::blink::mojom::Blob> param_blob, const ::GURL& param_url, const ::base::UnguessableToken& param_unsafe_agent_cluster_id, const std::optional<::net::SchemefulSite>& param_unsafe_top_level_site) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::BlobURLStore::Register (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), param_blob,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_agent_cluster_id"), param_unsafe_agent_cluster_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_top_level_site"), param_unsafe_top_level_site,
                        "<value of type const std::optional<::net::SchemefulSite>&>");
   });
#else
  TRACE_EVENT0("mojom", "BlobURLStore::Register");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      param_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_agent_cluster_id)::BaseType> unsafe_agent_cluster_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      param_unsafe_agent_cluster_id, unsafe_agent_cluster_id_fragment);
  params->unsafe_agent_cluster_id.Set(
      unsafe_agent_cluster_id_fragment.is_null() ? nullptr : unsafe_agent_cluster_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->unsafe_agent_cluster_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unsafe_agent_cluster_id in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_top_level_site)::BaseType> unsafe_top_level_site_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      param_unsafe_top_level_site, unsafe_top_level_site_fragment);
  params->unsafe_top_level_site.Set(
      unsafe_top_level_site_fragment.is_null() ? nullptr : unsafe_top_level_site_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Register");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_Register_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "BlobURLStore::Register");
#endif
  return result;
}

void BlobURLStoreProxy::Register(
    ::mojo::PendingRemote<::blink::mojom::Blob> in_blob, const ::GURL& in_url, const ::base::UnguessableToken& in_unsafe_agent_cluster_id, const std::optional<::net::SchemefulSite>& in_unsafe_top_level_site, RegisterCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobURLStore::Register", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("blob"), in_blob,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::Blob>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_agent_cluster_id"), in_unsafe_agent_cluster_id,
                        "<value of type const ::base::UnguessableToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_top_level_site"), in_unsafe_top_level_site,
                        "<value of type const std::optional<::net::SchemefulSite>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Register_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      in_blob, &params->blob, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->blob),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid blob in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_agent_cluster_id)::BaseType> unsafe_agent_cluster_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_unsafe_agent_cluster_id, unsafe_agent_cluster_id_fragment);
  params->unsafe_agent_cluster_id.Set(
      unsafe_agent_cluster_id_fragment.is_null() ? nullptr : unsafe_agent_cluster_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->unsafe_agent_cluster_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null unsafe_agent_cluster_id in BlobURLStore.Register request");
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_top_level_site)::BaseType> unsafe_top_level_site_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_unsafe_top_level_site, unsafe_top_level_site_fragment);
  params->unsafe_top_level_site.Set(
      unsafe_top_level_site_fragment.is_null() ? nullptr : unsafe_top_level_site_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Register");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_Register_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BlobURLStoreProxy::Revoke(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobURLStore::Revoke", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kRevoke), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Revoke_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.Revoke request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Revoke");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobURLStoreProxy::ResolveAsURLLoaderFactory(
    const ::GURL& in_url, ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> in_factory, ResolveAsURLLoaderFactoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("factory"), in_factory,
                        "<value of type ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kResolveAsURLLoaderFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.ResolveAsURLLoaderFactory request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_factory, &params->factory, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in BlobURLStore.ResolveAsURLLoaderFactory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveAsURLLoaderFactory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BlobURLStoreProxy::ResolveForNavigation(
    const ::GURL& in_url, ::mojo::PendingReceiver<BlobURLToken> in_token, bool in_is_top_level_navigation, ResolveForNavigationCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobURLStore::ResolveForNavigation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<BlobURLToken>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_top_level_navigation"), in_is_top_level_navigation,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kResolveForNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveForNavigation_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.ResolveForNavigation request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in BlobURLStore.ResolveForNavigation request");
  params->is_top_level_navigation = in_is_top_level_navigation;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveForNavigation");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_ResolveForNavigation_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void BlobURLStoreProxy::ResolveForWorkerScriptFetch(
    const ::GURL& in_url, ::mojo::PendingReceiver<BlobURLToken> in_token, ResolveForWorkerScriptFetchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobURLStore::ResolveForWorkerScriptFetch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<BlobURLToken>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kResolveForWorkerScriptFetch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveForWorkerScriptFetch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in BlobURLStore.ResolveForWorkerScriptFetch request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in BlobURLStore.ResolveForWorkerScriptFetch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveForWorkerScriptFetch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BlobURLStore_Register_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobURLStore::RegisterCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobURLStore_Register_ProxyToResponder> proxy(
        new BlobURLStore_Register_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobURLStore_Register_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLStore_Register_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobURLStore_Register_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLStore::RegisterCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool BlobURLStore_Register_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobURLStore_Register_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLStore_Register_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BlobURLStore.0
  bool success = true;
  BlobURLStore_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void BlobURLStore_Register_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::BlobURLStore::Register");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kRegister), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_Register_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("Register");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool BlobURLStore_Register_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobURLStore_Register_ResponseParams_Data* params =
      reinterpret_cast<internal::BlobURLStore_Register_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for BlobURLStore.0
  bool success = true;
  BlobURLStore_Register_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}
class BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobURLStore::ResolveAsURLLoaderFactoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder> proxy(
        new BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLStore::ResolveAsURLLoaderFactoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::UnguessableToken>& in_unsafe_agent_cluster_id, const std::optional<::net::SchemefulSite>& in_unsafe_top_level_site);
};

bool BlobURLStore_ResolveAsURLLoaderFactory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobURLStore_ResolveAsURLLoaderFactory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLStore_ResolveAsURLLoaderFactory_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BlobURLStore.2
  bool success = true;
  std::optional<::base::UnguessableToken> p_unsafe_agent_cluster_id{};
  std::optional<::net::SchemefulSite> p_unsafe_top_level_site{};
  BlobURLStore_ResolveAsURLLoaderFactory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUnsafeAgentClusterId(&p_unsafe_agent_cluster_id))
    success = false;
  if (success && !input_data_view.ReadUnsafeTopLevelSite(&p_unsafe_top_level_site))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_unsafe_agent_cluster_id), 
std::move(p_unsafe_top_level_site));
  return true;
}

void BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder::Run(
    const std::optional<::base::UnguessableToken>& in_unsafe_agent_cluster_id, const std::optional<::net::SchemefulSite>& in_unsafe_top_level_site) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BlobURLStore::ResolveAsURLLoaderFactory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_agent_cluster_id"), in_unsafe_agent_cluster_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_top_level_site"), in_unsafe_top_level_site,
                        "<value of type const std::optional<::net::SchemefulSite>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kResolveAsURLLoaderFactory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveAsURLLoaderFactory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_agent_cluster_id)::BaseType> unsafe_agent_cluster_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_unsafe_agent_cluster_id, unsafe_agent_cluster_id_fragment);
  params->unsafe_agent_cluster_id.Set(
      unsafe_agent_cluster_id_fragment.is_null() ? nullptr : unsafe_agent_cluster_id_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_top_level_site)::BaseType> unsafe_top_level_site_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
      in_unsafe_top_level_site, unsafe_top_level_site_fragment);
  params->unsafe_top_level_site.Set(
      unsafe_top_level_site_fragment.is_null() ? nullptr : unsafe_top_level_site_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveAsURLLoaderFactory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BlobURLStore_ResolveForNavigation_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobURLStore::ResolveForNavigationCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobURLStore_ResolveForNavigation_ProxyToResponder> proxy(
        new BlobURLStore_ResolveForNavigation_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobURLStore_ResolveForNavigation_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLStore_ResolveForNavigation_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobURLStore_ResolveForNavigation_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLStore::ResolveForNavigationCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::UnguessableToken>& in_unsafe_agent_cluster_id);
};

bool BlobURLStore_ResolveForNavigation_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobURLStore_ResolveForNavigation_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLStore_ResolveForNavigation_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BlobURLStore.3
  bool success = true;
  std::optional<::base::UnguessableToken> p_unsafe_agent_cluster_id{};
  BlobURLStore_ResolveForNavigation_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUnsafeAgentClusterId(&p_unsafe_agent_cluster_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_unsafe_agent_cluster_id));
  return true;
}

void BlobURLStore_ResolveForNavigation_ProxyToResponder::Run(
    const std::optional<::base::UnguessableToken>& in_unsafe_agent_cluster_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BlobURLStore::ResolveForNavigation", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_agent_cluster_id"), in_unsafe_agent_cluster_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kResolveForNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveForNavigation_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_agent_cluster_id)::BaseType> unsafe_agent_cluster_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_unsafe_agent_cluster_id, unsafe_agent_cluster_id_fragment);
  params->unsafe_agent_cluster_id.Set(
      unsafe_agent_cluster_id_fragment.is_null() ? nullptr : unsafe_agent_cluster_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveForNavigation");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobURLStore::ResolveForWorkerScriptFetchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder> proxy(
        new BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLStore::ResolveForWorkerScriptFetchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::UnguessableToken>& in_unsafe_agent_cluster_id);
};

bool BlobURLStore_ResolveForWorkerScriptFetch_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobURLStore_ResolveForWorkerScriptFetch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLStore_ResolveForWorkerScriptFetch_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BlobURLStore.4
  bool success = true;
  std::optional<::base::UnguessableToken> p_unsafe_agent_cluster_id{};
  BlobURLStore_ResolveForWorkerScriptFetch_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUnsafeAgentClusterId(&p_unsafe_agent_cluster_id))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLStore::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_unsafe_agent_cluster_id));
  return true;
}

void BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder::Run(
    const std::optional<::base::UnguessableToken>& in_unsafe_agent_cluster_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BlobURLStore::ResolveForWorkerScriptFetch", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("unsafe_agent_cluster_id"), in_unsafe_agent_cluster_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLStore::kResolveForWorkerScriptFetch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLStore_ResolveForWorkerScriptFetch_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->unsafe_agent_cluster_id)::BaseType> unsafe_agent_cluster_id_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_unsafe_agent_cluster_id, unsafe_agent_cluster_id_fragment);
  params->unsafe_agent_cluster_id.Set(
      unsafe_agent_cluster_id_fragment.is_null() ? nullptr : unsafe_agent_cluster_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLStore::Name_);
  message.set_method_name("ResolveForWorkerScriptFetch");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobURLStoreStubDispatch::Accept(
    BlobURLStore* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BlobURLStore>(message->header()->name)) {
    case messages::BlobURLStore::kRegister: {
      break;
    }
    case messages::BlobURLStore::kRevoke: {
      DCHECK(message->is_serialized());
      internal::BlobURLStore_Revoke_Params_Data* params =
          reinterpret_cast<internal::BlobURLStore_Revoke_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for BlobURLStore.1
      bool success = true;
      ::GURL p_url{};
      BlobURLStore_Revoke_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Revoke(        
        std::move(p_url));
      return true;
    }
    case messages::BlobURLStore::kResolveAsURLLoaderFactory: {
      break;
    }
    case messages::BlobURLStore::kResolveForNavigation: {
      break;
    }
    case messages::BlobURLStore::kResolveForWorkerScriptFetch: {
      break;
    }
  }
  return false;
}

// static
bool BlobURLStoreStubDispatch::AcceptWithResponder(
    BlobURLStore* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BlobURLStore>(message->header()->name)) {
    case messages::BlobURLStore::kRegister: {
      internal::BlobURLStore_Register_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLStore_Register_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BlobURLStore.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::Blob> p_blob{};
      ::GURL p_url{};
      ::base::UnguessableToken p_unsafe_agent_cluster_id{};
      std::optional<::net::SchemefulSite> p_unsafe_top_level_site{};
      BlobURLStore_Register_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_blob =
            input_data_view.TakeBlob<decltype(p_blob)>();
      }
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadUnsafeAgentClusterId(&p_unsafe_agent_cluster_id))
        success = false;
      if (success && !input_data_view.ReadUnsafeTopLevelSite(&p_unsafe_top_level_site))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 0, false);
        return false;
      }
      BlobURLStore::RegisterCallback callback =
          BlobURLStore_Register_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Register(        
        std::move(p_blob), 
        std::move(p_url), 
        std::move(p_unsafe_agent_cluster_id), 
        std::move(p_unsafe_top_level_site), std::move(callback));
      return true;
    }
    case messages::BlobURLStore::kRevoke: {
      break;
    }
    case messages::BlobURLStore::kResolveAsURLLoaderFactory: {
      internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BlobURLStore.2
      bool success = true;
      ::GURL p_url{};
      ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> p_factory{};
      BlobURLStore_ResolveAsURLLoaderFactory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 2, false);
        return false;
      }
      BlobURLStore::ResolveAsURLLoaderFactoryCallback callback =
          BlobURLStore_ResolveAsURLLoaderFactory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveAsURLLoaderFactory(        
        std::move(p_url), 
        std::move(p_factory), std::move(callback));
      return true;
    }
    case messages::BlobURLStore::kResolveForNavigation: {
      internal::BlobURLStore_ResolveForNavigation_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLStore_ResolveForNavigation_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BlobURLStore.3
      bool success = true;
      ::GURL p_url{};
      ::mojo::PendingReceiver<BlobURLToken> p_token{};
      bool p_is_top_level_navigation{};
      BlobURLStore_ResolveForNavigation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (success)
        p_is_top_level_navigation = input_data_view.is_top_level_navigation();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 3, false);
        return false;
      }
      BlobURLStore::ResolveForNavigationCallback callback =
          BlobURLStore_ResolveForNavigation_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveForNavigation(        
        std::move(p_url), 
        std::move(p_token), 
        std::move(p_is_top_level_navigation), std::move(callback));
      return true;
    }
    case messages::BlobURLStore::kResolveForWorkerScriptFetch: {
      internal::BlobURLStore_ResolveForWorkerScriptFetch_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLStore_ResolveForWorkerScriptFetch_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BlobURLStore.4
      bool success = true;
      ::GURL p_url{};
      ::mojo::PendingReceiver<BlobURLToken> p_token{};
      BlobURLStore_ResolveForWorkerScriptFetch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLStore::Name_, 4, false);
        return false;
      }
      BlobURLStore::ResolveForWorkerScriptFetchCallback callback =
          BlobURLStore_ResolveForWorkerScriptFetch_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveForWorkerScriptFetch(        
        std::move(p_url), 
        std::move(p_token), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBlobURLStoreValidationInfo[] = {
    { &internal::BlobURLStore_Register_Params_Data::Validate,
     &internal::BlobURLStore_Register_ResponseParams_Data::Validate},
    { &internal::BlobURLStore_Revoke_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BlobURLStore_ResolveAsURLLoaderFactory_Params_Data::Validate,
     &internal::BlobURLStore_ResolveAsURLLoaderFactory_ResponseParams_Data::Validate},
    { &internal::BlobURLStore_ResolveForNavigation_Params_Data::Validate,
     &internal::BlobURLStore_ResolveForNavigation_ResponseParams_Data::Validate},
    { &internal::BlobURLStore_ResolveForWorkerScriptFetch_Params_Data::Validate,
     &internal::BlobURLStore_ResolveForWorkerScriptFetch_ResponseParams_Data::Validate},
};

bool BlobURLStoreRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLStore::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobURLStoreValidationInfo);
}

bool BlobURLStoreResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLStore::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBlobURLStoreValidationInfo);
}
const char BlobURLToken::Name_[] = "blink.mojom.BlobURLToken";

BlobURLToken::IPCStableHashFunction BlobURLToken::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BlobURLToken>(message.name())) {
    case messages::BlobURLToken::kClone: {
      return &BlobURLToken::Clone_Sym::IPCStableHash;
    }
    case messages::BlobURLToken::kGetToken: {
      return &BlobURLToken::GetToken_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BlobURLToken::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BlobURLToken>(message.name())) {
      case messages::BlobURLToken::kClone:
            return "Receive blink::mojom::BlobURLToken::Clone";
      case messages::BlobURLToken::kGetToken:
            return "Receive blink::mojom::BlobURLToken::GetToken";
    }
  } else {
    switch (static_cast<messages::BlobURLToken>(message.name())) {
      case messages::BlobURLToken::kClone:
            return "Receive reply blink::mojom::BlobURLToken::Clone";
      case messages::BlobURLToken::kGetToken:
            return "Receive reply blink::mojom::BlobURLToken::GetToken";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BlobURLToken::Clone_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobURLToken::Clone");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BlobURLToken::GetToken_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::BlobURLToken::GetToken");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BlobURLToken_GetToken_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BlobURLToken_GetToken_ForwardToCallback(
      BlobURLToken::GetTokenCallback callback
      ) : callback_(std::move(callback)) {
  }

  BlobURLToken_GetToken_ForwardToCallback(const BlobURLToken_GetToken_ForwardToCallback&) = delete;
  BlobURLToken_GetToken_ForwardToCallback& operator=(const BlobURLToken_GetToken_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BlobURLToken::GetTokenCallback callback_;
};

BlobURLTokenProxy::BlobURLTokenProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BlobURLTokenProxy::Clone(
    ::mojo::PendingReceiver<BlobURLToken> in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::BlobURLToken::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type ::mojo::PendingReceiver<BlobURLToken>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLToken::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLToken_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
      in_token, &params->token, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->token),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid token in BlobURLToken.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLToken::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BlobURLTokenProxy::GetToken(
    GetTokenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::BlobURLToken::GetToken");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLToken::kGetToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLToken_GetToken_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLToken::Name_);
  message.set_method_name("GetToken");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BlobURLToken_GetToken_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BlobURLToken_GetToken_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BlobURLToken::GetTokenCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BlobURLToken_GetToken_ProxyToResponder> proxy(
        new BlobURLToken_GetToken_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BlobURLToken_GetToken_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BlobURLToken_GetToken_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BlobURLToken_GetToken_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "BlobURLToken::GetTokenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_token);
};

bool BlobURLToken_GetToken_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BlobURLToken_GetToken_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BlobURLToken_GetToken_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for BlobURLToken.1
  bool success = true;
  ::base::UnguessableToken p_token{};
  BlobURLToken_GetToken_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadToken(&p_token))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BlobURLToken::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_token));
  return true;
}

void BlobURLToken_GetToken_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::BlobURLToken::GetToken", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("token"), in_token,
                        "<value of type const ::base::UnguessableToken&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BlobURLToken::kGetToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::BlobURLToken_GetToken_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->token)::BaseType> token_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_token, token_fragment);
  params->token.Set(
      token_fragment.is_null() ? nullptr : token_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->token.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null token in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BlobURLToken::Name_);
  message.set_method_name("GetToken");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BlobURLTokenStubDispatch::Accept(
    BlobURLToken* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BlobURLToken>(message->header()->name)) {
    case messages::BlobURLToken::kClone: {
      DCHECK(message->is_serialized());
      internal::BlobURLToken_Clone_Params_Data* params =
          reinterpret_cast<internal::BlobURLToken_Clone_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for BlobURLToken.0
      bool success = true;
      ::mojo::PendingReceiver<BlobURLToken> p_token{};
      BlobURLToken_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_token =
            input_data_view.TakeToken<decltype(p_token)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLToken::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_token));
      return true;
    }
    case messages::BlobURLToken::kGetToken: {
      break;
    }
  }
  return false;
}

// static
bool BlobURLTokenStubDispatch::AcceptWithResponder(
    BlobURLToken* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BlobURLToken>(message->header()->name)) {
    case messages::BlobURLToken::kClone: {
      break;
    }
    case messages::BlobURLToken::kGetToken: {
      internal::BlobURLToken_GetToken_Params_Data* params =
          reinterpret_cast<
              internal::BlobURLToken_GetToken_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for BlobURLToken.1
      bool success = true;
      BlobURLToken_GetToken_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BlobURLToken::Name_, 1, false);
        return false;
      }
      BlobURLToken::GetTokenCallback callback =
          BlobURLToken_GetToken_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetToken(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBlobURLTokenValidationInfo[] = {
    { &internal::BlobURLToken_Clone_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BlobURLToken_GetToken_Params_Data::Validate,
     &internal::BlobURLToken_GetToken_ResponseParams_Data::Validate},
};

bool BlobURLTokenRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLToken::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBlobURLTokenValidationInfo);
}

bool BlobURLTokenResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BlobURLToken::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kBlobURLTokenValidationInfo);
}


}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void BlobURLStoreInterceptorForTesting::Register(::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::GURL& url, const ::base::UnguessableToken& unsafe_agent_cluster_id, const std::optional<::net::SchemefulSite>& unsafe_top_level_site, RegisterCallback callback) {
  GetForwardingInterface()->Register(
    std::move(blob)
    , 
    std::move(url)
    , 
    std::move(unsafe_agent_cluster_id)
    , 
    std::move(unsafe_top_level_site)
    , std::move(callback));
}
void BlobURLStoreInterceptorForTesting::Revoke(const ::GURL& url) {
  GetForwardingInterface()->Revoke(
    std::move(url)
    );
}
void BlobURLStoreInterceptorForTesting::ResolveAsURLLoaderFactory(const ::GURL& url, ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> factory, ResolveAsURLLoaderFactoryCallback callback) {
  GetForwardingInterface()->ResolveAsURLLoaderFactory(
    std::move(url)
    , 
    std::move(factory)
    , std::move(callback));
}
void BlobURLStoreInterceptorForTesting::ResolveForNavigation(const ::GURL& url, ::mojo::PendingReceiver<BlobURLToken> token, bool is_top_level_navigation, ResolveForNavigationCallback callback) {
  GetForwardingInterface()->ResolveForNavigation(
    std::move(url)
    , 
    std::move(token)
    , 
    std::move(is_top_level_navigation)
    , std::move(callback));
}
void BlobURLStoreInterceptorForTesting::ResolveForWorkerScriptFetch(const ::GURL& url, ::mojo::PendingReceiver<BlobURLToken> token, ResolveForWorkerScriptFetchCallback callback) {
  GetForwardingInterface()->ResolveForWorkerScriptFetch(
    std::move(url)
    , 
    std::move(token)
    , std::move(callback));
}
BlobURLStoreAsyncWaiter::BlobURLStoreAsyncWaiter(
    BlobURLStore* proxy) : proxy_(proxy) {}

BlobURLStoreAsyncWaiter::~BlobURLStoreAsyncWaiter() = default;

void BlobURLStoreAsyncWaiter::Register(
    ::mojo::PendingRemote<::blink::mojom::Blob> blob, const ::GURL& url, const ::base::UnguessableToken& unsafe_agent_cluster_id, const std::optional<::net::SchemefulSite>& unsafe_top_level_site) {
  base::RunLoop loop;
  proxy_->Register(
      std::move(blob),
      std::move(url),
      std::move(unsafe_agent_cluster_id),
      std::move(unsafe_top_level_site),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void BlobURLStoreAsyncWaiter::ResolveAsURLLoaderFactory(
    const ::GURL& url, ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> factory, std::optional<::base::UnguessableToken>* out_unsafe_agent_cluster_id, std::optional<::net::SchemefulSite>* out_unsafe_top_level_site) {
  base::RunLoop loop;
  proxy_->ResolveAsURLLoaderFactory(
      std::move(url),
      std::move(factory),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::UnguessableToken>* out_unsafe_agent_cluster_id
,
             std::optional<::net::SchemefulSite>* out_unsafe_top_level_site
,
             const std::optional<::base::UnguessableToken>& unsafe_agent_cluster_id,
             const std::optional<::net::SchemefulSite>& unsafe_top_level_site) {*out_unsafe_agent_cluster_id = std::move(unsafe_agent_cluster_id);*out_unsafe_top_level_site = std::move(unsafe_top_level_site);
            loop->Quit();
          },
          &loop,
          out_unsafe_agent_cluster_id,
          out_unsafe_top_level_site));
  loop.Run();
}



void BlobURLStoreAsyncWaiter::ResolveForNavigation(
    const ::GURL& url, ::mojo::PendingReceiver<BlobURLToken> token, bool is_top_level_navigation, std::optional<::base::UnguessableToken>* out_unsafe_agent_cluster_id) {
  base::RunLoop loop;
  proxy_->ResolveForNavigation(
      std::move(url),
      std::move(token),
      std::move(is_top_level_navigation),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::UnguessableToken>* out_unsafe_agent_cluster_id
,
             const std::optional<::base::UnguessableToken>& unsafe_agent_cluster_id) {*out_unsafe_agent_cluster_id = std::move(unsafe_agent_cluster_id);
            loop->Quit();
          },
          &loop,
          out_unsafe_agent_cluster_id));
  loop.Run();
}

std::optional<::base::UnguessableToken> BlobURLStoreAsyncWaiter::ResolveForNavigation(
    const ::GURL& url, ::mojo::PendingReceiver<BlobURLToken> token, bool is_top_level_navigation) {
  std::optional<::base::UnguessableToken> async_wait_result;
  ResolveForNavigation(std::move(url),std::move(token),std::move(is_top_level_navigation),&async_wait_result);
  return async_wait_result;
}

void BlobURLStoreAsyncWaiter::ResolveForWorkerScriptFetch(
    const ::GURL& url, ::mojo::PendingReceiver<BlobURLToken> token, std::optional<::base::UnguessableToken>* out_unsafe_agent_cluster_id) {
  base::RunLoop loop;
  proxy_->ResolveForWorkerScriptFetch(
      std::move(url),
      std::move(token),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::UnguessableToken>* out_unsafe_agent_cluster_id
,
             const std::optional<::base::UnguessableToken>& unsafe_agent_cluster_id) {*out_unsafe_agent_cluster_id = std::move(unsafe_agent_cluster_id);
            loop->Quit();
          },
          &loop,
          out_unsafe_agent_cluster_id));
  loop.Run();
}

std::optional<::base::UnguessableToken> BlobURLStoreAsyncWaiter::ResolveForWorkerScriptFetch(
    const ::GURL& url, ::mojo::PendingReceiver<BlobURLToken> token) {
  std::optional<::base::UnguessableToken> async_wait_result;
  ResolveForWorkerScriptFetch(std::move(url),std::move(token),&async_wait_result);
  return async_wait_result;
}




void BlobURLTokenInterceptorForTesting::Clone(::mojo::PendingReceiver<BlobURLToken> token) {
  GetForwardingInterface()->Clone(
    std::move(token)
    );
}
void BlobURLTokenInterceptorForTesting::GetToken(GetTokenCallback callback) {
  GetForwardingInterface()->GetToken(std::move(callback));
}
BlobURLTokenAsyncWaiter::BlobURLTokenAsyncWaiter(
    BlobURLToken* proxy) : proxy_(proxy) {}

BlobURLTokenAsyncWaiter::~BlobURLTokenAsyncWaiter() = default;

void BlobURLTokenAsyncWaiter::GetToken(
    ::base::UnguessableToken* out_token) {
  base::RunLoop loop;
  proxy_->GetToken(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::UnguessableToken* out_token
,
             const ::base::UnguessableToken& token) {*out_token = std::move(token);
            loop->Quit();
          },
          &loop,
          out_token));
  loop.Run();
}

::base::UnguessableToken BlobURLTokenAsyncWaiter::GetToken(
    ) {
  ::base::UnguessableToken async_wait_result;
  GetToken(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif