// third_party/blink/public/mojom/document_metadata/document_metadata.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-params-data.h"
#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/document_metadata/document_metadata.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
WebPage::WebPage()
    : url(),
      title(),
      entities() {}

WebPage::WebPage(
    const ::blink::KURL& url_in,
    const WTF::String& title_in,
    WTF::Vector<::schema_org::mojom::blink::EntityPtr> entities_in)
    : url(std::move(url_in)),
      title(std::move(title_in)),
      entities(std::move(entities_in)) {}

WebPage::~WebPage() = default;

void WebPage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "entities"), this->entities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<::schema_org::mojom::blink::EntityPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebPage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char DocumentMetadata::Name_[] = "blink.mojom.DocumentMetadata";

DocumentMetadata::IPCStableHashFunction DocumentMetadata::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::DocumentMetadata>(message.name())) {
    case messages::DocumentMetadata::kGetEntities: {
      return &DocumentMetadata::GetEntities_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* DocumentMetadata::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::DocumentMetadata>(message.name())) {
      case messages::DocumentMetadata::kGetEntities:
            return "Receive blink::mojom::DocumentMetadata::GetEntities";
    }
  } else {
    switch (static_cast<messages::DocumentMetadata>(message.name())) {
      case messages::DocumentMetadata::kGetEntities:
            return "Receive reply blink::mojom::DocumentMetadata::GetEntities";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t DocumentMetadata::GetEntities_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::DocumentMetadata::GetEntities");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class DocumentMetadata_GetEntities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  DocumentMetadata_GetEntities_ForwardToCallback(
      DocumentMetadata::GetEntitiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  DocumentMetadata_GetEntities_ForwardToCallback(const DocumentMetadata_GetEntities_ForwardToCallback&) = delete;
  DocumentMetadata_GetEntities_ForwardToCallback& operator=(const DocumentMetadata_GetEntities_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  DocumentMetadata::GetEntitiesCallback callback_;
};

DocumentMetadataProxy::DocumentMetadataProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DocumentMetadataProxy::GetEntities(
    GetEntitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::DocumentMetadata::GetEntities");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentMetadata::kGetEntities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DocumentMetadata_GetEntities_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentMetadata::Name_);
  message.set_method_name("GetEntities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new DocumentMetadata_GetEntities_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class DocumentMetadata_GetEntities_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static DocumentMetadata::GetEntitiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<DocumentMetadata_GetEntities_ProxyToResponder> proxy(
        new DocumentMetadata_GetEntities_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&DocumentMetadata_GetEntities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~DocumentMetadata_GetEntities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  DocumentMetadata_GetEntities_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "DocumentMetadata::GetEntitiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WebPagePtr in_page);
};

bool DocumentMetadata_GetEntities_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::DocumentMetadata_GetEntities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::DocumentMetadata_GetEntities_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for DocumentMetadata.0
  bool success = true;
  WebPagePtr p_page{};
  DocumentMetadata_GetEntities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPage(&p_page))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        DocumentMetadata::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_page));
  return true;
}

void DocumentMetadata_GetEntities_ProxyToResponder::Run(
    WebPagePtr in_page) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::DocumentMetadata::GetEntities", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type WebPagePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::DocumentMetadata::kGetEntities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::DocumentMetadata_GetEntities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page)::BaseType> page_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WebPageDataView>(
      in_page, page_fragment);
  params->page.Set(
      page_fragment.is_null() ? nullptr : page_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(DocumentMetadata::Name_);
  message.set_method_name("GetEntities");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool DocumentMetadataStubDispatch::Accept(
    DocumentMetadata* impl,
    mojo::Message* message) {
  switch (static_cast<messages::DocumentMetadata>(message->header()->name)) {
    case messages::DocumentMetadata::kGetEntities: {
      break;
    }
  }
  return false;
}

// static
bool DocumentMetadataStubDispatch::AcceptWithResponder(
    DocumentMetadata* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::DocumentMetadata>(message->header()->name)) {
    case messages::DocumentMetadata::kGetEntities: {
      internal::DocumentMetadata_GetEntities_Params_Data* params =
          reinterpret_cast<
              internal::DocumentMetadata_GetEntities_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for DocumentMetadata.0
      bool success = true;
      DocumentMetadata_GetEntities_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            DocumentMetadata::Name_, 0, false);
        return false;
      }
      DocumentMetadata::GetEntitiesCallback callback =
          DocumentMetadata_GetEntities_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntities(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kDocumentMetadataValidationInfo[] = {
    { &internal::DocumentMetadata_GetEntities_Params_Data::Validate,
     &internal::DocumentMetadata_GetEntities_ResponseParams_Data::Validate},
};

bool DocumentMetadataRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DocumentMetadata::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kDocumentMetadataValidationInfo);
}

bool DocumentMetadataResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::DocumentMetadata::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kDocumentMetadataValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::WebPage::DataView, ::blink::mojom::blink::WebPagePtr>::Read(
    ::blink::mojom::blink::WebPage::DataView input,
    ::blink::mojom::blink::WebPagePtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebPagePtr result(::blink::mojom::blink::WebPage::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadEntities(&result->entities))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void DocumentMetadataInterceptorForTesting::GetEntities(GetEntitiesCallback callback) {
  GetForwardingInterface()->GetEntities(std::move(callback));
}
DocumentMetadataAsyncWaiter::DocumentMetadataAsyncWaiter(
    DocumentMetadata* proxy) : proxy_(proxy) {}

DocumentMetadataAsyncWaiter::~DocumentMetadataAsyncWaiter() = default;

void DocumentMetadataAsyncWaiter::GetEntities(
    WebPagePtr* out_page) {
  base::RunLoop loop;
  proxy_->GetEntities(
      base::BindOnce(
          [](base::RunLoop* loop,
             WebPagePtr* out_page
,
             WebPagePtr page) {*out_page = std::move(page);
            loop->Quit();
          },
          &loop,
          out_page));
  loop.Run();
}

WebPagePtr DocumentMetadataAsyncWaiter::GetEntities(
    ) {
  WebPagePtr async_wait_result;
  GetEntities(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif