// third_party/blink/public/mojom/drag/drag.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/drag/drag.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "third_party/blink/public/mojom/data_transfer/data_transfer.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class AllowedDragOperationsDataView;

class DragItemStringDataView;

class DragItemBinaryDataView;

class DragItemFileSystemFileDataView;

class DragDataDataView;

class DragEventSourceInfoDataView;

class DragItemDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::AllowedDragOperationsDataView> {
  using Data = ::blink::mojom::internal::AllowedDragOperations_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemStringDataView> {
  using Data = ::blink::mojom::internal::DragItemString_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemBinaryDataView> {
  using Data = ::blink::mojom::internal::DragItemBinary_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemFileSystemFileDataView> {
  using Data = ::blink::mojom::internal::DragItemFileSystemFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragDataDataView> {
  using Data = ::blink::mojom::internal::DragData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragEventSourceInfoDataView> {
  using Data = ::blink::mojom::internal::DragEventSourceInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DragItemDataView> {
  using Data = ::blink::mojom::internal::DragItem_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class AllowedDragOperationsDataView {
 public:
  AllowedDragOperationsDataView() = default;

  AllowedDragOperationsDataView(
      internal::AllowedDragOperations_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow_copy() const {
    return data_->allow_copy;
  }
  bool allow_link() const {
    return data_->allow_link;
  }
  bool allow_move() const {
    return data_->allow_move;
  }
 private:
  internal::AllowedDragOperations_Data* data_ = nullptr;
};


class DragItemStringDataView {
 public:
  DragItemStringDataView() = default;

  DragItemStringDataView(
      internal::DragItemString_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStringTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringType(UserType* output) {
    
    auto* pointer = data_->string_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStringDataDataView(
      ::mojo_base::mojom::BigString16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStringData(UserType* output) {
    
    auto* pointer = data_->string_data.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::BigString16DataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `title` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTitle` instead "
    "of `ReadTitle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBaseUrl` instead "
    "of `ReadBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::DragItemString_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragItemBinaryDataView {
 public:
  DragItemBinaryDataView() = default;

  DragItemBinaryDataView(
      internal::DragItemBinary_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = !data_->data.is_null() ? &data_->data : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, message_);
  }
  bool is_image_accessible() const {
    return data_->is_image_accessible;
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFilenameExtensionDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilenameExtension(UserType* output) {
    
    auto* pointer = data_->filename_extension.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetContentDispositionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentDisposition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `content_disposition` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadContentDisposition` instead "
    "of `ReadContentDisposition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->content_disposition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DragItemBinary_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragItemFileSystemFileDataView {
 public:
  DragItemFileSystemFileDataView() = default;

  DragItemFileSystemFileDataView(
      internal::DragItemFileSystemFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  int64_t size() const {
    return data_->size;
  }
  inline void GetFileSystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `file_system_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileSystemId` instead "
    "of `ReadFileSystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_system_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSerializedBlobDataView(
      ::blink::mojom::SerializedBlobDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedBlob(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::SerializedBlobDataView, UserType>(),
    "Attempting to read the optional `serialized_blob` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSerializedBlob` instead "
    "of `ReadSerializedBlob if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->serialized_blob.Get();
    return mojo::internal::Deserialize<::blink::mojom::SerializedBlobDataView>(
        pointer, output, message_);
  }
 private:
  internal::DragItemFileSystemFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragDataDataView {
 public:
  DragDataDataView() = default;

  DragDataDataView(
      internal::DragData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemsDataView(
      mojo::ArrayDataView<DragItemDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItems(UserType* output) {
    
    auto* pointer = data_->items.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::DragItemDataView>>(
        pointer, output, message_);
  }
  inline void GetFileSystemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `file_system_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFileSystemId` instead "
    "of `ReadFileSystemId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file_system_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool force_default_action() const {
    return data_->force_default_action;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
 private:
  internal::DragData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragEventSourceInfoDataView {
 public:
  DragEventSourceInfoDataView() = default;

  DragEventSourceInfoDataView(
      internal::DragEventSourceInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLocationDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLocation(UserType* output) {
    
    auto* pointer = data_->location.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::ui::mojom::DragEventSource>(
        data_value, output);
  }
  ::ui::mojom::DragEventSource source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::DragEventSource>(data_->source));
  }
 private:
  internal::DragEventSourceInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DragItemDataView {
 public:
  using Tag = internal::DragItem_Data::DragItem_Tag;

  DragItemDataView() = default;

  DragItemDataView(
      internal::DragItem_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_string() const { return data_->tag == Tag::kString; }
  inline void GetStringDataView(
      DragItemStringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadString(UserType* output) const {
    
    CHECK(is_string());
    return mojo::internal::Deserialize<::blink::mojom::DragItemStringDataView>(
        data_->data.f_string.Get(), output, message_);
  }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      ::blink::mojom::DataTransferFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::blink::mojom::DataTransferFileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_binary() const { return data_->tag == Tag::kBinary; }
  inline void GetBinaryDataView(
      DragItemBinaryDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBinary(UserType* output) const {
    
    CHECK(is_binary());
    return mojo::internal::Deserialize<::blink::mojom::DragItemBinaryDataView>(
        data_->data.f_binary.Get(), output, message_);
  }
  bool is_file_system_file() const { return data_->tag == Tag::kFileSystemFile; }
  inline void GetFileSystemFileDataView(
      DragItemFileSystemFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFileSystemFile(UserType* output) const {
    
    CHECK(is_file_system_file());
    return mojo::internal::Deserialize<::blink::mojom::DragItemFileSystemFileDataView>(
        data_->data.f_file_system_file.Get(), output, message_);
  }

 private:
  internal::DragItem_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::AllowedDragOperationsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::AllowedDragOperationsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::AllowedDragOperations_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->allow_copy = Traits::allow_copy(input);
    fragment->allow_link = Traits::allow_link(input);
    fragment->allow_move = Traits::allow_move(input);
  }

  static bool Deserialize(::blink::mojom::internal::AllowedDragOperations_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::AllowedDragOperationsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemStringDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemStringDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemString_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::string_type(input)) in_string_type = Traits::string_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->string_type)::BaseType> string_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_string_type, string_type_fragment);
    fragment->string_type.Set(
        string_type_fragment.is_null() ? nullptr : string_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->string_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string_type in DragItemString struct");
    decltype(Traits::string_data(input)) in_string_data = Traits::string_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->string_data)::BaseType> string_data_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::BigString16DataView>(
        in_string_data, string_data_fragment);
    fragment->string_data.Set(
        string_data_fragment.is_null() ? nullptr : string_data_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->string_data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null string_data in DragItemString struct");
    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_title, title_fragment);
    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
    decltype(Traits::base_url(input)) in_base_url = Traits::base_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->base_url)::BaseType> base_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_base_url, base_url_fragment);
    fragment->base_url.Set(
        base_url_fragment.is_null() ? nullptr : base_url_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemString_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemStringDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemBinaryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemBinaryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemBinary_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<decltype(fragment->data)>
        data_fragment(fragment.message());
    data_fragment.Claim(&fragment->data);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_data, data_fragment, true);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->data.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null data in DragItemBinary struct");
    fragment->is_image_accessible = Traits::is_image_accessible(input);
    decltype(Traits::source_url(input)) in_source_url = Traits::source_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_url)::BaseType> source_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_source_url, source_url_fragment);
    fragment->source_url.Set(
        source_url_fragment.is_null() ? nullptr : source_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->source_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_url in DragItemBinary struct");
    decltype(Traits::filename_extension(input)) in_filename_extension = Traits::filename_extension(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filename_extension)::BaseType> filename_extension_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
        in_filename_extension, filename_extension_fragment);
    fragment->filename_extension.Set(
        filename_extension_fragment.is_null() ? nullptr : filename_extension_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->filename_extension.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filename_extension in DragItemBinary struct");
    decltype(Traits::content_disposition(input)) in_content_disposition = Traits::content_disposition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->content_disposition)::BaseType> content_disposition_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_content_disposition, content_disposition_fragment);
    fragment->content_disposition.Set(
        content_disposition_fragment.is_null() ? nullptr : content_disposition_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemBinary_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemBinaryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemFileSystemFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragItemFileSystemFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragItemFileSystemFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in DragItemFileSystemFile struct");
    fragment->size = Traits::size(input);
    decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_system_id)::BaseType> file_system_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_file_system_id, file_system_id_fragment);
    fragment->file_system_id.Set(
        file_system_id_fragment.is_null() ? nullptr : file_system_id_fragment.data());
    decltype(Traits::serialized_blob(input)) in_serialized_blob = Traits::serialized_blob(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serialized_blob)::BaseType> serialized_blob_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::SerializedBlobDataView>(
        in_serialized_blob, serialized_blob_fragment);
    fragment->serialized_blob.Set(
        serialized_blob_fragment.is_null() ? nullptr : serialized_blob_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DragItemFileSystemFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemFileSystemFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::items(input)) in_items = Traits::items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->items)::BaseType>
        items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::DragItemDataView>>(
        in_items, items_fragment, &items_validate_params);
    fragment->items.Set(
        items_fragment.is_null() ? nullptr : items_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->items.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in DragData struct");
    decltype(Traits::file_system_id(input)) in_file_system_id = Traits::file_system_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file_system_id)::BaseType> file_system_id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_file_system_id, file_system_id_fragment);
    fragment->file_system_id.Set(
        file_system_id_fragment.is_null() ? nullptr : file_system_id_fragment.data());
    fragment->force_default_action = Traits::force_default_action(input);
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input), &fragment->referrer_policy);
  }

  static bool Deserialize(::blink::mojom::internal::DragData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragEventSourceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DragEventSourceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DragEventSourceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::location(input)) in_location = Traits::location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->location)::BaseType> location_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_location, location_fragment);
    fragment->location.Set(
        location_fragment.is_null() ? nullptr : location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null location in DragEventSourceInfo struct");
    mojo::internal::Serialize<::ui::mojom::DragEventSource>(
        Traits::source(input), &fragment->source);
  }

  static bool Deserialize(::blink::mojom::internal::DragEventSourceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragEventSourceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DragItemDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::DragItemDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::DragItem_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::DragItemDataView::Tag::kString: {
        decltype(Traits::string(input))
            in_string = Traits::string(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_string)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::DragItemStringDataView>(
            in_string, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null string in DragItem union");
        fragment->data.f_string.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::DragItemDataView::Tag::kFile: {
        decltype(Traits::file(input))
            in_file = Traits::file(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_file)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::DataTransferFileDataView>(
            in_file, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file in DragItem union");
        fragment->data.f_file.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::DragItemDataView::Tag::kBinary: {
        decltype(Traits::binary(input))
            in_binary = Traits::binary(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_binary)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::DragItemBinaryDataView>(
            in_binary, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null binary in DragItem union");
        fragment->data.f_binary.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::DragItemDataView::Tag::kFileSystemFile: {
        decltype(Traits::file_system_file(input))
            in_file_system_file = Traits::file_system_file(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_file_system_file)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::DragItemFileSystemFileDataView>(
            in_file_system_file, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file_system_file in DragItem union");
        fragment->data.f_file_system_file.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::DragItem_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DragItemDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void DragItemStringDataView::GetStringTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->string_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DragItemStringDataView::GetStringDataDataView(
    ::mojo_base::mojom::BigString16DataView* output) {
  auto pointer = data_->string_data.Get();
  *output = ::mojo_base::mojom::BigString16DataView(pointer, message_);
}
inline void DragItemStringDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void DragItemStringDataView::GetBaseUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->base_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void DragItemBinaryDataView::GetDataDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->data;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, message_);
}
inline void DragItemBinaryDataView::GetSourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->source_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DragItemBinaryDataView::GetFilenameExtensionDataView(
    ::mojo_base::mojom::FilePathDataView* output) {
  auto pointer = data_->filename_extension.Get();
  *output = ::mojo_base::mojom::FilePathDataView(pointer, message_);
}
inline void DragItemBinaryDataView::GetContentDispositionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->content_disposition.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DragItemFileSystemFileDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DragItemFileSystemFileDataView::GetFileSystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_system_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DragItemFileSystemFileDataView::GetSerializedBlobDataView(
    ::blink::mojom::SerializedBlobDataView* output) {
  auto pointer = data_->serialized_blob.Get();
  *output = ::blink::mojom::SerializedBlobDataView(pointer, message_);
}


inline void DragDataDataView::GetItemsDataView(
    mojo::ArrayDataView<DragItemDataView>* output) {
  auto pointer = data_->items.Get();
  *output = mojo::ArrayDataView<DragItemDataView>(pointer, message_);
}
inline void DragDataDataView::GetFileSystemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->file_system_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DragEventSourceInfoDataView::GetLocationDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->location.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}


inline void DragItemDataView::GetStringDataView(
    DragItemStringDataView* output) const {
  CHECK(is_string());
  *output = DragItemStringDataView(data_->data.f_string.Get(), message_);
}
inline void DragItemDataView::GetFileDataView(
    ::blink::mojom::DataTransferFileDataView* output) const {
  CHECK(is_file());
  *output = ::blink::mojom::DataTransferFileDataView(data_->data.f_file.Get(), message_);
}
inline void DragItemDataView::GetBinaryDataView(
    DragItemBinaryDataView* output) const {
  CHECK(is_binary());
  *output = DragItemBinaryDataView(data_->data.f_binary.Get(), message_);
}
inline void DragItemDataView::GetFileSystemFileDataView(
    DragItemFileSystemFileDataView* output) const {
  CHECK(is_file_system_file());
  *output = DragItemFileSystemFileDataView(data_->data.f_file_system_file.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_DRAG_DRAG_MOJOM_SHARED_H_