// third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared-internal.h"
#include "cc/mojom/render_frame_metadata.mojom-shared.h"
#include "cc/mojom/touch_action.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "services/network/public/mojom/url_request.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/blob_url_store.mojom-shared.h"
#include "third_party/blink/public/mojom/conversions/conversions.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_owner_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_visual_properties.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/fullscreen.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/lifecycle.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/text_autosizer_page_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/tree_scope_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/triggering_event_info.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_notification_type.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/user_activation_update_types.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-shared.h"
#include "third_party/blink/public/mojom/input/focus_type.mojom-shared.h"
#include "third_party/blink/public/mojom/input/scroll_direction.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/navigation_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/permissions_policy/permissions_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/scroll/scroll_into_view_params.mojom-shared.h"
#include "third_party/blink/public/mojom/security_context/insecure_request_policy.mojom-shared.h"
#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "ui/base/mojom/window_open_disposition.mojom-shared.h"
#include "ui/events/mojom/scroll_granularity.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class RemoteMainFrameInterfacesDataView;

class RemoteFrameInterfacesFromRendererDataView;

class RemoteFrameInterfacesFromBrowserDataView;

class CreateRemoteChildParamsDataView;

class OpenURLParamsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::RemoteMainFrameInterfacesDataView> {
  using Data = ::blink::mojom::internal::RemoteMainFrameInterfaces_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RemoteFrameInterfacesFromRendererDataView> {
  using Data = ::blink::mojom::internal::RemoteFrameInterfacesFromRenderer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView> {
  using Data = ::blink::mojom::internal::RemoteFrameInterfacesFromBrowser_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CreateRemoteChildParamsDataView> {
  using Data = ::blink::mojom::internal::CreateRemoteChildParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::OpenURLParamsDataView> {
  using Data = ::blink::mojom::internal::OpenURLParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class NavigationStateKeepAliveHandleInterfaceBase {};

using NavigationStateKeepAliveHandlePtrDataView =
    mojo::InterfacePtrDataView<NavigationStateKeepAliveHandleInterfaceBase>;
using NavigationStateKeepAliveHandleRequestDataView =
    mojo::InterfaceRequestDataView<NavigationStateKeepAliveHandleInterfaceBase>;
using NavigationStateKeepAliveHandleAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NavigationStateKeepAliveHandleInterfaceBase>;
using NavigationStateKeepAliveHandleAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NavigationStateKeepAliveHandleInterfaceBase>;
class RemoteFrameHostInterfaceBase {};

using RemoteFrameHostPtrDataView =
    mojo::InterfacePtrDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteFrameHostInterfaceBase>;
using RemoteFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteFrameHostInterfaceBase>;
class RemoteFrameInterfaceBase {};

using RemoteFramePtrDataView =
    mojo::InterfacePtrDataView<RemoteFrameInterfaceBase>;
using RemoteFrameRequestDataView =
    mojo::InterfaceRequestDataView<RemoteFrameInterfaceBase>;
using RemoteFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteFrameInterfaceBase>;
using RemoteFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteFrameInterfaceBase>;
class RemoteMainFrameInterfaceBase {};

using RemoteMainFramePtrDataView =
    mojo::InterfacePtrDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameRequestDataView =
    mojo::InterfaceRequestDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteMainFrameInterfaceBase>;
using RemoteMainFrameAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteMainFrameInterfaceBase>;
class RemoteMainFrameHostInterfaceBase {};

using RemoteMainFrameHostPtrDataView =
    mojo::InterfacePtrDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostRequestDataView =
    mojo::InterfaceRequestDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RemoteMainFrameHostInterfaceBase>;
using RemoteMainFrameHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RemoteMainFrameHostInterfaceBase>;


class RemoteMainFrameInterfacesDataView {
 public:
  RemoteMainFrameInterfacesDataView() = default;

  RemoteMainFrameInterfacesDataView(
      internal::RemoteMainFrameInterfaces_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeMainFrameHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteMainFrameHostAssociatedPtrInfoDataView>(
            &data_->main_frame_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeMainFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteMainFrameAssociatedRequestDataView>(
            &data_->main_frame, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemoteMainFrameInterfaces_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemoteFrameInterfacesFromRendererDataView {
 public:
  RemoteFrameInterfacesFromRendererDataView() = default;

  RemoteFrameInterfacesFromRendererDataView(
      internal::RemoteFrameInterfacesFromRenderer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeFrame() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameAssociatedPtrInfoDataView>(
            &data_->frame, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameHostReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameHostAssociatedRequestDataView>(
            &data_->frame_host_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemoteFrameInterfacesFromRenderer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RemoteFrameInterfacesFromBrowserDataView {
 public:
  RemoteFrameInterfacesFromBrowserDataView() = default;

  RemoteFrameInterfacesFromBrowserDataView(
      internal::RemoteFrameInterfacesFromBrowser_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeFrameReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameAssociatedRequestDataView>(
            &data_->frame_receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeFrameHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::blink::mojom::RemoteFrameHostAssociatedPtrInfoDataView>(
            &data_->frame_host, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::RemoteFrameInterfacesFromBrowser_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateRemoteChildParamsDataView {
 public:
  CreateRemoteChildParamsDataView() = default;

  CreateRemoteChildParamsDataView(
      internal::CreateRemoteChildParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::blink::mojom::RemoteFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetOpenerFrameTokenDataView(
      ::blink::mojom::FrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOpenerFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::FrameTokenDataView, UserType>(),
    "Attempting to read the optional `opener_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadOpenerFrameToken` instead "
    "of `ReadOpenerFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->opener_frame_token.is_null() ? &data_->opener_frame_token : nullptr;
    return mojo::internal::Deserialize<::blink::mojom::FrameTokenDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTreeScopeType(UserType* output) const {
    auto data_value = data_->tree_scope_type;
    return mojo::internal::Deserialize<::blink::mojom::TreeScopeType>(
        data_value, output);
  }
  ::blink::mojom::TreeScopeType tree_scope_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TreeScopeType>(data_->tree_scope_type));
  }
  inline void GetReplicationStateDataView(
      ::blink::mojom::FrameReplicationStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplicationState(UserType* output) {
    
    auto* pointer = data_->replication_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameReplicationStateDataView>(
        pointer, output, message_);
  }
  inline void GetOwnerPropertiesDataView(
      ::blink::mojom::FrameOwnerPropertiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOwnerProperties(UserType* output) {
    
    auto* pointer = data_->owner_properties.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        pointer, output, message_);
  }
  bool is_loading() const {
    return data_->is_loading;
  }
  inline void GetDevtoolsFrameTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsFrameToken(UserType* output) {
    
    auto* pointer = data_->devtools_frame_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetFrameInterfacesDataView(
      RemoteFrameInterfacesFromBrowserDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameInterfaces(UserType* output) {
    
    auto* pointer = data_->frame_interfaces.Get();
    return mojo::internal::Deserialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
        pointer, output, message_);
  }
  inline void GetChildParamsDataView(
      mojo::ArrayDataView<CreateRemoteChildParamsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildParams(UserType* output) {
    
    auto* pointer = data_->child_params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::CreateRemoteChildParamsDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CreateRemoteChildParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OpenURLParamsDataView {
 public:
  OpenURLParamsDataView() = default;

  OpenURLParamsDataView(
      internal::OpenURLParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
    auto* pointer = data_->initiator_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorBaseUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorBaseUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `initiator_base_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorBaseUrl` instead "
    "of `ReadInitiatorBaseUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_base_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetInitiatorFrameTokenDataView(
      ::blink::mojom::LocalFrameTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorFrameToken(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::LocalFrameTokenDataView, UserType>(),
    "Attempting to read the optional `initiator_frame_token` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorFrameToken` instead "
    "of `ReadInitiatorFrameToken if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initiator_frame_token.Get();
    return mojo::internal::Deserialize<::blink::mojom::LocalFrameTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPostBodyDataView(
      ::network::mojom::URLRequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPostBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::network::mojom::URLRequestBodyDataView, UserType>(),
    "Attempting to read the optional `post_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPostBody` instead "
    "of `ReadPostBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->post_body.Get();
    return mojo::internal::Deserialize<::network::mojom::URLRequestBodyDataView>(
        pointer, output, message_);
  }
  inline void GetExtraHeadersDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExtraHeaders(UserType* output) {
    
    auto* pointer = data_->extra_headers.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, message_);
  }
  bool is_form_submission() const {
    return data_->is_form_submission;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDisposition(UserType* output) const {
    auto data_value = data_->disposition;
    return mojo::internal::Deserialize<::ui::mojom::WindowOpenDisposition>(
        data_value, output);
  }
  ::ui::mojom::WindowOpenDisposition disposition() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::WindowOpenDisposition>(data_->disposition));
  }
  bool should_replace_current_entry() const {
    return data_->should_replace_current_entry;
  }
  bool user_gesture() const {
    return data_->user_gesture;
  }
  bool is_unfenced_top_navigation() const {
    return data_->is_unfenced_top_navigation;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTriggeringEventInfo(UserType* output) const {
    auto data_value = data_->triggering_event_info;
    return mojo::internal::Deserialize<::blink::mojom::TriggeringEventInfo>(
        data_value, output);
  }
  ::blink::mojom::TriggeringEventInfo triggering_event_info() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::TriggeringEventInfo>(data_->triggering_event_info));
  }
  template <typename UserType>
  UserType TakeBlobUrlToken() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
            &data_->blob_url_token, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetHrefTranslateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHrefTranslate(UserType* output) {
    
    auto* pointer = data_->href_translate.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetImpressionDataView(
      ::blink::mojom::ImpressionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImpression(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ImpressionDataView, UserType>(),
    "Attempting to read the optional `impression` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImpression` instead "
    "of `ReadImpression if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->impression.Get();
    return mojo::internal::Deserialize<::blink::mojom::ImpressionDataView>(
        pointer, output, message_);
  }
  inline void GetDownloadPolicyDataView(
      ::blink::mojom::NavigationDownloadPolicyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownloadPolicy(UserType* output) {
    
    auto* pointer = data_->download_policy.Get();
    return mojo::internal::Deserialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        pointer, output, message_);
  }
  inline void GetSourceLocationDataView(
      ::network::mojom::SourceLocationDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLocation(UserType* output) {
    
    auto* pointer = data_->source_location.Get();
    return mojo::internal::Deserialize<::network::mojom::SourceLocationDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeInitiatorNavigationStateKeepAliveHandle() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::NavigationStateKeepAliveHandleInterfaceBase>>(
            &data_->initiator_navigation_state_keep_alive_handle, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorActivationAndAdStatus(UserType* output) const {
    auto data_value = data_->initiator_activation_and_ad_status;
    return mojo::internal::Deserialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        data_value, output);
  }
  ::blink::mojom::NavigationInitiatorActivationAndAdStatus initiator_activation_and_ad_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(data_->initiator_activation_and_ad_status));
  }
  bool is_container_initiated() const {
    return data_->is_container_initiated;
  }
  bool has_rel_opener() const {
    return data_->has_rel_opener;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
 private:
  internal::OpenURLParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RemoteMainFrameInterfacesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RemoteMainFrameInterfacesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RemoteMainFrameInterfaces_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::main_frame_host(input)) in_main_frame_host = Traits::main_frame_host(input);
    mojo::internal::Serialize<::blink::mojom::RemoteMainFrameHostAssociatedPtrInfoDataView>(
        in_main_frame_host, &fragment->main_frame_host, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->main_frame_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid main_frame_host in RemoteMainFrameInterfaces struct");
    decltype(Traits::main_frame(input)) in_main_frame = Traits::main_frame(input);
    mojo::internal::Serialize<::blink::mojom::RemoteMainFrameAssociatedRequestDataView>(
        in_main_frame, &fragment->main_frame, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->main_frame),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid main_frame in RemoteMainFrameInterfaces struct");
  }

  static bool Deserialize(::blink::mojom::internal::RemoteMainFrameInterfaces_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RemoteMainFrameInterfacesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RemoteFrameInterfacesFromRendererDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RemoteFrameInterfacesFromRendererDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RemoteFrameInterfacesFromRenderer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame(input)) in_frame = Traits::frame(input);
    mojo::internal::Serialize<::blink::mojom::RemoteFrameAssociatedPtrInfoDataView>(
        in_frame, &fragment->frame, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame in RemoteFrameInterfacesFromRenderer struct");
    decltype(Traits::frame_host_receiver(input)) in_frame_host_receiver = Traits::frame_host_receiver(input);
    mojo::internal::Serialize<::blink::mojom::RemoteFrameHostAssociatedRequestDataView>(
        in_frame_host_receiver, &fragment->frame_host_receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame_host_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_host_receiver in RemoteFrameInterfacesFromRenderer struct");
  }

  static bool Deserialize(::blink::mojom::internal::RemoteFrameInterfacesFromRenderer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RemoteFrameInterfacesFromRendererDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RemoteFrameInterfacesFromBrowser_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::frame_receiver(input)) in_frame_receiver = Traits::frame_receiver(input);
    mojo::internal::Serialize<::blink::mojom::RemoteFrameAssociatedRequestDataView>(
        in_frame_receiver, &fragment->frame_receiver, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame_receiver),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_receiver in RemoteFrameInterfacesFromBrowser struct");
    decltype(Traits::frame_host(input)) in_frame_host = Traits::frame_host(input);
    mojo::internal::Serialize<::blink::mojom::RemoteFrameHostAssociatedPtrInfoDataView>(
        in_frame_host, &fragment->frame_host, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->frame_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
        "invalid frame_host in RemoteFrameInterfacesFromBrowser struct");
  }

  static bool Deserialize(::blink::mojom::internal::RemoteFrameInterfacesFromBrowser_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RemoteFrameInterfacesFromBrowserDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::CreateRemoteChildParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CreateRemoteChildParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CreateRemoteChildParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::token(input)) in_token = Traits::token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->token)::BaseType> token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RemoteFrameTokenDataView>(
        in_token, token_fragment);
    fragment->token.Set(
        token_fragment.is_null() ? nullptr : token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in CreateRemoteChildParams struct");
    decltype(Traits::opener_frame_token(input)) in_opener_frame_token = Traits::opener_frame_token(input);
    mojo::internal::MessageFragment<decltype(fragment->opener_frame_token)>
        opener_frame_token_fragment(fragment.message());
    opener_frame_token_fragment.Claim(&fragment->opener_frame_token);
    mojo::internal::Serialize<::blink::mojom::FrameTokenDataView>(
        in_opener_frame_token, opener_frame_token_fragment, true);
    mojo::internal::Serialize<::blink::mojom::TreeScopeType>(
        Traits::tree_scope_type(input), &fragment->tree_scope_type);
    decltype(Traits::replication_state(input)) in_replication_state = Traits::replication_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replication_state)::BaseType> replication_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FrameReplicationStateDataView>(
        in_replication_state, replication_state_fragment);
    fragment->replication_state.Set(
        replication_state_fragment.is_null() ? nullptr : replication_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->replication_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replication_state in CreateRemoteChildParams struct");
    decltype(Traits::owner_properties(input)) in_owner_properties = Traits::owner_properties(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->owner_properties)::BaseType> owner_properties_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FrameOwnerPropertiesDataView>(
        in_owner_properties, owner_properties_fragment);
    fragment->owner_properties.Set(
        owner_properties_fragment.is_null() ? nullptr : owner_properties_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->owner_properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null owner_properties in CreateRemoteChildParams struct");
    fragment->is_loading = Traits::is_loading(input);
    decltype(Traits::devtools_frame_token(input)) in_devtools_frame_token = Traits::devtools_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_frame_token)::BaseType> devtools_frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_devtools_frame_token, devtools_frame_token_fragment);
    fragment->devtools_frame_token.Set(
        devtools_frame_token_fragment.is_null() ? nullptr : devtools_frame_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->devtools_frame_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null devtools_frame_token in CreateRemoteChildParams struct");
    decltype(Traits::frame_interfaces(input)) in_frame_interfaces = Traits::frame_interfaces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->frame_interfaces)::BaseType> frame_interfaces_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RemoteFrameInterfacesFromBrowserDataView>(
        in_frame_interfaces, frame_interfaces_fragment);
    fragment->frame_interfaces.Set(
        frame_interfaces_fragment.is_null() ? nullptr : frame_interfaces_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->frame_interfaces.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_interfaces in CreateRemoteChildParams struct");
    decltype(Traits::child_params(input)) in_child_params = Traits::child_params(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->child_params)::BaseType>
        child_params_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& child_params_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::CreateRemoteChildParamsDataView>>(
        in_child_params, child_params_fragment, &child_params_validate_params);
    fragment->child_params.Set(
        child_params_fragment.is_null() ? nullptr : child_params_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->child_params.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null child_params in CreateRemoteChildParams struct");
  }

  static bool Deserialize(::blink::mojom::internal::CreateRemoteChildParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::CreateRemoteChildParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::OpenURLParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::OpenURLParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::OpenURLParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in OpenURLParams struct");
    decltype(Traits::initiator_origin(input)) in_initiator_origin = Traits::initiator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_origin)::BaseType> initiator_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_initiator_origin, initiator_origin_fragment);
    fragment->initiator_origin.Set(
        initiator_origin_fragment.is_null() ? nullptr : initiator_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->initiator_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initiator_origin in OpenURLParams struct");
    decltype(Traits::initiator_base_url(input)) in_initiator_base_url = Traits::initiator_base_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_base_url)::BaseType> initiator_base_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_initiator_base_url, initiator_base_url_fragment);
    fragment->initiator_base_url.Set(
        initiator_base_url_fragment.is_null() ? nullptr : initiator_base_url_fragment.data());
    decltype(Traits::initiator_frame_token(input)) in_initiator_frame_token = Traits::initiator_frame_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_frame_token)::BaseType> initiator_frame_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
        in_initiator_frame_token, initiator_frame_token_fragment);
    fragment->initiator_frame_token.Set(
        initiator_frame_token_fragment.is_null() ? nullptr : initiator_frame_token_fragment.data());
    decltype(Traits::post_body(input)) in_post_body = Traits::post_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->post_body)::BaseType> post_body_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::URLRequestBodyDataView>(
        in_post_body, post_body_fragment);
    fragment->post_body.Set(
        post_body_fragment.is_null() ? nullptr : post_body_fragment.data());
    decltype(Traits::extra_headers(input)) in_extra_headers = Traits::extra_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->extra_headers)::BaseType> extra_headers_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_extra_headers, extra_headers_fragment);
    fragment->extra_headers.Set(
        extra_headers_fragment.is_null() ? nullptr : extra_headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->extra_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null extra_headers in OpenURLParams struct");
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, referrer_fragment);
    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in OpenURLParams struct");
    fragment->is_form_submission = Traits::is_form_submission(input);
    mojo::internal::Serialize<::ui::mojom::WindowOpenDisposition>(
        Traits::disposition(input), &fragment->disposition);
    fragment->should_replace_current_entry = Traits::should_replace_current_entry(input);
    fragment->user_gesture = Traits::user_gesture(input);
    fragment->is_unfenced_top_navigation = Traits::is_unfenced_top_navigation(input);
    mojo::internal::Serialize<::blink::mojom::TriggeringEventInfo>(
        Traits::triggering_event_info(input), &fragment->triggering_event_info);
    decltype(Traits::blob_url_token(input)) in_blob_url_token = Traits::blob_url_token(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobURLTokenInterfaceBase>>(
        in_blob_url_token, &fragment->blob_url_token, &fragment.message());
    decltype(Traits::href_translate(input)) in_href_translate = Traits::href_translate(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->href_translate)::BaseType> href_translate_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_href_translate, href_translate_fragment);
    fragment->href_translate.Set(
        href_translate_fragment.is_null() ? nullptr : href_translate_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->href_translate.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null href_translate in OpenURLParams struct");
    decltype(Traits::impression(input)) in_impression = Traits::impression(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->impression)::BaseType> impression_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ImpressionDataView>(
        in_impression, impression_fragment);
    fragment->impression.Set(
        impression_fragment.is_null() ? nullptr : impression_fragment.data());
    decltype(Traits::download_policy(input)) in_download_policy = Traits::download_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->download_policy)::BaseType> download_policy_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationDownloadPolicyDataView>(
        in_download_policy, download_policy_fragment);
    fragment->download_policy.Set(
        download_policy_fragment.is_null() ? nullptr : download_policy_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->download_policy.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null download_policy in OpenURLParams struct");
    decltype(Traits::source_location(input)) in_source_location = Traits::source_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_location)::BaseType> source_location_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
        in_source_location, source_location_fragment);
    fragment->source_location.Set(
        source_location_fragment.is_null() ? nullptr : source_location_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->source_location.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_location in OpenURLParams struct");
    decltype(Traits::initiator_navigation_state_keep_alive_handle(input)) in_initiator_navigation_state_keep_alive_handle = Traits::initiator_navigation_state_keep_alive_handle(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::NavigationStateKeepAliveHandleInterfaceBase>>(
        in_initiator_navigation_state_keep_alive_handle, &fragment->initiator_navigation_state_keep_alive_handle, &fragment.message());
    mojo::internal::Serialize<::blink::mojom::NavigationInitiatorActivationAndAdStatus>(
        Traits::initiator_activation_and_ad_status(input), &fragment->initiator_activation_and_ad_status);
    fragment->is_container_initiated = Traits::is_container_initiated(input);
    fragment->has_rel_opener = Traits::has_rel_opener(input);
    mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
        Traits::storage_access_api_status(input), &fragment->storage_access_api_status);
  }

  static bool Deserialize(::blink::mojom::internal::OpenURLParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::OpenURLParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {







inline void CreateRemoteChildParamsDataView::GetTokenDataView(
    ::blink::mojom::RemoteFrameTokenDataView* output) {
  auto pointer = data_->token.Get();
  *output = ::blink::mojom::RemoteFrameTokenDataView(pointer, message_);
}
inline void CreateRemoteChildParamsDataView::GetOpenerFrameTokenDataView(
    ::blink::mojom::FrameTokenDataView* output) {
  auto pointer = &data_->opener_frame_token;
  *output = ::blink::mojom::FrameTokenDataView(pointer, message_);
}
inline void CreateRemoteChildParamsDataView::GetReplicationStateDataView(
    ::blink::mojom::FrameReplicationStateDataView* output) {
  auto pointer = data_->replication_state.Get();
  *output = ::blink::mojom::FrameReplicationStateDataView(pointer, message_);
}
inline void CreateRemoteChildParamsDataView::GetOwnerPropertiesDataView(
    ::blink::mojom::FrameOwnerPropertiesDataView* output) {
  auto pointer = data_->owner_properties.Get();
  *output = ::blink::mojom::FrameOwnerPropertiesDataView(pointer, message_);
}
inline void CreateRemoteChildParamsDataView::GetDevtoolsFrameTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_frame_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void CreateRemoteChildParamsDataView::GetFrameInterfacesDataView(
    RemoteFrameInterfacesFromBrowserDataView* output) {
  auto pointer = data_->frame_interfaces.Get();
  *output = RemoteFrameInterfacesFromBrowserDataView(pointer, message_);
}
inline void CreateRemoteChildParamsDataView::GetChildParamsDataView(
    mojo::ArrayDataView<CreateRemoteChildParamsDataView>* output) {
  auto pointer = data_->child_params.Get();
  *output = mojo::ArrayDataView<CreateRemoteChildParamsDataView>(pointer, message_);
}


inline void OpenURLParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetInitiatorOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->initiator_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetInitiatorBaseUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->initiator_base_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetInitiatorFrameTokenDataView(
    ::blink::mojom::LocalFrameTokenDataView* output) {
  auto pointer = data_->initiator_frame_token.Get();
  *output = ::blink::mojom::LocalFrameTokenDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetPostBodyDataView(
    ::network::mojom::URLRequestBodyDataView* output) {
  auto pointer = data_->post_body.Get();
  *output = ::network::mojom::URLRequestBodyDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetExtraHeadersDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->extra_headers.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetHrefTranslateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->href_translate.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetImpressionDataView(
    ::blink::mojom::ImpressionDataView* output) {
  auto pointer = data_->impression.Get();
  *output = ::blink::mojom::ImpressionDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetDownloadPolicyDataView(
    ::blink::mojom::NavigationDownloadPolicyDataView* output) {
  auto pointer = data_->download_policy.Get();
  *output = ::blink::mojom::NavigationDownloadPolicyDataView(pointer, message_);
}
inline void OpenURLParamsDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_REMOTE_FRAME_MOJOM_SHARED_H_