// third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_SINKS_EMBEDDED_FRAME_SINK_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_SINKS_EMBEDDED_FRAME_SINK_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/frame_sinks/embedded_frame_sink.mojom-forward.h"  // IWYU pragma: export
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom-forward.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle.mojom-forward.h"
#include "services/viz/public/mojom/compositing/frame_sink_bundle_id.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "services/viz/public/mojom/compositing/surface_info.mojom-forward.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "content/common/content_export.h"




namespace blink::mojom {

class SurfaceEmbedderProxy;

template <typename ImplRefTraits>
class SurfaceEmbedderStub;

class SurfaceEmbedderRequestValidator;


class CONTENT_EXPORT SurfaceEmbedder
    : public SurfaceEmbedderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SurfaceEmbedderInterfaceBase;
  using Proxy_ = SurfaceEmbedderProxy;

  template <typename ImplRefTraits>
  using Stub_ = SurfaceEmbedderStub<ImplRefTraits>;

  using RequestValidator_ = SurfaceEmbedderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetLocalSurfaceIdMinVersion = 0,
    kOnOpacityChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetLocalSurfaceId_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnOpacityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SurfaceEmbedder() = default;

  
  virtual void SetLocalSurfaceId(const ::viz::LocalSurfaceId& local_surface_id) = 0;

  
  virtual void OnOpacityChanged(bool is_opaque) = 0;
};

class EmbeddedFrameSinkClientProxy;

template <typename ImplRefTraits>
class EmbeddedFrameSinkClientStub;

class EmbeddedFrameSinkClientRequestValidator;


class CONTENT_EXPORT EmbeddedFrameSinkClient
    : public EmbeddedFrameSinkClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedFrameSinkClientInterfaceBase;
  using Proxy_ = EmbeddedFrameSinkClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedFrameSinkClientStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedFrameSinkClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindSurfaceEmbedderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindSurfaceEmbedder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedFrameSinkClient() = default;

  
  virtual void BindSurfaceEmbedder(::mojo::PendingReceiver<SurfaceEmbedder> embedder) = 0;
};

class EmbeddedFrameSinkProviderProxy;

template <typename ImplRefTraits>
class EmbeddedFrameSinkProviderStub;

class EmbeddedFrameSinkProviderRequestValidator;


class CONTENT_EXPORT EmbeddedFrameSinkProvider
    : public EmbeddedFrameSinkProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedFrameSinkProviderInterfaceBase;
  using Proxy_ = EmbeddedFrameSinkProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedFrameSinkProviderStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedFrameSinkProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRegisterEmbeddedFrameSinkMinVersion = 0,
    kRegisterEmbeddedFrameSinkBundleMinVersion = 0,
    kCreateCompositorFrameSinkMinVersion = 0,
    kCreateBundledCompositorFrameSinkMinVersion = 0,
    kCreateSimpleCompositorFrameSinkMinVersion = 0,
    kConnectToEmbedderMinVersion = 0,
    kRegisterFrameSinkHierarchyMinVersion = 0,
    kUnregisterFrameSinkHierarchyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RegisterEmbeddedFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterEmbeddedFrameSinkBundle_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateCompositorFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateBundledCompositorFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateSimpleCompositorFrameSink_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ConnectToEmbedder_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterFrameSinkHierarchy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnregisterFrameSinkHierarchy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedFrameSinkProvider() = default;

  
  virtual void RegisterEmbeddedFrameSink(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> client) = 0;

  
  virtual void RegisterEmbeddedFrameSinkBundle(const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> client) = 0;

  
  virtual void CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) = 0;

  
  virtual void CreateBundledCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) = 0;

  
  virtual void CreateSimpleCompositorFrameSink(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> surface_client, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) = 0;

  
  virtual void ConnectToEmbedder(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingReceiver<SurfaceEmbedder> embedder) = 0;

  
  virtual void RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& frame_sink_id) = 0;

  
  virtual void UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& frame_sink_id) = 0;
};



class CONTENT_EXPORT SurfaceEmbedderProxy
    : public SurfaceEmbedder {
 public:
  using InterfaceType = SurfaceEmbedder;

  explicit SurfaceEmbedderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetLocalSurfaceId(const ::viz::LocalSurfaceId& local_surface_id) final;
  
  void OnOpacityChanged(bool is_opaque) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT EmbeddedFrameSinkClientProxy
    : public EmbeddedFrameSinkClient {
 public:
  using InterfaceType = EmbeddedFrameSinkClient;

  explicit EmbeddedFrameSinkClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindSurfaceEmbedder(::mojo::PendingReceiver<SurfaceEmbedder> embedder) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT EmbeddedFrameSinkProviderProxy
    : public EmbeddedFrameSinkProvider {
 public:
  using InterfaceType = EmbeddedFrameSinkProvider;

  explicit EmbeddedFrameSinkProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RegisterEmbeddedFrameSink(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> client) final;
  
  void RegisterEmbeddedFrameSinkBundle(const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingReceiver<::viz::mojom::FrameSinkBundle> receiver, ::mojo::PendingRemote<::viz::mojom::FrameSinkBundleClient> client) final;
  
  void CreateCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) final;
  
  void CreateBundledCompositorFrameSink(const ::viz::FrameSinkId& frame_sink_id, const ::viz::FrameSinkBundleId& bundle_id, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) final;
  
  void CreateSimpleCompositorFrameSink(const ::viz::FrameSinkId& parent_frame_sink_id, const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingRemote<EmbeddedFrameSinkClient> surface_client, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> client, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> sink) final;
  
  void ConnectToEmbedder(const ::viz::FrameSinkId& frame_sink_id, ::mojo::PendingReceiver<SurfaceEmbedder> embedder) final;
  
  void RegisterFrameSinkHierarchy(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void UnregisterFrameSinkHierarchy(const ::viz::FrameSinkId& frame_sink_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT SurfaceEmbedderStubDispatch {
 public:
  static bool Accept(SurfaceEmbedder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SurfaceEmbedder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SurfaceEmbedder>>
class SurfaceEmbedderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SurfaceEmbedderStub() = default;
  ~SurfaceEmbedderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SurfaceEmbedderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SurfaceEmbedderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT EmbeddedFrameSinkClientStubDispatch {
 public:
  static bool Accept(EmbeddedFrameSinkClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedFrameSinkClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedFrameSinkClient>>
class EmbeddedFrameSinkClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedFrameSinkClientStub() = default;
  ~EmbeddedFrameSinkClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedFrameSinkClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedFrameSinkClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT EmbeddedFrameSinkProviderStubDispatch {
 public:
  static bool Accept(EmbeddedFrameSinkProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedFrameSinkProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedFrameSinkProvider>>
class EmbeddedFrameSinkProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedFrameSinkProviderStub() = default;
  ~EmbeddedFrameSinkProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedFrameSinkProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedFrameSinkProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT SurfaceEmbedderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT EmbeddedFrameSinkClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT EmbeddedFrameSinkProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_FRAME_SINKS_EMBEDDED_FRAME_SINK_MOJOM_H_