// third_party/blink/public/mojom/page_state/page_state.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page_state/page_state.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"



#include "base/component_export.h"




namespace blink::mojom {
class DEPRECATED_FileSystemFileDataView;

class FileDataView;

class RequestBodyDataView;

class HttpBodyDataView;

class ViewStateDataView;

class FrameStateDataView;

class PageStateDataView;

class ElementDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DEPRECATED_FileSystemFileDataView> {
  using Data = ::blink::mojom::internal::DEPRECATED_FileSystemFile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FileDataView> {
  using Data = ::blink::mojom::internal::File_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::RequestBodyDataView> {
  using Data = ::blink::mojom::internal::RequestBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::HttpBodyDataView> {
  using Data = ::blink::mojom::internal::HttpBody_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ViewStateDataView> {
  using Data = ::blink::mojom::internal::ViewState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::FrameStateDataView> {
  using Data = ::blink::mojom::internal::FrameState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PageStateDataView> {
  using Data = ::blink::mojom::internal::PageState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::ElementDataView> {
  using Data = ::blink::mojom::internal::Element_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class ScrollRestorationType : int32_t {
  
  kAuto = 0,
  
  kManual = 1,
  kMinValue = 0,
  kMaxValue = 1,
  kDefaultValue = 0
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, ScrollRestorationType value);
inline bool IsKnownEnumValue(ScrollRestorationType value) {
  return internal::ScrollRestorationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ScrollRestorationType ToKnownEnumValue(ScrollRestorationType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ScrollRestorationType::kDefaultValue;
}


class DEPRECATED_FileSystemFileDataView {
 public:
  DEPRECATED_FileSystemFileDataView() = default;

  DEPRECATED_FileSystemFileDataView(
      internal::DEPRECATED_FileSystemFile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilesystemUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilesystemUrl(UserType* output) {
    
    auto* pointer = data_->filesystem_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModificationTime(UserType* output) {
    
    auto* pointer = data_->modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::DEPRECATED_FileSystemFile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FileDataView {
 public:
  FileDataView() = default;

  FileDataView(
      internal::File_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPathDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  uint64_t offset() const {
    return data_->offset;
  }
  uint64_t length() const {
    return data_->length;
  }
  inline void GetModificationTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadModificationTime(UserType* output) {
    
    auto* pointer = data_->modification_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::File_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RequestBodyDataView {
 public:
  RequestBodyDataView() = default;

  RequestBodyDataView(
      internal::RequestBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetElementsDataView(
      mojo::ArrayDataView<ElementDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadElements(UserType* output) {
    
    auto* pointer = data_->elements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::ElementDataView>>(
        pointer, output, message_);
  }
  int64_t identifier() const {
    return data_->identifier;
  }
  bool contains_sensitive_info() const {
    return data_->contains_sensitive_info;
  }
 private:
  internal::RequestBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class HttpBodyDataView {
 public:
  HttpBodyDataView() = default;

  HttpBodyDataView(
      internal::HttpBody_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetHttpContentTypeDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpContentType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `http_content_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadHttpContentType` instead "
    "of `ReadHttpContentType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->http_content_type.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetRequestBodyDataView(
      RequestBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestBody(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::RequestBodyDataView, UserType>(),
    "Attempting to read the optional `request_body` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestBody` instead "
    "of `ReadRequestBody if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_body.Get();
    return mojo::internal::Deserialize<::blink::mojom::RequestBodyDataView>(
        pointer, output, message_);
  }
  bool contains_passwords() const {
    return data_->contains_passwords;
  }
 private:
  internal::HttpBody_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ViewStateDataView {
 public:
  ViewStateDataView() = default;

  ViewStateDataView(
      internal::ViewState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetVisualViewportScrollOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisualViewportScrollOffset(UserType* output) {
    
    auto* pointer = data_->visual_viewport_scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  inline void GetScrollOffsetDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollOffset(UserType* output) {
    
    auto* pointer = data_->scroll_offset.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  double page_scale_factor() const {
    return data_->page_scale_factor;
  }
  inline void GetScrollAnchorSelectorDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollAnchorSelector(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `scroll_anchor_selector` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollAnchorSelector` instead "
    "of `ReadScrollAnchorSelector if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->scroll_anchor_selector.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetScrollAnchorOffsetDataView(
      ::gfx::mojom::PointFDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScrollAnchorOffset(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::PointFDataView, UserType>(),
    "Attempting to read the optional `scroll_anchor_offset` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScrollAnchorOffset` instead "
    "of `ReadScrollAnchorOffset if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->scroll_anchor_offset.Get() : nullptr;
    return mojo::internal::Deserialize<::gfx::mojom::PointFDataView>(
        pointer, output, message_);
  }
  uint64_t scroll_anchor_simhash() const {
    if (data_->header_.version < 1)
      return uint64_t{};
    return data_->scroll_anchor_simhash;
  }
 private:
  internal::ViewState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class FrameStateDataView {
 public:
  FrameStateDataView() = default;

  FrameStateDataView(
      internal::FrameState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlStringDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlString(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `url_string` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrlString` instead "
    "of `ReadUrlString if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url_string.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetReferrerDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferrer(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `referrer` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadReferrer` instead "
    "of `ReadReferrer if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetTargetDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTarget(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `target` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTarget` instead "
    "of `ReadTarget if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->target.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetStateObjectDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStateObject(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `state_object` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStateObject` instead "
    "of `ReadStateObject if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->state_object.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetDocumentStateDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDocumentState(UserType* output) {
    
    auto* pointer = data_->document_state.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadScrollRestorationType(UserType* output) const {
    auto data_value = data_->scroll_restoration_type;
    return mojo::internal::Deserialize<::blink::mojom::ScrollRestorationType>(
        data_value, output);
  }
  ScrollRestorationType scroll_restoration_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::ScrollRestorationType>(data_->scroll_restoration_type));
  }
  inline void GetViewStateDataView(
      ViewStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadViewState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::ViewStateDataView, UserType>(),
    "Attempting to read the optional `view_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadViewState` instead "
    "of `ReadViewState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->view_state.Get();
    return mojo::internal::Deserialize<::blink::mojom::ViewStateDataView>(
        pointer, output, message_);
  }
  int64_t item_sequence_number() const {
    return data_->item_sequence_number;
  }
  int64_t document_sequence_number() const {
    return data_->document_sequence_number;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }
  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy));
  }
  inline void GetHttpBodyDataView(
      HttpBodyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHttpBody(UserType* output) {
    
    auto* pointer = data_->http_body.Get();
    return mojo::internal::Deserialize<::blink::mojom::HttpBodyDataView>(
        pointer, output, message_);
  }
  inline void GetChildrenDataView(
      mojo::ArrayDataView<FrameStateDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChildren(UserType* output) {
    
    auto* pointer = data_->children.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::FrameStateDataView>>(
        pointer, output, message_);
  }
  inline void GetInitiatorOriginDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `initiator_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorOrigin` instead "
    "of `ReadInitiatorOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->initiator_origin.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNavigationApiKeyDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `navigation_api_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationApiKey` instead "
    "of `ReadNavigationApiKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->navigation_api_key.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNavigationApiIdDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `navigation_api_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationApiId` instead "
    "of `ReadNavigationApiId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->navigation_api_id.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetNavigationApiStateDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNavigationApiState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `navigation_api_state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNavigationApiState` instead "
    "of `ReadNavigationApiState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 4
                    ? data_->navigation_api_state.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  bool protect_url_in_navigation_api() const {
    if (data_->header_.version < 5)
      return bool{};
    return data_->protect_url_in_navigation_api;
  }
  inline void GetInitiatorBaseUrlStringDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitiatorBaseUrlString(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `initiator_base_url_string` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitiatorBaseUrlString` instead "
    "of `ReadInitiatorBaseUrlString if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 6
                    ? data_->initiator_base_url_string.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::FrameState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PageStateDataView {
 public:
  PageStateDataView() = default;

  PageStateDataView(
      internal::PageState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReferencedFilesDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReferencedFiles(UserType* output) {
    
    auto* pointer = data_->referenced_files.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
  inline void GetTopDataView(
      FrameStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTop(UserType* output) {
    
    auto* pointer = data_->top.Get();
    return mojo::internal::Deserialize<::blink::mojom::FrameStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::PageState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ElementDataView {
 public:
  using Tag = internal::Element_Data::Element_Tag;

  ElementDataView() = default;

  ElementDataView(
      internal::Element_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_blob_uuid() const { return data_->tag == Tag::kBlobUuid; }
  inline void GetBlobUuidDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBlobUuid(UserType* output) const {
    
    CHECK(is_blob_uuid());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_blob_uuid.Get(), output, message_);
  }
  bool is_bytes() const { return data_->tag == Tag::kBytes; }
  inline void GetBytesDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadBytes(UserType* output) const {
    
    CHECK(is_bytes());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_bytes.Get(), output, message_);
  }
  bool is_file() const { return data_->tag == Tag::kFile; }
  inline void GetFileDataView(
      FileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) const {
    
    CHECK(is_file());
    return mojo::internal::Deserialize<::blink::mojom::FileDataView>(
        data_->data.f_file.Get(), output, message_);
  }
  bool is_DEPRECATED_file_system_file() const { return data_->tag == Tag::kDeprecatedFileSystemFile; }
  inline void GetDeprecatedFileSystemFileDataView(
      DEPRECATED_FileSystemFileDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadDeprecatedFileSystemFile(UserType* output) const {
    
    CHECK(is_DEPRECATED_file_system_file());
    return mojo::internal::Deserialize<::blink::mojom::DEPRECATED_FileSystemFileDataView>(
        data_->data.f_DEPRECATED_file_system_file.Get(), output, message_);
  }

 private:
  internal::Element_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

template <>
struct hash<::blink::mojom::ScrollRestorationType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ScrollRestorationType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ScrollRestorationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ScrollRestorationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::ScrollRestorationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DEPRECATED_FileSystemFileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DEPRECATED_FileSystemFileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DEPRECATED_FileSystemFile_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::filesystem_url(input)) in_filesystem_url = Traits::filesystem_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->filesystem_url)::BaseType> filesystem_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_filesystem_url, filesystem_url_fragment);
    fragment->filesystem_url.Set(
        filesystem_url_fragment.is_null() ? nullptr : filesystem_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->filesystem_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null filesystem_url in DEPRECATED_FileSystemFile struct");
    fragment->offset = Traits::offset(input);
    fragment->length = Traits::length(input);
    decltype(Traits::modification_time(input)) in_modification_time = Traits::modification_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modification_time)::BaseType> modification_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_modification_time, modification_time_fragment);
    fragment->modification_time.Set(
        modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->modification_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null modification_time in DEPRECATED_FileSystemFile struct");
  }

  static bool Deserialize(::blink::mojom::internal::DEPRECATED_FileSystemFile_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DEPRECATED_FileSystemFileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FileDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FileDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::File_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_path, path_fragment);
    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->path.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null path in File struct");
    fragment->offset = Traits::offset(input);
    fragment->length = Traits::length(input);
    decltype(Traits::modification_time(input)) in_modification_time = Traits::modification_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->modification_time)::BaseType> modification_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_modification_time, modification_time_fragment);
    fragment->modification_time.Set(
        modification_time_fragment.is_null() ? nullptr : modification_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->modification_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null modification_time in File struct");
  }

  static bool Deserialize(::blink::mojom::internal::File_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FileDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::RequestBodyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::RequestBodyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::RequestBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::elements(input)) in_elements = Traits::elements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->elements)::BaseType>
        elements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& elements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ElementDataView>>(
        in_elements, elements_fragment, &elements_validate_params);
    fragment->elements.Set(
        elements_fragment.is_null() ? nullptr : elements_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->elements.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null elements in RequestBody struct");
    fragment->identifier = Traits::identifier(input);
    fragment->contains_sensitive_info = Traits::contains_sensitive_info(input);
  }

  static bool Deserialize(::blink::mojom::internal::RequestBody_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::RequestBodyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::HttpBodyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::HttpBodyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::HttpBody_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::http_content_type(input)) in_http_content_type = Traits::http_content_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->http_content_type)::BaseType> http_content_type_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_http_content_type, http_content_type_fragment);
    fragment->http_content_type.Set(
        http_content_type_fragment.is_null() ? nullptr : http_content_type_fragment.data());
    decltype(Traits::request_body(input)) in_request_body = Traits::request_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_body)::BaseType> request_body_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::RequestBodyDataView>(
        in_request_body, request_body_fragment);
    fragment->request_body.Set(
        request_body_fragment.is_null() ? nullptr : request_body_fragment.data());
    fragment->contains_passwords = Traits::contains_passwords(input);
  }

  static bool Deserialize(::blink::mojom::internal::HttpBody_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::HttpBodyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ViewStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ViewStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ViewState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::visual_viewport_scroll_offset(input)) in_visual_viewport_scroll_offset = Traits::visual_viewport_scroll_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visual_viewport_scroll_offset)::BaseType> visual_viewport_scroll_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_visual_viewport_scroll_offset, visual_viewport_scroll_offset_fragment);
    fragment->visual_viewport_scroll_offset.Set(
        visual_viewport_scroll_offset_fragment.is_null() ? nullptr : visual_viewport_scroll_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->visual_viewport_scroll_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visual_viewport_scroll_offset in ViewState struct");
    decltype(Traits::scroll_offset(input)) in_scroll_offset = Traits::scroll_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_offset)::BaseType> scroll_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_scroll_offset, scroll_offset_fragment);
    fragment->scroll_offset.Set(
        scroll_offset_fragment.is_null() ? nullptr : scroll_offset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->scroll_offset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scroll_offset in ViewState struct");
    fragment->page_scale_factor = Traits::page_scale_factor(input);
    decltype(Traits::scroll_anchor_selector(input)) in_scroll_anchor_selector = Traits::scroll_anchor_selector(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_anchor_selector)::BaseType> scroll_anchor_selector_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_scroll_anchor_selector, scroll_anchor_selector_fragment);
    fragment->scroll_anchor_selector.Set(
        scroll_anchor_selector_fragment.is_null() ? nullptr : scroll_anchor_selector_fragment.data());
    decltype(Traits::scroll_anchor_offset(input)) in_scroll_anchor_offset = Traits::scroll_anchor_offset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scroll_anchor_offset)::BaseType> scroll_anchor_offset_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
        in_scroll_anchor_offset, scroll_anchor_offset_fragment);
    fragment->scroll_anchor_offset.Set(
        scroll_anchor_offset_fragment.is_null() ? nullptr : scroll_anchor_offset_fragment.data());
    fragment->scroll_anchor_simhash = Traits::scroll_anchor_simhash(input);
  }

  static bool Deserialize(::blink::mojom::internal::ViewState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ViewStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FrameStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FrameStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FrameState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::url_string(input)) in_url_string = Traits::url_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_string)::BaseType> url_string_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_url_string, url_string_fragment);
    fragment->url_string.Set(
        url_string_fragment.is_null() ? nullptr : url_string_fragment.data());
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referrer)::BaseType> referrer_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_referrer, referrer_fragment);
    fragment->referrer.Set(
        referrer_fragment.is_null() ? nullptr : referrer_fragment.data());
    decltype(Traits::target(input)) in_target = Traits::target(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target)::BaseType> target_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_target, target_fragment);
    fragment->target.Set(
        target_fragment.is_null() ? nullptr : target_fragment.data());
    decltype(Traits::state_object(input)) in_state_object = Traits::state_object(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->state_object)::BaseType> state_object_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_state_object, state_object_fragment);
    fragment->state_object.Set(
        state_object_fragment.is_null() ? nullptr : state_object_fragment.data());
    decltype(Traits::document_state(input)) in_document_state = Traits::document_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_state)::BaseType>
        document_state_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& document_state_validate_params =
        mojo::internal::GetArrayValidator<0, true, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        in_document_state, document_state_fragment, &document_state_validate_params);
    fragment->document_state.Set(
        document_state_fragment.is_null() ? nullptr : document_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->document_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_state in FrameState struct");
    mojo::internal::Serialize<::blink::mojom::ScrollRestorationType>(
        Traits::scroll_restoration_type(input), &fragment->scroll_restoration_type);
    decltype(Traits::view_state(input)) in_view_state = Traits::view_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->view_state)::BaseType> view_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::ViewStateDataView>(
        in_view_state, view_state_fragment);
    fragment->view_state.Set(
        view_state_fragment.is_null() ? nullptr : view_state_fragment.data());
    fragment->item_sequence_number = Traits::item_sequence_number(input);
    fragment->document_sequence_number = Traits::document_sequence_number(input);
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input), &fragment->referrer_policy);
    decltype(Traits::http_body(input)) in_http_body = Traits::http_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->http_body)::BaseType> http_body_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::HttpBodyDataView>(
        in_http_body, http_body_fragment);
    fragment->http_body.Set(
        http_body_fragment.is_null() ? nullptr : http_body_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->http_body.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null http_body in FrameState struct");
    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::FrameStateDataView>>(
        in_children, children_fragment, &children_validate_params);
    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->children.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in FrameState struct");
    decltype(Traits::initiator_origin(input)) in_initiator_origin = Traits::initiator_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_origin)::BaseType> initiator_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_initiator_origin, initiator_origin_fragment);
    fragment->initiator_origin.Set(
        initiator_origin_fragment.is_null() ? nullptr : initiator_origin_fragment.data());
    decltype(Traits::navigation_api_key(input)) in_navigation_api_key = Traits::navigation_api_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_api_key)::BaseType> navigation_api_key_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_navigation_api_key, navigation_api_key_fragment);
    fragment->navigation_api_key.Set(
        navigation_api_key_fragment.is_null() ? nullptr : navigation_api_key_fragment.data());
    decltype(Traits::navigation_api_id(input)) in_navigation_api_id = Traits::navigation_api_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_api_id)::BaseType> navigation_api_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_navigation_api_id, navigation_api_id_fragment);
    fragment->navigation_api_id.Set(
        navigation_api_id_fragment.is_null() ? nullptr : navigation_api_id_fragment.data());
    decltype(Traits::navigation_api_state(input)) in_navigation_api_state = Traits::navigation_api_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->navigation_api_state)::BaseType> navigation_api_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_navigation_api_state, navigation_api_state_fragment);
    fragment->navigation_api_state.Set(
        navigation_api_state_fragment.is_null() ? nullptr : navigation_api_state_fragment.data());
    fragment->protect_url_in_navigation_api = Traits::protect_url_in_navigation_api(input);
    decltype(Traits::initiator_base_url_string(input)) in_initiator_base_url_string = Traits::initiator_base_url_string(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initiator_base_url_string)::BaseType> initiator_base_url_string_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_initiator_base_url_string, initiator_base_url_string_fragment);
    fragment->initiator_base_url_string.Set(
        initiator_base_url_string_fragment.is_null() ? nullptr : initiator_base_url_string_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::FrameState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FrameStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PageStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PageState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::referenced_files(input)) in_referenced_files = Traits::referenced_files(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->referenced_files)::BaseType>
        referenced_files_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& referenced_files_validate_params =
        mojo::internal::GetArrayValidator<0, true, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        in_referenced_files, referenced_files_fragment, &referenced_files_validate_params);
    fragment->referenced_files.Set(
        referenced_files_fragment.is_null() ? nullptr : referenced_files_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->referenced_files.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referenced_files in PageState struct");
    decltype(Traits::top(input)) in_top = Traits::top(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top)::BaseType> top_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::FrameStateDataView>(
        in_top, top_fragment);
    fragment->top.Set(
        top_fragment.is_null() ? nullptr : top_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top in PageState struct");
  }

  static bool Deserialize(::blink::mojom::internal::PageState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PageStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ElementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::ElementDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::Element_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::ElementDataView::Tag::kBlobUuid: {
        decltype(Traits::blob_uuid(input))
            in_blob_uuid = Traits::blob_uuid(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_blob_uuid)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<mojo::StringDataView>(
            in_blob_uuid, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null blob_uuid in Element union");
        fragment->data.f_blob_uuid.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::ElementDataView::Tag::kBytes: {
        decltype(Traits::bytes(input))
            in_bytes = Traits::bytes(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_bytes)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
            in_bytes, value_fragment, &bytes_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null bytes in Element union");
        fragment->data.f_bytes.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::ElementDataView::Tag::kFile: {
        decltype(Traits::file(input))
            in_file = Traits::file(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_file)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::FileDataView>(
            in_file, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null file in Element union");
        fragment->data.f_file.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::ElementDataView::Tag::kDeprecatedFileSystemFile: {
        decltype(Traits::DEPRECATED_file_system_file(input))
            in_DEPRECATED_file_system_file = Traits::DEPRECATED_file_system_file(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_DEPRECATED_file_system_file)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::blink::mojom::DEPRECATED_FileSystemFileDataView>(
            in_DEPRECATED_file_system_file, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null DEPRECATED_file_system_file in Element union");
        fragment->data.f_DEPRECATED_file_system_file.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::Element_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ElementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void DEPRECATED_FileSystemFileDataView::GetFilesystemUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->filesystem_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void DEPRECATED_FileSystemFileDataView::GetModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void FileDataView::GetPathDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->path.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FileDataView::GetModificationTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->modification_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void RequestBodyDataView::GetElementsDataView(
    mojo::ArrayDataView<ElementDataView>* output) {
  auto pointer = data_->elements.Get();
  *output = mojo::ArrayDataView<ElementDataView>(pointer, message_);
}


inline void HttpBodyDataView::GetHttpContentTypeDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->http_content_type.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void HttpBodyDataView::GetRequestBodyDataView(
    RequestBodyDataView* output) {
  auto pointer = data_->request_body.Get();
  *output = RequestBodyDataView(pointer, message_);
}


inline void ViewStateDataView::GetVisualViewportScrollOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->visual_viewport_scroll_offset.Get();
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}
inline void ViewStateDataView::GetScrollOffsetDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->scroll_offset.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void ViewStateDataView::GetScrollAnchorSelectorDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->scroll_anchor_selector.Get() : nullptr;
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ViewStateDataView::GetScrollAnchorOffsetDataView(
    ::gfx::mojom::PointFDataView* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->scroll_anchor_offset.Get() : nullptr;
  *output = ::gfx::mojom::PointFDataView(pointer, message_);
}


inline void FrameStateDataView::GetUrlStringDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->url_string.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FrameStateDataView::GetReferrerDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FrameStateDataView::GetTargetDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->target.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FrameStateDataView::GetStateObjectDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->state_object.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FrameStateDataView::GetDocumentStateDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->document_state.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void FrameStateDataView::GetViewStateDataView(
    ViewStateDataView* output) {
  auto pointer = data_->view_state.Get();
  *output = ViewStateDataView(pointer, message_);
}
inline void FrameStateDataView::GetHttpBodyDataView(
    HttpBodyDataView* output) {
  auto pointer = data_->http_body.Get();
  *output = HttpBodyDataView(pointer, message_);
}
inline void FrameStateDataView::GetChildrenDataView(
    mojo::ArrayDataView<FrameStateDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<FrameStateDataView>(pointer, message_);
}
inline void FrameStateDataView::GetInitiatorOriginDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_.version >= 2
                 ? data_->initiator_origin.Get() : nullptr;
  *output = mojo::StringDataView(pointer, message_);
}
inline void FrameStateDataView::GetNavigationApiKeyDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_.version >= 3
                 ? data_->navigation_api_key.Get() : nullptr;
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FrameStateDataView::GetNavigationApiIdDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_.version >= 3
                 ? data_->navigation_api_id.Get() : nullptr;
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FrameStateDataView::GetNavigationApiStateDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_.version >= 4
                 ? data_->navigation_api_state.Get() : nullptr;
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void FrameStateDataView::GetInitiatorBaseUrlStringDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->header_.version >= 6
                 ? data_->initiator_base_url_string.Get() : nullptr;
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void PageStateDataView::GetReferencedFilesDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->referenced_files.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}
inline void PageStateDataView::GetTopDataView(
    FrameStateDataView* output) {
  auto pointer = data_->top.Get();
  *output = FrameStateDataView(pointer, message_);
}


inline void ElementDataView::GetBlobUuidDataView(
    mojo::StringDataView* output) const {
  CHECK(is_blob_uuid());
  *output = mojo::StringDataView(data_->data.f_blob_uuid.Get(), message_);
}
inline void ElementDataView::GetBytesDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_bytes());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_bytes.Get(), message_);
}
inline void ElementDataView::GetFileDataView(
    FileDataView* output) const {
  CHECK(is_file());
  *output = FileDataView(data_->data.f_file.Get(), message_);
}
inline void ElementDataView::GetDeprecatedFileSystemFileDataView(
    DEPRECATED_FileSystemFileDataView* output) const {
  CHECK(is_DEPRECATED_file_system_file());
  *output = DEPRECATED_FileSystemFileDataView(data_->data.f_DEPRECATED_file_system_file.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) TraceFormatTraits<::blink::mojom::ScrollRestorationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::blink::mojom::ScrollRestorationType value);
};

} // namespace perfetto

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_STATE_PAGE_STATE_MOJOM_SHARED_H_