// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/no_vary_search.mojom.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class SpeculationHostProxy;

template <typename ImplRefTraits>
class SpeculationHostStub;

class SpeculationHostRequestValidator;


class BLINK_COMMON_EXPORT SpeculationHost
    : public SpeculationHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeculationHostInterfaceBase;
  using Proxy_ = SpeculationHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeculationHostStub<ImplRefTraits>;

  using RequestValidator_ = SpeculationHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateSpeculationCandidatesMinVersion = 0,
    kOnLCPPredictedMinVersion = 0,
    kInitiatePreviewMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateSpeculationCandidates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLCPPredicted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitiatePreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeculationHost() = default;

  
  virtual void UpdateSpeculationCandidates(std::vector<SpeculationCandidatePtr> candidates) = 0;

  
  virtual void OnLCPPredicted() = 0;

  
  virtual void InitiatePreview(const ::GURL& url) = 0;
};



class BLINK_COMMON_EXPORT SpeculationHostProxy
    : public SpeculationHost {
 public:
  using InterfaceType = SpeculationHost;

  explicit SpeculationHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateSpeculationCandidates(std::vector<SpeculationCandidatePtr> candidates) final;
  
  void OnLCPPredicted() final;
  
  void InitiatePreview(const ::GURL& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT SpeculationHostStubDispatch {
 public:
  static bool Accept(SpeculationHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeculationHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeculationHost>>
class SpeculationHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeculationHostStub() = default;
  ~SpeculationHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeculationHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeculationHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT SpeculationHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT SpeculationCandidate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeculationCandidate, T>::value>;
  using DataView = SpeculationCandidateDataView;
  using Data_ = internal::SpeculationCandidate_Data;

  template <typename... Args>
  static SpeculationCandidatePtr New(Args&&... args) {
    return SpeculationCandidatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeculationCandidatePtr From(const U& u) {
    return mojo::TypeConverter<SpeculationCandidatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeculationCandidate>::Convert(*this);
  }


  SpeculationCandidate();

  SpeculationCandidate(
      const ::GURL& url,
      SpeculationAction action,
      ::blink::mojom::ReferrerPtr referrer,
      bool requires_anonymous_client_ip_when_cross_origin,
      SpeculationTargetHint target_browsing_context_name_hint,
      SpeculationEagerness eagerness,
      ::network::mojom::NoVarySearchPtr no_vary_search_hint,
      SpeculationInjectionType injection_type);

SpeculationCandidate(const SpeculationCandidate&) = delete;
SpeculationCandidate& operator=(const SpeculationCandidate&) = delete;

  ~SpeculationCandidate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeculationCandidatePtr>
  SpeculationCandidatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeculationCandidate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeculationCandidate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeculationCandidate_UnserializedMessageContext<
            UserType, SpeculationCandidate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeculationCandidate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeculationCandidate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeculationCandidate_UnserializedMessageContext<
            UserType, SpeculationCandidate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeculationCandidate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  SpeculationAction action;
  
  ::blink::mojom::ReferrerPtr referrer;
  
  bool requires_anonymous_client_ip_when_cross_origin;
  
  SpeculationTargetHint target_browsing_context_name_hint;
  
  SpeculationEagerness eagerness;
  
  ::network::mojom::NoVarySearchPtr no_vary_search_hint;
  
  SpeculationInjectionType injection_type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpeculationCandidatePtr SpeculationCandidate::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(action),
      mojo::Clone(referrer),
      mojo::Clone(requires_anonymous_client_ip_when_cross_origin),
      mojo::Clone(target_browsing_context_name_hint),
      mojo::Clone(eagerness),
      mojo::Clone(no_vary_search_hint),
      mojo::Clone(injection_type)
  );
}

template <typename T, SpeculationCandidate::EnableIfSame<T>*>
bool SpeculationCandidate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->requires_anonymous_client_ip_when_cross_origin, other_struct.requires_anonymous_client_ip_when_cross_origin))
    return false;
  if (!mojo::Equals(this->target_browsing_context_name_hint, other_struct.target_browsing_context_name_hint))
    return false;
  if (!mojo::Equals(this->eagerness, other_struct.eagerness))
    return false;
  if (!mojo::Equals(this->no_vary_search_hint, other_struct.no_vary_search_hint))
    return false;
  if (!mojo::Equals(this->injection_type, other_struct.injection_type))
    return false;
  return true;
}

template <typename T, SpeculationCandidate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.requires_anonymous_client_ip_when_cross_origin < rhs.requires_anonymous_client_ip_when_cross_origin)
    return true;
  if (rhs.requires_anonymous_client_ip_when_cross_origin < lhs.requires_anonymous_client_ip_when_cross_origin)
    return false;
  if (lhs.target_browsing_context_name_hint < rhs.target_browsing_context_name_hint)
    return true;
  if (rhs.target_browsing_context_name_hint < lhs.target_browsing_context_name_hint)
    return false;
  if (lhs.eagerness < rhs.eagerness)
    return true;
  if (rhs.eagerness < lhs.eagerness)
    return false;
  if (lhs.no_vary_search_hint < rhs.no_vary_search_hint)
    return true;
  if (rhs.no_vary_search_hint < lhs.no_vary_search_hint)
    return false;
  if (lhs.injection_type < rhs.injection_type)
    return true;
  if (rhs.injection_type < lhs.injection_type)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::SpeculationCandidate::DataView,
                                         ::blink::mojom::SpeculationCandidatePtr> {
  static bool IsNull(const ::blink::mojom::SpeculationCandidatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::SpeculationCandidatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::SpeculationCandidate::url)& url(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::SpeculationCandidate::action) action(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->action;
  }

  static const decltype(::blink::mojom::SpeculationCandidate::referrer)& referrer(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->referrer;
  }

  static decltype(::blink::mojom::SpeculationCandidate::requires_anonymous_client_ip_when_cross_origin) requires_anonymous_client_ip_when_cross_origin(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->requires_anonymous_client_ip_when_cross_origin;
  }

  static decltype(::blink::mojom::SpeculationCandidate::target_browsing_context_name_hint) target_browsing_context_name_hint(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->target_browsing_context_name_hint;
  }

  static decltype(::blink::mojom::SpeculationCandidate::eagerness) eagerness(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->eagerness;
  }

  static const decltype(::blink::mojom::SpeculationCandidate::no_vary_search_hint)& no_vary_search_hint(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->no_vary_search_hint;
  }

  static decltype(::blink::mojom::SpeculationCandidate::injection_type) injection_type(
      const ::blink::mojom::SpeculationCandidatePtr& input) {
    return input->injection_type;
  }

  static bool Read(::blink::mojom::SpeculationCandidate::DataView input, ::blink::mojom::SpeculationCandidatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_H_