// ui/gfx/mojom/buffer_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_
#define UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/buffer_types.mojom-shared-internal.h"
#include "ui/gfx/mojom/native_handle_types.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace gfx::mojom {
class BufferUsageAndFormatDataView;

class GpuMemoryBufferIdDataView;

class GpuMemoryBufferHandleDataView;



}  // gfx::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::gfx::mojom::BufferUsageAndFormatDataView> {
  using Data = ::gfx::mojom::internal::BufferUsageAndFormat_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferIdDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::gfx::mojom::GpuMemoryBufferHandleDataView> {
  using Data = ::gfx::mojom::internal::GpuMemoryBufferHandle_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace gfx::mojom {


enum class BufferFormat : int32_t {
  
  R_8 = 0,
  
  R_16 = 1,
  
  RG_88 = 2,
  
  RG_1616 = 3,
  
  BGR_565 = 4,
  
  RGBA_4444 = 5,
  
  RGBX_8888 = 6,
  
  RGBA_8888 = 7,
  
  BGRX_8888 = 8,
  
  BGRA_1010102 = 9,
  
  RGBA_1010102 = 10,
  
  BGRA_8888 = 11,
  
  RGBA_F16 = 12,
  
  YVU_420 = 13,
  
  YUV_420_BIPLANAR = 14,
  
  YUVA_420_TRIPLANAR = 15,
  
  P010 = 16,
  kMinValue = 0,
  kMaxValue = 16,
};

 std::ostream& operator<<(std::ostream& os, BufferFormat value);
inline bool IsKnownEnumValue(BufferFormat value) {
  return internal::BufferFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BufferUsage : int32_t {
  
  GPU_READ = 0,
  
  SCANOUT = 1,
  
  SCANOUT_CAMERA_READ_WRITE = 2,
  
  CAMERA_AND_CPU_READ_WRITE = 3,
  
  SCANOUT_CPU_READ_WRITE = 4,
  
  SCANOUT_VDA_WRITE = 5,
  
  PROTECTED_SCANOUT = 6,
  
  PROTECTED_SCANOUT_VDA_WRITE = 7,
  
  GPU_READ_CPU_READ_WRITE = 8,
  
  SCANOUT_VEA_CPU_READ = 9,
  
  VEA_READ_CAMERA_AND_CPU_READ_WRITE = 10,
  
  SCANOUT_FRONT_RENDERING = 11,
  kMinValue = 0,
  kMaxValue = 11,
};

 std::ostream& operator<<(std::ostream& os, BufferUsage value);
inline bool IsKnownEnumValue(BufferUsage value) {
  return internal::BufferUsage_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class BufferPlane : int32_t {
  
  DEFAULT = 0,
  
  Y = 1,
  
  UV = 2,
  
  U = 3,
  
  V = 4,
  
  A = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, BufferPlane value);
inline bool IsKnownEnumValue(BufferPlane value) {
  return internal::BufferPlane_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class BufferUsageAndFormatDataView {
 public:
  BufferUsageAndFormatDataView() = default;

  BufferUsageAndFormatDataView(
      internal::BufferUsageAndFormat_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadUsage(UserType* output) const {
    auto data_value = data_->usage;
    return mojo::internal::Deserialize<::gfx::mojom::BufferUsage>(
        data_value, output);
  }
  BufferUsage usage() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::BufferUsage>(data_->usage));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFormat(UserType* output) const {
    auto data_value = data_->format;
    return mojo::internal::Deserialize<::gfx::mojom::BufferFormat>(
        data_value, output);
  }
  BufferFormat format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::gfx::mojom::BufferFormat>(data_->format));
  }
 private:
  internal::BufferUsageAndFormat_Data* data_ = nullptr;
};


class GpuMemoryBufferIdDataView {
 public:
  GpuMemoryBufferIdDataView() = default;

  GpuMemoryBufferIdDataView(
      internal::GpuMemoryBufferId_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t id() const {
    return data_->id;
  }
 private:
  internal::GpuMemoryBufferId_Data* data_ = nullptr;
};


class GpuMemoryBufferHandleDataView {
 public:
  GpuMemoryBufferHandleDataView() = default;

  GpuMemoryBufferHandleDataView(
      internal::GpuMemoryBufferHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      GpuMemoryBufferIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        pointer, output, message_);
  }
  uint32_t offset() const {
    return data_->offset;
  }
  uint32_t stride() const {
    return data_->stride;
  }
  inline void GetPlatformHandleDataView(
      ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPlatformHandle(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView, UserType>(),
    "Attempting to read the optional `platform_handle` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPlatformHandle` instead "
    "of `ReadPlatformHandle if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->platform_handle.is_null() ? &data_->platform_handle : nullptr;
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView>(
        pointer, output, message_);
  }
 private:
  internal::GpuMemoryBufferHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // gfx::mojom

namespace std {

template <>
struct hash<::gfx::mojom::BufferFormat>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferFormat> {};

template <>
struct hash<::gfx::mojom::BufferUsage>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferUsage> {};

template <>
struct hash<::gfx::mojom::BufferPlane>
    : public mojo::internal::EnumHashImpl<::gfx::mojom::BufferPlane> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferFormat, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferFormat, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::BufferFormat>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferUsage, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferUsage, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::BufferUsage>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferPlane, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::gfx::mojom::BufferPlane, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::gfx::mojom::BufferPlane>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::BufferUsageAndFormatDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::BufferUsageAndFormatDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::BufferUsageAndFormat_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::gfx::mojom::BufferUsage>(
        Traits::usage(input), &fragment->usage);
    mojo::internal::Serialize<::gfx::mojom::BufferFormat>(
        Traits::format(input), &fragment->format);
  }

  static bool Deserialize(::gfx::mojom::internal::BufferUsageAndFormat_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::BufferUsageAndFormatDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::GpuMemoryBufferId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::gfx::mojom::GpuMemoryBufferHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::GpuMemoryBufferHandleDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::GpuMemoryBufferHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferIdDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in GpuMemoryBufferHandle struct");
    fragment->offset = Traits::offset(input);
    fragment->stride = Traits::stride(input);
    decltype(Traits::platform_handle(input)) in_platform_handle = Traits::platform_handle(input);
    mojo::internal::MessageFragment<decltype(fragment->platform_handle)>
        platform_handle_fragment(fragment.message());
    platform_handle_fragment.Claim(&fragment->platform_handle);
    mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferPlatformHandleDataView>(
        in_platform_handle, platform_handle_fragment, true);
  }

  static bool Deserialize(::gfx::mojom::internal::GpuMemoryBufferHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::gfx::mojom::GpuMemoryBufferHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace gfx::mojom {





inline void GpuMemoryBufferHandleDataView::GetIdDataView(
    GpuMemoryBufferIdDataView* output) {
  auto pointer = data_->id.Get();
  *output = GpuMemoryBufferIdDataView(pointer, message_);
}
inline void GpuMemoryBufferHandleDataView::GetPlatformHandleDataView(
    ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView* output) {
  auto pointer = &data_->platform_handle;
  *output = ::gfx::mojom::GpuMemoryBufferPlatformHandleDataView(pointer, message_);
}



}  // gfx::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::BufferFormat> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::BufferFormat value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::BufferUsage> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::BufferUsage value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::gfx::mojom::BufferPlane> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::gfx::mojom::BufferPlane value);
};

} // namespace perfetto

#endif  // UI_GFX_MOJOM_BUFFER_TYPES_MOJOM_SHARED_H_