/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_cab.h"

#include "librpc/gen_ndr/ndr_misc.h"
static enum ndr_err_code ndr_push_cf_flags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_cf_flags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_cf_flags(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "cfhdrPREV_CABINET", cfhdrPREV_CABINET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "cfhdrNEXT_CABINET", cfhdrNEXT_CABINET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "cfhdrRESERVE_PRESENT", cfhdrRESERVE_PRESENT, r);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_CFHEADER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CFHEADER *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "MSCF", 4, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbCabinet));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cFolders * 8 + 36));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 3));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 1));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->cFolders));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->cFiles));
			NDR_CHECK(ndr_push_cf_flags(ndr, NDR_SCALARS, r->flags));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->setID));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->iCabinet));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CFHEADER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CFHEADER *r)
{
	uint32_t size_signature_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			size_signature_0 = 4;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->signature, size_signature_0, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved1));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbCabinet));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved2));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->coffFiles));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->reserved3));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->versionMinor));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->versionMajor));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->cFolders));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->cFiles));
			NDR_CHECK(ndr_pull_cf_flags(ndr, NDR_SCALARS, &r->flags));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->setID));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->iCabinet));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CFHEADER(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CFHEADER *r)
{
	ndr_print_CFHEADER(ndr, name, r);
}

_PUBLIC_ void ndr_print_CFHEADER(struct ndr_print *ndr, const char *name, const struct CFHEADER *r)
{
	ndr_print_struct(ndr, name, "CFHEADER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_string(ndr, "signature", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"MSCF":r->signature);
		ndr_print_uint32(ndr, "reserved1", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved1);
		ndr_print_uint32(ndr, "cbCabinet", r->cbCabinet);
		ndr_print_uint32(ndr, "reserved2", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved2);
		ndr_print_uint32(ndr, "coffFiles", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->cFolders * 8 + 36:r->coffFiles);
		ndr_print_uint32(ndr, "reserved3", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->reserved3);
		ndr_print_uint8(ndr, "versionMinor", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?3:r->versionMinor);
		ndr_print_uint8(ndr, "versionMajor", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->versionMajor);
		ndr_print_uint16(ndr, "cFolders", r->cFolders);
		ndr_print_uint16(ndr, "cFiles", r->cFiles);
		ndr_print_cf_flags(ndr, "flags", r->flags);
		ndr_print_uint16(ndr, "setID", r->setID);
		ndr_print_uint16(ndr, "iCabinet", r->iCabinet);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_cf_compress_type(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum cf_compress_type r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_cf_compress_type(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum cf_compress_type *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_cf_compress_type(struct ndr_print *ndr, const char *name, enum cf_compress_type r)
{
	const char *val = NULL;

	switch (r) {
		case CF_COMPRESS_NONE: val = "CF_COMPRESS_NONE"; break;
		case CF_COMPRESS_MSZIP: val = "CF_COMPRESS_MSZIP"; break;
		case CF_COMPRESS_LZX: val = "CF_COMPRESS_LZX"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_CFFOLDER(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CFFOLDER *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->coffCabStart));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->cCFData));
			NDR_CHECK(ndr_push_cf_compress_type(ndr, NDR_SCALARS, r->typeCompress));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CFFOLDER(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CFFOLDER *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->coffCabStart));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->cCFData));
			NDR_CHECK(ndr_pull_cf_compress_type(ndr, NDR_SCALARS, &r->typeCompress));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CFFOLDER(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CFFOLDER *r)
{
	ndr_print_CFFOLDER(ndr, name, r);
}

_PUBLIC_ void ndr_print_CFFOLDER(struct ndr_print *ndr, const char *name, const struct CFFOLDER *r)
{
	ndr_print_struct(ndr, name, "CFFOLDER");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "coffCabStart", r->coffCabStart);
		ndr_print_uint16(ndr, "cCFData", r->cCFData);
		ndr_print_cf_compress_type(ndr, "typeCompress", r->typeCompress);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_cf_attributes(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint16_t r)
{
	NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_cf_attributes(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint16_t *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_cf_attributes(struct ndr_print *ndr, const char *name, uint16_t r)
{
	ndr_print_uint16(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "_A_RDONLY", _A_RDONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "_A_HIDDEN", _A_HIDDEN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "_A_SYSTEM", _A_SYSTEM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "_A_ARCH", _A_ARCH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "_A_EXEC", _A_EXEC, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint16_t), "_A_NAME_IS_UTF", _A_NAME_IS_UTF, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_cf_date(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct cf_date *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 2));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->date));
			NDR_CHECK(ndr_push_trailer_align(ndr, 2));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_cf_date(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct cf_date *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 2));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->date));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_push_cf_time(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct cf_time *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 2));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->time));
			NDR_CHECK(ndr_push_trailer_align(ndr, 2));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_cf_time(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct cf_time *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 2));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->time));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push_CFFILE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CFFILE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->cbFile));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->uoffFolderStart));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->iFolder));
			NDR_CHECK(ndr_push_cf_date(ndr, NDR_SCALARS, &r->date));
			NDR_CHECK(ndr_push_cf_time(ndr, NDR_SCALARS, &r->time));
			NDR_CHECK(ndr_push_cf_attributes(ndr, NDR_SCALARS, r->attribs));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, r->attribs&_A_NAME_IS_UTF?LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM:LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
				NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->szName));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CFFILE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CFFILE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->cbFile));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->uoffFolderStart));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->iFolder));
			NDR_CHECK(ndr_pull_cf_date(ndr, NDR_SCALARS, &r->date));
			NDR_CHECK(ndr_pull_cf_time(ndr, NDR_SCALARS, &r->time));
			NDR_CHECK(ndr_pull_cf_attributes(ndr, NDR_SCALARS, &r->attribs));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, r->attribs&_A_NAME_IS_UTF?LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM:LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
				NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->szName));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CFFILE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CFFILE *r)
{
	ndr_print_CFFILE(ndr, name, r);
}

_PUBLIC_ void ndr_print_CFFILE(struct ndr_print *ndr, const char *name, const struct CFFILE *r)
{
	ndr_print_struct(ndr, name, "CFFILE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "cbFile", r->cbFile);
		ndr_print_uint32(ndr, "uoffFolderStart", r->uoffFolderStart);
		ndr_print_uint16(ndr, "iFolder", r->iFolder);
		ndr_print_cf_date(ndr, "date", &r->date);
		ndr_print_cf_time(ndr, "time", &r->time);
		ndr_print_cf_attributes(ndr, "attribs", r->attribs);
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, r->attribs&_A_NAME_IS_UTF?LIBNDR_FLAG_STR_UTF8|LIBNDR_FLAG_STR_NULLTERM:LIBNDR_FLAG_STR_ASCII|LIBNDR_FLAG_STR_NULLTERM);
			ndr_print_string(ndr, "szName", r->szName);
			ndr->flags = _flags_save_string;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ size_t ndr_size_CFFILE(const struct CFFILE *r, libndr_flags flags)
{
	flags |= LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN;
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_CFFILE);
}

_PUBLIC_ void ndr_print_CFDATA(struct ndr_print *ndr, const char *name, const struct CFDATA *r)
{
	ndr_print_struct(ndr, name, "CFDATA");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "csum", r->csum);
		ndr_print_uint16(ndr, "cbData", r->cbData);
		ndr_print_uint16(ndr, "cbUncomp", r->cbUncomp);
		ndr_print_DATA_BLOB(ndr, "ab", r->ab);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static void ndr_print_flags_cab_file(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct cab_file *r)
{
	ndr_print_cab_file(ndr, name, r);
}

_PUBLIC_ void ndr_print_cab_file(struct ndr_print *ndr, const char *name, const struct cab_file *r)
{
	uint32_t cntr_cffolders_0;
	uint32_t cntr_cffiles_0;
	uint32_t cntr_cfdata_0;
	ndr_print_struct(ndr, name, "cab_file");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX|LIBNDR_FLAG_LITTLE_ENDIAN|LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_CFHEADER(ndr, "cfheader", &r->cfheader);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "cffolders", (uint32_t)(r->cfheader.cFolders));
		ndr->depth++;
		for (cntr_cffolders_0 = 0; cntr_cffolders_0 < (r->cfheader.cFolders); cntr_cffolders_0++) {
			ndr_print_CFFOLDER(ndr, "cffolders", &r->cffolders[cntr_cffolders_0]);
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "cffiles", (uint32_t)(r->cfheader.cFiles));
		ndr->depth++;
		for (cntr_cffiles_0 = 0; cntr_cffiles_0 < (r->cfheader.cFiles); cntr_cffiles_0++) {
			ndr_print_CFFILE(ndr, "cffiles", &r->cffiles[cntr_cffiles_0]);
		}
		ndr->depth--;
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "cfdata", (uint32_t)(r->cfdata_count));
		ndr->depth++;
		for (cntr_cfdata_0 = 0; cntr_cfdata_0 < (r->cfdata_count); cntr_cfdata_0++) {
			ndr_print_CFDATA(ndr, "cfdata", &r->cfdata[cntr_cfdata_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_cab
static const struct ndr_interface_public_struct cab_public_structs[] = {
	{
		.name = "CFHEADER",
		.struct_size = sizeof(struct CFHEADER ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CFHEADER,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CFHEADER,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CFHEADER,
	},
	{
		.name = "CFFOLDER",
		.struct_size = sizeof(struct CFFOLDER ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CFFOLDER,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CFFOLDER,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CFFOLDER,
	},
	{
		.name = "CFFILE",
		.struct_size = sizeof(struct CFFILE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CFFILE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CFFILE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CFFILE,
	},
	{
		.name = "cab_file",
		.struct_size = sizeof(struct cab_file ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_cab_file,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_cab_file,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_cab_file,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call cab_calls[] = {
	{ .name = NULL }
};

static const char * const cab_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\cab]", 
};

static const struct ndr_interface_string_array cab_endpoints = {
	.count	= 1,
	.names	= cab_endpoint_strings
};

static const char * const cab_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array cab_authservices = {
	.count	= 1,
	.names	= cab_authservice_strings
};


const struct ndr_interface_table ndr_table_cab = {
	.name		= "cab",
	.syntax_id	= {
		{0x12345678,0x0000,0x0000,{0x00,0x00},{0x00,0x00,0x00,0x00}},
		NDR_CAB_VERSION
	},
	.helpstring	= NDR_CAB_HELPSTRING,
	.num_calls	= 0,
	.calls		= cab_calls,
	.num_public_structs	= 4,
	.public_structs		= cab_public_structs,
	.endpoints	= &cab_endpoints,
	.authservices	= &cab_authservices
};

#endif /* SKIP_NDR_TABLE_cab */
