// python wrapper for ttkMorseSmaleComplex
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMorseSmaleComplex.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMorseSmaleComplex(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMorseSmaleComplex_ClassNew(); }


static PyObject *
PyttkMorseSmaleComplex_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMorseSmaleComplex::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMorseSmaleComplex::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMorseSmaleComplex *tempr = ttkMorseSmaleComplex::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMorseSmaleComplex *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMorseSmaleComplex::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMorseSmaleComplex::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMorseSmaleComplex::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkMorseSmaleComplex::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeCriticalPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeCriticalPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeCriticalPoints(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeCriticalPoints(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeCriticalPoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeCriticalPoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeCriticalPoints() :
      op->ttkMorseSmaleComplex::GetComputeCriticalPoints());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeAscendingSeparatrices1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeAscendingSeparatrices1(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeAscendingSeparatrices1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeAscendingSeparatrices1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeAscendingSeparatrices1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeAscendingSeparatrices1() :
      op->ttkMorseSmaleComplex::GetComputeAscendingSeparatrices1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeDescendingSeparatrices1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeDescendingSeparatrices1(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeDescendingSeparatrices1(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeDescendingSeparatrices1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeDescendingSeparatrices1");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeDescendingSeparatrices1() :
      op->ttkMorseSmaleComplex::GetComputeDescendingSeparatrices1());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeSaddleConnectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeSaddleConnectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeSaddleConnectors(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeSaddleConnectors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeSaddleConnectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeSaddleConnectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeSaddleConnectors() :
      op->ttkMorseSmaleComplex::GetComputeSaddleConnectors());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeAscendingSeparatrices2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeAscendingSeparatrices2(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeAscendingSeparatrices2(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeAscendingSeparatrices2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeAscendingSeparatrices2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeAscendingSeparatrices2() :
      op->ttkMorseSmaleComplex::GetComputeAscendingSeparatrices2());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeDescendingSeparatrices2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeDescendingSeparatrices2(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeDescendingSeparatrices2(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeDescendingSeparatrices2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeDescendingSeparatrices2");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeDescendingSeparatrices2() :
      op->ttkMorseSmaleComplex::GetComputeDescendingSeparatrices2());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeAscendingSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeAscendingSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeAscendingSegmentation(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeAscendingSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeAscendingSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeAscendingSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeAscendingSegmentation() :
      op->ttkMorseSmaleComplex::GetComputeAscendingSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeDescendingSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeDescendingSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeDescendingSegmentation(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeDescendingSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeDescendingSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeDescendingSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeDescendingSegmentation() :
      op->ttkMorseSmaleComplex::GetComputeDescendingSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetComputeFinalSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetComputeFinalSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetComputeFinalSegmentation(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetComputeFinalSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetComputeFinalSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetComputeFinalSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetComputeFinalSegmentation() :
      op->ttkMorseSmaleComplex::GetComputeFinalSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetIterationThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIterationThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIterationThreshold(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetIterationThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetIterationThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIterationThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetIterationThreshold() :
      op->ttkMorseSmaleComplex::GetIterationThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetReturnSaddleConnectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetReturnSaddleConnectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetReturnSaddleConnectors(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetReturnSaddleConnectors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetReturnSaddleConnectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReturnSaddleConnectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetReturnSaddleConnectors() :
      op->ttkMorseSmaleComplex::GetReturnSaddleConnectors());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetSaddleConnectorsPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSaddleConnectorsPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSaddleConnectorsPersistenceThreshold(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetSaddleConnectorsPersistenceThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetSaddleConnectorsPersistenceThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSaddleConnectorsPersistenceThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetSaddleConnectorsPersistenceThreshold() :
      op->ttkMorseSmaleComplex::GetSaddleConnectorsPersistenceThreshold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetThresholdIsAbsolute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetThresholdIsAbsolute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetThresholdIsAbsolute(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetThresholdIsAbsolute(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetThresholdIsAbsolute(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetThresholdIsAbsolute");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetThresholdIsAbsolute() :
      op->ttkMorseSmaleComplex::GetThresholdIsAbsolute());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_SetForceLoopFreeGradient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceLoopFreeGradient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceLoopFreeGradient(temp0);
    }
    else
    {
      op->ttkMorseSmaleComplex::SetForceLoopFreeGradient(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMorseSmaleComplex_GetForceLoopFreeGradient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceLoopFreeGradient");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMorseSmaleComplex *op = static_cast<ttkMorseSmaleComplex *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceLoopFreeGradient() :
      op->ttkMorseSmaleComplex::GetForceLoopFreeGradient());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMorseSmaleComplex_Methods[] = {
  {"IsTypeOf", PyttkMorseSmaleComplex_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMorseSmaleComplex_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMorseSmaleComplex_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMorseSmaleComplex\nC++: static ttkMorseSmaleComplex *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMorseSmaleComplex_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMorseSmaleComplex\nC++: ttkMorseSmaleComplex *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMorseSmaleComplex_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMorseSmaleComplex_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetForceInputOffsetScalarField", PyttkMorseSmaleComplex_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"GetForceInputOffsetScalarField", PyttkMorseSmaleComplex_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetComputeCriticalPoints", PyttkMorseSmaleComplex_SetComputeCriticalPoints, METH_VARARGS,
   "SetComputeCriticalPoints(self, _arg:bool) -> None\nC++: virtual void SetComputeCriticalPoints(bool _arg)\n\n"},
  {"GetComputeCriticalPoints", PyttkMorseSmaleComplex_GetComputeCriticalPoints, METH_VARARGS,
   "GetComputeCriticalPoints(self) -> bool\nC++: virtual bool GetComputeCriticalPoints()\n\n"},
  {"SetComputeAscendingSeparatrices1", PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices1, METH_VARARGS,
   "SetComputeAscendingSeparatrices1(self, _arg:bool) -> None\nC++: virtual void SetComputeAscendingSeparatrices1(bool _arg)\n\n"},
  {"GetComputeAscendingSeparatrices1", PyttkMorseSmaleComplex_GetComputeAscendingSeparatrices1, METH_VARARGS,
   "GetComputeAscendingSeparatrices1(self) -> bool\nC++: virtual bool GetComputeAscendingSeparatrices1()\n\n"},
  {"SetComputeDescendingSeparatrices1", PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices1, METH_VARARGS,
   "SetComputeDescendingSeparatrices1(self, _arg:bool) -> None\nC++: virtual void SetComputeDescendingSeparatrices1(bool _arg)\n\n"},
  {"GetComputeDescendingSeparatrices1", PyttkMorseSmaleComplex_GetComputeDescendingSeparatrices1, METH_VARARGS,
   "GetComputeDescendingSeparatrices1(self) -> bool\nC++: virtual bool GetComputeDescendingSeparatrices1()\n\n"},
  {"SetComputeSaddleConnectors", PyttkMorseSmaleComplex_SetComputeSaddleConnectors, METH_VARARGS,
   "SetComputeSaddleConnectors(self, _arg:bool) -> None\nC++: virtual void SetComputeSaddleConnectors(bool _arg)\n\n"},
  {"GetComputeSaddleConnectors", PyttkMorseSmaleComplex_GetComputeSaddleConnectors, METH_VARARGS,
   "GetComputeSaddleConnectors(self) -> bool\nC++: virtual bool GetComputeSaddleConnectors()\n\n"},
  {"SetComputeAscendingSeparatrices2", PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices2, METH_VARARGS,
   "SetComputeAscendingSeparatrices2(self, _arg:bool) -> None\nC++: virtual void SetComputeAscendingSeparatrices2(bool _arg)\n\n"},
  {"GetComputeAscendingSeparatrices2", PyttkMorseSmaleComplex_GetComputeAscendingSeparatrices2, METH_VARARGS,
   "GetComputeAscendingSeparatrices2(self) -> bool\nC++: virtual bool GetComputeAscendingSeparatrices2()\n\n"},
  {"SetComputeDescendingSeparatrices2", PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices2, METH_VARARGS,
   "SetComputeDescendingSeparatrices2(self, _arg:bool) -> None\nC++: virtual void SetComputeDescendingSeparatrices2(bool _arg)\n\n"},
  {"GetComputeDescendingSeparatrices2", PyttkMorseSmaleComplex_GetComputeDescendingSeparatrices2, METH_VARARGS,
   "GetComputeDescendingSeparatrices2(self) -> bool\nC++: virtual bool GetComputeDescendingSeparatrices2()\n\n"},
  {"SetComputeAscendingSegmentation", PyttkMorseSmaleComplex_SetComputeAscendingSegmentation, METH_VARARGS,
   "SetComputeAscendingSegmentation(self, _arg:bool) -> None\nC++: virtual void SetComputeAscendingSegmentation(bool _arg)\n\n"},
  {"GetComputeAscendingSegmentation", PyttkMorseSmaleComplex_GetComputeAscendingSegmentation, METH_VARARGS,
   "GetComputeAscendingSegmentation(self) -> bool\nC++: virtual bool GetComputeAscendingSegmentation()\n\n"},
  {"SetComputeDescendingSegmentation", PyttkMorseSmaleComplex_SetComputeDescendingSegmentation, METH_VARARGS,
   "SetComputeDescendingSegmentation(self, _arg:bool) -> None\nC++: virtual void SetComputeDescendingSegmentation(bool _arg)\n\n"},
  {"GetComputeDescendingSegmentation", PyttkMorseSmaleComplex_GetComputeDescendingSegmentation, METH_VARARGS,
   "GetComputeDescendingSegmentation(self) -> bool\nC++: virtual bool GetComputeDescendingSegmentation()\n\n"},
  {"SetComputeFinalSegmentation", PyttkMorseSmaleComplex_SetComputeFinalSegmentation, METH_VARARGS,
   "SetComputeFinalSegmentation(self, _arg:bool) -> None\nC++: virtual void SetComputeFinalSegmentation(bool _arg)\n\n"},
  {"GetComputeFinalSegmentation", PyttkMorseSmaleComplex_GetComputeFinalSegmentation, METH_VARARGS,
   "GetComputeFinalSegmentation(self) -> bool\nC++: virtual bool GetComputeFinalSegmentation()\n\n"},
  {"SetIterationThreshold", PyttkMorseSmaleComplex_SetIterationThreshold, METH_VARARGS,
   "SetIterationThreshold(self, _arg:int) -> None\nC++: virtual void SetIterationThreshold(int _arg)\n\n"},
  {"GetIterationThreshold", PyttkMorseSmaleComplex_GetIterationThreshold, METH_VARARGS,
   "GetIterationThreshold(self) -> int\nC++: virtual int GetIterationThreshold()\n\n"},
  {"SetReturnSaddleConnectors", PyttkMorseSmaleComplex_SetReturnSaddleConnectors, METH_VARARGS,
   "SetReturnSaddleConnectors(self, _arg:bool) -> None\nC++: virtual void SetReturnSaddleConnectors(bool _arg)\n\n"},
  {"GetReturnSaddleConnectors", PyttkMorseSmaleComplex_GetReturnSaddleConnectors, METH_VARARGS,
   "GetReturnSaddleConnectors(self) -> bool\nC++: virtual bool GetReturnSaddleConnectors()\n\n"},
  {"SetSaddleConnectorsPersistenceThreshold", PyttkMorseSmaleComplex_SetSaddleConnectorsPersistenceThreshold, METH_VARARGS,
   "SetSaddleConnectorsPersistenceThreshold(self, _arg:float) -> None\nC++: virtual void SetSaddleConnectorsPersistenceThreshold(\n    double _arg)\n\n"},
  {"GetSaddleConnectorsPersistenceThreshold", PyttkMorseSmaleComplex_GetSaddleConnectorsPersistenceThreshold, METH_VARARGS,
   "GetSaddleConnectorsPersistenceThreshold(self) -> float\nC++: virtual double GetSaddleConnectorsPersistenceThreshold()\n\n"},
  {"SetThresholdIsAbsolute", PyttkMorseSmaleComplex_SetThresholdIsAbsolute, METH_VARARGS,
   "SetThresholdIsAbsolute(self, _arg:bool) -> None\nC++: virtual void SetThresholdIsAbsolute(bool _arg)\n\n"},
  {"GetThresholdIsAbsolute", PyttkMorseSmaleComplex_GetThresholdIsAbsolute, METH_VARARGS,
   "GetThresholdIsAbsolute(self) -> bool\nC++: virtual bool GetThresholdIsAbsolute()\n\n"},
  {"SetForceLoopFreeGradient", PyttkMorseSmaleComplex_SetForceLoopFreeGradient, METH_VARARGS,
   "SetForceLoopFreeGradient(self, _arg:bool) -> None\nC++: virtual void SetForceLoopFreeGradient(bool _arg)\n\n"},
  {"GetForceLoopFreeGradient", PyttkMorseSmaleComplex_GetForceLoopFreeGradient, METH_VARARGS,
   "GetForceLoopFreeGradient(self) -> bool\nC++: virtual bool GetForceLoopFreeGradient()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMorseSmaleComplex_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_critical_points"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeCriticalPoints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeCriticalPoints(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeCriticalPoints(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeCriticalPoints/SetComputeCriticalPoints\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_ascending_separatrices1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeAscendingSeparatrices1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeAscendingSeparatrices1/SetComputeAscendingSeparatrices1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_descending_separatrices1"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeDescendingSeparatrices1(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices1(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices1(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeDescendingSeparatrices1/SetComputeDescendingSeparatrices1\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_saddle_connectors"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeSaddleConnectors(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeSaddleConnectors(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeSaddleConnectors(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeSaddleConnectors/SetComputeSaddleConnectors\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_ascending_separatrices2"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeAscendingSeparatrices2(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices2(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeAscendingSeparatrices2(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeAscendingSeparatrices2/SetComputeAscendingSeparatrices2\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_descending_separatrices2"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeDescendingSeparatrices2(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices2(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeDescendingSeparatrices2(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeDescendingSeparatrices2/SetComputeDescendingSeparatrices2\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_ascending_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeAscendingSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeAscendingSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeAscendingSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeAscendingSegmentation/SetComputeAscendingSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_descending_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeDescendingSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeDescendingSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeDescendingSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeDescendingSegmentation/SetComputeDescendingSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("compute_final_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetComputeFinalSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetComputeFinalSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetComputeFinalSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetComputeFinalSegmentation/SetComputeFinalSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("iteration_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetIterationThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetIterationThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetIterationThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIterationThreshold/SetIterationThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("return_saddle_connectors"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetReturnSaddleConnectors(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetReturnSaddleConnectors(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetReturnSaddleConnectors(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetReturnSaddleConnectors/SetReturnSaddleConnectors\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("saddle_connectors_persistence_threshold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetSaddleConnectorsPersistenceThreshold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetSaddleConnectorsPersistenceThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetSaddleConnectorsPersistenceThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSaddleConnectorsPersistenceThreshold/SetSaddleConnectorsPersistenceThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("threshold_is_absolute"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetThresholdIsAbsolute(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetThresholdIsAbsolute(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetThresholdIsAbsolute(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetThresholdIsAbsolute/SetThresholdIsAbsolute\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("force_loop_free_gradient"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMorseSmaleComplex_GetForceLoopFreeGradient(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMorseSmaleComplex_SetForceLoopFreeGradient(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMorseSmaleComplex_SetForceLoopFreeGradient(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceLoopFreeGradient/SetForceLoopFreeGradient\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMorseSmaleComplex_Doc =
  "ttkMorseSmaleComplex - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Guillaume Favelier <guillaume.favelier@lip6.fr>\\author Julien\n"
  "Tierny <julien.tierny@lip6.fr>\\date February 2017.\n\n"
  "TTK VTK-filter that wraps the morseSmaleComplex processing package.\n\n"
  "TTK module for the computation of Morse-Smale complexes. Morse-Smale\n"
  "complexes are useful topological abstractions of scalar fields for\n"
  "data segmentation, feature extraction, etc.\n\n"
  "Related publication\n\n"
  "\"Parallel Computation of 3D Morse-Smale Complexes\"\n\n"
  "Nithin Shivashankar, Vijay Natarajan\n\n"
  "Proc. of EuroVis 2012.\n\n"
  "Computer Graphics Forum, 2012.\n\n"
  "\\param Input Input scalar field, defined as a point data scalar field\n"
  "attached to a geometry, either 2D or 3D, either regular grid or\n"
  "triangulation (vtkDataSet)\n"
  "\\param Output0 Output critical points (vtkPolyData)\n"
  "\\param Output1 Output 1-separatrices (vtkPolyData)\n"
  "\\param Output2 Output 2-separatrices (vtkPolyData)\n"
  "\\param Output3 Output data segmentation (vtkDataSet)\n\n"
  "The input data array needs to be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 0 (FIXED: the first array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the input array)\n\n"
  "The optional offset array can be specified via the standard VTK call\n"
  "vtkAlgorithm::SetInputArrayToProcess() with the following parameters:\n"
  "\\param idx 1 (FIXED: the second array the algorithm requires)\n"
  "\\param port 0 (FIXED: first port)\n"
  "\\param connection 0 (FIXED: first connection)\n"
  "\\param fieldAssociation 0 (FIXED: point data)\n"
  "\\param arrayName (DYNAMIC: string identifier of the offset array)\n\n"
  "ote: To use this optional array, `ForceInputOffsetScalarField` needs\n"
  "to be\n"
  "enabled with the setter `setForceInputOffsetScalarField()'.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "\\sa ttk::MorseSmaleComplex\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearning/\"\n"
  "  >1-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/1manifoldLearningCircles/\"\n"
  "  >1-Manifold Learning Circles example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/2manifoldLearning/\"\n"
  "  > 2-Manifold Learning example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/imageProcessing/\"\n"
  "  >Image Processing example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/karhunenLoveDigits64Dimensions/\"\n"
  "  >Karhunen-Love Digits 64-Dimensions example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morseMolecule/\">M\n"
  "  orse molecule example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morsePersistence/\"\n"
  "  >Morse Persistence example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/morseSmaleQuadrangulation/\"\n"
  "  >Morse-Smale Quadrangulation example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering0/\"\n"
  "  >Persistence clustering 0 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering1/\"\n"
  "  >Persistence clustering 1 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering2/\"\n"
  "  >Persistence clustering 2 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering3/\"\n"
  "  >Persistence clustering 3 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistenceClustering4/\"\n"
  "  >Persistence clustering 4 example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_at/\"\n"
  "  >Persistent Generators AT example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/persistentGenerators_darkSky/\"\n"
  "  >Persistent Generators DarkSky example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/tectonicPuzzle/\">\n"
  "  Tectonic Puzzle example\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/topologicalOptimization_darkSky/\"\n"
  "  >Topological Optimization DarkSky\\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/tribute/\">Tribute\n"
  "   example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMorseSmaleComplex_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMorseSmaleComplex.ttkMorseSmaleComplex", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMorseSmaleComplex_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMorseSmaleComplex_StaticNew()
{
  return ttkMorseSmaleComplex::New();
}

PyObject *PyttkMorseSmaleComplex_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMorseSmaleComplex_Type, PyttkMorseSmaleComplex_Methods,
    "ttkMorseSmaleComplex",
 &PyttkMorseSmaleComplex_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMorseSmaleComplex_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMorseSmaleComplex(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMorseSmaleComplex_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMorseSmaleComplex", o) != 0)
  {
    Py_DECREF(o);
  }

}

