// python wrapper for ttkMeshGraph
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkMeshGraph.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkMeshGraph(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkMeshGraph_ClassNew(); }


static PyObject *
PyttkMeshGraph_SetSizeAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSizeAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSizeAxis(temp0);
    }
    else
    {
      op->ttkMeshGraph::SetSizeAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_GetSizeAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSizeAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSizeAxis() :
      op->ttkMeshGraph::GetSizeAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_SetSizeScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSizeScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  float temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSizeScale(temp0);
    }
    else
    {
      op->ttkMeshGraph::SetSizeScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_GetSizeScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSizeScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    float tempr = (ap.IsBound() ?
      op->GetSizeScale() :
      op->ttkMeshGraph::GetSizeScale());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_SetUseQuadraticCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseQuadraticCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseQuadraticCells(temp0);
    }
    else
    {
      op->ttkMeshGraph::SetUseQuadraticCells(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_GetUseQuadraticCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseQuadraticCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseQuadraticCells() :
      op->ttkMeshGraph::GetUseQuadraticCells());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_SetSubdivisions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSubdivisions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSubdivisions(temp0);
    }
    else
    {
      op->ttkMeshGraph::SetSubdivisions(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_GetSubdivisions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSubdivisions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSubdivisions() :
      op->ttkMeshGraph::GetSubdivisions());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkMeshGraph::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkMeshGraph::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkMeshGraph *tempr = ttkMeshGraph::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkMeshGraph *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkMeshGraph::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkMeshGraph::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkMeshGraph_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkMeshGraph *op = static_cast<ttkMeshGraph *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkMeshGraph::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkMeshGraph_Methods[] = {
  {"SetSizeAxis", PyttkMeshGraph_SetSizeAxis, METH_VARARGS,
   "SetSizeAxis(self, _arg:int) -> None\nC++: virtual void SetSizeAxis(int _arg)\n\n"},
  {"GetSizeAxis", PyttkMeshGraph_GetSizeAxis, METH_VARARGS,
   "GetSizeAxis(self) -> int\nC++: virtual int GetSizeAxis()\n\n"},
  {"SetSizeScale", PyttkMeshGraph_SetSizeScale, METH_VARARGS,
   "SetSizeScale(self, _arg:float) -> None\nC++: virtual void SetSizeScale(float _arg)\n\n"},
  {"GetSizeScale", PyttkMeshGraph_GetSizeScale, METH_VARARGS,
   "GetSizeScale(self) -> float\nC++: virtual float GetSizeScale()\n\n"},
  {"SetUseQuadraticCells", PyttkMeshGraph_SetUseQuadraticCells, METH_VARARGS,
   "SetUseQuadraticCells(self, _arg:bool) -> None\nC++: virtual void SetUseQuadraticCells(bool _arg)\n\n"},
  {"GetUseQuadraticCells", PyttkMeshGraph_GetUseQuadraticCells, METH_VARARGS,
   "GetUseQuadraticCells(self) -> bool\nC++: virtual bool GetUseQuadraticCells()\n\n"},
  {"SetSubdivisions", PyttkMeshGraph_SetSubdivisions, METH_VARARGS,
   "SetSubdivisions(self, _arg:int) -> None\nC++: virtual void SetSubdivisions(int _arg)\n\n"},
  {"GetSubdivisions", PyttkMeshGraph_GetSubdivisions, METH_VARARGS,
   "GetSubdivisions(self) -> int\nC++: virtual int GetSubdivisions()\n\n"},
  {"IsTypeOf", PyttkMeshGraph_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkMeshGraph_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkMeshGraph_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkMeshGraph\nC++: static ttkMeshGraph *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkMeshGraph_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkMeshGraph\nC++: ttkMeshGraph *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkMeshGraph_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkMeshGraph_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkMeshGraph_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("size_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMeshGraph_GetSizeAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMeshGraph_SetSizeAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMeshGraph_SetSizeAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSizeAxis/SetSizeAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("size_scale"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMeshGraph_GetSizeScale(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMeshGraph_SetSizeScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMeshGraph_SetSizeScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSizeScale/SetSizeScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_quadratic_cells"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMeshGraph_GetUseQuadraticCells(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMeshGraph_SetUseQuadraticCells(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMeshGraph_SetUseQuadraticCells(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseQuadraticCells/SetUseQuadraticCells\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("subdivisions"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkMeshGraph_GetSubdivisions(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkMeshGraph_SetSubdivisions(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkMeshGraph_SetSubdivisions(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSubdivisions/SetSubdivisions\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkMeshGraph_Doc =
  "ttkMeshGraph - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk (jl@jluk.de)\\date 01.12.2018\n\n"
  "TTK VTK-filter that generates a mesh for a graph.\n\n"
  "This filter generates for each one dimensional cell (edge) of a\n"
  "'vtkUnstructuredGrid' a two dimensional cell by mapping a size value\n"
  "to the width of the input cell. The output is a 'vtkUnstructuredGrid'\n"
  "consisting of a set of either quadratic quads or linear polygons.\n\n"
  "VTK wrapping code for the ttk::MeshGraph package.\n\n"
  "\\param Input Graph (vtkUnstructuredGrid)\n"
  "\\param Output Graph (vtkUnstructuredGrid)\n\n"
  "\\sa ttk::MeshGraph\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/nestedTrackingFromOverlap/\"\n"
  "  >Nested Tracking from Overlap example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkMeshGraph_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkMeshGraph.ttkMeshGraph", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkMeshGraph_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkMeshGraph_StaticNew()
{
  return ttkMeshGraph::New();
}

PyObject *PyttkMeshGraph_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkMeshGraph_Type, PyttkMeshGraph_Methods,
    "ttkMeshGraph",
 &PyttkMeshGraph_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkMeshGraph_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkMeshGraph(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkMeshGraph_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkMeshGraph", o) != 0)
  {
    Py_DECREF(o);
  }

}

