// python wrapper for ttkReebGraph
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkReebGraph.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkReebGraph(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkReebGraph_ClassNew(); }


static PyObject *
PyttkReebGraph_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkReebGraph::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkReebGraph::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkReebGraph *tempr = ttkReebGraph::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkReebGraph *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkReebGraph::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkReebGraph::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkReebGraph::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_SetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetForceInputOffsetScalarField(temp0);
    }
    else
    {
      op->ttkReebGraph::SetForceInputOffsetScalarField(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_GetForceInputOffsetScalarField(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetForceInputOffsetScalarField");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetForceInputOffsetScalarField() :
      op->ttkReebGraph::GetForceInputOffsetScalarField());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_SetSingleSweep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSingleSweep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSingleSweep(temp0);
    }
    else
    {
      op->ttkReebGraph::SetSingleSweep(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_GetSingleSweep(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSingleSweep");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSingleSweep() :
      op->ttkReebGraph::GetSingleSweep());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_SetWithSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithSegmentation(temp0);
    }
    else
    {
      op->ttkReebGraph::SetWithSegmentation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_GetWithSegmentation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithSegmentation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithSegmentation() :
      op->ttkReebGraph::GetWithSegmentation());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_SetWithNormalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWithNormalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWithNormalize(temp0);
    }
    else
    {
      op->ttkReebGraph::SetWithNormalize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_GetWithNormalize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWithNormalize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWithNormalize() :
      op->ttkReebGraph::GetWithNormalize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_SetSampling(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSampling");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSampling(temp0);
    }
    else
    {
      op->ttkReebGraph::SetSampling(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkReebGraph_GetSuperArcSamplingLevel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSuperArcSamplingLevel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkReebGraph *op = static_cast<ttkReebGraph *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSuperArcSamplingLevel() :
      op->ttkReebGraph::GetSuperArcSamplingLevel());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkReebGraph_Methods[] = {
  {"IsTypeOf", PyttkReebGraph_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkReebGraph_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkReebGraph_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkReebGraph\nC++: static ttkReebGraph *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkReebGraph_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkReebGraph\nC++: ttkReebGraph *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkReebGraph_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkReebGraph_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetForceInputOffsetScalarField", PyttkReebGraph_SetForceInputOffsetScalarField, METH_VARARGS,
   "SetForceInputOffsetScalarField(self, _arg:bool) -> None\nC++: virtual void SetForceInputOffsetScalarField(bool _arg)\n\n"},
  {"GetForceInputOffsetScalarField", PyttkReebGraph_GetForceInputOffsetScalarField, METH_VARARGS,
   "GetForceInputOffsetScalarField(self) -> bool\nC++: virtual bool GetForceInputOffsetScalarField()\n\n"},
  {"SetSingleSweep", PyttkReebGraph_SetSingleSweep, METH_VARARGS,
   "SetSingleSweep(self, ss:bool) -> None\nC++: void SetSingleSweep(const bool ss)\n\n"},
  {"GetSingleSweep", PyttkReebGraph_GetSingleSweep, METH_VARARGS,
   "GetSingleSweep(self) -> bool\nC++: bool GetSingleSweep()\n\n"},
  {"SetWithSegmentation", PyttkReebGraph_SetWithSegmentation, METH_VARARGS,
   "SetWithSegmentation(self, segm:bool) -> None\nC++: void SetWithSegmentation(const bool segm)\n\n"},
  {"GetWithSegmentation", PyttkReebGraph_GetWithSegmentation, METH_VARARGS,
   "GetWithSegmentation(self) -> bool\nC++: bool GetWithSegmentation()\n\n"},
  {"SetWithNormalize", PyttkReebGraph_SetWithNormalize, METH_VARARGS,
   "SetWithNormalize(self, norm:bool) -> None\nC++: void SetWithNormalize(const bool norm)\n\n"},
  {"GetWithNormalize", PyttkReebGraph_GetWithNormalize, METH_VARARGS,
   "GetWithNormalize(self) -> bool\nC++: bool GetWithNormalize()\n\n"},
  {"SetSampling", PyttkReebGraph_SetSampling, METH_VARARGS,
   "SetSampling(self, lvl:int) -> None\nC++: void SetSampling(int lvl)\n\n"},
  {"GetSuperArcSamplingLevel", PyttkReebGraph_GetSuperArcSamplingLevel, METH_VARARGS,
   "GetSuperArcSamplingLevel(self) -> int\nC++: int GetSuperArcSamplingLevel()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkReebGraph_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("force_input_offset_scalar_field"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebGraph_GetForceInputOffsetScalarField(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebGraph_SetForceInputOffsetScalarField(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebGraph_SetForceInputOffsetScalarField(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetForceInputOffsetScalarField/SetForceInputOffsetScalarField\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("single_sweep"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebGraph_GetSingleSweep(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebGraph_SetSingleSweep(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebGraph_SetSingleSweep(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSingleSweep/SetSingleSweep\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_segmentation"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebGraph_GetWithSegmentation(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebGraph_SetWithSegmentation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebGraph_SetWithSegmentation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithSegmentation/SetWithSegmentation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("with_normalize"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebGraph_GetWithNormalize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebGraph_SetWithNormalize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebGraph_SetWithNormalize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWithNormalize/SetWithNormalize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sampling"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkReebGraph_SetSampling(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkReebGraph_SetSampling(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSampling\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("super_arc_sampling_level"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkReebGraph_GetSuperArcSamplingLevel(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSuperArcSamplingLevel\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkReebGraph_Doc =
  "ttkReebGraph - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Charles Gueunet <charles.gueunet@kitware.com>\\date June 2017.\n\n"
  "\\sa ttk::ftm::FTRGraph\n\n"
  "TTK VTK-filter for the computation of Reeb Graphs\n\n"
  "The computation of the Reeb graph done by this package is done in\n"
  "parallel if TTK_ENABLE_OPENMP is set to ON, using a task based\n"
  "approach described in the article mention below.\n\n"
  "\\param Input Input scalar field, either 2D or 3D, regular\n"
  "grid or triangulation (vtkDataSet)\n"
  "\\param SingleSweep control if the computation should start from both\n"
  "    minima\n"
  "and maxima simultaneously. If you encounter troubled with FTR, you\n"
  "should try to use the single sweep. It is slower but may be more\n"
  "robust. \\param Segmentation control wethear or not the output should\n"
  "be augmented with the segmentation. \\param SuperArcSamplingLevel\n"
  "control the number of subdivision of each superarc. Intermediate\n"
  "point will be located on the barycenter of the corresponding portion\n"
  "of vertex.\n"
  "\\param Output the output of this filter\n"
  "is composed of:\n\n"
  "1. The nodes of the tree\n"
  "2. The arcs of the tree\n"
  "3. The semgentation of the initial dataset The structure of the tree\n"
  "   (Nodes+Arcs) have a concept of nodeId, which is an id that is\n"
  "   consistent between execution if SetWithNormalize is set to True.\n"
  "   The downNodeId of an arc is its starting node (directed towards\n"
  "   the leaves as the computation starts here) and the upNodeId it the\n"
  "ending node, in direction of the Root of the tree. The segmentation\n"
  "   also contains some basics metrics like the size of each region\n"
  "   (RegionSpan) or its number of vertex (RegionSize)\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "Related publication\n\n"
  "\"Task-based Augmented Reeb Graphs with Dynamic ST-Trees\"\n\n"
  "Charles Gueunet, Pierre Fortin, Julien Jomier, Julien Tierny\n\n"
  "EGPGV19: Eurographics Symposium on Parallel Graphics and\n"
  "Visualization\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/harmonicSkeleton/\"\n"
  "  > Harmonic Skeleton example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkReebGraph_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkReebGraph.ttkReebGraph", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkReebGraph_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkReebGraph_StaticNew()
{
  return ttkReebGraph::New();
}

PyObject *PyttkReebGraph_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkReebGraph_Type, PyttkReebGraph_Methods,
    "ttkReebGraph",
 &PyttkReebGraph_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkReebGraph_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkReebGraph(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkReebGraph_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkReebGraph", o) != 0)
  {
    Py_DECREF(o);
  }

}

