/* Generated by wayland-scanner 1.24.0 */

#ifndef EXT_IMAGE_COPY_CAPTURE_V1_SERVER_PROTOCOL_H
#define EXT_IMAGE_COPY_CAPTURE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_ext_image_copy_capture_v1 The ext_image_copy_capture_v1 protocol
 * image capturing into client buffers
 *
 * @section page_desc_ext_image_copy_capture_v1 Description
 *
 * This protocol allows clients to ask the compositor to capture image sources
 * such as outputs and toplevels into user submitted buffers.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 *
 * @section page_ifaces_ext_image_copy_capture_v1 Interfaces
 * - @subpage page_iface_ext_image_copy_capture_manager_v1 - manager to inform clients and begin capturing
 * - @subpage page_iface_ext_image_copy_capture_session_v1 - image copy capture session
 * - @subpage page_iface_ext_image_copy_capture_frame_v1 - image capture frame
 * - @subpage page_iface_ext_image_copy_capture_cursor_session_v1 - cursor capture session
 * @section page_copyright_ext_image_copy_capture_v1 Copyright
 * <pre>
 *
 * Copyright © 2021-2023 Andri Yngvason
 * Copyright © 2024 Simon Ser
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct ext_image_capture_source_v1;
struct ext_image_copy_capture_cursor_session_v1;
struct ext_image_copy_capture_frame_v1;
struct ext_image_copy_capture_manager_v1;
struct ext_image_copy_capture_session_v1;
struct wl_buffer;
struct wl_pointer;

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_manager_v1 ext_image_copy_capture_manager_v1
 * @section page_iface_ext_image_copy_capture_manager_v1_desc Description
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 * @section page_iface_ext_image_copy_capture_manager_v1_api API
 * See @ref iface_ext_image_copy_capture_manager_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_manager_v1 The ext_image_copy_capture_manager_v1 interface
 *
 * This object is a manager which offers requests to start capturing from a
 * source.
 */
extern const struct wl_interface ext_image_copy_capture_manager_v1_interface;
#endif
#ifndef EXT_IMAGE_COPY_CAPTURE_SESSION_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_session_v1 ext_image_copy_capture_session_v1
 * @section page_iface_ext_image_copy_capture_session_v1_desc Description
 *
 * This object represents an active image copy capture session.
 *
 * After a capture session is created, buffer constraint events will be
 * emitted from the compositor to tell the client which buffer types and
 * formats are supported for reading from the session. The compositor may
 * re-send buffer constraint events whenever they change.
 *
 * To advertise buffer constraints, the compositor must send in no
 * particular order: zero or more shm_format and dmabuf_format events, zero
 * or one dmabuf_device event, and exactly one buffer_size event. Then the
 * compositor must send a done event.
 *
 * When the client has received all the buffer constraints, it can create a
 * buffer accordingly, attach it to the capture session using the
 * attach_buffer request, set the buffer damage using the damage_buffer
 * request and then send the capture request.
 * @section page_iface_ext_image_copy_capture_session_v1_api API
 * See @ref iface_ext_image_copy_capture_session_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_session_v1 The ext_image_copy_capture_session_v1 interface
 *
 * This object represents an active image copy capture session.
 *
 * After a capture session is created, buffer constraint events will be
 * emitted from the compositor to tell the client which buffer types and
 * formats are supported for reading from the session. The compositor may
 * re-send buffer constraint events whenever they change.
 *
 * To advertise buffer constraints, the compositor must send in no
 * particular order: zero or more shm_format and dmabuf_format events, zero
 * or one dmabuf_device event, and exactly one buffer_size event. Then the
 * compositor must send a done event.
 *
 * When the client has received all the buffer constraints, it can create a
 * buffer accordingly, attach it to the capture session using the
 * attach_buffer request, set the buffer damage using the damage_buffer
 * request and then send the capture request.
 */
extern const struct wl_interface ext_image_copy_capture_session_v1_interface;
#endif
#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_frame_v1 ext_image_copy_capture_frame_v1
 * @section page_iface_ext_image_copy_capture_frame_v1_desc Description
 *
 * This object represents an image capture frame.
 *
 * The client should attach a buffer, damage the buffer, and then send a
 * capture request.
 *
 * If the capture is successful, the compositor must send the frame metadata
 * (transform, damage, presentation_time in any order) followed by the ready
 * event.
 *
 * If the capture fails, the compositor must send the failed event.
 * @section page_iface_ext_image_copy_capture_frame_v1_api API
 * See @ref iface_ext_image_copy_capture_frame_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_frame_v1 The ext_image_copy_capture_frame_v1 interface
 *
 * This object represents an image capture frame.
 *
 * The client should attach a buffer, damage the buffer, and then send a
 * capture request.
 *
 * If the capture is successful, the compositor must send the frame metadata
 * (transform, damage, presentation_time in any order) followed by the ready
 * event.
 *
 * If the capture fails, the compositor must send the failed event.
 */
extern const struct wl_interface ext_image_copy_capture_frame_v1_interface;
#endif
#ifndef EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_INTERFACE
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_INTERFACE
/**
 * @page page_iface_ext_image_copy_capture_cursor_session_v1 ext_image_copy_capture_cursor_session_v1
 * @section page_iface_ext_image_copy_capture_cursor_session_v1_desc Description
 *
 * This object represents a cursor capture session. It extends the base
 * capture session with cursor-specific metadata.
 * @section page_iface_ext_image_copy_capture_cursor_session_v1_api API
 * See @ref iface_ext_image_copy_capture_cursor_session_v1.
 */
/**
 * @defgroup iface_ext_image_copy_capture_cursor_session_v1 The ext_image_copy_capture_cursor_session_v1 interface
 *
 * This object represents a cursor capture session. It extends the base
 * capture session with cursor-specific metadata.
 */
extern const struct wl_interface ext_image_copy_capture_cursor_session_v1_interface;
#endif

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM
enum ext_image_copy_capture_manager_v1_error {
	/**
	 * invalid option flag
	 */
	EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_INVALID_OPTION = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM_IS_VALID
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 * Validate a ext_image_copy_capture_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref ext_image_copy_capture_manager_v1_error
 */
static inline bool
ext_image_copy_capture_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_INVALID_OPTION:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_ERROR_ENUM_IS_VALID */

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM
enum ext_image_copy_capture_manager_v1_options {
	/**
	 * paint cursors onto captured frames
	 */
	EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_PAINT_CURSORS = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM_IS_VALID
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM_IS_VALID
/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 * Validate a ext_image_copy_capture_manager_v1 options value.
 *
 * @return true on success, false on error.
 * @ref ext_image_copy_capture_manager_v1_options
 */
static inline bool
ext_image_copy_capture_manager_v1_options_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_PAINT_CURSORS;
	return (value & ~valid) == 0;
}
#endif /* EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_OPTIONS_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 * @struct ext_image_copy_capture_manager_v1_interface
 */
struct ext_image_copy_capture_manager_v1_interface {
	/**
	 * capture an image capture source
	 *
	 * Create a capturing session for an image capture source.
	 *
	 * If the paint_cursors option is set, cursors shall be composited
	 * onto the captured frame. The cursor must not be composited onto
	 * the frame if this flag is not set.
	 *
	 * If the options bitfield is invalid, the invalid_option protocol
	 * error is sent.
	 */
	void (*create_session)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t session,
			       struct wl_resource *source,
			       uint32_t options);
	/**
	 * capture the pointer cursor of an image capture source
	 *
	 * Create a cursor capturing session for the pointer of an image
	 * capture source.
	 */
	void (*create_pointer_cursor_session)(struct wl_client *client,
					      struct wl_resource *resource,
					      uint32_t session,
					      struct wl_resource *source,
					      struct wl_resource *pointer);
	/**
	 * destroy the manager
	 *
	 * Destroy the manager object.
	 *
	 * Other objects created via this interface are unaffected.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};


/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_CREATE_POINTER_CURSOR_SESSION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_manager_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_MANAGER_V1_DESTROY_SINCE_VERSION 1

#ifndef EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM
enum ext_image_copy_capture_session_v1_error {
	/**
	 * create_frame sent before destroying previous frame
	 */
	EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_DUPLICATE_FRAME = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM_IS_VALID
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * Validate a ext_image_copy_capture_session_v1 error value.
 *
 * @return true on success, false on error.
 * @ref ext_image_copy_capture_session_v1_error
 */
static inline bool
ext_image_copy_capture_session_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_DUPLICATE_FRAME:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EXT_IMAGE_COPY_CAPTURE_SESSION_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * @struct ext_image_copy_capture_session_v1_interface
 */
struct ext_image_copy_capture_session_v1_interface {
	/**
	 * create a frame
	 *
	 * Create a capture frame for this session.
	 *
	 * At most one frame object can exist for a given session at any
	 * time. If a client sends a create_frame request before a previous
	 * frame object has been destroyed, the duplicate_frame protocol
	 * error is raised.
	 */
	void (*create_frame)(struct wl_client *client,
			     struct wl_resource *resource,
			     uint32_t frame);
	/**
	 * delete this object
	 *
	 * Destroys the session. This request can be sent at any time by
	 * the client.
	 *
	 * This request doesn't affect ext_image_copy_capture_frame_v1
	 * objects created by this object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_BUFFER_SIZE 0
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_SHM_FORMAT 1
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_DEVICE 2
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_FORMAT 3
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DONE 4
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_STOPPED 5

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_BUFFER_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_SHM_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_FORMAT_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_STOPPED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_CREATE_FRAME_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * Sends an buffer_size event to the client owning the resource.
 * @param resource_ The client's resource
 * @param width buffer width
 * @param height buffer height
 */
static inline void
ext_image_copy_capture_session_v1_send_buffer_size(struct wl_resource *resource_, uint32_t width, uint32_t height)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_SESSION_V1_BUFFER_SIZE, width, height);
}

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * Sends an shm_format event to the client owning the resource.
 * @param resource_ The client's resource
 * @param format shm format
 */
static inline void
ext_image_copy_capture_session_v1_send_shm_format(struct wl_resource *resource_, uint32_t format)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_SESSION_V1_SHM_FORMAT, format);
}

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * Sends an dmabuf_device event to the client owning the resource.
 * @param resource_ The client's resource
 * @param device device dev_t value
 */
static inline void
ext_image_copy_capture_session_v1_send_dmabuf_device(struct wl_resource *resource_, struct wl_array *device)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_DEVICE, device);
}

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * Sends an dmabuf_format event to the client owning the resource.
 * @param resource_ The client's resource
 * @param format drm format code
 * @param modifiers drm format modifiers
 */
static inline void
ext_image_copy_capture_session_v1_send_dmabuf_format(struct wl_resource *resource_, uint32_t format, struct wl_array *modifiers)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DMABUF_FORMAT, format, modifiers);
}

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_image_copy_capture_session_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_SESSION_V1_DONE);
}

/**
 * @ingroup iface_ext_image_copy_capture_session_v1
 * Sends an stopped event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_image_copy_capture_session_v1_send_stopped(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_SESSION_V1_STOPPED);
}

#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM
enum ext_image_copy_capture_frame_v1_error {
	/**
	 * capture sent without attach_buffer
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_NO_BUFFER = 1,
	/**
	 * invalid buffer damage
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_INVALID_BUFFER_DAMAGE = 2,
	/**
	 * capture request has been sent
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ALREADY_CAPTURED = 3,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM_IS_VALID
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * Validate a ext_image_copy_capture_frame_v1 error value.
 *
 * @return true on success, false on error.
 * @ref ext_image_copy_capture_frame_v1_error
 */
static inline bool
ext_image_copy_capture_frame_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_NO_BUFFER:
		return version >= 1;
	case EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_INVALID_BUFFER_DAMAGE:
		return version >= 1;
	case EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ALREADY_CAPTURED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ERROR_ENUM_IS_VALID */

#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM
enum ext_image_copy_capture_frame_v1_failure_reason {
	/**
	 * unknown runtime error
	 *
	 * An unspecified runtime error has occurred. The client may
	 * retry.
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_UNKNOWN = 0,
	/**
	 * buffer constraints mismatch
	 *
	 * The buffer submitted by the client doesn't match the latest
	 * session constraints. The client should re-allocate its buffers
	 * and retry.
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_BUFFER_CONSTRAINTS = 1,
	/**
	 * session is no longer available
	 *
	 * The session has stopped. See
	 * ext_image_copy_capture_session_v1.stopped.
	 */
	EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_STOPPED = 2,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM_IS_VALID
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM_IS_VALID
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * Validate a ext_image_copy_capture_frame_v1 failure_reason value.
 *
 * @return true on success, false on error.
 * @ref ext_image_copy_capture_frame_v1_failure_reason
 */
static inline bool
ext_image_copy_capture_frame_v1_failure_reason_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_UNKNOWN:
		return version >= 1;
	case EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_BUFFER_CONSTRAINTS:
		return version >= 1;
	case EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_STOPPED:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILURE_REASON_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * @struct ext_image_copy_capture_frame_v1_interface
 */
struct ext_image_copy_capture_frame_v1_interface {
	/**
	 * destroy this object
	 *
	 * Destroys the frame. This request can be sent at any time by
	 * the client.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * attach buffer to session
	 *
	 * Attach a buffer to the session.
	 *
	 * The wl_buffer.release request is unused.
	 *
	 * The new buffer replaces any previously attached buffer.
	 *
	 * This request must not be sent after capture, or else the
	 * already_captured protocol error is raised.
	 */
	void (*attach_buffer)(struct wl_client *client,
			      struct wl_resource *resource,
			      struct wl_resource *buffer);
	/**
	 * damage buffer
	 *
	 * Apply damage to the buffer which is to be captured next. This
	 * request may be sent multiple times to describe a region.
	 *
	 * The client indicates the accumulated damage since this wl_buffer
	 * was last captured. During capture, the compositor will update
	 * the buffer with at least the union of the region passed by the
	 * client and the region advertised by
	 * ext_image_copy_capture_frame_v1.damage.
	 *
	 * When a wl_buffer is captured for the first time, or when the
	 * client doesn't track damage, the client must damage the whole
	 * buffer.
	 *
	 * This is for optimisation purposes. The compositor may use this
	 * information to reduce copying.
	 *
	 * These coordinates originate from the upper left corner of the
	 * buffer.
	 *
	 * If x or y are strictly negative, or if width or height are
	 * negative or zero, the invalid_buffer_damage protocol error is
	 * raised.
	 *
	 * This request must not be sent after capture, or else the
	 * already_captured protocol error is raised.
	 * @param x region x coordinate
	 * @param y region y coordinate
	 * @param width region width
	 * @param height region height
	 */
	void (*damage_buffer)(struct wl_client *client,
			      struct wl_resource *resource,
			      int32_t x,
			      int32_t y,
			      int32_t width,
			      int32_t height);
	/**
	 * capture a frame
	 *
	 * Capture a frame.
	 *
	 * Unless this is the first successful captured frame performed in
	 * this session, the compositor may wait an indefinite amount of
	 * time for the source content to change before performing the
	 * copy.
	 *
	 * This request may only be sent once, or else the already_captured
	 * protocol error is raised. A buffer must be attached before this
	 * request is sent, or else the no_buffer protocol error is raised.
	 */
	void (*capture)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_TRANSFORM 0
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE 1
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_PRESENTATION_TIME 2
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_READY 3
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILED 4

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_TRANSFORM_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_PRESENTATION_TIME_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_READY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_ATTACH_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE_BUFFER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_FRAME_V1_CAPTURE_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * Sends an transform event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_image_copy_capture_frame_v1_send_transform(struct wl_resource *resource_, uint32_t transform)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_FRAME_V1_TRANSFORM, transform);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * Sends an damage event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x damage x coordinate
 * @param y damage y coordinate
 * @param width damage width
 * @param height damage height
 */
static inline void
ext_image_copy_capture_frame_v1_send_damage(struct wl_resource *resource_, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_FRAME_V1_DAMAGE, x, y, width, height);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * Sends an presentation_time event to the client owning the resource.
 * @param resource_ The client's resource
 * @param tv_sec_hi high 32 bits of the seconds part of the timestamp
 * @param tv_sec_lo low 32 bits of the seconds part of the timestamp
 * @param tv_nsec nanoseconds part of the timestamp
 */
static inline void
ext_image_copy_capture_frame_v1_send_presentation_time(struct wl_resource *resource_, uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_nsec)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_FRAME_V1_PRESENTATION_TIME, tv_sec_hi, tv_sec_lo, tv_nsec);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * Sends an ready event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_image_copy_capture_frame_v1_send_ready(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_FRAME_V1_READY);
}

/**
 * @ingroup iface_ext_image_copy_capture_frame_v1
 * Sends an failed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_image_copy_capture_frame_v1_send_failed(struct wl_resource *resource_, uint32_t reason)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_FRAME_V1_FAILED, reason);
}

#ifndef EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM
enum ext_image_copy_capture_cursor_session_v1_error {
	/**
	 * get_capture_session sent twice
	 */
	EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_DUPLICATE_SESSION = 1,
};
#endif /* EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM */

#ifndef EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM_IS_VALID
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 * Validate a ext_image_copy_capture_cursor_session_v1 error value.
 *
 * @return true on success, false on error.
 * @ref ext_image_copy_capture_cursor_session_v1_error
 */
static inline bool
ext_image_copy_capture_cursor_session_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_DUPLICATE_SESSION:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 * @struct ext_image_copy_capture_cursor_session_v1_interface
 */
struct ext_image_copy_capture_cursor_session_v1_interface {
	/**
	 * delete this object
	 *
	 * Destroys the session. This request can be sent at any time by
	 * the client.
	 *
	 * This request doesn't affect ext_image_copy_capture_frame_v1
	 * objects created by this object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * get image copy capturer session
	 *
	 * Gets the image copy capture session for this cursor session.
	 *
	 * The session will produce frames of the cursor image. The
	 * compositor may pause the session when the cursor leaves the
	 * captured area.
	 *
	 * This request must not be sent more than once, or else the
	 * duplicate_session protocol error is raised.
	 */
	void (*get_capture_session)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t session);
};

#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ENTER 0
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_LEAVE 1
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_POSITION 2
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_HOTSPOT 3

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_HOTSPOT_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 */
#define EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_GET_CAPTURE_SESSION_SINCE_VERSION 1

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 * Sends an enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_image_copy_capture_cursor_session_v1_send_enter(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_ENTER);
}

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 * Sends an leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_image_copy_capture_cursor_session_v1_send_leave(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_LEAVE);
}

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 * Sends an position event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x position x coordinates
 * @param y position y coordinates
 */
static inline void
ext_image_copy_capture_cursor_session_v1_send_position(struct wl_resource *resource_, int32_t x, int32_t y)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_POSITION, x, y);
}

/**
 * @ingroup iface_ext_image_copy_capture_cursor_session_v1
 * Sends an hotspot event to the client owning the resource.
 * @param resource_ The client's resource
 * @param x hotspot x coordinates
 * @param y hotspot y coordinates
 */
static inline void
ext_image_copy_capture_cursor_session_v1_send_hotspot(struct wl_resource *resource_, int32_t x, int32_t y)
{
	wl_resource_post_event(resource_, EXT_IMAGE_COPY_CAPTURE_CURSOR_SESSION_V1_HOTSPOT, x, y);
}

#ifdef  __cplusplus
}
#endif

#endif
