//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/builtinMaterialSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdBuiltinMaterialSchemaTokens,
    HD_BUILTIN_MATERIAL_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdBoolDataSourceHandle
HdBuiltinMaterialSchema::GetBuiltinMaterial() const
{
    return _GetTypedDataSource<HdBoolDataSource>(
        HdBuiltinMaterialSchemaTokens->builtinMaterial);
}

/*static*/
HdContainerDataSourceHandle
HdBuiltinMaterialSchema::BuildRetained(
        const HdBoolDataSourceHandle &builtinMaterial
)
{
    TfToken _names[1];
    HdDataSourceBaseHandle _values[1];

    size_t _count = 0;

    if (builtinMaterial) {
        _names[_count] = HdBuiltinMaterialSchemaTokens->builtinMaterial;
        _values[_count++] = builtinMaterial;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdBuiltinMaterialSchema::Builder &
HdBuiltinMaterialSchema::Builder::SetBuiltinMaterial(
    const HdBoolDataSourceHandle &builtinMaterial)
{
    _builtinMaterial = builtinMaterial;
    return *this;
}

HdContainerDataSourceHandle
HdBuiltinMaterialSchema::Builder::Build()
{
    return HdBuiltinMaterialSchema::BuildRetained(
        _builtinMaterial
    );
}

/*static*/
HdBuiltinMaterialSchema
HdBuiltinMaterialSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdBuiltinMaterialSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdBuiltinMaterialSchemaTokens->builtinMaterial))
        : nullptr);
}

/*static*/
const TfToken &
HdBuiltinMaterialSchema::GetSchemaToken()
{
    return HdBuiltinMaterialSchemaTokens->builtinMaterial;
}

/*static*/
const HdDataSourceLocator &
HdBuiltinMaterialSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
HdBuiltinMaterialSchema::GetBuiltinMaterialLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            HdBuiltinMaterialSchemaTokens->builtinMaterial);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE