//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/materialInterfaceSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
#include "pxr/imaging/hd/materialInterfaceMappingSchema.h"
#include "pxr/imaging/hd/materialInterfaceParameterSchema.h"
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdMaterialInterfaceSchemaTokens,
    HD_MATERIAL_INTERFACE_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

NestedTfTokenMap
HdMaterialInterfaceSchema::GetReverseInterfaceMappings() const
{
    NestedTfTokenMap reverseInterfaceMappings;

    const HdMaterialInterfaceParameterContainerSchema 
        interfaceParameters = GetParameters();
    if (!interfaceParameters) {
        return reverseInterfaceMappings;
    }

    for (const TfToken& publicUIName : interfaceParameters.GetNames()) {
        // Each publicUIName maps to an interface parameter
        const HdMaterialInterfaceParameterSchema parameterSchema =
            interfaceParameters.Get(publicUIName);
        if (!parameterSchema) {
            continue;
        }

        //  Each interface parameter maps to a list of material node parameters 
        // ie. [(nodePath, inputName), ...]
        const HdMaterialInterfaceMappingVectorSchema mappings =
            parameterSchema.GetMappings();
        if (!mappings) {
            continue;
        }

        const size_t numElems = mappings.GetNumElements();
        for (size_t i = 0; i < numElems; i++) {
            // Each interfaceMapping should be a (nodePath, inputName) pair 
            HdMaterialInterfaceMappingSchema interfaceMappingSchema =
                mappings.GetElement(i);
            if (!interfaceMappingSchema) {
                continue;
            }

            const TfToken nodePath = 
                interfaceMappingSchema.GetNodePath()->GetTypedValue(0);
            const TfToken inputName = 
                interfaceMappingSchema.GetInputName()->GetTypedValue(0);

            reverseInterfaceMappings[nodePath][inputName] = publicUIName;
        }
    }
    return reverseInterfaceMappings;
}

// --(END CUSTOM CODE: Schema Methods)--

HdMaterialInterfaceParameterContainerSchema
HdMaterialInterfaceSchema::GetParameters() const
{
    return HdMaterialInterfaceParameterContainerSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdMaterialInterfaceSchemaTokens->parameters));
}

HdTokenArrayDataSourceHandle
HdMaterialInterfaceSchema::GetParameterOrder() const
{
    return _GetTypedDataSource<HdTokenArrayDataSource>(
        HdMaterialInterfaceSchemaTokens->parameterOrder);
}

/*static*/
HdContainerDataSourceHandle
HdMaterialInterfaceSchema::BuildRetained(
        const HdContainerDataSourceHandle &parameters,
        const HdTokenArrayDataSourceHandle &parameterOrder
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (parameters) {
        _names[_count] = HdMaterialInterfaceSchemaTokens->parameters;
        _values[_count++] = parameters;
    }

    if (parameterOrder) {
        _names[_count] = HdMaterialInterfaceSchemaTokens->parameterOrder;
        _values[_count++] = parameterOrder;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdMaterialInterfaceSchema::Builder &
HdMaterialInterfaceSchema::Builder::SetParameters(
    const HdContainerDataSourceHandle &parameters)
{
    _parameters = parameters;
    return *this;
}

HdMaterialInterfaceSchema::Builder &
HdMaterialInterfaceSchema::Builder::SetParameterOrder(
    const HdTokenArrayDataSourceHandle &parameterOrder)
{
    _parameterOrder = parameterOrder;
    return *this;
}

HdContainerDataSourceHandle
HdMaterialInterfaceSchema::Builder::Build()
{
    return HdMaterialInterfaceSchema::BuildRetained(
        _parameters,
        _parameterOrder
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE