//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/materialNodeParameterSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdMaterialNodeParameterSchemaTokens,
    HD_MATERIAL_NODE_PARAMETER_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdSampledDataSourceHandle
HdMaterialNodeParameterSchema::GetValue() const
{
    return _GetTypedDataSource<HdSampledDataSource>(
        HdMaterialNodeParameterSchemaTokens->value);
}

HdTokenDataSourceHandle
HdMaterialNodeParameterSchema::GetColorSpace() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdMaterialNodeParameterSchemaTokens->colorSpace);
}

HdTokenDataSourceHandle
HdMaterialNodeParameterSchema::GetTypeName() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdMaterialNodeParameterSchemaTokens->typeName);
}

/*static*/
HdContainerDataSourceHandle
HdMaterialNodeParameterSchema::BuildRetained(
        const HdSampledDataSourceHandle &value,
        const HdTokenDataSourceHandle &colorSpace,
        const HdTokenDataSourceHandle &typeName
)
{
    TfToken _names[3];
    HdDataSourceBaseHandle _values[3];

    size_t _count = 0;

    if (value) {
        _names[_count] = HdMaterialNodeParameterSchemaTokens->value;
        _values[_count++] = value;
    }

    if (colorSpace) {
        _names[_count] = HdMaterialNodeParameterSchemaTokens->colorSpace;
        _values[_count++] = colorSpace;
    }

    if (typeName) {
        _names[_count] = HdMaterialNodeParameterSchemaTokens->typeName;
        _values[_count++] = typeName;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdMaterialNodeParameterSchema::Builder &
HdMaterialNodeParameterSchema::Builder::SetValue(
    const HdSampledDataSourceHandle &value)
{
    _value = value;
    return *this;
}

HdMaterialNodeParameterSchema::Builder &
HdMaterialNodeParameterSchema::Builder::SetColorSpace(
    const HdTokenDataSourceHandle &colorSpace)
{
    _colorSpace = colorSpace;
    return *this;
}

HdMaterialNodeParameterSchema::Builder &
HdMaterialNodeParameterSchema::Builder::SetTypeName(
    const HdTokenDataSourceHandle &typeName)
{
    _typeName = typeName;
    return *this;
}

HdContainerDataSourceHandle
HdMaterialNodeParameterSchema::Builder::Build()
{
    return HdMaterialNodeParameterSchema::BuildRetained(
        _value,
        _colorSpace,
        _typeName
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE