// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#include "config.h"
#include "StyleExtractorGenerated.h"

#include "CSSPrimitiveValueMappings.h"
#include "CSSProperty.h"
#include "ColorSerialization.h"
#include "RenderStyle.h"
#include "StyleExtractorConverter.h"
#include "StyleExtractorCustom.h"
#include "StyleExtractorState.h"
#include "StylePropertyShorthand.h"

namespace WebCore {
namespace Style {

class ExtractorFunctions {
public:
    static RefPtr<CSSValue> extractColorScheme(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ColorScheme>(extractorState, extractorState.style.colorScheme());
    }
    static void extractColorSchemeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ColorScheme>(extractorState, builder, context, extractorState.style.colorScheme());
    }
    static RefPtr<CSSValue> extractRubyPosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.rubyPosition());
    }
    static void extractRubyPositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.rubyPosition());
    }
    static RefPtr<CSSValue> extractDisplay(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.display());
    }
    static void extractDisplaySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.display());
    }
    static RefPtr<CSSValue> extractFontFeatureSettings(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFontFeatureSettings(extractorState, extractorState.style.fontDescription().featureSettings());
    }
    static void extractFontFeatureSettingsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFontFeatureSettings(extractorState, builder, context, extractorState.style.fontDescription().featureSettings());
    }
    static RefPtr<CSSValue> extractFontKerning(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().kerning());
    }
    static void extractFontKerningSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().kerning());
    }
    static RefPtr<CSSValue> extractFontOpticalSizing(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().opticalSizing());
    }
    static void extractFontOpticalSizingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().opticalSizing());
    }
    static RefPtr<CSSValue> extractFontPalette(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFontPalette(extractorState, extractorState.style.fontDescription().fontPalette());
    }
    static void extractFontPaletteSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFontPalette(extractorState, builder, context, extractorState.style.fontDescription().fontPalette());
    }
    static RefPtr<CSSValue> extractFontSizeAdjust(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFontSizeAdjust(extractorState, extractorState.style.fontDescription().fontSizeAdjust());
    }
    static void extractFontSizeAdjustSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFontSizeAdjust(extractorState, builder, context, extractorState.style.fontDescription().fontSizeAdjust());
    }
    static RefPtr<CSSValue> extractFontSynthesisSmallCaps(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().fontSynthesisSmallCaps());
    }
    static void extractFontSynthesisSmallCapsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().fontSynthesisSmallCaps());
    }
    static RefPtr<CSSValue> extractFontSynthesisStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().fontSynthesisStyle());
    }
    static void extractFontSynthesisStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().fontSynthesisStyle());
    }
    static RefPtr<CSSValue> extractFontSynthesisWeight(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().fontSynthesisWeight());
    }
    static void extractFontSynthesisWeightSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().fontSynthesisWeight());
    }
    static RefPtr<CSSValue> extractFontVariantCaps(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().variantCaps());
    }
    static void extractFontVariantCapsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().variantCaps());
    }
    static RefPtr<CSSValue> extractFontVariantEmoji(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().variantEmoji());
    }
    static void extractFontVariantEmojiSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().variantEmoji());
    }
    static RefPtr<CSSValue> extractFontVariantPosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().variantPosition());
    }
    static void extractFontVariantPositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().variantPosition());
    }
    static RefPtr<CSSValue> extractFontVariationSettings(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFontVariationSettings(extractorState, extractorState.style.fontDescription().variationSettings());
    }
    static void extractFontVariationSettingsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFontVariationSettings(extractorState, builder, context, extractorState.style.fontDescription().variationSettings());
    }
    static RefPtr<CSSValue> extractFontWeight(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFontWeight(extractorState, extractorState.style.fontDescription().weight());
    }
    static void extractFontWeightSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFontWeight(extractorState, builder, context, extractorState.style.fontDescription().weight());
    }
    static RefPtr<CSSValue> extractFontWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFontWidth(extractorState, extractorState.style.fontDescription().width());
    }
    static void extractFontWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFontWidth(extractorState, builder, context, extractorState.style.fontDescription().width());
    }
    static RefPtr<CSSValue> extractTextOrientation(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.writingMode().computedTextOrientation());
    }
    static void extractTextOrientationSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.writingMode().computedTextOrientation());
    }
    static RefPtr<CSSValue> extractTextRendering(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().textRenderingMode());
    }
    static void extractTextRenderingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().textRenderingMode());
    }
    static RefPtr<CSSValue> extractZoom(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.zoom());
    }
    static void extractZoomSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.zoom());
    }
    static RefPtr<CSSValue> extractWebkitFontSmoothing(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fontDescription().fontSmoothing());
    }
    static void extractWebkitFontSmoothingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fontDescription().fontSmoothing());
    }
    static RefPtr<CSSValue> extractWebkitLocale(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertCustomIdentAtomOrKeyword<CSSValueAuto>(extractorState, extractorState.style.fontDescription().specifiedLocale());
    }
    static void extractWebkitLocaleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeCustomIdentAtomOrKeyword<CSSValueAuto>(extractorState, builder, context, extractorState.style.fontDescription().specifiedLocale());
    }
    static RefPtr<CSSValue> extractWebkitTextZoom(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textZoom());
    }
    static void extractWebkitTextZoomSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textZoom());
    }
    static RefPtr<CSSValue> extractTextAutospace(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextAutospace(extractorState, extractorState.style.fontDescription().textAutospace());
    }
    static void extractTextAutospaceSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextAutospace(extractorState, builder, context, extractorState.style.fontDescription().textAutospace());
    }
    static RefPtr<CSSValue> extractTextSpacingTrim(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextSpacingTrim(extractorState, extractorState.style.fontDescription().textSpacingTrim());
    }
    static void extractTextSpacingTrimSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextSpacingTrim(extractorState, builder, context, extractorState.style.fontDescription().textSpacingTrim());
    }
    static RefPtr<CSSValue> extractAccentColor(ExtractorState& extractorState)
    {
        if (extractorState.style.hasAutoAccentColor())
            return CSSPrimitiveValue::create(CSSValueAuto);
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.accentColor());
    }
    static void extractAccentColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.style.hasAutoAccentColor()) {
            builder.append(nameLiteralForSerialization(CSSValueAuto));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.accentColor());
    }
    static RefPtr<CSSValue> extractAlignContent(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertContentAlignmentData(extractorState, extractorState.style.alignContent());
    }
    static void extractAlignContentSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeContentAlignmentData(extractorState, builder, context, extractorState.style.alignContent());
    }
    static RefPtr<CSSValue> extractAlignItems(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSelfOrDefaultAlignmentData(extractorState, extractorState.style.alignItems());
    }
    static void extractAlignItemsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSelfOrDefaultAlignmentData(extractorState, builder, context, extractorState.style.alignItems());
    }
    static RefPtr<CSSValue> extractAlignSelf(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSelfOrDefaultAlignmentData(extractorState, extractorState.style.alignSelf());
    }
    static void extractAlignSelfSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSelfOrDefaultAlignmentData(extractorState, builder, context, extractorState.style.alignSelf());
    }
    static RefPtr<CSSValue> extractAlignmentBaseline(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().alignmentBaseline());
    }
    static void extractAlignmentBaselineSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().alignmentBaseline());
    }
    static RefPtr<CSSValue> extractAnchorName(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<AnchorNames>(extractorState, extractorState.style.anchorNames());
    }
    static void extractAnchorNameSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<AnchorNames>(extractorState, builder, context, extractorState.style.anchorNames());
    }
    static RefPtr<CSSValue> extractAnchorScope(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertNameScope(extractorState, extractorState.style.anchorScope());
    }
    static void extractAnchorScopeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeNameScope(extractorState, builder, context, extractorState.style.anchorScope());
    }
    static RefPtr<CSSValue> extractAnimationComposition(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationCompositeOperation(extractorState, Animation::initialCompositeOperation(), animation, animationList);
            }
            if (!animation->isCompositeOperationFilled()) {
                return ExtractorConverter::convertAnimationCompositeOperation(extractorState, animation->compositeOperation(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationCompositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationCompositeOperation(extractorState, builder, context, Animation::initialCompositeOperation(), animation, animationList);
                return;
            }
            if (!animation->isCompositeOperationFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationCompositeOperation(extractorState, builder, context, animation->compositeOperation(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationDelay(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationDelay(extractorState, Animation::initialDelay(), animation, animationList);
            }
            if (!animation->isDelayFilled()) {
                return ExtractorConverter::convertAnimationDelay(extractorState, animation->delay(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationDelaySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDelay(extractorState, builder, context, Animation::initialDelay(), animation, animationList);
                return;
            }
            if (!animation->isDelayFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDelay(extractorState, builder, context, animation->delay(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationDirection(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationDirection(extractorState, Animation::initialDirection(), animation, animationList);
            }
            if (!animation->isDirectionFilled()) {
                return ExtractorConverter::convertAnimationDirection(extractorState, animation->direction(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationDirectionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDirection(extractorState, builder, context, Animation::initialDirection(), animation, animationList);
                return;
            }
            if (!animation->isDirectionFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDirection(extractorState, builder, context, animation->direction(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationDuration(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationDuration(extractorState, Animation::initialDuration(), animation, animationList);
            }
            if (!animation->isDurationFilled()) {
                return ExtractorConverter::convertAnimationDuration(extractorState, animation->duration(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationDurationSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDuration(extractorState, builder, context, Animation::initialDuration(), animation, animationList);
                return;
            }
            if (!animation->isDurationFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDuration(extractorState, builder, context, animation->duration(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationFillMode(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationFillMode(extractorState, Animation::initialFillMode(), animation, animationList);
            }
            if (!animation->isFillModeFilled()) {
                return ExtractorConverter::convertAnimationFillMode(extractorState, animation->fillMode(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationFillModeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationFillMode(extractorState, builder, context, Animation::initialFillMode(), animation, animationList);
                return;
            }
            if (!animation->isFillModeFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationFillMode(extractorState, builder, context, animation->fillMode(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationIterationCount(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationIterationCount(extractorState, Animation::initialIterationCount(), animation, animationList);
            }
            if (!animation->isIterationCountFilled()) {
                return ExtractorConverter::convertAnimationIterationCount(extractorState, animation->iterationCount(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationIterationCountSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationIterationCount(extractorState, builder, context, Animation::initialIterationCount(), animation, animationList);
                return;
            }
            if (!animation->isIterationCountFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationIterationCount(extractorState, builder, context, animation->iterationCount(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationName(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationName(extractorState, Animation::initialName(), animation, animationList);
            }
            if (!animation->isNameFilled()) {
                return ExtractorConverter::convertAnimationName(extractorState, animation->name(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationNameSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationName(extractorState, builder, context, Animation::initialName(), animation, animationList);
                return;
            }
            if (!animation->isNameFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationName(extractorState, builder, context, animation->name(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationPlayState(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationPlayState(extractorState, Animation::initialPlayState(), animation, animationList);
            }
            if (!animation->isPlayStateFilled()) {
                return ExtractorConverter::convertAnimationPlayState(extractorState, animation->playState(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationPlayStateSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationPlayState(extractorState, builder, context, Animation::initialPlayState(), animation, animationList);
                return;
            }
            if (!animation->isPlayStateFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationPlayState(extractorState, builder, context, animation->playState(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationRangeEnd(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationRangeEnd(extractorState, Animation::initialRangeEnd(), animation, animationList);
            }
            if (!animation->isRangeEndFilled()) {
                return ExtractorConverter::convertAnimationRangeEnd(extractorState, animation->rangeEnd(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationRangeEndSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationRangeEnd(extractorState, builder, context, Animation::initialRangeEnd(), animation, animationList);
                return;
            }
            if (!animation->isRangeEndFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationRangeEnd(extractorState, builder, context, animation->rangeEnd(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationRangeStart(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationRangeStart(extractorState, Animation::initialRangeStart(), animation, animationList);
            }
            if (!animation->isRangeStartFilled()) {
                return ExtractorConverter::convertAnimationRangeStart(extractorState, animation->rangeStart(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationRangeStartSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationRangeStart(extractorState, builder, context, Animation::initialRangeStart(), animation, animationList);
                return;
            }
            if (!animation->isRangeStartFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationRangeStart(extractorState, builder, context, animation->rangeStart(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationTimeline(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationTimeline(extractorState, Animation::initialTimeline(), animation, animationList);
            }
            if (!animation->isTimelineFilled()) {
                return ExtractorConverter::convertAnimationTimeline(extractorState, animation->timeline(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationTimelineSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationTimeline(extractorState, builder, context, Animation::initialTimeline(), animation, animationList);
                return;
            }
            if (!animation->isTimelineFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationTimeline(extractorState, builder, context, animation->timeline(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAnimationTimingFunction(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationTimingFunction(extractorState, Animation::initialTimingFunction(), animation, animationList);
            }
            if (!animation->isTimingFunctionFilled()) {
                return ExtractorConverter::convertAnimationTimingFunction(extractorState, animation->timingFunction(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.animations(), mapper);
    }
    static void extractAnimationTimingFunctionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationTimingFunction(extractorState, builder, context, Animation::initialTimingFunction(), animation, animationList);
                return;
            }
            if (!animation->isTimingFunctionFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationTimingFunction(extractorState, builder, context, animation->timingFunction(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.animations(), mapper);
    }
    static RefPtr<CSSValue> extractAppearance(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.appearance());
    }
    static void extractAppearanceSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.appearance());
    }
    static RefPtr<CSSValue> extractAspectRatio(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<AspectRatio>(extractorState, extractorState.style.aspectRatio());
    }
    static void extractAspectRatioSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<AspectRatio>(extractorState, builder, context, extractorState.style.aspectRatio());
    }
    static RefPtr<CSSValue> extractBackdropFilter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFilterOperations(extractorState, extractorState.style.backdropFilter());
    }
    static void extractBackdropFilterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFilterOperations(extractorState, builder, context, extractorState.style.backdropFilter());
    }
    static RefPtr<CSSValue> extractBackfaceVisibility(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.backfaceVisibility());
    }
    static void extractBackfaceVisibilitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.backfaceVisibility());
    }
    static RefPtr<CSSValue> extractBackgroundAttachment(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerAttachment(extractorState, layer.attachment());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundAttachmentSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerAttachment(extractorState, builder, context, layer.attachment());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundBlendMode(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerBlendMode(extractorState, layer.blendMode());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundBlendModeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerBlendMode(extractorState, builder, context, layer.blendMode());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundClip(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerClip(extractorState, layer.clip());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundClipSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerClip(extractorState, builder, context, layer.clip());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBackgroundColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.backgroundColor());
    }
    static void extractBackgroundColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBackgroundColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.backgroundColor());
    }
    static RefPtr<CSSValue> extractBackgroundImage(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerImage(extractorState, layer.image());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundImageSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerImage(extractorState, builder, context, layer.image());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundOrigin(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerOrigin(extractorState, layer.origin());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundOriginSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerOrigin(extractorState, builder, context, layer.origin());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundPositionX(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertStyleType<FillPositionX>(extractorState, layer.xPosition());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundPositionXSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeStyleType<FillPositionX>(extractorState, builder, context, layer.xPosition());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundPositionY(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertStyleType<FillPositionY>(extractorState, layer.yPosition());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundPositionYSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeStyleType<FillPositionY>(extractorState, builder, context, layer.yPosition());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundRepeat(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerRepeat(extractorState, layer.repeat());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundRepeatSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerRepeat(extractorState, builder, context, layer.repeat());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBackgroundSize(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerBackgroundSize(extractorState, layer.size());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractBackgroundSizeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerBackgroundSize(extractorState, builder, context, layer.size());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractBaselineShift(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGBaselineShift>(extractorState, extractorState.style.svgStyle().baselineShift());
    }
    static void extractBaselineShiftSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGBaselineShift>(extractorState, builder, context, extractorState.style.svgStyle().baselineShift());
    }
    static RefPtr<CSSValue> extractBlockEllipsis(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BlockEllipsis>(extractorState, extractorState.style.blockEllipsis());
    }
    static void extractBlockEllipsisSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BlockEllipsis>(extractorState, builder, context, extractorState.style.blockEllipsis());
    }
    static RefPtr<CSSValue> extractBlockStepAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.blockStepAlign());
    }
    static void extractBlockStepAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.blockStepAlign());
    }
    static RefPtr<CSSValue> extractBlockStepInsert(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.blockStepInsert());
    }
    static void extractBlockStepInsertSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.blockStepInsert());
    }
    static RefPtr<CSSValue> extractBlockStepRound(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.blockStepRound());
    }
    static void extractBlockStepRoundSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.blockStepRound());
    }
    static RefPtr<CSSValue> extractBlockStepSize(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BlockStepSize>(extractorState, extractorState.style.blockStepSize());
    }
    static void extractBlockStepSizeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BlockStepSize>(extractorState, builder, context, extractorState.style.blockStepSize());
    }
    static RefPtr<CSSValue> extractBorderCollapse(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.borderCollapse());
    }
    static void extractBorderCollapseSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.borderCollapse());
    }
    static RefPtr<CSSValue> extractBorderImageSource(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertImageOrNone(extractorState, extractorState.style.borderImageSource());
    }
    static void extractBorderImageSourceSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeImageOrNone(extractorState, builder, context, extractorState.style.borderImageSource());
    }
    static RefPtr<CSSValue> extractBoxShadow(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BoxShadows>(extractorState, extractorState.style.boxShadow());
    }
    static void extractBoxShadowSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BoxShadows>(extractorState, builder, context, extractorState.style.boxShadow());
    }
    static RefPtr<CSSValue> extractBoxSizing(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxSizing());
    }
    static void extractBoxSizingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxSizing());
    }
    static RefPtr<CSSValue> extractBreakAfter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.breakAfter());
    }
    static void extractBreakAfterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.breakAfter());
    }
    static RefPtr<CSSValue> extractBreakBefore(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.breakBefore());
    }
    static void extractBreakBeforeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.breakBefore());
    }
    static RefPtr<CSSValue> extractBreakInside(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.breakInside());
    }
    static void extractBreakInsideSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.breakInside());
    }
    static RefPtr<CSSValue> extractBufferedRendering(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().bufferedRendering());
    }
    static void extractBufferedRenderingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().bufferedRendering());
    }
    static RefPtr<CSSValue> extractCaptionSide(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.captionSide());
    }
    static void extractCaptionSideSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.captionSide());
    }
    static RefPtr<CSSValue> extractCaretColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyCaretColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.caretColor());
    }
    static void extractCaretColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyCaretColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.caretColor());
    }
    static RefPtr<CSSValue> extractClear(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.clear());
    }
    static void extractClearSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.clear());
    }
    static RefPtr<CSSValue> extractClip(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Clip>(extractorState, extractorState.style.clip());
    }
    static void extractClipSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Clip>(extractorState, builder, context, extractorState.style.clip());
    }
    static RefPtr<CSSValue> extractClipPath(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ClipPath>(extractorState, extractorState.style.clipPath());
    }
    static void extractClipPathSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ClipPath>(extractorState, builder, context, extractorState.style.clipPath());
    }
    static RefPtr<CSSValue> extractClipRule(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().clipRule());
    }
    static void extractClipRuleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().clipRule());
    }
    static RefPtr<CSSValue> extractColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.color());
    }
    static void extractColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.color());
    }
    static RefPtr<CSSValue> extractColorInterpolation(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().colorInterpolation());
    }
    static void extractColorInterpolationSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().colorInterpolation());
    }
    static RefPtr<CSSValue> extractColorInterpolationFilters(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().colorInterpolationFilters());
    }
    static void extractColorInterpolationFiltersSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().colorInterpolationFilters());
    }
    static RefPtr<CSSValue> extractColumnCount(ExtractorState& extractorState)
    {
        if (extractorState.style.hasAutoColumnCount())
            return CSSPrimitiveValue::create(CSSValueAuto);
        return ExtractorConverter::convert(extractorState, extractorState.style.columnCount());
    }
    static void extractColumnCountSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.style.hasAutoColumnCount()) {
            builder.append(nameLiteralForSerialization(CSSValueAuto));
            return;
        }
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.columnCount());
    }
    static RefPtr<CSSValue> extractColumnFill(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.columnFill());
    }
    static void extractColumnFillSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.columnFill());
    }
    static RefPtr<CSSValue> extractColumnGap(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GapGutter>(extractorState, extractorState.style.columnGap());
    }
    static void extractColumnGapSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GapGutter>(extractorState, builder, context, extractorState.style.columnGap());
    }
    static RefPtr<CSSValue> extractColumnRuleColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyColumnRuleColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.columnRuleColor());
    }
    static void extractColumnRuleColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyColumnRuleColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.columnRuleColor());
    }
    static RefPtr<CSSValue> extractColumnRuleStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.columnRuleStyle());
    }
    static void extractColumnRuleStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.columnRuleStyle());
    }
    static RefPtr<CSSValue> extractColumnRuleWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<LineWidth>(extractorState, extractorState.style.columnRuleWidth());
    }
    static void extractColumnRuleWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<LineWidth>(extractorState, builder, context, extractorState.style.columnRuleWidth());
    }
    static RefPtr<CSSValue> extractColumnSpan(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.columnSpan());
    }
    static void extractColumnSpanSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.columnSpan());
    }
    static RefPtr<CSSValue> extractColumnWidth(ExtractorState& extractorState)
    {
        if (extractorState.style.hasAutoColumnWidth())
            return CSSPrimitiveValue::create(CSSValueAuto);
        return ExtractorConverter::convertComputedLength<float>(extractorState, extractorState.style.columnWidth());
    }
    static void extractColumnWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.style.hasAutoColumnWidth()) {
            builder.append(nameLiteralForSerialization(CSSValueAuto));
            return;
        }
        ExtractorSerializer::serializeComputedLength<float>(extractorState, builder, context, extractorState.style.columnWidth());
    }
    static RefPtr<CSSValue> extractContain(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertContain(extractorState, extractorState.style.contain());
    }
    static void extractContainSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeContain(extractorState, builder, context, extractorState.style.contain());
    }
    static RefPtr<CSSValue> extractContainerName(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ContainerNames>(extractorState, extractorState.style.containerNames());
    }
    static void extractContainerNameSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ContainerNames>(extractorState, builder, context, extractorState.style.containerNames());
    }
    static RefPtr<CSSValue> extractContainerType(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.containerType());
    }
    static void extractContainerTypeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.containerType());
    }
    static RefPtr<CSSValue> extractContentVisibility(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.contentVisibility());
    }
    static void extractContentVisibilitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.contentVisibility());
    }
    static RefPtr<CSSValue> extractContinue(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.overflowContinue());
    }
    static void extractContinueSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.overflowContinue());
    }
    static RefPtr<CSSValue> extractCursor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Cursor>(extractorState, extractorState.style.cursor());
    }
    static void extractCursorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Cursor>(extractorState, builder, context, extractorState.style.cursor());
    }
    static RefPtr<CSSValue> extractCx(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGCenterCoordinateComponent>(extractorState, extractorState.style.cx());
    }
    static void extractCxSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGCenterCoordinateComponent>(extractorState, builder, context, extractorState.style.cx());
    }
    static RefPtr<CSSValue> extractCy(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGCenterCoordinateComponent>(extractorState, extractorState.style.cy());
    }
    static void extractCySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGCenterCoordinateComponent>(extractorState, builder, context, extractorState.style.cy());
    }
    static RefPtr<CSSValue> extractD(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertDPath(extractorState, extractorState.style.d());
    }
    static void extractDSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeDPath(extractorState, builder, context, extractorState.style.d());
    }
    static RefPtr<CSSValue> extractDominantBaseline(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().dominantBaseline());
    }
    static void extractDominantBaselineSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().dominantBaseline());
    }
    static RefPtr<CSSValue> extractDynamicRangeLimit(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<DynamicRangeLimit>(extractorState, extractorState.style.dynamicRangeLimit());
    }
    static void extractDynamicRangeLimitSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<DynamicRangeLimit>(extractorState, builder, context, extractorState.style.dynamicRangeLimit());
    }
    static RefPtr<CSSValue> extractEmptyCells(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.emptyCells());
    }
    static void extractEmptyCellsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.emptyCells());
    }
    static RefPtr<CSSValue> extractFieldSizing(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.fieldSizing());
    }
    static void extractFieldSizingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.fieldSizing());
    }
    static RefPtr<CSSValue> extractFill(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGPaint>(extractorState, extractorState.style.svgStyle().fill());
    }
    static void extractFillSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGPaint>(extractorState, builder, context, extractorState.style.svgStyle().fill());
    }
    static RefPtr<CSSValue> extractFillOpacity(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Opacity>(extractorState, extractorState.style.svgStyle().fillOpacity());
    }
    static void extractFillOpacitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Opacity>(extractorState, builder, context, extractorState.style.svgStyle().fillOpacity());
    }
    static RefPtr<CSSValue> extractFillRule(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().fillRule());
    }
    static void extractFillRuleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().fillRule());
    }
    static RefPtr<CSSValue> extractFilter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFilterOperations(extractorState, extractorState.style.filter());
    }
    static void extractFilterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFilterOperations(extractorState, builder, context, extractorState.style.filter());
    }
    static RefPtr<CSSValue> extractFlexBasis(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<FlexBasis>(extractorState, extractorState.style.flexBasis());
    }
    static void extractFlexBasisSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<FlexBasis>(extractorState, builder, context, extractorState.style.flexBasis());
    }
    static RefPtr<CSSValue> extractFlexDirection(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.flexDirection());
    }
    static void extractFlexDirectionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.flexDirection());
    }
    static RefPtr<CSSValue> extractFlexGrow(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.flexGrow());
    }
    static void extractFlexGrowSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.flexGrow());
    }
    static RefPtr<CSSValue> extractFlexShrink(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.flexShrink());
    }
    static void extractFlexShrinkSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.flexShrink());
    }
    static RefPtr<CSSValue> extractFlexWrap(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.flexWrap());
    }
    static void extractFlexWrapSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.flexWrap());
    }
    static RefPtr<CSSValue> extractFloodColor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.svgStyle().floodColor());
    }
    static void extractFloodColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.svgStyle().floodColor());
    }
    static RefPtr<CSSValue> extractFloodOpacity(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Opacity>(extractorState, extractorState.style.svgStyle().floodOpacity());
    }
    static void extractFloodOpacitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Opacity>(extractorState, builder, context, extractorState.style.svgStyle().floodOpacity());
    }
    static RefPtr<CSSValue> extractGlyphOrientationHorizontal(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertGlyphOrientation(extractorState, extractorState.style.svgStyle().glyphOrientationHorizontal());
    }
    static void extractGlyphOrientationHorizontalSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeGlyphOrientation(extractorState, builder, context, extractorState.style.svgStyle().glyphOrientationHorizontal());
    }
    static RefPtr<CSSValue> extractGlyphOrientationVertical(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertGlyphOrientationOrAuto(extractorState, extractorState.style.svgStyle().glyphOrientationVertical());
    }
    static void extractGlyphOrientationVerticalSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeGlyphOrientationOrAuto(extractorState, builder, context, extractorState.style.svgStyle().glyphOrientationVertical());
    }
    static RefPtr<CSSValue> extractGridAutoColumns(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GridTrackSizes>(extractorState, extractorState.style.gridAutoColumns());
    }
    static void extractGridAutoColumnsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GridTrackSizes>(extractorState, builder, context, extractorState.style.gridAutoColumns());
    }
    static RefPtr<CSSValue> extractGridAutoFlow(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertGridAutoFlow(extractorState, extractorState.style.gridAutoFlow());
    }
    static void extractGridAutoFlowSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeGridAutoFlow(extractorState, builder, context, extractorState.style.gridAutoFlow());
    }
    static RefPtr<CSSValue> extractGridAutoRows(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GridTrackSizes>(extractorState, extractorState.style.gridAutoRows());
    }
    static void extractGridAutoRowsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GridTrackSizes>(extractorState, builder, context, extractorState.style.gridAutoRows());
    }
    static RefPtr<CSSValue> extractGridColumnEnd(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GridPosition>(extractorState, extractorState.style.gridItemColumnEnd());
    }
    static void extractGridColumnEndSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GridPosition>(extractorState, builder, context, extractorState.style.gridItemColumnEnd());
    }
    static RefPtr<CSSValue> extractGridColumnStart(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GridPosition>(extractorState, extractorState.style.gridItemColumnStart());
    }
    static void extractGridColumnStartSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GridPosition>(extractorState, builder, context, extractorState.style.gridItemColumnStart());
    }
    static RefPtr<CSSValue> extractGridRowEnd(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GridPosition>(extractorState, extractorState.style.gridItemRowEnd());
    }
    static void extractGridRowEndSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GridPosition>(extractorState, builder, context, extractorState.style.gridItemRowEnd());
    }
    static RefPtr<CSSValue> extractGridRowStart(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GridPosition>(extractorState, extractorState.style.gridItemRowStart());
    }
    static void extractGridRowStartSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GridPosition>(extractorState, builder, context, extractorState.style.gridItemRowStart());
    }
    static RefPtr<CSSValue> extractGridTemplateAreas(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GridTemplateAreas>(extractorState, extractorState.style.gridTemplateAreas());
    }
    static void extractGridTemplateAreasSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GridTemplateAreas>(extractorState, builder, context, extractorState.style.gridTemplateAreas());
    }
    static RefPtr<CSSValue> extractHangingPunctuation(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertHangingPunctuation(extractorState, extractorState.style.hangingPunctuation());
    }
    static void extractHangingPunctuationSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeHangingPunctuation(extractorState, builder, context, extractorState.style.hangingPunctuation());
    }
    static RefPtr<CSSValue> extractHyphenateCharacter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<HyphenateCharacter>(extractorState, extractorState.style.hyphenateCharacter());
    }
    static void extractHyphenateCharacterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<HyphenateCharacter>(extractorState, builder, context, extractorState.style.hyphenateCharacter());
    }
    static RefPtr<CSSValue> extractHyphens(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.hyphens());
    }
    static void extractHyphensSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.hyphens());
    }
    static RefPtr<CSSValue> extractImageOrientation(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertImageOrientation(extractorState, extractorState.style.imageOrientation());
    }
    static void extractImageOrientationSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeImageOrientation(extractorState, builder, context, extractorState.style.imageOrientation());
    }
    static RefPtr<CSSValue> extractImageRendering(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.imageRendering());
    }
    static void extractImageRenderingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.imageRendering());
    }
    static RefPtr<CSSValue> extractInputSecurity(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.inputSecurity());
    }
    static void extractInputSecuritySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.inputSecurity());
    }
    static RefPtr<CSSValue> extractIsolation(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.isolation());
    }
    static void extractIsolationSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.isolation());
    }
    static RefPtr<CSSValue> extractJustifyContent(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertContentAlignmentData(extractorState, extractorState.style.justifyContent());
    }
    static void extractJustifyContentSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeContentAlignmentData(extractorState, builder, context, extractorState.style.justifyContent());
    }
    static RefPtr<CSSValue> extractJustifyItems(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSelfOrDefaultAlignmentData(extractorState, extractorState.style.justifyItems());
    }
    static void extractJustifyItemsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSelfOrDefaultAlignmentData(extractorState, builder, context, extractorState.style.justifyItems());
    }
    static RefPtr<CSSValue> extractJustifySelf(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSelfOrDefaultAlignmentData(extractorState, extractorState.style.justifySelf());
    }
    static void extractJustifySelfSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSelfOrDefaultAlignmentData(extractorState, builder, context, extractorState.style.justifySelf());
    }
    static RefPtr<CSSValue> extractLightingColor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.svgStyle().lightingColor());
    }
    static void extractLightingColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.svgStyle().lightingColor());
    }
    static RefPtr<CSSValue> extractLineBreak(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.lineBreak());
    }
    static void extractLineBreakSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.lineBreak());
    }
    static RefPtr<CSSValue> extractLineFitEdge(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertLineFitEdge(extractorState, extractorState.style.lineFitEdge());
    }
    static void extractLineFitEdgeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeLineFitEdge(extractorState, builder, context, extractorState.style.lineFitEdge());
    }
    static RefPtr<CSSValue> extractListStyleImage(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertImageOrNone(extractorState, extractorState.style.listStyleImage());
    }
    static void extractListStyleImageSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeImageOrNone(extractorState, builder, context, extractorState.style.listStyleImage());
    }
    static RefPtr<CSSValue> extractListStylePosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.listStylePosition());
    }
    static void extractListStylePositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.listStylePosition());
    }
    static RefPtr<CSSValue> extractListStyleType(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ListStyleType>(extractorState, extractorState.style.listStyleType());
    }
    static void extractListStyleTypeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ListStyleType>(extractorState, builder, context, extractorState.style.listStyleType());
    }
    static RefPtr<CSSValue> extractMarginTrim(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertMarginTrim(extractorState, extractorState.style.marginTrim());
    }
    static void extractMarginTrimSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeMarginTrim(extractorState, builder, context, extractorState.style.marginTrim());
    }
    static RefPtr<CSSValue> extractMarkerEnd(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSVGURIReference(extractorState, extractorState.style.svgStyle().markerEndResource());
    }
    static void extractMarkerEndSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSVGURIReference(extractorState, builder, context, extractorState.style.svgStyle().markerEndResource());
    }
    static RefPtr<CSSValue> extractMarkerMid(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSVGURIReference(extractorState, extractorState.style.svgStyle().markerMidResource());
    }
    static void extractMarkerMidSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSVGURIReference(extractorState, builder, context, extractorState.style.svgStyle().markerMidResource());
    }
    static RefPtr<CSSValue> extractMarkerStart(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSVGURIReference(extractorState, extractorState.style.svgStyle().markerStartResource());
    }
    static void extractMarkerStartSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSVGURIReference(extractorState, builder, context, extractorState.style.svgStyle().markerStartResource());
    }
    static RefPtr<CSSValue> extractMaskBorderSource(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertImageOrNone(extractorState, extractorState.style.maskBorderSource());
    }
    static void extractMaskBorderSourceSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeImageOrNone(extractorState, builder, context, extractorState.style.maskBorderSource());
    }
    static RefPtr<CSSValue> extractMaskClip(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerClip(extractorState, layer.clip());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractMaskClipSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerClip(extractorState, builder, context, layer.clip());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractMaskComposite(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerMaskComposite(extractorState, layer.composite());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractMaskCompositeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerMaskComposite(extractorState, builder, context, layer.composite());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractMaskImage(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerImage(extractorState, layer.image());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractMaskImageSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerImage(extractorState, builder, context, layer.image());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractMaskMode(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerMaskMode(extractorState, layer.maskMode());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractMaskModeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerMaskMode(extractorState, builder, context, layer.maskMode());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractMaskOrigin(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerOrigin(extractorState, layer.origin());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractMaskOriginSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerOrigin(extractorState, builder, context, layer.origin());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractMaskRepeat(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerRepeat(extractorState, layer.repeat());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractMaskRepeatSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerRepeat(extractorState, builder, context, layer.repeat());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractMaskSize(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerMaskSize(extractorState, layer.size());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractMaskSizeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerMaskSize(extractorState, builder, context, layer.size());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractMaskType(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().maskType());
    }
    static void extractMaskTypeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().maskType());
    }
    static RefPtr<CSSValue> extractMathStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.mathStyle());
    }
    static void extractMathStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.mathStyle());
    }
    static RefPtr<CSSValue> extractMaxLines(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<MaximumLines>(extractorState, extractorState.style.maxLines());
    }
    static void extractMaxLinesSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<MaximumLines>(extractorState, builder, context, extractorState.style.maxLines());
    }
    static RefPtr<CSSValue> extractMixBlendMode(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.blendMode());
    }
    static void extractMixBlendModeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.blendMode());
    }
    static RefPtr<CSSValue> extractObjectFit(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.objectFit());
    }
    static void extractObjectFitSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.objectFit());
    }
    static RefPtr<CSSValue> extractObjectPosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ObjectPosition>(extractorState, extractorState.style.objectPosition());
    }
    static void extractObjectPositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ObjectPosition>(extractorState, builder, context, extractorState.style.objectPosition());
    }
    static RefPtr<CSSValue> extractOffsetAnchor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<OffsetAnchor>(extractorState, extractorState.style.offsetAnchor());
    }
    static void extractOffsetAnchorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<OffsetAnchor>(extractorState, builder, context, extractorState.style.offsetAnchor());
    }
    static RefPtr<CSSValue> extractOffsetDistance(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<OffsetDistance>(extractorState, extractorState.style.offsetDistance());
    }
    static void extractOffsetDistanceSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<OffsetDistance>(extractorState, builder, context, extractorState.style.offsetDistance());
    }
    static RefPtr<CSSValue> extractOffsetPath(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<OffsetPath>(extractorState, extractorState.style.offsetPath());
    }
    static void extractOffsetPathSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<OffsetPath>(extractorState, builder, context, extractorState.style.offsetPath());
    }
    static RefPtr<CSSValue> extractOffsetPosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<OffsetPosition>(extractorState, extractorState.style.offsetPosition());
    }
    static void extractOffsetPositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<OffsetPosition>(extractorState, builder, context, extractorState.style.offsetPosition());
    }
    static RefPtr<CSSValue> extractOffsetRotate(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<OffsetRotate>(extractorState, extractorState.style.offsetRotate());
    }
    static void extractOffsetRotateSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<OffsetRotate>(extractorState, builder, context, extractorState.style.offsetRotate());
    }
    static RefPtr<CSSValue> extractOpacity(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Opacity>(extractorState, extractorState.style.opacity());
    }
    static void extractOpacitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Opacity>(extractorState, builder, context, extractorState.style.opacity());
    }
    static RefPtr<CSSValue> extractOrder(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.order());
    }
    static void extractOrderSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.order());
    }
    static RefPtr<CSSValue> extractOrphans(ExtractorState& extractorState)
    {
        if (extractorState.style.hasAutoOrphans())
            return CSSPrimitiveValue::create(CSSValueAuto);
        return ExtractorConverter::convert(extractorState, extractorState.style.orphans());
    }
    static void extractOrphansSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.style.hasAutoOrphans()) {
            builder.append(nameLiteralForSerialization(CSSValueAuto));
            return;
        }
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.orphans());
    }
    static RefPtr<CSSValue> extractOutlineColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyOutlineColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.outlineColor());
    }
    static void extractOutlineColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyOutlineColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.outlineColor());
    }
    static RefPtr<CSSValue> extractOutlineOffset(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Length<>>(extractorState, extractorState.style.outlineOffset());
    }
    static void extractOutlineOffsetSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Length<>>(extractorState, builder, context, extractorState.style.outlineOffset());
    }
    static RefPtr<CSSValue> extractOutlineStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.outlineStyle());
    }
    static void extractOutlineStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.outlineStyle());
    }
    static RefPtr<CSSValue> extractOutlineWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<LineWidth>(extractorState, extractorState.style.outlineWidth());
    }
    static void extractOutlineWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<LineWidth>(extractorState, builder, context, extractorState.style.outlineWidth());
    }
    static RefPtr<CSSValue> extractOverflowAnchor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.overflowAnchor());
    }
    static void extractOverflowAnchorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.overflowAnchor());
    }
    static RefPtr<CSSValue> extractOverflowWrap(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.overflowWrap());
    }
    static void extractOverflowWrapSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.overflowWrap());
    }
    static RefPtr<CSSValue> extractPaintOrder(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertPaintOrder(extractorState, extractorState.style.paintOrder());
    }
    static void extractPaintOrderSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializePaintOrder(extractorState, builder, context, extractorState.style.paintOrder());
    }
    static RefPtr<CSSValue> extractPerspective(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Perspective>(extractorState, extractorState.style.perspective());
    }
    static void extractPerspectiveSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Perspective>(extractorState, builder, context, extractorState.style.perspective());
    }
    static RefPtr<CSSValue> extractPointerEvents(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.pointerEvents());
    }
    static void extractPointerEventsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.pointerEvents());
    }
    static RefPtr<CSSValue> extractPosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.position());
    }
    static void extractPositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.position());
    }
    static RefPtr<CSSValue> extractPositionAnchor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertPositionAnchor(extractorState, extractorState.style.positionAnchor());
    }
    static void extractPositionAnchorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializePositionAnchor(extractorState, builder, context, extractorState.style.positionAnchor());
    }
    static RefPtr<CSSValue> extractPositionArea(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertPositionArea(extractorState, extractorState.style.positionArea());
    }
    static void extractPositionAreaSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializePositionArea(extractorState, builder, context, extractorState.style.positionArea());
    }
    static RefPtr<CSSValue> extractPositionTryFallbacks(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertPositionTryFallbacks(extractorState, extractorState.style.positionTryFallbacks());
    }
    static void extractPositionTryFallbacksSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializePositionTryFallbacks(extractorState, builder, context, extractorState.style.positionTryFallbacks());
    }
    static RefPtr<CSSValue> extractPositionTryOrder(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.positionTryOrder());
    }
    static void extractPositionTryOrderSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.positionTryOrder());
    }
    static RefPtr<CSSValue> extractPositionVisibility(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertPositionVisibility(extractorState, extractorState.style.positionVisibility());
    }
    static void extractPositionVisibilitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializePositionVisibility(extractorState, builder, context, extractorState.style.positionVisibility());
    }
    static RefPtr<CSSValue> extractPrintColorAdjust(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.printColorAdjust());
    }
    static void extractPrintColorAdjustSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.printColorAdjust());
    }
    static RefPtr<CSSValue> extractQuotes(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Quotes>(extractorState, extractorState.style.quotes());
    }
    static void extractQuotesSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Quotes>(extractorState, builder, context, extractorState.style.quotes());
    }
    static RefPtr<CSSValue> extractR(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGRadius>(extractorState, extractorState.style.r());
    }
    static void extractRSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGRadius>(extractorState, builder, context, extractorState.style.r());
    }
    static RefPtr<CSSValue> extractResize(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.resize());
    }
    static void extractResizeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.resize());
    }
    static RefPtr<CSSValue> extractRowGap(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<GapGutter>(extractorState, extractorState.style.rowGap());
    }
    static void extractRowGapSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<GapGutter>(extractorState, builder, context, extractorState.style.rowGap());
    }
    static RefPtr<CSSValue> extractRubyAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.rubyAlign());
    }
    static void extractRubyAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.rubyAlign());
    }
    static RefPtr<CSSValue> extractRubyOverhang(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.rubyOverhang());
    }
    static void extractRubyOverhangSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.rubyOverhang());
    }
    static RefPtr<CSSValue> extractRx(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGRadiusComponent>(extractorState, extractorState.style.rx());
    }
    static void extractRxSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGRadiusComponent>(extractorState, builder, context, extractorState.style.rx());
    }
    static RefPtr<CSSValue> extractRy(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGRadiusComponent>(extractorState, extractorState.style.ry());
    }
    static void extractRySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGRadiusComponent>(extractorState, builder, context, extractorState.style.ry());
    }
    static RefPtr<CSSValue> extractScrollBehavior(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.scrollBehavior());
    }
    static void extractScrollBehaviorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.scrollBehavior());
    }
    static RefPtr<CSSValue> extractScrollSnapAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertScrollSnapAlign(extractorState, extractorState.style.scrollSnapAlign());
    }
    static void extractScrollSnapAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeScrollSnapAlign(extractorState, builder, context, extractorState.style.scrollSnapAlign());
    }
    static RefPtr<CSSValue> extractScrollSnapStop(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.scrollSnapStop());
    }
    static void extractScrollSnapStopSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.scrollSnapStop());
    }
    static RefPtr<CSSValue> extractScrollSnapType(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertScrollSnapType(extractorState, extractorState.style.scrollSnapType());
    }
    static void extractScrollSnapTypeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeScrollSnapType(extractorState, builder, context, extractorState.style.scrollSnapType());
    }
    static RefPtr<CSSValue> extractScrollTimelineAxis(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ProgressTimelineAxes>(extractorState, extractorState.style.scrollTimelineAxes());
    }
    static void extractScrollTimelineAxisSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ProgressTimelineAxes>(extractorState, builder, context, extractorState.style.scrollTimelineAxes());
    }
    static RefPtr<CSSValue> extractScrollTimelineName(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ProgressTimelineNames>(extractorState, extractorState.style.scrollTimelineNames());
    }
    static void extractScrollTimelineNameSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ProgressTimelineNames>(extractorState, builder, context, extractorState.style.scrollTimelineNames());
    }
    static RefPtr<CSSValue> extractScrollbarColor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollbarColor>(extractorState, extractorState.style.scrollbarColor());
    }
    static void extractScrollbarColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollbarColor>(extractorState, builder, context, extractorState.style.scrollbarColor());
    }
    static RefPtr<CSSValue> extractScrollbarGutter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollbarGutter>(extractorState, extractorState.style.scrollbarGutter());
    }
    static void extractScrollbarGutterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollbarGutter>(extractorState, builder, context, extractorState.style.scrollbarGutter());
    }
    static RefPtr<CSSValue> extractScrollbarWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.scrollbarWidth());
    }
    static void extractScrollbarWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.scrollbarWidth());
    }
    static RefPtr<CSSValue> extractShapeImageThreshold(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ShapeImageThreshold>(extractorState, extractorState.style.shapeImageThreshold());
    }
    static void extractShapeImageThresholdSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ShapeImageThreshold>(extractorState, builder, context, extractorState.style.shapeImageThreshold());
    }
    static RefPtr<CSSValue> extractShapeMargin(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ShapeMargin>(extractorState, extractorState.style.shapeMargin());
    }
    static void extractShapeMarginSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ShapeMargin>(extractorState, builder, context, extractorState.style.shapeMargin());
    }
    static RefPtr<CSSValue> extractShapeOutside(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ShapeOutside>(extractorState, extractorState.style.shapeOutside());
    }
    static void extractShapeOutsideSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ShapeOutside>(extractorState, builder, context, extractorState.style.shapeOutside());
    }
    static RefPtr<CSSValue> extractShapeRendering(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().shapeRendering());
    }
    static void extractShapeRenderingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().shapeRendering());
    }
    static RefPtr<CSSValue> extractSpeakAs(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertSpeakAs(extractorState, extractorState.style.speakAs());
    }
    static void extractSpeakAsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeSpeakAs(extractorState, builder, context, extractorState.style.speakAs());
    }
    static RefPtr<CSSValue> extractStopColor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.svgStyle().stopColor());
    }
    static void extractStopColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.svgStyle().stopColor());
    }
    static RefPtr<CSSValue> extractStopOpacity(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Opacity>(extractorState, extractorState.style.svgStyle().stopOpacity());
    }
    static void extractStopOpacitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Opacity>(extractorState, builder, context, extractorState.style.svgStyle().stopOpacity());
    }
    static RefPtr<CSSValue> extractStroke(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGPaint>(extractorState, extractorState.style.svgStyle().stroke());
    }
    static void extractStrokeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGPaint>(extractorState, builder, context, extractorState.style.svgStyle().stroke());
    }
    static RefPtr<CSSValue> extractStrokeColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyStrokeColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.strokeColor());
    }
    static void extractStrokeColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyStrokeColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.strokeColor());
    }
    static RefPtr<CSSValue> extractStrokeDasharray(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGStrokeDasharray>(extractorState, extractorState.style.svgStyle().strokeDashArray());
    }
    static void extractStrokeDasharraySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGStrokeDasharray>(extractorState, builder, context, extractorState.style.svgStyle().strokeDashArray());
    }
    static RefPtr<CSSValue> extractStrokeDashoffset(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGStrokeDashoffset>(extractorState, extractorState.style.strokeDashOffset());
    }
    static void extractStrokeDashoffsetSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGStrokeDashoffset>(extractorState, builder, context, extractorState.style.strokeDashOffset());
    }
    static RefPtr<CSSValue> extractStrokeLinecap(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.capStyle());
    }
    static void extractStrokeLinecapSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.capStyle());
    }
    static RefPtr<CSSValue> extractStrokeLinejoin(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.joinStyle());
    }
    static void extractStrokeLinejoinSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.joinStyle());
    }
    static RefPtr<CSSValue> extractStrokeMiterlimit(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<StrokeMiterlimit>(extractorState, extractorState.style.strokeMiterLimit());
    }
    static void extractStrokeMiterlimitSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<StrokeMiterlimit>(extractorState, builder, context, extractorState.style.strokeMiterLimit());
    }
    static RefPtr<CSSValue> extractStrokeOpacity(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Opacity>(extractorState, extractorState.style.svgStyle().strokeOpacity());
    }
    static void extractStrokeOpacitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Opacity>(extractorState, builder, context, extractorState.style.svgStyle().strokeOpacity());
    }
    static RefPtr<CSSValue> extractStrokeWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<StrokeWidth>(extractorState, extractorState.style.strokeWidth());
    }
    static void extractStrokeWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<StrokeWidth>(extractorState, builder, context, extractorState.style.strokeWidth());
    }
    static RefPtr<CSSValue> extractTabSize(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTabSize(extractorState, extractorState.style.tabSize());
    }
    static void extractTabSizeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTabSize(extractorState, builder, context, extractorState.style.tabSize());
    }
    static RefPtr<CSSValue> extractTableLayout(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.tableLayout());
    }
    static void extractTableLayoutSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.tableLayout());
    }
    static RefPtr<CSSValue> extractTextAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textAlign());
    }
    static void extractTextAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textAlign());
    }
    static RefPtr<CSSValue> extractTextAlignLast(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textAlignLast());
    }
    static void extractTextAlignLastSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textAlignLast());
    }
    static RefPtr<CSSValue> extractTextAnchor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().textAnchor());
    }
    static void extractTextAnchorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().textAnchor());
    }
    static RefPtr<CSSValue> extractTextBoxEdge(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextBoxEdge(extractorState, extractorState.style.textBoxEdge());
    }
    static void extractTextBoxEdgeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextBoxEdge(extractorState, builder, context, extractorState.style.textBoxEdge());
    }
    static RefPtr<CSSValue> extractTextBoxTrim(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textBoxTrim());
    }
    static void extractTextBoxTrimSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textBoxTrim());
    }
    static RefPtr<CSSValue> extractTextCombineUpright(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textCombine());
    }
    static void extractTextCombineUprightSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textCombine());
    }
    static RefPtr<CSSValue> extractTextDecorationColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyTextDecorationColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.textDecorationColor());
    }
    static void extractTextDecorationColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyTextDecorationColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.textDecorationColor());
    }
    static RefPtr<CSSValue> extractTextDecorationLine(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextDecorationLine(extractorState, extractorState.style.textDecorationLine());
    }
    static void extractTextDecorationLineSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextDecorationLine(extractorState, builder, context, extractorState.style.textDecorationLine());
    }
    static RefPtr<CSSValue> extractTextDecorationSkipInk(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textDecorationSkipInk());
    }
    static void extractTextDecorationSkipInkSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textDecorationSkipInk());
    }
    static RefPtr<CSSValue> extractTextDecorationStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textDecorationStyle());
    }
    static void extractTextDecorationStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textDecorationStyle());
    }
    static RefPtr<CSSValue> extractTextDecorationThickness(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<TextDecorationThickness>(extractorState, extractorState.style.textDecorationThickness());
    }
    static void extractTextDecorationThicknessSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<TextDecorationThickness>(extractorState, builder, context, extractorState.style.textDecorationThickness());
    }
    static RefPtr<CSSValue> extractTextEmphasisColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyTextEmphasisColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.textEmphasisColor());
    }
    static void extractTextEmphasisColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyTextEmphasisColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.textEmphasisColor());
    }
    static RefPtr<CSSValue> extractTextEmphasisPosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextEmphasisPosition(extractorState, extractorState.style.textEmphasisPosition());
    }
    static void extractTextEmphasisPositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextEmphasisPosition(extractorState, builder, context, extractorState.style.textEmphasisPosition());
    }
    static RefPtr<CSSValue> extractTextEmphasisStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<TextEmphasisStyle>(extractorState, extractorState.style.textEmphasisStyle());
    }
    static void extractTextEmphasisStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<TextEmphasisStyle>(extractorState, builder, context, extractorState.style.textEmphasisStyle());
    }
    static RefPtr<CSSValue> extractTextGroupAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textGroupAlign());
    }
    static void extractTextGroupAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textGroupAlign());
    }
    static RefPtr<CSSValue> extractTextIndent(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<TextIndent>(extractorState, extractorState.style.textIndent());
    }
    static void extractTextIndentSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<TextIndent>(extractorState, builder, context, extractorState.style.textIndent());
    }
    static RefPtr<CSSValue> extractTextJustify(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textJustify());
    }
    static void extractTextJustifySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textJustify());
    }
    static RefPtr<CSSValue> extractTextOverflow(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textOverflow());
    }
    static void extractTextOverflowSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textOverflow());
    }
    static RefPtr<CSSValue> extractTextShadow(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<TextShadows>(extractorState, extractorState.style.textShadow());
    }
    static void extractTextShadowSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<TextShadows>(extractorState, builder, context, extractorState.style.textShadow());
    }
    static RefPtr<CSSValue> extractTextTransform(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextTransform(extractorState, extractorState.style.textTransform());
    }
    static void extractTextTransformSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextTransform(extractorState, builder, context, extractorState.style.textTransform());
    }
    static RefPtr<CSSValue> extractTextUnderlineOffset(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<TextUnderlineOffset>(extractorState, extractorState.style.textUnderlineOffset());
    }
    static void extractTextUnderlineOffsetSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<TextUnderlineOffset>(extractorState, builder, context, extractorState.style.textUnderlineOffset());
    }
    static RefPtr<CSSValue> extractTextUnderlinePosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextUnderlinePosition(extractorState, extractorState.style.textUnderlinePosition());
    }
    static void extractTextUnderlinePositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextUnderlinePosition(extractorState, builder, context, extractorState.style.textUnderlinePosition());
    }
    static RefPtr<CSSValue> extractTextWrapMode(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textWrapMode());
    }
    static void extractTextWrapModeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textWrapMode());
    }
    static RefPtr<CSSValue> extractTextWrapStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textWrapStyle());
    }
    static void extractTextWrapStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textWrapStyle());
    }
    static RefPtr<CSSValue> extractTimelineScope(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertNameScope(extractorState, extractorState.style.timelineScope());
    }
    static void extractTimelineScopeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeNameScope(extractorState, builder, context, extractorState.style.timelineScope());
    }
    static RefPtr<CSSValue> extractTouchAction(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTouchAction(extractorState, extractorState.style.touchActions());
    }
    static void extractTouchActionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTouchAction(extractorState, builder, context, extractorState.style.touchActions());
    }
    static RefPtr<CSSValue> extractTransformBox(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.transformBox());
    }
    static void extractTransformBoxSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.transformBox());
    }
    static RefPtr<CSSValue> extractTransformStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.transformStyle3D());
    }
    static void extractTransformStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.transformStyle3D());
    }
    static RefPtr<CSSValue> extractTransitionBehavior(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationAllowsDiscreteTransitions(extractorState, Animation::initialAllowsDiscreteTransitions(), animation, animationList);
            }
            if (!animation->isAllowsDiscreteTransitionsFilled()) {
                return ExtractorConverter::convertAnimationAllowsDiscreteTransitions(extractorState, animation->allowsDiscreteTransitions(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.transitions(), mapper);
    }
    static void extractTransitionBehaviorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationAllowsDiscreteTransitions(extractorState, builder, context, Animation::initialAllowsDiscreteTransitions(), animation, animationList);
                return;
            }
            if (!animation->isAllowsDiscreteTransitionsFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationAllowsDiscreteTransitions(extractorState, builder, context, animation->allowsDiscreteTransitions(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.transitions(), mapper);
    }
    static RefPtr<CSSValue> extractTransitionDelay(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationDelay(extractorState, Animation::initialDelay(), animation, animationList);
            }
            if (!animation->isDelayFilled()) {
                return ExtractorConverter::convertAnimationDelay(extractorState, animation->delay(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.transitions(), mapper);
    }
    static void extractTransitionDelaySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDelay(extractorState, builder, context, Animation::initialDelay(), animation, animationList);
                return;
            }
            if (!animation->isDelayFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDelay(extractorState, builder, context, animation->delay(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.transitions(), mapper);
    }
    static RefPtr<CSSValue> extractTransitionDuration(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationDuration(extractorState, Animation::initialDuration(), animation, animationList);
            }
            if (!animation->isDurationFilled()) {
                return ExtractorConverter::convertAnimationDuration(extractorState, animation->duration(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.transitions(), mapper);
    }
    static void extractTransitionDurationSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDuration(extractorState, builder, context, Animation::initialDuration(), animation, animationList);
                return;
            }
            if (!animation->isDurationFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationDuration(extractorState, builder, context, animation->duration(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.transitions(), mapper);
    }
    static RefPtr<CSSValue> extractTransitionProperty(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationProperty(extractorState, Animation::initialProperty(), animation, animationList);
            }
            if (!animation->isPropertyFilled()) {
                return ExtractorConverter::convertAnimationProperty(extractorState, animation->property(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.transitions(), mapper);
    }
    static void extractTransitionPropertySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationProperty(extractorState, builder, context, Animation::initialProperty(), animation, animationList);
                return;
            }
            if (!animation->isPropertyFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationProperty(extractorState, builder, context, animation->property(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.transitions(), mapper);
    }
    static RefPtr<CSSValue> extractTransitionTimingFunction(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, const Animation* animation, const AnimationList* animationList) -> RefPtr<CSSValue> {
            if (!animation) {
                return ExtractorConverter::convertAnimationTimingFunction(extractorState, Animation::initialTimingFunction(), animation, animationList);
            }
            if (!animation->isTimingFunctionFilled()) {
                return ExtractorConverter::convertAnimationTimingFunction(extractorState, animation->timingFunction(), animation, animationList);
            }
            return nullptr;
        };
        return extractAnimationOrTransitionValue(extractorState, extractorState.style.transitions(), mapper);
    }
    static void extractTransitionTimingFunctionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, const Animation* animation, const AnimationList* animationList) {
            if (!animation) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationTimingFunction(extractorState, builder, context, Animation::initialTimingFunction(), animation, animationList);
                return;
            }
            if (!animation->isTimingFunctionFilled()) {
                if (includeComma)
                    builder.append(", "_s);
                ExtractorSerializer::serializeAnimationTimingFunction(extractorState, builder, context, animation->timingFunction(), animation, animationList);
                return;
            }
        };
        extractAnimationOrTransitionValueSerialization(extractorState, builder, context, extractorState.style.transitions(), mapper);
    }
    static RefPtr<CSSValue> extractUnicodeBidi(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.unicodeBidi());
    }
    static void extractUnicodeBidiSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.unicodeBidi());
    }
    static RefPtr<CSSValue> extractVectorEffect(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.svgStyle().vectorEffect());
    }
    static void extractVectorEffectSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.svgStyle().vectorEffect());
    }
    static RefPtr<CSSValue> extractVerticalAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<VerticalAlign>(extractorState, extractorState.style.verticalAlign());
    }
    static void extractVerticalAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<VerticalAlign>(extractorState, builder, context, extractorState.style.verticalAlign());
    }
    static RefPtr<CSSValue> extractViewTimelineAxis(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ProgressTimelineAxes>(extractorState, extractorState.style.viewTimelineAxes());
    }
    static void extractViewTimelineAxisSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ProgressTimelineAxes>(extractorState, builder, context, extractorState.style.viewTimelineAxes());
    }
    static RefPtr<CSSValue> extractViewTimelineInset(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ViewTimelineInsets>(extractorState, extractorState.style.viewTimelineInsets());
    }
    static void extractViewTimelineInsetSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ViewTimelineInsets>(extractorState, builder, context, extractorState.style.viewTimelineInsets());
    }
    static RefPtr<CSSValue> extractViewTimelineName(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ProgressTimelineNames>(extractorState, extractorState.style.viewTimelineNames());
    }
    static void extractViewTimelineNameSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ProgressTimelineNames>(extractorState, builder, context, extractorState.style.viewTimelineNames());
    }
    static RefPtr<CSSValue> extractViewTransitionClass(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ViewTransitionClasses>(extractorState, extractorState.style.viewTransitionClasses());
    }
    static void extractViewTransitionClassSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ViewTransitionClasses>(extractorState, builder, context, extractorState.style.viewTransitionClasses());
    }
    static RefPtr<CSSValue> extractViewTransitionName(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ViewTransitionName>(extractorState, extractorState.style.viewTransitionName());
    }
    static void extractViewTransitionNameSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ViewTransitionName>(extractorState, builder, context, extractorState.style.viewTransitionName());
    }
    static RefPtr<CSSValue> extractVisibility(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.visibility());
    }
    static void extractVisibilitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.visibility());
    }
    static RefPtr<CSSValue> extractWhiteSpaceCollapse(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.whiteSpaceCollapse());
    }
    static void extractWhiteSpaceCollapseSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.whiteSpaceCollapse());
    }
    static RefPtr<CSSValue> extractWidows(ExtractorState& extractorState)
    {
        if (extractorState.style.hasAutoWidows())
            return CSSPrimitiveValue::create(CSSValueAuto);
        return ExtractorConverter::convert(extractorState, extractorState.style.widows());
    }
    static void extractWidowsSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.style.hasAutoWidows()) {
            builder.append(nameLiteralForSerialization(CSSValueAuto));
            return;
        }
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.widows());
    }
    static RefPtr<CSSValue> extractWillChange(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertWillChange(extractorState, extractorState.style.willChange());
    }
    static void extractWillChangeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeWillChange(extractorState, builder, context, extractorState.style.willChange());
    }
    static RefPtr<CSSValue> extractWordBreak(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.wordBreak());
    }
    static void extractWordBreakSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.wordBreak());
    }
    static RefPtr<CSSValue> extractX(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGCoordinateComponent>(extractorState, extractorState.style.x());
    }
    static void extractXSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGCoordinateComponent>(extractorState, builder, context, extractorState.style.x());
    }
    static RefPtr<CSSValue> extractY(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<SVGCoordinateComponent>(extractorState, extractorState.style.y());
    }
    static void extractYSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<SVGCoordinateComponent>(extractorState, builder, context, extractorState.style.y());
    }
    static RefPtr<CSSValue> extractZIndex(ExtractorState& extractorState)
    {
        if (extractorState.style.hasAutoSpecifiedZIndex())
            return CSSPrimitiveValue::create(CSSValueAuto);
        return ExtractorConverter::convert(extractorState, extractorState.style.specifiedZIndex());
    }
    static void extractZIndexSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.style.hasAutoSpecifiedZIndex()) {
            builder.append(nameLiteralForSerialization(CSSValueAuto));
            return;
        }
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.specifiedZIndex());
    }
    static RefPtr<CSSValue> extractAppleColorFilter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertAppleColorFilterOperations(extractorState, extractorState.style.appleColorFilter());
    }
    static void extractAppleColorFilterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeAppleColorFilterOperations(extractorState, builder, context, extractorState.style.appleColorFilter());
    }
    static RefPtr<CSSValue> extractWebkitBackdropFilter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertFilterOperations(extractorState, extractorState.style.backdropFilter());
    }
    static void extractWebkitBackdropFilterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeFilterOperations(extractorState, builder, context, extractorState.style.backdropFilter());
    }
    static RefPtr<CSSValue> extractWebkitBackgroundClip(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerClip(extractorState, layer.clip());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractWebkitBackgroundClipSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerClip(extractorState, builder, context, layer.clip());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractWebkitBackgroundOrigin(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerOrigin(extractorState, layer.origin());
        };
        return extractFillLayerValue(extractorState, extractorState.style.backgroundLayers(), mapper);
    }
    static void extractWebkitBackgroundOriginSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerOrigin(extractorState, builder, context, layer.origin());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.backgroundLayers(), mapper);
    }
    static RefPtr<CSSValue> extractWebkitBorderHorizontalSpacing(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<WebkitBorderSpacing>(extractorState, extractorState.style.borderHorizontalSpacing());
    }
    static void extractWebkitBorderHorizontalSpacingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<WebkitBorderSpacing>(extractorState, builder, context, extractorState.style.borderHorizontalSpacing());
    }
    static RefPtr<CSSValue> extractWebkitBorderVerticalSpacing(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<WebkitBorderSpacing>(extractorState, extractorState.style.borderVerticalSpacing());
    }
    static void extractWebkitBorderVerticalSpacingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<WebkitBorderSpacing>(extractorState, builder, context, extractorState.style.borderVerticalSpacing());
    }
    static RefPtr<CSSValue> extractWebkitBoxAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxAlign());
    }
    static void extractWebkitBoxAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxAlign());
    }
    static RefPtr<CSSValue> extractWebkitBoxDecorationBreak(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxDecorationBreak());
    }
    static void extractWebkitBoxDecorationBreakSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxDecorationBreak());
    }
    static RefPtr<CSSValue> extractWebkitBoxDirection(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxDirection());
    }
    static void extractWebkitBoxDirectionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxDirection());
    }
    static RefPtr<CSSValue> extractWebkitBoxFlex(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxFlex());
    }
    static void extractWebkitBoxFlexSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxFlex());
    }
    static RefPtr<CSSValue> extractWebkitBoxFlexGroup(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxFlexGroup());
    }
    static void extractWebkitBoxFlexGroupSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxFlexGroup());
    }
    static RefPtr<CSSValue> extractWebkitBoxLines(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxLines());
    }
    static void extractWebkitBoxLinesSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxLines());
    }
    static RefPtr<CSSValue> extractWebkitBoxOrdinalGroup(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxOrdinalGroup());
    }
    static void extractWebkitBoxOrdinalGroupSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxOrdinalGroup());
    }
    static RefPtr<CSSValue> extractWebkitBoxOrient(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxOrient());
    }
    static void extractWebkitBoxOrientSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxOrient());
    }
    static RefPtr<CSSValue> extractWebkitBoxPack(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.boxPack());
    }
    static void extractWebkitBoxPackSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.boxPack());
    }
    static RefPtr<CSSValue> extractWebkitBoxReflect(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertReflection(extractorState, extractorState.style.boxReflect());
    }
    static void extractWebkitBoxReflectSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeReflection(extractorState, builder, context, extractorState.style.boxReflect());
    }
    static RefPtr<CSSValue> extractWebkitBoxShadow(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BoxShadows>(extractorState, extractorState.style.boxShadow());
    }
    static void extractWebkitBoxShadowSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BoxShadows>(extractorState, builder, context, extractorState.style.boxShadow());
    }
    static RefPtr<CSSValue> extractWebkitColumnAxis(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.columnAxis());
    }
    static void extractWebkitColumnAxisSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.columnAxis());
    }
    static RefPtr<CSSValue> extractWebkitColumnProgression(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.columnProgression());
    }
    static void extractWebkitColumnProgressionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.columnProgression());
    }
    static RefPtr<CSSValue> extractWebkitCursorVisibility(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.cursorVisibility());
    }
    static void extractWebkitCursorVisibilitySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.cursorVisibility());
    }
    static RefPtr<CSSValue> extractWebkitHyphenateLimitAfter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<HyphenateLimitEdge>(extractorState, extractorState.style.hyphenateLimitAfter());
    }
    static void extractWebkitHyphenateLimitAfterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<HyphenateLimitEdge>(extractorState, builder, context, extractorState.style.hyphenateLimitAfter());
    }
    static RefPtr<CSSValue> extractWebkitHyphenateLimitBefore(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<HyphenateLimitEdge>(extractorState, extractorState.style.hyphenateLimitBefore());
    }
    static void extractWebkitHyphenateLimitBeforeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<HyphenateLimitEdge>(extractorState, builder, context, extractorState.style.hyphenateLimitBefore());
    }
    static RefPtr<CSSValue> extractWebkitHyphenateLimitLines(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<HyphenateLimitLines>(extractorState, extractorState.style.hyphenateLimitLines());
    }
    static void extractWebkitHyphenateLimitLinesSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<HyphenateLimitLines>(extractorState, builder, context, extractorState.style.hyphenateLimitLines());
    }
    static RefPtr<CSSValue> extractWebkitInitialLetter(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertInitialLetter(extractorState, extractorState.style.initialLetter());
    }
    static void extractWebkitInitialLetterSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeInitialLetter(extractorState, builder, context, extractorState.style.initialLetter());
    }
    static RefPtr<CSSValue> extractWebkitLineAlign(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.lineAlign());
    }
    static void extractWebkitLineAlignSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.lineAlign());
    }
    static RefPtr<CSSValue> extractWebkitLineBoxContain(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertLineBoxContain(extractorState, extractorState.style.lineBoxContain());
    }
    static void extractWebkitLineBoxContainSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeLineBoxContain(extractorState, builder, context, extractorState.style.lineBoxContain());
    }
    static RefPtr<CSSValue> extractWebkitLineClamp(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertLineClamp(extractorState, extractorState.style.lineClamp());
    }
    static void extractWebkitLineClampSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeLineClamp(extractorState, builder, context, extractorState.style.lineClamp());
    }
    static RefPtr<CSSValue> extractWebkitLineGrid(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<WebkitLineGrid>(extractorState, extractorState.style.lineGrid());
    }
    static void extractWebkitLineGridSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<WebkitLineGrid>(extractorState, builder, context, extractorState.style.lineGrid());
    }
    static RefPtr<CSSValue> extractWebkitLineSnap(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.lineSnap());
    }
    static void extractWebkitLineSnapSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.lineSnap());
    }
    static RefPtr<CSSValue> extractWebkitMaskClip(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerClip(extractorState, layer.clip());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractWebkitMaskClipSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerClip(extractorState, builder, context, layer.clip());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractWebkitMaskComposite(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerWebkitMaskComposite(extractorState, layer.composite());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractWebkitMaskCompositeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerWebkitMaskComposite(extractorState, builder, context, layer.composite());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractWebkitMaskPositionX(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertStyleType<FillPositionX>(extractorState, layer.xPosition());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractWebkitMaskPositionXSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeStyleType<FillPositionX>(extractorState, builder, context, layer.xPosition());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractWebkitMaskPositionY(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertStyleType<FillPositionY>(extractorState, layer.yPosition());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractWebkitMaskPositionYSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeStyleType<FillPositionY>(extractorState, builder, context, layer.yPosition());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractWebkitMaskSourceType(ExtractorState& extractorState)
    {
        auto mapper = [](auto& extractorState, auto& layer) -> Ref<CSSValue> {
            return ExtractorConverter::convertFillLayerWebkitMaskSourceType(extractorState, layer.maskMode());
        };
        return extractFillLayerValue(extractorState, extractorState.style.maskLayers(), mapper);
    }
    static void extractWebkitMaskSourceTypeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        auto mapper = [](auto& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, bool includeComma, auto& layer) {
            if (includeComma)
                builder.append(", "_s);
            ExtractorSerializer::serializeFillLayerWebkitMaskSourceType(extractorState, builder, context, layer.maskMode());
        };
        extractFillLayerValueSerialization(extractorState, builder, context, extractorState.style.maskLayers(), mapper);
    }
    static RefPtr<CSSValue> extractWebkitNbspMode(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.nbspMode());
    }
    static void extractWebkitNbspModeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.nbspMode());
    }
    static RefPtr<CSSValue> extractWebkitRtlOrdering(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.rtlOrdering());
    }
    static void extractWebkitRtlOrderingSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.rtlOrdering());
    }
    static RefPtr<CSSValue> extractWebkitRubyPosition(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertWebkitRubyPosition(extractorState, extractorState.style.rubyPosition());
    }
    static void extractWebkitRubyPositionSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeWebkitRubyPosition(extractorState, builder, context, extractorState.style.rubyPosition());
    }
    static RefPtr<CSSValue> extractWebkitTapHighlightColor(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.tapHighlightColor());
    }
    static void extractWebkitTapHighlightColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.tapHighlightColor());
    }
    static RefPtr<CSSValue> extractWebkitTextCombine(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertWebkitTextCombine(extractorState, extractorState.style.textCombine());
    }
    static void extractWebkitTextCombineSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeWebkitTextCombine(extractorState, builder, context, extractorState.style.textCombine());
    }
    static RefPtr<CSSValue> extractWebkitTextDecorationsInEffect(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertTextDecorationLine(extractorState, extractorState.style.textDecorationLineInEffect());
    }
    static void extractWebkitTextDecorationsInEffectSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeTextDecorationLine(extractorState, builder, context, extractorState.style.textDecorationLineInEffect());
    }
    static RefPtr<CSSValue> extractWebkitTextFillColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyWebkitTextFillColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.textFillColor());
    }
    static void extractWebkitTextFillColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyWebkitTextFillColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.textFillColor());
    }
    static RefPtr<CSSValue> extractWebkitTextSecurity(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.textSecurity());
    }
    static void extractWebkitTextSecuritySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.textSecurity());
    }
    static RefPtr<CSSValue> extractWebkitTextStrokeColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyWebkitTextStrokeColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.textStrokeColor());
    }
    static void extractWebkitTextStrokeColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyWebkitTextStrokeColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.textStrokeColor());
    }
    static RefPtr<CSSValue> extractWebkitTextStrokeWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<WebkitTextStrokeWidth>(extractorState, extractorState.style.textStrokeWidth());
    }
    static void extractWebkitTextStrokeWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<WebkitTextStrokeWidth>(extractorState, builder, context, extractorState.style.textStrokeWidth());
    }
    static RefPtr<CSSValue> extractWebkitUserDrag(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.userDrag());
    }
    static void extractWebkitUserDragSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.userDrag());
    }
    static RefPtr<CSSValue> extractWebkitUserModify(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.userModify());
    }
    static void extractWebkitUserModifySerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.userModify());
    }
    static RefPtr<CSSValue> extractWebkitUserSelect(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.userSelect());
    }
    static void extractWebkitUserSelectSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.userSelect());
    }
    static RefPtr<CSSValue> extractBorderBottomColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderBottomColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.borderBottomColor());
    }
    static void extractBorderBottomColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderBottomColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.borderBottomColor());
    }
    static RefPtr<CSSValue> extractBorderBottomLeftRadius(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BorderRadiusValue>(extractorState, extractorState.style.borderBottomLeftRadius());
    }
    static void extractBorderBottomLeftRadiusSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BorderRadiusValue>(extractorState, builder, context, extractorState.style.borderBottomLeftRadius());
    }
    static RefPtr<CSSValue> extractBorderBottomRightRadius(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BorderRadiusValue>(extractorState, extractorState.style.borderBottomRightRadius());
    }
    static void extractBorderBottomRightRadiusSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BorderRadiusValue>(extractorState, builder, context, extractorState.style.borderBottomRightRadius());
    }
    static RefPtr<CSSValue> extractBorderBottomStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.borderBottomStyle());
    }
    static void extractBorderBottomStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.borderBottomStyle());
    }
    static RefPtr<CSSValue> extractBorderBottomWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<LineWidth>(extractorState, extractorState.style.borderBottomWidth());
    }
    static void extractBorderBottomWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<LineWidth>(extractorState, builder, context, extractorState.style.borderBottomWidth());
    }
    static RefPtr<CSSValue> extractBorderLeftColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderLeftColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.borderLeftColor());
    }
    static void extractBorderLeftColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderLeftColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.borderLeftColor());
    }
    static RefPtr<CSSValue> extractBorderLeftStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.borderLeftStyle());
    }
    static void extractBorderLeftStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.borderLeftStyle());
    }
    static RefPtr<CSSValue> extractBorderLeftWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<LineWidth>(extractorState, extractorState.style.borderLeftWidth());
    }
    static void extractBorderLeftWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<LineWidth>(extractorState, builder, context, extractorState.style.borderLeftWidth());
    }
    static RefPtr<CSSValue> extractBorderRightColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderRightColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.borderRightColor());
    }
    static void extractBorderRightColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderRightColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.borderRightColor());
    }
    static RefPtr<CSSValue> extractBorderRightStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.borderRightStyle());
    }
    static void extractBorderRightStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.borderRightStyle());
    }
    static RefPtr<CSSValue> extractBorderRightWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<LineWidth>(extractorState, extractorState.style.borderRightWidth());
    }
    static void extractBorderRightWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<LineWidth>(extractorState, builder, context, extractorState.style.borderRightWidth());
    }
    static RefPtr<CSSValue> extractBorderTopColor(ExtractorState& extractorState)
    {
        if (extractorState.allowVisitedStyle) {
            return extractorState.pool.createColorValue(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderTopColor));
        }
        return ExtractorConverter::convertStyleType<Color>(extractorState, extractorState.style.borderTopColor());
    }
    static void extractBorderTopColorSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        if (extractorState.allowVisitedStyle) {
            builder.append(WebCore::serializationForCSS(extractorState.style.visitedDependentColor(CSSPropertyID::CSSPropertyBorderTopColor)));
            return;
        }
        ExtractorSerializer::serializeStyleType<Color>(extractorState, builder, context, extractorState.style.borderTopColor());
    }
    static RefPtr<CSSValue> extractBorderTopLeftRadius(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BorderRadiusValue>(extractorState, extractorState.style.borderTopLeftRadius());
    }
    static void extractBorderTopLeftRadiusSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BorderRadiusValue>(extractorState, builder, context, extractorState.style.borderTopLeftRadius());
    }
    static RefPtr<CSSValue> extractBorderTopRightRadius(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<BorderRadiusValue>(extractorState, extractorState.style.borderTopRightRadius());
    }
    static void extractBorderTopRightRadiusSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<BorderRadiusValue>(extractorState, builder, context, extractorState.style.borderTopRightRadius());
    }
    static RefPtr<CSSValue> extractBorderTopStyle(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.borderTopStyle());
    }
    static void extractBorderTopStyleSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.borderTopStyle());
    }
    static RefPtr<CSSValue> extractBorderTopWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<LineWidth>(extractorState, extractorState.style.borderTopWidth());
    }
    static void extractBorderTopWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<LineWidth>(extractorState, builder, context, extractorState.style.borderTopWidth());
    }
    static RefPtr<CSSValue> extractContainIntrinsicHeight(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ContainIntrinsicSize>(extractorState, extractorState.style.containIntrinsicHeight());
    }
    static void extractContainIntrinsicHeightSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ContainIntrinsicSize>(extractorState, builder, context, extractorState.style.containIntrinsicHeight());
    }
    static RefPtr<CSSValue> extractContainIntrinsicWidth(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ContainIntrinsicSize>(extractorState, extractorState.style.containIntrinsicWidth());
    }
    static void extractContainIntrinsicWidthSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ContainIntrinsicSize>(extractorState, builder, context, extractorState.style.containIntrinsicWidth());
    }
    static RefPtr<CSSValue> extractCornerBottomLeftShape(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<CornerShapeValue>(extractorState, extractorState.style.cornerBottomLeftShape());
    }
    static void extractCornerBottomLeftShapeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<CornerShapeValue>(extractorState, builder, context, extractorState.style.cornerBottomLeftShape());
    }
    static RefPtr<CSSValue> extractCornerBottomRightShape(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<CornerShapeValue>(extractorState, extractorState.style.cornerBottomRightShape());
    }
    static void extractCornerBottomRightShapeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<CornerShapeValue>(extractorState, builder, context, extractorState.style.cornerBottomRightShape());
    }
    static RefPtr<CSSValue> extractCornerTopLeftShape(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<CornerShapeValue>(extractorState, extractorState.style.cornerTopLeftShape());
    }
    static void extractCornerTopLeftShapeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<CornerShapeValue>(extractorState, builder, context, extractorState.style.cornerTopLeftShape());
    }
    static RefPtr<CSSValue> extractCornerTopRightShape(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<CornerShapeValue>(extractorState, extractorState.style.cornerTopRightShape());
    }
    static void extractCornerTopRightShapeSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<CornerShapeValue>(extractorState, builder, context, extractorState.style.cornerTopRightShape());
    }
    static RefPtr<CSSValue> extractOverflowX(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.overflowX());
    }
    static void extractOverflowXSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.overflowX());
    }
    static RefPtr<CSSValue> extractOverflowY(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.overflowY());
    }
    static void extractOverflowYSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.overflowY());
    }
    static RefPtr<CSSValue> extractOverscrollBehaviorX(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.overscrollBehaviorX());
    }
    static void extractOverscrollBehaviorXSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.overscrollBehaviorX());
    }
    static RefPtr<CSSValue> extractOverscrollBehaviorY(ExtractorState& extractorState)
    {
        return ExtractorConverter::convert(extractorState, extractorState.style.overscrollBehaviorY());
    }
    static void extractOverscrollBehaviorYSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serialize(extractorState, builder, context, extractorState.style.overscrollBehaviorY());
    }
    static RefPtr<CSSValue> extractScrollMarginBottom(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollMarginEdge>(extractorState, extractorState.style.scrollMarginBottom());
    }
    static void extractScrollMarginBottomSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollMarginEdge>(extractorState, builder, context, extractorState.style.scrollMarginBottom());
    }
    static RefPtr<CSSValue> extractScrollMarginLeft(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollMarginEdge>(extractorState, extractorState.style.scrollMarginLeft());
    }
    static void extractScrollMarginLeftSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollMarginEdge>(extractorState, builder, context, extractorState.style.scrollMarginLeft());
    }
    static RefPtr<CSSValue> extractScrollMarginRight(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollMarginEdge>(extractorState, extractorState.style.scrollMarginRight());
    }
    static void extractScrollMarginRightSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollMarginEdge>(extractorState, builder, context, extractorState.style.scrollMarginRight());
    }
    static RefPtr<CSSValue> extractScrollMarginTop(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollMarginEdge>(extractorState, extractorState.style.scrollMarginTop());
    }
    static void extractScrollMarginTopSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollMarginEdge>(extractorState, builder, context, extractorState.style.scrollMarginTop());
    }
    static RefPtr<CSSValue> extractScrollPaddingBottom(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollPaddingEdge>(extractorState, extractorState.style.scrollPaddingBottom());
    }
    static void extractScrollPaddingBottomSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollPaddingEdge>(extractorState, builder, context, extractorState.style.scrollPaddingBottom());
    }
    static RefPtr<CSSValue> extractScrollPaddingLeft(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollPaddingEdge>(extractorState, extractorState.style.scrollPaddingLeft());
    }
    static void extractScrollPaddingLeftSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollPaddingEdge>(extractorState, builder, context, extractorState.style.scrollPaddingLeft());
    }
    static RefPtr<CSSValue> extractScrollPaddingRight(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollPaddingEdge>(extractorState, extractorState.style.scrollPaddingRight());
    }
    static void extractScrollPaddingRightSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollPaddingEdge>(extractorState, builder, context, extractorState.style.scrollPaddingRight());
    }
    static RefPtr<CSSValue> extractScrollPaddingTop(ExtractorState& extractorState)
    {
        return ExtractorConverter::convertStyleType<ScrollPaddingEdge>(extractorState, extractorState.style.scrollPaddingTop());
    }
    static void extractScrollPaddingTopSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        ExtractorSerializer::serializeStyleType<ScrollPaddingEdge>(extractorState, builder, context, extractorState.style.scrollPaddingTop());
    }
    static RefPtr<CSSValue> extractBorderBlockColorShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, borderBlockColorShorthand());
    }
    static void extractBorderBlockColorShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, borderBlockColorShorthand());
    }
    static RefPtr<CSSValue> extractBorderBlockEndShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderBlockEndShorthand());
    }
    static void extractBorderBlockEndShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderBlockEndShorthand());
    }
    static RefPtr<CSSValue> extractBorderBlockStartShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderBlockStartShorthand());
    }
    static void extractBorderBlockStartShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderBlockStartShorthand());
    }
    static RefPtr<CSSValue> extractBorderBlockStyleShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, borderBlockStyleShorthand());
    }
    static void extractBorderBlockStyleShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, borderBlockStyleShorthand());
    }
    static RefPtr<CSSValue> extractBorderBlockWidthShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, borderBlockWidthShorthand());
    }
    static void extractBorderBlockWidthShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, borderBlockWidthShorthand());
    }
    static RefPtr<CSSValue> extractBorderBottomShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderBottomShorthand());
    }
    static void extractBorderBottomShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderBottomShorthand());
    }
    static RefPtr<CSSValue> extractBorderColorShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, borderColorShorthand());
    }
    static void extractBorderColorShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, borderColorShorthand());
    }
    static RefPtr<CSSValue> extractBorderInlineColorShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, borderInlineColorShorthand());
    }
    static void extractBorderInlineColorShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, borderInlineColorShorthand());
    }
    static RefPtr<CSSValue> extractBorderInlineEndShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderInlineEndShorthand());
    }
    static void extractBorderInlineEndShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderInlineEndShorthand());
    }
    static RefPtr<CSSValue> extractBorderInlineStartShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderInlineStartShorthand());
    }
    static void extractBorderInlineStartShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderInlineStartShorthand());
    }
    static RefPtr<CSSValue> extractBorderInlineStyleShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, borderInlineStyleShorthand());
    }
    static void extractBorderInlineStyleShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, borderInlineStyleShorthand());
    }
    static RefPtr<CSSValue> extractBorderInlineWidthShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, borderInlineWidthShorthand());
    }
    static void extractBorderInlineWidthShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, borderInlineWidthShorthand());
    }
    static RefPtr<CSSValue> extractBorderLeftShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderLeftShorthand());
    }
    static void extractBorderLeftShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderLeftShorthand());
    }
    static RefPtr<CSSValue> extractBorderRightShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderRightShorthand());
    }
    static void extractBorderRightShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderRightShorthand());
    }
    static RefPtr<CSSValue> extractBorderSpacingShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, borderSpacingShorthand());
    }
    static void extractBorderSpacingShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, borderSpacingShorthand());
    }
    static RefPtr<CSSValue> extractBorderStyleShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, borderStyleShorthand());
    }
    static void extractBorderStyleShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, borderStyleShorthand());
    }
    static RefPtr<CSSValue> extractBorderTopShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, borderTopShorthand());
    }
    static void extractBorderTopShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, borderTopShorthand());
    }
    static RefPtr<CSSValue> extractBorderWidthShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, borderWidthShorthand());
    }
    static void extractBorderWidthShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, borderWidthShorthand());
    }
    static RefPtr<CSSValue> extractColumnRuleShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, columnRuleShorthand());
    }
    static void extractColumnRuleShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, columnRuleShorthand());
    }
    static RefPtr<CSSValue> extractContainIntrinsicSizeShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, containIntrinsicSizeShorthand());
    }
    static void extractContainIntrinsicSizeShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, containIntrinsicSizeShorthand());
    }
    static RefPtr<CSSValue> extractCornerShapeShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, cornerShapeShorthand());
    }
    static void extractCornerShapeShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, cornerShapeShorthand());
    }
    static RefPtr<CSSValue> extractFlexShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, flexShorthand());
    }
    static void extractFlexShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, flexShorthand());
    }
    static RefPtr<CSSValue> extractGapShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, gapShorthand());
    }
    static void extractGapShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, gapShorthand());
    }
    static RefPtr<CSSValue> extractGridShorthand(ExtractorState& extractorState)
    {
        return extractStandardSlashSeparatedShorthand(extractorState, gridShorthand());
    }
    static void extractGridShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSlashSeparatedShorthandSerialization(extractorState, builder, context, gridShorthand());
    }
    static RefPtr<CSSValue> extractGridAreaShorthand(ExtractorState& extractorState)
    {
        return extractStandardSlashSeparatedShorthand(extractorState, gridAreaShorthand());
    }
    static void extractGridAreaShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSlashSeparatedShorthandSerialization(extractorState, builder, context, gridAreaShorthand());
    }
    static RefPtr<CSSValue> extractGridColumnShorthand(ExtractorState& extractorState)
    {
        return extractStandardSlashSeparatedShorthand(extractorState, gridColumnShorthand());
    }
    static void extractGridColumnShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSlashSeparatedShorthandSerialization(extractorState, builder, context, gridColumnShorthand());
    }
    static RefPtr<CSSValue> extractGridRowShorthand(ExtractorState& extractorState)
    {
        return extractStandardSlashSeparatedShorthand(extractorState, gridRowShorthand());
    }
    static void extractGridRowShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSlashSeparatedShorthandSerialization(extractorState, builder, context, gridRowShorthand());
    }
    static RefPtr<CSSValue> extractGridTemplateShorthand(ExtractorState& extractorState)
    {
        return extractStandardSlashSeparatedShorthand(extractorState, gridTemplateShorthand());
    }
    static void extractGridTemplateShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSlashSeparatedShorthandSerialization(extractorState, builder, context, gridTemplateShorthand());
    }
    static RefPtr<CSSValue> extractInsetShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, insetShorthand());
    }
    static void extractInsetShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, insetShorthand());
    }
    static RefPtr<CSSValue> extractInsetBlockShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, insetBlockShorthand());
    }
    static void extractInsetBlockShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, insetBlockShorthand());
    }
    static RefPtr<CSSValue> extractInsetInlineShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, insetInlineShorthand());
    }
    static void extractInsetInlineShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, insetInlineShorthand());
    }
    static RefPtr<CSSValue> extractListStyleShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, listStyleShorthand());
    }
    static void extractListStyleShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, listStyleShorthand());
    }
    static RefPtr<CSSValue> extractMarginShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, marginShorthand());
    }
    static void extractMarginShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, marginShorthand());
    }
    static RefPtr<CSSValue> extractMarginBlockShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, marginBlockShorthand());
    }
    static void extractMarginBlockShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, marginBlockShorthand());
    }
    static RefPtr<CSSValue> extractMarginInlineShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, marginInlineShorthand());
    }
    static void extractMarginInlineShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, marginInlineShorthand());
    }
    static RefPtr<CSSValue> extractOutlineShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, outlineShorthand());
    }
    static void extractOutlineShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, outlineShorthand());
    }
    static RefPtr<CSSValue> extractOverflowShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, overflowShorthand());
    }
    static void extractOverflowShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, overflowShorthand());
    }
    static RefPtr<CSSValue> extractPaddingShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, paddingShorthand());
    }
    static void extractPaddingShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, paddingShorthand());
    }
    static RefPtr<CSSValue> extractPaddingBlockShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, paddingBlockShorthand());
    }
    static void extractPaddingBlockShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, paddingBlockShorthand());
    }
    static RefPtr<CSSValue> extractPaddingInlineShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, paddingInlineShorthand());
    }
    static void extractPaddingInlineShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, paddingInlineShorthand());
    }
    static RefPtr<CSSValue> extractPlaceContentShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, placeContentShorthand());
    }
    static void extractPlaceContentShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, placeContentShorthand());
    }
    static RefPtr<CSSValue> extractPlaceItemsShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, placeItemsShorthand());
    }
    static void extractPlaceItemsShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, placeItemsShorthand());
    }
    static RefPtr<CSSValue> extractPlaceSelfShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, placeSelfShorthand());
    }
    static void extractPlaceSelfShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, placeSelfShorthand());
    }
    static RefPtr<CSSValue> extractScrollMarginShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, scrollMarginShorthand());
    }
    static void extractScrollMarginShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, scrollMarginShorthand());
    }
    static RefPtr<CSSValue> extractScrollMarginBlockShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, scrollMarginBlockShorthand());
    }
    static void extractScrollMarginBlockShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, scrollMarginBlockShorthand());
    }
    static RefPtr<CSSValue> extractScrollMarginInlineShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, scrollMarginInlineShorthand());
    }
    static void extractScrollMarginInlineShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, scrollMarginInlineShorthand());
    }
    static RefPtr<CSSValue> extractScrollPaddingShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingQuadShorthand(extractorState, scrollPaddingShorthand());
    }
    static void extractScrollPaddingShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingQuadShorthandSerialization(extractorState, builder, context, scrollPaddingShorthand());
    }
    static RefPtr<CSSValue> extractScrollPaddingBlockShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, scrollPaddingBlockShorthand());
    }
    static void extractScrollPaddingBlockShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, scrollPaddingBlockShorthand());
    }
    static RefPtr<CSSValue> extractScrollPaddingInlineShorthand(ExtractorState& extractorState)
    {
        return extractCoalescingPairShorthand(extractorState, scrollPaddingInlineShorthand());
    }
    static void extractScrollPaddingInlineShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractCoalescingPairShorthandSerialization(extractorState, builder, context, scrollPaddingInlineShorthand());
    }
    static RefPtr<CSSValue> extractTextDecorationShorthand(ExtractorState& extractorState)
    {
        return extractSingleShorthand(extractorState, textDecorationShorthand());
    }
    static void extractTextDecorationShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractSingleShorthandSerialization(extractorState, builder, context, textDecorationShorthand());
    }
    static RefPtr<CSSValue> extractTextEmphasisShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, textEmphasisShorthand());
    }
    static void extractTextEmphasisShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, textEmphasisShorthand());
    }
    static RefPtr<CSSValue> extractWebkitBackgroundSizeShorthand(ExtractorState& extractorState)
    {
        return extractSingleShorthand(extractorState, webkitBackgroundSizeShorthand());
    }
    static void extractWebkitBackgroundSizeShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractSingleShorthandSerialization(extractorState, builder, context, webkitBackgroundSizeShorthand());
    }
    static RefPtr<CSSValue> extractWebkitPerspectiveShorthand(ExtractorState& extractorState)
    {
        return extractSingleShorthand(extractorState, webkitPerspectiveShorthand());
    }
    static void extractWebkitPerspectiveShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractSingleShorthandSerialization(extractorState, builder, context, webkitPerspectiveShorthand());
    }
    static RefPtr<CSSValue> extractWebkitTextDecorationShorthand(ExtractorState& extractorState)
    {
        return extractStandardSpaceSeparatedShorthand(extractorState, webkitTextDecorationShorthand());
    }
    static void extractWebkitTextDecorationShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractStandardSpaceSeparatedShorthandSerialization(extractorState, builder, context, webkitTextDecorationShorthand());
    }
    static RefPtr<CSSValue> extractWebkitTextOrientationShorthand(ExtractorState& extractorState)
    {
        return extractSingleShorthand(extractorState, webkitTextOrientationShorthand());
    }
    static void extractWebkitTextOrientationShorthandSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context)
    {
        extractSingleShorthandSerialization(extractorState, builder, context, webkitTextOrientationShorthand());
    }
};

RefPtr<CSSValue> ExtractorGenerated::extractValue(ExtractorState& extractorState, CSSPropertyID id)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyInvalid:
        break;
    case CSSPropertyID::CSSPropertyCustom:
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyColorScheme:
        return ExtractorFunctions::extractColorScheme(extractorState);
    case CSSPropertyID::CSSPropertyRubyPosition:
        return ExtractorFunctions::extractRubyPosition(extractorState);
    case CSSPropertyID::CSSPropertyWritingMode:
        return ExtractorCustom::extractWritingMode(extractorState);
    case CSSPropertyID::CSSPropertyDirection:
        return ExtractorCustom::extractDirection(extractorState);
    case CSSPropertyID::CSSPropertyDisplay:
        return ExtractorFunctions::extractDisplay(extractorState);
    case CSSPropertyID::CSSPropertyFontFamily:
        return ExtractorCustom::extractFontFamily(extractorState);
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        return ExtractorFunctions::extractFontFeatureSettings(extractorState);
    case CSSPropertyID::CSSPropertyFontKerning:
        return ExtractorFunctions::extractFontKerning(extractorState);
    case CSSPropertyID::CSSPropertyFontOpticalSizing:
        return ExtractorFunctions::extractFontOpticalSizing(extractorState);
    case CSSPropertyID::CSSPropertyFontPalette:
        return ExtractorFunctions::extractFontPalette(extractorState);
    case CSSPropertyID::CSSPropertyFontSize:
        return ExtractorCustom::extractFontSize(extractorState);
    case CSSPropertyID::CSSPropertyFontSizeAdjust:
        return ExtractorFunctions::extractFontSizeAdjust(extractorState);
    case CSSPropertyID::CSSPropertyFontStyle:
        return ExtractorCustom::extractFontStyle(extractorState);
    case CSSPropertyID::CSSPropertyFontSynthesisSmallCaps:
        return ExtractorFunctions::extractFontSynthesisSmallCaps(extractorState);
    case CSSPropertyID::CSSPropertyFontSynthesisStyle:
        return ExtractorFunctions::extractFontSynthesisStyle(extractorState);
    case CSSPropertyID::CSSPropertyFontSynthesisWeight:
        return ExtractorFunctions::extractFontSynthesisWeight(extractorState);
    case CSSPropertyID::CSSPropertyFontVariantAlternates:
        return ExtractorCustom::extractFontVariantAlternates(extractorState);
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        return ExtractorFunctions::extractFontVariantCaps(extractorState);
    case CSSPropertyID::CSSPropertyFontVariantEastAsian:
        return ExtractorCustom::extractFontVariantEastAsian(extractorState);
    case CSSPropertyID::CSSPropertyFontVariantEmoji:
        return ExtractorFunctions::extractFontVariantEmoji(extractorState);
    case CSSPropertyID::CSSPropertyFontVariantLigatures:
        return ExtractorCustom::extractFontVariantLigatures(extractorState);
    case CSSPropertyID::CSSPropertyFontVariantNumeric:
        return ExtractorCustom::extractFontVariantNumeric(extractorState);
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        return ExtractorFunctions::extractFontVariantPosition(extractorState);
    case CSSPropertyID::CSSPropertyFontVariationSettings:
        return ExtractorFunctions::extractFontVariationSettings(extractorState);
    case CSSPropertyID::CSSPropertyFontWeight:
        return ExtractorFunctions::extractFontWeight(extractorState);
    case CSSPropertyID::CSSPropertyFontWidth:
        return ExtractorFunctions::extractFontWidth(extractorState);
    case CSSPropertyID::CSSPropertyTextOrientation:
        return ExtractorFunctions::extractTextOrientation(extractorState);
    case CSSPropertyID::CSSPropertyTextRendering:
        return ExtractorFunctions::extractTextRendering(extractorState);
    case CSSPropertyID::CSSPropertyZoom:
        return ExtractorFunctions::extractZoom(extractorState);
    case CSSPropertyID::CSSPropertyWebkitFontSmoothing:
        return ExtractorFunctions::extractWebkitFontSmoothing(extractorState);
    case CSSPropertyID::CSSPropertyWebkitLocale:
        return ExtractorFunctions::extractWebkitLocale(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextZoom:
        return ExtractorFunctions::extractWebkitTextZoom(extractorState);
    case CSSPropertyID::CSSPropertyLetterSpacing:
        return ExtractorCustom::extractLetterSpacing(extractorState);
    case CSSPropertyID::CSSPropertyTextAutospace:
        return ExtractorFunctions::extractTextAutospace(extractorState);
    case CSSPropertyID::CSSPropertyTextSpacingTrim:
        return ExtractorFunctions::extractTextSpacingTrim(extractorState);
    case CSSPropertyID::CSSPropertyAccentColor:
        return ExtractorFunctions::extractAccentColor(extractorState);
    case CSSPropertyID::CSSPropertyAdditiveSymbols:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyAlignContent:
        return ExtractorFunctions::extractAlignContent(extractorState);
    case CSSPropertyID::CSSPropertyAlignItems:
        return ExtractorFunctions::extractAlignItems(extractorState);
    case CSSPropertyID::CSSPropertyAlignSelf:
        return ExtractorFunctions::extractAlignSelf(extractorState);
    case CSSPropertyID::CSSPropertyAlignmentBaseline:
        return ExtractorFunctions::extractAlignmentBaseline(extractorState);
    case CSSPropertyID::CSSPropertyAnchorName:
        return ExtractorFunctions::extractAnchorName(extractorState);
    case CSSPropertyID::CSSPropertyAnchorScope:
        return ExtractorFunctions::extractAnchorScope(extractorState);
    case CSSPropertyID::CSSPropertyAnimationComposition:
        return ExtractorFunctions::extractAnimationComposition(extractorState);
    case CSSPropertyID::CSSPropertyAnimationDelay:
        return ExtractorFunctions::extractAnimationDelay(extractorState);
    case CSSPropertyID::CSSPropertyAnimationDirection:
        return ExtractorFunctions::extractAnimationDirection(extractorState);
    case CSSPropertyID::CSSPropertyAnimationDuration:
        return ExtractorFunctions::extractAnimationDuration(extractorState);
    case CSSPropertyID::CSSPropertyAnimationFillMode:
        return ExtractorFunctions::extractAnimationFillMode(extractorState);
    case CSSPropertyID::CSSPropertyAnimationIterationCount:
        return ExtractorFunctions::extractAnimationIterationCount(extractorState);
    case CSSPropertyID::CSSPropertyAnimationName:
        return ExtractorFunctions::extractAnimationName(extractorState);
    case CSSPropertyID::CSSPropertyAnimationPlayState:
        return ExtractorFunctions::extractAnimationPlayState(extractorState);
    case CSSPropertyID::CSSPropertyAnimationRangeEnd:
        return ExtractorFunctions::extractAnimationRangeEnd(extractorState);
    case CSSPropertyID::CSSPropertyAnimationRangeStart:
        return ExtractorFunctions::extractAnimationRangeStart(extractorState);
    case CSSPropertyID::CSSPropertyAnimationTimeline:
        return ExtractorFunctions::extractAnimationTimeline(extractorState);
    case CSSPropertyID::CSSPropertyAnimationTimingFunction:
        return ExtractorFunctions::extractAnimationTimingFunction(extractorState);
    case CSSPropertyID::CSSPropertyAppearance:
        return ExtractorFunctions::extractAppearance(extractorState);
    case CSSPropertyID::CSSPropertyAspectRatio:
        return ExtractorFunctions::extractAspectRatio(extractorState);
    case CSSPropertyID::CSSPropertyBackdropFilter:
        return ExtractorFunctions::extractBackdropFilter(extractorState);
    case CSSPropertyID::CSSPropertyBackfaceVisibility:
        return ExtractorFunctions::extractBackfaceVisibility(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundAttachment:
        return ExtractorFunctions::extractBackgroundAttachment(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundBlendMode:
        return ExtractorFunctions::extractBackgroundBlendMode(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundClip:
        return ExtractorFunctions::extractBackgroundClip(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundColor:
        return ExtractorFunctions::extractBackgroundColor(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundImage:
        return ExtractorFunctions::extractBackgroundImage(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundOrigin:
        return ExtractorFunctions::extractBackgroundOrigin(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundPositionX:
        return ExtractorFunctions::extractBackgroundPositionX(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundPositionY:
        return ExtractorFunctions::extractBackgroundPositionY(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundRepeat:
        return ExtractorFunctions::extractBackgroundRepeat(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundSize:
        return ExtractorFunctions::extractBackgroundSize(extractorState);
    case CSSPropertyID::CSSPropertyBasePalette:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyBaselineShift:
        return ExtractorFunctions::extractBaselineShift(extractorState);
    case CSSPropertyID::CSSPropertyBlockEllipsis:
        return ExtractorFunctions::extractBlockEllipsis(extractorState);
    case CSSPropertyID::CSSPropertyBlockStepAlign:
        return ExtractorFunctions::extractBlockStepAlign(extractorState);
    case CSSPropertyID::CSSPropertyBlockStepInsert:
        return ExtractorFunctions::extractBlockStepInsert(extractorState);
    case CSSPropertyID::CSSPropertyBlockStepRound:
        return ExtractorFunctions::extractBlockStepRound(extractorState);
    case CSSPropertyID::CSSPropertyBlockStepSize:
        return ExtractorFunctions::extractBlockStepSize(extractorState);
    case CSSPropertyID::CSSPropertyBorderCollapse:
        return ExtractorFunctions::extractBorderCollapse(extractorState);
    case CSSPropertyID::CSSPropertyBorderImageOutset:
        return ExtractorCustom::extractBorderImageOutset(extractorState);
    case CSSPropertyID::CSSPropertyBorderImageRepeat:
        return ExtractorCustom::extractBorderImageRepeat(extractorState);
    case CSSPropertyID::CSSPropertyBorderImageSlice:
        return ExtractorCustom::extractBorderImageSlice(extractorState);
    case CSSPropertyID::CSSPropertyBorderImageSource:
        return ExtractorFunctions::extractBorderImageSource(extractorState);
    case CSSPropertyID::CSSPropertyBorderImageWidth:
        return ExtractorCustom::extractBorderImageWidth(extractorState);
    case CSSPropertyID::CSSPropertyBoxShadow:
        return ExtractorFunctions::extractBoxShadow(extractorState);
    case CSSPropertyID::CSSPropertyBoxSizing:
        return ExtractorFunctions::extractBoxSizing(extractorState);
    case CSSPropertyID::CSSPropertyBreakAfter:
        return ExtractorFunctions::extractBreakAfter(extractorState);
    case CSSPropertyID::CSSPropertyBreakBefore:
        return ExtractorFunctions::extractBreakBefore(extractorState);
    case CSSPropertyID::CSSPropertyBreakInside:
        return ExtractorFunctions::extractBreakInside(extractorState);
    case CSSPropertyID::CSSPropertyBufferedRendering:
        return ExtractorFunctions::extractBufferedRendering(extractorState);
    case CSSPropertyID::CSSPropertyCaptionSide:
        return ExtractorFunctions::extractCaptionSide(extractorState);
    case CSSPropertyID::CSSPropertyCaretColor:
        return ExtractorFunctions::extractCaretColor(extractorState);
    case CSSPropertyID::CSSPropertyClear:
        return ExtractorFunctions::extractClear(extractorState);
    case CSSPropertyID::CSSPropertyClip:
        return ExtractorFunctions::extractClip(extractorState);
    case CSSPropertyID::CSSPropertyClipPath:
        return ExtractorFunctions::extractClipPath(extractorState);
    case CSSPropertyID::CSSPropertyClipRule:
        return ExtractorFunctions::extractClipRule(extractorState);
    case CSSPropertyID::CSSPropertyColor:
        return ExtractorFunctions::extractColor(extractorState);
    case CSSPropertyID::CSSPropertyColorInterpolation:
        return ExtractorFunctions::extractColorInterpolation(extractorState);
    case CSSPropertyID::CSSPropertyColorInterpolationFilters:
        return ExtractorFunctions::extractColorInterpolationFilters(extractorState);
    case CSSPropertyID::CSSPropertyColumnCount:
        return ExtractorFunctions::extractColumnCount(extractorState);
    case CSSPropertyID::CSSPropertyColumnFill:
        return ExtractorFunctions::extractColumnFill(extractorState);
    case CSSPropertyID::CSSPropertyColumnGap:
        return ExtractorFunctions::extractColumnGap(extractorState);
    case CSSPropertyID::CSSPropertyColumnRuleColor:
        return ExtractorFunctions::extractColumnRuleColor(extractorState);
    case CSSPropertyID::CSSPropertyColumnRuleStyle:
        return ExtractorFunctions::extractColumnRuleStyle(extractorState);
    case CSSPropertyID::CSSPropertyColumnRuleWidth:
        return ExtractorFunctions::extractColumnRuleWidth(extractorState);
    case CSSPropertyID::CSSPropertyColumnSpan:
        return ExtractorFunctions::extractColumnSpan(extractorState);
    case CSSPropertyID::CSSPropertyColumnWidth:
        return ExtractorFunctions::extractColumnWidth(extractorState);
    case CSSPropertyID::CSSPropertyContain:
        return ExtractorFunctions::extractContain(extractorState);
    case CSSPropertyID::CSSPropertyContainerName:
        return ExtractorFunctions::extractContainerName(extractorState);
    case CSSPropertyID::CSSPropertyContainerType:
        return ExtractorFunctions::extractContainerType(extractorState);
    case CSSPropertyID::CSSPropertyContent:
        return ExtractorCustom::extractContent(extractorState);
    case CSSPropertyID::CSSPropertyContentVisibility:
        return ExtractorFunctions::extractContentVisibility(extractorState);
    case CSSPropertyID::CSSPropertyContinue:
        return ExtractorFunctions::extractContinue(extractorState);
    case CSSPropertyID::CSSPropertyCounterIncrement:
        return ExtractorCustom::extractCounterIncrement(extractorState);
    case CSSPropertyID::CSSPropertyCounterReset:
        return ExtractorCustom::extractCounterReset(extractorState);
    case CSSPropertyID::CSSPropertyCounterSet:
        return ExtractorCustom::extractCounterSet(extractorState);
    case CSSPropertyID::CSSPropertyCursor:
        return ExtractorFunctions::extractCursor(extractorState);
    case CSSPropertyID::CSSPropertyCx:
        return ExtractorFunctions::extractCx(extractorState);
    case CSSPropertyID::CSSPropertyCy:
        return ExtractorFunctions::extractCy(extractorState);
    case CSSPropertyID::CSSPropertyD:
        return ExtractorFunctions::extractD(extractorState);
    case CSSPropertyID::CSSPropertyDominantBaseline:
        return ExtractorFunctions::extractDominantBaseline(extractorState);
    case CSSPropertyID::CSSPropertyDynamicRangeLimit:
        return ExtractorFunctions::extractDynamicRangeLimit(extractorState);
    case CSSPropertyID::CSSPropertyEmptyCells:
        return ExtractorFunctions::extractEmptyCells(extractorState);
    case CSSPropertyID::CSSPropertyFallback:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyFieldSizing:
        return ExtractorFunctions::extractFieldSizing(extractorState);
    case CSSPropertyID::CSSPropertyFill:
        return ExtractorFunctions::extractFill(extractorState);
    case CSSPropertyID::CSSPropertyFillOpacity:
        return ExtractorFunctions::extractFillOpacity(extractorState);
    case CSSPropertyID::CSSPropertyFillRule:
        return ExtractorFunctions::extractFillRule(extractorState);
    case CSSPropertyID::CSSPropertyFilter:
        return ExtractorFunctions::extractFilter(extractorState);
    case CSSPropertyID::CSSPropertyFlexBasis:
        return ExtractorFunctions::extractFlexBasis(extractorState);
    case CSSPropertyID::CSSPropertyFlexDirection:
        return ExtractorFunctions::extractFlexDirection(extractorState);
    case CSSPropertyID::CSSPropertyFlexGrow:
        return ExtractorFunctions::extractFlexGrow(extractorState);
    case CSSPropertyID::CSSPropertyFlexShrink:
        return ExtractorFunctions::extractFlexShrink(extractorState);
    case CSSPropertyID::CSSPropertyFlexWrap:
        return ExtractorFunctions::extractFlexWrap(extractorState);
    case CSSPropertyID::CSSPropertyFloat:
        return ExtractorCustom::extractFloat(extractorState);
    case CSSPropertyID::CSSPropertyFloodColor:
        return ExtractorFunctions::extractFloodColor(extractorState);
    case CSSPropertyID::CSSPropertyFloodOpacity:
        return ExtractorFunctions::extractFloodOpacity(extractorState);
    case CSSPropertyID::CSSPropertyFontDisplay:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyGlyphOrientationHorizontal:
        return ExtractorFunctions::extractGlyphOrientationHorizontal(extractorState);
    case CSSPropertyID::CSSPropertyGlyphOrientationVertical:
        return ExtractorFunctions::extractGlyphOrientationVertical(extractorState);
    case CSSPropertyID::CSSPropertyGridAutoColumns:
        return ExtractorFunctions::extractGridAutoColumns(extractorState);
    case CSSPropertyID::CSSPropertyGridAutoFlow:
        return ExtractorFunctions::extractGridAutoFlow(extractorState);
    case CSSPropertyID::CSSPropertyGridAutoRows:
        return ExtractorFunctions::extractGridAutoRows(extractorState);
    case CSSPropertyID::CSSPropertyGridColumnEnd:
        return ExtractorFunctions::extractGridColumnEnd(extractorState);
    case CSSPropertyID::CSSPropertyGridColumnStart:
        return ExtractorFunctions::extractGridColumnStart(extractorState);
    case CSSPropertyID::CSSPropertyGridRowEnd:
        return ExtractorFunctions::extractGridRowEnd(extractorState);
    case CSSPropertyID::CSSPropertyGridRowStart:
        return ExtractorFunctions::extractGridRowStart(extractorState);
    case CSSPropertyID::CSSPropertyGridTemplateAreas:
        return ExtractorFunctions::extractGridTemplateAreas(extractorState);
    case CSSPropertyID::CSSPropertyGridTemplateColumns:
        return ExtractorCustom::extractGridTemplateColumns(extractorState);
    case CSSPropertyID::CSSPropertyGridTemplateRows:
        return ExtractorCustom::extractGridTemplateRows(extractorState);
    case CSSPropertyID::CSSPropertyHangingPunctuation:
        return ExtractorFunctions::extractHangingPunctuation(extractorState);
    case CSSPropertyID::CSSPropertyHyphenateCharacter:
        return ExtractorFunctions::extractHyphenateCharacter(extractorState);
    case CSSPropertyID::CSSPropertyHyphens:
        return ExtractorFunctions::extractHyphens(extractorState);
    case CSSPropertyID::CSSPropertyImageOrientation:
        return ExtractorFunctions::extractImageOrientation(extractorState);
    case CSSPropertyID::CSSPropertyImageRendering:
        return ExtractorFunctions::extractImageRendering(extractorState);
    case CSSPropertyID::CSSPropertyInherits:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyInitialValue:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyInputSecurity:
        return ExtractorFunctions::extractInputSecurity(extractorState);
    case CSSPropertyID::CSSPropertyIsolation:
        return ExtractorFunctions::extractIsolation(extractorState);
    case CSSPropertyID::CSSPropertyJustifyContent:
        return ExtractorFunctions::extractJustifyContent(extractorState);
    case CSSPropertyID::CSSPropertyJustifyItems:
        return ExtractorFunctions::extractJustifyItems(extractorState);
    case CSSPropertyID::CSSPropertyJustifySelf:
        return ExtractorFunctions::extractJustifySelf(extractorState);
    case CSSPropertyID::CSSPropertyLightingColor:
        return ExtractorFunctions::extractLightingColor(extractorState);
    case CSSPropertyID::CSSPropertyLineBreak:
        return ExtractorFunctions::extractLineBreak(extractorState);
    case CSSPropertyID::CSSPropertyLineFitEdge:
        return ExtractorFunctions::extractLineFitEdge(extractorState);
    case CSSPropertyID::CSSPropertyLineHeight:
        return ExtractorCustom::extractLineHeight(extractorState);
    case CSSPropertyID::CSSPropertyListStyleImage:
        return ExtractorFunctions::extractListStyleImage(extractorState);
    case CSSPropertyID::CSSPropertyListStylePosition:
        return ExtractorFunctions::extractListStylePosition(extractorState);
    case CSSPropertyID::CSSPropertyListStyleType:
        return ExtractorFunctions::extractListStyleType(extractorState);
    case CSSPropertyID::CSSPropertyMarginTrim:
        return ExtractorFunctions::extractMarginTrim(extractorState);
    case CSSPropertyID::CSSPropertyMarkerEnd:
        return ExtractorFunctions::extractMarkerEnd(extractorState);
    case CSSPropertyID::CSSPropertyMarkerMid:
        return ExtractorFunctions::extractMarkerMid(extractorState);
    case CSSPropertyID::CSSPropertyMarkerStart:
        return ExtractorFunctions::extractMarkerStart(extractorState);
    case CSSPropertyID::CSSPropertyMaskBorderOutset:
        return ExtractorCustom::extractMaskBorderOutset(extractorState);
    case CSSPropertyID::CSSPropertyMaskBorderRepeat:
        return ExtractorCustom::extractMaskBorderRepeat(extractorState);
    case CSSPropertyID::CSSPropertyMaskBorderSlice:
        return ExtractorCustom::extractMaskBorderSlice(extractorState);
    case CSSPropertyID::CSSPropertyMaskBorderSource:
        return ExtractorFunctions::extractMaskBorderSource(extractorState);
    case CSSPropertyID::CSSPropertyMaskBorderWidth:
        return ExtractorCustom::extractMaskBorderWidth(extractorState);
    case CSSPropertyID::CSSPropertyMaskClip:
        return ExtractorFunctions::extractMaskClip(extractorState);
    case CSSPropertyID::CSSPropertyMaskComposite:
        return ExtractorFunctions::extractMaskComposite(extractorState);
    case CSSPropertyID::CSSPropertyMaskImage:
        return ExtractorFunctions::extractMaskImage(extractorState);
    case CSSPropertyID::CSSPropertyMaskMode:
        return ExtractorFunctions::extractMaskMode(extractorState);
    case CSSPropertyID::CSSPropertyMaskOrigin:
        return ExtractorFunctions::extractMaskOrigin(extractorState);
    case CSSPropertyID::CSSPropertyMaskRepeat:
        return ExtractorFunctions::extractMaskRepeat(extractorState);
    case CSSPropertyID::CSSPropertyMaskSize:
        return ExtractorFunctions::extractMaskSize(extractorState);
    case CSSPropertyID::CSSPropertyMaskType:
        return ExtractorFunctions::extractMaskType(extractorState);
    case CSSPropertyID::CSSPropertyMathStyle:
        return ExtractorFunctions::extractMathStyle(extractorState);
    case CSSPropertyID::CSSPropertyMaxLines:
        return ExtractorFunctions::extractMaxLines(extractorState);
    case CSSPropertyID::CSSPropertyMixBlendMode:
        return ExtractorFunctions::extractMixBlendMode(extractorState);
    case CSSPropertyID::CSSPropertyNavigation:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyNegative:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyObjectFit:
        return ExtractorFunctions::extractObjectFit(extractorState);
    case CSSPropertyID::CSSPropertyObjectPosition:
        return ExtractorFunctions::extractObjectPosition(extractorState);
    case CSSPropertyID::CSSPropertyOffsetAnchor:
        return ExtractorFunctions::extractOffsetAnchor(extractorState);
    case CSSPropertyID::CSSPropertyOffsetDistance:
        return ExtractorFunctions::extractOffsetDistance(extractorState);
    case CSSPropertyID::CSSPropertyOffsetPath:
        return ExtractorFunctions::extractOffsetPath(extractorState);
    case CSSPropertyID::CSSPropertyOffsetPosition:
        return ExtractorFunctions::extractOffsetPosition(extractorState);
    case CSSPropertyID::CSSPropertyOffsetRotate:
        return ExtractorFunctions::extractOffsetRotate(extractorState);
    case CSSPropertyID::CSSPropertyOpacity:
        return ExtractorFunctions::extractOpacity(extractorState);
    case CSSPropertyID::CSSPropertyOrder:
        return ExtractorFunctions::extractOrder(extractorState);
    case CSSPropertyID::CSSPropertyOrphans:
        return ExtractorFunctions::extractOrphans(extractorState);
    case CSSPropertyID::CSSPropertyOutlineColor:
        return ExtractorFunctions::extractOutlineColor(extractorState);
    case CSSPropertyID::CSSPropertyOutlineOffset:
        return ExtractorFunctions::extractOutlineOffset(extractorState);
    case CSSPropertyID::CSSPropertyOutlineStyle:
        return ExtractorFunctions::extractOutlineStyle(extractorState);
    case CSSPropertyID::CSSPropertyOutlineWidth:
        return ExtractorFunctions::extractOutlineWidth(extractorState);
    case CSSPropertyID::CSSPropertyOverflowAnchor:
        return ExtractorFunctions::extractOverflowAnchor(extractorState);
    case CSSPropertyID::CSSPropertyOverflowWrap:
        return ExtractorFunctions::extractOverflowWrap(extractorState);
    case CSSPropertyID::CSSPropertyOverrideColors:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyPad:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyPage:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyPaintOrder:
        return ExtractorFunctions::extractPaintOrder(extractorState);
    case CSSPropertyID::CSSPropertyPerspective:
        return ExtractorFunctions::extractPerspective(extractorState);
    case CSSPropertyID::CSSPropertyPerspectiveOriginX:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyPerspectiveOriginY:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyPointerEvents:
        return ExtractorFunctions::extractPointerEvents(extractorState);
    case CSSPropertyID::CSSPropertyPosition:
        return ExtractorFunctions::extractPosition(extractorState);
    case CSSPropertyID::CSSPropertyPositionAnchor:
        return ExtractorFunctions::extractPositionAnchor(extractorState);
    case CSSPropertyID::CSSPropertyPositionArea:
        return ExtractorFunctions::extractPositionArea(extractorState);
    case CSSPropertyID::CSSPropertyPositionTryFallbacks:
        return ExtractorFunctions::extractPositionTryFallbacks(extractorState);
    case CSSPropertyID::CSSPropertyPositionTryOrder:
        return ExtractorFunctions::extractPositionTryOrder(extractorState);
    case CSSPropertyID::CSSPropertyPositionVisibility:
        return ExtractorFunctions::extractPositionVisibility(extractorState);
    case CSSPropertyID::CSSPropertyPrefix:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyPrintColorAdjust:
        return ExtractorFunctions::extractPrintColorAdjust(extractorState);
    case CSSPropertyID::CSSPropertyQuotes:
        return ExtractorFunctions::extractQuotes(extractorState);
    case CSSPropertyID::CSSPropertyR:
        return ExtractorFunctions::extractR(extractorState);
    case CSSPropertyID::CSSPropertyRange:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyResize:
        return ExtractorFunctions::extractResize(extractorState);
    case CSSPropertyID::CSSPropertyRotate:
        return ExtractorCustom::extractRotate(extractorState);
    case CSSPropertyID::CSSPropertyRowGap:
        return ExtractorFunctions::extractRowGap(extractorState);
    case CSSPropertyID::CSSPropertyRubyAlign:
        return ExtractorFunctions::extractRubyAlign(extractorState);
    case CSSPropertyID::CSSPropertyRubyOverhang:
        return ExtractorFunctions::extractRubyOverhang(extractorState);
    case CSSPropertyID::CSSPropertyRx:
        return ExtractorFunctions::extractRx(extractorState);
    case CSSPropertyID::CSSPropertyRy:
        return ExtractorFunctions::extractRy(extractorState);
    case CSSPropertyID::CSSPropertyScale:
        return ExtractorCustom::extractScale(extractorState);
    case CSSPropertyID::CSSPropertyScrollBehavior:
        return ExtractorFunctions::extractScrollBehavior(extractorState);
    case CSSPropertyID::CSSPropertyScrollSnapAlign:
        return ExtractorFunctions::extractScrollSnapAlign(extractorState);
    case CSSPropertyID::CSSPropertyScrollSnapStop:
        return ExtractorFunctions::extractScrollSnapStop(extractorState);
    case CSSPropertyID::CSSPropertyScrollSnapType:
        return ExtractorFunctions::extractScrollSnapType(extractorState);
    case CSSPropertyID::CSSPropertyScrollTimelineAxis:
        return ExtractorFunctions::extractScrollTimelineAxis(extractorState);
    case CSSPropertyID::CSSPropertyScrollTimelineName:
        return ExtractorFunctions::extractScrollTimelineName(extractorState);
    case CSSPropertyID::CSSPropertyScrollbarColor:
        return ExtractorFunctions::extractScrollbarColor(extractorState);
    case CSSPropertyID::CSSPropertyScrollbarGutter:
        return ExtractorFunctions::extractScrollbarGutter(extractorState);
    case CSSPropertyID::CSSPropertyScrollbarWidth:
        return ExtractorFunctions::extractScrollbarWidth(extractorState);
    case CSSPropertyID::CSSPropertyShapeImageThreshold:
        return ExtractorFunctions::extractShapeImageThreshold(extractorState);
    case CSSPropertyID::CSSPropertyShapeMargin:
        return ExtractorFunctions::extractShapeMargin(extractorState);
    case CSSPropertyID::CSSPropertyShapeOutside:
        return ExtractorFunctions::extractShapeOutside(extractorState);
    case CSSPropertyID::CSSPropertyShapeRendering:
        return ExtractorFunctions::extractShapeRendering(extractorState);
    case CSSPropertyID::CSSPropertySize:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertySizeAdjust:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertySpeakAs:
        return ExtractorFunctions::extractSpeakAs(extractorState);
    case CSSPropertyID::CSSPropertySrc:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyStopColor:
        return ExtractorFunctions::extractStopColor(extractorState);
    case CSSPropertyID::CSSPropertyStopOpacity:
        return ExtractorFunctions::extractStopOpacity(extractorState);
    case CSSPropertyID::CSSPropertyStroke:
        return ExtractorFunctions::extractStroke(extractorState);
    case CSSPropertyID::CSSPropertyStrokeColor:
        return ExtractorFunctions::extractStrokeColor(extractorState);
    case CSSPropertyID::CSSPropertyStrokeDasharray:
        return ExtractorFunctions::extractStrokeDasharray(extractorState);
    case CSSPropertyID::CSSPropertyStrokeDashoffset:
        return ExtractorFunctions::extractStrokeDashoffset(extractorState);
    case CSSPropertyID::CSSPropertyStrokeLinecap:
        return ExtractorFunctions::extractStrokeLinecap(extractorState);
    case CSSPropertyID::CSSPropertyStrokeLinejoin:
        return ExtractorFunctions::extractStrokeLinejoin(extractorState);
    case CSSPropertyID::CSSPropertyStrokeMiterlimit:
        return ExtractorFunctions::extractStrokeMiterlimit(extractorState);
    case CSSPropertyID::CSSPropertyStrokeOpacity:
        return ExtractorFunctions::extractStrokeOpacity(extractorState);
    case CSSPropertyID::CSSPropertyStrokeWidth:
        return ExtractorFunctions::extractStrokeWidth(extractorState);
    case CSSPropertyID::CSSPropertySuffix:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertySymbols:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertySyntax:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertySystem:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyTabSize:
        return ExtractorFunctions::extractTabSize(extractorState);
    case CSSPropertyID::CSSPropertyTableLayout:
        return ExtractorFunctions::extractTableLayout(extractorState);
    case CSSPropertyID::CSSPropertyTextAlign:
        return ExtractorFunctions::extractTextAlign(extractorState);
    case CSSPropertyID::CSSPropertyTextAlignLast:
        return ExtractorFunctions::extractTextAlignLast(extractorState);
    case CSSPropertyID::CSSPropertyTextAnchor:
        return ExtractorFunctions::extractTextAnchor(extractorState);
    case CSSPropertyID::CSSPropertyTextBoxEdge:
        return ExtractorFunctions::extractTextBoxEdge(extractorState);
    case CSSPropertyID::CSSPropertyTextBoxTrim:
        return ExtractorFunctions::extractTextBoxTrim(extractorState);
    case CSSPropertyID::CSSPropertyTextCombineUpright:
        return ExtractorFunctions::extractTextCombineUpright(extractorState);
    case CSSPropertyID::CSSPropertyTextDecorationColor:
        return ExtractorFunctions::extractTextDecorationColor(extractorState);
    case CSSPropertyID::CSSPropertyTextDecorationLine:
        return ExtractorFunctions::extractTextDecorationLine(extractorState);
    case CSSPropertyID::CSSPropertyTextDecorationSkipInk:
        return ExtractorFunctions::extractTextDecorationSkipInk(extractorState);
    case CSSPropertyID::CSSPropertyTextDecorationStyle:
        return ExtractorFunctions::extractTextDecorationStyle(extractorState);
    case CSSPropertyID::CSSPropertyTextDecorationThickness:
        return ExtractorFunctions::extractTextDecorationThickness(extractorState);
    case CSSPropertyID::CSSPropertyTextEmphasisColor:
        return ExtractorFunctions::extractTextEmphasisColor(extractorState);
    case CSSPropertyID::CSSPropertyTextEmphasisPosition:
        return ExtractorFunctions::extractTextEmphasisPosition(extractorState);
    case CSSPropertyID::CSSPropertyTextEmphasisStyle:
        return ExtractorFunctions::extractTextEmphasisStyle(extractorState);
    case CSSPropertyID::CSSPropertyTextGroupAlign:
        return ExtractorFunctions::extractTextGroupAlign(extractorState);
    case CSSPropertyID::CSSPropertyTextIndent:
        return ExtractorFunctions::extractTextIndent(extractorState);
    case CSSPropertyID::CSSPropertyTextJustify:
        return ExtractorFunctions::extractTextJustify(extractorState);
    case CSSPropertyID::CSSPropertyTextOverflow:
        return ExtractorFunctions::extractTextOverflow(extractorState);
    case CSSPropertyID::CSSPropertyTextShadow:
        return ExtractorFunctions::extractTextShadow(extractorState);
    case CSSPropertyID::CSSPropertyTextTransform:
        return ExtractorFunctions::extractTextTransform(extractorState);
    case CSSPropertyID::CSSPropertyTextUnderlineOffset:
        return ExtractorFunctions::extractTextUnderlineOffset(extractorState);
    case CSSPropertyID::CSSPropertyTextUnderlinePosition:
        return ExtractorFunctions::extractTextUnderlinePosition(extractorState);
    case CSSPropertyID::CSSPropertyTextWrapMode:
        return ExtractorFunctions::extractTextWrapMode(extractorState);
    case CSSPropertyID::CSSPropertyTextWrapStyle:
        return ExtractorFunctions::extractTextWrapStyle(extractorState);
    case CSSPropertyID::CSSPropertyTimelineScope:
        return ExtractorFunctions::extractTimelineScope(extractorState);
    case CSSPropertyID::CSSPropertyTouchAction:
        return ExtractorFunctions::extractTouchAction(extractorState);
    case CSSPropertyID::CSSPropertyTransform:
        return ExtractorCustom::extractTransform(extractorState);
    case CSSPropertyID::CSSPropertyTransformBox:
        return ExtractorFunctions::extractTransformBox(extractorState);
    case CSSPropertyID::CSSPropertyTransformOriginX:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyTransformOriginY:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyTransformOriginZ:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyTransformStyle:
        return ExtractorFunctions::extractTransformStyle(extractorState);
    case CSSPropertyID::CSSPropertyTransitionBehavior:
        return ExtractorFunctions::extractTransitionBehavior(extractorState);
    case CSSPropertyID::CSSPropertyTransitionDelay:
        return ExtractorFunctions::extractTransitionDelay(extractorState);
    case CSSPropertyID::CSSPropertyTransitionDuration:
        return ExtractorFunctions::extractTransitionDuration(extractorState);
    case CSSPropertyID::CSSPropertyTransitionProperty:
        return ExtractorFunctions::extractTransitionProperty(extractorState);
    case CSSPropertyID::CSSPropertyTransitionTimingFunction:
        return ExtractorFunctions::extractTransitionTimingFunction(extractorState);
    case CSSPropertyID::CSSPropertyTranslate:
        return ExtractorCustom::extractTranslate(extractorState);
    case CSSPropertyID::CSSPropertyTypes:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyUnicodeBidi:
        return ExtractorFunctions::extractUnicodeBidi(extractorState);
    case CSSPropertyID::CSSPropertyUnicodeRange:
        // Skipped - Descriptor-only property
        return nullptr;
    case CSSPropertyID::CSSPropertyVectorEffect:
        return ExtractorFunctions::extractVectorEffect(extractorState);
    case CSSPropertyID::CSSPropertyVerticalAlign:
        return ExtractorFunctions::extractVerticalAlign(extractorState);
    case CSSPropertyID::CSSPropertyViewTimelineAxis:
        return ExtractorFunctions::extractViewTimelineAxis(extractorState);
    case CSSPropertyID::CSSPropertyViewTimelineInset:
        return ExtractorFunctions::extractViewTimelineInset(extractorState);
    case CSSPropertyID::CSSPropertyViewTimelineName:
        return ExtractorFunctions::extractViewTimelineName(extractorState);
    case CSSPropertyID::CSSPropertyViewTransitionClass:
        return ExtractorFunctions::extractViewTransitionClass(extractorState);
    case CSSPropertyID::CSSPropertyViewTransitionName:
        return ExtractorFunctions::extractViewTransitionName(extractorState);
    case CSSPropertyID::CSSPropertyVisibility:
        return ExtractorFunctions::extractVisibility(extractorState);
    case CSSPropertyID::CSSPropertyWhiteSpaceCollapse:
        return ExtractorFunctions::extractWhiteSpaceCollapse(extractorState);
    case CSSPropertyID::CSSPropertyWidows:
        return ExtractorFunctions::extractWidows(extractorState);
    case CSSPropertyID::CSSPropertyWillChange:
        return ExtractorFunctions::extractWillChange(extractorState);
    case CSSPropertyID::CSSPropertyWordBreak:
        return ExtractorFunctions::extractWordBreak(extractorState);
    case CSSPropertyID::CSSPropertyX:
        return ExtractorFunctions::extractX(extractorState);
    case CSSPropertyID::CSSPropertyY:
        return ExtractorFunctions::extractY(extractorState);
    case CSSPropertyID::CSSPropertyZIndex:
        return ExtractorFunctions::extractZIndex(extractorState);
    case CSSPropertyID::CSSPropertyAppleColorFilter:
        return ExtractorFunctions::extractAppleColorFilter(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBackdropFilter:
        return ExtractorFunctions::extractWebkitBackdropFilter(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBackgroundClip:
        return ExtractorFunctions::extractWebkitBackgroundClip(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBackgroundOrigin:
        return ExtractorFunctions::extractWebkitBackgroundOrigin(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBorderHorizontalSpacing:
        return ExtractorFunctions::extractWebkitBorderHorizontalSpacing(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBorderVerticalSpacing:
        return ExtractorFunctions::extractWebkitBorderVerticalSpacing(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxAlign:
        return ExtractorFunctions::extractWebkitBoxAlign(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak:
        return ExtractorFunctions::extractWebkitBoxDecorationBreak(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxDirection:
        return ExtractorFunctions::extractWebkitBoxDirection(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxFlex:
        return ExtractorFunctions::extractWebkitBoxFlex(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxFlexGroup:
        return ExtractorFunctions::extractWebkitBoxFlexGroup(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxLines:
        return ExtractorFunctions::extractWebkitBoxLines(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxOrdinalGroup:
        return ExtractorFunctions::extractWebkitBoxOrdinalGroup(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxOrient:
        return ExtractorFunctions::extractWebkitBoxOrient(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxPack:
        return ExtractorFunctions::extractWebkitBoxPack(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxReflect:
        return ExtractorFunctions::extractWebkitBoxReflect(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBoxShadow:
        return ExtractorFunctions::extractWebkitBoxShadow(extractorState);
    case CSSPropertyID::CSSPropertyWebkitColumnAxis:
        return ExtractorFunctions::extractWebkitColumnAxis(extractorState);
    case CSSPropertyID::CSSPropertyWebkitColumnProgression:
        return ExtractorFunctions::extractWebkitColumnProgression(extractorState);
    case CSSPropertyID::CSSPropertyWebkitCursorVisibility:
        return ExtractorFunctions::extractWebkitCursorVisibility(extractorState);
    case CSSPropertyID::CSSPropertyWebkitFontSizeDelta:
        // Skipped - Internal only
        return nullptr;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter:
        return ExtractorFunctions::extractWebkitHyphenateLimitAfter(extractorState);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore:
        return ExtractorFunctions::extractWebkitHyphenateLimitBefore(extractorState);
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines:
        return ExtractorFunctions::extractWebkitHyphenateLimitLines(extractorState);
    case CSSPropertyID::CSSPropertyWebkitInitialLetter:
        return ExtractorFunctions::extractWebkitInitialLetter(extractorState);
    case CSSPropertyID::CSSPropertyWebkitLineAlign:
        return ExtractorFunctions::extractWebkitLineAlign(extractorState);
    case CSSPropertyID::CSSPropertyWebkitLineBoxContain:
        return ExtractorFunctions::extractWebkitLineBoxContain(extractorState);
    case CSSPropertyID::CSSPropertyWebkitLineClamp:
        return ExtractorFunctions::extractWebkitLineClamp(extractorState);
    case CSSPropertyID::CSSPropertyWebkitLineGrid:
        return ExtractorFunctions::extractWebkitLineGrid(extractorState);
    case CSSPropertyID::CSSPropertyWebkitLineSnap:
        return ExtractorFunctions::extractWebkitLineSnap(extractorState);
    case CSSPropertyID::CSSPropertyWebkitMarqueeDirection:
        // Skipped - Internal only
        return nullptr;
    case CSSPropertyID::CSSPropertyWebkitMarqueeIncrement:
        // Skipped - Internal only
        return nullptr;
    case CSSPropertyID::CSSPropertyWebkitMarqueeRepetition:
        // Skipped - Internal only
        return nullptr;
    case CSSPropertyID::CSSPropertyWebkitMarqueeSpeed:
        // Skipped - Internal only
        return nullptr;
    case CSSPropertyID::CSSPropertyWebkitMarqueeStyle:
        // Skipped - Internal only
        return nullptr;
    case CSSPropertyID::CSSPropertyWebkitMaskClip:
        return ExtractorFunctions::extractWebkitMaskClip(extractorState);
    case CSSPropertyID::CSSPropertyWebkitMaskComposite:
        return ExtractorFunctions::extractWebkitMaskComposite(extractorState);
    case CSSPropertyID::CSSPropertyWebkitMaskPositionX:
        return ExtractorFunctions::extractWebkitMaskPositionX(extractorState);
    case CSSPropertyID::CSSPropertyWebkitMaskPositionY:
        return ExtractorFunctions::extractWebkitMaskPositionY(extractorState);
    case CSSPropertyID::CSSPropertyWebkitMaskSourceType:
        return ExtractorFunctions::extractWebkitMaskSourceType(extractorState);
    case CSSPropertyID::CSSPropertyWebkitNbspMode:
        return ExtractorFunctions::extractWebkitNbspMode(extractorState);
    case CSSPropertyID::CSSPropertyWebkitRtlOrdering:
        return ExtractorFunctions::extractWebkitRtlOrdering(extractorState);
    case CSSPropertyID::CSSPropertyWebkitRubyPosition:
        return ExtractorFunctions::extractWebkitRubyPosition(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTapHighlightColor:
        return ExtractorFunctions::extractWebkitTapHighlightColor(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextCombine:
        return ExtractorFunctions::extractWebkitTextCombine(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextDecorationsInEffect:
        return ExtractorFunctions::extractWebkitTextDecorationsInEffect(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextFillColor:
        return ExtractorFunctions::extractWebkitTextFillColor(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextSecurity:
        return ExtractorFunctions::extractWebkitTextSecurity(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextStrokeColor:
        return ExtractorFunctions::extractWebkitTextStrokeColor(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextStrokeWidth:
        return ExtractorFunctions::extractWebkitTextStrokeWidth(extractorState);
    case CSSPropertyID::CSSPropertyWebkitUserDrag:
        return ExtractorFunctions::extractWebkitUserDrag(extractorState);
    case CSSPropertyID::CSSPropertyWebkitUserModify:
        return ExtractorFunctions::extractWebkitUserModify(extractorState);
    case CSSPropertyID::CSSPropertyWebkitUserSelect:
        return ExtractorFunctions::extractWebkitUserSelect(extractorState);
    case CSSPropertyID::CSSPropertyWordSpacing:
        return ExtractorCustom::extractWordSpacing(extractorState);
    case CSSPropertyID::CSSPropertyBorderBottomColor:
        return ExtractorFunctions::extractBorderBottomColor(extractorState);
    case CSSPropertyID::CSSPropertyBorderBottomLeftRadius:
        return ExtractorFunctions::extractBorderBottomLeftRadius(extractorState);
    case CSSPropertyID::CSSPropertyBorderBottomRightRadius:
        return ExtractorFunctions::extractBorderBottomRightRadius(extractorState);
    case CSSPropertyID::CSSPropertyBorderBottomStyle:
        return ExtractorFunctions::extractBorderBottomStyle(extractorState);
    case CSSPropertyID::CSSPropertyBorderBottomWidth:
        return ExtractorFunctions::extractBorderBottomWidth(extractorState);
    case CSSPropertyID::CSSPropertyBorderLeftColor:
        return ExtractorFunctions::extractBorderLeftColor(extractorState);
    case CSSPropertyID::CSSPropertyBorderLeftStyle:
        return ExtractorFunctions::extractBorderLeftStyle(extractorState);
    case CSSPropertyID::CSSPropertyBorderLeftWidth:
        return ExtractorFunctions::extractBorderLeftWidth(extractorState);
    case CSSPropertyID::CSSPropertyBorderRightColor:
        return ExtractorFunctions::extractBorderRightColor(extractorState);
    case CSSPropertyID::CSSPropertyBorderRightStyle:
        return ExtractorFunctions::extractBorderRightStyle(extractorState);
    case CSSPropertyID::CSSPropertyBorderRightWidth:
        return ExtractorFunctions::extractBorderRightWidth(extractorState);
    case CSSPropertyID::CSSPropertyBorderTopColor:
        return ExtractorFunctions::extractBorderTopColor(extractorState);
    case CSSPropertyID::CSSPropertyBorderTopLeftRadius:
        return ExtractorFunctions::extractBorderTopLeftRadius(extractorState);
    case CSSPropertyID::CSSPropertyBorderTopRightRadius:
        return ExtractorFunctions::extractBorderTopRightRadius(extractorState);
    case CSSPropertyID::CSSPropertyBorderTopStyle:
        return ExtractorFunctions::extractBorderTopStyle(extractorState);
    case CSSPropertyID::CSSPropertyBorderTopWidth:
        return ExtractorFunctions::extractBorderTopWidth(extractorState);
    case CSSPropertyID::CSSPropertyBottom:
        return ExtractorCustom::extractBottom(extractorState);
    case CSSPropertyID::CSSPropertyContainIntrinsicHeight:
        return ExtractorFunctions::extractContainIntrinsicHeight(extractorState);
    case CSSPropertyID::CSSPropertyContainIntrinsicWidth:
        return ExtractorFunctions::extractContainIntrinsicWidth(extractorState);
    case CSSPropertyID::CSSPropertyCornerBottomLeftShape:
        return ExtractorFunctions::extractCornerBottomLeftShape(extractorState);
    case CSSPropertyID::CSSPropertyCornerBottomRightShape:
        return ExtractorFunctions::extractCornerBottomRightShape(extractorState);
    case CSSPropertyID::CSSPropertyCornerTopLeftShape:
        return ExtractorFunctions::extractCornerTopLeftShape(extractorState);
    case CSSPropertyID::CSSPropertyCornerTopRightShape:
        return ExtractorFunctions::extractCornerTopRightShape(extractorState);
    case CSSPropertyID::CSSPropertyHeight:
        return ExtractorCustom::extractHeight(extractorState);
    case CSSPropertyID::CSSPropertyLeft:
        return ExtractorCustom::extractLeft(extractorState);
    case CSSPropertyID::CSSPropertyMarginBottom:
        return ExtractorCustom::extractMarginBottom(extractorState);
    case CSSPropertyID::CSSPropertyMarginLeft:
        return ExtractorCustom::extractMarginLeft(extractorState);
    case CSSPropertyID::CSSPropertyMarginRight:
        return ExtractorCustom::extractMarginRight(extractorState);
    case CSSPropertyID::CSSPropertyMarginTop:
        return ExtractorCustom::extractMarginTop(extractorState);
    case CSSPropertyID::CSSPropertyMaxHeight:
        return ExtractorCustom::extractMaxHeight(extractorState);
    case CSSPropertyID::CSSPropertyMaxWidth:
        return ExtractorCustom::extractMaxWidth(extractorState);
    case CSSPropertyID::CSSPropertyMinHeight:
        return ExtractorCustom::extractMinHeight(extractorState);
    case CSSPropertyID::CSSPropertyMinWidth:
        return ExtractorCustom::extractMinWidth(extractorState);
    case CSSPropertyID::CSSPropertyOverflowX:
        return ExtractorFunctions::extractOverflowX(extractorState);
    case CSSPropertyID::CSSPropertyOverflowY:
        return ExtractorFunctions::extractOverflowY(extractorState);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorX:
        return ExtractorFunctions::extractOverscrollBehaviorX(extractorState);
    case CSSPropertyID::CSSPropertyOverscrollBehaviorY:
        return ExtractorFunctions::extractOverscrollBehaviorY(extractorState);
    case CSSPropertyID::CSSPropertyPaddingBottom:
        return ExtractorCustom::extractPaddingBottom(extractorState);
    case CSSPropertyID::CSSPropertyPaddingLeft:
        return ExtractorCustom::extractPaddingLeft(extractorState);
    case CSSPropertyID::CSSPropertyPaddingRight:
        return ExtractorCustom::extractPaddingRight(extractorState);
    case CSSPropertyID::CSSPropertyPaddingTop:
        return ExtractorCustom::extractPaddingTop(extractorState);
    case CSSPropertyID::CSSPropertyRight:
        return ExtractorCustom::extractRight(extractorState);
    case CSSPropertyID::CSSPropertyScrollMarginBottom:
        return ExtractorFunctions::extractScrollMarginBottom(extractorState);
    case CSSPropertyID::CSSPropertyScrollMarginLeft:
        return ExtractorFunctions::extractScrollMarginLeft(extractorState);
    case CSSPropertyID::CSSPropertyScrollMarginRight:
        return ExtractorFunctions::extractScrollMarginRight(extractorState);
    case CSSPropertyID::CSSPropertyScrollMarginTop:
        return ExtractorFunctions::extractScrollMarginTop(extractorState);
    case CSSPropertyID::CSSPropertyScrollPaddingBottom:
        return ExtractorFunctions::extractScrollPaddingBottom(extractorState);
    case CSSPropertyID::CSSPropertyScrollPaddingLeft:
        return ExtractorFunctions::extractScrollPaddingLeft(extractorState);
    case CSSPropertyID::CSSPropertyScrollPaddingRight:
        return ExtractorFunctions::extractScrollPaddingRight(extractorState);
    case CSSPropertyID::CSSPropertyScrollPaddingTop:
        return ExtractorFunctions::extractScrollPaddingTop(extractorState);
    case CSSPropertyID::CSSPropertyTop:
        return ExtractorCustom::extractTop(extractorState);
    case CSSPropertyID::CSSPropertyWidth:
        return ExtractorCustom::extractWidth(extractorState);
    case CSSPropertyID::CSSPropertyBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderBlockEndColor:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderBlockEndStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderBlockEndWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderBlockStartColor:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderBlockStartStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderBlockStartWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderEndEndRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderEndStartRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderInlineEndColor:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderInlineEndStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderInlineEndWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderInlineStartColor:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderInlineStartStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderInlineStartWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderStartEndRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyBorderStartStartRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyContainIntrinsicBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyContainIntrinsicInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyCornerEndEndShape:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyCornerEndStartShape:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyCornerStartEndShape:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyCornerStartStartShape:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyInsetBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyInsetBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyInsetInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyInsetInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMarginBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMarginBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMarginInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMarginInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMaxBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMaxInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMinBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyMinInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyOverflowBlock:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyOverflowInline:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyOverscrollBehaviorBlock:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyOverscrollBehaviorInline:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyPaddingBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyPaddingBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyPaddingInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyPaddingInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollMarginBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollMarginBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollMarginInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollMarginInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollPaddingBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollPaddingBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollPaddingInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyScrollPaddingInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        return extractValue(extractorState, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
    case CSSPropertyID::CSSPropertyAll:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyAnimation:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractAnimationShorthand(extractorState);
    case CSSPropertyID::CSSPropertyAnimationRange:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractAnimationRangeShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBackground:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBackgroundShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBackgroundPosition:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBackgroundPositionShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBlockStep:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBlockStepShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorder:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBorderShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderBlock:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBorderBlockShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderBlockColor:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderBlockColorShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderBlockEnd:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderBlockEndShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderBlockStart:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderBlockStartShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderBlockStyle:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderBlockStyleShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderBlockWidth:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderBlockWidthShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderBottom:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderBottomShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderColor:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderColorShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderImage:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBorderImageShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderInline:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBorderInlineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderInlineColor:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderInlineColorShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderInlineEnd:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderInlineEndShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderInlineStart:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderInlineStartShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderInlineStyle:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderInlineStyleShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderInlineWidth:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderInlineWidthShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderLeft:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderLeftShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderRadius:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractBorderRadiusShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderRight:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderRightShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderSpacing:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderSpacingShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderStyle:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderStyleShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderTop:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderTopShorthand(extractorState);
    case CSSPropertyID::CSSPropertyBorderWidth:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractBorderWidthShorthand(extractorState);
    case CSSPropertyID::CSSPropertyColumnRule:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractColumnRuleShorthand(extractorState);
    case CSSPropertyID::CSSPropertyColumns:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractColumnsShorthand(extractorState);
    case CSSPropertyID::CSSPropertyContainIntrinsicSize:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractContainIntrinsicSizeShorthand(extractorState);
    case CSSPropertyID::CSSPropertyContainer:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractContainerShorthand(extractorState);
    case CSSPropertyID::CSSPropertyCornerShape:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractCornerShapeShorthand(extractorState);
    case CSSPropertyID::CSSPropertyFlex:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractFlexShorthand(extractorState);
    case CSSPropertyID::CSSPropertyFlexFlow:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractFlexFlowShorthand(extractorState);
    case CSSPropertyID::CSSPropertyFont:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractFontShorthand(extractorState);
    case CSSPropertyID::CSSPropertyFontSynthesis:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractFontSynthesisShorthand(extractorState);
    case CSSPropertyID::CSSPropertyFontVariant:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractFontVariantShorthand(extractorState);
    case CSSPropertyID::CSSPropertyGap:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractGapShorthand(extractorState);
    case CSSPropertyID::CSSPropertyGrid:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractGridShorthand(extractorState);
    case CSSPropertyID::CSSPropertyGridArea:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractGridAreaShorthand(extractorState);
    case CSSPropertyID::CSSPropertyGridColumn:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractGridColumnShorthand(extractorState);
    case CSSPropertyID::CSSPropertyGridRow:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractGridRowShorthand(extractorState);
    case CSSPropertyID::CSSPropertyGridTemplate:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractGridTemplateShorthand(extractorState);
    case CSSPropertyID::CSSPropertyInset:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractInsetShorthand(extractorState);
    case CSSPropertyID::CSSPropertyInsetBlock:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractInsetBlockShorthand(extractorState);
    case CSSPropertyID::CSSPropertyInsetInline:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractInsetInlineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyLineClamp:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractLineClampShorthand(extractorState);
    case CSSPropertyID::CSSPropertyListStyle:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractListStyleShorthand(extractorState);
    case CSSPropertyID::CSSPropertyMargin:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractMarginShorthand(extractorState);
    case CSSPropertyID::CSSPropertyMarginBlock:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractMarginBlockShorthand(extractorState);
    case CSSPropertyID::CSSPropertyMarginInline:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractMarginInlineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyMarker:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyMask:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractMaskShorthand(extractorState);
    case CSSPropertyID::CSSPropertyMaskBorder:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractMaskBorderShorthand(extractorState);
    case CSSPropertyID::CSSPropertyMaskPosition:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractMaskPositionShorthand(extractorState);
    case CSSPropertyID::CSSPropertyOffset:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractOffsetShorthand(extractorState);
    case CSSPropertyID::CSSPropertyOutline:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractOutlineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyOverflow:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractOverflowShorthand(extractorState);
    case CSSPropertyID::CSSPropertyOverscrollBehavior:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractOverscrollBehaviorShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPadding:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractPaddingShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPaddingBlock:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractPaddingBlockShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPaddingInline:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractPaddingInlineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPageBreakAfter:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractPageBreakAfterShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPageBreakBefore:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractPageBreakBeforeShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPageBreakInside:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractPageBreakInsideShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPerspectiveOrigin:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractPerspectiveOriginShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPlaceContent:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractPlaceContentShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPlaceItems:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractPlaceItemsShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPlaceSelf:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractPlaceSelfShorthand(extractorState);
    case CSSPropertyID::CSSPropertyPositionTry:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractPositionTryShorthand(extractorState);
    case CSSPropertyID::CSSPropertyScrollMargin:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractScrollMarginShorthand(extractorState);
    case CSSPropertyID::CSSPropertyScrollMarginBlock:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractScrollMarginBlockShorthand(extractorState);
    case CSSPropertyID::CSSPropertyScrollMarginInline:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractScrollMarginInlineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyScrollPadding:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractScrollPaddingShorthand(extractorState);
    case CSSPropertyID::CSSPropertyScrollPaddingBlock:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractScrollPaddingBlockShorthand(extractorState);
    case CSSPropertyID::CSSPropertyScrollPaddingInline:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractScrollPaddingInlineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyScrollTimeline:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractScrollTimelineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyTextBox:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractTextBoxShorthand(extractorState);
    case CSSPropertyID::CSSPropertyTextDecoration:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractTextDecorationShorthand(extractorState);
    case CSSPropertyID::CSSPropertyTextDecorationSkip:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractTextDecorationSkipShorthand(extractorState);
    case CSSPropertyID::CSSPropertyTextEmphasis:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractTextEmphasisShorthand(extractorState);
    case CSSPropertyID::CSSPropertyTextWrap:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractTextWrapShorthand(extractorState);
    case CSSPropertyID::CSSPropertyTransformOrigin:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractTransformOriginShorthand(extractorState);
    case CSSPropertyID::CSSPropertyTransition:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractTransitionShorthand(extractorState);
    case CSSPropertyID::CSSPropertyViewTimeline:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractViewTimelineShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWhiteSpace:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWhiteSpaceShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBackgroundSize:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractWebkitBackgroundSizeShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBorderImage:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWebkitBorderImageShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitBorderRadius:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWebkitBorderRadiusShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitColumnBreakAfter:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWebkitColumnBreakAfterShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitColumnBreakBefore:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWebkitColumnBreakBeforeShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitColumnBreakInside:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWebkitColumnBreakInsideShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitMask:
        // Skipped - Not computable
        return nullptr;
    case CSSPropertyID::CSSPropertyWebkitMaskBoxImage:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWebkitMaskBoxImageShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitMaskPosition:
        ASSERT(isShorthand(id));
        return ExtractorCustom::extractWebkitMaskPositionShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitPerspective:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractWebkitPerspectiveShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextDecoration:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractWebkitTextDecorationShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextOrientation:
        ASSERT(isShorthand(id));
        return ExtractorFunctions::extractWebkitTextOrientationShorthand(extractorState);
    case CSSPropertyID::CSSPropertyWebkitTextStroke:
        // Skipped - Not computable
        return nullptr;
    }
    ASSERT_NOT_REACHED();
    return nullptr;
}


void ExtractorGenerated::extractValueSerialization(ExtractorState& extractorState, StringBuilder& builder, const CSS::SerializationContext& context, CSSPropertyID id)
{
    switch (id) {
    case CSSPropertyID::CSSPropertyInvalid:
        break;
    case CSSPropertyID::CSSPropertyCustom:
        ASSERT_NOT_REACHED();
        break;
    case CSSPropertyID::CSSPropertyColorScheme:
        ExtractorFunctions::extractColorSchemeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRubyPosition:
        ExtractorFunctions::extractRubyPositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWritingMode:
        ExtractorCustom::extractWritingModeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyDirection:
        ExtractorCustom::extractDirectionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyDisplay:
        ExtractorFunctions::extractDisplaySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontFamily:
        ExtractorCustom::extractFontFamilySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontFeatureSettings:
        ExtractorFunctions::extractFontFeatureSettingsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontKerning:
        ExtractorFunctions::extractFontKerningSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontOpticalSizing:
        ExtractorFunctions::extractFontOpticalSizingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontPalette:
        ExtractorFunctions::extractFontPaletteSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontSize:
        ExtractorCustom::extractFontSizeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontSizeAdjust:
        ExtractorFunctions::extractFontSizeAdjustSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontStyle:
        ExtractorCustom::extractFontStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontSynthesisSmallCaps:
        ExtractorFunctions::extractFontSynthesisSmallCapsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontSynthesisStyle:
        ExtractorFunctions::extractFontSynthesisStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontSynthesisWeight:
        ExtractorFunctions::extractFontSynthesisWeightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariantAlternates:
        ExtractorCustom::extractFontVariantAlternatesSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariantCaps:
        ExtractorFunctions::extractFontVariantCapsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariantEastAsian:
        ExtractorCustom::extractFontVariantEastAsianSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariantEmoji:
        ExtractorFunctions::extractFontVariantEmojiSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariantLigatures:
        ExtractorCustom::extractFontVariantLigaturesSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariantNumeric:
        ExtractorCustom::extractFontVariantNumericSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariantPosition:
        ExtractorFunctions::extractFontVariantPositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariationSettings:
        ExtractorFunctions::extractFontVariationSettingsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontWeight:
        ExtractorFunctions::extractFontWeightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontWidth:
        ExtractorFunctions::extractFontWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextOrientation:
        ExtractorFunctions::extractTextOrientationSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextRendering:
        ExtractorFunctions::extractTextRenderingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyZoom:
        ExtractorFunctions::extractZoomSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitFontSmoothing:
        ExtractorFunctions::extractWebkitFontSmoothingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitLocale:
        ExtractorFunctions::extractWebkitLocaleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextZoom:
        ExtractorFunctions::extractWebkitTextZoomSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyLetterSpacing:
        ExtractorCustom::extractLetterSpacingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextAutospace:
        ExtractorFunctions::extractTextAutospaceSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextSpacingTrim:
        ExtractorFunctions::extractTextSpacingTrimSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAccentColor:
        ExtractorFunctions::extractAccentColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAdditiveSymbols:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyAlignContent:
        ExtractorFunctions::extractAlignContentSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAlignItems:
        ExtractorFunctions::extractAlignItemsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAlignSelf:
        ExtractorFunctions::extractAlignSelfSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAlignmentBaseline:
        ExtractorFunctions::extractAlignmentBaselineSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnchorName:
        ExtractorFunctions::extractAnchorNameSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnchorScope:
        ExtractorFunctions::extractAnchorScopeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationComposition:
        ExtractorFunctions::extractAnimationCompositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationDelay:
        ExtractorFunctions::extractAnimationDelaySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationDirection:
        ExtractorFunctions::extractAnimationDirectionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationDuration:
        ExtractorFunctions::extractAnimationDurationSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationFillMode:
        ExtractorFunctions::extractAnimationFillModeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationIterationCount:
        ExtractorFunctions::extractAnimationIterationCountSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationName:
        ExtractorFunctions::extractAnimationNameSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationPlayState:
        ExtractorFunctions::extractAnimationPlayStateSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationRangeEnd:
        ExtractorFunctions::extractAnimationRangeEndSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationRangeStart:
        ExtractorFunctions::extractAnimationRangeStartSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationTimeline:
        ExtractorFunctions::extractAnimationTimelineSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationTimingFunction:
        ExtractorFunctions::extractAnimationTimingFunctionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAppearance:
        ExtractorFunctions::extractAppearanceSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAspectRatio:
        ExtractorFunctions::extractAspectRatioSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackdropFilter:
        ExtractorFunctions::extractBackdropFilterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackfaceVisibility:
        ExtractorFunctions::extractBackfaceVisibilitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundAttachment:
        ExtractorFunctions::extractBackgroundAttachmentSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundBlendMode:
        ExtractorFunctions::extractBackgroundBlendModeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundClip:
        ExtractorFunctions::extractBackgroundClipSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundColor:
        ExtractorFunctions::extractBackgroundColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundImage:
        ExtractorFunctions::extractBackgroundImageSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundOrigin:
        ExtractorFunctions::extractBackgroundOriginSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundPositionX:
        ExtractorFunctions::extractBackgroundPositionXSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundPositionY:
        ExtractorFunctions::extractBackgroundPositionYSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundRepeat:
        ExtractorFunctions::extractBackgroundRepeatSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundSize:
        ExtractorFunctions::extractBackgroundSizeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBasePalette:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyBaselineShift:
        ExtractorFunctions::extractBaselineShiftSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBlockEllipsis:
        ExtractorFunctions::extractBlockEllipsisSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBlockStepAlign:
        ExtractorFunctions::extractBlockStepAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBlockStepInsert:
        ExtractorFunctions::extractBlockStepInsertSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBlockStepRound:
        ExtractorFunctions::extractBlockStepRoundSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBlockStepSize:
        ExtractorFunctions::extractBlockStepSizeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderCollapse:
        ExtractorFunctions::extractBorderCollapseSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderImageOutset:
        ExtractorCustom::extractBorderImageOutsetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderImageRepeat:
        ExtractorCustom::extractBorderImageRepeatSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderImageSlice:
        ExtractorCustom::extractBorderImageSliceSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderImageSource:
        ExtractorFunctions::extractBorderImageSourceSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderImageWidth:
        ExtractorCustom::extractBorderImageWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBoxShadow:
        ExtractorFunctions::extractBoxShadowSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBoxSizing:
        ExtractorFunctions::extractBoxSizingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBreakAfter:
        ExtractorFunctions::extractBreakAfterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBreakBefore:
        ExtractorFunctions::extractBreakBeforeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBreakInside:
        ExtractorFunctions::extractBreakInsideSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBufferedRendering:
        ExtractorFunctions::extractBufferedRenderingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCaptionSide:
        ExtractorFunctions::extractCaptionSideSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCaretColor:
        ExtractorFunctions::extractCaretColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyClear:
        ExtractorFunctions::extractClearSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyClip:
        ExtractorFunctions::extractClipSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyClipPath:
        ExtractorFunctions::extractClipPathSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyClipRule:
        ExtractorFunctions::extractClipRuleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColor:
        ExtractorFunctions::extractColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColorInterpolation:
        ExtractorFunctions::extractColorInterpolationSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColorInterpolationFilters:
        ExtractorFunctions::extractColorInterpolationFiltersSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnCount:
        ExtractorFunctions::extractColumnCountSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnFill:
        ExtractorFunctions::extractColumnFillSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnGap:
        ExtractorFunctions::extractColumnGapSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnRuleColor:
        ExtractorFunctions::extractColumnRuleColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnRuleStyle:
        ExtractorFunctions::extractColumnRuleStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnRuleWidth:
        ExtractorFunctions::extractColumnRuleWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnSpan:
        ExtractorFunctions::extractColumnSpanSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnWidth:
        ExtractorFunctions::extractColumnWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContain:
        ExtractorFunctions::extractContainSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContainerName:
        ExtractorFunctions::extractContainerNameSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContainerType:
        ExtractorFunctions::extractContainerTypeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContent:
        ExtractorCustom::extractContentSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContentVisibility:
        ExtractorFunctions::extractContentVisibilitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContinue:
        ExtractorFunctions::extractContinueSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCounterIncrement:
        ExtractorCustom::extractCounterIncrementSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCounterReset:
        ExtractorCustom::extractCounterResetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCounterSet:
        ExtractorCustom::extractCounterSetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCursor:
        ExtractorFunctions::extractCursorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCx:
        ExtractorFunctions::extractCxSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCy:
        ExtractorFunctions::extractCySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyD:
        ExtractorFunctions::extractDSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyDominantBaseline:
        ExtractorFunctions::extractDominantBaselineSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyDynamicRangeLimit:
        ExtractorFunctions::extractDynamicRangeLimitSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyEmptyCells:
        ExtractorFunctions::extractEmptyCellsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFallback:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyFieldSizing:
        ExtractorFunctions::extractFieldSizingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFill:
        ExtractorFunctions::extractFillSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFillOpacity:
        ExtractorFunctions::extractFillOpacitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFillRule:
        ExtractorFunctions::extractFillRuleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFilter:
        ExtractorFunctions::extractFilterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFlexBasis:
        ExtractorFunctions::extractFlexBasisSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFlexDirection:
        ExtractorFunctions::extractFlexDirectionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFlexGrow:
        ExtractorFunctions::extractFlexGrowSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFlexShrink:
        ExtractorFunctions::extractFlexShrinkSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFlexWrap:
        ExtractorFunctions::extractFlexWrapSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFloat:
        ExtractorCustom::extractFloatSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFloodColor:
        ExtractorFunctions::extractFloodColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFloodOpacity:
        ExtractorFunctions::extractFloodOpacitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontDisplay:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyGlyphOrientationHorizontal:
        ExtractorFunctions::extractGlyphOrientationHorizontalSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGlyphOrientationVertical:
        ExtractorFunctions::extractGlyphOrientationVerticalSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridAutoColumns:
        ExtractorFunctions::extractGridAutoColumnsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridAutoFlow:
        ExtractorFunctions::extractGridAutoFlowSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridAutoRows:
        ExtractorFunctions::extractGridAutoRowsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridColumnEnd:
        ExtractorFunctions::extractGridColumnEndSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridColumnStart:
        ExtractorFunctions::extractGridColumnStartSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridRowEnd:
        ExtractorFunctions::extractGridRowEndSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridRowStart:
        ExtractorFunctions::extractGridRowStartSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridTemplateAreas:
        ExtractorFunctions::extractGridTemplateAreasSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridTemplateColumns:
        ExtractorCustom::extractGridTemplateColumnsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridTemplateRows:
        ExtractorCustom::extractGridTemplateRowsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyHangingPunctuation:
        ExtractorFunctions::extractHangingPunctuationSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyHyphenateCharacter:
        ExtractorFunctions::extractHyphenateCharacterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyHyphens:
        ExtractorFunctions::extractHyphensSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyImageOrientation:
        ExtractorFunctions::extractImageOrientationSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyImageRendering:
        ExtractorFunctions::extractImageRenderingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyInherits:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyInitialValue:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyInputSecurity:
        ExtractorFunctions::extractInputSecuritySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyIsolation:
        ExtractorFunctions::extractIsolationSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyJustifyContent:
        ExtractorFunctions::extractJustifyContentSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyJustifyItems:
        ExtractorFunctions::extractJustifyItemsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyJustifySelf:
        ExtractorFunctions::extractJustifySelfSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyLightingColor:
        ExtractorFunctions::extractLightingColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyLineBreak:
        ExtractorFunctions::extractLineBreakSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyLineFitEdge:
        ExtractorFunctions::extractLineFitEdgeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyLineHeight:
        ExtractorCustom::extractLineHeightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyListStyleImage:
        ExtractorFunctions::extractListStyleImageSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyListStylePosition:
        ExtractorFunctions::extractListStylePositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyListStyleType:
        ExtractorFunctions::extractListStyleTypeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarginTrim:
        ExtractorFunctions::extractMarginTrimSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarkerEnd:
        ExtractorFunctions::extractMarkerEndSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarkerMid:
        ExtractorFunctions::extractMarkerMidSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarkerStart:
        ExtractorFunctions::extractMarkerStartSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskBorderOutset:
        ExtractorCustom::extractMaskBorderOutsetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskBorderRepeat:
        ExtractorCustom::extractMaskBorderRepeatSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskBorderSlice:
        ExtractorCustom::extractMaskBorderSliceSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskBorderSource:
        ExtractorFunctions::extractMaskBorderSourceSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskBorderWidth:
        ExtractorCustom::extractMaskBorderWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskClip:
        ExtractorFunctions::extractMaskClipSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskComposite:
        ExtractorFunctions::extractMaskCompositeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskImage:
        ExtractorFunctions::extractMaskImageSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskMode:
        ExtractorFunctions::extractMaskModeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskOrigin:
        ExtractorFunctions::extractMaskOriginSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskRepeat:
        ExtractorFunctions::extractMaskRepeatSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskSize:
        ExtractorFunctions::extractMaskSizeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskType:
        ExtractorFunctions::extractMaskTypeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMathStyle:
        ExtractorFunctions::extractMathStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaxLines:
        ExtractorFunctions::extractMaxLinesSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMixBlendMode:
        ExtractorFunctions::extractMixBlendModeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyNavigation:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyNegative:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyObjectFit:
        ExtractorFunctions::extractObjectFitSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyObjectPosition:
        ExtractorFunctions::extractObjectPositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOffsetAnchor:
        ExtractorFunctions::extractOffsetAnchorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOffsetDistance:
        ExtractorFunctions::extractOffsetDistanceSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOffsetPath:
        ExtractorFunctions::extractOffsetPathSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOffsetPosition:
        ExtractorFunctions::extractOffsetPositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOffsetRotate:
        ExtractorFunctions::extractOffsetRotateSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOpacity:
        ExtractorFunctions::extractOpacitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOrder:
        ExtractorFunctions::extractOrderSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOrphans:
        ExtractorFunctions::extractOrphansSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOutlineColor:
        ExtractorFunctions::extractOutlineColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOutlineOffset:
        ExtractorFunctions::extractOutlineOffsetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOutlineStyle:
        ExtractorFunctions::extractOutlineStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOutlineWidth:
        ExtractorFunctions::extractOutlineWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverflowAnchor:
        ExtractorFunctions::extractOverflowAnchorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverflowWrap:
        ExtractorFunctions::extractOverflowWrapSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverrideColors:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyPad:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyPage:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyPaintOrder:
        ExtractorFunctions::extractPaintOrderSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPerspective:
        ExtractorFunctions::extractPerspectiveSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPerspectiveOriginX:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyPerspectiveOriginY:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyPointerEvents:
        ExtractorFunctions::extractPointerEventsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPosition:
        ExtractorFunctions::extractPositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPositionAnchor:
        ExtractorFunctions::extractPositionAnchorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPositionArea:
        ExtractorFunctions::extractPositionAreaSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPositionTryFallbacks:
        ExtractorFunctions::extractPositionTryFallbacksSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPositionTryOrder:
        ExtractorFunctions::extractPositionTryOrderSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPositionVisibility:
        ExtractorFunctions::extractPositionVisibilitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPrefix:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyPrintColorAdjust:
        ExtractorFunctions::extractPrintColorAdjustSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyQuotes:
        ExtractorFunctions::extractQuotesSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyR:
        ExtractorFunctions::extractRSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRange:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyResize:
        ExtractorFunctions::extractResizeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRotate:
        ExtractorCustom::extractRotateSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRowGap:
        ExtractorFunctions::extractRowGapSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRubyAlign:
        ExtractorFunctions::extractRubyAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRubyOverhang:
        ExtractorFunctions::extractRubyOverhangSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRx:
        ExtractorFunctions::extractRxSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRy:
        ExtractorFunctions::extractRySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScale:
        ExtractorCustom::extractScaleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollBehavior:
        ExtractorFunctions::extractScrollBehaviorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollSnapAlign:
        ExtractorFunctions::extractScrollSnapAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollSnapStop:
        ExtractorFunctions::extractScrollSnapStopSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollSnapType:
        ExtractorFunctions::extractScrollSnapTypeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollTimelineAxis:
        ExtractorFunctions::extractScrollTimelineAxisSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollTimelineName:
        ExtractorFunctions::extractScrollTimelineNameSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollbarColor:
        ExtractorFunctions::extractScrollbarColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollbarGutter:
        ExtractorFunctions::extractScrollbarGutterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollbarWidth:
        ExtractorFunctions::extractScrollbarWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyShapeImageThreshold:
        ExtractorFunctions::extractShapeImageThresholdSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyShapeMargin:
        ExtractorFunctions::extractShapeMarginSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyShapeOutside:
        ExtractorFunctions::extractShapeOutsideSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyShapeRendering:
        ExtractorFunctions::extractShapeRenderingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertySize:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertySizeAdjust:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertySpeakAs:
        ExtractorFunctions::extractSpeakAsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertySrc:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyStopColor:
        ExtractorFunctions::extractStopColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStopOpacity:
        ExtractorFunctions::extractStopOpacitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStroke:
        ExtractorFunctions::extractStrokeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeColor:
        ExtractorFunctions::extractStrokeColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeDasharray:
        ExtractorFunctions::extractStrokeDasharraySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeDashoffset:
        ExtractorFunctions::extractStrokeDashoffsetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeLinecap:
        ExtractorFunctions::extractStrokeLinecapSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeLinejoin:
        ExtractorFunctions::extractStrokeLinejoinSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeMiterlimit:
        ExtractorFunctions::extractStrokeMiterlimitSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeOpacity:
        ExtractorFunctions::extractStrokeOpacitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyStrokeWidth:
        ExtractorFunctions::extractStrokeWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertySuffix:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertySymbols:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertySyntax:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertySystem:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyTabSize:
        ExtractorFunctions::extractTabSizeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTableLayout:
        ExtractorFunctions::extractTableLayoutSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextAlign:
        ExtractorFunctions::extractTextAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextAlignLast:
        ExtractorFunctions::extractTextAlignLastSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextAnchor:
        ExtractorFunctions::extractTextAnchorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextBoxEdge:
        ExtractorFunctions::extractTextBoxEdgeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextBoxTrim:
        ExtractorFunctions::extractTextBoxTrimSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextCombineUpright:
        ExtractorFunctions::extractTextCombineUprightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextDecorationColor:
        ExtractorFunctions::extractTextDecorationColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextDecorationLine:
        ExtractorFunctions::extractTextDecorationLineSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextDecorationSkipInk:
        ExtractorFunctions::extractTextDecorationSkipInkSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextDecorationStyle:
        ExtractorFunctions::extractTextDecorationStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextDecorationThickness:
        ExtractorFunctions::extractTextDecorationThicknessSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextEmphasisColor:
        ExtractorFunctions::extractTextEmphasisColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextEmphasisPosition:
        ExtractorFunctions::extractTextEmphasisPositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextEmphasisStyle:
        ExtractorFunctions::extractTextEmphasisStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextGroupAlign:
        ExtractorFunctions::extractTextGroupAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextIndent:
        ExtractorFunctions::extractTextIndentSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextJustify:
        ExtractorFunctions::extractTextJustifySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextOverflow:
        ExtractorFunctions::extractTextOverflowSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextShadow:
        ExtractorFunctions::extractTextShadowSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextTransform:
        ExtractorFunctions::extractTextTransformSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextUnderlineOffset:
        ExtractorFunctions::extractTextUnderlineOffsetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextUnderlinePosition:
        ExtractorFunctions::extractTextUnderlinePositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextWrapMode:
        ExtractorFunctions::extractTextWrapModeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextWrapStyle:
        ExtractorFunctions::extractTextWrapStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTimelineScope:
        ExtractorFunctions::extractTimelineScopeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTouchAction:
        ExtractorFunctions::extractTouchActionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransform:
        ExtractorCustom::extractTransformSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransformBox:
        ExtractorFunctions::extractTransformBoxSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransformOriginX:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyTransformOriginY:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyTransformOriginZ:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyTransformStyle:
        ExtractorFunctions::extractTransformStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransitionBehavior:
        ExtractorFunctions::extractTransitionBehaviorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransitionDelay:
        ExtractorFunctions::extractTransitionDelaySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransitionDuration:
        ExtractorFunctions::extractTransitionDurationSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransitionProperty:
        ExtractorFunctions::extractTransitionPropertySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransitionTimingFunction:
        ExtractorFunctions::extractTransitionTimingFunctionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTranslate:
        ExtractorCustom::extractTranslateSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTypes:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyUnicodeBidi:
        ExtractorFunctions::extractUnicodeBidiSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyUnicodeRange:
        // Skipped - Descriptor-only property
        return;
    case CSSPropertyID::CSSPropertyVectorEffect:
        ExtractorFunctions::extractVectorEffectSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyVerticalAlign:
        ExtractorFunctions::extractVerticalAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyViewTimelineAxis:
        ExtractorFunctions::extractViewTimelineAxisSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyViewTimelineInset:
        ExtractorFunctions::extractViewTimelineInsetSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyViewTimelineName:
        ExtractorFunctions::extractViewTimelineNameSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyViewTransitionClass:
        ExtractorFunctions::extractViewTransitionClassSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyViewTransitionName:
        ExtractorFunctions::extractViewTransitionNameSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyVisibility:
        ExtractorFunctions::extractVisibilitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWhiteSpaceCollapse:
        ExtractorFunctions::extractWhiteSpaceCollapseSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWidows:
        ExtractorFunctions::extractWidowsSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWillChange:
        ExtractorFunctions::extractWillChangeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWordBreak:
        ExtractorFunctions::extractWordBreakSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyX:
        ExtractorFunctions::extractXSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyY:
        ExtractorFunctions::extractYSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyZIndex:
        ExtractorFunctions::extractZIndexSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAppleColorFilter:
        ExtractorFunctions::extractAppleColorFilterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBackdropFilter:
        ExtractorFunctions::extractWebkitBackdropFilterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBackgroundClip:
        ExtractorFunctions::extractWebkitBackgroundClipSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBackgroundOrigin:
        ExtractorFunctions::extractWebkitBackgroundOriginSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBorderHorizontalSpacing:
        ExtractorFunctions::extractWebkitBorderHorizontalSpacingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBorderVerticalSpacing:
        ExtractorFunctions::extractWebkitBorderVerticalSpacingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxAlign:
        ExtractorFunctions::extractWebkitBoxAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak:
        ExtractorFunctions::extractWebkitBoxDecorationBreakSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxDirection:
        ExtractorFunctions::extractWebkitBoxDirectionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxFlex:
        ExtractorFunctions::extractWebkitBoxFlexSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxFlexGroup:
        ExtractorFunctions::extractWebkitBoxFlexGroupSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxLines:
        ExtractorFunctions::extractWebkitBoxLinesSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxOrdinalGroup:
        ExtractorFunctions::extractWebkitBoxOrdinalGroupSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxOrient:
        ExtractorFunctions::extractWebkitBoxOrientSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxPack:
        ExtractorFunctions::extractWebkitBoxPackSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxReflect:
        ExtractorFunctions::extractWebkitBoxReflectSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBoxShadow:
        ExtractorFunctions::extractWebkitBoxShadowSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitColumnAxis:
        ExtractorFunctions::extractWebkitColumnAxisSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitColumnProgression:
        ExtractorFunctions::extractWebkitColumnProgressionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitCursorVisibility:
        ExtractorFunctions::extractWebkitCursorVisibilitySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitFontSizeDelta:
        // Skipped - Internal only
        return;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter:
        ExtractorFunctions::extractWebkitHyphenateLimitAfterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore:
        ExtractorFunctions::extractWebkitHyphenateLimitBeforeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines:
        ExtractorFunctions::extractWebkitHyphenateLimitLinesSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitInitialLetter:
        ExtractorFunctions::extractWebkitInitialLetterSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitLineAlign:
        ExtractorFunctions::extractWebkitLineAlignSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitLineBoxContain:
        ExtractorFunctions::extractWebkitLineBoxContainSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitLineClamp:
        ExtractorFunctions::extractWebkitLineClampSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitLineGrid:
        ExtractorFunctions::extractWebkitLineGridSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitLineSnap:
        ExtractorFunctions::extractWebkitLineSnapSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitMarqueeDirection:
        // Skipped - Internal only
        return;
    case CSSPropertyID::CSSPropertyWebkitMarqueeIncrement:
        // Skipped - Internal only
        return;
    case CSSPropertyID::CSSPropertyWebkitMarqueeRepetition:
        // Skipped - Internal only
        return;
    case CSSPropertyID::CSSPropertyWebkitMarqueeSpeed:
        // Skipped - Internal only
        return;
    case CSSPropertyID::CSSPropertyWebkitMarqueeStyle:
        // Skipped - Internal only
        return;
    case CSSPropertyID::CSSPropertyWebkitMaskClip:
        ExtractorFunctions::extractWebkitMaskClipSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitMaskComposite:
        ExtractorFunctions::extractWebkitMaskCompositeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitMaskPositionX:
        ExtractorFunctions::extractWebkitMaskPositionXSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitMaskPositionY:
        ExtractorFunctions::extractWebkitMaskPositionYSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitMaskSourceType:
        ExtractorFunctions::extractWebkitMaskSourceTypeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitNbspMode:
        ExtractorFunctions::extractWebkitNbspModeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitRtlOrdering:
        ExtractorFunctions::extractWebkitRtlOrderingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitRubyPosition:
        ExtractorFunctions::extractWebkitRubyPositionSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTapHighlightColor:
        ExtractorFunctions::extractWebkitTapHighlightColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextCombine:
        ExtractorFunctions::extractWebkitTextCombineSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextDecorationsInEffect:
        ExtractorFunctions::extractWebkitTextDecorationsInEffectSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextFillColor:
        ExtractorFunctions::extractWebkitTextFillColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextSecurity:
        ExtractorFunctions::extractWebkitTextSecuritySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextStrokeColor:
        ExtractorFunctions::extractWebkitTextStrokeColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextStrokeWidth:
        ExtractorFunctions::extractWebkitTextStrokeWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitUserDrag:
        ExtractorFunctions::extractWebkitUserDragSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitUserModify:
        ExtractorFunctions::extractWebkitUserModifySerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitUserSelect:
        ExtractorFunctions::extractWebkitUserSelectSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWordSpacing:
        ExtractorCustom::extractWordSpacingSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBottomColor:
        ExtractorFunctions::extractBorderBottomColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBottomLeftRadius:
        ExtractorFunctions::extractBorderBottomLeftRadiusSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBottomRightRadius:
        ExtractorFunctions::extractBorderBottomRightRadiusSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBottomStyle:
        ExtractorFunctions::extractBorderBottomStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBottomWidth:
        ExtractorFunctions::extractBorderBottomWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderLeftColor:
        ExtractorFunctions::extractBorderLeftColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderLeftStyle:
        ExtractorFunctions::extractBorderLeftStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderLeftWidth:
        ExtractorFunctions::extractBorderLeftWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderRightColor:
        ExtractorFunctions::extractBorderRightColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderRightStyle:
        ExtractorFunctions::extractBorderRightStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderRightWidth:
        ExtractorFunctions::extractBorderRightWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderTopColor:
        ExtractorFunctions::extractBorderTopColorSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderTopLeftRadius:
        ExtractorFunctions::extractBorderTopLeftRadiusSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderTopRightRadius:
        ExtractorFunctions::extractBorderTopRightRadiusSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderTopStyle:
        ExtractorFunctions::extractBorderTopStyleSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderTopWidth:
        ExtractorFunctions::extractBorderTopWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBottom:
        ExtractorCustom::extractBottomSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContainIntrinsicHeight:
        ExtractorFunctions::extractContainIntrinsicHeightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContainIntrinsicWidth:
        ExtractorFunctions::extractContainIntrinsicWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCornerBottomLeftShape:
        ExtractorFunctions::extractCornerBottomLeftShapeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCornerBottomRightShape:
        ExtractorFunctions::extractCornerBottomRightShapeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCornerTopLeftShape:
        ExtractorFunctions::extractCornerTopLeftShapeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCornerTopRightShape:
        ExtractorFunctions::extractCornerTopRightShapeSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyHeight:
        ExtractorCustom::extractHeightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyLeft:
        ExtractorCustom::extractLeftSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarginBottom:
        ExtractorCustom::extractMarginBottomSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarginLeft:
        ExtractorCustom::extractMarginLeftSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarginRight:
        ExtractorCustom::extractMarginRightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarginTop:
        ExtractorCustom::extractMarginTopSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaxHeight:
        ExtractorCustom::extractMaxHeightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaxWidth:
        ExtractorCustom::extractMaxWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMinHeight:
        ExtractorCustom::extractMinHeightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMinWidth:
        ExtractorCustom::extractMinWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverflowX:
        ExtractorFunctions::extractOverflowXSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverflowY:
        ExtractorFunctions::extractOverflowYSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorX:
        ExtractorFunctions::extractOverscrollBehaviorXSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorY:
        ExtractorFunctions::extractOverscrollBehaviorYSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPaddingBottom:
        ExtractorCustom::extractPaddingBottomSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPaddingLeft:
        ExtractorCustom::extractPaddingLeftSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPaddingRight:
        ExtractorCustom::extractPaddingRightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPaddingTop:
        ExtractorCustom::extractPaddingTopSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyRight:
        ExtractorCustom::extractRightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollMarginBottom:
        ExtractorFunctions::extractScrollMarginBottomSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollMarginLeft:
        ExtractorFunctions::extractScrollMarginLeftSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollMarginRight:
        ExtractorFunctions::extractScrollMarginRightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollMarginTop:
        ExtractorFunctions::extractScrollMarginTopSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingBottom:
        ExtractorFunctions::extractScrollPaddingBottomSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingLeft:
        ExtractorFunctions::extractScrollPaddingLeftSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingRight:
        ExtractorFunctions::extractScrollPaddingRightSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingTop:
        ExtractorFunctions::extractScrollPaddingTopSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTop:
        ExtractorCustom::extractTopSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWidth:
        ExtractorCustom::extractWidthSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderBlockEndColor:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderBlockEndStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderBlockEndWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderBlockStartColor:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderBlockStartStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderBlockStartWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderEndEndRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderEndStartRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderInlineEndColor:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderInlineEndStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderInlineEndWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderInlineStartColor:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderInlineStartStyle:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderInlineStartWidth:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderStartEndRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyBorderStartStartRadius:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyContainIntrinsicBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyContainIntrinsicInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyCornerEndEndShape:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyCornerEndStartShape:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyCornerStartEndShape:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyCornerStartStartShape:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyInsetBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyInsetBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyInsetInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyInsetInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMarginBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMarginBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMarginInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMarginInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMaxBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMaxInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMinBlockSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyMinInlineSize:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyOverflowBlock:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyOverflowInline:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorBlock:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyOverscrollBehaviorInline:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyPaddingBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyPaddingBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyPaddingInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyPaddingInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollMarginBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollMarginBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollMarginInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollMarginInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingBlockEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingBlockStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingInlineEnd:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingInlineStart:
        // Logical properties are handled by recursing using the direction resolved property.
        extractValueSerialization(extractorState, builder, context, CSSProperty::resolveDirectionAwareProperty(id, extractorState.style.writingMode()));
        return;
    case CSSPropertyID::CSSPropertyAll:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyAnimation:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractAnimationShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyAnimationRange:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractAnimationRangeShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackground:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBackgroundShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBackgroundPosition:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBackgroundPositionShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBlockStep:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBlockStepShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorder:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBorderShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBlock:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBorderBlockShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBlockColor:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderBlockColorShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBlockEnd:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderBlockEndShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBlockStart:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderBlockStartShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBlockStyle:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderBlockStyleShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBlockWidth:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderBlockWidthShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderBottom:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderBottomShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderColor:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderColorShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderImage:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBorderImageShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderInline:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBorderInlineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderInlineColor:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderInlineColorShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderInlineEnd:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderInlineEndShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderInlineStart:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderInlineStartShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderInlineStyle:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderInlineStyleShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderInlineWidth:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderInlineWidthShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderLeft:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderLeftShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderRadius:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractBorderRadiusShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderRight:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderRightShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderSpacing:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderSpacingShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderStyle:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderStyleShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderTop:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderTopShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyBorderWidth:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractBorderWidthShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumnRule:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractColumnRuleShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyColumns:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractColumnsShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContainIntrinsicSize:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractContainIntrinsicSizeShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyContainer:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractContainerShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyCornerShape:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractCornerShapeShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFlex:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractFlexShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFlexFlow:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractFlexFlowShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFont:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractFontShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontSynthesis:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractFontSynthesisShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyFontVariant:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractFontVariantShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGap:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractGapShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGrid:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractGridShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridArea:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractGridAreaShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridColumn:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractGridColumnShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridRow:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractGridRowShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyGridTemplate:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractGridTemplateShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyInset:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractInsetShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyInsetBlock:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractInsetBlockShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyInsetInline:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractInsetInlineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyLineClamp:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractLineClampShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyListStyle:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractListStyleShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMargin:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractMarginShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarginBlock:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractMarginBlockShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarginInline:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractMarginInlineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMarker:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyMask:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractMaskShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskBorder:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractMaskBorderShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyMaskPosition:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractMaskPositionShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOffset:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractOffsetShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOutline:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractOutlineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverflow:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractOverflowShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyOverscrollBehavior:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractOverscrollBehaviorShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPadding:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractPaddingShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPaddingBlock:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractPaddingBlockShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPaddingInline:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractPaddingInlineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPageBreakAfter:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractPageBreakAfterShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPageBreakBefore:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractPageBreakBeforeShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPageBreakInside:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractPageBreakInsideShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPerspectiveOrigin:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractPerspectiveOriginShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPlaceContent:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractPlaceContentShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPlaceItems:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractPlaceItemsShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPlaceSelf:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractPlaceSelfShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyPositionTry:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractPositionTryShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollMargin:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractScrollMarginShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollMarginBlock:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractScrollMarginBlockShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollMarginInline:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractScrollMarginInlineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollPadding:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractScrollPaddingShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingBlock:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractScrollPaddingBlockShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollPaddingInline:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractScrollPaddingInlineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyScrollTimeline:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractScrollTimelineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextBox:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractTextBoxShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextDecoration:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractTextDecorationShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextDecorationSkip:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractTextDecorationSkipShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextEmphasis:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractTextEmphasisShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTextWrap:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractTextWrapShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransformOrigin:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractTransformOriginShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyTransition:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractTransitionShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyViewTimeline:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractViewTimelineShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWhiteSpace:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWhiteSpaceShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBackgroundSize:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractWebkitBackgroundSizeShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBorderImage:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWebkitBorderImageShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitBorderRadius:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWebkitBorderRadiusShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakAfter:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWebkitColumnBreakAfterShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakBefore:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWebkitColumnBreakBeforeShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitColumnBreakInside:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWebkitColumnBreakInsideShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitMask:
        // Skipped - Not computable
        return;
    case CSSPropertyID::CSSPropertyWebkitMaskBoxImage:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWebkitMaskBoxImageShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitMaskPosition:
        ASSERT(isShorthand(id));
        ExtractorCustom::extractWebkitMaskPositionShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitPerspective:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractWebkitPerspectiveShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextDecoration:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractWebkitTextDecorationShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextOrientation:
        ASSERT(isShorthand(id));
        ExtractorFunctions::extractWebkitTextOrientationShorthandSerialization(extractorState, builder, context);
        return;
    case CSSPropertyID::CSSPropertyWebkitTextStroke:
        // Skipped - Not computable
        return;
    }
    ASSERT_NOT_REACHED();
}

} // namespace WebCore
} // namespace Style

