/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSFileSystemFileHandle.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSFile.h"
#include "JSFileSystemSyncAccessHandle.h"
#include "JSFileSystemWritableFileStream.h"
#include "JSWorkerGlobalScopeBase.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<FileSystemFileHandle::CreateWritableOptions>> convertDictionary<FileSystemFileHandle::CreateWritableOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    FileSystemFileHandle::CreateWritableOptions result;
    JSValue keepExistingDataValue;
    if (isNullOrUndefined)
        keepExistingDataValue = jsUndefined();
    else {
        keepExistingDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keepExistingData"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto keepExistingDataConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, keepExistingDataValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (keepExistingDataConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.keepExistingData = keepExistingDataConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsFileSystemFileHandlePrototypeFunction_getFile);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemFileHandlePrototypeFunction_createSyncAccessHandle);
static JSC_DECLARE_HOST_FUNCTION(jsFileSystemFileHandlePrototypeFunction_createWritable);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsFileSystemFileHandleConstructor);

class JSFileSystemFileHandlePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSFileSystemFileHandlePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSFileSystemFileHandlePrototype* ptr = new (NotNull, JSC::allocateCell<JSFileSystemFileHandlePrototype>(vm)) JSFileSystemFileHandlePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemFileHandlePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSFileSystemFileHandlePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSFileSystemFileHandlePrototype, JSFileSystemFileHandlePrototype::Base);

using JSFileSystemFileHandleDOMConstructor = JSDOMConstructorNotConstructable<JSFileSystemFileHandle>;

template<> const ClassInfo JSFileSystemFileHandleDOMConstructor::s_info = { "FileSystemFileHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileHandleDOMConstructor) };

template<> JSValue JSFileSystemFileHandleDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSFileSystemHandle::getConstructor(vm, &globalObject);
}

template<> void JSFileSystemFileHandleDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "FileSystemFileHandle"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSFileSystemFileHandle::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 4> JSFileSystemFileHandlePrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsFileSystemFileHandleConstructor, 0 } },
    HashTableValue { "getFile"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemFileHandlePrototypeFunction_getFile, 0 } },
    HashTableValue { "createSyncAccessHandle"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemFileHandlePrototypeFunction_createSyncAccessHandle, 0 } },
    HashTableValue { "createWritable"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsFileSystemFileHandlePrototypeFunction_createWritable, 0 } },
};

const ClassInfo JSFileSystemFileHandlePrototype::s_info = { "FileSystemFileHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileHandlePrototype) };

void JSFileSystemFileHandlePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSFileSystemFileHandle::info(), JSFileSystemFileHandlePrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!((globalObject())->inherits<JSWorkerGlobalScopeBase>() && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().accessHandleEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "createSyncAccessHandle"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().accessHandleEnabled && jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().fileSystemWritableStreamEnabled)) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "createWritable"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSFileSystemFileHandle::s_info = { "FileSystemFileHandle"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSFileSystemFileHandle) };

JSFileSystemFileHandle::JSFileSystemFileHandle(Structure* structure, JSDOMGlobalObject& globalObject, Ref<FileSystemFileHandle>&& impl)
    : JSFileSystemHandle(structure, globalObject, WTFMove(impl))
{
}

Ref<FileSystemFileHandle> JSFileSystemFileHandle::protectedWrapped() const
{
    return wrapped();
}

static_assert(std::is_base_of<ActiveDOMObject, FileSystemFileHandle>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSFileSystemFileHandle::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSFileSystemFileHandlePrototype::createStructure(vm, &globalObject, JSFileSystemHandle::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSFileSystemFileHandlePrototype::create(vm, &globalObject, structure);
}

JSObject* JSFileSystemFileHandle::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSFileSystemFileHandle>(vm, globalObject);
}

JSValue JSFileSystemFileHandle::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileSystemFileHandleDOMConstructor, DOMConstructorID::FileSystemFileHandle>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsFileSystemFileHandleConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSFileSystemFileHandlePrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSFileSystemFileHandle::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsFileSystemFileHandlePrototypeFunction_getFileBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemFileHandle>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<File>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.getFile(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemFileHandlePrototypeFunction_getFile, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemFileHandle>::call<jsFileSystemFileHandlePrototypeFunction_getFileBody>(*lexicalGlobalObject, *callFrame, "getFile");
}

static inline JSC::EncodedJSValue jsFileSystemFileHandlePrototypeFunction_createSyncAccessHandleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemFileHandle>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<FileSystemSyncAccessHandle>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createSyncAccessHandle(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemFileHandlePrototypeFunction_createSyncAccessHandle, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemFileHandle>::call<jsFileSystemFileHandlePrototypeFunction_createSyncAccessHandleBody>(*lexicalGlobalObject, *callFrame, "createSyncAccessHandle");
}

static inline JSC::EncodedJSValue jsFileSystemFileHandlePrototypeFunction_createWritableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSFileSystemFileHandle>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<FileSystemFileHandle::CreateWritableOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<FileSystemWritableFileStream>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.createWritable(optionsConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsFileSystemFileHandlePrototypeFunction_createWritable, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSFileSystemFileHandle>::call<jsFileSystemFileHandlePrototypeFunction_createWritableBody>(*lexicalGlobalObject, *callFrame, "createWritable");
}

JSC::GCClient::IsoSubspace* JSFileSystemFileHandle::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSFileSystemFileHandle, UseCustomHeapCellType::No>(vm, "JSFileSystemFileHandle"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForFileSystemFileHandle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForFileSystemFileHandle = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForFileSystemFileHandle.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForFileSystemFileHandle = std::forward<decltype(space)>(space); }
    );
}

void JSFileSystemFileHandle::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSFileSystemFileHandle*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSFileSystemFileHandleOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    SUPPRESS_UNCOUNTED_LOCAL auto* jsFileSystemFileHandle = jsCast<JSFileSystemFileHandle*>(handle.slot()->asCell());
    SUPPRESS_UNCOUNTED_LOCAL auto& wrapped = jsFileSystemFileHandle->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (reason) [[unlikely]]
            *reason = "ActiveDOMObject with pending activity"_s;
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSFileSystemFileHandleOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsFileSystemFileHandle = static_cast<JSFileSystemFileHandle*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileSystemFileHandle->protectedWrapped().ptr(), jsFileSystemFileHandle);
}


}
