/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSImageResource.h"

#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ImageResource>> convertDictionary<ImageResource>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ImageResource result;
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!labelValue.isUndefined()) {
        auto labelConversionResult = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
        if (labelConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.label = labelConversionResult.releaseReturnValue();
    }
    JSValue sizesValue;
    if (isNullOrUndefined)
        sizesValue = jsUndefined();
    else {
        sizesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sizes"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!sizesValue.isUndefined()) {
        auto sizesConversionResult = convert<IDLDOMString>(lexicalGlobalObject, sizesValue);
        if (sizesConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.sizes = sizesConversionResult.releaseReturnValue();
    }
    JSValue srcValue;
    if (isNullOrUndefined)
        srcValue = jsUndefined();
    else {
        srcValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "src"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (srcValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "src"_s, "ImageResource"_s, "USVString"_s);
        return ConversionResultException { };
    }
    auto srcConversionResult = convert<IDLUSVString>(lexicalGlobalObject, srcValue);
    if (srcConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.src = srcConversionResult.releaseReturnValue();
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!typeValue.isUndefined()) {
        auto typeConversionResult = convert<IDLDOMString>(lexicalGlobalObject, typeValue);
        if (typeConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.type = typeConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

