/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoTrack.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "JSVideoTrackConfiguration.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

#if ENABLE(MEDIA_SOURCE)
#include "JSDOMConvertNullable.h"
#include "JSSourceBuffer.h"
#include "VideoTrackMediaSource.h"
#endif

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrackConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrack_id);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrack_kind);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrack_label);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrack_language);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrack_selected);
static JSC_DECLARE_CUSTOM_SETTER(setJSVideoTrack_selected);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrack_configuration);
#if ENABLE(MEDIA_SOURCE)
static JSC_DECLARE_CUSTOM_GETTER(jsVideoTrack_sourceBuffer);
#endif

class JSVideoTrackPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVideoTrackPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoTrackPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoTrackPrototype>(vm)) JSVideoTrackPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoTrackPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoTrackPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoTrackPrototype, JSVideoTrackPrototype::Base);

using JSVideoTrackDOMConstructor = JSDOMConstructorNotConstructable<JSVideoTrack>;

template<> const ClassInfo JSVideoTrackDOMConstructor::s_info = { "VideoTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackDOMConstructor) };

template<> JSValue JSVideoTrackDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVideoTrackDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VideoTrack"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSVideoTrack::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 8> JSVideoTrackPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrackConstructor, 0 } },
    HashTableValue { "id"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrack_id, 0 } },
    HashTableValue { "kind"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrack_kind, 0 } },
    HashTableValue { "label"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrack_label, 0 } },
    HashTableValue { "language"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrack_language, 0 } },
    HashTableValue { "selected"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrack_selected, setJSVideoTrack_selected } },
    HashTableValue { "configuration"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrack_configuration, 0 } },
#if ENABLE(MEDIA_SOURCE)
    HashTableValue { "sourceBuffer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoTrack_sourceBuffer, 0 } },
#else
    HashTableValue { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
};

const ClassInfo JSVideoTrackPrototype::s_info = { "VideoTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrackPrototype) };

void JSVideoTrackPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoTrack::info(), JSVideoTrackPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().trackConfigurationEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "configuration"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(MEDIA_SOURCE)
    if (!((globalObject())->inherits<JSDOMWindowBase>() && (downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().mediaSourceEnabled || downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().managedMediaSourceEnabled))) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "sourceBuffer"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSVideoTrack::s_info = { "VideoTrack"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoTrack) };

JSVideoTrack::JSVideoTrack(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoTrack>&& impl)
    : JSDOMWrapper<VideoTrack>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, VideoTrack>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSVideoTrack::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSVideoTrackPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSVideoTrackPrototype::create(vm, &globalObject, structure);
}

JSObject* JSVideoTrack::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVideoTrack>(vm, globalObject);
}

JSValue JSVideoTrack::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVideoTrackDOMConstructor, DOMConstructorID::VideoTrack>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSVideoTrack::destroy(JSC::JSCell* cell)
{
    JSVideoTrack* thisObject = static_cast<JSVideoTrack*>(cell);
    thisObject->JSVideoTrack::~JSVideoTrack();
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrackConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVideoTrackPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVideoTrack::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsVideoTrack_idGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrack_id, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrack_idGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrack_kindGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.kind())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrack_kind, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrack_kindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrack_labelGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrack_label, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrack_labelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrack_languageGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.language())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrack_language, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrack_languageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoTrack_selectedGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.selected())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrack_selected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrack_selectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSVideoTrack_selectedSetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLBoolean>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSelected(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSVideoTrack_selected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::set<setJSVideoTrack_selectedSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsVideoTrack_configurationGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<VideoTrackConfiguration>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.configuration())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrack_configuration, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrack_configurationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#if ENABLE(MEDIA_SOURCE)
static inline JSValue jsVideoTrack_sourceBufferGetter(JSGlobalObject& lexicalGlobalObject, JSVideoTrack& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<SourceBuffer>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::VideoTrackMediaSource::sourceBuffer(impl))));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoTrack_sourceBuffer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoTrack>::get<jsVideoTrack_sourceBufferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

JSC::GCClient::IsoSubspace* JSVideoTrack::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSVideoTrack, UseCustomHeapCellType::No>(vm, "JSVideoTrack"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForVideoTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForVideoTrack = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForVideoTrack.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForVideoTrack = std::forward<decltype(space)>(space); }
    );
}

void JSVideoTrack::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVideoTrack*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSVideoTrackOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsVideoTrack = jsCast<JSVideoTrack*>(handle.slot()->asCell());
    auto& owner = jsVideoTrack->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsVideoTrack"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSVideoTrackOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoTrack = static_cast<JSVideoTrack*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsVideoTrack->protectedWrapped().ptr(), jsVideoTrack);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoTrack@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10VideoTrackE[]; }
#endif
template<std::same_as<VideoTrack> T>
static inline void verifyVTable(VideoTrack* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7VideoTrack@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10VideoTrackE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // VideoTrack has subclasses. If VideoTrack has subclasses that get passed
        // to toJS() we currently require VideoTrack you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VideoTrack>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<VideoTrack>(impl.ptr());
#endif
    return createWrapper<VideoTrack>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VideoTrack& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VideoTrack* JSVideoTrack::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoTrack*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
