/*
 * This file is autogenerated, see util/species-gen.py and dat/species/ for
 * more info.
 *
 * Entry format:
 *   row  0: species enum
 *   row  1: two-letter abbreviation
 *   row  2: name noun, name adjective, genus (null to use name)
 *   row  3: flags (SPF_*)
 *   row  4: XP "aptitude", HP mod (in tenths), MP mod, WL per XL
 *   row  5: corresponding monster
 *   row  6: habitat, undead state, size
 *   row  7: starting strength, intelligence, dexterity  // sum
 *   row  8: { level-up stats }, level for stat increase
 *   row  9: { { mutation, mutation level, XP level }, ... }
 *   row 10: { fake mutation messages for A screen }
 *   row 11: { fake mutation names for % screen }
 *   row 12: recommended jobs for character selection
 *   row 13: recommended weapons for character selection
 *   row 14: custom walking action, or nullptr
 *   row 15: custom prayer action, or nullptr
 */

static const species_def species_data[] =
{

{  SP_HUMAN,
    "Hu",
    "Human", nullptr, nullptr,
    SPF_NONE,
    0, 0, 0, 3,
    MONS_HUMAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    8, 8, 8,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_EXPLORE_REGEN, 1, 1 } },
    {},
    {},
    { JOB_BERSERKER, JOB_CINDER_ACOLYTE, JOB_CONJURER, JOB_NECROMANCER, JOB_ICE_ELEMENTALIST },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_HIGH_ELF,
    "HE",
    "High Elf", "Elven", "Elf",
    SPF_NONE,
    -1, -1, 1, 4,
    MONS_ELF,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    7, 11, 10,
    { STAT_DEX, STAT_INT }, 3,
    {},
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "High Orc",
    nullptr,
},
#endif

{  SP_DEEP_ELF,
    "DE",
    "Deep Elf", "Elven", "Elf",
    SPF_NONE,
    -1, -2, 2, 4,
    MONS_ELF,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    5, 12, 10,
    { STAT_INT }, 4,
    { { MUT_MANA_REGENERATION, 1, 1 } },
    {},
    {},
    { JOB_HEDGE_WIZARD, JOB_CONJURER, JOB_SUMMONER, JOB_FORGEWRIGHT, JOB_NECROMANCER, JOB_FIRE_ELEMENTALIST, JOB_ICE_ELEMENTALIST, JOB_AIR_ELEMENTALIST, JOB_EARTH_ELEMENTALIST, JOB_ALCHEMIST },
    { SK_SHORT_BLADES, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Deep Orc",
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_SLUDGE_ELF,
    "SE",
    "Sludge Elf", "Elven", "Elf",
    SPF_NONE,
    0, -1, 1, 3,
    MONS_ELF,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    8, 8, 8,
    { STAT_DEX, STAT_INT }, 4,
    {},
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Sludge Orc",
    nullptr,
},
#endif
#if TAG_MAJOR_VERSION == 34
{  SP_HALFLING,
    "Ha",
    "Halfling", nullptr, nullptr,
    SPF_NONE,
    1, -1, 0, 3,
    MONS_HALFLING,
    HT_LAND, US_ALIVE, SIZE_SMALL,
    9, 6, 9,
    { STAT_DEX }, 5,
    { { MUT_MUTATION_RESISTANCE, 1, 1 } },
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Halflorc",
    nullptr,
},
#endif
#if TAG_MAJOR_VERSION == 34
{  SP_HILL_ORC,
    "HO",
    "Hill Orc", nullptr, nullptr,
    SPF_NONE,
    0, 1, 0, 3,
    MONS_ORC,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR }, 5,
    {},
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Antique Orc",
    nullptr,
},
#endif

{  SP_KOBOLD,
    "Ko",
    "Kobold", nullptr, nullptr,
    SPF_NONE,
    1, -2, 0, 3,
    MONS_KOBOLD,
    HT_LAND, US_ALIVE, SIZE_SMALL,
    5, 9, 10,
    { STAT_STR, STAT_INT, STAT_DEX }, 5,
    { { MUT_NIGHTSTALKER, 3, 1 } },
    {},
    {},
    { JOB_BRIGAND, JOB_BERSERKER, JOB_HEXSLINGER, JOB_ENCHANTER, JOB_CONJURER, JOB_EARTH_ELEMENTALIST },
    { SK_SHORT_BLADES, SK_MACES_FLAILS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Orcobold",
    nullptr,
},


{  SP_MUMMY,
    "Mu",
    "Mummy", nullptr, nullptr,
    SPF_NO_BLOOD,
    -1, 0, 0, 5,
    MONS_MUMMY,
    HT_LAND, US_UNDEAD, SIZE_MEDIUM,
    11, 7, 7,
    { STAT_STR, STAT_INT, STAT_DEX }, 5,
    { { MUT_ACCURSED, 1, 1 }, { MUT_COLD_RESISTANCE, 1, 1 }, { MUT_FAITH, 1, 1 }, { MUT_HEAT_VULNERABILITY, 1, 1 }, { MUT_NECRO_ENHANCER, 1, 1 }, { MUT_NEGATIVE_ENERGY_RESISTANCE, 3, 1 }, { MUT_NO_DRINK, 1, 1 }, { MUT_TORMENT_RESISTANCE, 2, 1 }, { MUT_NECRO_ENHANCER, 1, 13 } },
    {},
    {},
    { JOB_CINDER_ACOLYTE, JOB_HEDGE_WIZARD, JOB_CONJURER, JOB_NECROMANCER, JOB_ICE_ELEMENTALIST, JOB_SUMMONER },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Orcish Mummy",
    "A small pair of tusks begins to pierce through your wrappings.",
},


{  SP_NAGA,
    "Na",
    "Naga", nullptr, nullptr,
    SPF_SMALL_TORSO | SPF_BARDING | SPF_NO_FEET,
    0, 2, 0, 5,
    MONS_NAGA,
    HT_LAND, US_ALIVE, SIZE_LARGE,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ACUTE_VISION, 1, 1 }, { MUT_CONSTRICTING_TAIL, 1, 1 }, { MUT_DEFORMED, 1, 1 }, { MUT_POISON_RESISTANCE, 1, 1 }, { MUT_SPIT_POISON, 1, 1 }, { MUT_CONSTRICTING_TAIL, 1, 13 } },
    {},
    {},
    { JOB_BERSERKER, JOB_SHAPESHIFTER, JOB_ENCHANTER, JOB_FIRE_ELEMENTALIST, JOB_ICE_ELEMENTALIST, JOB_WARPER, JOB_HEDGE_WIZARD, JOB_ALCHEMIST },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    "Slither",
    "coil in front of",
    nullptr,
    "Nagorc",
    nullptr,
},


{  SP_ONI,
    "On",
    "Oni", "Oni", nullptr,
    SPF_NONE,
    0, 3, 0, 4,
    MONS_ONI,
    HT_LAND, US_ALIVE, SIZE_LARGE,
    11, 9, 4,
    { STAT_STR }, 3,
    { { MUT_DOUBLE_POTION_HEAL, 1, 1 }, { MUT_DRUNKEN_BRAWLING, 1, 1 }, { MUT_HORNS, 1, 1 }, { MUT_TOUGH_SKIN, 1, 1 } },
    {},
    {},
    { JOB_GLADIATOR, JOB_BERSERKER, JOB_CINDER_ACOLYTE, JOB_HEDGE_WIZARD, JOB_AIR_ELEMENTALIST, JOB_FIRE_ELEMENTALIST },
    { SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES, SK_AXES },
    nullptr,
    nullptr,
    nullptr,
    "Big Orc",
    nullptr,
},


{  SP_TROLL,
    "Tr",
    "Troll", "Trollish", nullptr,
    SPF_NONE,
    -1, 3, -1, 3,
    MONS_TROLL,
    HT_LAND, US_ALIVE, SIZE_LARGE,
    15, 4, 5,
    { STAT_STR }, 3,
    { { MUT_CLAWS, 3, 1 }, { MUT_REGENERATION, 1, 1 }, { MUT_SHAGGY_FUR, 1, 1 }, { MUT_TOUGH_SKIN, 1, 1 } },
    {},
    {},
    { JOB_FIGHTER, JOB_GLADIATOR, JOB_BERSERKER, JOB_WARPER, JOB_EARTH_ELEMENTALIST, JOB_HEDGE_WIZARD },
    { SK_MACES_FLAILS, SK_UNARMED_COMBAT },
    nullptr,
    nullptr,
    nullptr,
    "Trorc",
    nullptr,
},


{  SP_RED_DRACONIAN,
    "Dr",
    "Red Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_RED_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_HEAT_RESISTANCE, 1, 7 } },
    { "You can breathe blasts of explosive embers." },
    { "combustion breath" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Red Orconian",
    nullptr,
},


{  SP_WHITE_DRACONIAN,
    "Dr",
    "White Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_WHITE_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_COLD_RESISTANCE, 1, 7 } },
    { "You can breathe waves of cold which freeze foes solid." },
    { "glacial breath" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "White Orconian",
    nullptr,
},


{  SP_GREEN_DRACONIAN,
    "Dr",
    "Green Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_GREEN_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_POISON_RESISTANCE, 1, 7 }, { MUT_STINGER, 2, 14 } },
    { "You can breathe blasts of noxious fumes." },
    { "noxious breath" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Green Orconian",
    nullptr,
},


{  SP_YELLOW_DRACONIAN,
    "Dr",
    "Yellow Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_YELLOW_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_ACID_RESISTANCE, 1, 7 }, { MUT_ACIDIC_BITE, 1, 14 } },
    { "You can breathe corrosive fumes." },
    { "caustic breath" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Yellow Orconian",
    nullptr,
},


{  SP_GREY_DRACONIAN,
    "Dr",
    "Grey Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_GREY_DRACONIAN,
    HT_WATER, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_IRON_FUSED_SCALES, 1, 14 } },
    { "You can breathe torrents of mud.", "You are unimpeded by mud." },
    { "mud breath", "mud-swimmer" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Grey Orconian",
    nullptr,
},


{  SP_BLACK_DRACONIAN,
    "Dr",
    "Black Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_BLACK_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_SHOCK_RESISTANCE, 1, 7 }, { MUT_BIG_WINGS, 1, 14 } },
    { "You can breathe arcing electricity." },
    { "galvanic breath" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Black Orconian",
    nullptr,
},


{  SP_PURPLE_DRACONIAN,
    "Dr",
    "Purple Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_PURPLE_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_STRONG_WILLED, 1, 7 }, { MUT_INVIOLATE_MAGIC, 1, 14 } },
    { "You can breathe blasts of antimagic." },
    { "nullifying breath" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Purple Orconian",
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_MOTTLED_DRACONIAN,
    "Dr",
    "Mottled Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_MOTTLED_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_COLD_BLOODED, 1, 1 } },
    { "You can spit globs of burning liquid.", "You can ignite nearby creatures when you spit burning liquid." },
    { "breathe sticky flame splash" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Mottled Orconian",
    nullptr,
},
#endif

{  SP_PALE_DRACONIAN,
    "Dr",
    "Pale Draconian", "Draconian", "Draconian",
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_PALE_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 }, { MUT_STEAM_RESISTANCE, 1, 7 } },
    { "You can breathe blasts of scalding, opaque steam." },
    { "steam breath" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Pale Orconian",
    nullptr,
},


{  SP_BASE_DRACONIAN,
    "Dr",
    "Draconian", nullptr, nullptr,
    SPF_DRACONIAN | SPF_NO_HAIR,
    -1, 1, 0, 3,
    MONS_DRACONIAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 1, 1 }, { MUT_COLD_BLOODED, 1, 1 } },
    {},
    {},
    { JOB_BERSERKER, JOB_SHAPESHIFTER, JOB_CONJURER, JOB_FIRE_ELEMENTALIST, JOB_ICE_ELEMENTALIST, JOB_AIR_ELEMENTALIST, JOB_EARTH_ELEMENTALIST, JOB_ALCHEMIST },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Orconian",
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_CENTAUR,
    "Ce",
    "Centaur", nullptr, nullptr,
    SPF_SMALL_TORSO | SPF_BARDING | SPF_NO_FEET,
    -1, 1, 0, 3,
    MONS_CENTAUR,
    HT_LAND, US_ALIVE, SIZE_LARGE,
    10, 7, 4,
    { STAT_STR, STAT_DEX }, 4,
    { { MUT_DEFORMED, 1, 1 }, { MUT_FAST, 2, 1 }, { MUT_HOOVES, 3, 1 }, { MUT_TOUGH_SKIN, 3, 1 } },
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Centorc",
    nullptr,
},
#endif

{  SP_DEMIGOD,
    "Dg",
    "Demigod", "Divine", nullptr,
    SPF_NONE,
    -2, 1, 2, 4,
    MONS_DEMIGOD,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    9, 10, 9,
    set<stat_type>(), 28,
    { { MUT_DIVINE_ATTRS, 1, 1 }, { MUT_FORLORN, 1, 1 }, { MUT_HIGH_MAGIC, 1, 1 } },
    {},
    {},
    { JOB_SHAPESHIFTER, JOB_CONJURER, JOB_FIRE_ELEMENTALIST, JOB_ICE_ELEMENTALIST, JOB_AIR_ELEMENTALIST, JOB_EARTH_ELEMENTALIST },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Buggy Orc",
    "Your teeth buggily grow more tusk-like, and your ears buggily lengthen.",
},


{  SP_SPRIGGAN,
    "Sp",
    "Spriggan", nullptr, nullptr,
    SPF_NONE,
    -1, -3, 1, 7,
    MONS_SPRIGGAN,
    HT_LAND, US_ALIVE, SIZE_LITTLE,
    4, 9, 10,
    { STAT_INT, STAT_DEX }, 5,
    { { MUT_ACUTE_VISION, 1, 1 }, { MUT_FAST, 3, 1 } },
    {},
    {},
    { JOB_BRIGAND, JOB_ARTIFICER, JOB_WARPER, JOB_ENCHANTER, JOB_CONJURER, JOB_EARTH_ELEMENTALIST, JOB_ALCHEMIST },
    { SK_SHORT_BLADES },
    "Sprint",
    nullptr,
    nullptr,
    "Spriggorc",
    nullptr,
},


{  SP_MINOTAUR,
    "Mi",
    "Minotaur", nullptr, nullptr,
    SPF_NONE,
    -1, 1, -1, 3,
    MONS_MINOTAUR,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    12, 5, 5,
    { STAT_STR, STAT_DEX }, 4,
    { { MUT_HORNS, 2, 1 }, { MUT_REFLEXIVE_HEADBUTT, 1, 1 } },
    {},
    {},
    { JOB_FIGHTER, JOB_GLADIATOR, JOB_MONK, JOB_HUNTER, JOB_BERSERKER },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    "Calf",
    "Minotorc",
    nullptr,
},


{  SP_DEMONSPAWN,
    "Ds",
    "Demonspawn", "Demonic", nullptr,
    SPF_NONE,
    -1, 0, 0, 3,
    MONS_DEMONSPAWN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    8, 8, 8,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    {},
    {},
    {},
    { JOB_GLADIATOR, JOB_BERSERKER, JOB_HEDGE_WIZARD, JOB_NECROMANCER, JOB_FIRE_ELEMENTALIST, JOB_ICE_ELEMENTALIST, JOB_ALCHEMIST },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Demon Orc",
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_GHOUL,
    "Gh",
    "Ghoul", "Ghoulish", nullptr,
    SPF_NO_BLOOD | SPF_NO_HAIR,
    0, 1, 0, 3,
    MONS_GHOUL,
    HT_LAND, US_UNDEAD, SIZE_MEDIUM,
    11, 7, 4,
    { STAT_STR }, 5,
    { { MUT_CLAWS, 1, 1 }, { MUT_COLD_RESISTANCE, 1, 1 }, { MUT_DEVOUR_ON_KILL, 1, 1 }, { MUT_INHIBITED_REGENERATION, 1, 1 }, { MUT_NEGATIVE_ENERGY_RESISTANCE, 3, 1 }, { MUT_TORMENT_RESISTANCE, 2, 1 } },
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Rotting Orc",
    nullptr,
},
#endif

{  SP_TENGU,
    "Te",
    "Tengu", nullptr, nullptr,
    SPF_NO_EARS | SPF_NO_HAIR,
    0, -2, 1, 3,
    MONS_TENGU,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    8, 8, 9,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ACROBATIC, 1, 1 }, { MUT_BEAK, 1, 1 }, { MUT_TALONS, 3, 1 }, { MUT_TENGU_FLIGHT, 1, 7 } },
    {},
    {},
    { JOB_BERSERKER, JOB_REAVER, JOB_HEDGE_WIZARD, JOB_CONJURER, JOB_SUMMONER, JOB_FIRE_ELEMENTALIST, JOB_AIR_ELEMENTALIST },
    { SK_MACES_FLAILS, SK_AXES, SK_POLEARMS, SK_LONG_BLADES, SK_STAVES },
    "Glid",
    nullptr,
    "Chick",
    "Tengorc",
    "Your beak becomes more hooked, and the plumage around your ears grows tufted.",
},


{  SP_MERFOLK,
    "Mf",
    "Merfolk", "Merfolkian", nullptr,
    SPF_NONE,
    0, 0, 0, 3,
    MONS_MERFOLK,
    HT_WATER, US_ALIVE, SIZE_MEDIUM,
    8, 7, 9,
    { STAT_STR, STAT_INT, STAT_DEX }, 5,
    { { MUT_MERTAIL, 1, 1 }, { MUT_NIMBLE_SWIMMER, 2, 1 } },
    {},
    {},
    { JOB_GLADIATOR, JOB_BERSERKER, JOB_SHAPESHIFTER, JOB_SUMMONER, JOB_ICE_ELEMENTALIST, JOB_ALCHEMIST },
    { SK_POLEARMS, SK_LONG_BLADES },
    nullptr,
    nullptr,
    nullptr,
    "Merforc",
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_VAMPIRE,
    "Vp",
    "Vampire", "Vampiric", nullptr,
    SPF_NONE,
    -1, 0, 0, 4,
    MONS_VAMPIRE,
    HT_LAND, US_SEMI_UNDEAD, SIZE_MEDIUM,
    7, 10, 9,
    { STAT_INT, STAT_DEX }, 5,
    { { MUT_ACUTE_VISION, 1, 1 }, { MUT_FANGS, 3, 1 } },
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Orcula",
    nullptr,
},
#endif
#if TAG_MAJOR_VERSION == 34
{  SP_DEEP_DWARF,
    "DD",
    "Deep Dwarf", "Dwarven", "Dwarf",
    SPF_NONE,
    -1, 2, 0, 6,
    MONS_DEEP_DWARF,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    11, 8, 8,
    { STAT_STR, STAT_INT }, 4,
    { { MUT_NO_REGENERATION, 1, 1 }, { MUT_PASSIVE_MAPPING, 1, 1 }, { MUT_PASSIVE_MAPPING, 1, 9 }, { MUT_NEGATIVE_ENERGY_RESISTANCE, 1, 14 } },
    { "You are resistant to damage.", "You can heal yourself by infusing magical energy." },
    { "damage resistance", "heal wounds" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Deep Dworc",
    nullptr,
},
#endif

{  SP_FELID,
    "Fe",
    "Felid", "Feline", "Cat",
    SPF_NO_FEET,
    -1, -3, 1, 6,
    MONS_FELID,
    HT_LAND, US_ALIVE, SIZE_LITTLE,
    4, 11, 11,
    { STAT_INT, STAT_DEX }, 4,
    { { MUT_ACUTE_VISION, 1, 1 }, { MUT_CLAWS, 1, 1 }, { MUT_FANGS, 3, 1 }, { MUT_MULTILIVED, 1, 1 }, { MUT_NO_ARMOUR, 1, 1 }, { MUT_NO_GRASPING, 1, 1 }, { MUT_PAWS, 1, 1 }, { MUT_SHAGGY_FUR, 1, 1 }, { MUT_SHAGGY_FUR, 1, 6 }, { MUT_SHAGGY_FUR, 1, 12 } },
    {},
    {},
    { JOB_BERSERKER, JOB_ENCHANTER, JOB_SHAPESHIFTER, JOB_ICE_ELEMENTALIST, JOB_AIR_ELEMENTALIST, JOB_CONJURER, JOB_SUMMONER },
    { SK_UNARMED_COMBAT },
    nullptr,
    "sit before",
    "Kitten",
    "Orcat",
    nullptr,
},


{  SP_OCTOPODE,
    "Op",
    "Octopode", "Octopoid", "Octopus",
    SPF_NO_EARS | SPF_NO_FEET | SPF_NO_BONES | SPF_NO_HAIR,
    0, -1, 0, 3,
    MONS_OCTOPODE,
    HT_WATER, US_ALIVE, SIZE_MEDIUM,
    7, 10, 7,
    { STAT_STR, STAT_INT, STAT_DEX }, 5,
    { { MUT_CAMOUFLAGE, 1, 1 }, { MUT_GELATINOUS_BODY, 1, 1 }, { MUT_NIMBLE_SWIMMER, 1, 1 }, { MUT_TENTACLE_ARMS, 1, 1 } },
    { "You cannot wear most types of armour." },
    { "almost no armour" },
    { JOB_SHAPESHIFTER, JOB_HEDGE_WIZARD, JOB_CONJURER, JOB_BRIGAND, JOB_FIRE_ELEMENTALIST, JOB_EARTH_ELEMENTALIST, JOB_ALCHEMIST },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    "Wriggl",
    "curl up in front of",
    "Fry",
    "Orctopode",
    "Your beak grows more hooked, and small fins emerge from the sides of your head.",
},


{  SP_DJINNI,
    "Dj",
    "Djinni", nullptr, nullptr,
    SPF_NO_BLOOD | SPF_NO_FEET,
    1, -1, 0, 4,
    MONS_DJINNI,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    7, 9, 8,
    { STAT_DEX, STAT_INT }, 4,
    { { MUT_COLD_VULNERABILITY, 1, 1 }, { MUT_FLAT_HP, 1, 1 }, { MUT_FLOAT, 1, 1 }, { MUT_HEAT_RESISTANCE, 2, 1 }, { MUT_HP_CASTING, 1, 1 }, { MUT_INNATE_CASTER, 1, 1 } },
    { "You are immune to sickness and miasma." },
    { "sickness immunity" },
    { JOB_CONJURER, JOB_WARPER, JOB_HEDGE_WIZARD, JOB_FIRE_ELEMENTALIST, JOB_ICE_ELEMENTALIST, JOB_AIR_ELEMENTALIST },
    { SK_SHORT_BLADES, SK_LONG_BLADES },
    "Float",
    nullptr,
    nullptr,
    "Orcfreeti",
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_LAVA_ORC,
    "LO",
    "Lava Orc", nullptr, nullptr,
    SPF_NONE,
    -1, 1, 0, 3,
    MONS_ORC,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 6,
    { STAT_INT, STAT_DEX }, 5,
    {},
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Lava Orc Orc",
    nullptr,
},
#endif

{  SP_GARGOYLE,
    "Gr",
    "Gargoyle", nullptr, nullptr,
    SPF_NO_BLOOD | SPF_NO_HAIR,
    0, -2, 0, 3,
    MONS_GARGOYLE,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    11, 8, 5,
    { STAT_STR, STAT_INT }, 4,
    { { MUT_NEGATIVE_ENERGY_RESISTANCE, 1, 1 }, { MUT_SHOCK_RESISTANCE, 1, 1 }, { MUT_STONE_BODY, 1, 1 }, { MUT_TORMENT_RESISTANCE, 1, 1 }, { MUT_BIG_WINGS, 1, 14 } },
    { "You are immune to sickness and miasma." },
    { "sickness immunity" },
    { JOB_FIGHTER, JOB_GLADIATOR, JOB_MONK, JOB_BERSERKER, JOB_FIRE_ELEMENTALIST, JOB_EARTH_ELEMENTALIST, JOB_REAVER },
    { SK_MACES_FLAILS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Gargorcle",
    "You feel a divine power chisel tusks from your teeth and sculpt your ears to a sharp point.",
},


{  SP_FORMICID,
    "Fo",
    "Formicid", nullptr, "Ant",
    SPF_NO_EARS | SPF_NO_BONES,
    1, 0, 0, 4,
    MONS_FORMICID,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    12, 7, 9,
    { STAT_STR, STAT_INT }, 4,
    { { MUT_ANTENNAE, 3, 1 }, { MUT_QUADRUMANOUS, 1, 1 } },
    { "You cannot be hasted, slowed, berserked, paralysed or teleported.", "You can dig through walls and to a lower floor." },
    { "permanent stasis", "dig shafts and tunnels" },
    { JOB_FIGHTER, JOB_HUNTER, JOB_HEXSLINGER, JOB_EARTH_ELEMENTALIST, JOB_ALCHEMIST, JOB_FORGEWRIGHT },
    { SK_MACES_FLAILS, SK_AXES, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    "Larva",
    "Orcmicid",
    "Your mandibles take on a glossy white sheen, and your antennae grow pointier.",
},


{  SP_VINE_STALKER,
    "VS",
    "Vine Stalker", nullptr, nullptr,
    SPF_NO_EARS,
    0, -3, 1, 5,
    MONS_VINE_STALKER,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 9,
    { STAT_STR, STAT_DEX }, 4,
    { { MUT_ANTIMAGIC_BITE, 1, 1 }, { MUT_FANGS, 2, 1 }, { MUT_MANA_SHIELD, 1, 1 }, { MUT_NO_POTION_HEAL, 2, 1 }, { MUT_REGENERATION, 1, 1 }, { MUT_FANGS, 1, 8 } },
    {},
    {},
    { JOB_FIGHTER, JOB_BRIGAND, JOB_BERSERKER, JOB_ENCHANTER, JOB_CONJURER, JOB_NECROMANCER, JOB_ICE_ELEMENTALIST },
    { SK_MACES_FLAILS, SK_AXES, SK_POLEARMS, SK_LONG_BLADES, SK_STAVES },
    "Stalk",
    nullptr,
    nullptr,
    "Orchid Stalker",
    "A pair of ivory tusks grows out from your maw, and flowers begin to bloom upon you.",
},


{  SP_BARACHI,
    "Ba",
    "Barachi", "Barachian", "Frog",
    SPF_NO_EARS | SPF_NO_HAIR,
    0, 0, 0, 3,
    MONS_BARACHI,
    HT_WATER, US_ALIVE, SIZE_MEDIUM,
    9, 8, 7,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_DAYSTALKER, 1, 1 }, { MUT_FROG_LEGS, 1, 1 }, { MUT_FROG_LEGS, 1, 13 } },
    {},
    {},
    { JOB_FIGHTER, JOB_BERSERKER, JOB_WARPER, JOB_HEXSLINGER, JOB_SUMMONER, JOB_ICE_ELEMENTALIST, JOB_REAVER, JOB_FORGEWRIGHT },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    "Hop",
    nullptr,
    "Tadpole",
    "Orcphibian",
    "Your teeth grow more tusk-like, and your tympanum bulges.",
},


{  SP_GNOLL,
    "Gn",
    "Gnoll", nullptr, nullptr,
    SPF_NONE,
    0, 0, 0, 3,
    MONS_GNOLL,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    7, 7, 7,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_DISTRIBUTED_TRAINING, 1, 1 }, { MUT_FANGS, 1, 1 }, { MUT_TREASURE_SENSE, 1, 1 } },
    {},
    {},
    { JOB_CINDER_ACOLYTE, JOB_REAVER, JOB_WARPER, JOB_HEXSLINGER, JOB_SHAPESHIFTER, JOB_WANDERER, JOB_FORGEWRIGHT },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    "Pup",
    "Hyenorc",
    nullptr,
},


{  SP_ARMATAUR,
    "At",
    "Armataur", nullptr, nullptr,
    SPF_SMALL_TORSO | SPF_BARDING,
    -1, 1, 0, 3,
    MONS_ARMATAUR,
    HT_LAND, US_ALIVE, SIZE_LARGE,
    13, 8, 5,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_ARMOURED_TAIL, 2, 1 }, { MUT_DEFORMED, 1, 1 }, { MUT_ROLLPAGE, 1, 1 }, { MUT_TOUGH_SKIN, 3, 1 }, { MUT_ROLLPAGE, 1, 7 } },
    {},
    {},
    { JOB_FIGHTER, JOB_BERSERKER, JOB_WARPER, JOB_HEDGE_WIZARD, JOB_CONJURER },
    { SK_UNARMED_COMBAT, SK_MACES_FLAILS, SK_AXES, SK_STAVES },
    nullptr,
    "curl up in front of",
    "Pup",
    "Orcataur",
    nullptr,
},

#if TAG_MAJOR_VERSION == 34
{  SP_MAYFLYTAUR,
    "My",
    "Mayflytaur", nullptr, nullptr,
    SPF_NONE,
    0, 2, 1, 5,
    MONS_BUTTERFLY,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    9, 9, 9,
    { STAT_STR, STAT_INT, STAT_DEX }, 3,
    { { MUT_BIG_WINGS, 1, 1 }, { MUT_PASSIVE_MAPPING, 1, 1 }, { MUT_SHORT_LIFESPAN, 1, 1 }, { MUT_MANA_REGENERATION, 1, 6 }, { MUT_PASSIVE_MAPPING, 1, 9 }, { MUT_REGENERATION, 1, 12 }, { MUT_NEGATIVE_ENERGY_RESISTANCE, 1, 14 } },
    { "You are resistant to damage." },
    { "damage resistance" },
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Mayflyorc",
    nullptr,
},
#endif
#if TAG_MAJOR_VERSION == 34
{  SP_METEORAN,
    "Me",
    "Meteoran", "Meteoric", nullptr,
    SPF_NONE,
    2, 1, 1, 5,
    MONS_METEORAN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    9, 9, 9,
    { STAT_STR, STAT_INT, STAT_DEX }, 3,
    { { MUT_EXPLORE_REGEN, 1, 1 }, { MUT_PASSIVE_MAPPING, 1, 1 }, { MUT_SHORT_LIFESPAN, 1, 1 }, { MUT_PASSIVE_MAPPING, 1, 9 } },
    {},
    {},
    {  },
    {  },
    nullptr,
    nullptr,
    nullptr,
    "Meteorc",
    nullptr,
},
#endif

{  SP_MOUNTAIN_DWARF,
    "MD",
    "Mountain Dwarf", "Dwarven", "Dwarf",
    SPF_NONE,
    -1, 1, 0, 4,
    MONS_DWARF,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    10, 8, 5,
    { STAT_STR, STAT_INT }, 4,
    { { MUT_ARTEFACT_ENCHANTING, 1, 1 }, { MUT_RUNIC_MAGIC, 1, 1 } },
    {},
    {},
    { JOB_FIGHTER, JOB_MONK, JOB_BERSERKER, JOB_CINDER_ACOLYTE, JOB_REAVER, JOB_FIRE_ELEMENTALIST, JOB_FORGEWRIGHT },
    { SK_MACES_FLAILS, SK_AXES, SK_POLEARMS },
    nullptr,
    nullptr,
    nullptr,
    "Mountain Orc",
    nullptr,
},


{  SP_COGLIN,
    "Co",
    "Coglin", nullptr, "Goblin",
    SPF_NONE,
    0, 0, 0, 5,
    MONS_GOBLIN,
    HT_LAND, US_ALIVE, SIZE_MEDIUM,
    8, 7, 9,
    { STAT_STR, STAT_INT, STAT_DEX }, 4,
    { { MUT_NO_JEWELLERY, 1, 1 }, { MUT_SLOW_WIELD, 1, 1 }, { MUT_WARMUP_STRIKES, 1, 1 }, { MUT_WIELD_OFFHAND, 1, 1 } },
    {},
    {},
    { JOB_ARTIFICER, JOB_HUNTER, JOB_GLADIATOR, JOB_WARPER, JOB_BERSERKER, JOB_ALCHEMIST, JOB_FORGEWRIGHT },
    { SK_LONG_BLADES, SK_AXES, SK_MACES_FLAILS, SK_POLEARMS, SK_STAVES },
    nullptr,
    nullptr,
    nullptr,
    "Exo-Orc",
    nullptr,
},


{  SP_POLTERGEIST,
    "Po",
    "Poltergeist", "Ghostly", "Geist",
    SPF_NO_BLOOD | SPF_NO_EARS | SPF_NO_BONES | SPF_NO_HAIR | SPF_NO_FEET,
    0, -1, 0, 4,
    MONS_POLTERGEIST,
    HT_LAND, US_UNDEAD, SIZE_MEDIUM,
    4, 10, 9,
    { STAT_INT, STAT_DEX }, 5,
    { { MUT_ACCURSED, 1, 1 }, { MUT_COLD_RESISTANCE, 1, 1 }, { MUT_FLOAT, 1, 1 }, { MUT_FORMLESS, 1, 1 }, { MUT_NEGATIVE_ENERGY_RESISTANCE, 3, 1 }, { MUT_TORMENT_RESISTANCE, 2, 1 }, { MUT_TRICKSTER, 1, 1 }, { MUT_FORMLESS, 1, 13 } },
    { "You are insubstantial and cannot be petrified, ensnared, or set on fire." },
    { "insubstantial" },
    { JOB_CHAOS_KNIGHT, JOB_ENCHANTER, JOB_HEXSLINGER, JOB_NECROMANCER, JOB_EARTH_ELEMENTALIST, JOB_ICE_ELEMENTALIST, JOB_ALCHEMIST },
    { SK_SHORT_BLADES, SK_AXES, SK_LONG_BLADES },
    "Float",
    nullptr,
    nullptr,
    "Phantasmorc",
    "A small pair of spectral tusks begins to grow in your mouth.",
},


{  SP_REVENANT,
    "Re",
    "Revenant", nullptr, nullptr,
    SPF_NO_EARS | SPF_NO_BLOOD | SPF_NO_HAIR,
    -1, 1, 1, 3,
    MONS_REVENANT,
    HT_LAND, US_UNDEAD, SIZE_MEDIUM,
    11, 7, 4,
    { STAT_STR, STAT_INT }, 5,
    { { MUT_ACCURSED, 1, 1 }, { MUT_CLAWS, 1, 1 }, { MUT_COLD_RESISTANCE, 1, 1 }, { MUT_LOW_MAGIC, 2, 1 }, { MUT_NEGATIVE_ENERGY_RESISTANCE, 3, 1 }, { MUT_SPELLCLAWS, 1, 1 }, { MUT_TORMENT_RESISTANCE, 2, 1 }, { MUT_MNEMOPHAGE, 1, 3 } },
    {},
    {},
    { JOB_GLADIATOR, JOB_MONK, JOB_NECROMANCER, JOB_ICE_ELEMENTALIST, JOB_EARTH_ELEMENTALIST },
    { SK_UNARMED_COMBAT },
    nullptr,
    nullptr,
    nullptr,
    "Skeletorc",
    "A small pair of tusks begins to sprout from your jawbone.",
},

// Ideally this wouldn't be necessary...
{ SP_UNKNOWN, // Line 1: enum
    "??", // Line 2: abbrev
    "Yak", nullptr, nullptr, // Line 3: name, genus name, adjectival name
    SPF_NONE, // Line 4: flags
    0, 0, 0, 0, // Line 5: XP, HP, MP, WL (gen-apt.pl needs them here!)
    MONS_PROGRAM_BUG, // Line 6: equivalent monster type
    HT_LAND, US_ALIVE, SIZE_MEDIUM, // Line 7: habitat, life, size
    0, 0, 0, // Line 8: str, int, dex
    set<stat_type>(), 28, // Line 9: str gain, int gain, dex gain, frequency
    {}, // Line 10: Mutations
    {}, // Line 11: Fake mutations
    {}, // Line 12: Fake mutations
    {}, // Line 13: Recommended jobs
    {}, // Line 14: Recommended weapons
    nullptr, // Line 15: walk verb
    nullptr, // Line 16: pray verb
}
};
