/* context.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from context.vala, do not modify */

#include "omemo.h"
#include <glib.h>
#include <omemo/signal_protocol.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <native/helper.h>
#include <omemo/ratchet.h>
#include <omemo/session_pre_key.h>
#include <omemo/key_helper.h>
#include <gee.h>
#include <omemo/curve.h>
#include <omemo/signal_protocol_types.h>
#include <omemo/protocol.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _signal_context_destroy0(var) ((var == NULL) ? NULL : (var = (signal_context_destroy (var), NULL)))
#define _omemo_context_unref0(var) ((var == NULL) ? NULL : (var = (omemo_context_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _signal_type_unref_vapi0(var) ((var == NULL) ? NULL : (var = (signal_type_unref_vapi (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _signal_buffer_free0(var) ((var == NULL) ? NULL : (var = (signal_buffer_free (var), NULL)))
typedef struct _OmemoParamSpecContext OmemoParamSpecContext;

struct _OmemoContextPrivate {
	GRecMutex mutex;
};

struct _OmemoParamSpecContext {
	GParamSpec parent_instance;
};

static gint OmemoContext_private_offset;
static gpointer omemo_context_parent_class = NULL;

static void omemo_context_locking_function_lock (void* user_data);
static void omemo_context_locking_function_unlock (void* user_data);
static void omemo_context_stderr_log (int level,
                               const gchar* message,
                               gsize len,
                               void* user_data);
static const char* _omemo_log_level_to_string (int value);
static const char* _omemo_error_code_to_string (int value);
static void _omemo_context_locking_function_lock_omemo_locking_func (void* user_data);
static void _omemo_context_locking_function_unlock_omemo_locking_func (void* user_data);
static void _omemo_context_stderr_log_omemo_log_func (int level,
                                               const gchar* message,
                                               gsize len,
                                               void* user_data);
VALA_EXTERN OmemoStore* omemo_store_new (OmemoContext* context);
VALA_EXTERN OmemoStore* omemo_store_construct (GType object_type,
                                   OmemoContext* context);
static guint8* _vala_array_dup28 (guint8* self,
                           gssize length);
static void omemo_context_finalize (OmemoContext * obj);
static GType omemo_context_get_type_once (void);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
omemo_context_get_instance_private (OmemoContext* self)
{
	return G_STRUCT_MEMBER_P (self, OmemoContext_private_offset);
}

static gpointer
_omemo_context_ref0 (gpointer self)
{
	return self ? omemo_context_ref (self) : NULL;
}

static void
omemo_context_locking_function_lock (void* user_data)
{
	OmemoContext* ctx = NULL;
	OmemoContext* _tmp0_;
	_tmp0_ = _omemo_context_ref0 (G_TYPE_CHECK_INSTANCE_CAST (user_data, OMEMO_TYPE_CONTEXT, OmemoContext));
	ctx = _tmp0_;
	g_rec_mutex_lock (&ctx->priv->mutex);
	_omemo_context_unref0 (ctx);
}

static void
omemo_context_locking_function_unlock (void* user_data)
{
	OmemoContext* ctx = NULL;
	OmemoContext* _tmp0_;
	_tmp0_ = _omemo_context_ref0 (G_TYPE_CHECK_INSTANCE_CAST (user_data, OMEMO_TYPE_CONTEXT, OmemoContext));
	ctx = _tmp0_;
	g_rec_mutex_unlock (&ctx->priv->mutex);
	_omemo_context_unref0 (ctx);
}

static const char*
_omemo_log_level_to_string (int value)
{
	switch (value) {
		case SG_LOG_ERROR:
		return "SG_LOG_ERROR";
		case SG_LOG_WARNING:
		return "SG_LOG_WARNING";
		case SG_LOG_NOTICE:
		return "SG_LOG_NOTICE";
		case SG_LOG_INFO:
		return "SG_LOG_INFO";
		case SG_LOG_DEBUG:
		return "SG_LOG_DEBUG";
	}
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
omemo_context_stderr_log (int level,
                          const gchar* message,
                          gsize len,
                          void* user_data)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = _omemo_log_level_to_string (level);
	_tmp1_ = string_to_string (message);
	_tmp2_ = g_strconcat (_tmp0_, ": ", _tmp1_, "\n", NULL);
	_tmp3_ = _tmp2_;
	g_printerr ("%s", _tmp3_);
	_g_free0 (_tmp3_);
}

static const char*
_omemo_error_code_to_string (int value)
{
	switch (value) {
		case SG_SUCCESS:
		return "SG_SUCCESS";
		case SG_ERR_NOMEM:
		return "SG_ERR_NOMEM";
		case SG_ERR_INVAL:
		return "SG_ERR_INVAL";
		case SG_ERR_UNKNOWN:
		return "SG_ERR_UNKNOWN";
		case SG_ERR_DUPLICATE_MESSAGE:
		return "SG_ERR_DUPLICATE_MESSAGE";
		case SG_ERR_INVALID_KEY:
		return "SG_ERR_INVALID_KEY";
		case SG_ERR_INVALID_KEY_ID:
		return "SG_ERR_INVALID_KEY_ID";
		case SG_ERR_INVALID_MAC:
		return "SG_ERR_INVALID_MAC";
		case SG_ERR_INVALID_MESSAGE:
		return "SG_ERR_INVALID_MESSAGE";
		case SG_ERR_INVALID_VERSION:
		return "SG_ERR_INVALID_VERSION";
		case SG_ERR_LEGACY_MESSAGE:
		return "SG_ERR_LEGACY_MESSAGE";
		case SG_ERR_NO_SESSION:
		return "SG_ERR_NO_SESSION";
		case SG_ERR_STALE_KEY_EXCHANGE:
		return "SG_ERR_STALE_KEY_EXCHANGE";
		case SG_ERR_UNTRUSTED_IDENTITY:
		return "SG_ERR_UNTRUSTED_IDENTITY";
		case SG_ERR_VRF_SIG_VERIF_FAILED:
		return "SG_ERR_VRF_SIG_VERIF_FAILED";
		case SG_ERR_INVALID_PROTO_BUF:
		return "SG_ERR_INVALID_PROTO_BUF";
		case SG_ERR_FP_VERSION_MISMATCH:
		return "SG_ERR_FP_VERSION_MISMATCH";
		case SG_ERR_FP_IDENT_MISMATCH:
		return "SG_ERR_FP_IDENT_MISMATCH";
	}
	return NULL;
}

static gint
signal_throw_gerror_by_code_ (gint code,
                              const gchar* message,
                              GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	if (code < 0) {
		_tmp0_ = code > SG_ERR_MINIMUM;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		gint _tmp4_ = -1;
		_tmp1_ = message;
		if (_tmp1_ == NULL) {
			_tmp1_ = "libomemo-c error";
		}
		_tmp2_ = _omemo_error_code_to_string ((int) code);
		_tmp3_ = g_error_new ((GQuark) -1, code, "%s: %s", _tmp1_, _tmp2_);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	result = code;
	return result;
}

static void
_omemo_context_locking_function_lock_omemo_locking_func (void* user_data)
{
	omemo_context_locking_function_lock (user_data);
}

static void
_omemo_context_locking_function_unlock_omemo_locking_func (void* user_data)
{
	omemo_context_locking_function_unlock (user_data);
}

static void
_omemo_context_stderr_log_omemo_log_func (int level,
                                          const gchar* message,
                                          gsize len,
                                          void* user_data)
{
	omemo_context_stderr_log (level, message, len, user_data);
}

OmemoContext*
omemo_context_construct (GType object_type,
                         gboolean log,
                         GError** error)
{
	OmemoContext* self = NULL;
	signal_context* _tmp0_ = NULL;
	gint _tmp1_;
	signal_context* _tmp2_;
	signal_context* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (OmemoContext*) g_type_create_instance (object_type);
	_tmp1_ = signal_context_create (&_tmp0_, self);
	_signal_context_destroy0 (self->native_context);
	self->native_context = _tmp0_;
	signal_throw_gerror_by_code_ (_tmp1_, "Error initializing native context", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_omemo_context_unref0 (self);
		return NULL;
	}
	_tmp2_ = self->native_context;
	signal_throw_gerror_by_code_ (signal_context_set_locking_functions (_tmp2_, _omemo_context_locking_function_lock_omemo_locking_func, _omemo_context_locking_function_unlock_omemo_locking_func), "Error initializing native locking functions", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_omemo_context_unref0 (self);
		return NULL;
	}
	if (log) {
		signal_context* _tmp3_;
		_tmp3_ = self->native_context;
		signal_context_set_log_function (_tmp3_, _omemo_context_stderr_log_omemo_log_func);
	}
	_tmp4_ = self->native_context;
	setup_signal_vala_crypto_provider (_tmp4_);
	return self;
}

OmemoContext*
omemo_context_new (gboolean log,
                   GError** error)
{
	return omemo_context_construct (OMEMO_TYPE_CONTEXT, log, error);
}

OmemoStore*
omemo_context_create_store (OmemoContext* self)
{
	OmemoStore* _tmp0_;
	OmemoStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = omemo_store_new (self);
	result = _tmp0_;
	return result;
}

void
omemo_context_randomize (OmemoContext* self,
                         guint8* data,
                         gint data_length1,
                         GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	signal_throw_gerror_by_code_ (signal_vala_randomize (data, (gint) data_length1), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

session_signed_pre_key*
omemo_context_generate_signed_pre_key (OmemoContext* self,
                                       ratchet_identity_key_pair* identity_key_pair,
                                       gint32 id,
                                       guint64 timestamp,
                                       GError** error)
{
	session_signed_pre_key* res = NULL;
	signal_context* _tmp2_;
	session_signed_pre_key* _tmp3_ = NULL;
	gint _tmp4_;
	GError* _inner_error0_ = NULL;
	session_signed_pre_key* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (identity_key_pair != NULL, NULL);
	if (timestamp == ((guint64) 0)) {
		GDateTime* _tmp0_;
		GDateTime* _tmp1_;
		_tmp0_ = g_date_time_new_now_utc ();
		_tmp1_ = _tmp0_;
		timestamp = (guint64) g_date_time_to_unix (_tmp1_);
		_g_date_time_unref0 (_tmp1_);
	}
	_tmp2_ = self->native_context;
	_tmp4_ = signal_protocol_key_helper_generate_signed_pre_key (&_tmp3_, identity_key_pair, (guint32) id, timestamp, _tmp2_);
	_signal_type_unref_vapi0 (res);
	res = _tmp3_;
	signal_throw_gerror_by_code_ (_tmp4_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

GeeSet*
omemo_context_generate_pre_keys (OmemoContext* self,
                                 guint start,
                                 guint count,
                                 GError** error)
{
	GeeSet* res = NULL;
	GeeHashSet* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_POINTER, (GBoxedCopyFunc) signal_type_ref_vapi, (GDestroyNotify) signal_type_unref_vapi, NULL, NULL, NULL, NULL, NULL, NULL);
	res = (GeeSet*) _tmp0_;
	{
		guint i = 0U;
		i = start;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ec_key_pair* pair = NULL;
				ec_key_pair* _tmp3_;
				session_pre_key* record = NULL;
				ec_key_pair* _tmp4_;
				session_pre_key* _tmp5_ = NULL;
				gint _tmp6_;
				GeeSet* _tmp7_;
				session_pre_key* _tmp8_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < (start + count))) {
					break;
				}
				_tmp3_ = omemo_context_generate_key_pair (self, &_inner_error0_);
				pair = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (res);
					return NULL;
				}
				_tmp4_ = pair;
				_tmp6_ = session_pre_key_create (&_tmp5_, (guint32) i, _tmp4_);
				_signal_type_unref_vapi0 (record);
				record = _tmp5_;
				signal_throw_gerror_by_code_ (_tmp6_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_signal_type_unref_vapi0 (record);
					_signal_type_unref_vapi0 (pair);
					_g_object_unref0 (res);
					return NULL;
				}
				_tmp7_ = res;
				_tmp8_ = record;
				gee_collection_add ((GeeCollection*) _tmp7_, _tmp8_);
				_signal_type_unref_vapi0 (record);
				_signal_type_unref_vapi0 (pair);
			}
		}
	}
	result = res;
	return result;
}

ec_public_key*
omemo_context_decode_public_key (OmemoContext* self,
                                 guint8* bytes,
                                 gint bytes_length1,
                                 GError** error)
{
	ec_public_key* public_key = NULL;
	signal_context* _tmp0_;
	ec_public_key* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	ec_public_key* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = curve_decode_point (&_tmp1_, bytes, (gint) bytes_length1, _tmp0_);
	_signal_type_unref_vapi0 (public_key);
	public_key = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, "Error decoding public key", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (public_key);
		return NULL;
	}
	result = public_key;
	return result;
}

ec_private_key*
omemo_context_decode_private_key (OmemoContext* self,
                                  guint8* bytes,
                                  gint bytes_length1,
                                  GError** error)
{
	ec_private_key* private_key = NULL;
	signal_context* _tmp0_;
	ec_private_key* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	ec_private_key* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = curve_decode_private_point (&_tmp1_, bytes, (gint) bytes_length1, _tmp0_);
	_signal_type_unref_vapi0 (private_key);
	private_key = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, "Error decoding private key", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (private_key);
		return NULL;
	}
	result = private_key;
	return result;
}

ec_key_pair*
omemo_context_generate_key_pair (OmemoContext* self,
                                 GError** error)
{
	ec_key_pair* key_pair = NULL;
	signal_context* _tmp0_;
	ec_key_pair* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	ec_key_pair* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = curve_generate_key_pair (_tmp0_, &_tmp1_);
	_signal_type_unref_vapi0 (key_pair);
	key_pair = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, "Error generating key pair", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (key_pair);
		return NULL;
	}
	result = key_pair;
	return result;
}

static guint8*
signal_buffer_get_data (signal_buffer* self,
                        gint* result_length1)
{
	guint8* result;
	gint x = 0;
	guint8* res = NULL;
	guint8* _tmp0_;
	gint res_length1;
	gint _res_size_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	x = (gint) signal_buffer_len (self);
	_tmp0_ = signal_buffer_data (self);
	res = _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	res_length1 = x;
	_tmp1_ = res;
	_tmp1__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static guint8*
_vala_array_dup28 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

guint8*
omemo_context_calculate_signature (OmemoContext* self,
                                   ec_private_key* signing_key,
                                   guint8* message,
                                   gint message_length1,
                                   gint* result_length1,
                                   GError** error)
{
	signal_buffer* signature = NULL;
	signal_context* _tmp0_;
	signal_buffer* _tmp1_ = NULL;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_;
	gint _tmp5__length1;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	gint _tmp7__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (signing_key != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = curve_calculate_signature (_tmp0_, &_tmp1_, signing_key, message, (gint) message_length1);
	_signal_buffer_free0 (signature);
	signature = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, "Error calculating signature", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_buffer_free0 (signature);
		return NULL;
	}
	_tmp3_ = signal_buffer_get_data (signature, &_tmp4_);
	_tmp3__length1 = _tmp4_;
	_tmp5_ = _tmp3_;
	_tmp5__length1 = _tmp3__length1;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup28 (_tmp5_, _tmp5__length1) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	_signal_buffer_free0 (signature);
	return result;
}

signal_message*
omemo_context_deserialize_signal_message (OmemoContext* self,
                                          guint8* data,
                                          gint data_length1,
                                          GError** error)
{
	signal_message* res = NULL;
	signal_context* _tmp0_;
	signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	signal_message* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = signal_message_deserialize (&_tmp1_, data, (gint) data_length1, _tmp0_);
	_signal_type_unref_vapi0 (res);
	res = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

signal_message*
omemo_context_deserialize_omemo_message (OmemoContext* self,
                                         guint8* data,
                                         gint data_length1,
                                         GError** error)
{
	signal_message* res = NULL;
	signal_context* _tmp0_;
	signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	signal_message* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = signal_message_deserialize_omemo (&_tmp1_, data, (gint) data_length1, _tmp0_);
	_signal_type_unref_vapi0 (res);
	res = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

signal_message*
omemo_context_copy_message (OmemoContext* self,
                            ciphertext_message* original,
                            GError** error)
{
	signal_message* res = NULL;
	signal_context* _tmp0_;
	signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	signal_message* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = signal_message_copy (&_tmp1_, (signal_message*) original, _tmp0_);
	_signal_type_unref_vapi0 (res);
	res = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

pre_key_signal_message*
omemo_context_deserialize_signal_pre_key_message (OmemoContext* self,
                                                  guint8* data,
                                                  gint data_length1,
                                                  GError** error)
{
	pre_key_signal_message* res = NULL;
	signal_context* _tmp0_;
	pre_key_signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	pre_key_signal_message* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = pre_key_signal_message_deserialize (&_tmp1_, data, (gint) data_length1, _tmp0_);
	_signal_type_unref_vapi0 (res);
	res = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

pre_key_signal_message*
omemo_context_deserialize_omemo_pre_key_message (OmemoContext* self,
                                                 guint8* data,
                                                 gint data_length1,
                                                 guint32 remote_registration_id,
                                                 GError** error)
{
	pre_key_signal_message* res = NULL;
	signal_context* _tmp0_;
	pre_key_signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	pre_key_signal_message* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = pre_key_signal_message_deserialize_omemo (&_tmp1_, data, (gint) data_length1, remote_registration_id, _tmp0_);
	_signal_type_unref_vapi0 (res);
	res = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

pre_key_signal_message*
omemo_context_copy_pre_key_message (OmemoContext* self,
                                    ciphertext_message* original,
                                    GError** error)
{
	pre_key_signal_message* res = NULL;
	signal_context* _tmp0_;
	pre_key_signal_message* _tmp1_ = NULL;
	gint _tmp2_;
	GError* _inner_error0_ = NULL;
	pre_key_signal_message* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (original != NULL, NULL);
	_tmp0_ = self->native_context;
	_tmp2_ = pre_key_signal_message_copy (&_tmp1_, (pre_key_signal_message*) original, _tmp0_);
	_signal_type_unref_vapi0 (res);
	res = _tmp1_;
	signal_throw_gerror_by_code_ (_tmp2_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

static void
omemo_value_context_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
omemo_value_context_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		omemo_context_unref (value->data[0].v_pointer);
	}
}

static void
omemo_value_context_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = omemo_context_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
omemo_value_context_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
omemo_value_context_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		OmemoContext * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = omemo_context_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
omemo_value_context_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	OmemoContext ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = omemo_context_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
omemo_param_spec_context (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	OmemoParamSpecContext* spec;
	g_return_val_if_fail (g_type_is_a (object_type, OMEMO_TYPE_CONTEXT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
omemo_value_get_context (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, OMEMO_TYPE_CONTEXT), NULL);
	return value->data[0].v_pointer;
}

void
omemo_value_set_context (GValue* value,
                         gpointer v_object)
{
	OmemoContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, OMEMO_TYPE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, OMEMO_TYPE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		omemo_context_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		omemo_context_unref (old);
	}
}

void
omemo_value_take_context (GValue* value,
                          gpointer v_object)
{
	OmemoContext * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, OMEMO_TYPE_CONTEXT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, OMEMO_TYPE_CONTEXT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		omemo_context_unref (old);
	}
}

static void
omemo_context_class_init (OmemoContextClass * klass,
                          gpointer klass_data)
{
	omemo_context_parent_class = g_type_class_peek_parent (klass);
	((OmemoContextClass *) klass)->finalize = omemo_context_finalize;
	g_type_class_adjust_private_offset (klass, &OmemoContext_private_offset);
}

static void
omemo_context_instance_init (OmemoContext * self,
                             gpointer klass)
{
	self->priv = omemo_context_get_instance_private (self);
	g_rec_mutex_init (&self->priv->mutex);
	self->ref_count = 1;
}

static void
omemo_context_finalize (OmemoContext * obj)
{
	OmemoContext * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, OMEMO_TYPE_CONTEXT, OmemoContext);
	g_signal_handlers_destroy (self);
	_signal_context_destroy0 (self->native_context);
	_vala_clear_GRecMutex (&self->priv->mutex);
}

static GType
omemo_context_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { omemo_value_context_init, omemo_value_context_free_value, omemo_value_context_copy_value, omemo_value_context_peek_pointer, "p", omemo_value_context_collect_value, "p", omemo_value_context_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (OmemoContextClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) omemo_context_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OmemoContext), 0, (GInstanceInitFunc) omemo_context_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType omemo_context_type_id;
	omemo_context_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OmemoContext", &g_define_type_info, &g_define_type_fundamental_info, 0);
	OmemoContext_private_offset = g_type_add_instance_private (omemo_context_type_id, sizeof (OmemoContextPrivate));
	return omemo_context_type_id;
}

GType
omemo_context_get_type (void)
{
	static volatile gsize omemo_context_type_id__once = 0;
	if (g_once_init_enter (&omemo_context_type_id__once)) {
		GType omemo_context_type_id;
		omemo_context_type_id = omemo_context_get_type_once ();
		g_once_init_leave (&omemo_context_type_id__once, omemo_context_type_id);
	}
	return omemo_context_type_id__once;
}

gpointer
omemo_context_ref (gpointer instance)
{
	OmemoContext * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
omemo_context_unref (gpointer instance)
{
	OmemoContext * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		OMEMO_CONTEXT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

