/* imap-status.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from imap-status.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include "geary-engine.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

/**
 * An optional status code accompanying a {@link ServerResponse}.
 *
 * See [[http://tools.ietf.org/html/rfc3501#section-7.1]] for more information.
 */
gchar*
geary_imap_status_to_string (GearyImapStatus self)
{
	gchar* result;
	switch (self) {
		case GEARY_IMAP_STATUS_OK:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ok");
			result = _tmp0_;
			return result;
		}
		case GEARY_IMAP_STATUS_NO:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("no");
			result = _tmp1_;
			return result;
		}
		case GEARY_IMAP_STATUS_BAD:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("bad");
			result = _tmp2_;
			return result;
		}
		case GEARY_IMAP_STATUS_PREAUTH:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("preauth");
			result = _tmp3_;
			return result;
		}
		case GEARY_IMAP_STATUS_BYE:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("bye");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GearyImapStatus
geary_imap_status_from_parameter (GearyImapStringParameter* strparam,
                                  GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	GError* _inner_error0_ = NULL;
	GearyImapStatus result;
	g_return_val_if_fail (GEARY_IMAP_IS_STRING_PARAMETER (strparam), 0);
	_tmp0_ = geary_imap_string_parameter_as_lower (strparam);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("ok")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_OK;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("no")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_NO;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("bad")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_BAD;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("preauth")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_PREAUTH;
				return result;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("bye")))) {
		switch (0) {
			default:
			{
				result = GEARY_IMAP_STATUS_BYE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				GError* _tmp6_;
				GError* _tmp7_;
				_tmp4_ = geary_imap_parameter_to_string (G_TYPE_CHECK_INSTANCE_CAST (strparam, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter));
				_tmp5_ = _tmp4_;
				_tmp6_ = g_error_new (GEARY_IMAP_ERROR, GEARY_IMAP_ERROR_PARSE_ERROR, "Unrecognized status response \"%s\"", _tmp5_);
				_tmp7_ = _tmp6_;
				_g_free0 (_tmp5_);
				_inner_error0_ = _tmp7_;
				if (_inner_error0_->domain == GEARY_IMAP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return 0;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return 0;
				}
			}
		}
	}
}

GearyImapParameter*
geary_imap_status_to_parameter (GearyImapStatus self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GearyImapAtomParameter* _tmp2_;
	GearyImapParameter* _tmp3_;
	GearyImapParameter* result;
	_tmp0_ = geary_imap_status_to_string (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = geary_imap_atom_parameter_new (_tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEARY_IMAP_TYPE_PARAMETER, GearyImapParameter);
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

 G_GNUC_NO_INLINE static GType
geary_imap_status_get_type_once (void)
{
	static const GEnumValue values[] = {{GEARY_IMAP_STATUS_OK, "GEARY_IMAP_STATUS_OK", "ok"}, {GEARY_IMAP_STATUS_NO, "GEARY_IMAP_STATUS_NO", "no"}, {GEARY_IMAP_STATUS_BAD, "GEARY_IMAP_STATUS_BAD", "bad"}, {GEARY_IMAP_STATUS_PREAUTH, "GEARY_IMAP_STATUS_PREAUTH", "preauth"}, {GEARY_IMAP_STATUS_BYE, "GEARY_IMAP_STATUS_BYE", "bye"}, {0, NULL, NULL}};
	GType geary_imap_status_type_id;
	geary_imap_status_type_id = g_enum_register_static ("GearyImapStatus", values);
	return geary_imap_status_type_id;
}

GType
geary_imap_status_get_type (void)
{
	static gsize geary_imap_status_type_id__once = 0;
	if (g_once_init_enter (&geary_imap_status_type_id__once)) {
		GType geary_imap_status_type_id;
		geary_imap_status_type_id = geary_imap_status_get_type_once ();
		g_once_init_leave (&geary_imap_status_type_id__once, geary_imap_status_type_id);
	}
	return geary_imap_status_type_id__once;
}

