/* gitg-diff-image-overlay.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-image-overlay.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2016 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "libgitg.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_TYPE_DIFF_IMAGE_COMPOSITE (gitg_diff_image_composite_get_type ())
#define GITG_DIFF_IMAGE_COMPOSITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageComposite))
#define GITG_DIFF_IMAGE_COMPOSITE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageCompositeClass))
#define GITG_IS_DIFF_IMAGE_COMPOSITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_COMPOSITE))
#define GITG_IS_DIFF_IMAGE_COMPOSITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_COMPOSITE))
#define GITG_DIFF_IMAGE_COMPOSITE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageCompositeClass))

typedef struct _GitgDiffImageComposite GitgDiffImageComposite;
typedef struct _GitgDiffImageCompositeClass GitgDiffImageCompositeClass;
typedef struct _GitgDiffImageCompositePrivate GitgDiffImageCompositePrivate;

#define GITG_TYPE_DIFF_IMAGE_OVERLAY (gitg_diff_image_overlay_get_type ())
#define GITG_DIFF_IMAGE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlay))
#define GITG_DIFF_IMAGE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlayClass))
#define GITG_IS_DIFF_IMAGE_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_OVERLAY))
#define GITG_IS_DIFF_IMAGE_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_IMAGE_OVERLAY))
#define GITG_DIFF_IMAGE_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlayClass))

typedef struct _GitgDiffImageOverlay GitgDiffImageOverlay;
typedef struct _GitgDiffImageOverlayClass GitgDiffImageOverlayClass;
typedef struct _GitgDiffImageOverlayPrivate GitgDiffImageOverlayPrivate;
enum  {
	GITG_DIFF_IMAGE_OVERLAY_0_PROPERTY,
	GITG_DIFF_IMAGE_OVERLAY_ALPHA_PROPERTY,
	GITG_DIFF_IMAGE_OVERLAY_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_image_overlay_properties[GITG_DIFF_IMAGE_OVERLAY_NUM_PROPERTIES];

#define GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE (gitg_diff_image_surface_cache_get_type ())
#define GITG_DIFF_IMAGE_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, GitgDiffImageSurfaceCache))
#define GITG_IS_DIFF_IMAGE_SURFACE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE))
#define GITG_DIFF_IMAGE_SURFACE_CACHE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_IMAGE_SURFACE_CACHE, GitgDiffImageSurfaceCacheIface))

typedef struct _GitgDiffImageSurfaceCache GitgDiffImageSurfaceCache;
typedef struct _GitgDiffImageSurfaceCacheIface GitgDiffImageSurfaceCacheIface;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GitgDiffImageComposite {
	GtkDrawingArea parent_instance;
	GitgDiffImageCompositePrivate * priv;
};

struct _GitgDiffImageCompositeClass {
	GtkDrawingAreaClass parent_class;
};

struct _GitgDiffImageOverlay {
	GitgDiffImageComposite parent_instance;
	GitgDiffImageOverlayPrivate * priv;
};

struct _GitgDiffImageOverlayClass {
	GitgDiffImageCompositeClass parent_class;
};

struct _GitgDiffImageOverlayPrivate {
	gdouble d_alpha;
};

struct _GitgDiffImageSurfaceCacheIface {
	GTypeInterface parent_iface;
	cairo_surface_t* (*get_old_surface) (GitgDiffImageSurfaceCache* self, GdkWindow* window);
	cairo_surface_t* (*get_new_surface) (GitgDiffImageSurfaceCache* self, GdkWindow* window);
	GdkPixbuf* (*get_old_pixbuf) (GitgDiffImageSurfaceCache* self);
	void (*set_old_pixbuf) (GitgDiffImageSurfaceCache* self, GdkPixbuf* value);
	GdkPixbuf* (*get_new_pixbuf) (GitgDiffImageSurfaceCache* self);
	void (*set_new_pixbuf) (GitgDiffImageSurfaceCache* self, GdkPixbuf* value);
	GdkWindow* (*get_window) (GitgDiffImageSurfaceCache* self);
	void (*set_window) (GitgDiffImageSurfaceCache* self, GdkWindow* value);
};

static gint GitgDiffImageOverlay_private_offset;
static gpointer gitg_diff_image_overlay_parent_class = NULL;

VALA_EXTERN GType gitg_diff_image_composite_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_image_overlay_get_type (void) G_GNUC_CONST ;
static gboolean gitg_diff_image_overlay_real_draw (GtkWidget* base,
                                            cairo_t* cr);
VALA_EXTERN void gitg_diff_image_composite_get_sizing (GitgDiffImageComposite* self,
                                           gint width,
                                           gint* image_width,
                                           gint* image_height);
VALA_EXTERN GType gitg_diff_image_surface_cache_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GitgDiffImageSurfaceCache* gitg_diff_image_composite_get_cache (GitgDiffImageComposite* self);
VALA_EXTERN cairo_surface_t* gitg_diff_image_surface_cache_get_old_surface (GitgDiffImageSurfaceCache* self,
                                                                GdkWindow* window);
VALA_EXTERN cairo_surface_t* gitg_diff_image_surface_cache_get_new_surface (GitgDiffImageSurfaceCache* self,
                                                                GdkWindow* window);
static void gitg_diff_image_overlay_real_realize (GtkWidget* base);
VALA_EXTERN GitgDiffImageOverlay* gitg_diff_image_overlay_new (void);
VALA_EXTERN GitgDiffImageOverlay* gitg_diff_image_overlay_construct (GType object_type);
VALA_EXTERN GitgDiffImageComposite* gitg_diff_image_composite_new (void);
VALA_EXTERN GitgDiffImageComposite* gitg_diff_image_composite_construct (GType object_type);
VALA_EXTERN gdouble gitg_diff_image_overlay_get_alpha (GitgDiffImageOverlay* self);
VALA_EXTERN void gitg_diff_image_overlay_set_alpha (GitgDiffImageOverlay* self,
                                        gdouble value);
static GObject * gitg_diff_image_overlay_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void gitg_diff_image_overlay_finalize (GObject * obj);
static GType gitg_diff_image_overlay_get_type_once (void);
static void _vala_gitg_diff_image_overlay_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_gitg_diff_image_overlay_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static inline gpointer
gitg_diff_image_overlay_get_instance_private (GitgDiffImageOverlay* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffImageOverlay_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
gitg_diff_image_overlay_real_draw (GtkWidget* base,
                                   cairo_t* cr)
{
	GitgDiffImageOverlay * self;
	GdkWindow* window = NULL;
	GdkWindow* _tmp0_;
	GdkWindow* _tmp1_;
	GtkAllocation alloc = {0};
	GtkAllocation _tmp2_ = {0};
	gint image_width = 0;
	gint image_height = 0;
	GtkAllocation _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	cairo_surface_t* old_surface = NULL;
	GitgDiffImageSurfaceCache* _tmp6_;
	GitgDiffImageSurfaceCache* _tmp7_;
	GdkWindow* _tmp8_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* new_surface = NULL;
	GitgDiffImageSurfaceCache* _tmp10_;
	GitgDiffImageSurfaceCache* _tmp11_;
	GdkWindow* _tmp12_;
	cairo_surface_t* _tmp13_;
	gint x = 0;
	GtkAllocation _tmp14_;
	gint y = 0;
	gboolean _tmp15_ = FALSE;
	cairo_surface_t* _tmp16_;
	gboolean _tmp18_ = FALSE;
	cairo_surface_t* _tmp19_;
	gboolean result;
	self = (GitgDiffImageOverlay*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	GTK_WIDGET_CLASS (gitg_diff_image_overlay_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageComposite), cr);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp2_);
	alloc = _tmp2_;
	_tmp3_ = alloc;
	gitg_diff_image_composite_get_sizing ((GitgDiffImageComposite*) self, _tmp3_.width, &_tmp4_, &_tmp5_);
	image_width = _tmp4_;
	image_height = _tmp5_;
	_tmp6_ = gitg_diff_image_composite_get_cache ((GitgDiffImageComposite*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = window;
	_tmp9_ = gitg_diff_image_surface_cache_get_old_surface (_tmp7_, _tmp8_);
	old_surface = _tmp9_;
	_tmp10_ = gitg_diff_image_composite_get_cache ((GitgDiffImageComposite*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = window;
	_tmp13_ = gitg_diff_image_surface_cache_get_new_surface (_tmp11_, _tmp12_);
	new_surface = _tmp13_;
	_tmp14_ = alloc;
	x = (_tmp14_.width - image_width) / 2;
	y = 0;
	_tmp16_ = old_surface;
	if (_tmp16_ != NULL) {
		_tmp15_ = self->priv->d_alpha != ((gdouble) 1);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		cairo_surface_t* _tmp17_;
		_tmp17_ = old_surface;
		cairo_set_source_surface (cr, _tmp17_, (gdouble) x, (gdouble) y);
		cairo_paint_with_alpha (cr, 1 - self->priv->d_alpha);
	}
	_tmp19_ = new_surface;
	if (_tmp19_ != NULL) {
		_tmp18_ = self->priv->d_alpha != ((gdouble) 0);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		cairo_surface_t* _tmp20_;
		_tmp20_ = new_surface;
		cairo_set_source_surface (cr, _tmp20_, (gdouble) x, (gdouble) y);
		cairo_paint_with_alpha (cr, self->priv->d_alpha);
	}
	result = TRUE;
	_cairo_surface_destroy0 (new_surface);
	_cairo_surface_destroy0 (old_surface);
	_g_object_unref0 (window);
	return result;
}

static void
gitg_diff_image_overlay_real_realize (GtkWidget* base)
{
	GitgDiffImageOverlay * self;
	self = (GitgDiffImageOverlay*) base;
	GTK_WIDGET_CLASS (gitg_diff_image_overlay_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GITG_TYPE_DIFF_IMAGE_COMPOSITE, GitgDiffImageComposite));
	gtk_widget_queue_resize ((GtkWidget*) self);
}

GitgDiffImageOverlay*
gitg_diff_image_overlay_construct (GType object_type)
{
	GitgDiffImageOverlay * self = NULL;
	self = (GitgDiffImageOverlay*) gitg_diff_image_composite_construct (object_type);
	return self;
}

GitgDiffImageOverlay*
gitg_diff_image_overlay_new (void)
{
	return gitg_diff_image_overlay_construct (GITG_TYPE_DIFF_IMAGE_OVERLAY);
}

gdouble
gitg_diff_image_overlay_get_alpha (GitgDiffImageOverlay* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->d_alpha;
	return result;
}

void
gitg_diff_image_overlay_set_alpha (GitgDiffImageOverlay* self,
                                   gdouble value)
{
	gdouble newalpha = 0.0;
	g_return_if_fail (self != NULL);
	newalpha = MAX ((gdouble) 0, MIN (value, (gdouble) 1));
	if (newalpha != self->priv->d_alpha) {
		self->priv->d_alpha = newalpha;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_image_overlay_properties[GITG_DIFF_IMAGE_OVERLAY_ALPHA_PROPERTY]);
}

static GObject *
gitg_diff_image_overlay_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDiffImageOverlay * self;
	parent_class = G_OBJECT_CLASS (gitg_diff_image_overlay_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlay);
	gitg_diff_image_overlay_set_alpha (self, 0.5);
	return obj;
}

static void
gitg_diff_image_overlay_class_init (GitgDiffImageOverlayClass * klass,
                                    gpointer klass_data)
{
	gitg_diff_image_overlay_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffImageOverlay_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) gitg_diff_image_overlay_real_draw;
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) gitg_diff_image_overlay_real_realize;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_image_overlay_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_image_overlay_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_diff_image_overlay_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_image_overlay_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_IMAGE_OVERLAY_ALPHA_PROPERTY, gitg_diff_image_overlay_properties[GITG_DIFF_IMAGE_OVERLAY_ALPHA_PROPERTY] = g_param_spec_double ("alpha", "alpha", "alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gitg_diff_image_overlay_instance_init (GitgDiffImageOverlay * self,
                                       gpointer klass)
{
	self->priv = gitg_diff_image_overlay_get_instance_private (self);
}

static void
gitg_diff_image_overlay_finalize (GObject * obj)
{
	GitgDiffImageOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlay);
	G_OBJECT_CLASS (gitg_diff_image_overlay_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_image_overlay_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffImageOverlayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_image_overlay_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffImageOverlay), 0, (GInstanceInitFunc) gitg_diff_image_overlay_instance_init, NULL };
	GType gitg_diff_image_overlay_type_id;
	gitg_diff_image_overlay_type_id = g_type_register_static (GITG_TYPE_DIFF_IMAGE_COMPOSITE, "GitgDiffImageOverlay", &g_define_type_info, 0);
	GitgDiffImageOverlay_private_offset = g_type_add_instance_private (gitg_diff_image_overlay_type_id, sizeof (GitgDiffImageOverlayPrivate));
	return gitg_diff_image_overlay_type_id;
}

GType
gitg_diff_image_overlay_get_type (void)
{
	static gsize gitg_diff_image_overlay_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_image_overlay_type_id__once)) {
		GType gitg_diff_image_overlay_type_id;
		gitg_diff_image_overlay_type_id = gitg_diff_image_overlay_get_type_once ();
		g_once_init_leave (&gitg_diff_image_overlay_type_id__once, gitg_diff_image_overlay_type_id);
	}
	return gitg_diff_image_overlay_type_id__once;
}

static void
_vala_gitg_diff_image_overlay_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	GitgDiffImageOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlay);
	switch (property_id) {
		case GITG_DIFF_IMAGE_OVERLAY_ALPHA_PROPERTY:
		g_value_set_double (value, gitg_diff_image_overlay_get_alpha (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_image_overlay_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	GitgDiffImageOverlay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_IMAGE_OVERLAY, GitgDiffImageOverlay);
	switch (property_id) {
		case GITG_DIFF_IMAGE_OVERLAY_ALPHA_PROPERTY:
		gitg_diff_image_overlay_set_alpha (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

