/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_message_strobe_random = R"doc(Send message at defined interval.

Takes a PMT message and sends it out at random intervals. The interval is based on a random distribution, , with specified mean () and variance (). Useful for testing/debugging the message system.

Constructor Specific Documentation:

Make a message stobe block to sends message  at random intervals defined by the distribution  with mean  and standard deviation .

Args:
    msg : The message to send as a PMT.
    dist : The random distribution from which to draw the time between events.
    mean_ms : The mean of the distribution, in milliseconds.
    std_ms : The standard deviation of the Gaussian distribution, or the maximum absolute deviation of the Uniform distribution, in milliseconds. This argument is ignored for other distributions.)doc";


static const char* __doc_gr_blocks_message_strobe_random_message_strobe_random_0 =
    R"doc()doc";


static const char* __doc_gr_blocks_message_strobe_random_message_strobe_random_1 =
    R"doc()doc";


static const char* __doc_gr_blocks_message_strobe_random_make = R"doc(Send message at defined interval.

Takes a PMT message and sends it out at random intervals. The interval is based on a random distribution, , with specified mean () and variance (). Useful for testing/debugging the message system.

Constructor Specific Documentation:

Make a message stobe block to sends message  at random intervals defined by the distribution  with mean  and standard deviation .

Args:
    msg : The message to send as a PMT.
    dist : The random distribution from which to draw the time between events.
    mean_ms : The mean of the distribution, in milliseconds.
    std_ms : The standard deviation of the Gaussian distribution, or the maximum absolute deviation of the Uniform distribution, in milliseconds. This argument is ignored for other distributions.)doc";


static const char* __doc_gr_blocks_message_strobe_random_set_msg = R"doc(Reset the message being sent.)doc";


static const char* __doc_gr_blocks_message_strobe_random_msg = R"doc(Get the value of the message being sent.)doc";


static const char* __doc_gr_blocks_message_strobe_random_set_dist = R"doc()doc";


static const char* __doc_gr_blocks_message_strobe_random_dist = R"doc(get the current distribution.)doc";


static const char* __doc_gr_blocks_message_strobe_random_set_mean = R"doc(Reset the sending interval.)doc";


static const char* __doc_gr_blocks_message_strobe_random_mean = R"doc(Get the time interval of the strobe_random.)doc";


static const char* __doc_gr_blocks_message_strobe_random_set_std = R"doc(Reset the sending interval.)doc";


static const char* __doc_gr_blocks_message_strobe_random_std = R"doc(Get the std of strobe_random.)doc";
