/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, blocks, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_blocks_pack_k_bits_bb = R"doc(Converts a stream of bytes with 1 bit in the LSB to a byte with k relevant bits.

This block takes in K bytes at a time, and uses the least significant bit to form a new byte.


Example: k = 4 in = [0,1,0,1, 0x81,0x00,0x00,0x00] out = [0x05, 0x08]

Constructor Specific Documentation:

Make a pack_k_bits block.

Args:
    k : number of bits to be packed.)doc";


static const char* __doc_gr_blocks_pack_k_bits_bb_pack_k_bits_bb = R"doc()doc";


static const char* __doc_gr_blocks_pack_k_bits_bb_make = R"doc(Converts a stream of bytes with 1 bit in the LSB to a byte with k relevant bits.

This block takes in K bytes at a time, and uses the least significant bit to form a new byte.


Example: k = 4 in = [0,1,0,1, 0x81,0x00,0x00,0x00] out = [0x05, 0x08]

Constructor Specific Documentation:

Make a pack_k_bits block.

Args:
    k : number of bits to be packed.)doc";
