/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, fec, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_fec_depuncture_bb = R"doc(Depuncture a stream of samples.

Depuncture a given block of input samples of . The items produced is based on the pattern . Basically, if:





This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the depuncturing will be done on the symbol level, not the bit level.


 is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





Example: 


The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist(\"11101111\"). Also, this allows us to use puncsize=len(\"11101111\") to make sure that our sizes are set up correctly for the pattern we want.


The fec.extended_decoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

Constructor Specific Documentation:

Constructs a depuncture block.

Args:
    puncsize : Size of block of bits to puncture
    puncpat : The puncturing pattern
    delay : Delayed the puncturing pattern by shifting it
    symbol : The symbol to reinsert into the stream (def=127))doc";


static const char* __doc_gr_fec_depuncture_bb_depuncture_bb = R"doc()doc";


static const char* __doc_gr_fec_depuncture_bb_make = R"doc(Depuncture a stream of samples.

Depuncture a given block of input samples of . The items produced is based on the pattern . Basically, if:





This block is designed for unpacked bits - that is, every input sample is a bit, either a 1 or 0. It's possible to use packed bits as symbols, but the depuncturing will be done on the symbol level, not the bit level.


 is specified as a 32-bit integer that we can convert into the vector _puncpat used in the algorithm above:





Example: 


The gr.fec Python module provides a read_bitlist function that can turn a string of a puncture pattern into the correct integer form. The pattern of 0xEF could be specified as fec.readbitlist(\"11101111\"). Also, this allows us to use puncsize=len(\"11101111\") to make sure that our sizes are set up correctly for the pattern we want.


The fec.extended_decoder takes in the puncture pattern directly as a string and uses the readbitlist inside to do the conversion.


The  parameter delays the application of the puncture pattern. This is equivalent to circularly rotating the  by . Note that because of the circular shift, the delay should be between 0 and , but this is not enforced; the effective delay will simply be  mod . A negative value here is ignored.

Constructor Specific Documentation:

Constructs a depuncture block.

Args:
    puncsize : Size of block of bits to puncture
    puncpat : The puncturing pattern
    delay : Delayed the puncturing pattern by shifting it
    symbol : The symbol to reinsert into the stream (def=127))doc";
