/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_additive_scrambler = R"doc(Scramble an input stream using an LFSR.

The scrambler can work with soft symbols (gr_complex, float, int32_t, or int16_t) or with hard symbols (uint8_t). When working with soft symbols, the scrambler works by changing the sign of the input symbol whenever the output of the LFSR is one.


When working with hard symbols, this block scrambles up to 8 bits per byte of the input data stream, starting at the LSB. In this case, the scrambler works by XORing the incoming bit stream by the output of the LFSR.


In both cases, optionally, after  bits have been processed, the shift register is reset to the  value. This allows processing fixed length vectors of samples.


Alternatively, the LFSR can be reset using a reset tag to scramble variable length vectors. However, it cannot be reset between bytes in the hard symbol mode.


For details on configuring the LFSR, see gr::digital::lfsr.

Constructor Specific Documentation:

Create additive scrambler.

Args:
    mask : Polynomial mask for LFSR
    seed : Initial shift register contents
    len : Shift register length
    count : Number of bytes after which shift register is reset, 0=never
    bits_per_byte : Number of bits per byte (must be 1 if T != uint8_t)
    reset_tag_key : When a tag with this key is detected, the shift register is reset (when this is set, count is ignored!))doc";


static const char* __doc_gr_digital_additive_scrambler_additive_scrambler_0 = R"doc()doc";


static const char* __doc_gr_digital_additive_scrambler_additive_scrambler_1 = R"doc()doc";


static const char* __doc_gr_digital_additive_scrambler_make = R"doc(Scramble an input stream using an LFSR.

The scrambler can work with soft symbols (gr_complex, float, int32_t, or int16_t) or with hard symbols (uint8_t). When working with soft symbols, the scrambler works by changing the sign of the input symbol whenever the output of the LFSR is one.


When working with hard symbols, this block scrambles up to 8 bits per byte of the input data stream, starting at the LSB. In this case, the scrambler works by XORing the incoming bit stream by the output of the LFSR.


In both cases, optionally, after  bits have been processed, the shift register is reset to the  value. This allows processing fixed length vectors of samples.


Alternatively, the LFSR can be reset using a reset tag to scramble variable length vectors. However, it cannot be reset between bytes in the hard symbol mode.


For details on configuring the LFSR, see gr::digital::lfsr.

Constructor Specific Documentation:

Create additive scrambler.

Args:
    mask : Polynomial mask for LFSR
    seed : Initial shift register contents
    len : Shift register length
    count : Number of bytes after which shift register is reset, 0=never
    bits_per_byte : Number of bits per byte (must be 1 if T != uint8_t)
    reset_tag_key : When a tag with this key is detected, the shift register is reset (when this is set, count is ignored!))doc";


static const char* __doc_gr_digital_additive_scrambler_mask = R"doc()doc";


static const char* __doc_gr_digital_additive_scrambler_seed = R"doc()doc";


static const char* __doc_gr_digital_additive_scrambler_len = R"doc()doc";


static const char* __doc_gr_digital_additive_scrambler_count = R"doc()doc";


static const char* __doc_gr_digital_additive_scrambler_bits_per_byte = R"doc()doc";
