// python wrapper for vtkViewLayout
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkViewLayout.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkViewLayout(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkViewLayout_ClassNew(); }


static PyObject *
PyvtkViewLayout_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkViewLayout::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkViewLayout::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkViewLayout *tempr = vtkViewLayout::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkViewLayout *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkViewLayout::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkViewLayout::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkViewLayout::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_ShowOnTileDisplay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowOnTileDisplay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowOnTileDisplay();
    }
    else
    {
      op->vtkViewLayout::ShowOnTileDisplay();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_RemoveAllViews(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveAllViews");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RemoveAllViews();
    }
    else
    {
      op->vtkViewLayout::RemoveAllViews();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_AddView_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  vtkPVView *temp0 = nullptr;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVView") &&
      ap.GetArray(temp1, size1))
  {
    if (ap.IsBound())
    {
      op->AddView(temp0, temp1);
    }
    else
    {
      op->vtkViewLayout::AddView(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkViewLayout_AddView_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  vtkPVComparativeView *temp0 = nullptr;
  size_t size1 = ap.GetArgSize(1);
  vtkPythonArgs::Array<double> store1(size1);
  double *temp1 = store1.Data();
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVComparativeView") &&
      ap.GetArray(temp1, size1))
  {
    if (ap.IsBound())
    {
      op->AddView(temp0, temp1);
    }
    else
    {
      op->vtkViewLayout::AddView(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkViewLayout_AddView_Methods[] = {
  {"AddView", PyvtkViewLayout_AddView_s1, METH_VARARGS,
   "@VP *vtkPVView *d"},
  {"AddView", PyvtkViewLayout_AddView_s2, METH_VARARGS,
   "@VP *vtkPVComparativeView *d"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkViewLayout_AddView(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkViewLayout_AddView_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "AddView");
  return nullptr;
}


static PyObject *
PyvtkViewLayout_SaveAsPNG(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveAsPNG");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->SaveAsPNG(temp0, temp1) :
      op->vtkViewLayout::SaveAsPNG(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_SetSeparatorColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeparatorColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetSeparatorColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkViewLayout::SetSeparatorColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkViewLayout_SetSeparatorColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeparatorColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  const size_t size0 = 3;
  double temp0[3];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSeparatorColor(temp0);
    }
    else
    {
      op->vtkViewLayout::SetSeparatorColor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkViewLayout_SetSeparatorColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 3:
      return PyvtkViewLayout_SetSeparatorColor_s1(self, args);
    case 1:
      return PyvtkViewLayout_SetSeparatorColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSeparatorColor");
  return nullptr;
}


static PyObject *
PyvtkViewLayout_GetSeparatorColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSeparatorColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  size_t sizer = 3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetSeparatorColor() :
      op->vtkViewLayout::GetSeparatorColor());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_SetSeparatorWidth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSeparatorWidth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSeparatorWidth(temp0);
    }
    else
    {
      op->vtkViewLayout::SetSeparatorWidth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_GetSeparatorWidthMinValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSeparatorWidthMinValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSeparatorWidthMinValue() :
      op->vtkViewLayout::GetSeparatorWidthMinValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_GetSeparatorWidthMaxValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSeparatorWidthMaxValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSeparatorWidthMaxValue() :
      op->vtkViewLayout::GetSeparatorWidthMaxValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkViewLayout_GetSeparatorWidth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSeparatorWidth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkViewLayout *op = static_cast<vtkViewLayout *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSeparatorWidth() :
      op->vtkViewLayout::GetSeparatorWidth());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkViewLayout_Methods[] = {
  {"IsTypeOf", PyvtkViewLayout_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkViewLayout_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkViewLayout_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkViewLayout\nC++: static vtkViewLayout *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkViewLayout_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkViewLayout\nC++: vtkViewLayout *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkViewLayout_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkViewLayout_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ShowOnTileDisplay", PyvtkViewLayout_ShowOnTileDisplay, METH_VARARGS,
   "ShowOnTileDisplay(self) -> None\nC++: void ShowOnTileDisplay()\n\nThis method is called to make this layout the one to be shown on\nthe tile display, if any. This will deactivate the previously\nchosen layout, if any.\n"},
  {"RemoveAllViews", PyvtkViewLayout_RemoveAllViews, METH_VARARGS,
   "RemoveAllViews(self) -> None\nC++: void RemoveAllViews()\n\nAdd/remove views in this layout.\n"},
  {"AddView", PyvtkViewLayout_AddView, METH_VARARGS,
   "AddView(self, __a:vtkPVView, viewport:(float, ...)) -> None\nC++: void AddView(vtkPVView *, const double *viewport)\nAddView(self, __a:vtkPVComparativeView, viewport:(float, ...))\n    -> None\nC++: void AddView(vtkPVComparativeView *, const double *viewport)\n\n"},
  {"SaveAsPNG", PyvtkViewLayout_SaveAsPNG, METH_VARARGS,
   "SaveAsPNG(self, rank:int, fname:str) -> bool\nC++: bool SaveAsPNG(int rank, const char *fname)\n\nIntended for testing and debugging. When called, this will save\nthe layout results to an png file.\n"},
  {"SetSeparatorColor", PyvtkViewLayout_SetSeparatorColor, METH_VARARGS,
   "SetSeparatorColor(self, _arg1:float, _arg2:float, _arg3:float)\n    -> None\nC++: virtual void SetSeparatorColor(double _arg1, double _arg2,\n    double _arg3)\nSetSeparatorColor(self, _arg:(float, float, float)) -> None\nC++: virtual void SetSeparatorColor(const double _arg[3])\n\nSet the color to use for separator between views in multi-view\nconfigurations when saving images.\n\nThe arguments are the components of the red, green, and blue\nchannels from 0.0 to 1.0.\n"},
  {"GetSeparatorColor", PyvtkViewLayout_GetSeparatorColor, METH_VARARGS,
   "GetSeparatorColor(self) -> (float, float, float)\nC++: virtual double *GetSeparatorColor()\n\n"},
  {"SetSeparatorWidth", PyvtkViewLayout_SetSeparatorWidth, METH_VARARGS,
   "SetSeparatorWidth(self, _arg:int) -> None\nC++: virtual void SetSeparatorWidth(int _arg)\n\nGet/Set the separator width (in pixels) to use for separator\nbetween views in multi-view configurations.\n"},
  {"GetSeparatorWidthMinValue", PyvtkViewLayout_GetSeparatorWidthMinValue, METH_VARARGS,
   "GetSeparatorWidthMinValue(self) -> int\nC++: virtual int GetSeparatorWidthMinValue()\n\n"},
  {"GetSeparatorWidthMaxValue", PyvtkViewLayout_GetSeparatorWidthMaxValue, METH_VARARGS,
   "GetSeparatorWidthMaxValue(self) -> int\nC++: virtual int GetSeparatorWidthMaxValue()\n\n"},
  {"GetSeparatorWidth", PyvtkViewLayout_GetSeparatorWidth, METH_VARARGS,
   "GetSeparatorWidth(self) -> int\nC++: virtual int GetSeparatorWidth()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkViewLayout_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("separator_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkViewLayout_GetSeparatorColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkViewLayout_SetSeparatorColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkViewLayout_SetSeparatorColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSeparatorColor/SetSeparatorColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("separator_width"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkViewLayout_GetSeparatorWidth(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkViewLayout_SetSeparatorWidth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkViewLayout_SetSeparatorWidth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSeparatorWidth/SetSeparatorWidth\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkViewLayout_Doc =
  "vtkViewLayout - used by vtkSMViewLayoutProxy.\n\n"
  "Superclass: vtkObject\n\n"
  "vtkViewLayout is the server-side object corresponding to\n"
  "vtkSMViewLayoutProxy. vtkSMViewLayoutProxy corresponds to a single\n"
  "layout of views. In ParaView UI, this corresponds to a single tab. In\n"
  "tile-display mode, the server-side only has \"1 tab\", in a manner of\n"
  "speaking. Thus, we need to ensure that the server shows the views\n"
  "laid out in the active tab. This class helps vtkSMViewLayoutProxy do\n"
  "that.\n\n"
  "In addition, in tile display mode this class handles setting of\n"
  "window size and positions for each view known to the layout before\n"
  "any of view renders. Additionally, it also handles pasting back\n"
  "rendering results on the processes specific render window (see\n"
  "vtkPVProcessWindow), if any, if appropriate for current mode e.g. in\n"
  "tile display mode, CAVE mode, client-server mode when\n"
  "PV_DEBUG_REMOTE_RENDERING is set or on root node in batch mode.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkViewLayout_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkViewLayout", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkViewLayout_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkViewLayout_StaticNew()
{
  return vtkViewLayout::New();
}

PyObject *PyvtkViewLayout_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkViewLayout_Type, PyvtkViewLayout_Methods,
    "vtkViewLayout",
 &PyvtkViewLayout_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  for (int c = 0; c < 2; c++)
  {
    static const struct { const char *name; int value; }
      constants[2] = {
        { "RequestUpdateLayoutEvent", vtkViewLayout::RequestUpdateLayoutEvent },
        { "RequestUpdateDisplayEvent", vtkViewLayout::RequestUpdateDisplayEvent },
      };

    o = PyLong_FromLong(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkViewLayout_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkViewLayout(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkViewLayout_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkViewLayout", o) != 0)
  {
    Py_DECREF(o);
  }

}

