/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtGui.h"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtGui/qcolorspace.sip"
#include <qcolorspace.h>
#line 29 "/build/pyqt6/src/pyqt6-6.10.1/build/QtGui/sipQtGuiQColorSpace.cpp"

#line 991 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpycore_qlist.sip"
#include <qlist.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/build/QtGui/sipQtGuiQColorSpace.cpp"
#line 110 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qpoint.sip"
#include <qpoint.h>
#line 36 "/build/pyqt6/src/pyqt6-6.10.1/build/QtGui/sipQtGuiQColorSpace.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtGui/qcolorspace.sip"
#include <qcolorspace.h>
#line 174 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtGui/qcolorspace.sip"
#include <qcolorspace.h>
#line 41 "/build/pyqt6/src/pyqt6-6.10.1/build/QtGui/sipQtGuiQColorSpace.cpp"
#line 24 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 44 "/build/pyqt6/src/pyqt6-6.10.1/build/QtGui/sipQtGuiQColorSpace.cpp"
#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtGui/qcolortransform.sip"
#include <qcolortransform.h>
#line 47 "/build/pyqt6/src/pyqt6-6.10.1/build/QtGui/sipQtGuiQColorSpace.cpp"
#line 30 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtCore/qbytearray.sip"
#include <qbytearray.h>
#line 50 "/build/pyqt6/src/pyqt6-6.10.1/build/QtGui/sipQtGuiQColorSpace.cpp"


PyDoc_STRVAR(doc_QColorSpace_swap, "swap(self, colorSpace: QColorSpace)");

extern "C" {static PyObject *meth_QColorSpace_swap(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_swap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QColorSpace* a0;
        ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QColorSpace, &a0))
        {
            sipCpp->swap(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_swap, doc_QColorSpace_swap);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_primaries, "primaries(self) -> QColorSpace.Primaries");

extern "C" {static PyObject *meth_QColorSpace_primaries(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_primaries(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QColorSpace::Primaries sipRes;

            sipRes = sipCpp->primaries();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QColorSpace_Primaries);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_primaries, doc_QColorSpace_primaries);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_transferFunction, "transferFunction(self) -> QColorSpace.TransferFunction");

extern "C" {static PyObject *meth_QColorSpace_transferFunction(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_transferFunction(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QColorSpace::TransferFunction sipRes;

            sipRes = sipCpp->transferFunction();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QColorSpace_TransferFunction);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_transferFunction, doc_QColorSpace_transferFunction);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_gamma, "gamma(self) -> float");

extern "C" {static PyObject *meth_QColorSpace_gamma(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_gamma(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            float sipRes;

            sipRes = sipCpp->gamma();

            return PyFloat_FromDouble((double)sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_gamma, doc_QColorSpace_gamma);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_setTransferFunction, "setTransferFunction(self, transferFunction: QColorSpace.TransferFunction, gamma: float = 0)\n"
"setTransferFunction(self, transferFunctionTable: Iterable[int])");

extern "C" {static PyObject *meth_QColorSpace_setTransferFunction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_setTransferFunction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QColorSpace::TransferFunction a0;
        float a1 = 0;
        ::QColorSpace *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_gamma,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE|f", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QColorSpace_TransferFunction, &a0, &a1))
        {
            sipCpp->setTransferFunction(a0, a1);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::QList<unsigned short>* a0;
        int a0State = 0;
        ::QColorSpace *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QList_1600, &a0, &a0State))
        {
            sipCpp->setTransferFunction(*a0);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a0), sipType_QList_1600, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_setTransferFunction, doc_QColorSpace_setTransferFunction);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_setTransferFunctions, "setTransferFunctions(self, redTransferFunctionTable: Iterable[int], greenTransferFunctionTable: Iterable[int], blueTransferFunctionTable: Iterable[int])");

extern "C" {static PyObject *meth_QColorSpace_setTransferFunctions(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_setTransferFunctions(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QList<unsigned short>* a0;
        int a0State = 0;
        const ::QList<unsigned short>* a1;
        int a1State = 0;
        const ::QList<unsigned short>* a2;
        int a2State = 0;
        ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QList_1600, &a0, &a0State, sipType_QList_1600, &a1, &a1State, sipType_QList_1600, &a2, &a2State))
        {
            sipCpp->setTransferFunctions(*a0, *a1, *a2);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a0), sipType_QList_1600, a0State);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a1), sipType_QList_1600, a1State);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a2), sipType_QList_1600, a2State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_setTransferFunctions, doc_QColorSpace_setTransferFunctions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_withTransferFunction, "withTransferFunction(self, transferFunctionTable: Iterable[int]) -> QColorSpace\n"
"withTransferFunction(self, transferFunction: QColorSpace.TransferFunction, gamma: float = 0) -> QColorSpace");

extern "C" {static PyObject *meth_QColorSpace_withTransferFunction(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_withTransferFunction(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QList<unsigned short>* a0;
        int a0State = 0;
        const ::QColorSpace *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "BJ1", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QList_1600, &a0, &a0State))
        {
            ::QColorSpace*sipRes;

            sipRes = new ::QColorSpace(sipCpp->withTransferFunction(*a0));
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a0), sipType_QList_1600, a0State);

            return sipConvertFromNewType(sipRes, sipType_QColorSpace, SIP_NULLPTR);
        }
    }

    {
        ::QColorSpace::TransferFunction a0;
        float a1 = 0;
        const ::QColorSpace *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_gamma,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE|f", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QColorSpace_TransferFunction, &a0, &a1))
        {
            ::QColorSpace*sipRes;

            sipRes = new ::QColorSpace(sipCpp->withTransferFunction(a0, a1));

            return sipConvertFromNewType(sipRes, sipType_QColorSpace, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_withTransferFunction, doc_QColorSpace_withTransferFunction);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_withTransferFunctions, "withTransferFunctions(self, redTransferFunctionTable: Iterable[int], greenTransferFunctionTable: Iterable[int], blueTransferFunctionTable: Iterable[int]) -> QColorSpace");

extern "C" {static PyObject *meth_QColorSpace_withTransferFunctions(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_withTransferFunctions(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QList<unsigned short>* a0;
        int a0State = 0;
        const ::QList<unsigned short>* a1;
        int a1State = 0;
        const ::QList<unsigned short>* a2;
        int a2State = 0;
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QList_1600, &a0, &a0State, sipType_QList_1600, &a1, &a1State, sipType_QList_1600, &a2, &a2State))
        {
            ::QColorSpace*sipRes;

            sipRes = new ::QColorSpace(sipCpp->withTransferFunctions(*a0, *a1, *a2));
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a0), sipType_QList_1600, a0State);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a1), sipType_QList_1600, a1State);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a2), sipType_QList_1600, a2State);

            return sipConvertFromNewType(sipRes, sipType_QColorSpace, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_withTransferFunctions, doc_QColorSpace_withTransferFunctions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_setPrimaries, "setPrimaries(self, primariesId: QColorSpace.Primaries)\n"
"setPrimaries(self, whitePoint: QPointF, redPoint: QPointF, greenPoint: QPointF, bluePoint: QPointF)");

extern "C" {static PyObject *meth_QColorSpace_setPrimaries(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_setPrimaries(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QColorSpace::Primaries a0;
        ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QColorSpace_Primaries, &a0))
        {
            sipCpp->setPrimaries(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::QPointF* a0;
        const ::QPointF* a1;
        const ::QPointF* a2;
        const ::QPointF* a3;
        ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9J9J9J9", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QPointF, &a0, sipType_QPointF, &a1, sipType_QPointF, &a2, sipType_QPointF, &a3))
        {
            sipCpp->setPrimaries(*a0, *a1, *a2, *a3);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_setPrimaries, doc_QColorSpace_setPrimaries);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QColorSpace_isValid(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_isValid, doc_QColorSpace_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_fromIccProfile, "fromIccProfile(iccProfile: QByteArray|bytes|bytearray|memoryview) -> QColorSpace");

extern "C" {static PyObject *meth_QColorSpace_fromIccProfile(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_fromIccProfile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QByteArray* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "CJ1", &sipSelf, sipType_QByteArray, &a0, &a0State))
        {
            ::QColorSpace*sipRes;

            sipRes = new ::QColorSpace(::QColorSpace::fromIccProfile(*a0));
            sipReleaseType(const_cast< ::QByteArray *>(a0), sipType_QByteArray, a0State);

            return sipConvertFromNewType(sipRes, sipType_QColorSpace, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_fromIccProfile, doc_QColorSpace_fromIccProfile);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_iccProfile, "iccProfile(self) -> QByteArray");

extern "C" {static PyObject *meth_QColorSpace_iccProfile(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_iccProfile(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QByteArray*sipRes;

            sipRes = new ::QByteArray(sipCpp->iccProfile());

            return sipConvertFromNewType(sipRes, sipType_QByteArray, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_iccProfile, doc_QColorSpace_iccProfile);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_transformationToColorSpace, "transformationToColorSpace(self, colorspace: QColorSpace) -> QColorTransform");

extern "C" {static PyObject *meth_QColorSpace_transformationToColorSpace(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_transformationToColorSpace(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace* a0;
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QColorSpace, &a0))
        {
            ::QColorTransform*sipRes;

            sipRes = new ::QColorTransform(sipCpp->transformationToColorSpace(*a0));

            return sipConvertFromNewType(sipRes, sipType_QColorTransform, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_transformationToColorSpace, doc_QColorSpace_transformationToColorSpace);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_description, "description(self) -> str");

extern "C" {static PyObject *meth_QColorSpace_description(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_description(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->description());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_description, doc_QColorSpace_description);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_setDescription, "setDescription(self, description: str|None)");

extern "C" {static PyObject *meth_QColorSpace_setDescription(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_setDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setDescription(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_setDescription, doc_QColorSpace_setDescription);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_setWhitePoint, "setWhitePoint(self, whitePoint: QPointF)");

extern "C" {static PyObject *meth_QColorSpace_setWhitePoint(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_setWhitePoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QPointF* a0;
        ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QPointF, &a0))
        {
            sipCpp->setWhitePoint(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_setWhitePoint, doc_QColorSpace_setWhitePoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_whitePoint, "whitePoint(self) -> QPointF");

extern "C" {static PyObject *meth_QColorSpace_whitePoint(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_whitePoint(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QPointF*sipRes;

            sipRes = new ::QPointF(sipCpp->whitePoint());

            return sipConvertFromNewType(sipRes, sipType_QPointF, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_whitePoint, doc_QColorSpace_whitePoint);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_transformModel, "transformModel(self) -> QColorSpace.TransformModel");

extern "C" {static PyObject *meth_QColorSpace_transformModel(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_transformModel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QColorSpace::TransformModel sipRes;

            sipRes = sipCpp->transformModel();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QColorSpace_TransformModel);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_transformModel, doc_QColorSpace_transformModel);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_colorModel, "colorModel(self) -> QColorSpace.ColorModel");

extern "C" {static PyObject *meth_QColorSpace_colorModel(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_colorModel(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QColorSpace::ColorModel sipRes;

            sipRes = sipCpp->colorModel();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QColorSpace_ColorModel);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_colorModel, doc_QColorSpace_colorModel);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_isValidTarget, "isValidTarget(self) -> bool");

extern "C" {static PyObject *meth_QColorSpace_isValidTarget(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_isValidTarget(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValidTarget();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_isValidTarget, doc_QColorSpace_isValidTarget);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_setPrimaryPoints, "setPrimaryPoints(self, primaryPoints: QColorSpace.PrimaryPoints)");

extern "C" {static PyObject *meth_QColorSpace_setPrimaryPoints(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_setPrimaryPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace::PrimaryPoints* a0;
        ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QColorSpace, &sipCpp, sipType_QColorSpace_PrimaryPoints, &a0))
        {
            sipCpp->setPrimaryPoints(*a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_setPrimaryPoints, doc_QColorSpace_setPrimaryPoints);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QColorSpace_primaryPoints, "primaryPoints(self) -> QColorSpace.PrimaryPoints");

extern "C" {static PyObject *meth_QColorSpace_primaryPoints(PyObject *, PyObject *);}
static PyObject *meth_QColorSpace_primaryPoints(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QColorSpace, &sipCpp))
        {
            ::QColorSpace::PrimaryPoints*sipRes;

            sipRes = new ::QColorSpace::PrimaryPoints(sipCpp->primaryPoints());

            return sipConvertFromNewType(sipRes, sipType_QColorSpace_PrimaryPoints, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QColorSpace, sipName_primaryPoints, doc_QColorSpace_primaryPoints);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_QColorSpace___ne__(PyObject *, PyObject *);}
static PyObject *slot_QColorSpace___ne__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QColorSpace *sipCpp = reinterpret_cast< ::QColorSpace *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QColorSpace));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QColorSpace, &a0))
        {
            bool sipRes;

            sipRes = operator!=((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, ne_slot, sipType_QColorSpace, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_QColorSpace___eq__(PyObject *, PyObject *);}
static PyObject *slot_QColorSpace___eq__(PyObject *sipSelf, PyObject *sipArg)
{
    ::QColorSpace *sipCpp = reinterpret_cast< ::QColorSpace *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf, sipType_QColorSpace));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QColorSpace* a0;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_QColorSpace, &a0))
        {
            bool sipRes;

            sipRes = operator==((*sipCpp), *a0);

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    return sipPySlotExtend(&sipModuleAPI_QtGui, eq_slot, sipType_QColorSpace, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_QColorSpace(void *, int);}
static void release_QColorSpace(void *sipCppV, int)
{
    delete reinterpret_cast< ::QColorSpace *>(sipCppV);
}


extern "C" {static void *array_QColorSpace(Py_ssize_t);}
static void *array_QColorSpace(Py_ssize_t sipNrElem)
{
    return new ::QColorSpace[sipNrElem];
}


extern "C" {static void array_delete_QColorSpace(void *);}
static void array_delete_QColorSpace(void *sipCpp)
{
    delete[] reinterpret_cast< ::QColorSpace *>(sipCpp);
}


extern "C" {static void assign_QColorSpace(void *, Py_ssize_t, void *);}
static void assign_QColorSpace(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QColorSpace *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QColorSpace *>(sipSrc);
}


extern "C" {static void *copy_QColorSpace(const void *, Py_ssize_t);}
static void *copy_QColorSpace(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QColorSpace(reinterpret_cast<const ::QColorSpace *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QColorSpace(sipSimpleWrapper *);}
static void dealloc_QColorSpace(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QColorSpace(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QColorSpace(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QColorSpace(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QColorSpace *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QColorSpace();

            return sipCpp;
        }
    }

    {
        ::QColorSpace::NamedColorSpace a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "E", sipType_QColorSpace_NamedColorSpace, &a0))
        {
            sipCpp = new ::QColorSpace(a0);

            return sipCpp;
        }
    }

    {
        ::QColorSpace::Primaries a0;
        ::QColorSpace::TransferFunction a1;
        float a2 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_gamma,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "EE|f", sipType_QColorSpace_Primaries, &a0, sipType_QColorSpace_TransferFunction, &a1, &a2))
        {
            sipCpp = new ::QColorSpace(a0, a1, a2);

            return sipCpp;
        }
    }

    {
        ::QColorSpace::Primaries a0;
        float a1;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "Ef", sipType_QColorSpace_Primaries, &a0, &a1))
        {
            sipCpp = new ::QColorSpace(a0, a1);

            return sipCpp;
        }
    }

    {
        ::QColorSpace::Primaries a0;
        const ::QList<unsigned short>* a1;
        int a1State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "EJ1", sipType_QColorSpace_Primaries, &a0, sipType_QList_1600, &a1, &a1State))
        {
            sipCpp = new ::QColorSpace(a0, *a1);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a1), sipType_QList_1600, a1State);

            return sipCpp;
        }
    }

    {
        const ::QPointF* a0;
        const ::QPointF* a1;
        const ::QPointF* a2;
        const ::QPointF* a3;
        ::QColorSpace::TransferFunction a4;
        float a5 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_gamma,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J9J9J9E|f", sipType_QPointF, &a0, sipType_QPointF, &a1, sipType_QPointF, &a2, sipType_QPointF, &a3, sipType_QColorSpace_TransferFunction, &a4, &a5))
        {
            sipCpp = new ::QColorSpace(*a0, *a1, *a2, *a3, a4, a5);

            return sipCpp;
        }
    }

    {
        const ::QPointF* a0;
        const ::QPointF* a1;
        const ::QPointF* a2;
        const ::QPointF* a3;
        const ::QList<unsigned short>* a4;
        int a4State = 0;
        const ::QList<unsigned short>* a5;
        int a5State = 0;
        const ::QList<unsigned short>* a6;
        int a6State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J9J9J9J1J1J1", sipType_QPointF, &a0, sipType_QPointF, &a1, sipType_QPointF, &a2, sipType_QPointF, &a3, sipType_QList_1600, &a4, &a4State, sipType_QList_1600, &a5, &a5State, sipType_QList_1600, &a6, &a6State))
        {
            sipCpp = new ::QColorSpace(*a0, *a1, *a2, *a3, *a4, *a5, *a6);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a4), sipType_QList_1600, a4State);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a5), sipType_QList_1600, a5State);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a6), sipType_QList_1600, a6State);

            return sipCpp;
        }
    }

    {
        const ::QPointF* a0;
        const ::QPointF* a1;
        const ::QPointF* a2;
        const ::QPointF* a3;
        const ::QList<unsigned short>* a4;
        int a4State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J9J9J9J1", sipType_QPointF, &a0, sipType_QPointF, &a1, sipType_QPointF, &a2, sipType_QPointF, &a3, sipType_QList_1600, &a4, &a4State))
        {
            sipCpp = new ::QColorSpace(*a0, *a1, *a2, *a3, *a4);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a4), sipType_QList_1600, a4State);

            return sipCpp;
        }
    }

    {
        ::QPointF* a0;
        const ::QList<unsigned short>* a1;
        int a1State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9J1", sipType_QPointF, &a0, sipType_QList_1600, &a1, &a1State))
        {
            sipCpp = new ::QColorSpace(*a0, *a1);
            sipReleaseType(const_cast< ::QList<unsigned short> *>(a1), sipType_QList_1600, a1State);

            return sipCpp;
        }
    }

    {
        ::QPointF* a0;
        ::QColorSpace::TransferFunction a1;
        float a2 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_gamma,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9E|f", sipType_QPointF, &a0, sipType_QColorSpace_TransferFunction, &a1, &a2))
        {
            sipCpp = new ::QColorSpace(*a0, a1, a2);

            return sipCpp;
        }
    }

    {
        const ::QColorSpace* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QColorSpace, &a0))
        {
            sipCpp = new ::QColorSpace(*a0);

            return sipCpp;
        }
    }

    {
        const ::QColorSpace::PrimaryPoints* a0;
        ::QColorSpace::TransferFunction a1;
        float a2 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_gamma,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9E|f", sipType_QColorSpace_PrimaryPoints, &a0, sipType_QColorSpace_TransferFunction, &a1, &a2))
        {
            sipCpp = new ::QColorSpace(*a0, a1, a2);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_QColorSpace[] = {
    {(void *)slot_QColorSpace___ne__, ne_slot},
    {(void *)slot_QColorSpace___eq__, eq_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_QColorSpace[] = {
    {sipName_colorModel, meth_QColorSpace_colorModel, METH_VARARGS, doc_QColorSpace_colorModel},
    {sipName_description, meth_QColorSpace_description, METH_VARARGS, doc_QColorSpace_description},
    {sipName_fromIccProfile, meth_QColorSpace_fromIccProfile, METH_VARARGS, doc_QColorSpace_fromIccProfile},
    {sipName_gamma, meth_QColorSpace_gamma, METH_VARARGS, doc_QColorSpace_gamma},
    {sipName_iccProfile, meth_QColorSpace_iccProfile, METH_VARARGS, doc_QColorSpace_iccProfile},
    {sipName_isValid, meth_QColorSpace_isValid, METH_VARARGS, doc_QColorSpace_isValid},
    {sipName_isValidTarget, meth_QColorSpace_isValidTarget, METH_VARARGS, doc_QColorSpace_isValidTarget},
    {sipName_primaries, meth_QColorSpace_primaries, METH_VARARGS, doc_QColorSpace_primaries},
    {sipName_primaryPoints, meth_QColorSpace_primaryPoints, METH_VARARGS, doc_QColorSpace_primaryPoints},
    {sipName_setDescription, meth_QColorSpace_setDescription, METH_VARARGS, doc_QColorSpace_setDescription},
    {sipName_setPrimaries, meth_QColorSpace_setPrimaries, METH_VARARGS, doc_QColorSpace_setPrimaries},
    {sipName_setPrimaryPoints, meth_QColorSpace_setPrimaryPoints, METH_VARARGS, doc_QColorSpace_setPrimaryPoints},
    {sipName_setTransferFunction, SIP_MLMETH_CAST(meth_QColorSpace_setTransferFunction), METH_VARARGS|METH_KEYWORDS, doc_QColorSpace_setTransferFunction},
    {sipName_setTransferFunctions, meth_QColorSpace_setTransferFunctions, METH_VARARGS, doc_QColorSpace_setTransferFunctions},
    {sipName_setWhitePoint, meth_QColorSpace_setWhitePoint, METH_VARARGS, doc_QColorSpace_setWhitePoint},
    {sipName_swap, meth_QColorSpace_swap, METH_VARARGS, doc_QColorSpace_swap},
    {sipName_transferFunction, meth_QColorSpace_transferFunction, METH_VARARGS, doc_QColorSpace_transferFunction},
    {sipName_transformModel, meth_QColorSpace_transformModel, METH_VARARGS, doc_QColorSpace_transformModel},
    {sipName_transformationToColorSpace, meth_QColorSpace_transformationToColorSpace, METH_VARARGS, doc_QColorSpace_transformationToColorSpace},
    {sipName_whitePoint, meth_QColorSpace_whitePoint, METH_VARARGS, doc_QColorSpace_whitePoint},
    {sipName_withTransferFunction, SIP_MLMETH_CAST(meth_QColorSpace_withTransferFunction), METH_VARARGS|METH_KEYWORDS, doc_QColorSpace_withTransferFunction},
    {sipName_withTransferFunctions, meth_QColorSpace_withTransferFunctions, METH_VARARGS, doc_QColorSpace_withTransferFunctions}
};


/* Define the enum members and ints to be added to this type. */
static sipIntInstanceDef intInstances_QColorSpace[] = {
    {sipName_Undefined, static_cast<int>(::QColorSpace::ColorModel::Undefined)},
    {sipName_Rgb, static_cast<int>(::QColorSpace::ColorModel::Rgb)},
    {sipName_Gray, static_cast<int>(::QColorSpace::ColorModel::Gray)},
    {sipName_Cmyk, static_cast<int>(::QColorSpace::ColorModel::Cmyk)},
    {sipName_SRgb, static_cast<int>(::QColorSpace::SRgb)},
    {sipName_SRgbLinear, static_cast<int>(::QColorSpace::SRgbLinear)},
    {sipName_AdobeRgb, static_cast<int>(::QColorSpace::AdobeRgb)},
    {sipName_DisplayP3, static_cast<int>(::QColorSpace::DisplayP3)},
    {sipName_ProPhotoRgb, static_cast<int>(::QColorSpace::ProPhotoRgb)},
    {sipName_Bt2020, static_cast<int>(::QColorSpace::Bt2020)},
    {sipName_Bt2100Pq, static_cast<int>(::QColorSpace::Bt2100Pq)},
    {sipName_Bt2100Hlg, static_cast<int>(::QColorSpace::Bt2100Hlg)},
    {sipName_Custom, static_cast<int>(::QColorSpace::Primaries::Custom)},
    {sipName_SRgb, static_cast<int>(::QColorSpace::Primaries::SRgb)},
    {sipName_AdobeRgb, static_cast<int>(::QColorSpace::Primaries::AdobeRgb)},
    {sipName_DciP3D65, static_cast<int>(::QColorSpace::Primaries::DciP3D65)},
    {sipName_ProPhotoRgb, static_cast<int>(::QColorSpace::Primaries::ProPhotoRgb)},
    {sipName_Bt2020, static_cast<int>(::QColorSpace::Primaries::Bt2020)},
    {sipName_Custom, static_cast<int>(::QColorSpace::TransferFunction::Custom)},
    {sipName_Linear, static_cast<int>(::QColorSpace::TransferFunction::Linear)},
    {sipName_Gamma, static_cast<int>(::QColorSpace::TransferFunction::Gamma)},
    {sipName_SRgb, static_cast<int>(::QColorSpace::TransferFunction::SRgb)},
    {sipName_ProPhotoRgb, static_cast<int>(::QColorSpace::TransferFunction::ProPhotoRgb)},
    {sipName_Bt2020, static_cast<int>(::QColorSpace::TransferFunction::Bt2020)},
    {sipName_St2084, static_cast<int>(::QColorSpace::TransferFunction::St2084)},
    {sipName_Hlg, static_cast<int>(::QColorSpace::TransferFunction::Hlg)},
    {sipName_ThreeComponentMatrix, static_cast<int>(::QColorSpace::TransformModel::ThreeComponentMatrix)},
    {sipName_ElementListProcessing, static_cast<int>(::QColorSpace::TransformModel::ElementListProcessing)},
    {0, 0}
};

PyDoc_STRVAR(doc_QColorSpace, "\1QColorSpace()\n"
"QColorSpace(namedColorSpace: QColorSpace.NamedColorSpace)\n"
"QColorSpace(primaries: QColorSpace.Primaries, fun: QColorSpace.TransferFunction, gamma: float = 0)\n"
"QColorSpace(primaries: QColorSpace.Primaries, gamma: float)\n"
"QColorSpace(primaries: QColorSpace.Primaries, transferFunctionTable: Iterable[int])\n"
"QColorSpace(whitePoint: QPointF, redPoint: QPointF, greenPoint: QPointF, bluePoint: QPointF, fun: QColorSpace.TransferFunction, gamma: float = 0)\n"
"QColorSpace(whitePoint: QPointF, redPoint: QPointF, greenPoint: QPointF, bluePoint: QPointF, redTransferFunctionTable: Iterable[int], greenTransferFunctionTable: Iterable[int], blueTransferFunctionTable: Iterable[int])\n"
"QColorSpace(whitePoint: QPointF, redPoint: QPointF, greenPoint: QPointF, bluePoint: QPointF, transferFunctionTable: Iterable[int])\n"
"QColorSpace(whitePoint: QPointF, transferFunctionTable: Iterable[int])\n"
"QColorSpace(whitePoint: QPointF, transferFunction: QColorSpace.TransferFunction, gamma: float = 0)\n"
"QColorSpace(colorSpace: QColorSpace)\n"
"QColorSpace(primaryPoints: QColorSpace.PrimaryPoints, transferFunction: QColorSpace.TransferFunction, gamma: float = 0)");


sipClassTypeDef sipTypeDef_QtGui_QColorSpace = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QColorSpace,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_QColorSpace,
        {0, 0, 1},
        22, methods_QColorSpace,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, intInstances_QColorSpace, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QColorSpace,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    slots_QColorSpace,
    init_type_QColorSpace,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QColorSpace,
    assign_QColorSpace,
    array_QColorSpace,
    copy_QColorSpace,
    release_QColorSpace,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QColorSpace,
    sizeof (::QColorSpace),
};
