// content/browser/private_aggregation/private_aggregation_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SHARED_H_
#define CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "content/browser/private_aggregation/private_aggregation_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/mojom/base/int128.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace private_aggregation_internals::mojom {
class AggregatableReportRequestIDDataView;

class AggregatableHistogramContributionDataView;

class WebUIAggregatableReportDataView;



}  // private_aggregation_internals::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView> {
  using Data = ::private_aggregation_internals::mojom::internal::AggregatableReportRequestID_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView> {
  using Data = ::private_aggregation_internals::mojom::internal::AggregatableHistogramContribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView> {
  using Data = ::private_aggregation_internals::mojom::internal::WebUIAggregatableReport_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace private_aggregation_internals::mojom {


enum class ReportStatus : int32_t {
  
  kPending = 0,
  
  kSent = 1,
  
  kFailedToAssemble = 2,
  
  kFailedToSend = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) std::ostream& operator<<(std::ostream& os, ReportStatus value);
inline bool IsKnownEnumValue(ReportStatus value) {
  return internal::ReportStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ObserverInterfaceBase {};

using ObserverPtrDataView =
    mojo::InterfacePtrDataView<ObserverInterfaceBase>;
using ObserverRequestDataView =
    mojo::InterfaceRequestDataView<ObserverInterfaceBase>;
using ObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ObserverInterfaceBase>;
using ObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ObserverInterfaceBase>;
class HandlerInterfaceBase {};

using HandlerPtrDataView =
    mojo::InterfacePtrDataView<HandlerInterfaceBase>;
using HandlerRequestDataView =
    mojo::InterfaceRequestDataView<HandlerInterfaceBase>;
using HandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HandlerInterfaceBase>;
using HandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HandlerInterfaceBase>;
class FactoryInterfaceBase {};

using FactoryPtrDataView =
    mojo::InterfacePtrDataView<FactoryInterfaceBase>;
using FactoryRequestDataView =
    mojo::InterfaceRequestDataView<FactoryInterfaceBase>;
using FactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<FactoryInterfaceBase>;
using FactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<FactoryInterfaceBase>;


class AggregatableReportRequestIDDataView {
 public:
  AggregatableReportRequestIDDataView() = default;

  AggregatableReportRequestIDDataView(
      internal::AggregatableReportRequestID_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int64_t value() const {
    return data_->value;
  }
 private:
  internal::AggregatableReportRequestID_Data* data_ = nullptr;
};


class AggregatableHistogramContributionDataView {
 public:
  AggregatableHistogramContributionDataView() = default;

  AggregatableHistogramContributionDataView(
      internal::AggregatableHistogramContribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBucketDataView(
      ::mojo_base::mojom::Uint128DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBucket(UserType* output) {
    
    auto* pointer = data_->bucket.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::Uint128DataView>(
        pointer, output, message_);
  }
  int32_t value() const {
    return data_->value;
  }
 private:
  internal::AggregatableHistogramContribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebUIAggregatableReportDataView {
 public:
  WebUIAggregatableReportDataView() = default;

  WebUIAggregatableReportDataView(
      internal::WebUIAggregatableReport_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      AggregatableReportRequestIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView>(
        pointer, output, message_);
  }
  double report_time() const {
    return data_->report_time;
  }
  inline void GetApiIdentifierDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApiIdentifier(UserType* output) {
    
    auto* pointer = data_->api_identifier.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetApiVersionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadApiVersion(UserType* output) {
    
    auto* pointer = data_->api_version.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReportUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportUrl(UserType* output) {
    
    auto* pointer = data_->report_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetContributionsDataView(
      mojo::ArrayDataView<AggregatableHistogramContributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContributions(UserType* output) {
    
    auto* pointer = data_->contributions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::private_aggregation_internals::mojom::ReportStatus>(
        data_value, output);
  }
  ReportStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::private_aggregation_internals::mojom::ReportStatus>(data_->status));
  }
  inline void GetReportBodyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReportBody(UserType* output) {
    
    auto* pointer = data_->report_body.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebUIAggregatableReport_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // private_aggregation_internals::mojom

namespace std {

template <>
struct hash<::private_aggregation_internals::mojom::ReportStatus>
    : public mojo::internal::EnumHashImpl<::private_aggregation_internals::mojom::ReportStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::ReportStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::private_aggregation_internals::mojom::ReportStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::private_aggregation_internals::mojom::ReportStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::AggregatableReportRequestID_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::private_aggregation_internals::mojom::internal::AggregatableReportRequestID_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::AggregatableHistogramContribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::bucket(input)) in_bucket = Traits::bucket(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bucket)::BaseType> bucket_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::Uint128DataView>(
        in_bucket, bucket_fragment);
    fragment->bucket.Set(
        bucket_fragment.is_null() ? nullptr : bucket_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->bucket.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bucket in AggregatableHistogramContribution struct");
    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::private_aggregation_internals::mojom::internal::AggregatableHistogramContribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::private_aggregation_internals::mojom::WebUIAggregatableReportDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::private_aggregation_internals::mojom::internal::WebUIAggregatableReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<::private_aggregation_internals::mojom::AggregatableReportRequestIDDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    fragment->report_time = Traits::report_time(input);
    decltype(Traits::api_identifier(input)) in_api_identifier = Traits::api_identifier(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->api_identifier)::BaseType> api_identifier_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_api_identifier, api_identifier_fragment);
    fragment->api_identifier.Set(
        api_identifier_fragment.is_null() ? nullptr : api_identifier_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->api_identifier.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null api_identifier in WebUIAggregatableReport struct");
    decltype(Traits::api_version(input)) in_api_version = Traits::api_version(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->api_version)::BaseType> api_version_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_api_version, api_version_fragment);
    fragment->api_version.Set(
        api_version_fragment.is_null() ? nullptr : api_version_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->api_version.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null api_version in WebUIAggregatableReport struct");
    decltype(Traits::report_url(input)) in_report_url = Traits::report_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_url)::BaseType> report_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_report_url, report_url_fragment);
    fragment->report_url.Set(
        report_url_fragment.is_null() ? nullptr : report_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->report_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_url in WebUIAggregatableReport struct");
    decltype(Traits::contributions(input)) in_contributions = Traits::contributions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contributions)::BaseType>
        contributions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& contributions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::private_aggregation_internals::mojom::AggregatableHistogramContributionDataView>>(
        in_contributions, contributions_fragment, &contributions_validate_params);
    fragment->contributions.Set(
        contributions_fragment.is_null() ? nullptr : contributions_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->contributions.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null contributions in WebUIAggregatableReport struct");
    mojo::internal::Serialize<::private_aggregation_internals::mojom::ReportStatus>(
        Traits::status(input), &fragment->status);
    decltype(Traits::report_body(input)) in_report_body = Traits::report_body(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_body)::BaseType> report_body_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_report_body, report_body_fragment);
    fragment->report_body.Set(
        report_body_fragment.is_null() ? nullptr : report_body_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->report_body.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_body in WebUIAggregatableReport struct");
  }

  static bool Deserialize(::private_aggregation_internals::mojom::internal::WebUIAggregatableReport_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::private_aggregation_internals::mojom::WebUIAggregatableReportDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace private_aggregation_internals::mojom {



inline void AggregatableHistogramContributionDataView::GetBucketDataView(
    ::mojo_base::mojom::Uint128DataView* output) {
  auto pointer = data_->bucket.Get();
  *output = ::mojo_base::mojom::Uint128DataView(pointer, message_);
}


inline void WebUIAggregatableReportDataView::GetIdDataView(
    AggregatableReportRequestIDDataView* output) {
  auto pointer = data_->id.Get();
  *output = AggregatableReportRequestIDDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetApiIdentifierDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->api_identifier.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetApiVersionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->api_version.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetReportUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->report_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetContributionsDataView(
    mojo::ArrayDataView<AggregatableHistogramContributionDataView>* output) {
  auto pointer = data_->contributions.Get();
  *output = mojo::ArrayDataView<AggregatableHistogramContributionDataView>(pointer, message_);
}
inline void WebUIAggregatableReportDataView::GetReportBodyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->report_body.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // private_aggregation_internals::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) TraceFormatTraits<::private_aggregation_internals::mojom::ReportStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::private_aggregation_internals::mojom::ReportStatus value);
};

} // namespace perfetto

#endif  // CONTENT_BROWSER_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_INTERNALS_MOJOM_SHARED_H_