// content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "content/services/auction_worklet/public/mojom/trusted_signals_cache.mojom-params-data.h"
namespace auction_worklet {
namespace mojom {

NOINLINE static const char* TrustedSignalsCompressionSchemeToStringHelper(TrustedSignalsCompressionScheme value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TrustedSignalsCompressionScheme::kNone:
      return "kNone";
    case TrustedSignalsCompressionScheme::kGzip:
      return "kGzip";
    case TrustedSignalsCompressionScheme::kBrotli:
      return "kBrotli";
    default:
      return nullptr;
  }
}

std::string TrustedSignalsCompressionSchemeToString(TrustedSignalsCompressionScheme value) {
  const char *str = TrustedSignalsCompressionSchemeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TrustedSignalsCompressionScheme value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TrustedSignalsCompressionScheme value) {
  return os << TrustedSignalsCompressionSchemeToString(value);
}

namespace internal {


// static
bool TrustedSignalsCacheKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedSignalsCacheKey_Data* object =
      static_cast<const TrustedSignalsCacheKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->compression_group_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->compression_group_token, validation_context))
    return false;

  return true;
}

TrustedSignalsCacheKey_Data::TrustedSignalsCacheKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedSignalsCacheClient_OnSuccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedSignalsCacheClient_OnSuccess_Params_Data* object =
      static_cast<const TrustedSignalsCacheClient_OnSuccess_Params_Data*>(data);


  if (!::auction_worklet::mojom::internal::TrustedSignalsCompressionScheme_Data
        ::Validate(object->compression_scheme, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->compression_group_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->compression_group_data, validation_context))
    return false;

  return true;
}

TrustedSignalsCacheClient_OnSuccess_Params_Data::TrustedSignalsCacheClient_OnSuccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedSignalsCacheClient_OnError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedSignalsCacheClient_OnError_Params_Data* object =
      static_cast<const TrustedSignalsCacheClient_OnError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->error_message, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& error_message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_message, validation_context,
                                         &error_message_validate_params)) {
    return false;
  }

  return true;
}

TrustedSignalsCacheClient_OnError_Params_Data::TrustedSignalsCacheClient_OnError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedSignalsCache_GetTrustedSignals_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedSignalsCache_GetTrustedSignals_Params_Data* object =
      static_cast<const TrustedSignalsCache_GetTrustedSignals_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->compression_group_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->compression_group_token, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TrustedSignalsCache_GetTrustedSignals_Params_Data::TrustedSignalsCache_GetTrustedSignals_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace auction_worklet

namespace perfetto {

// static
void TraceFormatTraits<::auction_worklet::mojom::TrustedSignalsCompressionScheme>::WriteIntoTrace(
   perfetto::TracedValue context, ::auction_worklet::mojom::TrustedSignalsCompressionScheme value) {
  return std::move(context).WriteString(::auction_worklet::mojom::TrustedSignalsCompressionSchemeToString(value));
}

} // namespace perfetto