// extensions/common/api/mime_handler.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_SHARED_H_
#define EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "extensions/common/api/mime_handler.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace extensions::mime_handler {
class StreamInfoDataView;

class PdfPluginAttributesDataView;



}  // extensions::mime_handler

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::extensions::mime_handler::StreamInfoDataView> {
  using Data = ::extensions::mime_handler::internal::StreamInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::extensions::mime_handler::PdfPluginAttributesDataView> {
  using Data = ::extensions::mime_handler::internal::PdfPluginAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace extensions::mime_handler {
// Interface base classes. They are used for type safety check.
class MimeHandlerServiceInterfaceBase {};

using MimeHandlerServicePtrDataView =
    mojo::InterfacePtrDataView<MimeHandlerServiceInterfaceBase>;
using MimeHandlerServiceRequestDataView =
    mojo::InterfaceRequestDataView<MimeHandlerServiceInterfaceBase>;
using MimeHandlerServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MimeHandlerServiceInterfaceBase>;
using MimeHandlerServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MimeHandlerServiceInterfaceBase>;
class BeforeUnloadControlInterfaceBase {};

using BeforeUnloadControlPtrDataView =
    mojo::InterfacePtrDataView<BeforeUnloadControlInterfaceBase>;
using BeforeUnloadControlRequestDataView =
    mojo::InterfaceRequestDataView<BeforeUnloadControlInterfaceBase>;
using BeforeUnloadControlAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<BeforeUnloadControlInterfaceBase>;
using BeforeUnloadControlAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<BeforeUnloadControlInterfaceBase>;


class StreamInfoDataView {
 public:
  StreamInfoDataView() = default;

  StreamInfoDataView(
      internal::StreamInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMimeTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMimeType(UserType* output) {
    
    auto* pointer = data_->mime_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalUrl(UserType* output) {
    
    auto* pointer = data_->original_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStreamUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamUrl(UserType* output) {
    
    auto* pointer = data_->stream_url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t tab_id() const {
    return data_->tab_id;
  }
  inline void GetResponseHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponseHeaders(UserType* output) {
    
    auto* pointer = data_->response_headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool embedded() const {
    return data_->embedded;
  }
 private:
  internal::StreamInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PdfPluginAttributesDataView {
 public:
  PdfPluginAttributesDataView() = default;

  PdfPluginAttributesDataView(
      internal::PdfPluginAttributes_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  double background_color() const {
    return data_->background_color;
  }
  bool allow_javascript() const {
    return data_->allow_javascript;
  }
 private:
  internal::PdfPluginAttributes_Data* data_ = nullptr;
};


}  // extensions::mime_handler

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mime_handler::StreamInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mime_handler::StreamInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mime_handler::internal::StreamInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::mime_type(input)) in_mime_type = Traits::mime_type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mime_type)::BaseType> mime_type_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_mime_type, mime_type_fragment);
    fragment->mime_type.Set(
        mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->mime_type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null mime_type in StreamInfo struct");
    decltype(Traits::original_url(input)) in_original_url = Traits::original_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->original_url)::BaseType> original_url_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_original_url, original_url_fragment);
    fragment->original_url.Set(
        original_url_fragment.is_null() ? nullptr : original_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->original_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null original_url in StreamInfo struct");
    decltype(Traits::stream_url(input)) in_stream_url = Traits::stream_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stream_url)::BaseType> stream_url_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_stream_url, stream_url_fragment);
    fragment->stream_url.Set(
        stream_url_fragment.is_null() ? nullptr : stream_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->stream_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null stream_url in StreamInfo struct");
    fragment->tab_id = Traits::tab_id(input);
    decltype(Traits::response_headers(input)) in_response_headers = Traits::response_headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->response_headers)::BaseType>
        response_headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& response_headers_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        in_response_headers, response_headers_fragment, &response_headers_validate_params);
    fragment->response_headers.Set(
        response_headers_fragment.is_null() ? nullptr : response_headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->response_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_headers in StreamInfo struct");
    fragment->embedded = Traits::embedded(input);
  }

  static bool Deserialize(::extensions::mime_handler::internal::StreamInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mime_handler::StreamInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::extensions::mime_handler::PdfPluginAttributesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::extensions::mime_handler::PdfPluginAttributesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::extensions::mime_handler::internal::PdfPluginAttributes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->background_color = Traits::background_color(input);
    fragment->allow_javascript = Traits::allow_javascript(input);
  }

  static bool Deserialize(::extensions::mime_handler::internal::PdfPluginAttributes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::extensions::mime_handler::PdfPluginAttributesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace extensions::mime_handler {

inline void StreamInfoDataView::GetMimeTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->mime_type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StreamInfoDataView::GetOriginalUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->original_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StreamInfoDataView::GetStreamUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->stream_url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void StreamInfoDataView::GetResponseHeadersDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->response_headers.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}





}  // extensions::mime_handler

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // EXTENSIONS_COMMON_API_MIME_HANDLER_MOJOM_SHARED_H_