// services/device/public/mojom/power_monitor.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_POWER_MONITOR_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_POWER_MONITOR_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/power_monitor.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/power_monitor.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/power_monitor.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/battery_power_status.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace device::mojom::blink {

class PowerMonitorProxy;

template <typename ImplRefTraits>
class PowerMonitorStub;

class PowerMonitorRequestValidator;


class BLINK_PLATFORM_EXPORT PowerMonitor
    : public PowerMonitorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PowerMonitorInterfaceBase;
  using Proxy_ = PowerMonitorProxy;

  template <typename ImplRefTraits>
  using Stub_ = PowerMonitorStub<ImplRefTraits>;

  using RequestValidator_ = PowerMonitorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddClientMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddClient_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PowerMonitor() = default;

  
  virtual void AddClient(::mojo::PendingRemote<PowerMonitorClient> client) = 0;
};

class PowerMonitorClientProxy;

template <typename ImplRefTraits>
class PowerMonitorClientStub;

class PowerMonitorClientRequestValidator;


class BLINK_PLATFORM_EXPORT PowerMonitorClient
    : public PowerMonitorClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PowerMonitorClientInterfaceBase;
  using Proxy_ = PowerMonitorClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = PowerMonitorClientStub<ImplRefTraits>;

  using RequestValidator_ = PowerMonitorClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kPowerStateChangeMinVersion = 0,
    kSuspendMinVersion = 0,
    kResumeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct PowerStateChange_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Suspend_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PowerMonitorClient() = default;

  
  virtual void PowerStateChange(::mojo_base::mojom::blink::BatteryPowerStatus battery_power_status) = 0;

  
  virtual void Suspend() = 0;

  
  virtual void Resume() = 0;
};



class BLINK_PLATFORM_EXPORT PowerMonitorProxy
    : public PowerMonitor {
 public:
  using InterfaceType = PowerMonitor;

  explicit PowerMonitorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddClient(::mojo::PendingRemote<PowerMonitorClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT PowerMonitorClientProxy
    : public PowerMonitorClient {
 public:
  using InterfaceType = PowerMonitorClient;

  explicit PowerMonitorClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void PowerStateChange(::mojo_base::mojom::blink::BatteryPowerStatus battery_power_status) final;
  
  void Suspend() final;
  
  void Resume() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT PowerMonitorStubDispatch {
 public:
  static bool Accept(PowerMonitor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PowerMonitor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PowerMonitor>>
class PowerMonitorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PowerMonitorStub() = default;
  ~PowerMonitorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PowerMonitorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PowerMonitorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT PowerMonitorClientStubDispatch {
 public:
  static bool Accept(PowerMonitorClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PowerMonitorClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PowerMonitorClient>>
class PowerMonitorClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PowerMonitorClientStub() = default;
  ~PowerMonitorClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PowerMonitorClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PowerMonitorClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT PowerMonitorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT PowerMonitorClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // device::mojom::blink

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_POWER_MONITOR_MOJOM_BLINK_H_