// services/network/public/mojom/load_timing_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/load_timing_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"







namespace network::mojom {
class LoadTimingInfoConnectTimingDataView;

class LoadTimingInfoDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::LoadTimingInfoConnectTimingDataView> {
  using Data = ::network::mojom::internal::LoadTimingInfoConnectTiming_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::LoadTimingInfoDataView> {
  using Data = ::network::mojom::internal::LoadTimingInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


class LoadTimingInfoConnectTimingDataView {
 public:
  LoadTimingInfoConnectTimingDataView() = default;

  LoadTimingInfoConnectTimingDataView(
      internal::LoadTimingInfoConnectTiming_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDomainLookupStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainLookupStart(UserType* output) {
    
    auto* pointer = data_->domain_lookup_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetDomainLookupEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDomainLookupEnd(UserType* output) {
    
    auto* pointer = data_->domain_lookup_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetConnectStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectStart(UserType* output) {
    
    auto* pointer = data_->connect_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetConnectEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectEnd(UserType* output) {
    
    auto* pointer = data_->connect_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetSslStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSslStart(UserType* output) {
    
    auto* pointer = data_->ssl_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetSslEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSslEnd(UserType* output) {
    
    auto* pointer = data_->ssl_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::LoadTimingInfoConnectTiming_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class LoadTimingInfoDataView {
 public:
  LoadTimingInfoDataView() = default;

  LoadTimingInfoDataView(
      internal::LoadTimingInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool socket_reused() const {
    return data_->socket_reused;
  }
  uint32_t socket_log_id() const {
    return data_->socket_log_id;
  }
  inline void GetRequestStartTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestStartTime(UserType* output) {
    
    auto* pointer = data_->request_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetRequestStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestStart(UserType* output) {
    
    auto* pointer = data_->request_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetProxyResolveStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyResolveStart(UserType* output) {
    
    auto* pointer = data_->proxy_resolve_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetProxyResolveEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProxyResolveEnd(UserType* output) {
    
    auto* pointer = data_->proxy_resolve_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetConnectTimingDataView(
      LoadTimingInfoConnectTimingDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnectTiming(UserType* output) {
    
    auto* pointer = data_->connect_timing.Get();
    return mojo::internal::Deserialize<::network::mojom::LoadTimingInfoConnectTimingDataView>(
        pointer, output, message_);
  }
  inline void GetSendStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSendStart(UserType* output) {
    
    auto* pointer = data_->send_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetSendEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSendEnd(UserType* output) {
    
    auto* pointer = data_->send_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetReceiveHeadersStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceiveHeadersStart(UserType* output) {
    
    auto* pointer = data_->receive_headers_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetReceiveHeadersEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceiveHeadersEnd(UserType* output) {
    
    auto* pointer = data_->receive_headers_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetReceiveNonInformationalHeadersStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReceiveNonInformationalHeadersStart(UserType* output) {
    
    auto* pointer = data_->receive_non_informational_headers_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetFirstEarlyHintsTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFirstEarlyHintsTime(UserType* output) {
    
    auto* pointer = data_->first_early_hints_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetPushStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPushStart(UserType* output) {
    
    auto* pointer = data_->push_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetPushEndDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPushEnd(UserType* output) {
    
    auto* pointer = data_->push_end.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerStartTime(UserType* output) {
    
    auto* pointer = data_->service_worker_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerReadyTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerReadyTime(UserType* output) {
    
    auto* pointer = data_->service_worker_ready_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerFetchStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerFetchStart(UserType* output) {
    
    auto* pointer = data_->service_worker_fetch_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerRespondWithSettledDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerRespondWithSettled(UserType* output) {
    
    auto* pointer = data_->service_worker_respond_with_settled.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerRouterEvaluationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerRouterEvaluationStart(UserType* output) {
    
    auto* pointer = data_->service_worker_router_evaluation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
  inline void GetServiceWorkerCacheLookupStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadServiceWorkerCacheLookupStart(UserType* output) {
    
    auto* pointer = data_->service_worker_cache_lookup_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, message_);
  }
 private:
  internal::LoadTimingInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LoadTimingInfoConnectTimingDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::LoadTimingInfoConnectTimingDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::LoadTimingInfoConnectTiming_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::domain_lookup_start(input)) in_domain_lookup_start = Traits::domain_lookup_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain_lookup_start)::BaseType> domain_lookup_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_domain_lookup_start, domain_lookup_start_fragment);
    fragment->domain_lookup_start.Set(
        domain_lookup_start_fragment.is_null() ? nullptr : domain_lookup_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->domain_lookup_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain_lookup_start in LoadTimingInfoConnectTiming struct");
    decltype(Traits::domain_lookup_end(input)) in_domain_lookup_end = Traits::domain_lookup_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->domain_lookup_end)::BaseType> domain_lookup_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_domain_lookup_end, domain_lookup_end_fragment);
    fragment->domain_lookup_end.Set(
        domain_lookup_end_fragment.is_null() ? nullptr : domain_lookup_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->domain_lookup_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain_lookup_end in LoadTimingInfoConnectTiming struct");
    decltype(Traits::connect_start(input)) in_connect_start = Traits::connect_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->connect_start)::BaseType> connect_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_connect_start, connect_start_fragment);
    fragment->connect_start.Set(
        connect_start_fragment.is_null() ? nullptr : connect_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->connect_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connect_start in LoadTimingInfoConnectTiming struct");
    decltype(Traits::connect_end(input)) in_connect_end = Traits::connect_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->connect_end)::BaseType> connect_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_connect_end, connect_end_fragment);
    fragment->connect_end.Set(
        connect_end_fragment.is_null() ? nullptr : connect_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->connect_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connect_end in LoadTimingInfoConnectTiming struct");
    decltype(Traits::ssl_start(input)) in_ssl_start = Traits::ssl_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ssl_start)::BaseType> ssl_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_ssl_start, ssl_start_fragment);
    fragment->ssl_start.Set(
        ssl_start_fragment.is_null() ? nullptr : ssl_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ssl_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ssl_start in LoadTimingInfoConnectTiming struct");
    decltype(Traits::ssl_end(input)) in_ssl_end = Traits::ssl_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ssl_end)::BaseType> ssl_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_ssl_end, ssl_end_fragment);
    fragment->ssl_end.Set(
        ssl_end_fragment.is_null() ? nullptr : ssl_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->ssl_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ssl_end in LoadTimingInfoConnectTiming struct");
  }

  static bool Deserialize(::network::mojom::internal::LoadTimingInfoConnectTiming_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::LoadTimingInfoConnectTimingDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LoadTimingInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::LoadTimingInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::LoadTimingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->socket_reused = Traits::socket_reused(input);
    fragment->socket_log_id = Traits::socket_log_id(input);
    decltype(Traits::request_start_time(input)) in_request_start_time = Traits::request_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_start_time)::BaseType> request_start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_request_start_time, request_start_time_fragment);
    fragment->request_start_time.Set(
        request_start_time_fragment.is_null() ? nullptr : request_start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->request_start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_start_time in LoadTimingInfo struct");
    decltype(Traits::request_start(input)) in_request_start = Traits::request_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_start)::BaseType> request_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_request_start, request_start_fragment);
    fragment->request_start.Set(
        request_start_fragment.is_null() ? nullptr : request_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->request_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null request_start in LoadTimingInfo struct");
    decltype(Traits::proxy_resolve_start(input)) in_proxy_resolve_start = Traits::proxy_resolve_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_resolve_start)::BaseType> proxy_resolve_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_proxy_resolve_start, proxy_resolve_start_fragment);
    fragment->proxy_resolve_start.Set(
        proxy_resolve_start_fragment.is_null() ? nullptr : proxy_resolve_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->proxy_resolve_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_resolve_start in LoadTimingInfo struct");
    decltype(Traits::proxy_resolve_end(input)) in_proxy_resolve_end = Traits::proxy_resolve_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->proxy_resolve_end)::BaseType> proxy_resolve_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_proxy_resolve_end, proxy_resolve_end_fragment);
    fragment->proxy_resolve_end.Set(
        proxy_resolve_end_fragment.is_null() ? nullptr : proxy_resolve_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->proxy_resolve_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null proxy_resolve_end in LoadTimingInfo struct");
    decltype(Traits::connect_timing(input)) in_connect_timing = Traits::connect_timing(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->connect_timing)::BaseType> connect_timing_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::LoadTimingInfoConnectTimingDataView>(
        in_connect_timing, connect_timing_fragment);
    fragment->connect_timing.Set(
        connect_timing_fragment.is_null() ? nullptr : connect_timing_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->connect_timing.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connect_timing in LoadTimingInfo struct");
    decltype(Traits::send_start(input)) in_send_start = Traits::send_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->send_start)::BaseType> send_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_send_start, send_start_fragment);
    fragment->send_start.Set(
        send_start_fragment.is_null() ? nullptr : send_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->send_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null send_start in LoadTimingInfo struct");
    decltype(Traits::send_end(input)) in_send_end = Traits::send_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->send_end)::BaseType> send_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_send_end, send_end_fragment);
    fragment->send_end.Set(
        send_end_fragment.is_null() ? nullptr : send_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->send_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null send_end in LoadTimingInfo struct");
    decltype(Traits::receive_headers_start(input)) in_receive_headers_start = Traits::receive_headers_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->receive_headers_start)::BaseType> receive_headers_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_receive_headers_start, receive_headers_start_fragment);
    fragment->receive_headers_start.Set(
        receive_headers_start_fragment.is_null() ? nullptr : receive_headers_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->receive_headers_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null receive_headers_start in LoadTimingInfo struct");
    decltype(Traits::receive_headers_end(input)) in_receive_headers_end = Traits::receive_headers_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->receive_headers_end)::BaseType> receive_headers_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_receive_headers_end, receive_headers_end_fragment);
    fragment->receive_headers_end.Set(
        receive_headers_end_fragment.is_null() ? nullptr : receive_headers_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->receive_headers_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null receive_headers_end in LoadTimingInfo struct");
    decltype(Traits::receive_non_informational_headers_start(input)) in_receive_non_informational_headers_start = Traits::receive_non_informational_headers_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->receive_non_informational_headers_start)::BaseType> receive_non_informational_headers_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_receive_non_informational_headers_start, receive_non_informational_headers_start_fragment);
    fragment->receive_non_informational_headers_start.Set(
        receive_non_informational_headers_start_fragment.is_null() ? nullptr : receive_non_informational_headers_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->receive_non_informational_headers_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null receive_non_informational_headers_start in LoadTimingInfo struct");
    decltype(Traits::first_early_hints_time(input)) in_first_early_hints_time = Traits::first_early_hints_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->first_early_hints_time)::BaseType> first_early_hints_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_first_early_hints_time, first_early_hints_time_fragment);
    fragment->first_early_hints_time.Set(
        first_early_hints_time_fragment.is_null() ? nullptr : first_early_hints_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->first_early_hints_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null first_early_hints_time in LoadTimingInfo struct");
    decltype(Traits::push_start(input)) in_push_start = Traits::push_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->push_start)::BaseType> push_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_push_start, push_start_fragment);
    fragment->push_start.Set(
        push_start_fragment.is_null() ? nullptr : push_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->push_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null push_start in LoadTimingInfo struct");
    decltype(Traits::push_end(input)) in_push_end = Traits::push_end(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->push_end)::BaseType> push_end_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_push_end, push_end_fragment);
    fragment->push_end.Set(
        push_end_fragment.is_null() ? nullptr : push_end_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->push_end.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null push_end in LoadTimingInfo struct");
    decltype(Traits::service_worker_start_time(input)) in_service_worker_start_time = Traits::service_worker_start_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_start_time)::BaseType> service_worker_start_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_service_worker_start_time, service_worker_start_time_fragment);
    fragment->service_worker_start_time.Set(
        service_worker_start_time_fragment.is_null() ? nullptr : service_worker_start_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_worker_start_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_worker_start_time in LoadTimingInfo struct");
    decltype(Traits::service_worker_ready_time(input)) in_service_worker_ready_time = Traits::service_worker_ready_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_ready_time)::BaseType> service_worker_ready_time_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_service_worker_ready_time, service_worker_ready_time_fragment);
    fragment->service_worker_ready_time.Set(
        service_worker_ready_time_fragment.is_null() ? nullptr : service_worker_ready_time_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_worker_ready_time.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_worker_ready_time in LoadTimingInfo struct");
    decltype(Traits::service_worker_fetch_start(input)) in_service_worker_fetch_start = Traits::service_worker_fetch_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_fetch_start)::BaseType> service_worker_fetch_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_service_worker_fetch_start, service_worker_fetch_start_fragment);
    fragment->service_worker_fetch_start.Set(
        service_worker_fetch_start_fragment.is_null() ? nullptr : service_worker_fetch_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_worker_fetch_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_worker_fetch_start in LoadTimingInfo struct");
    decltype(Traits::service_worker_respond_with_settled(input)) in_service_worker_respond_with_settled = Traits::service_worker_respond_with_settled(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_respond_with_settled)::BaseType> service_worker_respond_with_settled_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_service_worker_respond_with_settled, service_worker_respond_with_settled_fragment);
    fragment->service_worker_respond_with_settled.Set(
        service_worker_respond_with_settled_fragment.is_null() ? nullptr : service_worker_respond_with_settled_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_worker_respond_with_settled.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_worker_respond_with_settled in LoadTimingInfo struct");
    decltype(Traits::service_worker_router_evaluation_start(input)) in_service_worker_router_evaluation_start = Traits::service_worker_router_evaluation_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_router_evaluation_start)::BaseType> service_worker_router_evaluation_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_service_worker_router_evaluation_start, service_worker_router_evaluation_start_fragment);
    fragment->service_worker_router_evaluation_start.Set(
        service_worker_router_evaluation_start_fragment.is_null() ? nullptr : service_worker_router_evaluation_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_worker_router_evaluation_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_worker_router_evaluation_start in LoadTimingInfo struct");
    decltype(Traits::service_worker_cache_lookup_start(input)) in_service_worker_cache_lookup_start = Traits::service_worker_cache_lookup_start(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->service_worker_cache_lookup_start)::BaseType> service_worker_cache_lookup_start_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_service_worker_cache_lookup_start, service_worker_cache_lookup_start_fragment);
    fragment->service_worker_cache_lookup_start.Set(
        service_worker_cache_lookup_start_fragment.is_null() ? nullptr : service_worker_cache_lookup_start_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->service_worker_cache_lookup_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null service_worker_cache_lookup_start in LoadTimingInfo struct");
  }

  static bool Deserialize(::network::mojom::internal::LoadTimingInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::LoadTimingInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void LoadTimingInfoConnectTimingDataView::GetDomainLookupStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->domain_lookup_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoConnectTimingDataView::GetDomainLookupEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->domain_lookup_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoConnectTimingDataView::GetConnectStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->connect_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoConnectTimingDataView::GetConnectEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->connect_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoConnectTimingDataView::GetSslStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->ssl_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoConnectTimingDataView::GetSslEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->ssl_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void LoadTimingInfoDataView::GetRequestStartTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->request_start_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetRequestStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->request_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetProxyResolveStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->proxy_resolve_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetProxyResolveEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->proxy_resolve_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetConnectTimingDataView(
    LoadTimingInfoConnectTimingDataView* output) {
  auto pointer = data_->connect_timing.Get();
  *output = LoadTimingInfoConnectTimingDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetSendStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->send_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetSendEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->send_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetReceiveHeadersStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->receive_headers_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetReceiveHeadersEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->receive_headers_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetReceiveNonInformationalHeadersStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->receive_non_informational_headers_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetFirstEarlyHintsTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->first_early_hints_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetPushStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->push_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetPushEndDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->push_end.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetServiceWorkerStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->service_worker_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetServiceWorkerReadyTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->service_worker_ready_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetServiceWorkerFetchStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->service_worker_fetch_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetServiceWorkerRespondWithSettledDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->service_worker_respond_with_settled.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetServiceWorkerRouterEvaluationStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->service_worker_router_evaluation_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}
inline void LoadTimingInfoDataView::GetServiceWorkerCacheLookupStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->service_worker_cache_lookup_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INFO_MOJOM_SHARED_H_