// services/network/public/mojom/network_interface_change_listener.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/network_interface_change_listener.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_interface_change_listener.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/network_interface_change_listener.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/network_interface_change_listener_mojom_traits.h"




namespace network::mojom {

class NetworkInterfaceChangeListenerProxy;

template <typename ImplRefTraits>
class NetworkInterfaceChangeListenerStub;

class NetworkInterfaceChangeListenerRequestValidator;


class NetworkInterfaceChangeListener
    : public NetworkInterfaceChangeListenerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NetworkInterfaceChangeListenerInterfaceBase;
  using Proxy_ = NetworkInterfaceChangeListenerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkInterfaceChangeListenerStub<ImplRefTraits>;

  using RequestValidator_ = NetworkInterfaceChangeListenerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNetworkInterfacesChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNetworkInterfacesChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NetworkInterfaceChangeListener() = default;

  
  virtual void OnNetworkInterfacesChanged(NetworkInterfaceChangeParamsPtr params) = 0;
};



class  NetworkInterfaceChangeListenerProxy
    : public NetworkInterfaceChangeListener {
 public:
  using InterfaceType = NetworkInterfaceChangeListener;

  explicit NetworkInterfaceChangeListenerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNetworkInterfacesChanged(NetworkInterfaceChangeParamsPtr params) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkInterfaceChangeListenerStubDispatch {
 public:
  static bool Accept(NetworkInterfaceChangeListener* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkInterfaceChangeListener* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkInterfaceChangeListener>>
class NetworkInterfaceChangeListenerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkInterfaceChangeListenerStub() = default;
  ~NetworkInterfaceChangeListenerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkInterfaceChangeListenerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkInterfaceChangeListenerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkInterfaceChangeListenerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};












class  IfAddrMsg {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IfAddrMsg, T>::value>;
  using DataView = IfAddrMsgDataView;
  using Data_ = internal::IfAddrMsg_Data;

  template <typename... Args>
  static IfAddrMsgPtr New(Args&&... args) {
    return IfAddrMsgPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IfAddrMsgPtr From(const U& u) {
    return mojo::TypeConverter<IfAddrMsgPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IfAddrMsg>::Convert(*this);
  }


  IfAddrMsg();

  IfAddrMsg(
      uint8_t ifa_family,
      uint8_t ifa_prefixlen,
      uint8_t ifa_flags,
      uint8_t ifa_scope,
      uint32_t ifa_index);


  ~IfAddrMsg();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IfAddrMsgPtr>
  IfAddrMsgPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IfAddrMsg::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IfAddrMsg::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IfAddrMsg::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IfAddrMsg::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IfAddrMsg::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IfAddrMsg_UnserializedMessageContext<
            UserType, IfAddrMsg::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IfAddrMsg::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IfAddrMsg::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IfAddrMsg_UnserializedMessageContext<
            UserType, IfAddrMsg::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IfAddrMsg::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint8_t ifa_family;
  
  uint8_t ifa_prefixlen;
  
  uint8_t ifa_flags;
  
  uint8_t ifa_scope;
  
  uint32_t ifa_index;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IfAddrMsg::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IfAddrMsg::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IfAddrMsg::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IfAddrMsg::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  AddressMap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AddressMap, T>::value>;
  using DataView = AddressMapDataView;
  using Data_ = internal::AddressMap_Data;

  template <typename... Args>
  static AddressMapPtr New(Args&&... args) {
    return AddressMapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AddressMapPtr From(const U& u) {
    return mojo::TypeConverter<AddressMapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AddressMap>::Convert(*this);
  }


  AddressMap();

  explicit AddressMap(
      const base::flat_map<::net::IPAddress, struct ifaddrmsg>& address_map);


  ~AddressMap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AddressMapPtr>
  AddressMapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AddressMap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AddressMap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AddressMap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AddressMap::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AddressMap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AddressMap_UnserializedMessageContext<
            UserType, AddressMap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AddressMap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AddressMap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AddressMap_UnserializedMessageContext<
            UserType, AddressMap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AddressMap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<::net::IPAddress, struct ifaddrmsg> address_map;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AddressMap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AddressMap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AddressMap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AddressMap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  OnlineLinks {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<OnlineLinks, T>::value>;
  using DataView = OnlineLinksDataView;
  using Data_ = internal::OnlineLinks_Data;

  template <typename... Args>
  static OnlineLinksPtr New(Args&&... args) {
    return OnlineLinksPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static OnlineLinksPtr From(const U& u) {
    return mojo::TypeConverter<OnlineLinksPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, OnlineLinks>::Convert(*this);
  }


  OnlineLinks();

  explicit OnlineLinks(
      std::vector<int32_t> online_links);


  ~OnlineLinks();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = OnlineLinksPtr>
  OnlineLinksPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, OnlineLinks::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, OnlineLinks::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, OnlineLinks::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        OnlineLinks::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        OnlineLinks::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::OnlineLinks_UnserializedMessageContext<
            UserType, OnlineLinks::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<OnlineLinks::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return OnlineLinks::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::OnlineLinks_UnserializedMessageContext<
            UserType, OnlineLinks::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<OnlineLinks::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<int32_t> online_links;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, OnlineLinks::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, OnlineLinks::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, OnlineLinks::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, OnlineLinks::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  InitialAddressMap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<InitialAddressMap, T>::value>;
  using DataView = InitialAddressMapDataView;
  using Data_ = internal::InitialAddressMap_Data;

  template <typename... Args>
  static InitialAddressMapPtr New(Args&&... args) {
    return InitialAddressMapPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static InitialAddressMapPtr From(const U& u) {
    return mojo::TypeConverter<InitialAddressMapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, InitialAddressMap>::Convert(*this);
  }


  InitialAddressMap();

  InitialAddressMap(
      const ::net::AddressMapOwnerLinux::AddressMap& address_map,
      const ::std::unordered_set<int>& online_links);


  ~InitialAddressMap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = InitialAddressMapPtr>
  InitialAddressMapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, InitialAddressMap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, InitialAddressMap::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, InitialAddressMap::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        InitialAddressMap::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        InitialAddressMap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::InitialAddressMap_UnserializedMessageContext<
            UserType, InitialAddressMap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<InitialAddressMap::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return InitialAddressMap::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::InitialAddressMap_UnserializedMessageContext<
            UserType, InitialAddressMap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<InitialAddressMap::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::AddressMapOwnerLinux::AddressMap address_map;
  
  ::std::unordered_set<int> online_links;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, InitialAddressMap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, InitialAddressMap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, InitialAddressMap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, InitialAddressMap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NetworkInterfaceChangeParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkInterfaceChangeParams, T>::value>;
  using DataView = NetworkInterfaceChangeParamsDataView;
  using Data_ = internal::NetworkInterfaceChangeParams_Data;

  template <typename... Args>
  static NetworkInterfaceChangeParamsPtr New(Args&&... args) {
    return NetworkInterfaceChangeParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkInterfaceChangeParamsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkInterfaceChangeParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkInterfaceChangeParams>::Convert(*this);
  }


  NetworkInterfaceChangeParams();

  NetworkInterfaceChangeParams(
      const base::flat_map<::net::IPAddress, std::optional<struct ifaddrmsg>>& address_map,
      const base::flat_map<int32_t, bool>& online_links);


  ~NetworkInterfaceChangeParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkInterfaceChangeParamsPtr>
  NetworkInterfaceChangeParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkInterfaceChangeParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkInterfaceChangeParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkInterfaceChangeParams_UnserializedMessageContext<
            UserType, NetworkInterfaceChangeParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkInterfaceChangeParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkInterfaceChangeParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkInterfaceChangeParams_UnserializedMessageContext<
            UserType, NetworkInterfaceChangeParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkInterfaceChangeParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  base::flat_map<::net::IPAddress, std::optional<struct ifaddrmsg>> address_map;
  
  base::flat_map<int32_t, bool> online_links;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IfAddrMsgPtr IfAddrMsg::Clone() const {
  return New(
      mojo::Clone(ifa_family),
      mojo::Clone(ifa_prefixlen),
      mojo::Clone(ifa_flags),
      mojo::Clone(ifa_scope),
      mojo::Clone(ifa_index)
  );
}

template <typename T, IfAddrMsg::EnableIfSame<T>*>
bool IfAddrMsg::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ifa_family, other_struct.ifa_family))
    return false;
  if (!mojo::Equals(this->ifa_prefixlen, other_struct.ifa_prefixlen))
    return false;
  if (!mojo::Equals(this->ifa_flags, other_struct.ifa_flags))
    return false;
  if (!mojo::Equals(this->ifa_scope, other_struct.ifa_scope))
    return false;
  if (!mojo::Equals(this->ifa_index, other_struct.ifa_index))
    return false;
  return true;
}

template <typename T, IfAddrMsg::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ifa_family < rhs.ifa_family)
    return true;
  if (rhs.ifa_family < lhs.ifa_family)
    return false;
  if (lhs.ifa_prefixlen < rhs.ifa_prefixlen)
    return true;
  if (rhs.ifa_prefixlen < lhs.ifa_prefixlen)
    return false;
  if (lhs.ifa_flags < rhs.ifa_flags)
    return true;
  if (rhs.ifa_flags < lhs.ifa_flags)
    return false;
  if (lhs.ifa_scope < rhs.ifa_scope)
    return true;
  if (rhs.ifa_scope < lhs.ifa_scope)
    return false;
  if (lhs.ifa_index < rhs.ifa_index)
    return true;
  if (rhs.ifa_index < lhs.ifa_index)
    return false;
  return false;
}
template <typename StructPtrType>
AddressMapPtr AddressMap::Clone() const {
  return New(
      mojo::Clone(address_map)
  );
}

template <typename T, AddressMap::EnableIfSame<T>*>
bool AddressMap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->address_map, other_struct.address_map))
    return false;
  return true;
}

template <typename T, AddressMap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.address_map < rhs.address_map)
    return true;
  if (rhs.address_map < lhs.address_map)
    return false;
  return false;
}
template <typename StructPtrType>
OnlineLinksPtr OnlineLinks::Clone() const {
  return New(
      mojo::Clone(online_links)
  );
}

template <typename T, OnlineLinks::EnableIfSame<T>*>
bool OnlineLinks::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->online_links, other_struct.online_links))
    return false;
  return true;
}

template <typename T, OnlineLinks::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.online_links < rhs.online_links)
    return true;
  if (rhs.online_links < lhs.online_links)
    return false;
  return false;
}
template <typename StructPtrType>
InitialAddressMapPtr InitialAddressMap::Clone() const {
  return New(
      mojo::Clone(address_map),
      mojo::Clone(online_links)
  );
}

template <typename T, InitialAddressMap::EnableIfSame<T>*>
bool InitialAddressMap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->address_map, other_struct.address_map))
    return false;
  if (!mojo::Equals(this->online_links, other_struct.online_links))
    return false;
  return true;
}

template <typename T, InitialAddressMap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.address_map < rhs.address_map)
    return true;
  if (rhs.address_map < lhs.address_map)
    return false;
  if (lhs.online_links < rhs.online_links)
    return true;
  if (rhs.online_links < lhs.online_links)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkInterfaceChangeParamsPtr NetworkInterfaceChangeParams::Clone() const {
  return New(
      mojo::Clone(address_map),
      mojo::Clone(online_links)
  );
}

template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>*>
bool NetworkInterfaceChangeParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->address_map, other_struct.address_map))
    return false;
  if (!mojo::Equals(this->online_links, other_struct.online_links))
    return false;
  return true;
}

template <typename T, NetworkInterfaceChangeParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.address_map < rhs.address_map)
    return true;
  if (rhs.address_map < lhs.address_map)
    return false;
  if (lhs.online_links < rhs.online_links)
    return true;
  if (rhs.online_links < lhs.online_links)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::IfAddrMsg::DataView,
                                         ::network::mojom::IfAddrMsgPtr> {
  static bool IsNull(const ::network::mojom::IfAddrMsgPtr& input) { return !input; }
  static void SetToNull(::network::mojom::IfAddrMsgPtr* output) { output->reset(); }

  static decltype(::network::mojom::IfAddrMsg::ifa_family) ifa_family(
      const ::network::mojom::IfAddrMsgPtr& input) {
    return input->ifa_family;
  }

  static decltype(::network::mojom::IfAddrMsg::ifa_prefixlen) ifa_prefixlen(
      const ::network::mojom::IfAddrMsgPtr& input) {
    return input->ifa_prefixlen;
  }

  static decltype(::network::mojom::IfAddrMsg::ifa_flags) ifa_flags(
      const ::network::mojom::IfAddrMsgPtr& input) {
    return input->ifa_flags;
  }

  static decltype(::network::mojom::IfAddrMsg::ifa_scope) ifa_scope(
      const ::network::mojom::IfAddrMsgPtr& input) {
    return input->ifa_scope;
  }

  static decltype(::network::mojom::IfAddrMsg::ifa_index) ifa_index(
      const ::network::mojom::IfAddrMsgPtr& input) {
    return input->ifa_index;
  }

  static bool Read(::network::mojom::IfAddrMsg::DataView input, ::network::mojom::IfAddrMsgPtr* output);
};


template <>
struct  StructTraits<::network::mojom::AddressMap::DataView,
                                         ::network::mojom::AddressMapPtr> {
  static bool IsNull(const ::network::mojom::AddressMapPtr& input) { return !input; }
  static void SetToNull(::network::mojom::AddressMapPtr* output) { output->reset(); }

  static const decltype(::network::mojom::AddressMap::address_map)& address_map(
      const ::network::mojom::AddressMapPtr& input) {
    return input->address_map;
  }

  static bool Read(::network::mojom::AddressMap::DataView input, ::network::mojom::AddressMapPtr* output);
};


template <>
struct  StructTraits<::network::mojom::OnlineLinks::DataView,
                                         ::network::mojom::OnlineLinksPtr> {
  static bool IsNull(const ::network::mojom::OnlineLinksPtr& input) { return !input; }
  static void SetToNull(::network::mojom::OnlineLinksPtr* output) { output->reset(); }

  static const decltype(::network::mojom::OnlineLinks::online_links)& online_links(
      const ::network::mojom::OnlineLinksPtr& input) {
    return input->online_links;
  }

  static bool Read(::network::mojom::OnlineLinks::DataView input, ::network::mojom::OnlineLinksPtr* output);
};


template <>
struct  StructTraits<::network::mojom::InitialAddressMap::DataView,
                                         ::network::mojom::InitialAddressMapPtr> {
  static bool IsNull(const ::network::mojom::InitialAddressMapPtr& input) { return !input; }
  static void SetToNull(::network::mojom::InitialAddressMapPtr* output) { output->reset(); }

  static const decltype(::network::mojom::InitialAddressMap::address_map)& address_map(
      const ::network::mojom::InitialAddressMapPtr& input) {
    return input->address_map;
  }

  static const decltype(::network::mojom::InitialAddressMap::online_links)& online_links(
      const ::network::mojom::InitialAddressMapPtr& input) {
    return input->online_links;
  }

  static bool Read(::network::mojom::InitialAddressMap::DataView input, ::network::mojom::InitialAddressMapPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkInterfaceChangeParams::DataView,
                                         ::network::mojom::NetworkInterfaceChangeParamsPtr> {
  static bool IsNull(const ::network::mojom::NetworkInterfaceChangeParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkInterfaceChangeParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::NetworkInterfaceChangeParams::address_map)& address_map(
      const ::network::mojom::NetworkInterfaceChangeParamsPtr& input) {
    return input->address_map;
  }

  static const decltype(::network::mojom::NetworkInterfaceChangeParams::online_links)& online_links(
      const ::network::mojom::NetworkInterfaceChangeParamsPtr& input) {
    return input->online_links;
  }

  static bool Read(::network::mojom::NetworkInterfaceChangeParams::DataView input, ::network::mojom::NetworkInterfaceChangeParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_INTERFACE_CHANGE_LISTENER_MOJOM_H_