// services/network/public/mojom/network_isolation_key.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_isolation_key.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_isolation_key.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {
// static
bool NetworkIsolationKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const NetworkIsolationKey_Data* object = static_cast<const NetworkIsolationKey_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case NetworkIsolationKey_Tag::kEmpty: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_empty, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_empty, validation_context))
        return false;
      return true;
    }
    case NetworkIsolationKey_Tag::kNonEmpty: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_non_empty, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_non_empty, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in NetworkIsolationKey");
      return false;
    }
  }
}


// static
bool EmptyNetworkIsolationKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EmptyNetworkIsolationKey_Data* object =
      static_cast<const EmptyNetworkIsolationKey_Data*>(data);

  return true;
}

EmptyNetworkIsolationKey_Data::EmptyNetworkIsolationKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NonEmptyNetworkIsolationKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NonEmptyNetworkIsolationKey_Data* object =
      static_cast<const NonEmptyNetworkIsolationKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_site, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_site, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_site, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_site, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->nonce, validation_context))
    return false;

  return true;
}

NonEmptyNetworkIsolationKey_Data::NonEmptyNetworkIsolationKey_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network