// services/network/public/mojom/sri_message_signature.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/sri_message_signature.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/sri_message_signature.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* SRIMessageSignatureErrorToStringHelper(SRIMessageSignatureError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SRIMessageSignatureError::kMissingSignatureHeader:
      return "kMissingSignatureHeader";
    case SRIMessageSignatureError::kMissingSignatureInputHeader:
      return "kMissingSignatureInputHeader";
    case SRIMessageSignatureError::kInvalidSignatureHeader:
      return "kInvalidSignatureHeader";
    case SRIMessageSignatureError::kInvalidSignatureInputHeader:
      return "kInvalidSignatureInputHeader";
    case SRIMessageSignatureError::kSignatureHeaderValueIsNotByteSequence:
      return "kSignatureHeaderValueIsNotByteSequence";
    case SRIMessageSignatureError::kSignatureHeaderValueIsParameterized:
      return "kSignatureHeaderValueIsParameterized";
    case SRIMessageSignatureError::kSignatureHeaderValueIsIncorrectLength:
      return "kSignatureHeaderValueIsIncorrectLength";
    case SRIMessageSignatureError::kSignatureInputHeaderMissingLabel:
      return "kSignatureInputHeaderMissingLabel";
    case SRIMessageSignatureError::kSignatureInputHeaderValueNotInnerList:
      return "kSignatureInputHeaderValueNotInnerList";
    case SRIMessageSignatureError::kSignatureInputHeaderValueMissingComponents:
      return "kSignatureInputHeaderValueMissingComponents";
    case SRIMessageSignatureError::kSignatureInputHeaderInvalidComponentType:
      return "kSignatureInputHeaderInvalidComponentType";
    case SRIMessageSignatureError::kSignatureInputHeaderInvalidComponentName:
      return "kSignatureInputHeaderInvalidComponentName";
    case SRIMessageSignatureError::kSignatureInputHeaderInvalidHeaderComponentParameter:
      return "kSignatureInputHeaderInvalidHeaderComponentParameter";
    case SRIMessageSignatureError::kSignatureInputHeaderInvalidDerivedComponentParameter:
      return "kSignatureInputHeaderInvalidDerivedComponentParameter";
    case SRIMessageSignatureError::kSignatureInputHeaderKeyIdLength:
      return "kSignatureInputHeaderKeyIdLength";
    case SRIMessageSignatureError::kSignatureInputHeaderInvalidParameter:
      return "kSignatureInputHeaderInvalidParameter";
    case SRIMessageSignatureError::kSignatureInputHeaderMissingRequiredParameters:
      return "kSignatureInputHeaderMissingRequiredParameters";
    case SRIMessageSignatureError::kValidationFailedSignatureExpired:
      return "kValidationFailedSignatureExpired";
    case SRIMessageSignatureError::kValidationFailedInvalidLength:
      return "kValidationFailedInvalidLength";
    case SRIMessageSignatureError::kValidationFailedSignatureMismatch:
      return "kValidationFailedSignatureMismatch";
    default:
      return nullptr;
  }
}

std::string SRIMessageSignatureErrorToString(SRIMessageSignatureError value) {
  const char *str = SRIMessageSignatureErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SRIMessageSignatureError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SRIMessageSignatureError value) {
  return os << SRIMessageSignatureErrorToString(value);
}

NOINLINE static const char* SRIMessageSignatureComponent_ParameterToStringHelper(SRIMessageSignatureComponent_Parameter value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SRIMessageSignatureComponent_Parameter::kRequest:
      return "kRequest";
    case SRIMessageSignatureComponent_Parameter::kStrictStructuredFieldSerialization:
      return "kStrictStructuredFieldSerialization";
    default:
      return nullptr;
  }
}

std::string SRIMessageSignatureComponent_ParameterToString(SRIMessageSignatureComponent_Parameter value) {
  const char *str = SRIMessageSignatureComponent_ParameterToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SRIMessageSignatureComponent_Parameter value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SRIMessageSignatureComponent_Parameter value) {
  return os << SRIMessageSignatureComponent_ParameterToString(value);
}

namespace internal {


// static
bool SRIMessageSignatureComponent_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SRIMessageSignatureComponent_Data* object =
      static_cast<const SRIMessageSignatureComponent_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& params_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SRIMessageSignatureComponent_Parameter_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->params, validation_context,
                                         &params_validate_params)) {
    return false;
  }

  return true;
}

SRIMessageSignatureComponent_Data::SRIMessageSignatureComponent_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SRIMessageSignature_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SRIMessageSignature_Data* object =
      static_cast<const SRIMessageSignature_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signature, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signature_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signature, validation_context,
                                         &signature_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->components, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& components_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->components, validation_context,
                                         &components_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& keyid_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->keyid, validation_context,
                                         &keyid_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& nonce_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nonce, validation_context,
                                         &nonce_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& tag_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tag, validation_context,
                                         &tag_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->serialized_signature_params, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& serialized_signature_params_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->serialized_signature_params, validation_context,
                                         &serialized_signature_params_validate_params)) {
    return false;
  }

  return true;
}

SRIMessageSignature_Data::SRIMessageSignature_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SRIMessageSignatures_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SRIMessageSignatures_Data* object =
      static_cast<const SRIMessageSignatures_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->signatures, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& signatures_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->signatures, validation_context,
                                         &signatures_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->errors, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& errors_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SRIMessageSignatureError_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->errors, validation_context,
                                         &errors_validate_params)) {
    return false;
  }

  return true;
}

SRIMessageSignatures_Data::SRIMessageSignatures_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SRIMessageSignatureError>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SRIMessageSignatureError value) {
  return std::move(context).WriteString(::network::mojom::SRIMessageSignatureErrorToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SRIMessageSignatureComponent_Parameter>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SRIMessageSignatureComponent_Parameter value) {
  return std::move(context).WriteString(::network::mojom::SRIMessageSignatureComponent_ParameterToString(value));
}

} // namespace perfetto